/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt;

import java.io.Serializable;

class ValueRange
implements Serializable {
    private static final long serialVersionUID = 1000L;
    protected String m_lowValueString = null;
    protected String m_highValueString = null;
    protected String m_description = null;

    public ValueRange(String value) {
        this(value, null, null);
    }

    public ValueRange(String lowValue, String highValue) {
        this(lowValue, highValue, null);
    }

    public ValueRange(String lowValue, String highValue, String description) {
        if (lowValue != null) {
            if (highValue == null || highValue.length() == 0) {
                this.m_lowValueString = lowValue;
            } else {
                int compare = lowValue.compareTo(highValue);
                if (compare < 0) {
                    this.m_lowValueString = lowValue;
                    this.m_highValueString = highValue;
                } else if (compare == 0) {
                    this.m_lowValueString = lowValue;
                } else {
                    this.m_lowValueString = highValue;
                    this.m_highValueString = lowValue;
                }
            }
        } else {
            this.m_lowValueString = highValue;
        }
        this.m_description = description;
    }

    public final String getDescription() {
        return this.m_description;
    }

    public final String getHighValue() {
        return this.m_highValueString;
    }

    public final String getLowValue() {
        return this.m_lowValueString;
    }

    public final boolean isInValueRange(String value) {
        if (value == null) {
            return false;
        }
        return this.m_highValueString == null ? value.equals(this.m_lowValueString) : value.compareTo(this.m_lowValueString) >= 0 && value.compareTo(this.m_highValueString) <= 0;
    }
}

