/*
 * Decompiled with CFR 0.152.
 */
package com.sap.conn.idoc.rt;

import com.sap.conn.idoc.IDocRepository;
import com.sap.conn.idoc.IDocSegmentMetaData;
import com.sap.conn.idoc.monitor.IDocRepositoryMonitor;
import com.sap.conn.idoc.rt.DefaultIDocSegmentMetaData;
import com.sap.conn.idoc.rt.util.ObjectList;
import java.util.Enumeration;
import java.util.Hashtable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicIDocRepository
implements IDocRepository {
    private static final long serialVersionUID = 3007L;
    protected String m_name = null;
    protected long m_lastAccessTimestamp;
    protected Hashtable<String, IDocSegmentMetaData> m_segmentMetaDataCache = new Hashtable(101);
    protected Hashtable<String, String> m_iDocCompoundTypesCache = null;
    protected transient BasicIDocRepositoryMonitor m_monitor = null;
    protected transient String[][] m_latestCachedIDocTypes = null;
    protected transient Object m_latestCachedIDocTypesSemaphore = new Object();
    protected static final String ROOT = "ROOT";
    protected static final String ROOT_SEGMENT_DESCRIPTION = "General root segment";

    protected BasicIDocRepository(String name) {
        this.m_name = name;
        this.m_lastAccessTimestamp = System.currentTimeMillis();
    }

    public void addSegmentMetaDataToCache(IDocSegmentMetaData segmentMetaData) {
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        if (segmentMetaData != null) {
            segmentMetaData.lock();
            if (this.m_segmentMetaDataCache.put(segmentMetaData.getKey(), segmentMetaData) == null) {
                this.m_latestCachedIDocTypes = null;
            }
        }
    }

    public void addSegmentMetaDataTreeToCache(IDocSegmentMetaData segmentMetaData) {
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        if (segmentMetaData != null) {
            segmentMetaData.lock();
            if (this.m_segmentMetaDataCache.put(segmentMetaData.getKey(), segmentMetaData) == null) {
                this.m_latestCachedIDocTypes = null;
            }
            int numChilds = segmentMetaData.getNumChildren();
            for (int i = 0; i < numChilds; ++i) {
                this.addSegmentMetaDataTreeToCache(segmentMetaData.getChild(i));
            }
        }
    }

    @Override
    public void clear() {
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        this.m_segmentMetaDataCache = new Hashtable(101);
        this.m_latestCachedIDocTypes = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String[][] getCachedIDocTypes() {
        String[][] iDocTypes = this.m_latestCachedIDocTypes;
        if (iDocTypes == null) {
            Object object = this.m_latestCachedIDocTypesSemaphore;
            synchronized (object) {
                iDocTypes = this.m_latestCachedIDocTypes;
                if (iDocTypes == null) {
                    String key;
                    int numKeys = this.m_segmentMetaDataCache.size();
                    ObjectList rootKeys = new ObjectList(numKeys);
                    Enumeration<String> keys = this.m_segmentMetaDataCache.keys();
                    while (keys.hasMoreElements()) {
                        key = keys.nextElement();
                        if (!key.endsWith(ROOT)) continue;
                        rootKeys.add(key);
                    }
                    iDocTypes = new String[rootKeys.size()][4];
                    for (int i = 0; i < rootKeys.size(); ++i) {
                        key = (String)rootKeys.get(i);
                        int endIndex = key.indexOf(124);
                        iDocTypes[i][0] = key.substring(0, endIndex);
                        int beginIndex = endIndex + 1;
                        endIndex = key.indexOf(124, beginIndex);
                        iDocTypes[i][1] = key.substring(beginIndex, endIndex);
                        beginIndex = endIndex + 1;
                        endIndex = key.indexOf(124, beginIndex);
                        iDocTypes[i][2] = key.substring(beginIndex, endIndex);
                        beginIndex = endIndex + 1;
                        endIndex = key.indexOf(124, beginIndex);
                        iDocTypes[i][3] = key.substring(beginIndex, endIndex);
                    }
                    if (this.m_segmentMetaDataCache.size() == numKeys) {
                        this.m_latestCachedIDocTypes = iDocTypes;
                    }
                }
            }
        }
        return iDocTypes;
    }

    public IDocSegmentMetaData getCachedRootSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        String key = DefaultIDocSegmentMetaData.createKey(iDocType, iDocTypeExtension, systemRelease, applicationRelease, ROOT);
        return this.m_segmentMetaDataCache.get(key);
    }

    public IDocSegmentMetaData getCachedSegmentMetaData(String key) {
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        return this.m_segmentMetaDataCache.get(key);
    }

    public IDocSegmentMetaData getCachedSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String definition) {
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        if (ROOT.equals(definition)) {
            return this.getCachedRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
        }
        String key = DefaultIDocSegmentMetaData.createKey(iDocType, iDocTypeExtension, systemRelease, applicationRelease, definition);
        return this.m_segmentMetaDataCache.get(key);
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public IDocSegmentMetaData getRootSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        IDocSegmentMetaData rootSegmentMetaData = this.getCachedRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
        return rootSegmentMetaData;
    }

    @Override
    public IDocSegmentMetaData getSegmentMetaData(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String definition) {
        IDocSegmentMetaData rootSegmentMetaData;
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        if (ROOT.equals(definition)) {
            return this.getRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
        }
        String key = DefaultIDocSegmentMetaData.createKey(iDocType, iDocTypeExtension, systemRelease, applicationRelease, definition);
        IDocSegmentMetaData segmentMetaData = this.getCachedSegmentMetaData(key);
        if (segmentMetaData == null && (rootSegmentMetaData = this.getCachedRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease)) != null) {
            this.addSegmentMetaDataTreeToCache(rootSegmentMetaData);
            segmentMetaData = this.getCachedSegmentMetaData(key);
        }
        return segmentMetaData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addIDocCompoundTypesToCache(Hashtable<String, String> iDocCompoundTypesHashtable) {
        if (iDocCompoundTypesHashtable == null || iDocCompoundTypesHashtable.size() == 0) {
            return;
        }
        if (this.m_iDocCompoundTypesCache == null) {
            BasicIDocRepository basicIDocRepository = this;
            synchronized (basicIDocRepository) {
                if (this.m_iDocCompoundTypesCache == null) {
                    this.m_iDocCompoundTypesCache = (Hashtable)iDocCompoundTypesHashtable.clone();
                    return;
                }
            }
        }
        String key = null;
        Enumeration<String> keys = iDocCompoundTypesHashtable.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            this.m_iDocCompoundTypesCache.put(key, iDocCompoundTypesHashtable.get(key));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIDocCompoundTypeToCache(String iDocType, String iDocTypeExtension, String iDocCompoundType) {
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        if (iDocType == null || iDocType.length() == 0 || iDocCompoundType == null || iDocCompoundType.length() == 0) {
            return;
        }
        if (this.m_iDocCompoundTypesCache == null) {
            BasicIDocRepository basicIDocRepository = this;
            synchronized (basicIDocRepository) {
                if (this.m_iDocCompoundTypesCache == null) {
                    this.m_iDocCompoundTypesCache = new Hashtable(51);
                }
            }
        }
        String key = BasicIDocRepository.createIDocCompoundTypeKey(iDocType, iDocTypeExtension);
        this.m_iDocCompoundTypesCache.put(key, iDocCompoundType);
    }

    protected static String createIDocCompoundTypeKey(String iDocType, String iDocTypeExtension) {
        if (iDocTypeExtension == null || iDocTypeExtension.length() == 0) {
            return iDocType;
        }
        StringBuilder key = new StringBuilder(61);
        if (iDocType != null) {
            key.append(iDocType);
        }
        key.append('|');
        key.append(iDocTypeExtension);
        return key.toString();
    }

    public String getCachedIDocCompoundType(String iDocType, String iDocTypeExtension) {
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        if (this.m_iDocCompoundTypesCache == null) {
            return null;
        }
        String key = BasicIDocRepository.createIDocCompoundTypeKey(iDocType, iDocTypeExtension);
        return this.m_iDocCompoundTypesCache.get(key);
    }

    @Override
    public String getIDocCompoundType(String iDocType, String iDocTypeExtension) {
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        return this.getCachedIDocCompoundType(iDocType, iDocTypeExtension);
    }

    @Override
    public IDocSegmentMetaData removeRootSegmentMetaDataFromCache(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        IDocSegmentMetaData segmentMetaData = this.getCachedRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
        if (this.removeSegmentMetaDataFromCache(segmentMetaData)) {
            return segmentMetaData;
        }
        return null;
    }

    @Override
    public IDocSegmentMetaData removeRootSegmentMetaDataTreeFromCache(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease) {
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        IDocSegmentMetaData segmentMetaData = this.getCachedRootSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
        if (this.removeSegmentMetaDataTreeFromCache(segmentMetaData)) {
            return segmentMetaData;
        }
        return null;
    }

    @Override
    public boolean removeSegmentMetaDataFromCache(IDocSegmentMetaData segmentMetaData) {
        boolean removed;
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        if (segmentMetaData == null) {
            return false;
        }
        boolean bl = removed = this.m_segmentMetaDataCache.remove(segmentMetaData.getKey()) != null;
        if (removed) {
            this.m_latestCachedIDocTypes = null;
        }
        return removed;
    }

    @Override
    public boolean removeSegmentMetaDataTreeFromCache(IDocSegmentMetaData segmentMetaData) {
        boolean removed;
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        if (segmentMetaData == null) {
            return false;
        }
        boolean bl = removed = this.m_segmentMetaDataCache.remove(segmentMetaData.getKey()) != null;
        if (removed) {
            this.m_latestCachedIDocTypes = null;
        }
        int numChilds = segmentMetaData.getNumChildren();
        for (int i = 0; i < numChilds; ++i) {
            this.removeSegmentMetaDataTreeFromCache(segmentMetaData.getChild(i));
        }
        return removed;
    }

    @Override
    public IDocSegmentMetaData removeSegmentMetaDataFromCache(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String definition) {
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        if (ROOT.equals(definition)) {
            return this.removeRootSegmentMetaDataFromCache(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
        }
        IDocSegmentMetaData segmentMetaData = this.getCachedSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, definition);
        if (this.removeSegmentMetaDataFromCache(segmentMetaData)) {
            return segmentMetaData;
        }
        return null;
    }

    @Override
    public IDocSegmentMetaData removeSegmentMetaDataTreeFromCache(String iDocType, String iDocTypeExtension, String systemRelease, String applicationRelease, String definition) {
        this.m_lastAccessTimestamp = System.currentTimeMillis();
        if (ROOT.equals(definition)) {
            return this.removeRootSegmentMetaDataTreeFromCache(iDocType, iDocTypeExtension, systemRelease, applicationRelease);
        }
        IDocSegmentMetaData segmentMetaData = this.getCachedSegmentMetaData(iDocType, iDocTypeExtension, systemRelease, applicationRelease, definition);
        if (this.removeSegmentMetaDataTreeFromCache(segmentMetaData)) {
            return segmentMetaData;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IDocRepositoryMonitor getMonitor() {
        if (this.m_monitor == null) {
            BasicIDocRepository basicIDocRepository = this;
            synchronized (basicIDocRepository) {
                if (this.m_monitor == null) {
                    this.m_monitor = new BasicIDocRepositoryMonitor();
                }
            }
        }
        return this.m_monitor;
    }

    protected class BasicIDocRepositoryMonitor
    implements IDocRepositoryMonitor {
        protected BasicIDocRepositoryMonitor() {
        }

        public String getRepositoryID() {
            return BasicIDocRepository.this.m_name;
        }

        public long getLastAccessTimestamp() {
            return BasicIDocRepository.this.m_lastAccessTimestamp;
        }

        public long getLastRemoteQueryTimestamp() {
            return 0L;
        }

        public int getIDocTypeCount() {
            return BasicIDocRepository.this.getCachedIDocTypes().length;
        }
    }
}

