/*
 * #%L
 * Fuse EAP :: Config
 * %%
 * Copyright (C) 2015 RedHat
 * %%
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * #L%
 */
package org.jboss.fuse.eap.config;

import org.wildfly.extras.config.ConfigContext;

public class RTGovClientConfigPlugin extends RTGovConfigPlugin
{
    @Override
    public String getConfigName ()
    {
        return "rtgovclient";
    }

    protected void updateOverlordConfigSubsystem (ConfigContext context, boolean enable) {
        updateSubsystem (context, enable, NS_OVERLORD_CONFIG, "/client/overlord-config-subsystem.xml");
    }

    protected void updateOverlordDeploySubsystem (ConfigContext context, boolean enable) {
        updateSubsystem (context, enable, NS_OVERLORD_DEPLOY, "/client/overlord-deploy-subsystem.xml");
    }
}
