/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.ser.std;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Date;

public class StdKeySerializer
extends StdSerializer<Object> {
    public StdKeySerializer() {
        super(Object.class);
    }

    @Override
    public void serialize(Object value2, JsonGenerator g, SerializerProvider provider) throws IOException {
        String str;
        Class<?> cls = value2.getClass();
        if (cls == String.class) {
            str = (String)value2;
        } else if (cls.isEnum()) {
            Enum en = (Enum)value2;
            str = provider.isEnabled(SerializationFeature.WRITE_ENUMS_USING_TO_STRING) ? en.toString() : en.name();
        } else {
            if (value2 instanceof Date) {
                provider.defaultSerializeDateKey((Date)value2, g);
                return;
            }
            str = cls == Class.class ? ((Class)value2).getName() : value2.toString();
        }
        g.writeFieldName(str);
    }

    @Override
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) throws JsonMappingException {
        return this.createSchemaNode("string");
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this.visitStringFormat(visitor, typeHint);
    }
}

