/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.events;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.jgit.events.ConfigChangedListener;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RefsChangedListener;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.events.RepositoryListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerList {
    private final ConcurrentMap<Class<? extends RepositoryListener>, CopyOnWriteArrayList<ListenerHandle>> lists = new ConcurrentHashMap<Class<? extends RepositoryListener>, CopyOnWriteArrayList<ListenerHandle>>();

    public ListenerHandle addIndexChangedListener(IndexChangedListener listener) {
        return this.addListener(IndexChangedListener.class, listener);
    }

    public ListenerHandle addRefsChangedListener(RefsChangedListener listener) {
        return this.addListener(RefsChangedListener.class, listener);
    }

    public ListenerHandle addConfigChangedListener(ConfigChangedListener listener) {
        return this.addListener(ConfigChangedListener.class, listener);
    }

    public <T extends RepositoryListener> ListenerHandle addListener(Class<T> type, T listener) {
        ListenerHandle handle2 = new ListenerHandle(this, type, listener);
        this.add(handle2);
        return handle2;
    }

    public void dispatch(RepositoryEvent event) {
        List list2 = (List)this.lists.get(event.getListenerType());
        if (list2 != null) {
            for (ListenerHandle handle2 : list2) {
                event.dispatch(handle2.listener);
            }
        }
    }

    private void add(ListenerHandle handle2) {
        CopyOnWriteArrayList<ListenerHandle> newList;
        CopyOnWriteArrayList<ListenerHandle> list2 = (CopyOnWriteArrayList<ListenerHandle>)this.lists.get(handle2.type);
        if (list2 == null && (list2 = (List)this.lists.putIfAbsent(handle2.type, newList = new CopyOnWriteArrayList<ListenerHandle>())) == null) {
            list2 = newList;
        }
        list2.add(handle2);
    }

    void remove(ListenerHandle handle2) {
        List list2 = (List)this.lists.get(handle2.type);
        if (list2 != null) {
            list2.remove(handle2);
        }
    }
}

