/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.dfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.internal.storage.dfs.DfsObjDatabase;
import org.eclipse.jgit.internal.storage.dfs.DfsObjectRepresentation;
import org.eclipse.jgit.internal.storage.dfs.DfsOutputStream;
import org.eclipse.jgit.internal.storage.dfs.DfsPackDescription;
import org.eclipse.jgit.internal.storage.dfs.DfsPackFile;
import org.eclipse.jgit.internal.storage.dfs.DfsReader;
import org.eclipse.jgit.internal.storage.dfs.DfsRepository;
import org.eclipse.jgit.internal.storage.file.PackIndex;
import org.eclipse.jgit.internal.storage.file.PackReverseIndex;
import org.eclipse.jgit.internal.storage.pack.PackExt;
import org.eclipse.jgit.internal.storage.pack.PackWriter;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.storage.pack.PackConfig;
import org.eclipse.jgit.util.BlockList;
import org.eclipse.jgit.util.io.CountingOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DfsPackCompactor {
    private final DfsRepository repo;
    private final List<DfsPackFile> srcPacks;
    private final List<PackWriter.ObjectIdSet> exclude;
    private final List<DfsPackDescription> newPacks;
    private final List<PackWriter.Statistics> newStats;
    private int autoAddSize;
    private RevWalk rw;
    private RevFlag added;
    private RevFlag isBase;

    public DfsPackCompactor(DfsRepository repository) {
        this.repo = repository;
        this.autoAddSize = 0x500000;
        this.srcPacks = new ArrayList<DfsPackFile>();
        this.exclude = new ArrayList<PackWriter.ObjectIdSet>(4);
        this.newPacks = new ArrayList<DfsPackDescription>(1);
        this.newStats = new ArrayList<PackWriter.Statistics>(1);
    }

    public DfsPackCompactor add(DfsPackFile pack) {
        this.srcPacks.add(pack);
        return this;
    }

    public DfsPackCompactor autoAdd() throws IOException {
        DfsObjDatabase objdb = this.repo.getObjectDatabase();
        for (DfsPackFile pack : objdb.getPacks()) {
            DfsPackDescription d = pack.getPackDescription();
            if (d.getFileSize(PackExt.PACK) < (long)this.autoAddSize) {
                this.add(pack);
                continue;
            }
            this.exclude(pack);
        }
        return this;
    }

    public DfsPackCompactor exclude(PackWriter.ObjectIdSet set2) {
        this.exclude.add(set2);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DfsPackCompactor exclude(DfsPackFile pack) throws IOException {
        PackIndex idx;
        DfsReader ctx = (DfsReader)this.repo.newObjectReader();
        try {
            idx = pack.getPackIndex(ctx);
            Object var5_4 = null;
            ctx.release();
        }
        catch (Throwable throwable2) {
            Object var5_5 = null;
            ctx.release();
            throw throwable2;
        }
        return this.exclude(new PackWriter.ObjectIdSet(){

            public boolean contains(AnyObjectId id) {
                return idx.hasObject(id);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compact(ProgressMonitor pm) throws IOException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        DfsObjDatabase objdb = this.repo.getObjectDatabase();
        DfsReader ctx = (DfsReader)objdb.newReader();
        try {
            PackWriter pw;
            block13: {
                block14: {
                    PackConfig pc = new PackConfig(this.repo);
                    pc.setIndexVersion(2);
                    pc.setDeltaCompress(false);
                    pc.setReuseDeltas(true);
                    pc.setReuseObjects(true);
                    pw = new PackWriter(pc, (ObjectReader)ctx);
                    try {
                        pw.setDeltaBaseAsOffset(true);
                        pw.setReuseDeltaCommits(false);
                        this.addObjectsToPack(pw, ctx, pm);
                        if (pw.getObjectCount() != 0L) break block13;
                        List<DfsPackDescription> remove2 = this.toPrune();
                        if (remove2.size() > 0) {
                            objdb.commitPack(Collections.<DfsPackDescription>emptyList(), remove2);
                        }
                        Object var12_8 = null;
                        if (pw == null) break block14;
                        pw.release();
                    }
                    catch (Throwable throwable2) {
                        Object var12_10 = null;
                        if (pw != null) {
                            pw.release();
                        }
                        throw throwable2;
                    }
                }
                Object var14_11 = null;
                this.rw = null;
                ctx.release();
                return;
            }
            boolean rollback = true;
            DfsPackDescription pack = objdb.newPack(DfsObjDatabase.PackSource.COMPACT);
            try {
                DfsPackCompactor.writePack(objdb, pack, pw, pm);
                DfsPackCompactor.writeIndex(objdb, pack, pw);
                PackWriter.Statistics stats = pw.getStatistics();
                pw.release();
                pw = null;
                pack.setPackStats(stats);
                objdb.commitPack(Collections.singletonList(pack), this.toPrune());
                this.newPacks.add(pack);
                this.newStats.add(stats);
                rollback = false;
                Object var10_16 = null;
                if (rollback) {
                    objdb.rollbackPack(Collections.singletonList(pack));
                }
            }
            catch (Throwable throwable3) {
                Object var10_17 = null;
                if (rollback) {
                    objdb.rollbackPack(Collections.singletonList(pack));
                }
                throw throwable3;
            }
            Object var12_9 = null;
            if (pw != null) {
                pw.release();
            }
        }
        catch (Throwable throwable4) {
            Object var14_13 = null;
            this.rw = null;
            ctx.release();
            throw throwable4;
        }
        Object var14_12 = null;
        this.rw = null;
        ctx.release();
    }

    public List<DfsPackDescription> getSourcePacks() {
        return this.toPrune();
    }

    public List<DfsPackDescription> getNewPacks() {
        return this.newPacks;
    }

    public List<PackWriter.Statistics> getNewPackStatistics() {
        return this.newStats;
    }

    private List<DfsPackDescription> toPrune() {
        int cnt = this.srcPacks.size();
        ArrayList<DfsPackDescription> all = new ArrayList<DfsPackDescription>(cnt);
        for (DfsPackFile pack : this.srcPacks) {
            all.add(pack.getPackDescription());
        }
        return all;
    }

    private void addObjectsToPack(PackWriter pw, DfsReader ctx, ProgressMonitor pm) throws IOException, IncorrectObjectTypeException {
        Collections.sort(this.srcPacks, new Comparator<DfsPackFile>(){

            @Override
            public int compare(DfsPackFile a, DfsPackFile b) {
                return a.getPackDescription().compareTo(b.getPackDescription());
            }
        });
        this.rw = new RevWalk(ctx);
        this.added = this.rw.newFlag("ADDED");
        this.isBase = this.rw.newFlag("IS_BASE");
        BlockList baseObjects = new BlockList();
        pm.beginTask(JGitText.get().countingObjects, 0);
        for (DfsPackFile src : this.srcPacks) {
            List<ObjectIdWithOffset> want = this.toInclude(src, ctx);
            if (want.isEmpty()) continue;
            PackReverseIndex rev = src.getReverseIdx(ctx);
            DfsObjectRepresentation rep2 = new DfsObjectRepresentation(src);
            for (ObjectIdWithOffset id : want) {
                RevObject base;
                int type;
                RevObject obj2 = this.rw.lookupAny(id, type = src.getObjectType(ctx, id.offset));
                if (obj2.has(this.added)) continue;
                pm.update(1);
                pw.addObject(obj2);
                obj2.add(this.added);
                src.representation(rep2, id.offset, ctx, rev);
                if (rep2.getFormat() != 0 || (base = this.rw.lookupAny(rep2.getDeltaBase(), type)).has(this.added) || base.has(this.isBase)) continue;
                baseObjects.add(base);
                base.add(this.isBase);
            }
        }
        for (RevObject obj3 : baseObjects) {
            if (obj3.has(this.added)) continue;
            pm.update(1);
            pw.addObject(obj3);
            obj3.add(this.added);
        }
        pm.endTask();
    }

    private List<ObjectIdWithOffset> toInclude(DfsPackFile src, DfsReader ctx) throws IOException {
        PackIndex srcIdx = src.getPackIndex(ctx);
        BlockList<ObjectIdWithOffset> want = new BlockList<ObjectIdWithOffset>((int)srcIdx.getObjectCount());
        block0: for (PackIndex.MutableEntry ent : srcIdx) {
            ObjectId id = ent.toObjectId();
            RevObject obj2 = this.rw.lookupOrNull(id);
            if (obj2 != null && (obj2.has(this.added) || obj2.has(this.isBase))) continue;
            for (PackWriter.ObjectIdSet e : this.exclude) {
                if (!e.contains(id)) continue;
                continue block0;
            }
            want.add(new ObjectIdWithOffset(id, ent.getOffset()));
        }
        Collections.sort(want, new Comparator<ObjectIdWithOffset>(){

            @Override
            public int compare(ObjectIdWithOffset a, ObjectIdWithOffset b) {
                return Long.signum(a.offset - b.offset);
            }
        });
        return want;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writePack(DfsObjDatabase objdb, DfsPackDescription pack, PackWriter pw, ProgressMonitor pm) throws IOException {
        DfsOutputStream out = objdb.writeFile(pack, PackExt.PACK);
        try {
            pw.writePack(pm, pm, out);
            pack.addFileExt(PackExt.PACK);
            Object var6_5 = null;
        }
        catch (Throwable throwable2) {
            Object var6_6 = null;
            out.close();
            throw throwable2;
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeIndex(DfsObjDatabase objdb, DfsPackDescription pack, PackWriter pw) throws IOException {
        DfsOutputStream out = objdb.writeFile(pack, PackExt.INDEX);
        try {
            CountingOutputStream cnt = new CountingOutputStream(out);
            pw.writeIndex(cnt);
            pack.addFileExt(PackExt.INDEX);
            pack.setFileSize(PackExt.INDEX, cnt.getCount());
            pack.setIndexVersion(pw.getIndexVersion());
            Object var6_5 = null;
        }
        catch (Throwable throwable2) {
            Object var6_6 = null;
            out.close();
            throw throwable2;
        }
        out.close();
    }

    private static class ObjectIdWithOffset
    extends ObjectId {
        final long offset;

        ObjectIdWithOffset(AnyObjectId id, long ofs) {
            super(id);
            this.offset = ofs;
        }
    }
}

