/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.storage.file;

import java.io.IOException;
import org.eclipse.jgit.internal.storage.file.PackFile;
import org.eclipse.jgit.internal.storage.pack.StoredObjectRepresentation;
import org.eclipse.jgit.lib.ObjectId;

class LocalObjectRepresentation
extends StoredObjectRepresentation {
    PackFile pack;
    long offset;
    long length;
    private long baseOffset;
    private ObjectId baseId;

    LocalObjectRepresentation() {
    }

    static LocalObjectRepresentation newWhole(PackFile f2, long p, long length) {
        LocalObjectRepresentation r = new LocalObjectRepresentation(){

            public int getFormat() {
                return 1;
            }
        };
        r.pack = f2;
        r.offset = p;
        r.length = length;
        return r;
    }

    static LocalObjectRepresentation newDelta(PackFile f2, long p, long n, ObjectId base) {
        Delta r = new Delta();
        r.pack = f2;
        r.offset = p;
        r.length = n;
        r.baseId = base;
        return r;
    }

    static LocalObjectRepresentation newDelta(PackFile f2, long p, long n, long base) {
        Delta r = new Delta();
        r.pack = f2;
        r.offset = p;
        r.length = n;
        r.baseOffset = base;
        return r;
    }

    public int getWeight() {
        return (int)Math.min(this.length, Integer.MAX_VALUE);
    }

    public ObjectId getDeltaBase() {
        if (this.baseId == null && this.getFormat() == 0) {
            try {
                this.baseId = this.pack.findObjectForOffset(this.baseOffset);
            }
            catch (IOException error2) {
                return null;
            }
        }
        return this.baseId;
    }

    private static final class Delta
    extends LocalObjectRepresentation {
        private Delta() {
        }

        public int getFormat() {
            return 0;
        }
    }
}

