/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.treewalk.filter;

import java.io.IOException;
import java.util.Collection;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.filter.TreeFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OrTreeFilter
extends TreeFilter {
    public static TreeFilter create(TreeFilter a, TreeFilter b) {
        if (a == ALL || b == ALL) {
            return ALL;
        }
        return new Binary(a, b);
    }

    public static TreeFilter create(TreeFilter[] list2) {
        if (list2.length == 2) {
            return OrTreeFilter.create(list2[0], list2[1]);
        }
        if (list2.length < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        TreeFilter[] subfilters = new TreeFilter[list2.length];
        System.arraycopy(list2, 0, subfilters, 0, list2.length);
        return new List(subfilters);
    }

    public static TreeFilter create(Collection<TreeFilter> list2) {
        if (list2.size() < 2) {
            throw new IllegalArgumentException(JGitText.get().atLeastTwoFiltersNeeded);
        }
        TreeFilter[] subfilters = new TreeFilter[list2.size()];
        list2.toArray(subfilters);
        if (subfilters.length == 2) {
            return OrTreeFilter.create(subfilters[0], subfilters[1]);
        }
        return new List(subfilters);
    }

    private static class Binary
    extends OrTreeFilter {
        private final TreeFilter a;
        private final TreeFilter b;

        Binary(TreeFilter one, TreeFilter two) {
            this.a = one;
            this.b = two;
        }

        public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            return this.a.include(walker) || this.b.include(walker);
        }

        public boolean shouldBeRecursive() {
            return this.a.shouldBeRecursive() || this.b.shouldBeRecursive();
        }

        public TreeFilter clone() {
            return new Binary(this.a.clone(), this.b.clone());
        }

        public String toString() {
            return "(" + this.a.toString() + " OR " + this.b.toString() + ")";
        }
    }

    private static class List
    extends OrTreeFilter {
        private final TreeFilter[] subfilters;

        List(TreeFilter[] list2) {
            this.subfilters = list2;
        }

        public boolean include(TreeWalk walker) throws MissingObjectException, IncorrectObjectTypeException, IOException {
            for (TreeFilter f2 : this.subfilters) {
                if (!f2.include(walker)) continue;
                return true;
            }
            return false;
        }

        public boolean shouldBeRecursive() {
            for (TreeFilter f2 : this.subfilters) {
                if (!f2.shouldBeRecursive()) continue;
                return true;
            }
            return false;
        }

        public TreeFilter clone() {
            TreeFilter[] s2 = new TreeFilter[this.subfilters.length];
            for (int i = 0; i < s2.length; ++i) {
                s2[i] = this.subfilters[i].clone();
            }
            return new List(s2);
        }

        public String toString() {
            StringBuilder r = new StringBuilder();
            r.append("(");
            for (int i = 0; i < this.subfilters.length; ++i) {
                if (i > 0) {
                    r.append(" OR ");
                }
                r.append(this.subfilters[i].toString());
            }
            r.append(")");
            return r.toString();
        }
    }
}

