/*
 * Decompiled with CFR 0.152.
 */
package org.joda.convert;

import org.joda.convert.RenameHandler;
import org.joda.convert.StringConverter;
import org.joda.convert.StringConverterFactory;
import org.joda.convert.TypedStringConverter;

final class EnumStringConverterFactory
implements StringConverterFactory {
    static final StringConverterFactory INSTANCE = new EnumStringConverterFactory();

    private EnumStringConverterFactory() {
    }

    @Override
    public StringConverter<?> findConverter(Class<?> cls) {
        Class<?> sup = cls.getSuperclass();
        if (sup == Enum.class) {
            return new EnumStringConverter(cls);
        }
        if (sup != null && sup.getSuperclass() == Enum.class) {
            return new EnumStringConverter(sup);
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    final class EnumStringConverter
    implements TypedStringConverter<Enum<?>> {
        private final Class<?> effectiveType;

        EnumStringConverter(Class<?> effectiveType) {
            this.effectiveType = effectiveType;
        }

        @Override
        public String convertToString(Enum<?> en) {
            return en.name();
        }

        @Override
        public Enum<?> convertFromString(Class<? extends Enum<?>> cls, String str) {
            return RenameHandler.INSTANCE.lookupEnum(cls, str);
        }

        @Override
        public Class<?> getEffectiveType() {
            return this.effectiveType;
        }
    }
}

