# Summary

* [Introduction](README.md)
* [Legal Notice](notice.md)
* [Getting Started](getting-started.adoc)
* [Longer Getting Started Guide](book-getting-started.adoc)

* [Architecture](architecture.adoc)
    * [Async](async.adoc)
    * [Asynchronous Routing Engine](asynchronous-routing-engine.adoc)
    * [BacklogDebugger](backlogdebugger.adoc)
    * [BAM](bam.adoc)
    * [Batch Consumer](batch-consumer.adoc)
    * [BrowsableEndpoint](browsable-endpoint.adoc)
    * [Camel Core](camel-core.adoc)
    * [CamelContext](camelcontext.adoc)
    * [CEP](cep.adoc)
    * [Debugger](debugger.adoc)
    * [Delay Interceptor](delay-interceptor.adoc)
    * [Dependency Injection](dependency-injection.adoc)
    * [Dozer Type Conversion](dozer-type-conversion.adoc)
    * [DSL](dsl.adoc)
        * [Java DSL](java-dsl.adoc)
        * [Spring DSL](spring.adoc)
        * [Blueprint DSL](using-osgi-blueprint-with-camel.adoc)
        * [Groovy DSL](groovy-dsl.adoc)
        * [Scala DSL](scala-dsl.adoc)
            * [Scala DSL Getting Started](scala-dsl-getting-started.adoc)
            * [Scala DSL EIP](scala-dsl-eip.adoc)
            * [Scala DSL Supported Languages](scala-dsl-supported-languages.adoc)
        * [Annotation DSL](bean-integration.adoc)
    * [Endpoint](endpoint.adoc)
    * [Error Handler](error-handler.adoc)
    * [Exchange](exchange.adoc)
    * [Exchange Pattern](exchange-pattern.adoc)
    * [Expression](expression.adoc)
    * [Injector](injector.adoc)
    * [Intercept](intercept.adoc)
    * [Inversion Of Control With Smart Defaults](inversion-of-control-with-smart-defaults.adoc)
    * [Lifecycle](lifecycle.adoc)
    * [OnCompletion](oncompletion.adoc)
    * [Registry](registry.adoc)
    * [RX](rx.adoc)
    * [Scala DSL](scala-dsl.adoc)

<!--
    * [Pluggable Class Resolvers](.adoc)
    * [Predicate](.adoc)
    * [Processor](.adoc)
    * [RouteBuilder](.adoc)
    * [RoutePolicy](.adoc)
    * [Routes](.adoc)
    * [ServicePool](.adoc)
    * [Stream caching](.adoc)
    * [ToAsync](.adoc)
    * [Tracer](.adoc)
    * [Transport](.adoc)
    * [Type Converter](.adoc)
    * [URIs](.adoc)
    * [Xml Configuration](.adoc)
    * [ProcessorFactory](.adoc)
    * [Asynchronous Routing Engine](.adoc)
    * [Security](.adoc)
    * [UuidGenerator](.adoc)
    * [Binding](.adoc)
    * [BacklogTracer](.adoc)
    * [Endpoint Annotations](.adoc)
    * [ComponentConfiguration](.adoc)
    * [BacklogDebugger](.adoc)
    * [EndpointCompleter](.adoc)
    * [Clustering and loadbalancing](.adoc)
    * [Threading Model](.adoc)
-->

* [Enterprise Integration Patterns](enterprise-integration-patterns.adoc)
    * [Event Message](event-message.adoc)
    * [Message](message.adoc)
    * [Request Reply](request-reply.adoc)

* Community
    * FAQ
        * Using Camel questions
            * [How do I configure endpoints](how-do-i-configure-endpoints.adoc)




<!-- core components: START -->
* Core Components
	* [Bean](bean-component.adoc)
	* [Binding](binding-component.adoc)
	* [Browse](browse-component.adoc)
	* [Class](class-component.adoc)
	* [Control Bus](controlbus-component.adoc)
	* [Data Format](dataformat-component.adoc)
	* [Dataset](dataset-component.adoc)
	* [Direct](direct-component.adoc)
	* [Direct VM](direct-vm-component.adoc)
	* [File](file-component.adoc)
	* [Language](language-component.adoc)
	* [Log](log-component.adoc)
	* [Mock](mock-component.adoc)
	* [Properties](properties-component.adoc)
	* [Ref](ref-component.adoc)
	* [REST](rest-component.adoc)
	* [REST API](rest-api-component.adoc)
	* [Saga](saga-component.adoc)
	* [Scheduler](scheduler-component.adoc)
	* [SEDA](seda-component.adoc)
	* [Stub](stub-component.adoc)
	* [Test](test-component.adoc)
	* [Timer](timer-component.adoc)
	* [Validator](validator-component.adoc)
	* [VM](vm-component.adoc)
	* [XSLT](xslt-component.adoc)
<!-- core components: END -->









<!-- components: START -->
* Components
	* [AHC](ahc-component.adoc)
	* [AHC Websocket](ahc-ws-component.adoc)
	* [AMQP](amqp-component.adoc)
	* [Apache Flink](flink-component.adoc)
	* [Apache Spark](spark-component.adoc)
	* [APNS](apns-component.adoc)
	* [Asterisk](asterisk-component.adoc)
	* [Atmos](atmos-component.adoc)
	* [Atmosphere Websocket](atmosphere-websocket-component.adoc)
	* [Atom](atom-component.adoc)
	* [Atomix Map](atomix-map-component.adoc)
	* [Atomix Messaging](atomix-messaging-component.adoc)
	* [Atomix MultiMap](atomix-multimap-component.adoc)
	* [Atomix Queue](atomix-queue-component.adoc)
	* [Atomix Set](atomix-set-component.adoc)
	* [Atomix Value](atomix-value-component.adoc)
	* [Avro](avro-component.adoc)
	* [AWS CloudWatch](aws-cw-component.adoc)
	* [AWS DynamoDB](aws-ddb-component.adoc)
	* [AWS DynamoDB Streams](aws-ddbstream-component.adoc)
	* [AWS EC2](aws-ec2-component.adoc)
	* [AWS Kinesis](aws-kinesis-component.adoc)
	* [AWS Kinesis Firehose](aws-kinesis-firehose-component.adoc)
	* [AWS KMS](aws-kms-component.adoc)
	* [AWS Lambda](aws-lambda-component.adoc)
	* [AWS MQ](aws-mq-component.adoc)
	* [AWS S3 Storage Service](aws-s3-component.adoc)
	* [AWS Simple Email Service](aws-ses-component.adoc)
	* [AWS Simple Notification System](aws-sns-component.adoc)
	* [AWS Simple Queue Service](aws-sqs-component.adoc)
	* [AWS Simple Workflow](aws-swf-component.adoc)
	* [AWS SimpleDB](aws-sdb-component.adoc)
	* [Azure Storage Blob Service](azure-blob-component.adoc)
	* [Azure Storage Queue Service](azure-queue-component.adoc)
	* [Bean Validator](bean-validator-component.adoc)
	* [Beanstalk](beanstalk-component.adoc)
	* [Bonita](bonita-component.adoc)
	* [Box](box-component.adoc)
	* [Braintree](braintree-component.adoc)
	* [Caffeine Cache](caffeine-cache-component.adoc)
	* [Caffeine LoadCache](caffeine-loadcache-component.adoc)
	* [Camel Context](context-component.adoc)
	* [Cassandra CQL](cql-component.adoc)
	* [Chronicle Engine](chronicle-engine-component.adoc)
	* [Chunk](chunk-component.adoc)
	* [CM SMS Gateway](cm-sms-component.adoc)
	* [CMIS](cmis-component.adoc)
	* [CoAP](coap-component.adoc)
	* [CometD](cometd-component.adoc)
	* [Consul](consul-component.adoc)
	* [Couchbase](couchbase-component.adoc)
	* [CouchDB](couchdb-component.adoc)
	* [Crypto (JCE)](crypto-component.adoc)
	* [Crypto CMS](crypto-cms-component.adoc)
	* [CXF](cxf-component.adoc)
	* [CXF-RS](cxfrs-component.adoc)
	* [DigitalOcean](digitalocean-component.adoc)
	* [Disruptor](disruptor-component.adoc)
	* [DNS](dns-component.adoc)
	* [Docker](docker-component.adoc)
	* [Dozer](dozer-component.adoc)
	* [Drill](drill-component.adoc)
	* [Dropbox](dropbox-component.adoc)
	* [EHCache](cache-component.adoc)
	* [Ehcache](ehcache-component.adoc)
	* [EJB](ejb-component.adoc)
	* [Elastichsearch Rest](elasticsearch-rest-component.adoc)
	* [Elasticsearch](elasticsearch-component.adoc)
	* [Elasticsearch5](elasticsearch5-component.adoc)
	* [ElSQL](elsql-component.adoc)
	* [etcd](etcd-component.adoc)
	* [Exec](exec-component.adoc)
	* [Facebook](facebook-component.adoc)
	* [Flatpack](flatpack-component.adoc)
	* [FOP](fop-component.adoc)
	* [Freemarker](freemarker-component.adoc)
	* [FTP](ftp-component.adoc)
	* [FTPS](ftps-component.adoc)
	* [Ganglia](ganglia-component.adoc)
	* [Geocoder](geocoder-component.adoc)
	* [Git](git-component.adoc)
	* [GitHub](github-component.adoc)
	* [Google BigQuery](google-bigquery-component.adoc)
	* [Google Calendar](google-calendar-component.adoc)
	* [Google Drive](google-drive-component.adoc)
	* [Google Mail](google-mail-component.adoc)
	* [Google Pubsub](google-pubsub-component.adoc)
	* [Gora](gora-component.adoc)
	* [Grape](grape-component.adoc)
	* [gRPC](grpc-component.adoc)
	* [Guava EventBus](guava-eventbus-component.adoc)
	* [Hazelcast Atomic Number](hazelcast-atomicvalue-component.adoc)
	* [Hazelcast Instance](hazelcast-instance-component.adoc)
	* [Hazelcast List](hazelcast-list-component.adoc)
	* [Hazelcast Map](hazelcast-map-component.adoc)
	* [Hazelcast Multimap](hazelcast-multimap-component.adoc)
	* [Hazelcast Queue](hazelcast-queue-component.adoc)
	* [Hazelcast Replicated Map](hazelcast-replicatedmap-component.adoc)
	* [Hazelcast Ringbuffer](hazelcast-ringbuffer-component.adoc)
	* [Hazelcast SEDA](hazelcast-seda-component.adoc)
	* [Hazelcast Set](hazelcast-set-component.adoc)
	* [Hazelcast Topic](hazelcast-topic-component.adoc)
	* [HBase](hbase-component.adoc)
	* [HDFS](hdfs-component.adoc)
	* [HDFS2](hdfs2-component.adoc)
	* [Hipchat](hipchat-component.adoc)
	* [HTTP](http-component.adoc)
	* [HTTP4](http4-component.adoc)
	* [iBatis](ibatis-component.adoc)
	* [IEC 60870 Client](iec60870-client-component.adoc)
	* [IEC 60870 Server](iec60870-server-component.adoc)
	* [Ignite Cache](ignite-cache-component.adoc)
	* [Ignite Compute](ignite-compute-component.adoc)
	* [Ignite Events](ignite-events-component.adoc)
	* [Ignite ID Generator](ignite-idgen-component.adoc)
	* [Ignite Messaging](ignite-messaging-component.adoc)
	* [Ignite Queues](ignite-queue-component.adoc)
	* [Ignite Sets](ignite-set-component.adoc)
	* [IMAP](imap-component.adoc)
	* [Infinispan](infinispan-component.adoc)
	* [InfluxDB](influxdb-component.adoc)
	* [IRC](irc-component.adoc)
	* [IronMQ](ironmq-component.adoc)
	* [JavaSpace](javaspace-component.adoc)
	* [JBPM](jbpm-component.adoc)
	* [JCache](jcache-component.adoc)
	* [JClouds](jclouds-component.adoc)
	* [JCR](jcr-component.adoc)
	* [JDBC](jdbc-component.adoc)
	* [Jetty 9](jetty-component.adoc)
	* [Jetty Websocket](websocket-component.adoc)
	* [JGroups](jgroups-component.adoc)
	* [Jing](jing-component.adoc)
	* [JIRA](jira-component.adoc)
	* [JMS](jms-component.adoc)
	* [JMX](jmx-component.adoc)
	* [JOLT](jolt-component.adoc)
	* [JPA](jpa-component.adoc)
	* [JSON Schema Validator](json-validator-component.adoc)
	* [JT400](jt400-component.adoc)
	* [Kafka](kafka-component.adoc)
	* [Kestrel](kestrel-component.adoc)
	* [Krati](krati-component.adoc)
	* [Kubernetes](kubernetes-component.adoc)
	* [Kubernetes ConfigMap](kubernetes-config-maps-component.adoc)
	* [Kubernetes Deployments](kubernetes-deployments-component.adoc)
	* [Kubernetes Namespaces](kubernetes-namespaces-component.adoc)
	* [Kubernetes Nodes](kubernetes-nodes-component.adoc)
	* [Kubernetes Persistent Volume](kubernetes-persistent-volumes-component.adoc)
	* [Kubernetes Persistent Volume Claim](kubernetes-persistent-volumes-claims-component.adoc)
	* [Kubernetes Pods](kubernetes-pods-component.adoc)
	* [Kubernetes Replication Controller](kubernetes-replication-controllers-component.adoc)
	* [Kubernetes Resources Quota](kubernetes-resources-quota-component.adoc)
	* [Kubernetes Secrets](kubernetes-secrets-component.adoc)
	* [Kubernetes Service Account](kubernetes-service-accounts-component.adoc)
	* [Kubernetes Services](kubernetes-services-component.adoc)
	* [LDAP](ldap-component.adoc)
	* [LDIF](ldif-component.adoc)
	* [Linkedin](linkedin-component.adoc)
	* [Lucene](lucene-component.adoc)
	* [Lumberjack](lumberjack-component.adoc)
	* [Master](master-component.adoc)
	* [Metrics](metrics-component.adoc)
	* [Mina](mina-component.adoc)
	* [Mina2](mina2-component.adoc)
	* [MLLP](mllp-component.adoc)
	* [MongoDB](mongodb-component.adoc)
	* [MongoDB](mongodb3-component.adoc)
	* [MongoDB GridFS](mongodb-gridfs-component.adoc)
	* [MQTT](mqtt-component.adoc)
	* [MSV](msv-component.adoc)
	* [Mustache](mustache-component.adoc)
	* [MVEL](mvel-component.adoc)
	* [MyBatis](mybatis-component.adoc)
	* [Nagios](nagios-component.adoc)
	* [Nats](nats-component.adoc)
	* [Netty](netty-component.adoc)
	* [Netty HTTP](netty-http-component.adoc)
	* [Netty4](netty4-component.adoc)
	* [Netty4 HTTP](netty4-http-component.adoc)
	* [Olingo2](olingo2-component.adoc)
	* [Olingo4](olingo4-component.adoc)
	* [OPC UA Client](milo-client-component.adoc)
	* [OPC UA Server](milo-server-component.adoc)
	* [OpenShift](openshift-component.adoc)
	* [Openshift Build Config](openshift-build-configs-component.adoc)
	* [Openshift Builds](openshift-builds-component.adoc)
	* [OpenStack Cinder](openstack-cinder-component.adoc)
	* [OpenStack Glance](openstack-glance-component.adoc)
	* [OpenStack Keystone](openstack-keystone-component.adoc)
	* [OpenStack Neutron](openstack-neutron-component.adoc)
	* [OpenStack Nova](openstack-nova-component.adoc)
	* [OpenStack Swift](openstack-swift-component.adoc)
	* [OptaPlanner](optaplanner-component.adoc)
	* [OSGi EventAdmin](eventadmin-component.adoc)
	* [OSGi PAX Logging](paxlogging-component.adoc)
	* [Paho](paho-component.adoc)
	* [PDF](pdf-component.adoc)
	* [PostgresSQL Event](pgevent-component.adoc)
	* [Printer](lpr-component.adoc)
	* [PubNub](pubnub-component.adoc)
	* [Quartz](quartz-component.adoc)
	* [Quartz2](quartz2-component.adoc)
	* [QuickFix](quickfix-component.adoc)
	* [RabbitMQ](rabbitmq-component.adoc)
	* [Reactive Streams](reactive-streams-component.adoc)
	* [REST Swagger](rest-swagger-component.adoc)
	* [Restlet](restlet-component.adoc)
	* [RMI](rmi-component.adoc)
	* [RouteBox](routebox-component.adoc)
	* [RSS](rss-component.adoc)
	* [Salesforce](salesforce-component.adoc)
	* [SAP NetWeaver](sap-netweaver-component.adoc)
	* [Schematron](schematron-component.adoc)
	* [SCP](scp-component.adoc)
	* [ServiceNow](servicenow-component.adoc)
	* [Servlet](servlet-component.adoc)
	* [SFTP](sftp-component.adoc)
	* [Simple JMS](sjms-component.adoc)
	* [Simple JMS Batch](sjms-batch-component.adoc)
	* [Simple JMS2](sjms2-component.adoc)
	* [SIP](sip-component.adoc)
	* [Slack](slack-component.adoc)
	* [SMPP](smpp-component.adoc)
	* [SNMP](snmp-component.adoc)
	* [Solr](solr-component.adoc)
	* [Spark Rest](spark-rest-component.adoc)
	* [Splunk](splunk-component.adoc)
	* [Spring Batch](spring-batch-component.adoc)
	* [Spring Event](spring-event-component.adoc)
	* [Spring Integration](spring-integration-component.adoc)
	* [Spring LDAP](spring-ldap-component.adoc)
	* [Spring Redis](spring-redis-component.adoc)
	* [Spring WebService](spring-ws-component.adoc)
	* [SQL](sql-component.adoc)
	* [SQL Stored Procedure](sql-stored-component.adoc)
	* [SSH](ssh-component.adoc)
	* [StAX](stax-component.adoc)
	* [Stomp](stomp-component.adoc)
	* [Stream](stream-component.adoc)
	* [String Template](string-template-component.adoc)
	* [Telegram](telegram-component.adoc)
	* [Thrift](thrift-component.adoc)
	* [Tika](tika-component.adoc)
	* [Twilio](twilio-component.adoc)
	* [Twitter](twitter-component.adoc)
	* [Twitter Direct Message](twitter-directmessage-component.adoc)
	* [Twitter Search](twitter-search-component.adoc)
	* [Twitter Streaming](twitter-streaming-component.adoc)
	* [Twitter Timeline](twitter-timeline-component.adoc)
	* [Undertow](undertow-component.adoc)
	* [Velocity](velocity-component.adoc)
	* [Vert.x](vertx-component.adoc)
	* [Weather](weather-component.adoc)
	* [Wordpress](wordpress-component.adoc)
	* [XChange](xchange-component.adoc)
	* [XML RPC](xmlrpc-component.adoc)
	* [XML Security](xmlsecurity-component.adoc)
	* [XMPP](xmpp-component.adoc)
	* [XQuery](xquery-component.adoc)
	* [Yahoo Query Language](yql-component.adoc)
	* [Yammer](yammer-component.adoc)
	* [Zendesk](zendesk-component.adoc)
	* [ZooKeeper](zookeeper-component.adoc)
	* [ZooKeeper Master](zookeeper-master-component.adoc)
<!-- components: END -->




<!-- others: START -->
* Miscellaneous Components
	* [BAM](bam.adoc)
	* [Blueprint](blueprint.adoc)
	* [CDI](cdi.adoc)
	* [CXF Transport](cxf-transport.adoc)
	* [Eclipse](eclipse.adoc)
	* [Groovy DSL](groovy-dsl.adoc)
	* [Guice](guice.adoc)
	* [HawtDB](hawtdb.adoc)
	* [Headersmap](headersmap.adoc)
	* [Hystrix](hystrix.adoc)
	* [Jasypt](jasypt.adoc)
	* [Kura](kura.adoc)
	* [LevelDB](leveldb.adoc)
	* [Lra](lra.adoc)
	* [OpenTracing](opentracing.adoc)
	* [Reactor](reactor.adoc)
	* [Ribbon](ribbon.adoc)
	* [Ruby](ruby.adoc)
	* [RX](rx.adoc)
	* [Scala DSL](scala.adoc)
	* [SCR](scr.adoc)
	* [Servlet Listener](servletlistener.adoc)
	* [Shiro](shiro.adoc)
	* [Spring Boot](spring-boot.adoc)
	* [Spring Cloud](spring-cloud.adoc)
	* [Spring Cloud Netflix](spring-cloud-netflix.adoc)
	* [Spring Java Configuration](spring-javaconfig.adoc)
	* [Spring Security](spring-security.adoc)
	* [Swagger](swagger.adoc)
	* [Swagger Java](swagger-java.adoc)
	* [Test](test.adoc)
	* [Test Blueprint](test-blueprint.adoc)
	* [Test CDI](test-cdi.adoc)
	* [Test Karaf](test-karaf.adoc)
	* [Test Spring](test-spring.adoc)
	* [TestNG](testng.adoc)
	* [URLRewrite](urlrewrite.adoc)
	* [XRay](aws-xray.adoc)
	* [Zipkin](zipkin.adoc)
<!-- others: END -->


<!-- dataformats: START -->
* Data Formats
	* [ASN.1 File](asn1-dataformat.adoc)
	* [Avro](avro-dataformat.adoc)
	* [Barcode](barcode-dataformat.adoc)
	* [Base64](base64-dataformat.adoc)
	* [BeanIO](beanio-dataformat.adoc)
	* [Bindy CSV](bindy-dataformat.adoc)
	* [Bindy Fixed Length](bindy-dataformat.adoc)
	* [Bindy Key Value Pair](bindy-dataformat.adoc)
	* [Boon](boon-dataformat.adoc)
	* [Castor](castor-dataformat.adoc)
	* [Crypto (Java Cryptographic Extension)](crypto-dataformat.adoc)
	* [CSV](csv-dataformat.adoc)
	* [FHIR JSon](fhirJson-dataformat.adoc)
	* [FHIR XML](fhirXml-dataformat.adoc)
	* [Flatpack](flatpack-dataformat.adoc)
	* [GZip](gzip-dataformat.adoc)
	* [Hessian](hessian-dataformat.adoc)
	* [HL7](hl7-dataformat.adoc)
	* [iCal](ical-dataformat.adoc)
	* [JacksonXML](jacksonxml-dataformat.adoc)
	* [Java Object Serialization](serialization-dataformat.adoc)
	* [JAXB](jaxb-dataformat.adoc)
	* [JiBX](jibx-dataformat.adoc)
	* [JSon Fastjson](json-fastjson-dataformat.adoc)
	* [JSon GSon](json-gson-dataformat.adoc)
	* [JSon Jackson](json-jackson-dataformat.adoc)
	* [JSon Johnzon](json-johnzon-dataformat.adoc)
	* [JSon XStream](json-xstream-dataformat.adoc)
	* [LZF Deflate Compression](lzf-dataformat.adoc)
	* [MIME Multipart](mime-multipart-dataformat.adoc)
	* [PGP](pgp-dataformat.adoc)
	* [Protobuf](protobuf-dataformat.adoc)
	* [RSS](rss-dataformat.adoc)
	* [SOAP](soapjaxb-dataformat.adoc)
	* [String Encoding](string-dataformat.adoc)
	* [Syslog](syslog-dataformat.adoc)
	* [Tar File](tarfile-dataformat.adoc)
	* [Thrift](thrift-dataformat.adoc)
	* [TidyMarkup](tidyMarkup-dataformat.adoc)
	* [uniVocity CSV](univocity-csv-dataformat.adoc)
	* [uniVocity Fixed Length](univocity-fixed-dataformat.adoc)
	* [uniVocity TSV](univocity-tsv-dataformat.adoc)
	* [XML Beans](xmlBeans-dataformat.adoc)
	* [XML JSon](xmljson-dataformat.adoc)
	* [XML RPC](xmlrpc-dataformat.adoc)
	* [XML Security](secureXML-dataformat.adoc)
	* [XStream](xstream-dataformat.adoc)
	* [YAML SnakeYAML](yaml-snakeyaml-dataformat.adoc)
	* [Zip Deflate Compression](zip-dataformat.adoc)
	* [Zip File](zipfile-dataformat.adoc)
<!-- dataformats: END -->









<!-- languages: START -->
* Expression Languages
	* [Bean method](bean-language.adoc)
	* [Constant](constant-language.adoc)
	* [EL](el-language.adoc)
	* [ExchangeProperty](exchangeProperty-language.adoc)
	* [File](file-language.adoc)
	* [Groovy](groovy-language.adoc)
	* [Header](header-language.adoc)
	* [HL7 Terser](terser-language.adoc)
	* [JavaScript](javaScript-language.adoc)
	* [JsonPath](jsonpath-language.adoc)
	* [JXPath](jxpath-language.adoc)
	* [MVEL](mvel-language.adoc)
	* [OGNL](ognl-language.adoc)
	* [PHP](php-language.adoc)
	* [Python](python-language.adoc)
	* [Ref](ref-language.adoc)
	* [Ruby](ruby-language.adoc)
	* [Simple](simple-language.adoc)
	* [SpEL](spel-language.adoc)
	* [SQL](sql-language.adoc)
	* [Tokenize](tokenize-language.adoc)
	* [XML Tokenize](xtokenize-language.adoc)
	* [XPath](xpath-language.adoc)
	* [XQuery](xquery-language.adoc)
<!-- languages: END -->




* Example
    * [BAM Example](bam-example.adoc)

* User Guide
    * [Karaf](karaf.adoc)
    * [Testing](testing.adoc)
        * [Test](test.adoc)
        * [Blueprint Testing](test-blueprint.adoc)
        * [CDI Testing](test-cdi.adoc)
        * [Spring Testing](test-spring.adoc)
    * [JSSE Utility](camel-configuration-utilities.adoc)
