/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.cxf.systest.jaxws.tracing;

import java.util.Arrays;
import java.util.Collection;
import java.util.UUID;

import javax.jws.WebMethod;
import javax.jws.WebService;

import org.apache.cxf.systest.Book;
import org.apache.htrace.core.TraceScope;
import org.apache.htrace.core.Tracer;

@WebService(endpointInterface = "org.apache.cxf.systest.jaxws.tracing.BookStoreService", serviceName = "BookStore")
public class BookStore implements BookStoreService {
    @WebMethod
    public Collection< Book > getBooks() {
        try (TraceScope span = Tracer.curThreadTracer().newScope("Get Books")) {
            return Arrays.asList(
                new Book("Apache CXF in Action", UUID.randomUUID().toString()),
                new Book("Mastering Apache CXF", UUID.randomUUID().toString())
            );
        }
    }
}
