// Code generated by go-bindata.
// sources:
// translations/extract.py
// translations/kubectl/OWNERS
// translations/kubectl/default/LC_MESSAGES/k8s.mo
// translations/kubectl/default/LC_MESSAGES/k8s.po
// translations/kubectl/en_US/LC_MESSAGES/k8s.mo
// translations/kubectl/en_US/LC_MESSAGES/k8s.po
// translations/kubectl/fr_FR/LC_MESSAGES/k8s.mo
// translations/kubectl/fr_FR/LC_MESSAGES/k8s.po
// translations/kubectl/ja_JP/LC_MESSAGES/k8s.mo
// translations/kubectl/ja_JP/LC_MESSAGES/k8s.po
// translations/kubectl/template.pot
// translations/kubectl/zh_CN/LC_MESSAGES/k8s.mo
// translations/kubectl/zh_CN/LC_MESSAGES/k8s.po
// translations/kubectl/zh_TW/LC_MESSAGES/k8s.mo
// translations/kubectl/zh_TW/LC_MESSAGES/k8s.po
// translations/test/default/LC_MESSAGES/k8s.mo
// translations/test/default/LC_MESSAGES/k8s.po
// translations/test/en_US/LC_MESSAGES/k8s.mo
// translations/test/en_US/LC_MESSAGES/k8s.po
// DO NOT EDIT!

package generated

import (
	"fmt"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

type asset struct {
	bytes []byte
	info  os.FileInfo
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _translationsExtractPy = []byte(`#!/usr/bin/env python

# Copyright 2017 The Kubernetes Authors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Extract strings from command files and externalize into translation files.
Expects to be run from the root directory of the repository.

Usage:
   extract.py pkg/kubectl/cmd/apply.go

"""
import fileinput
import sys
import re

class MatchHandler(object):
    """ Simple holder for a regular expression and a function
    to run if that regular expression matches a line.
    The function should expect (re.match, file, linenumber) as parameters
    """
    def __init__(self, regex, replace_fn):
        self.regex = re.compile(regex)
        self.replace_fn = replace_fn

def short_replace(match, file, line_number):
    """Replace a Short: ... cobra command description with an internationalization
    """
    sys.stdout.write('{}i18n.T({}),\n'.format(match.group(1), match.group(2)))

SHORT_MATCH = MatchHandler(r'(\s+Short:\s+)("[^"]+"),', short_replace)

def import_replace(match, file, line_number):
    """Add an extra import for the i18n library.
    Doesn't try to be smart and detect if it's already present, assumes a
    gofmt round wil fix things.
    """
    sys.stdout.write('{}\n"k8s.io/kubernetes/pkg/util/i18n"\n'.format(match.group(1)))

IMPORT_MATCH = MatchHandler('(.*"k8s.io/kubernetes/pkg/kubectl/cmd/util")', import_replace)


def string_flag_replace(match, file, line_number):
    """Replace a cmd.Flags().String("...", "", "...") with an internationalization
    """
    sys.stdout.write('{}i18n.T("{})"))\n'.format(match.group(1), match.group(2)))

STRING_FLAG_MATCH = MatchHandler('(\s+cmd\.Flags\(\).String\("[^"]*", "[^"]*", )"([^"]*)"\)', string_flag_replace)


def long_string_replace(match, file, line_number):
    return '{}i18n.T({}){}'.format(match.group(1), match.group(2), match.group(3))

LONG_DESC_MATCH = MatchHandler('(LongDesc\()(` + "`" + `[^` + "`" + `]+` + "`" + `)([^\n]\n)', long_string_replace)

EXAMPLE_MATCH = MatchHandler('(Examples\()(` + "`" + `[^` + "`" + `]+` + "`" + `)([^\n]\n)', long_string_replace)

def replace(filename, matchers, multiline_matchers):
    """Given a file and a set of matchers, run those matchers
    across the file and replace it with the results.
    """
    # Run all the matchers
    line_number = 0
    for line in fileinput.input(filename, inplace=True):
        line_number += 1
        matched = False
        for matcher in matchers:
            match = matcher.regex.match(line)
            if match:
                matcher.replace_fn(match, filename, line_number)
                matched = True
                break
        if not matched:
            sys.stdout.write(line)
    sys.stdout.flush()
    with open(filename, 'r') as datafile:
        content = datafile.read()
        for matcher in multiline_matchers:
            match = matcher.regex.search(content)
            while match:
                rep = matcher.replace_fn(match, filename, 0)
                # Escape back references in the replacement string
                # (And escape for Python)
                # (And escape for regex)
                rep = re.sub('\\\\(\\d)', '\\\\\\\\\\1', rep)
                content = matcher.regex.sub(rep, content, 1)
                match = matcher.regex.search(content)
        sys.stdout.write(content)

    # gofmt the file again
    from subprocess import call
    call(["goimports", "-w", filename])

replace(sys.argv[1], [SHORT_MATCH, IMPORT_MATCH, STRING_FLAG_MATCH], [LONG_DESC_MATCH, EXAMPLE_MATCH])
`)

func translationsExtractPyBytes() ([]byte, error) {
	return _translationsExtractPy, nil
}

func translationsExtractPy() (*asset, error) {
	bytes, err := translationsExtractPyBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/extract.py", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlOwners = []byte(`approvers:
- sig-cli-maintainers
reviewers:
- sig-cli
`)

func translationsKubectlOwnersBytes() ([]byte, error) {
	return _translationsKubectlOwners, nil
}

func translationsKubectlOwners() (*asset, error) {
	bytes, err := translationsKubectlOwnersBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/OWNERS", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlDefaultLc_messagesK8sMo = []byte("\xde\x12\x04\x95\x00\x00\x00\x00\xeb\x00\x00\x00\x1c\x00\x00\x00t\a\x00\x009\x01\x00\x00\xcc\x0e\x00\x00\x00\x00\x00\x00\xb0\x13\x00\x00\xdc\x00\x00\x00\xb1\x13\x00\x00\xb6\x00\x00\x00\x8e\x14\x00\x00\v\x02\x00\x00E\x15\x00\x00\x1f\x01\x00\x00Q\x17\x00\x00z\x00\x00\x00q\x18\x00\x00_\x02\x00\x00\xec\x18\x00\x00|\x01\x00\x00L\x1b\x00\x00\x8f\x01\x00\x00\xc9\x1c\x00\x00k\x01\x00\x00Y\x1e\x00\x00k\x01\x00\x00\xc5\x1f\x00\x00>\x01\x00\x001!\x00\x00\x03\x02\x00\x00p\"\x00\x00o\x01\x00\x00t$\x00\x00H\x05\x00\x00\xe4%\x00\x00g\x02\x00\x00-+\x00\x00\x1b\x02\x00\x00\x95-\x00\x00q\x01\x00\x00\xb1/\x00\x00\xa8\x01\x00\x00#1\x00\x00\xd4\x01\x00\x00\xcc2\x00\x00\x02\x02\x00\x00\xa14\x00\x00\xb4\x00\x00\x00\xa46\x00\x00\xb7\x02\x00\x00Y7\x00\x00\x92\x03\x00\x00\x11:\x00\x00\xbf\x01\x00\x00\xa4=\x00\x00=\x00\x00\x00d?\x00\x00;\x00\x00\x00\xa2?\x00\x00\xcd\x02\x00\x00\xde?\x00\x00<\x00\x00\x00\xacB\x00\x00P\x00\x00\x00\xe9B\x00\x00S\x00\x00\x00:C\x00\x00<\x00\x00\x00\x8eC\x00\x00\xac\x01\x00\x00\xcbC\x00\x00\x13\x03\x00\x00xE\x00\x00\xea\x01\x00\x00\x8cH\x00\x00\xfa\x01\x00\x00wJ\x00\x00\xda\x01\x00\x00rL\x00\x00c\x01\x00\x00MN\x00\x00T\x01\x00\x00\xb1O\x00\x00\xba\x06\x00\x00\x06Q\x00\x00\xf9\x01\x00\x00\xc1W\x00\x00\xe0\x02\x00\x00\xbbY\x00\x00\x02\x03\x00\x00\x9c\\\x00\x00\xfb\x00\x00\x00\x9f_\x00\x00\xa5\x01\x00\x00\x9b`\x00\x00\xb4\x01\x00\x00Ab\x00\x00\x18\x00\x00\x00\xf6c\x00\x00<\x00\x00\x00\x0fd\x00\x00=\x00\x00\x00Ld\x00\x00\xc6\x00\x00\x00\x8ad\x00\x00g\x02\x00\x00Qe\x00\x00.\x00\x00\x00\xb9g\x00\x001\x03\x00\x00\xe8g\x00\x00g\x00\x00\x00\x1ak\x00\x00Q\x00\x00\x00\x82k\x00\x00R\x00\x00\x00\xd4k\x00\x00\"\x00\x00\x00'l\x00\x00X\x02\x00\x00Jl\x00\x004\x00\x00\x00\xa3n\x00\x00}\x00\x00\x00\xd8n\x00\x00k\x01\x00\x00Vo\x00\x00\x81\a\x00\x00\xc2p\x00\x00f\x01\x00\x00Dx\x00\x00\x85\x00\x00\x00\xaby\x00\x00\xea\x00\x00\x001z\x00\x00\xd9\x00\x00\x00\x1c{\x00\x00\n\x05\x00\x00\xf6{\x00\x00\x10\x05\x00\x00\x01\x81\x00\x00\x1c\x00\x00\x00\x12\x86\x00\x00\x1e\x00\x00\x00/\x86\x00\x00\x99\x02\x00\x00N\x86\x00\x00\xbc\x01\x00\x00\xe8\x88\x00\x00\x9c\x01\x00\x00\xa5\x8a\x00\x00q\x01\x00\x00B\x8c\x00\x00\x05\x01\x00\x00\xb4\x8d\x00\x00\xdf\x01\x00\x00\xba\x8e\x00\x00\x1c\x01\x00\x00\x9a\x90\x00\x00\xc1\x01\x00\x00\xb7\x91\x00\x00\x1b\x02\x00\x00y\x93\x00\x00\xc0\x00\x00\x00\x95\x95\x00\x00\xd5\x02\x00\x00V\x96\x00\x00\x9d\x00\x00\x00,\x99\x00\x00X\x00\x00\x00\u0299\x00\x00%\x02\x00\x00#\x9a\x00\x00o\x00\x00\x00I\x9c\x00\x00u\x00\x00\x00\xb9\x9c\x00\x00\x01\x01\x00\x00/\x9d\x00\x00v\x00\x00\x001\x9e\x00\x00t\x00\x00\x00\xa8\x9e\x00\x00\xef\x00\x00\x00\x1d\x9f\x00\x00}\x00\x00\x00\r\xa0\x00\x00j\x00\x00\x00\x8b\xa0\x00\x00\xc4\x01\x00\x00\xf6\xa0\x00\x00\xf7\x03\x00\x00\xbb\xa2\x00\x00;\x00\x00\x00\xb3\xa6\x00\x008\x00\x00\x00\xef\xa6\x00\x001\x00\x00\x00(\xa7\x00\x007\x00\x00\x00Z\xa7\x00\x00u\x02\x00\x00\x92\xa7\x00\x00\xb0\x00\x00\x00\b\xaa\x00\x00[\x00\x00\x00\xb9\xaa\x00\x00J\x00\x00\x00\x15\xab\x00\x00a\x00\x00\x00`\xab\x00\x00\xbd\x00\x00\x00\u00ab\x00\x009\x00\x00\x00\x80\xac\x00\x00\xc5\x00\x00\x00\xba\xac\x00\x00\xae\x00\x00\x00\x80\xad\x00\x00\xd6\x00\x00\x00/\xae\x00\x008\x00\x00\x00\x06\xaf\x00\x00%\x00\x00\x00?\xaf\x00\x00W\x00\x00\x00e\xaf\x00\x00\x1d\x00\x00\x00\xbd\xaf\x00\x00=\x00\x00\x00\u06ef\x00\x00u\x00\x00\x00\x19\xb0\x00\x004\x00\x00\x00\x8f\xb0\x00\x00-\x00\x00\x00\u0130\x00\x00\xa3\x00\x00\x00\xf2\xb0\x00\x003\x00\x00\x00\x96\xb1\x00\x002\x00\x00\x00\u02b1\x00\x008\x00\x00\x00\xfd\xb1\x00\x00\x1e\x00\x00\x006\xb2\x00\x00\x1a\x00\x00\x00U\xb2\x00\x009\x00\x00\x00p\xb2\x00\x00\x13\x00\x00\x00\xaa\xb2\x00\x00\x1b\x00\x00\x00\xbe\xb2\x00\x00@\x00\x00\x00\u06b2\x00\x00,\x00\x00\x00\x1b\xb3\x00\x00*\x00\x00\x00H\xb3\x00\x007\x00\x00\x00s\xb3\x00\x00'\x00\x00\x00\xab\xb3\x00\x00&\x00\x00\x00\u04f3\x00\x00.\x00\x00\x00\xfa\xb3\x00\x00=\x00\x00\x00)\xb4\x00\x00*\x00\x00\x00g\xb4\x00\x000\x00\x00\x00\x92\xb4\x00\x00,\x00\x00\x00\u00f4\x00\x00\x1f\x00\x00\x00\xf0\xb4\x00\x00]\x00\x00\x00\x10\xb5\x00\x000\x00\x00\x00n\xb5\x00\x000\x00\x00\x00\x9f\xb5\x00\x00\"\x00\x00\x00\u0435\x00\x00?\x00\x00\x00\xf3\xb5\x00\x00\x1d\x00\x00\x003\xb6\x00\x004\x00\x00\x00Q\xb6\x00\x003\x00\x00\x00\x86\xb6\x00\x00,\x00\x00\x00\xba\xb6\x00\x00\x14\x00\x00\x00\xe7\xb6\x00\x00*\x00\x00\x00\xfc\xb6\x00\x00A\x00\x00\x00'\xb7\x00\x00\x1d\x00\x00\x00i\xb7\x00\x00\x1c\x00\x00\x00\x87\xb7\x00\x00\x1a\x00\x00\x00\xa4\xb7\x00\x00)\x00\x00\x00\xbf\xb7\x00\x006\x00\x00\x00\xe9\xb7\x00\x00\x1d\x00\x00\x00 \xb8\x00\x00\x19\x00\x00\x00>\xb8\x00\x00 \x00\x00\x00X\xb8\x00\x00v\x00\x00\x00y\xb8\x00\x00(\x00\x00\x00\xf0\xb8\x00\x00\x16\x00\x00\x00\x19\xb9\x00\x00p\x00\x00\x000\xb9\x00\x00`\x00\x00\x00\xa1\xb9\x00\x00\x9b\x00\x00\x00\x02\xba\x00\x00\x97\x00\x00\x00\x9e\xba\x00\x00\xa8\x00\x00\x006\xbb\x00\x00\x1b\x00\x00\x00\u07fb\x00\x00\x18\x00\x00\x00\xfb\xbb\x00\x00\x1a\x00\x00\x00\x14\xbc\x00\x00$\x00\x00\x00/\xbc\x00\x00\x1d\x00\x00\x00T\xbc\x00\x00\x17\x00\x00\x00r\xbc\x00\x00a\x00\x00\x00\x8a\xbc\x00\x00s\x00\x00\x00\xec\xbc\x00\x00B\x00\x00\x00`\xbd\x00\x00Y\x00\x00\x00\xa3\xbd\x00\x00+\x00\x00\x00\xfd\xbd\x00\x00+\x00\x00\x00)\xbe\x00\x006\x00\x00\x00U\xbe\x00\x00;\x00\x00\x00\x8c\xbe\x00\x00q\x00\x00\x00\u023e\x00\x00/\x00\x00\x00:\xbf\x00\x001\x00\x00\x00j\xbf\x00\x00'\x00\x00\x00\x9c\xbf\x00\x00'\x00\x00\x00\u013f\x00\x00\x18\x00\x00\x00\xec\xbf\x00\x00&\x00\x00\x00\x05\xc0\x00\x00%\x00\x00\x00,\xc0\x00\x00(\x00\x00\x00R\xc0\x00\x00#\x00\x00\x00{\xc0\x00\x00K\x00\x00\x00\x9f\xc0\x00\x00 \x00\x00\x00\xeb\xc0\x00\x00_\x00\x00\x00\f\xc1\x00\x00\x1e\x00\x00\x00l\xc1\x00\x00\"\x00\x00\x00\x8b\xc1\x00\x00\"\x00\x00\x00\xae\xc1\x00\x00\x1f\x00\x00\x00\xd1\xc1\x00\x00-\x00\x00\x00\xf1\xc1\x00\x00-\x00\x00\x00\x1f\xc2\x00\x009\x00\x00\x00M\xc2\x00\x00\x1e\x00\x00\x00\x87\xc2\x00\x00\x19\x00\x00\x00\xa6\xc2\x00\x00c\x00\x00\x00\xc0\xc2\x00\x00#\x00\x00\x00$\xc3\x00\x00\x82\x00\x00\x00H\xc3\x00\x00\x94\x00\x00\x00\xcb\xc3\x00\x00H\x00\x00\x00`\xc4\x00\x00&\x00\x00\x00\xa9\xc4\x00\x00e\x00\x00\x00\xd0\xc4\x00\x00z\x00\x00\x006\xc5\x00\x00J\x00\x00\x00\xb1\xc5\x00\x00\xe5\x00\x00\x00\xfc\xc5\x00\x00W\x00\x00\x00\xe2\xc6\x00\x00E\x00\x00\x00:\xc7\x00\x00a\x00\x00\x00\x80\xc7\x00\x00v\x00\x00\x00\xe2\xc7\x00\x00\xcb\x00\x00\x00Y\xc8\x00\x00\xcf\x00\x00\x00%\xc9\x00\x00\x1e\x01\x00\x00\xf5\xc9\x00\x00\x1c\x00\x00\x00\x14\xcb\x00\x00T\x00\x00\x001\xcb\x00\x00\x17\x00\x00\x00\x86\xcb\x00\x00/\x00\x00\x00\x9e\xcb\x00\x009\x00\x00\x00\xce\xcb\x00\x00\x1e\x00\x00\x00\b\xcc\x00\x00=\x00\x00\x00'\xcc\x00\x00$\x00\x00\x00e\xcc\x00\x00\x1f\x00\x00\x00\x8a\xcc\x00\x00&\x00\x00\x00\xaa\xcc\x00\x00+\x00\x00\x00\xd1\xcc\x00\x00G\x00\x00\x00\xfd\xcc\x00\x00\x14\x00\x00\x00E\xcd\x00\x00r\x00\x00\x00Z\xcd\x00\x00\x13\x00\x00\x00\xcd\xcd\x00\x00\x18\x00\x00\x00\xe1\xcd\x00\x00/\x00\x00\x00\xfa\xcd\x00\x00\xb1\x01\x00\x00*\xce\x00\x00\xdc\x00\x00\x00\xdc\xcf\x00\x00\xb6\x00\x00\x00\xb9\xd0\x00\x00\v\x02\x00\x00p\xd1\x00\x00\x1f\x01\x00\x00|\xd3\x00\x00z\x00\x00\x00\x9c\xd4\x00\x00_\x02\x00\x00\x17\xd5\x00\x00|\x01\x00\x00w\xd7\x00\x00\x8f\x01\x00\x00\xf4\xd8\x00\x00k\x01\x00\x00\x84\xda\x00\x00k\x01\x00\x00\xf0\xdb\x00\x00>\x01\x00\x00\\\xdd\x00\x00\x03\x02\x00\x00\x9b\xde\x00\x00o\x01\x00\x00\x9f\xe0\x00\x00H\x05\x00\x00\x0f\xe2\x00\x00g\x02\x00\x00X\xe7\x00\x00\x1b\x02\x00\x00\xc0\xe9\x00\x00q\x01\x00\x00\xdc\xeb\x00\x00\xa8\x01\x00\x00N\xed\x00\x00\xd4\x01\x00\x00\xf7\xee\x00\x00\x02\x02\x00\x00\xcc\xf0\x00\x00\xb4\x00\x00\x00\xcf\xf2\x00\x00\xb7\x02\x00\x00\x84\xf3\x00\x00\x92\x03\x00\x00<\xf6\x00\x00\xbf\x01\x00\x00\xcf\xf9\x00\x00=\x00\x00\x00\x8f\xfb\x00\x00;\x00\x00\x00\xcd\xfb\x00\x00\xcd\x02\x00\x00\t\xfc\x00\x00<\x00\x00\x00\xd7\xfe\x00\x00P\x00\x00\x00\x14\xff\x00\x00S\x00\x00\x00e\xff\x00\x00<\x00\x00\x00\xb9\xff\x00\x00\xac\x01\x00\x00\xf6\xff\x00\x00\x13\x03\x00\x00\xa3\x01\x01\x00\xea\x01\x00\x00\xb7\x04\x01\x00\xfa\x01\x00\x00\xa2\x06\x01\x00\xda\x01\x00\x00\x9d\b\x01\x00c\x01\x00\x00x\n\x01\x00T\x01\x00\x00\xdc\v\x01\x00\xba\x06\x00\x001\r\x01\x00\xf9\x01\x00\x00\xec\x13\x01\x00\xe0\x02\x00\x00\xe6\x15\x01\x00\x02\x03\x00\x00\xc7\x18\x01\x00\xfb\x00\x00\x00\xca\x1b\x01\x00\xa5\x01\x00\x00\xc6\x1c\x01\x00\xb4\x01\x00\x00l\x1e\x01\x00\x18\x00\x00\x00! \x01\x00<\x00\x00\x00: \x01\x00=\x00\x00\x00w \x01\x00\xc6\x00\x00\x00\xb5 \x01\x00g\x02\x00\x00|!\x01\x00.\x00\x00\x00\xe4#\x01\x001\x03\x00\x00\x13$\x01\x00g\x00\x00\x00E'\x01\x00Q\x00\x00\x00\xad'\x01\x00R\x00\x00\x00\xff'\x01\x00\"\x00\x00\x00R(\x01\x00X\x02\x00\x00u(\x01\x004\x00\x00\x00\xce*\x01\x00}\x00\x00\x00\x03+\x01\x00k\x01\x00\x00\x81+\x01\x00\x81\a\x00\x00\xed,\x01\x00f\x01\x00\x00o4\x01\x00\x85\x00\x00\x00\xd65\x01\x00\xea\x00\x00\x00\\6\x01\x00\xd9\x00\x00\x00G7\x01\x00\n\x05\x00\x00!8\x01\x00\x10\x05\x00\x00,=\x01\x00\x1c\x00\x00\x00=B\x01\x00\x1e\x00\x00\x00ZB\x01\x00\x99\x02\x00\x00yB\x01\x00\xbc\x01\x00\x00\x13E\x01\x00\x9c\x01\x00\x00\xd0F\x01\x00q\x01\x00\x00mH\x01\x00\x05\x01\x00\x00\xdfI\x01\x00\xdf\x01\x00\x00\xe5J\x01\x00\x1c\x01\x00\x00\xc5L\x01\x00\xc1\x01\x00\x00\xe2M\x01\x00\x1b\x02\x00\x00\xa4O\x01\x00\xc0\x00\x00\x00\xc0Q\x01\x00\xd5\x02\x00\x00\x81R\x01\x00\x9d\x00\x00\x00WU\x01\x00X\x00\x00\x00\xf5U\x01\x00%\x02\x00\x00NV\x01\x00o\x00\x00\x00tX\x01\x00u\x00\x00\x00\xe4X\x01\x00\x01\x01\x00\x00ZY\x01\x00v\x00\x00\x00\\Z\x01\x00t\x00\x00\x00\xd3Z\x01\x00\xef\x00\x00\x00H[\x01\x00}\x00\x00\x008\\\x01\x00j\x00\x00\x00\xb6\\\x01\x00\xc4\x01\x00\x00!]\x01\x00\xf7\x03\x00\x00\xe6^\x01\x00;\x00\x00\x00\xdeb\x01\x008\x00\x00\x00\x1ac\x01\x001\x00\x00\x00Sc\x01\x007\x00\x00\x00\x85c\x01\x00u\x02\x00\x00\xbdc\x01\x00\xb0\x00\x00\x003f\x01\x00[\x00\x00\x00\xe4f\x01\x00J\x00\x00\x00@g\x01\x00a\x00\x00\x00\x8bg\x01\x00\xbd\x00\x00\x00\xedg\x01\x009\x00\x00\x00\xabh\x01\x00\xc5\x00\x00\x00\xe5h\x01\x00\xae\x00\x00\x00\xabi\x01\x00\xd6\x00\x00\x00Zj\x01\x008\x00\x00\x001k\x01\x00%\x00\x00\x00jk\x01\x00W\x00\x00\x00\x90k\x01\x00\x1d\x00\x00\x00\xe8k\x01\x00=\x00\x00\x00\x06l\x01\x00u\x00\x00\x00Dl\x01\x004\x00\x00\x00\xbal\x01\x00-\x00\x00\x00\xefl\x01\x00\xa3\x00\x00\x00\x1dm\x01\x003\x00\x00\x00\xc1m\x01\x002\x00\x00\x00\xf5m\x01\x008\x00\x00\x00(n\x01\x00\x1e\x00\x00\x00an\x01\x00\x1a\x00\x00\x00\x80n\x01\x009\x00\x00\x00\x9bn\x01\x00\x13\x00\x00\x00\xd5n\x01\x00\x1b\x00\x00\x00\xe9n\x01\x00@\x00\x00\x00\x05o\x01\x00,\x00\x00\x00Fo\x01\x00*\x00\x00\x00so\x01\x007\x00\x00\x00\x9eo\x01\x00'\x00\x00\x00\xd6o\x01\x00&\x00\x00\x00\xfeo\x01\x00.\x00\x00\x00%p\x01\x00=\x00\x00\x00Tp\x01\x00*\x00\x00\x00\x92p\x01\x000\x00\x00\x00\xbdp\x01\x00,\x00\x00\x00\xeep\x01\x00\x1f\x00\x00\x00\x1bq\x01\x00]\x00\x00\x00;q\x01\x000\x00\x00\x00\x99q\x01\x000\x00\x00\x00\xcaq\x01\x00\"\x00\x00\x00\xfbq\x01\x00?\x00\x00\x00\x1er\x01\x00\x1d\x00\x00\x00^r\x01\x004\x00\x00\x00|r\x01\x003\x00\x00\x00\xb1r\x01\x00,\x00\x00\x00\xe5r\x01\x00\x14\x00\x00\x00\x12s\x01\x00*\x00\x00\x00's\x01\x00A\x00\x00\x00Rs\x01\x00\x1d\x00\x00\x00\x94s\x01\x00\x1c\x00\x00\x00\xb2s\x01\x00\x1a\x00\x00\x00\xcfs\x01\x00)\x00\x00\x00\xeas\x01\x006\x00\x00\x00\x14t\x01\x00\x1d\x00\x00\x00Kt\x01\x00\x19\x00\x00\x00it\x01\x00 \x00\x00\x00\x83t\x01\x00v\x00\x00\x00\xa4t\x01\x00(\x00\x00\x00\x1bu\x01\x00\x16\x00\x00\x00Du\x01\x00p\x00\x00\x00[u\x01\x00`\x00\x00\x00\xccu\x01\x00\x9b\x00\x00\x00-v\x01\x00\x97\x00\x00\x00\xc9v\x01\x00\xa8\x00\x00\x00aw\x01\x00\x1b\x00\x00\x00\nx\x01\x00\x18\x00\x00\x00&x\x01\x00\x1a\x00\x00\x00?x\x01\x00$\x00\x00\x00Zx\x01\x00\x1d\x00\x00\x00\u007fx\x01\x00\x17\x00\x00\x00\x9dx\x01\x00a\x00\x00\x00\xb5x\x01\x00s\x00\x00\x00\x17y\x01\x00B\x00\x00\x00\x8by\x01\x00Y\x00\x00\x00\xcey\x01\x00+\x00\x00\x00(z\x01\x00+\x00\x00\x00Tz\x01\x006\x00\x00\x00\x80z\x01\x00;\x00\x00\x00\xb7z\x01\x00q\x00\x00\x00\xf3z\x01\x00/\x00\x00\x00e{\x01\x001\x00\x00\x00\x95{\x01\x00'\x00\x00\x00\xc7{\x01\x00'\x00\x00\x00\xef{\x01\x00\x18\x00\x00\x00\x17|\x01\x00&\x00\x00\x000|\x01\x00%\x00\x00\x00W|\x01\x00(\x00\x00\x00}|\x01\x00#\x00\x00\x00\xa6|\x01\x00K\x00\x00\x00\xca|\x01\x00 \x00\x00\x00\x16}\x01\x00_\x00\x00\x007}\x01\x00\x1e\x00\x00\x00\x97}\x01\x00\"\x00\x00\x00\xb6}\x01\x00\"\x00\x00\x00\xd9}\x01\x00\x1f\x00\x00\x00\xfc}\x01\x00-\x00\x00\x00\x1c~\x01\x00-\x00\x00\x00J~\x01\x009\x00\x00\x00x~\x01\x00\x1e\x00\x00\x00\xb2~\x01\x00\x19\x00\x00\x00\xd1~\x01\x00c\x00\x00\x00\xeb~\x01\x00#\x00\x00\x00O\u007f\x01\x00\x82\x00\x00\x00s\u007f\x01\x00\x94\x00\x00\x00\xf6\u007f\x01\x00H\x00\x00\x00\x8b\x80\x01\x00&\x00\x00\x00\u0500\x01\x00e\x00\x00\x00\xfb\x80\x01\x00z\x00\x00\x00a\x81\x01\x00J\x00\x00\x00\u0701\x01\x00\xe5\x00\x00\x00'\x82\x01\x00W\x00\x00\x00\r\x83\x01\x00E\x00\x00\x00e\x83\x01\x00a\x00\x00\x00\xab\x83\x01\x00v\x00\x00\x00\r\x84\x01\x00\xcb\x00\x00\x00\x84\x84\x01\x00\xcf\x00\x00\x00P\x85\x01\x00\x1e\x01\x00\x00 \x86\x01\x00\x1c\x00\x00\x00?\x87\x01\x00T\x00\x00\x00\\\x87\x01\x00\x17\x00\x00\x00\xb1\x87\x01\x00/\x00\x00\x00\u0247\x01\x009\x00\x00\x00\xf9\x87\x01\x00\x1e\x00\x00\x003\x88\x01\x00=\x00\x00\x00R\x88\x01\x00$\x00\x00\x00\x90\x88\x01\x00\x1f\x00\x00\x00\xb5\x88\x01\x00&\x00\x00\x00\u0548\x01\x00+\x00\x00\x00\xfc\x88\x01\x00G\x00\x00\x00(\x89\x01\x00\x14\x00\x00\x00p\x89\x01\x00r\x00\x00\x00\x85\x89\x01\x00\x13\x00\x00\x00\xf8\x89\x01\x00\x18\x00\x00\x00\f\x8a\x01\x00/\x00\x00\x00%\x8a\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00^\x00\x00\x00\\\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\x00\x00\x00\xc4\x00\x00\x00\x0f\x00\x00\x00\xc3\x00\x00\x00\x00\x00\x00\x00-\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\xeb\x00\x00\x00c\x00\x00\x00\x00\x00\x00\x001\x00\x00\x00o\x00\x00\x00}\x00\x00\x00\x00\x00\x00\x00J\x00\x00\x00\x00\x00\x00\x00\xd8\x00\x00\x00\x98\x00\x00\x00U\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdb\x00\x00\x00\x17\x00\x00\x00u\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x8a\x00\x00\x00\xe8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc9\x00\x00\x00\xb7\x00\x00\x00\xd7\x00\x00\x00*\x00\x00\x00\x99\x00\x00\x00\x00\x00\x00\x00\x1f\x00\x00\x00\x84\x00\x00\x00\x9c\x00\x00\x00\xe6\x00\x00\x00\x9d\x00\x00\x00\xc5\x00\x00\x00\xd9\x00\x00\x00\xb9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x19\x00\x00\x00\xcd\x00\x00\x00\xcb\x00\x00\x00y\x00\x00\x00\x97\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00C\x00\x00\x00\x93\x00\x00\x00\xad\x00\x00\x00\xe1\x00\x00\x00\xa6\x00\x00\x00\xd0\x00\x00\x00r\x00\x00\x00+\x00\x00\x006\x00\x00\x00\xce\x00\x00\x00\xa5\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00h\x00\x00\x00\xa0\x00\x00\x00\x00\x00\x00\x00\xd1\x00\x00\x00\xde\x00\x00\x00;\x00\x00\x00\x00\x00\x00\x00\xe9\x00\x00\x00\xe7\x00\x00\x00G\x00\x00\x00\xe4\x00\x00\x00z\x00\x00\x00/\x00\x00\x00V\x00\x00\x00`\x00\x00\x00\xe3\x00\x00\x00!\x00\x00\x00~\x00\x00\x00\x00\x00\x00\x00\xe2\x00\x00\x00\xd3\x00\x00\x00\x88\x00\x00\x00l\x00\x00\x00s\x00\x00\x00g\x00\x00\x00\x05\x00\x00\x00\xc2\x00\x00\x00#\x00\x00\x00\x91\x00\x00\x00\x00\x00\x00\x00\xb1\x00\x00\x00\x00\x00\x00\x00\x90\x00\x00\x00\x13\x00\x00\x00S\x00\x00\x00\x00\x00\x00\x00$\x00\x00\x00\xc1\x00\x00\x00\xb5\x00\x00\x00X\x00\x00\x00m\x00\x00\x00\t\x00\x00\x00x\x00\x00\x00\xb8\x00\x00\x00\xbd\x00\x00\x00k\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<\x00\x00\x00E\x00\x00\x00\xbf\x00\x00\x00\xbc\x00\x00\x00\x00\x00\x00\x00:\x00\x00\x00\x82\x00\x00\x00\x81\x00\x00\x00&\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x00\x00[\x00\x00\x00\x00\x00\x00\x00e\x00\x00\x00\x04\x00\x00\x00>\x00\x00\x00I\x00\x00\x00\x94\x00\x00\x00\x8f\x00\x00\x00\x92\x00\x00\x00?\x00\x00\x00Y\x00\x00\x00\xda\x00\x00\x00\x15\x00\x00\x00\x00\x00\x00\x00'\x00\x00\x004\x00\x00\x00\xcc\x00\x00\x00\f\x00\x00\x005\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\xbb\x00\x00\x00\x00\x00\x00\x00\xa9\x00\x00\x00\x9e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00O\x00\x00\x00 \x00\x00\x00)\x00\x00\x00\xcf\x00\x00\x00\x00\x00\x00\x00\x1b\x00\x00\x00Z\x00\x00\x00\"\x00\x00\x00\x00\x00\x00\x00v\x00\x00\x00]\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00a\x00\x00\x00j\x00\x00\x008\x00\x00\x00\xa3\x00\x00\x00q\x00\x00\x00t\x00\x00\x00_\x00\x00\x00\x10\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\v\x00\x00\x00@\x00\x00\x00\xd2\x00\x00\x00,\x00\x00\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\xe5\x00\x00\x00\x00\x00\x00\x00\xc8\x00\x00\x00\x95\x00\x00\x00\x06\x00\x00\x00\xa8\x00\x00\x00\xae\x00\x00\x00\xa1\x00\x00\x00\x00\x00\x00\x00\xba\x00\x00\x00\x0e\x00\x00\x00{\x00\x00\x00\xa7\x00\x00\x00\x00\x00\x00\x00\xb6\x00\x00\x00i\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd5\x00\x00\x00L\x00\x00\x00\x00\x00\x00\x00\xea\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00w\x00\x00\x00\x12\x00\x00\x00=\x00\x00\x00\xaf\x00\x00\x00\a\x00\x00\x00\xdf\x00\x00\x00\xc0\x00\x00\x00N\x00\x00\x00%\x00\x00\x009\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00.\x00\x00\x00\x00\x00\x00\x00\u007f\x00\x00\x00\xbe\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00P\x00\x00\x00\xb3\x00\x00\x00\r\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00R\x00\x00\x00D\x00\x00\x00B\x00\x00\x00n\x00\x00\x00\x00\x00\x00\x00\xd6\x00\x00\x00\x83\x00\x00\x00\n\x00\x00\x00W\x00\x00\x00\x14\x00\x00\x00Q\x00\x00\x00\xd4\x00\x00\x00d\x00\x00\x00\xac\x00\x00\x00\x16\x00\x00\x00\x96\x00\x00\x00K\x00\x00\x002\x00\x00\x00\x1a\x00\x00\x00\xb4\x00\x00\x00f\x00\x00\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00A\x00\x00\x00\xc6\x00\x00\x00\x8c\x00\x00\x00\x9a\x00\x00\x00\b\x00\x00\x00\xab\x00\x00\x00M\x00\x00\x007\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\xdc\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x00\x00\x89\x00\x00\x00\x00\x00\x00\x00\xdd\x00\x00\x00\x8e\x00\x00\x00\xca\x00\x00\x00H\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x00\x00\x00\x00\x00\x00\x1c\x00\x00\x00\xb0\x00\x00\x00\x00\x00\x00\x00|\x00\x00\x003\x00\x00\x00T\x00\x00\x00\x87\x00\x00\x00b\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\xaa\x00\x00\x00\xa4\x00\x00\x00\x00\x00\x00\x00p\x00\x00\x00\xc7\x00\x00\x00\x8b\x00\x00\x00\x00\n\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the cluster-admin ClusterRole\n\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin ClusterRole\n\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a new configmap named my-config based on folder bar\n\t\t  kubectl create configmap my-config --from-file=path/to/bar\n\n\t\t  # Create a new configmap named my-config with specified keys instead of file basenames on disk\n\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1.txt --from-file=key2=/path/to/bar/file2.txt\n\n\t\t  # Create a new configmap named my-config with key1=config1 and key2=config2\n\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-literal=key2=config2\x00\n\t\t  # If you don't already have a .dockercfg file, you can create a dockercfg secret directly by using:\n\t\t  kubectl create secret docker-registry my-secret --docker-server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL\x00\n\t\t  # Show metrics for all nodes\n\t\t  kubectl top node\n\n\t\t  # Show metrics for a given node\n\t\t  kubectl top node NODE_NAME\x00\n\t\t# Apply the configuration in pod.json to a pod.\n\t\tkubectl apply -f ./pod.json\n\n\t\t# Apply the JSON passed into stdin to a pod.\n\t\tcat pod.json | kubectl apply -f -\n\n\t\t# Note: --prune is still in Alpha\n\t\t# Apply the configuration in manifest.yaml that matches label app=nginx and delete all the other resources that are not in the file and match label app=nginx.\n\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n\n\t\t# Apply the configuration in manifest.yaml and delete all the other configmaps that are not in the file.\n\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/ConfigMap\x00\n\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and 10, target CPU utilization specified so a default autoscaling policy will be used:\n\t\tkubectl autoscale deployment foo --min=2 --max=10\n\n\t\t# Auto scale a replication controller \"foo\", with the number of pods between 1 and 5, target CPU utilization at 80%:\n\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80\x00\n\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n\t\tkubectl convert -f pod.yaml\n\n\t\t# Convert the live state of the resource specified by 'pod.yaml' to the latest version\n\t\t# and print to stdout in json format.\n\t\tkubectl convert -f pod.yaml --local -o json\n\n\t\t# Convert all files under current directory to latest version and create them all.\n\t\tkubectl convert -f . | kubectl create -f -\x00\n\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods\n\n\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --resource=pods\n\n\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a new resourcequota named my-quota\n\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,replicationcontrollers=2,resourcequotas=1,secrets=5,persistentvolumeclaims=10\n\n\t\t# Create a new resourcequota named best-effort\n\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort\x00\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=rails label\n\t\t# and require at least one of them being available at any point in time.\n\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-available=1\n\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=nginx label\n\t\t# and require at least half of the pods selected to be available at any point in time.\n\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%\x00\n\t\t# Create a pod using the data in pod.json.\n\t\tkubectl create -f ./pod.json\n\n\t\t# Create a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl create -f -\n\n\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format then create the resource using the edited data.\n\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json\x00\n\t\t# Create a service for a replicated nginx, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rc nginx --port=80 --target-port=8000\n\n\t\t# Create a service for a replication controller identified by type and name specified in \"nginx-controller.yaml\", which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n\n\t\t# Create a service for a pod valid-pod, which serves on port 444 with the name \"frontend\"\n\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n\n\t\t# Create a second service based on the above service, exposing the container port 8443 as port 443 with the name \"nginx-https\"\n\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-https\n\n\t\t# Create a service for a replicated streaming application on port 4100 balancing UDP traffic and named 'video-stream'.\n\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-stream\n\n\t\t# Create a service for a replicated nginx using replica set, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rs nginx --port=80 --target-port=8000\n\n\t\t# Create a service for an nginx deployment, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose deployment nginx --port=80 --target-port=8000\x00\n\t\t# Delete a pod using the type and name specified in pod.json.\n\t\tkubectl delete -f ./pod.json\n\n\t\t# Delete a pod based on the type and name in the JSON passed into stdin.\n\t\tcat pod.json | kubectl delete -f -\n\n\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n\t\tkubectl delete pod,service baz foo\n\n\t\t# Delete pods and services with label name=myLabel.\n\t\tkubectl delete pods,services -l name=myLabel\n\n\t\t# Delete a pod with minimal delay\n\t\tkubectl delete pod foo --now\n\n\t\t# Force delete a pod on a dead node\n\t\tkubectl delete pod foo --grace-period=0 --force\n\n\t\t# Delete all pods\n\t\tkubectl delete pods --all\x00\n\t\t# Describe a node\n\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n\n\t\t# Describe a pod\n\t\tkubectl describe pods/nginx\n\n\t\t# Describe a pod identified by type and name in \"pod.json\"\n\t\tkubectl describe -f pod.json\n\n\t\t# Describe all pods\n\t\tkubectl describe pods\n\n\t\t# Describe pods by label name=myLabel\n\t\tkubectl describe po -l name=myLabel\n\n\t\t# Describe all pods managed by the 'frontend' replication controller (rc-created pods\n\t\t# get the name of the rc as a prefix in the pod the name).\n\t\tkubectl describe pods frontend\x00\n\t\t# Drain node \"foo\", even if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n\t\t$ kubectl drain foo --force\n\n\t\t# As above, but abort if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a grace period of 15 minutes.\n\t\t$ kubectl drain foo --grace-period=900\x00\n\t\t# Edit the service named 'docker-registry':\n\t\tkubectl edit svc/docker-registry\n\n\t\t# Use an alternative editor\n\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n\n\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n\t\tkubectl edit job.v1.batch/myjob -o json\n\n\t\t# Edit the deployment 'mydeployment' in YAML and save the modified config in its annotation:\n\t\tkubectl edit deployment/mydeployment -o yaml --save-config\x00\n\t\t# Get output from running 'date' from pod 123456-7890, using the first container by default\n\t\tkubectl exec 123456-7890 date\n\n\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n\t\tkubectl exec 123456-7890 -c ruby-container date\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il\x00\n\t\t# Get output from running pod 123456-7890, using the first container by default\n\t\tkubectl attach 123456-7890\n\n\t\t# Get output from ruby-container from pod 123456-7890\n\t\tkubectl attach 123456-7890 -c ruby-container\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n\n\t\t# Get output from the first pod of a ReplicaSet named nginx\n\t\tkubectl attach rs/nginx\n\t\t\x00\n\t\t# Get the documentation of the resource and its fields\n\t\tkubectl explain pods\n\n\t\t# Get the documentation of a specific field of a resource\n\t\tkubectl explain pods.spec.containers\x00\n\t\t# Install bash completion on a Mac using homebrew\n\t\tbrew install bash-completion\n\t\tprintf \"\n# Bash completion support\nsource $(brew --prefix)/etc/bash_completion\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for bash into the current shell\n\t\tsource <(kubectl completion bash)\n\n\t\t# Write bash completion code to a file and source if from .bash_profile\n\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n\t\tprintf \"\n# Kubectl shell completion\nsource '$HOME/.kube/completion.bash.inc'\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for zsh[1] into the current shell\n\t\tsource <(kubectl completion zsh)\x00\n\t\t# List all pods in ps output format.\n\t\tkubectl get pods\n\n\t\t# List all pods in ps output format with more information (such as node name).\n\t\tkubectl get pods -o wide\n\n\t\t# List a single replication controller with specified NAME in ps output format.\n\t\tkubectl get replicationcontroller web\n\n\t\t# List a single pod in JSON output format.\n\t\tkubectl get -o json pod web-pod-13je7\n\n\t\t# List a pod identified by type and name specified in \"pod.yaml\" in JSON output format.\n\t\tkubectl get -f pod.yaml -o json\n\n\t\t# Return only the phase value of the specified pod.\n\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n\n\t\t# List all replication controllers and services together in ps output format.\n\t\tkubectl get rc,services\n\n\t\t# List one or more resources by their type and names.\n\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n\n\t\t# List all resources with different types.\n\t\tkubectl get all\x00\n\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports 5000 and 6000 in the pod\n\t\tkubectl port-forward mypod 5000 6000\n\n\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 8888:5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod :5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 0:5000\x00\n\t\t# Mark node \"foo\" as schedulable.\n\t\t$ kubectl uncordon foo\x00\n\t\t# Mark node \"foo\" as unschedulable.\n\t\tkubectl cordon foo\x00\n\t\t# Partially update a node using strategic merge patch\n\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Partially update a node identified by the type and name specified in \"node.json\" using strategic merge patch\n\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Update a container's image; spec.containers[*].name is required because it's a merge key\n\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n\n\t\t# Update a container's image using a json patch with positional arrays\n\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", \"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'\x00\n\t\t# Print flags inherited by all commands\n\t\tkubectl options\x00\n\t\t# Print the address of the master and cluster services\n\t\tkubectl cluster-info\x00\n\t\t# Print the client and server versions for the current context\n\t\tkubectl version\x00\n\t\t# Print the supported API versions\n\t\tkubectl api-versions\x00\n\t\t# Replace a pod using the data in pod.json.\n\t\tkubectl replace -f ./pod.json\n\n\t\t# Replace a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl replace -f -\n\n\t\t# Update a single-container pod's image version (tag) to v4\n\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/\x01:v4/' | kubectl replace -f -\n\n\t\t# Force replace, delete and then re-create the resource\n\t\tkubectl replace --force -f ./pod.json\x00\n\t\t# Return snapshot logs from pod nginx with only one container\n\t\tkubectl logs nginx\n\n\t\t# Return snapshot logs for the pods defined by label app=nginx\n\t\tkubectl logs -lapp=nginx\n\n\t\t# Return snapshot of previous terminated ruby container logs from pod web-1\n\t\tkubectl logs -p -c ruby web-1\n\n\t\t# Begin streaming the logs of the ruby container in pod web-1\n\t\tkubectl logs -f -c ruby web-1\n\n\t\t# Display only the most recent 20 lines of output in pod nginx\n\t\tkubectl logs --tail=20 nginx\n\n\t\t# Show all logs from pod nginx written in the last hour\n\t\tkubectl logs --since=1h nginx\n\n\t\t# Return snapshot logs from first container of a job named hello\n\t\tkubectl logs job/hello\n\n\t\t# Return snapshot logs from container nginx-1 of a deployment named nginx\n\t\tkubectl logs deployment/nginx -c nginx-1\x00\n\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static content from ./local/www/\n\t\tkubectl proxy --port=8011 --www=./local/www/\n\n\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n\t\t# The chosen port for the server will be output to stdout.\n\t\tkubectl proxy --port=0\n\n\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-api\n\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/pods/\n\t\tkubectl proxy --api-prefix=/k8s-api\x00\n\t\t# Scale a replicaset named 'foo' to 3.\n\t\tkubectl scale --replicas=3 rs/foo\n\n\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" to 3.\n\t\tkubectl scale --replicas=3 -f foo.yaml\n\n\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n\n\t\t# Scale multiple replication controllers.\n\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n\n\t\t# Scale job named 'cron' to 3.\n\t\tkubectl scale --replicas=3 job/cron\x00\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file.\n\t\tkubectl apply set-last-applied -f deploy.yaml\n\n\t\t# Execute set-last-applied against each configuration file in a directory.\n\t\tkubectl apply set-last-applied -f path/\n\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file, will create the annotation if it does not already exist.\n\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n\t\t\x00\n\t\t# Show metrics for all pods in the default namespace\n\t\tkubectl top pod\n\n\t\t# Show metrics for all pods in the given namespace\n\t\tkubectl top pod --namespace=NAMESPACE\n\n\t\t# Show metrics for a given pod and its containers\n\t\tkubectl top pod POD_NAME --containers\n\n\t\t# Show metrics for the pods defined by label name=myLabel\n\t\tkubectl top pod -l name=myLabel\x00\n\t\t# Shut down foo.\n\t\tkubectl stop replicationcontroller foo\n\n\t\t# Stop pods and services with label name=myLabel.\n\t\tkubectl stop pods,services -l name=myLabel\n\n\t\t# Shut down the service defined in service.json\n\t\tkubectl stop -f service.json\n\n\t\t# Shut down all resources in the path/to/resources directory\n\t\tkubectl stop -f path/to/resources\x00\n\t\t# Start a single instance of nginx.\n\t\tkubectl run nginx --image=nginx\n\n\t\t# Start a single instance of hazelcast and let the container expose port 5701 .\n\t\tkubectl run hazelcast --image=hazelcast --port=5701\n\n\t\t# Start a single instance of hazelcast and set environment variables \"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --env=\"POD_NAMESPACE=default\"\n\n\t\t# Start a replicated instance of nginx.\n\t\tkubectl run nginx --image=nginx --replicas=5\n\n\t\t# Dry run. Print the corresponding API objects without creating them.\n\t\tkubectl run nginx --image=nginx --dry-run\n\n\t\t# Start a single instance of nginx, but overload the spec of the deployment with a partial set of values parsed from JSON.\n\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", \"spec\": { ... } }'\n\n\t\t# Start a pod of busybox and keep it in the foreground, don't restart it if it exits.\n\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n\n\t\t# Start the nginx container using the default command, but use custom arguments (arg1 .. argN) for that command.\n\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n\n\t\t# Start the nginx container using a different command and custom arguments.\n\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n\n\t\t# Start the perl container to compute \u03c0 to 2000 places and print it out.\n\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\n\n\t\t# Start the cron job to compute \u03c0 to 2000 places and print it out every 5 minutes.\n\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\x00\n\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-user' and effect 'NoSchedule'.\n\t\t# If a taint with that key and effect already exists, its value is replaced as specified.\n\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n\n\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect 'NoSchedule' if one exists.\n\t\tkubectl taint nodes foo dedicated:NoSchedule-\n\n\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n\t\tkubectl taint nodes foo dedicated-\x00\n\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n\t\tkubectl label pods foo unhealthy=true\n\n\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', overwriting any existing value.\n\t\tkubectl label --overwrite pods foo status=unhealthy\n\n\t\t# Update all pods in the namespace\n\t\tkubectl label pods --all status=unhealthy\n\n\t\t# Update a pod identified by the type and name in \"pod.json\"\n\t\tkubectl label -f pod.json status=unhealthy\n\n\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n\t\tkubectl label pods foo status=unhealthy --resource-version=1\n\n\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n\t\t# Does not require the --overwrite flag.\n\t\tkubectl label pods foo bar-\x00\n\t\t# Update pods of frontend-v1 using new replication controller data in frontend-v2.json.\n\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n\n\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n\n\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the image, and switching the\n\t\t# name of the replication controller.\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n\n\t\t# Update the pods of frontend by just changing the image, and keeping the old name.\n\t\tkubectl rolling-update frontend --image=image:v2\n\n\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to frontend-v2).\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback\x00\n\t\t# View the last-applied-configuration annotations by type/name in YAML.\n\t\tkubectl apply view-last-applied deployment/nginx\n\n\t\t# View the last-applied-configuration annotations by file in JSON\n\t\tkubectl apply view-last-applied -f deploy.yaml -o json\x00\n\t\tApply a configuration to a resource by filename or stdin.\n\t\tThis resource will be created if it doesn't exist yet.\n\t\tTo use 'apply', always create the resource initially with either 'apply' or 'create --save-config'.\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not use unless you are aware of what the current state is. See https://issues.k8s.io/34274.\x00\n\t\tConvert config files between different API versions. Both YAML\n\t\tand JSON formats are accepted.\n\n\t\tThe command takes filename, directory, or URL as input, and convert it into format\n\t\tof version specified by --output-version flag. If target version is not specified or\n\t\tnot supported, convert to latest version.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change to output destination.\x00\n\t\tCreate a ClusterRole.\x00\n\t\tCreate a ClusterRoleBinding for a particular ClusterRole.\x00\n\t\tCreate a RoleBinding for a particular Role or ClusterRole.\x00\n\t\tCreate a TLS secret from the given public/private key pair.\n\n\t\tThe public/private key pair must exist before hand. The public key certificate must be .PEM encoded and match the given private key.\x00\n\t\tCreate a configmap based on a file, directory, or specified literal value.\n\n\t\tA single configmap may package one or more key/value pairs.\n\n\t\tWhen creating a configmap based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a configmap based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the configmap.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a namespace with the specified name.\x00\n\t\tCreate a new secret for use with Docker registries.\n\n\t\tDockercfg secrets are used to authenticate against Docker registries.\n\n\t\tWhen using the Docker command line to push images, you can authenticate to a given registry by running\n\n\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n\n    That produces a ~/.dockercfg file that is used by subsequent 'docker push' and 'docker pull' commands to\n\t\tauthenticate to the registry. The email address is optional.\n\n\t\tWhen creating applications, you may have a Docker registry that requires authentication.  In order for the\n\t\tnodes to pull images on your behalf, they have to have the credentials.  You can provide this information\n\t\tby creating a dockercfg secret and attaching it to your service account.\x00\n\t\tCreate a pod disruption budget with the specified name, selector, and desired minimum available pods\x00\n\t\tCreate a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted.\x00\n\t\tCreate a resourcequota with the specified name, hard limits and optional scopes\x00\n\t\tCreate a role with single rule.\x00\n\t\tCreate a secret based on a file, directory, or specified literal value.\n\n\t\tA single secret may package one or more key/value pairs.\n\n\t\tWhen creating a secret based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a secret based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the secret.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a service account with the specified name.\x00\n\t\tCreate and run a particular image, possibly replicated.\n\n\t\tCreates a deployment or job to manage the created container(s).\x00\n\t\tCreates an autoscaler that automatically chooses and sets the number of pods that run in a kubernetes cluster.\n\n\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and creates an autoscaler that uses the given resource as a reference.\n\t\tAn autoscaler can automatically increase or decrease number of pods deployed within the system as needed.\x00\n\t\tDelete resources by filenames, stdin, resources and names, or by resources and label selector.\n\n\t\tJSON and YAML formats are accepted. Only one type of the arguments may be specified: filenames,\n\t\tresources and names, or resources and label selector.\n\n\t\tSome resources, such as pods, support graceful deletion. These resources define a default period\n\t\tbefore they are forcibly terminated (the grace period) but you may override that value with\n\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. Because these resources often\n\t\trepresent entities in the cluster, deletion may not be acknowledged immediately. If the node\n\t\thosting a pod is down or cannot reach the API server, termination may take significantly longer\n\t\tthan the grace period. To force delete a resource,\tyou must pass a grace\tperiod of 0 and specify\n\t\tthe --force flag.\n\n\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the pod's processes have been\n\t\tterminated, which can leave those processes running until the node detects the deletion and\n\t\tcompletes graceful deletion. If your processes use shared storage or talk to a remote API and\n\t\tdepend on the name of the pod to identify themselves, force deleting those pods may result in\n\t\tmultiple processes running on different machines using the same identification which may lead\n\t\tto data corruption or inconsistency. Only force delete pods when you are sure the pod is\n\t\tterminated, or if your application can tolerate multiple copies of the same pod running at once.\n\t\tAlso, if you force delete pods the scheduler may place new pods on those nodes before the node\n\t\thas released those resources and causing those pods to be evicted immediately.\n\n\t\tNote that the delete command does NOT do resource version checks, so if someone\n\t\tsubmits an update to a resource right when you submit a delete, their update\n\t\twill be lost along with the rest of the resource.\x00\n\t\tDeprecated: Gracefully shut down a resource by name or filename.\n\n\t\tThe stop command is deprecated, all its functionalities are covered by delete command.\n\t\tSee 'kubectl delete --help' for more details.\n\n\t\tAttempts to shut down and delete a resource that supports graceful termination.\n\t\tIf the resource is scalable it will be scaled to 0 before deletion.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n\n\t\tThe top-node command allows you to see the resource consumption of nodes.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n\n\t\tThe 'top pod' command allows you to see the resource consumption of pods.\n\n\t\tDue to the metrics pipeline delay, they may be unavailable for a few minutes\n\t\tsince pod creation.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage.\n\n\t\tThe top command allows you to see the resource consumption for nodes or pods.\n\n\t\tThis command requires Heapster to be correctly configured and working on the server. \x00\n\t\tDrain node in preparation for maintenance.\n\n\t\tThe given node will be marked unschedulable to prevent new pods from arriving.\n\t\t'drain' evicts the pods if the APIServer supports eviction\n\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use normal DELETE\n\t\tto delete the pods.\n\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot be deleted through\n\t\tthe API server).  If there are DaemonSet-managed pods, drain will not proceed\n\t\twithout --ignore-daemonsets, and regardless it will not delete any\n\t\tDaemonSet-managed pods, because those pods would be immediately replaced by the\n\t\tDaemonSet controller, which ignores unschedulable markings.  If there are any\n\t\tpods that are neither mirror pods nor managed by ReplicationController,\n\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete any pods unless you\n\t\tuse --force.  --force will also allow deletion to proceed if the managing resource of one\n\t\tor more pods is missing.\n\n\t\t'drain' waits for graceful termination. You should not operate on the machine until\n\t\tthe command completes.\n\n\t\tWhen you are ready to put the node back into service, use kubectl uncordon, which\n\t\twill make the node schedulable again.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)\x00\n\t\tEdit a resource from the default editor.\n\n\t\tThe edit command allows you to directly edit any API resource you can retrieve via the\n\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, or EDITOR\n\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for Windows.\n\t\tYou can edit multiple objects, although changes are applied one at a time. The command\n\t\taccepts filenames as well as command line arguments, although the files you point to must\n\t\tbe previously saved versions of resources.\n\n\t\tEditing is done with the API version used to fetch the resource.\n\t\tTo edit using a specific API version, fully-qualify the resource, version, and group.\n\n\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n\n\t\tThe flag --windows-line-endings can be used to force Windows line endings,\n\t\totherwise the default for your operating system will be used.\n\n\t\tIn the event an error occurs while updating, a temporary file will be created on disk\n\t\tthat contains your unapplied changes. The most common error when updating a resource\n\t\tis another editor changing the resource on the server. When this occurs, you will have\n\t\tto apply your changes to the newer version of the resource, or update your temporary\n\t\tsaved copy to include the latest resource version.\x00\n\t\tMark node as schedulable.\x00\n\t\tMark node as unschedulable.\x00\n\t\tOutput shell completion code for the specified shell (bash or zsh).\n\t\tThe shell code must be evalutated to provide interactive\n\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n\t\tthe .bash_profile.\n\n\t\tNote: this requires the bash-completion framework, which is not installed\n\t\tby default on Mac.  This can be installed by using homebrew:\n\n\t\t    $ brew install bash-completion\n\n\t\tOnce installed, bash_completion must be evaluated.  This can be done by adding the\n\t\tfollowing line to the .bash_profile\n\n\t\t    $ source $(brew --prefix)/etc/bash_completion\n\n\t\tNote for zsh users: [1] zsh completions are only supported in versions of zsh >= 5.2\x00\n\t\tPerform a rolling update of the given ReplicationController.\n\n\t\tReplaces the specified replication controller with a new replication controller by updating one pod at a time to use the\n\t\tnew PodTemplate. The new-controller.json must specify the same namespace as the\n\t\texisting replication controller and overwrite at least one (common) label in its replicaSelector.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)\x00\n\t\tReplace a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted. If replacing an existing resource, the\n\t\tcomplete resource spec must be provided. This can be obtained by\n\n\t\t    $ kubectl get TYPE NAME -o yaml\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or Job.\n\n\t\tScale also allows users to specify one or more preconditions for the scale action.\n\n\t\tIf --current-replicas or --resource-version is specified, it is validated before the\n\t\tscale is attempted, and it is guaranteed that the precondition holds true when the\n\t\tscale is sent to the server.\x00\n\t\tSet the latest last-applied-configuration annotations by setting it to match the contents of a file.\n\t\tThis results in the last-applied-configuration being updated as though 'kubectl apply -f <file>' was run,\n\t\twithout updating any other parts of the object.\x00\n\t\tTo proxy all of the kubernetes api and nothing else, use:\n\n\t\t    $ kubectl proxy --api-prefix=/\n\n\t\tTo proxy only part of the kubernetes api and also some static files:\n\n\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/api/\n\n\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n\n\t\tTo proxy the entire kubernetes api at a different root, use:\n\n\t\t    $ kubectl proxy --api-prefix=/custom/\n\n\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'\x00\n\t\tUpdate field(s) of a resource using strategic merge patch\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tUpdate the labels on a resource.\n\n\t\t* A label must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* If --overwrite is true, then existing labels can be overwritten, otherwise attempting to overwrite a label will result in an error.\n\t\t* If --resource-version is specified, then updates will use this resource version, otherwise the existing resource-version will be used.\x00\n\t\tUpdate the taints on one or more nodes.\n\n\t\t* A taint consists of a key, value, and effect. As an argument here, it is expressed as key=value:effect.\n\t\t* The key must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* The value must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[2]d characters.\n\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n\t\t* Currently taint can only apply to node.\x00\n\t\tView the latest last-applied-configuration annotations by type/name or file.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change output format.\x00\n\t    # !!!Important Note!!!\n\t    # Requires that the 'tar' binary is present in your container\n\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n\n\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in the default namespace\n\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n\n        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific container\n\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n\n\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace <some-namespace>\n\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n\n\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar\x00\n\t  # Create a new TLS secret named tls-secret with the given key pair:\n\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/to/tls.key\x00\n\t  # Create a new namespace named my-namespace\n\t  kubectl create namespace my-namespace\x00\n\t  # Create a new secret named my-secret with keys for each file in folder bar\n\t  kubectl create secret generic my-secret --from-file=path/to/bar\n\n\t  # Create a new secret named my-secret with specified keys instead of names on disk\n\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/.ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n\n\t  # Create a new secret named my-secret with key1=supersecret and key2=topsecret\n\t  kubectl create secret generic my-secret --from-literal=key1=supersecret --from-literal=key2=topsecret\x00\n\t  # Create a new service account named my-service-account\n\t  kubectl create serviceaccount my-service-account\x00\n\t# Create a new ExternalName service named my-ns \n\tkubectl create service externalname my-ns --external-name bar.com\x00\n\tCreate an ExternalName service with the specified name.\n\n\tExternalName service references to an external DNS address instead of\n\tonly pods, which will allow application authors to reference services\n\tthat exist off platform, on other clusters, or locally.\x00\n\tHelp provides help for any command in the application.\n\tSimply type kubectl help [path to command] for full details.\x00\n    # Create a new LoadBalancer service named my-lbs\n    kubectl create service loadbalancer my-lbs --tcp=5678:8080\x00\n    # Create a new clusterIP service named my-cs\n    kubectl create service clusterip my-cs --tcp=5678:8080\n\n    # Create a new clusterIP service named my-cs (in headless mode)\n    kubectl create service clusterip my-cs --clusterip=\"None\"\x00\n    # Create a new deployment named my-dep that runs the busybox image.\n    kubectl create deployment my-dep --image=busybox\x00\n    # Create a new nodeport service named my-ns\n    kubectl create service nodeport my-ns --tcp=5678:8080\x00\n    # Dump current cluster state to stdout\n    kubectl cluster-info dump\n\n    # Dump current cluster state to /path/to/cluster-state\n    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n\n    # Dump all namespaces to stdout\n    kubectl cluster-info dump --all-namespaces\n\n    # Dump a set of namespaces to /path/to/cluster-state\n    kubectl cluster-info dump --namespaces default,kube-system --output-directory=/path/to/cluster-state\x00\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend'.\n    # If the same annotation is set multiple times, only the last value will be applied\n    kubectl annotate pods foo description='my frontend'\n\n    # Update a pod identified by type and name in \"pod.json\"\n    kubectl annotate -f pod.json description='my frontend'\n\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend running nginx', overwriting any existing value.\n    kubectl annotate --overwrite pods foo description='my frontend running nginx'\n\n    # Update all pods in the namespace\n    kubectl annotate pods --all description='my frontend running nginx'\n\n    # Update pod 'foo' only if the resource is unchanged from version 1.\n    kubectl annotate pods foo description='my frontend running nginx' --resource-version=1\n\n    # Update pod 'foo' by removing an annotation named 'description' if it exists.\n    # Does not require the --overwrite flag.\n    kubectl annotate pods foo description-\x00\n    Create a LoadBalancer service with the specified name.\x00\n    Create a clusterIP service with the specified name.\x00\n    Create a deployment with the specified name.\x00\n    Create a nodeport service with the specified name.\x00\n    Dumps cluster info out suitable for debugging and diagnosing cluster problems.  By default, dumps everything to\n    stdout. You can optionally specify a directory with --output-directory.  If you specify a directory, kubernetes will\n    build a set of files in that directory.  By default only dumps things in the 'kube-system' namespace, but you can\n    switch to a different namespace with the --namespaces flag, or specify --all-namespaces to dump all namespaces.\n\n    The command also dumps the logs of all of the pods in the cluster, these logs are dumped into different directories\n    based on namespace and pod name.\x00\n  Display addresses of the master and services with label kubernetes.io/cluster-service=true\n  To further debug and diagnose cluster problems, use 'kubectl cluster-info dump'.\x00A comma-delimited set of quota scopes that must all match each object tracked by the quota.\x00A comma-delimited set of resource=quantity pairs that define a hard limit.\x00A label selector to use for this budget. Only equality-based selector requirements are supported.\x00A label selector to use for this service. Only equality-based selector requirements are supported. If empty (the default) infer the selector from the replication controller or replica set.)\x00A schedule in the Cron format the job should be run with.\x00Additional external IP address (not managed by Kubernetes) to accept for the service. If this IP is routed to a node, the service can be accessed by this IP in addition to its generated service IP.\x00An inline JSON override for the generated object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.\x00An inline JSON override for the generated service object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.  Only used if --expose is true.\x00Apply a configuration to a resource by filename or stdin\x00Approve a certificate signing request\x00Assign your own ClusterIP or set to 'None' for a 'headless' service (no loadbalancing).\x00Attach to a running container\x00Auto-scale a Deployment, ReplicaSet, or ReplicationController\x00ClusterIP to be assigned to the service. Leave empty to auto-allocate, or set to 'None' to create a headless service.\x00ClusterRole this ClusterRoleBinding should reference\x00ClusterRole this RoleBinding should reference\x00Container name which will have its image upgraded. Only relevant when --image is specified, ignored otherwise. Required when using --image on a multi-container pod\x00Convert config files between different API versions\x00Copy files and directories to and from containers.\x00Create a ClusterRoleBinding for a particular ClusterRole\x00Create a LoadBalancer service.\x00Create a NodePort service.\x00Create a RoleBinding for a particular Role or ClusterRole\x00Create a TLS secret\x00Create a clusterIP service.\x00Create a configmap from a local file, directory or literal value\x00Create a deployment with the specified name.\x00Create a namespace with the specified name\x00Create a pod disruption budget with the specified name.\x00Create a quota with the specified name.\x00Create a resource by filename or stdin\x00Create a secret for use with a Docker registry\x00Create a secret from a local file, directory or literal value\x00Create a secret using specified subcommand\x00Create a service account with the specified name\x00Create a service using specified subcommand.\x00Create an ExternalName service.\x00Delete resources by filenames, stdin, resources and names, or by resources and label selector\x00Delete the specified cluster from the kubeconfig\x00Delete the specified context from the kubeconfig\x00Deny a certificate signing request\x00Deprecated: Gracefully shut down a resource by name or filename\x00Describe one or many contexts\x00Display Resource (CPU/Memory/Storage) usage of nodes\x00Display Resource (CPU/Memory/Storage) usage of pods\x00Display Resource (CPU/Memory/Storage) usage.\x00Display cluster info\x00Display clusters defined in the kubeconfig\x00Display merged kubeconfig settings or a specified kubeconfig file\x00Display one or many resources\x00Displays the current-context\x00Documentation of resources\x00Drain node in preparation for maintenance\x00Dump lots of relevant info for debugging and diagnosis\x00Edit a resource on the server\x00Email for Docker registry\x00Execute a command in a container\x00Explicit policy for when to pull container images. Required when --image is same as existing image, ignored otherwise.\x00Forward one or more local ports to a pod\x00Help about any command\x00IP to assign to the Load Balancer. If empty, an ephemeral IP will be created and used (cloud-provider specific).\x00If non-empty, set the session affinity for the service to this; legal values: 'None', 'ClientIP'\x00If non-empty, the annotation update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00If non-empty, the labels update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00Image to use for upgrading the replication controller. Must be distinct from the existing image (either new image or new image tag).  Can not be used with --filename/-f\x00Manage a deployment rollout\x00Mark node as schedulable\x00Mark node as unschedulable\x00Mark the provided resource as paused\x00Modify certificate resources.\x00Modify kubeconfig files\x00Name or number for the port on the container that the service should direct traffic to. Optional.\x00Only return logs after a specific date (RFC3339). Defaults to all logs. Only one of since-time / since may be used.\x00Output shell completion code for the specified shell (bash or zsh)\x00Output the formatted object with the given group version (for ex: 'extensions/v1beta1').)\x00Password for Docker registry authentication\x00Path to PEM encoded public key certificate.\x00Path to private key associated with given certificate.\x00Perform a rolling update of the given ReplicationController\x00Precondition for resource version. Requires that the current resource version match this value in order to scale.\x00Print the client and server version information\x00Print the list of flags inherited by all commands\x00Print the logs for a container in a pod\x00Replace a resource by filename or stdin\x00Resume a paused resource\x00Role this RoleBinding should reference\x00Run a particular image on the cluster\x00Run a proxy to the Kubernetes API server\x00Server location for Docker registry\x00Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job\x00Set specific features on objects\x00Set the last-applied-configuration annotation on a live object to match the contents of a file.\x00Set the selector on a resource\x00Sets a cluster entry in kubeconfig\x00Sets a context entry in kubeconfig\x00Sets a user entry in kubeconfig\x00Sets an individual value in a kubeconfig file\x00Sets the current-context in a kubeconfig file\x00Show details of a specific resource or group of resources\x00Show the status of the rollout\x00Synonym for --target-port\x00Take a replication controller, service, deployment or pod and expose it as a new Kubernetes Service\x00The image for the container to run.\x00The image pull policy for the container. If left empty, this value will not be specified by the client and defaulted by the server\x00The key to use to differentiate between two different controllers, default 'deployment'.  Only relevant when --image is specified, ignored otherwise\x00The minimum number or percentage of available pods this budget requires.\x00The name for the newly created object.\x00The name for the newly created object. If not specified, the name of the input resource will be used.\x00The name of the API generator to use, see http://kubernetes.io/docs/user-guide/kubectl-conventions/#generators for a list.\x00The name of the API generator to use. Currently there is only 1 generator.\x00The name of the API generator to use. There are 2 generators: 'service/v1' and 'service/v2'. The only difference between them is that service port in v1 is named 'default', while it is left unnamed in v2. Default is 'service/v2'.\x00The name of the generator to use for creating a service.  Only used if --expose is true\x00The network protocol for the service to be created. Default is 'TCP'.\x00The port that the service should serve on. Copied from the resource being exposed, if unspecified\x00The port that this container exposes.  If --expose is true, this is also the port used by the service that is created.\x00The resource requirement limits for this container.  For example, 'cpu=200m,memory=512Mi'.  Note that server side components may assign limits depending on the server configuration, such as limit ranges.\x00The resource requirement requests for this container.  For example, 'cpu=100m,memory=256Mi'.  Note that server side components may assign requests depending on the server configuration, such as limit ranges.\x00The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  If set to 'Always' a deployment is created, if set to 'OnFailure' a job is created, if set to 'Never', a regular pod is created. For the latter two --replicas must be 1.  Default 'Always', for CronJobs `Never`.\x00The type of secret to create\x00Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is 'ClusterIP'.\x00Undo a previous rollout\x00Unsets an individual value in a kubeconfig file\x00Update field(s) of a resource using strategic merge patch\x00Update image of a pod template\x00Update resource requests/limits on objects with pod templates\x00Update the annotations on a resource\x00Update the labels on a resource\x00Update the taints on one or more nodes\x00Username for Docker registry authentication\x00View latest last-applied-configuration annotations of a resource/object\x00View rollout history\x00Where to output the files.  If empty or '-' uses stdout, otherwise creates a directory hierarchy in that directory\x00dummy restart flag)\x00external name of service\x00kubectl controls the Kubernetes cluster manager\x00Project-Id-Version: gettext-go-examples-hello\nReport-Msgid-Bugs-To: EMAIL\nPOT-Creation-Date: 2017-03-14 21:32-0700\nPO-Revision-Date: 2017-05-24 18:01+0800\nLast-Translator: Brendan Burns <brendan.d.burns@gmail.com>\nLanguage-Team: \nLanguage: en\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 8bit\nX-Generator: Poedit 1.8.12\nX-Poedit-SourceCharset: UTF-8\nPlural-Forms: nplurals=2; plural=(n != 1);\n\x00\n\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the cluster-admin ClusterRole\n\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin ClusterRole\n\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a new configmap named my-config based on folder bar\n\t\t  kubectl create configmap my-config --from-file=path/to/bar\n\n\t\t  # Create a new configmap named my-config with specified keys instead of file basenames on disk\n\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1.txt --from-file=key2=/path/to/bar/file2.txt\n\n\t\t  # Create a new configmap named my-config with key1=config1 and key2=config2\n\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-literal=key2=config2\x00\n\t\t  # If you don't already have a .dockercfg file, you can create a dockercfg secret directly by using:\n\t\t  kubectl create secret docker-registry my-secret --docker-server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL\x00\n\t\t  # Show metrics for all nodes\n\t\t  kubectl top node\n\n\t\t  # Show metrics for a given node\n\t\t  kubectl top node NODE_NAME\x00\n\t\t# Apply the configuration in pod.json to a pod.\n\t\tkubectl apply -f ./pod.json\n\n\t\t# Apply the JSON passed into stdin to a pod.\n\t\tcat pod.json | kubectl apply -f -\n\n\t\t# Note: --prune is still in Alpha\n\t\t# Apply the configuration in manifest.yaml that matches label app=nginx and delete all the other resources that are not in the file and match label app=nginx.\n\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n\n\t\t# Apply the configuration in manifest.yaml and delete all the other configmaps that are not in the file.\n\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/ConfigMap\x00\n\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and 10, target CPU utilization specified so a default autoscaling policy will be used:\n\t\tkubectl autoscale deployment foo --min=2 --max=10\n\n\t\t# Auto scale a replication controller \"foo\", with the number of pods between 1 and 5, target CPU utilization at 80%:\n\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80\x00\n\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n\t\tkubectl convert -f pod.yaml\n\n\t\t# Convert the live state of the resource specified by 'pod.yaml' to the latest version\n\t\t# and print to stdout in json format.\n\t\tkubectl convert -f pod.yaml --local -o json\n\n\t\t# Convert all files under current directory to latest version and create them all.\n\t\tkubectl convert -f . | kubectl create -f -\x00\n\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods\n\n\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --resource=pods\n\n\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a new resourcequota named my-quota\n\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,replicationcontrollers=2,resourcequotas=1,secrets=5,persistentvolumeclaims=10\n\n\t\t# Create a new resourcequota named best-effort\n\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort\x00\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=rails label\n\t\t# and require at least one of them being available at any point in time.\n\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-available=1\n\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=nginx label\n\t\t# and require at least half of the pods selected to be available at any point in time.\n\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%\x00\n\t\t# Create a pod using the data in pod.json.\n\t\tkubectl create -f ./pod.json\n\n\t\t# Create a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl create -f -\n\n\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format then create the resource using the edited data.\n\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json\x00\n\t\t# Create a service for a replicated nginx, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rc nginx --port=80 --target-port=8000\n\n\t\t# Create a service for a replication controller identified by type and name specified in \"nginx-controller.yaml\", which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n\n\t\t# Create a service for a pod valid-pod, which serves on port 444 with the name \"frontend\"\n\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n\n\t\t# Create a second service based on the above service, exposing the container port 8443 as port 443 with the name \"nginx-https\"\n\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-https\n\n\t\t# Create a service for a replicated streaming application on port 4100 balancing UDP traffic and named 'video-stream'.\n\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-stream\n\n\t\t# Create a service for a replicated nginx using replica set, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rs nginx --port=80 --target-port=8000\n\n\t\t# Create a service for an nginx deployment, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose deployment nginx --port=80 --target-port=8000\x00\n\t\t# Delete a pod using the type and name specified in pod.json.\n\t\tkubectl delete -f ./pod.json\n\n\t\t# Delete a pod based on the type and name in the JSON passed into stdin.\n\t\tcat pod.json | kubectl delete -f -\n\n\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n\t\tkubectl delete pod,service baz foo\n\n\t\t# Delete pods and services with label name=myLabel.\n\t\tkubectl delete pods,services -l name=myLabel\n\n\t\t# Delete a pod with minimal delay\n\t\tkubectl delete pod foo --now\n\n\t\t# Force delete a pod on a dead node\n\t\tkubectl delete pod foo --grace-period=0 --force\n\n\t\t# Delete all pods\n\t\tkubectl delete pods --all\x00\n\t\t# Describe a node\n\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n\n\t\t# Describe a pod\n\t\tkubectl describe pods/nginx\n\n\t\t# Describe a pod identified by type and name in \"pod.json\"\n\t\tkubectl describe -f pod.json\n\n\t\t# Describe all pods\n\t\tkubectl describe pods\n\n\t\t# Describe pods by label name=myLabel\n\t\tkubectl describe po -l name=myLabel\n\n\t\t# Describe all pods managed by the 'frontend' replication controller (rc-created pods\n\t\t# get the name of the rc as a prefix in the pod the name).\n\t\tkubectl describe pods frontend\x00\n\t\t# Drain node \"foo\", even if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n\t\t$ kubectl drain foo --force\n\n\t\t# As above, but abort if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a grace period of 15 minutes.\n\t\t$ kubectl drain foo --grace-period=900\x00\n\t\t# Edit the service named 'docker-registry':\n\t\tkubectl edit svc/docker-registry\n\n\t\t# Use an alternative editor\n\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n\n\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n\t\tkubectl edit job.v1.batch/myjob -o json\n\n\t\t# Edit the deployment 'mydeployment' in YAML and save the modified config in its annotation:\n\t\tkubectl edit deployment/mydeployment -o yaml --save-config\x00\n\t\t# Get output from running 'date' from pod 123456-7890, using the first container by default\n\t\tkubectl exec 123456-7890 date\n\n\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n\t\tkubectl exec 123456-7890 -c ruby-container date\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il\x00\n\t\t# Get output from running pod 123456-7890, using the first container by default\n\t\tkubectl attach 123456-7890\n\n\t\t# Get output from ruby-container from pod 123456-7890\n\t\tkubectl attach 123456-7890 -c ruby-container\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n\n\t\t# Get output from the first pod of a ReplicaSet named nginx\n\t\tkubectl attach rs/nginx\n\t\t\x00\n\t\t# Get the documentation of the resource and its fields\n\t\tkubectl explain pods\n\n\t\t# Get the documentation of a specific field of a resource\n\t\tkubectl explain pods.spec.containers\x00\n\t\t# Install bash completion on a Mac using homebrew\n\t\tbrew install bash-completion\n\t\tprintf \"\n# Bash completion support\nsource $(brew --prefix)/etc/bash_completion\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for bash into the current shell\n\t\tsource <(kubectl completion bash)\n\n\t\t# Write bash completion code to a file and source if from .bash_profile\n\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n\t\tprintf \"\n# Kubectl shell completion\nsource '$HOME/.kube/completion.bash.inc'\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for zsh[1] into the current shell\n\t\tsource <(kubectl completion zsh)\x00\n\t\t# List all pods in ps output format.\n\t\tkubectl get pods\n\n\t\t# List all pods in ps output format with more information (such as node name).\n\t\tkubectl get pods -o wide\n\n\t\t# List a single replication controller with specified NAME in ps output format.\n\t\tkubectl get replicationcontroller web\n\n\t\t# List a single pod in JSON output format.\n\t\tkubectl get -o json pod web-pod-13je7\n\n\t\t# List a pod identified by type and name specified in \"pod.yaml\" in JSON output format.\n\t\tkubectl get -f pod.yaml -o json\n\n\t\t# Return only the phase value of the specified pod.\n\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n\n\t\t# List all replication controllers and services together in ps output format.\n\t\tkubectl get rc,services\n\n\t\t# List one or more resources by their type and names.\n\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n\n\t\t# List all resources with different types.\n\t\tkubectl get all\x00\n\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports 5000 and 6000 in the pod\n\t\tkubectl port-forward mypod 5000 6000\n\n\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 8888:5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod :5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 0:5000\x00\n\t\t# Mark node \"foo\" as schedulable.\n\t\t$ kubectl uncordon foo\x00\n\t\t# Mark node \"foo\" as unschedulable.\n\t\tkubectl cordon foo\x00\n\t\t# Partially update a node using strategic merge patch\n\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Partially update a node identified by the type and name specified in \"node.json\" using strategic merge patch\n\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Update a container's image; spec.containers[*].name is required because it's a merge key\n\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n\n\t\t# Update a container's image using a json patch with positional arrays\n\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", \"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'\x00\n\t\t# Print flags inherited by all commands\n\t\tkubectl options\x00\n\t\t# Print the address of the master and cluster services\n\t\tkubectl cluster-info\x00\n\t\t# Print the client and server versions for the current context\n\t\tkubectl version\x00\n\t\t# Print the supported API versions\n\t\tkubectl api-versions\x00\n\t\t# Replace a pod using the data in pod.json.\n\t\tkubectl replace -f ./pod.json\n\n\t\t# Replace a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl replace -f -\n\n\t\t# Update a single-container pod's image version (tag) to v4\n\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/\x01:v4/' | kubectl replace -f -\n\n\t\t# Force replace, delete and then re-create the resource\n\t\tkubectl replace --force -f ./pod.json\x00\n\t\t# Return snapshot logs from pod nginx with only one container\n\t\tkubectl logs nginx\n\n\t\t# Return snapshot logs for the pods defined by label app=nginx\n\t\tkubectl logs -lapp=nginx\n\n\t\t# Return snapshot of previous terminated ruby container logs from pod web-1\n\t\tkubectl logs -p -c ruby web-1\n\n\t\t# Begin streaming the logs of the ruby container in pod web-1\n\t\tkubectl logs -f -c ruby web-1\n\n\t\t# Display only the most recent 20 lines of output in pod nginx\n\t\tkubectl logs --tail=20 nginx\n\n\t\t# Show all logs from pod nginx written in the last hour\n\t\tkubectl logs --since=1h nginx\n\n\t\t# Return snapshot logs from first container of a job named hello\n\t\tkubectl logs job/hello\n\n\t\t# Return snapshot logs from container nginx-1 of a deployment named nginx\n\t\tkubectl logs deployment/nginx -c nginx-1\x00\n\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static content from ./local/www/\n\t\tkubectl proxy --port=8011 --www=./local/www/\n\n\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n\t\t# The chosen port for the server will be output to stdout.\n\t\tkubectl proxy --port=0\n\n\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-api\n\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/pods/\n\t\tkubectl proxy --api-prefix=/k8s-api\x00\n\t\t# Scale a replicaset named 'foo' to 3.\n\t\tkubectl scale --replicas=3 rs/foo\n\n\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" to 3.\n\t\tkubectl scale --replicas=3 -f foo.yaml\n\n\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n\n\t\t# Scale multiple replication controllers.\n\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n\n\t\t# Scale job named 'cron' to 3.\n\t\tkubectl scale --replicas=3 job/cron\x00\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file.\n\t\tkubectl apply set-last-applied -f deploy.yaml\n\n\t\t# Execute set-last-applied against each configuration file in a directory.\n\t\tkubectl apply set-last-applied -f path/\n\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file, will create the annotation if it does not already exist.\n\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n\t\t\x00\n\t\t# Show metrics for all pods in the default namespace\n\t\tkubectl top pod\n\n\t\t# Show metrics for all pods in the given namespace\n\t\tkubectl top pod --namespace=NAMESPACE\n\n\t\t# Show metrics for a given pod and its containers\n\t\tkubectl top pod POD_NAME --containers\n\n\t\t# Show metrics for the pods defined by label name=myLabel\n\t\tkubectl top pod -l name=myLabel\x00\n\t\t# Shut down foo.\n\t\tkubectl stop replicationcontroller foo\n\n\t\t# Stop pods and services with label name=myLabel.\n\t\tkubectl stop pods,services -l name=myLabel\n\n\t\t# Shut down the service defined in service.json\n\t\tkubectl stop -f service.json\n\n\t\t# Shut down all resources in the path/to/resources directory\n\t\tkubectl stop -f path/to/resources\x00\n\t\t# Start a single instance of nginx.\n\t\tkubectl run nginx --image=nginx\n\n\t\t# Start a single instance of hazelcast and let the container expose port 5701 .\n\t\tkubectl run hazelcast --image=hazelcast --port=5701\n\n\t\t# Start a single instance of hazelcast and set environment variables \"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --env=\"POD_NAMESPACE=default\"\n\n\t\t# Start a replicated instance of nginx.\n\t\tkubectl run nginx --image=nginx --replicas=5\n\n\t\t# Dry run. Print the corresponding API objects without creating them.\n\t\tkubectl run nginx --image=nginx --dry-run\n\n\t\t# Start a single instance of nginx, but overload the spec of the deployment with a partial set of values parsed from JSON.\n\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", \"spec\": { ... } }'\n\n\t\t# Start a pod of busybox and keep it in the foreground, don't restart it if it exits.\n\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n\n\t\t# Start the nginx container using the default command, but use custom arguments (arg1 .. argN) for that command.\n\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n\n\t\t# Start the nginx container using a different command and custom arguments.\n\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n\n\t\t# Start the perl container to compute \u03c0 to 2000 places and print it out.\n\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\n\n\t\t# Start the cron job to compute \u03c0 to 2000 places and print it out every 5 minutes.\n\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\x00\n\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-user' and effect 'NoSchedule'.\n\t\t# If a taint with that key and effect already exists, its value is replaced as specified.\n\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n\n\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect 'NoSchedule' if one exists.\n\t\tkubectl taint nodes foo dedicated:NoSchedule-\n\n\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n\t\tkubectl taint nodes foo dedicated-\x00\n\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n\t\tkubectl label pods foo unhealthy=true\n\n\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', overwriting any existing value.\n\t\tkubectl label --overwrite pods foo status=unhealthy\n\n\t\t# Update all pods in the namespace\n\t\tkubectl label pods --all status=unhealthy\n\n\t\t# Update a pod identified by the type and name in \"pod.json\"\n\t\tkubectl label -f pod.json status=unhealthy\n\n\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n\t\tkubectl label pods foo status=unhealthy --resource-version=1\n\n\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n\t\t# Does not require the --overwrite flag.\n\t\tkubectl label pods foo bar-\x00\n\t\t# Update pods of frontend-v1 using new replication controller data in frontend-v2.json.\n\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n\n\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n\n\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the image, and switching the\n\t\t# name of the replication controller.\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n\n\t\t# Update the pods of frontend by just changing the image, and keeping the old name.\n\t\tkubectl rolling-update frontend --image=image:v2\n\n\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to frontend-v2).\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback\x00\n\t\t# View the last-applied-configuration annotations by type/name in YAML.\n\t\tkubectl apply view-last-applied deployment/nginx\n\n\t\t# View the last-applied-configuration annotations by file in JSON\n\t\tkubectl apply view-last-applied -f deploy.yaml -o json\x00\n\t\tApply a configuration to a resource by filename or stdin.\n\t\tThis resource will be created if it doesn't exist yet.\n\t\tTo use 'apply', always create the resource initially with either 'apply' or 'create --save-config'.\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not use unless you are aware of what the current state is. See https://issues.k8s.io/34274.\x00\n\t\tConvert config files between different API versions. Both YAML\n\t\tand JSON formats are accepted.\n\n\t\tThe command takes filename, directory, or URL as input, and convert it into format\n\t\tof version specified by --output-version flag. If target version is not specified or\n\t\tnot supported, convert to latest version.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change to output destination.\x00\n\t\tCreate a ClusterRole.\x00\n\t\tCreate a ClusterRoleBinding for a particular ClusterRole.\x00\n\t\tCreate a RoleBinding for a particular Role or ClusterRole.\x00\n\t\tCreate a TLS secret from the given public/private key pair.\n\n\t\tThe public/private key pair must exist before hand. The public key certificate must be .PEM encoded and match the given private key.\x00\n\t\tCreate a configmap based on a file, directory, or specified literal value.\n\n\t\tA single configmap may package one or more key/value pairs.\n\n\t\tWhen creating a configmap based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a configmap based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the configmap.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a namespace with the specified name.\x00\n\t\tCreate a new secret for use with Docker registries.\n\n\t\tDockercfg secrets are used to authenticate against Docker registries.\n\n\t\tWhen using the Docker command line to push images, you can authenticate to a given registry by running\n\n\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n\n    That produces a ~/.dockercfg file that is used by subsequent 'docker push' and 'docker pull' commands to\n\t\tauthenticate to the registry. The email address is optional.\n\n\t\tWhen creating applications, you may have a Docker registry that requires authentication.  In order for the\n\t\tnodes to pull images on your behalf, they have to have the credentials.  You can provide this information\n\t\tby creating a dockercfg secret and attaching it to your service account.\x00\n\t\tCreate a pod disruption budget with the specified name, selector, and desired minimum available pods\x00\n\t\tCreate a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted.\x00\n\t\tCreate a resourcequota with the specified name, hard limits and optional scopes\x00\n\t\tCreate a role with single rule.\x00\n\t\tCreate a secret based on a file, directory, or specified literal value.\n\n\t\tA single secret may package one or more key/value pairs.\n\n\t\tWhen creating a secret based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a secret based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the secret.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a service account with the specified name.\x00\n\t\tCreate and run a particular image, possibly replicated.\n\n\t\tCreates a deployment or job to manage the created container(s).\x00\n\t\tCreates an autoscaler that automatically chooses and sets the number of pods that run in a kubernetes cluster.\n\n\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and creates an autoscaler that uses the given resource as a reference.\n\t\tAn autoscaler can automatically increase or decrease number of pods deployed within the system as needed.\x00\n\t\tDelete resources by filenames, stdin, resources and names, or by resources and label selector.\n\n\t\tJSON and YAML formats are accepted. Only one type of the arguments may be specified: filenames,\n\t\tresources and names, or resources and label selector.\n\n\t\tSome resources, such as pods, support graceful deletion. These resources define a default period\n\t\tbefore they are forcibly terminated (the grace period) but you may override that value with\n\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. Because these resources often\n\t\trepresent entities in the cluster, deletion may not be acknowledged immediately. If the node\n\t\thosting a pod is down or cannot reach the API server, termination may take significantly longer\n\t\tthan the grace period. To force delete a resource,\tyou must pass a grace\tperiod of 0 and specify\n\t\tthe --force flag.\n\n\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the pod's processes have been\n\t\tterminated, which can leave those processes running until the node detects the deletion and\n\t\tcompletes graceful deletion. If your processes use shared storage or talk to a remote API and\n\t\tdepend on the name of the pod to identify themselves, force deleting those pods may result in\n\t\tmultiple processes running on different machines using the same identification which may lead\n\t\tto data corruption or inconsistency. Only force delete pods when you are sure the pod is\n\t\tterminated, or if your application can tolerate multiple copies of the same pod running at once.\n\t\tAlso, if you force delete pods the scheduler may place new pods on those nodes before the node\n\t\thas released those resources and causing those pods to be evicted immediately.\n\n\t\tNote that the delete command does NOT do resource version checks, so if someone\n\t\tsubmits an update to a resource right when you submit a delete, their update\n\t\twill be lost along with the rest of the resource.\x00\n\t\tDeprecated: Gracefully shut down a resource by name or filename.\n\n\t\tThe stop command is deprecated, all its functionalities are covered by delete command.\n\t\tSee 'kubectl delete --help' for more details.\n\n\t\tAttempts to shut down and delete a resource that supports graceful termination.\n\t\tIf the resource is scalable it will be scaled to 0 before deletion.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n\n\t\tThe top-node command allows you to see the resource consumption of nodes.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n\n\t\tThe 'top pod' command allows you to see the resource consumption of pods.\n\n\t\tDue to the metrics pipeline delay, they may be unavailable for a few minutes\n\t\tsince pod creation.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage.\n\n\t\tThe top command allows you to see the resource consumption for nodes or pods.\n\n\t\tThis command requires Heapster to be correctly configured and working on the server. \x00\n\t\tDrain node in preparation for maintenance.\n\n\t\tThe given node will be marked unschedulable to prevent new pods from arriving.\n\t\t'drain' evicts the pods if the APIServer supports eviction\n\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use normal DELETE\n\t\tto delete the pods.\n\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot be deleted through\n\t\tthe API server).  If there are DaemonSet-managed pods, drain will not proceed\n\t\twithout --ignore-daemonsets, and regardless it will not delete any\n\t\tDaemonSet-managed pods, because those pods would be immediately replaced by the\n\t\tDaemonSet controller, which ignores unschedulable markings.  If there are any\n\t\tpods that are neither mirror pods nor managed by ReplicationController,\n\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete any pods unless you\n\t\tuse --force.  --force will also allow deletion to proceed if the managing resource of one\n\t\tor more pods is missing.\n\n\t\t'drain' waits for graceful termination. You should not operate on the machine until\n\t\tthe command completes.\n\n\t\tWhen you are ready to put the node back into service, use kubectl uncordon, which\n\t\twill make the node schedulable again.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)\x00\n\t\tEdit a resource from the default editor.\n\n\t\tThe edit command allows you to directly edit any API resource you can retrieve via the\n\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, or EDITOR\n\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for Windows.\n\t\tYou can edit multiple objects, although changes are applied one at a time. The command\n\t\taccepts filenames as well as command line arguments, although the files you point to must\n\t\tbe previously saved versions of resources.\n\n\t\tEditing is done with the API version used to fetch the resource.\n\t\tTo edit using a specific API version, fully-qualify the resource, version, and group.\n\n\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n\n\t\tThe flag --windows-line-endings can be used to force Windows line endings,\n\t\totherwise the default for your operating system will be used.\n\n\t\tIn the event an error occurs while updating, a temporary file will be created on disk\n\t\tthat contains your unapplied changes. The most common error when updating a resource\n\t\tis another editor changing the resource on the server. When this occurs, you will have\n\t\tto apply your changes to the newer version of the resource, or update your temporary\n\t\tsaved copy to include the latest resource version.\x00\n\t\tMark node as schedulable.\x00\n\t\tMark node as unschedulable.\x00\n\t\tOutput shell completion code for the specified shell (bash or zsh).\n\t\tThe shell code must be evalutated to provide interactive\n\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n\t\tthe .bash_profile.\n\n\t\tNote: this requires the bash-completion framework, which is not installed\n\t\tby default on Mac.  This can be installed by using homebrew:\n\n\t\t    $ brew install bash-completion\n\n\t\tOnce installed, bash_completion must be evaluated.  This can be done by adding the\n\t\tfollowing line to the .bash_profile\n\n\t\t    $ source $(brew --prefix)/etc/bash_completion\n\n\t\tNote for zsh users: [1] zsh completions are only supported in versions of zsh >= 5.2\x00\n\t\tPerform a rolling update of the given ReplicationController.\n\n\t\tReplaces the specified replication controller with a new replication controller by updating one pod at a time to use the\n\t\tnew PodTemplate. The new-controller.json must specify the same namespace as the\n\t\texisting replication controller and overwrite at least one (common) label in its replicaSelector.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)\x00\n\t\tReplace a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted. If replacing an existing resource, the\n\t\tcomplete resource spec must be provided. This can be obtained by\n\n\t\t    $ kubectl get TYPE NAME -o yaml\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or Job.\n\n\t\tScale also allows users to specify one or more preconditions for the scale action.\n\n\t\tIf --current-replicas or --resource-version is specified, it is validated before the\n\t\tscale is attempted, and it is guaranteed that the precondition holds true when the\n\t\tscale is sent to the server.\x00\n\t\tSet the latest last-applied-configuration annotations by setting it to match the contents of a file.\n\t\tThis results in the last-applied-configuration being updated as though 'kubectl apply -f <file>' was run,\n\t\twithout updating any other parts of the object.\x00\n\t\tTo proxy all of the kubernetes api and nothing else, use:\n\n\t\t    $ kubectl proxy --api-prefix=/\n\n\t\tTo proxy only part of the kubernetes api and also some static files:\n\n\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/api/\n\n\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n\n\t\tTo proxy the entire kubernetes api at a different root, use:\n\n\t\t    $ kubectl proxy --api-prefix=/custom/\n\n\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'\x00\n\t\tUpdate field(s) of a resource using strategic merge patch\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tUpdate the labels on a resource.\n\n\t\t* A label must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* If --overwrite is true, then existing labels can be overwritten, otherwise attempting to overwrite a label will result in an error.\n\t\t* If --resource-version is specified, then updates will use this resource version, otherwise the existing resource-version will be used.\x00\n\t\tUpdate the taints on one or more nodes.\n\n\t\t* A taint consists of a key, value, and effect. As an argument here, it is expressed as key=value:effect.\n\t\t* The key must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* The value must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[2]d characters.\n\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n\t\t* Currently taint can only apply to node.\x00\n\t\tView the latest last-applied-configuration annotations by type/name or file.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change output format.\x00\n\t    # !!!Important Note!!!\n\t    # Requires that the 'tar' binary is present in your container\n\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n\n\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in the default namespace\n\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n\n        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific container\n\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n\n\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace <some-namespace>\n\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n\n\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar\x00\n\t  # Create a new TLS secret named tls-secret with the given key pair:\n\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/to/tls.key\x00\n\t  # Create a new namespace named my-namespace\n\t  kubectl create namespace my-namespace\x00\n\t  # Create a new secret named my-secret with keys for each file in folder bar\n\t  kubectl create secret generic my-secret --from-file=path/to/bar\n\n\t  # Create a new secret named my-secret with specified keys instead of names on disk\n\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/.ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n\n\t  # Create a new secret named my-secret with key1=supersecret and key2=topsecret\n\t  kubectl create secret generic my-secret --from-literal=key1=supersecret --from-literal=key2=topsecret\x00\n\t  # Create a new service account named my-service-account\n\t  kubectl create serviceaccount my-service-account\x00\n\t# Create a new ExternalName service named my-ns \n\tkubectl create service externalname my-ns --external-name bar.com\x00\n\tCreate an ExternalName service with the specified name.\n\n\tExternalName service references to an external DNS address instead of\n\tonly pods, which will allow application authors to reference services\n\tthat exist off platform, on other clusters, or locally.\x00\n\tHelp provides help for any command in the application.\n\tSimply type kubectl help [path to command] for full details.\x00\n    # Create a new LoadBalancer service named my-lbs\n    kubectl create service loadbalancer my-lbs --tcp=5678:8080\x00\n    # Create a new clusterIP service named my-cs\n    kubectl create service clusterip my-cs --tcp=5678:8080\n\n    # Create a new clusterIP service named my-cs (in headless mode)\n    kubectl create service clusterip my-cs --clusterip=\"None\"\x00\n    # Create a new deployment named my-dep that runs the busybox image.\n    kubectl create deployment my-dep --image=busybox\x00\n    # Create a new nodeport service named my-ns\n    kubectl create service nodeport my-ns --tcp=5678:8080\x00\n    # Dump current cluster state to stdout\n    kubectl cluster-info dump\n\n    # Dump current cluster state to /path/to/cluster-state\n    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n\n    # Dump all namespaces to stdout\n    kubectl cluster-info dump --all-namespaces\n\n    # Dump a set of namespaces to /path/to/cluster-state\n    kubectl cluster-info dump --namespaces default,kube-system --output-directory=/path/to/cluster-state\x00\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend'.\n    # If the same annotation is set multiple times, only the last value will be applied\n    kubectl annotate pods foo description='my frontend'\n\n    # Update a pod identified by type and name in \"pod.json\"\n    kubectl annotate -f pod.json description='my frontend'\n\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend running nginx', overwriting any existing value.\n    kubectl annotate --overwrite pods foo description='my frontend running nginx'\n\n    # Update all pods in the namespace\n    kubectl annotate pods --all description='my frontend running nginx'\n\n    # Update pod 'foo' only if the resource is unchanged from version 1.\n    kubectl annotate pods foo description='my frontend running nginx' --resource-version=1\n\n    # Update pod 'foo' by removing an annotation named 'description' if it exists.\n    # Does not require the --overwrite flag.\n    kubectl annotate pods foo description-\x00\n    Create a LoadBalancer service with the specified name.\x00\n    Create a clusterIP service with the specified name.\x00\n    Create a deployment with the specified name.\x00\n    Create a nodeport service with the specified name.\x00\n    Dumps cluster info out suitable for debugging and diagnosing cluster problems.  By default, dumps everything to\n    stdout. You can optionally specify a directory with --output-directory.  If you specify a directory, kubernetes will\n    build a set of files in that directory.  By default only dumps things in the 'kube-system' namespace, but you can\n    switch to a different namespace with the --namespaces flag, or specify --all-namespaces to dump all namespaces.\n\n    The command also dumps the logs of all of the pods in the cluster, these logs are dumped into different directories\n    based on namespace and pod name.\x00\n  Display addresses of the master and services with label kubernetes.io/cluster-service=true\n  To further debug and diagnose cluster problems, use 'kubectl cluster-info dump'.\x00A comma-delimited set of quota scopes that must all match each object tracked by the quota.\x00A comma-delimited set of resource=quantity pairs that define a hard limit.\x00A label selector to use for this budget. Only equality-based selector requirements are supported.\x00A label selector to use for this service. Only equality-based selector requirements are supported. If empty (the default) infer the selector from the replication controller or replica set.)\x00A schedule in the Cron format the job should be run with.\x00Additional external IP address (not managed by Kubernetes) to accept for the service. If this IP is routed to a node, the service can be accessed by this IP in addition to its generated service IP.\x00An inline JSON override for the generated object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.\x00An inline JSON override for the generated service object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.  Only used if --expose is true.\x00Apply a configuration to a resource by filename or stdin\x00Approve a certificate signing request\x00Assign your own ClusterIP or set to 'None' for a 'headless' service (no loadbalancing).\x00Attach to a running container\x00Auto-scale a Deployment, ReplicaSet, or ReplicationController\x00ClusterIP to be assigned to the service. Leave empty to auto-allocate, or set to 'None' to create a headless service.\x00ClusterRole this ClusterRoleBinding should reference\x00ClusterRole this RoleBinding should reference\x00Container name which will have its image upgraded. Only relevant when --image is specified, ignored otherwise. Required when using --image on a multi-container pod\x00Convert config files between different API versions\x00Copy files and directories to and from containers.\x00Create a ClusterRoleBinding for a particular ClusterRole\x00Create a LoadBalancer service.\x00Create a NodePort service.\x00Create a RoleBinding for a particular Role or ClusterRole\x00Create a TLS secret\x00Create a clusterIP service.\x00Create a configmap from a local file, directory or literal value\x00Create a deployment with the specified name.\x00Create a namespace with the specified name\x00Create a pod disruption budget with the specified name.\x00Create a quota with the specified name.\x00Create a resource by filename or stdin\x00Create a secret for use with a Docker registry\x00Create a secret from a local file, directory or literal value\x00Create a secret using specified subcommand\x00Create a service account with the specified name\x00Create a service using specified subcommand.\x00Create an ExternalName service.\x00Delete resources by filenames, stdin, resources and names, or by resources and label selector\x00Delete the specified cluster from the kubeconfig\x00Delete the specified context from the kubeconfig\x00Deny a certificate signing request\x00Deprecated: Gracefully shut down a resource by name or filename\x00Describe one or many contexts\x00Display Resource (CPU/Memory/Storage) usage of nodes\x00Display Resource (CPU/Memory/Storage) usage of pods\x00Display Resource (CPU/Memory/Storage) usage.\x00Display cluster info\x00Display clusters defined in the kubeconfig\x00Display merged kubeconfig settings or a specified kubeconfig file\x00Display one or many resources\x00Displays the current-context\x00Documentation of resources\x00Drain node in preparation for maintenance\x00Dump lots of relevant info for debugging and diagnosis\x00Edit a resource on the server\x00Email for Docker registry\x00Execute a command in a container\x00Explicit policy for when to pull container images. Required when --image is same as existing image, ignored otherwise.\x00Forward one or more local ports to a pod\x00Help about any command\x00IP to assign to the Load Balancer. If empty, an ephemeral IP will be created and used (cloud-provider specific).\x00If non-empty, set the session affinity for the service to this; legal values: 'None', 'ClientIP'\x00If non-empty, the annotation update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00If non-empty, the labels update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00Image to use for upgrading the replication controller. Must be distinct from the existing image (either new image or new image tag).  Can not be used with --filename/-f\x00Manage a deployment rollout\x00Mark node as schedulable\x00Mark node as unschedulable\x00Mark the provided resource as paused\x00Modify certificate resources.\x00Modify kubeconfig files\x00Name or number for the port on the container that the service should direct traffic to. Optional.\x00Only return logs after a specific date (RFC3339). Defaults to all logs. Only one of since-time / since may be used.\x00Output shell completion code for the specified shell (bash or zsh)\x00Output the formatted object with the given group version (for ex: 'extensions/v1beta1').)\x00Password for Docker registry authentication\x00Path to PEM encoded public key certificate.\x00Path to private key associated with given certificate.\x00Perform a rolling update of the given ReplicationController\x00Precondition for resource version. Requires that the current resource version match this value in order to scale.\x00Print the client and server version information\x00Print the list of flags inherited by all commands\x00Print the logs for a container in a pod\x00Replace a resource by filename or stdin\x00Resume a paused resource\x00Role this RoleBinding should reference\x00Run a particular image on the cluster\x00Run a proxy to the Kubernetes API server\x00Server location for Docker registry\x00Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job\x00Set specific features on objects\x00Set the last-applied-configuration annotation on a live object to match the contents of a file.\x00Set the selector on a resource\x00Sets a cluster entry in kubeconfig\x00Sets a context entry in kubeconfig\x00Sets a user entry in kubeconfig\x00Sets an individual value in a kubeconfig file\x00Sets the current-context in a kubeconfig file\x00Show details of a specific resource or group of resources\x00Show the status of the rollout\x00Synonym for --target-port\x00Take a replication controller, service, deployment or pod and expose it as a new Kubernetes Service\x00The image for the container to run.\x00The image pull policy for the container. If left empty, this value will not be specified by the client and defaulted by the server\x00The key to use to differentiate between two different controllers, default 'deployment'.  Only relevant when --image is specified, ignored otherwise\x00The minimum number or percentage of available pods this budget requires.\x00The name for the newly created object.\x00The name for the newly created object. If not specified, the name of the input resource will be used.\x00The name of the API generator to use, see http://kubernetes.io/docs/user-guide/kubectl-conventions/#generators for a list.\x00The name of the API generator to use. Currently there is only 1 generator.\x00The name of the API generator to use. There are 2 generators: 'service/v1' and 'service/v2'. The only difference between them is that service port in v1 is named 'default', while it is left unnamed in v2. Default is 'service/v2'.\x00The name of the generator to use for creating a service.  Only used if --expose is true\x00The network protocol for the service to be created. Default is 'TCP'.\x00The port that the service should serve on. Copied from the resource being exposed, if unspecified\x00The port that this container exposes.  If --expose is true, this is also the port used by the service that is created.\x00The resource requirement limits for this container.  For example, 'cpu=200m,memory=512Mi'.  Note that server side components may assign limits depending on the server configuration, such as limit ranges.\x00The resource requirement requests for this container.  For example, 'cpu=100m,memory=256Mi'.  Note that server side components may assign requests depending on the server configuration, such as limit ranges.\x00The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  If set to 'Always' a deployment is created, if set to 'OnFailure' a job is created, if set to 'Never', a regular pod is created. For the latter two --replicas must be 1.  Default 'Always', for CronJobs `Never`.\x00The type of secret to create\x00Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is 'ClusterIP'.\x00Undo a previous rollout\x00Unsets an individual value in a kubeconfig file\x00Update field(s) of a resource using strategic merge patch\x00Update image of a pod template\x00Update resource requests/limits on objects with pod templates\x00Update the annotations on a resource\x00Update the labels on a resource\x00Update the taints on one or more nodes\x00Username for Docker registry authentication\x00View latest last-applied-configuration annotations of a resource/object\x00View rollout history\x00Where to output the files.  If empty or '-' uses stdout, otherwise creates a directory hierarchy in that directory\x00dummy restart flag)\x00external name of service\x00kubectl controls the Kubernetes cluster manager\x00")

func translationsKubectlDefaultLc_messagesK8sMoBytes() ([]byte, error) {
	return _translationsKubectlDefaultLc_messagesK8sMo, nil
}

func translationsKubectlDefaultLc_messagesK8sMo() (*asset, error) {
	bytes, err := translationsKubectlDefaultLc_messagesK8sMoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/default/LC_MESSAGES/k8s.mo", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlDefaultLc_messagesK8sPo = []byte(`# Test translations for unit tests.
# Copyright (C) 2016
# This file is distributed under the same license as the PACKAGE package.
# FIRST AUTHOR brendan.d.burns@gmail.com, 2016.
#
msgid ""
msgstr ""
"Project-Id-Version: gettext-go-examples-hello\n"
"Report-Msgid-Bugs-To: EMAIL\n"
"POT-Creation-Date: 2017-03-14 21:32-0700\n"
"PO-Revision-Date: 2017-05-24 18:01+0800\n"
"Last-Translator: Brendan Burns <brendan.d.burns@gmail.com>\n"
"Language-Team: \n"
"Language: en\n"
"MIME-Version: 1.0\n"
"Content-Type: text/plain; charset=UTF-8\n"
"Content-Transfer-Encoding: 8bit\n"
"X-Generator: Poedit 1.8.12\n"
"X-Poedit-SourceCharset: UTF-8\n"
"Plural-Forms: nplurals=2; plural=(n != 1);\n"

#: pkg/kubectl/cmd/create_clusterrolebinding.go:35
msgid ""
"\n"
"\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the "
"cluster-admin ClusterRole\n"
"\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-"
"admin --user=user1 --user=user2 --group=group1"
msgstr ""
"\n"
"\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the "
"cluster-admin ClusterRole\n"
"\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-"
"admin --user=user1 --user=user2 --group=group1"

#: pkg/kubectl/cmd/create_rolebinding.go:35
msgid ""
"\n"
"\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin "
"ClusterRole\n"
"\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --"
"user=user2 --group=group1"
msgstr ""
"\n"
"\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin "
"ClusterRole\n"
"\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --"
"user=user2 --group=group1"

#: pkg/kubectl/cmd/create_configmap.go:44
msgid ""
"\n"
"\t\t  # Create a new configmap named my-config based on folder bar\n"
"\t\t  kubectl create configmap my-config --from-file=path/to/bar\n"
"\n"
"\t\t  # Create a new configmap named my-config with specified keys instead "
"of file basenames on disk\n"
"\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1."
"txt --from-file=key2=/path/to/bar/file2.txt\n"
"\n"
"\t\t  # Create a new configmap named my-config with key1=config1 and "
"key2=config2\n"
"\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-"
"literal=key2=config2"
msgstr ""
"\n"
"\t\t  # Create a new configmap named my-config based on folder bar\n"
"\t\t  kubectl create configmap my-config --from-file=path/to/bar\n"
"\n"
"\t\t  # Create a new configmap named my-config with specified keys instead "
"of file basenames on disk\n"
"\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1."
"txt --from-file=key2=/path/to/bar/file2.txt\n"
"\n"
"\t\t  # Create a new configmap named my-config with key1=config1 and "
"key2=config2\n"
"\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-"
"literal=key2=config2"

#: pkg/kubectl/cmd/create_secret.go:135
msgid ""
"\n"
"\t\t  # If you don't already have a .dockercfg file, you can create a "
"dockercfg secret directly by using:\n"
"\t\t  kubectl create secret docker-registry my-secret --docker-"
"server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-"
"password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL"
msgstr ""
"\n"
"\t\t  # If you don't already have a .dockercfg file, you can create a "
"dockercfg secret directly by using:\n"
"\t\t  kubectl create secret docker-registry my-secret --docker-"
"server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-"
"password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL"

#: pkg/kubectl/cmd/top_node.go:65
msgid ""
"\n"
"\t\t  # Show metrics for all nodes\n"
"\t\t  kubectl top node\n"
"\n"
"\t\t  # Show metrics for a given node\n"
"\t\t  kubectl top node NODE_NAME"
msgstr ""
"\n"
"\t\t  # Show metrics for all nodes\n"
"\t\t  kubectl top node\n"
"\n"
"\t\t  # Show metrics for a given node\n"
"\t\t  kubectl top node NODE_NAME"

#: pkg/kubectl/cmd/apply.go:84
msgid ""
"\n"
"\t\t# Apply the configuration in pod.json to a pod.\n"
"\t\tkubectl apply -f ./pod.json\n"
"\n"
"\t\t# Apply the JSON passed into stdin to a pod.\n"
"\t\tcat pod.json | kubectl apply -f -\n"
"\n"
"\t\t# Note: --prune is still in Alpha\n"
"\t\t# Apply the configuration in manifest.yaml that matches label app=nginx "
"and delete all the other resources that are not in the file and match label "
"app=nginx.\n"
"\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n"
"\n"
"\t\t# Apply the configuration in manifest.yaml and delete all the other "
"configmaps that are not in the file.\n"
"\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/"
"ConfigMap"
msgstr ""
"\n"
"\t\t# Apply the configuration in pod.json to a pod.\n"
"\t\tkubectl apply -f ./pod.json\n"
"\n"
"\t\t# Apply the JSON passed into stdin to a pod.\n"
"\t\tcat pod.json | kubectl apply -f -\n"
"\n"
"\t\t# Note: --prune is still in Alpha\n"
"\t\t# Apply the configuration in manifest.yaml that matches label app=nginx "
"and delete all the other resources that are not in the file and match label "
"app=nginx.\n"
"\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n"
"\n"
"\t\t# Apply the configuration in manifest.yaml and delete all the other "
"configmaps that are not in the file.\n"
"\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/"
"ConfigMap"

#: pkg/kubectl/cmd/autoscale.go:40
#, c-format
msgid ""
"\n"
"\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and "
"10, target CPU utilization specified so a default autoscaling policy will be "
"used:\n"
"\t\tkubectl autoscale deployment foo --min=2 --max=10\n"
"\n"
"\t\t# Auto scale a replication controller \"foo\", with the number of pods "
"between 1 and 5, target CPU utilization at 80%:\n"
"\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80"
msgstr ""
"\n"
"\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and "
"10, target CPU utilization specified so a default autoscaling policy will be "
"used:\n"
"\t\tkubectl autoscale deployment foo --min=2 --max=10\n"
"\n"
"\t\t# Auto scale a replication controller \"foo\", with the number of pods "
"between 1 and 5, target CPU utilization at 80%:\n"
"\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80"

#: pkg/kubectl/cmd/convert.go:49
msgid ""
"\n"
"\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n"
"\t\tkubectl convert -f pod.yaml\n"
"\n"
"\t\t# Convert the live state of the resource specified by 'pod.yaml' to the "
"latest version\n"
"\t\t# and print to stdout in json format.\n"
"\t\tkubectl convert -f pod.yaml --local -o json\n"
"\n"
"\t\t# Convert all files under current directory to latest version and create "
"them all.\n"
"\t\tkubectl convert -f . | kubectl create -f -"
msgstr ""
"\n"
"\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n"
"\t\tkubectl convert -f pod.yaml\n"
"\n"
"\t\t# Convert the live state of the resource specified by 'pod.yaml' to the "
"latest version\n"
"\t\t# and print to stdout in json format.\n"
"\t\tkubectl convert -f pod.yaml --local -o json\n"
"\n"
"\t\t# Convert all files under current directory to latest version and create "
"them all.\n"
"\t\tkubectl convert -f . | kubectl create -f -"

#: pkg/kubectl/cmd/create_clusterrole.go:34
msgid ""
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform "
"\"get\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods\n"
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods --resource-name=readablepod"
msgstr ""
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform "
"\"get\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods\n"
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods --resource-name=readablepod"

#: pkg/kubectl/cmd/create_role.go:41
msgid ""
"\n"
"\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get"
"\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --"
"resource=pods\n"
"\n"
"\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --"
"resource=pods --resource-name=readablepod"
msgstr ""
"\n"
"\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get"
"\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --"
"resource=pods\n"
"\n"
"\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --"
"resource=pods --resource-name=readablepod"

#: pkg/kubectl/cmd/create_quota.go:35
msgid ""
"\n"
"\t\t# Create a new resourcequota named my-quota\n"
"\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,"
"replicationcontrollers=2,resourcequotas=1,secrets=5,"
"persistentvolumeclaims=10\n"
"\n"
"\t\t# Create a new resourcequota named best-effort\n"
"\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort"
msgstr ""
"\n"
"\t\t# Create a new resourcequota named my-quota\n"
"\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,"
"replicationcontrollers=2,resourcequotas=1,secrets=5,"
"persistentvolumeclaims=10\n"
"\n"
"\t\t# Create a new resourcequota named best-effort\n"
"\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort"

#: pkg/kubectl/cmd/create_pdb.go:35
#, c-format
msgid ""
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=rails label\n"
"\t\t# and require at least one of them being available at any point in "
"time.\n"
"\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-"
"available=1\n"
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=nginx label\n"
"\t\t# and require at least half of the pods selected to be available at any "
"point in time.\n"
"\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%"
msgstr ""
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=rails label\n"
"\t\t# and require at least one of them being available at any point in "
"time.\n"
"\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-"
"available=1\n"
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=nginx label\n"
"\t\t# and require at least half of the pods selected to be available at any "
"point in time.\n"
"\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%"

#: pkg/kubectl/cmd/create.go:47
msgid ""
"\n"
"\t\t# Create a pod using the data in pod.json.\n"
"\t\tkubectl create -f ./pod.json\n"
"\n"
"\t\t# Create a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl create -f -\n"
"\n"
"\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format "
"then create the resource using the edited data.\n"
"\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json"
msgstr ""
"\n"
"\t\t# Create a pod using the data in pod.json.\n"
"\t\tkubectl create -f ./pod.json\n"
"\n"
"\t\t# Create a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl create -f -\n"
"\n"
"\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format "
"then create the resource using the edited data.\n"
"\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json"

#: pkg/kubectl/cmd/expose.go:53
msgid ""
"\n"
"\t\t# Create a service for a replicated nginx, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose rc nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a replication controller identified by type and "
"name specified in \"nginx-controller.yaml\", which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a pod valid-pod, which serves on port 444 with "
"the name \"frontend\"\n"
"\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n"
"\n"
"\t\t# Create a second service based on the above service, exposing the "
"container port 8443 as port 443 with the name \"nginx-https\"\n"
"\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-"
"https\n"
"\n"
"\t\t# Create a service for a replicated streaming application on port 4100 "
"balancing UDP traffic and named 'video-stream'.\n"
"\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-"
"stream\n"
"\n"
"\t\t# Create a service for a replicated nginx using replica set, which "
"serves on port 80 and connects to the containers on port 8000.\n"
"\t\tkubectl expose rs nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for an nginx deployment, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose deployment nginx --port=80 --target-port=8000"
msgstr ""
"\n"
"\t\t# Create a service for a replicated nginx, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose rc nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a replication controller identified by type and "
"name specified in \"nginx-controller.yaml\", which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a pod valid-pod, which serves on port 444 with "
"the name \"frontend\"\n"
"\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n"
"\n"
"\t\t# Create a second service based on the above service, exposing the "
"container port 8443 as port 443 with the name \"nginx-https\"\n"
"\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-"
"https\n"
"\n"
"\t\t# Create a service for a replicated streaming application on port 4100 "
"balancing UDP traffic and named 'video-stream'.\n"
"\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-"
"stream\n"
"\n"
"\t\t# Create a service for a replicated nginx using replica set, which "
"serves on port 80 and connects to the containers on port 8000.\n"
"\t\tkubectl expose rs nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for an nginx deployment, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose deployment nginx --port=80 --target-port=8000"

#: pkg/kubectl/cmd/delete.go:68
msgid ""
"\n"
"\t\t# Delete a pod using the type and name specified in pod.json.\n"
"\t\tkubectl delete -f ./pod.json\n"
"\n"
"\t\t# Delete a pod based on the type and name in the JSON passed into "
"stdin.\n"
"\t\tcat pod.json | kubectl delete -f -\n"
"\n"
"\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n"
"\t\tkubectl delete pod,service baz foo\n"
"\n"
"\t\t# Delete pods and services with label name=myLabel.\n"
"\t\tkubectl delete pods,services -l name=myLabel\n"
"\n"
"\t\t# Delete a pod with minimal delay\n"
"\t\tkubectl delete pod foo --now\n"
"\n"
"\t\t# Force delete a pod on a dead node\n"
"\t\tkubectl delete pod foo --grace-period=0 --force\n"
"\n"
"\t\t# Delete all pods\n"
"\t\tkubectl delete pods --all"
msgstr ""
"\n"
"\t\t# Delete a pod using the type and name specified in pod.json.\n"
"\t\tkubectl delete -f ./pod.json\n"
"\n"
"\t\t# Delete a pod based on the type and name in the JSON passed into "
"stdin.\n"
"\t\tcat pod.json | kubectl delete -f -\n"
"\n"
"\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n"
"\t\tkubectl delete pod,service baz foo\n"
"\n"
"\t\t# Delete pods and services with label name=myLabel.\n"
"\t\tkubectl delete pods,services -l name=myLabel\n"
"\n"
"\t\t# Delete a pod with minimal delay\n"
"\t\tkubectl delete pod foo --now\n"
"\n"
"\t\t# Force delete a pod on a dead node\n"
"\t\tkubectl delete pod foo --grace-period=0 --force\n"
"\n"
"\t\t# Delete all pods\n"
"\t\tkubectl delete pods --all"

#: pkg/kubectl/cmd/describe.go:54
msgid ""
"\n"
"\t\t# Describe a node\n"
"\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n"
"\n"
"\t\t# Describe a pod\n"
"\t\tkubectl describe pods/nginx\n"
"\n"
"\t\t# Describe a pod identified by type and name in \"pod.json\"\n"
"\t\tkubectl describe -f pod.json\n"
"\n"
"\t\t# Describe all pods\n"
"\t\tkubectl describe pods\n"
"\n"
"\t\t# Describe pods by label name=myLabel\n"
"\t\tkubectl describe po -l name=myLabel\n"
"\n"
"\t\t# Describe all pods managed by the 'frontend' replication controller (rc-"
"created pods\n"
"\t\t# get the name of the rc as a prefix in the pod the name).\n"
"\t\tkubectl describe pods frontend"
msgstr ""
"\n"
"\t\t# Describe a node\n"
"\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n"
"\n"
"\t\t# Describe a pod\n"
"\t\tkubectl describe pods/nginx\n"
"\n"
"\t\t# Describe a pod identified by type and name in \"pod.json\"\n"
"\t\tkubectl describe -f pod.json\n"
"\n"
"\t\t# Describe all pods\n"
"\t\tkubectl describe pods\n"
"\n"
"\t\t# Describe pods by label name=myLabel\n"
"\t\tkubectl describe po -l name=myLabel\n"
"\n"
"\t\t# Describe all pods managed by the 'frontend' replication controller (rc-"
"created pods\n"
"\t\t# get the name of the rc as a prefix in the pod the name).\n"
"\t\tkubectl describe pods frontend"

#: pkg/kubectl/cmd/drain.go:165
msgid ""
"\n"
"\t\t# Drain node \"foo\", even if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n"
"\t\t$ kubectl drain foo --force\n"
"\n"
"\t\t# As above, but abort if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a "
"grace period of 15 minutes.\n"
"\t\t$ kubectl drain foo --grace-period=900"
msgstr ""
"\n"
"\t\t# Drain node \"foo\", even if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n"
"\t\t$ kubectl drain foo --force\n"
"\n"
"\t\t# As above, but abort if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a "
"grace period of 15 minutes.\n"
"\t\t$ kubectl drain foo --grace-period=900"

#: pkg/kubectl/cmd/edit.go:80
msgid ""
"\n"
"\t\t# Edit the service named 'docker-registry':\n"
"\t\tkubectl edit svc/docker-registry\n"
"\n"
"\t\t# Use an alternative editor\n"
"\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n"
"\n"
"\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n"
"\t\tkubectl edit job.v1.batch/myjob -o json\n"
"\n"
"\t\t# Edit the deployment 'mydeployment' in YAML and save the modified "
"config in its annotation:\n"
"\t\tkubectl edit deployment/mydeployment -o yaml --save-config"
msgstr ""
"\n"
"\t\t# Edit the service named 'docker-registry':\n"
"\t\tkubectl edit svc/docker-registry\n"
"\n"
"\t\t# Use an alternative editor\n"
"\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n"
"\n"
"\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n"
"\t\tkubectl edit job.v1.batch/myjob -o json\n"
"\n"
"\t\t# Edit the deployment 'mydeployment' in YAML and save the modified "
"config in its annotation:\n"
"\t\tkubectl edit deployment/mydeployment -o yaml --save-config"

#: pkg/kubectl/cmd/exec.go:41
msgid ""
"\n"
"\t\t# Get output from running 'date' from pod 123456-7890, using the first "
"container by default\n"
"\t\tkubectl exec 123456-7890 date\n"
"\n"
"\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n"
"\t\tkubectl exec 123456-7890 -c ruby-container date\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il"
msgstr ""
"\n"
"\t\t# Get output from running 'date' from pod 123456-7890, using the first "
"container by default\n"
"\t\tkubectl exec 123456-7890 date\n"
"\n"
"\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n"
"\t\tkubectl exec 123456-7890 -c ruby-container date\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il"

#: pkg/kubectl/cmd/attach.go:42
msgid ""
"\n"
"\t\t# Get output from running pod 123456-7890, using the first container by "
"default\n"
"\t\tkubectl attach 123456-7890\n"
"\n"
"\t\t# Get output from ruby-container from pod 123456-7890\n"
"\t\tkubectl attach 123456-7890 -c ruby-container\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n"
"\n"
"\t\t# Get output from the first pod of a ReplicaSet named nginx\n"
"\t\tkubectl attach rs/nginx\n"
"\t\t"
msgstr ""
"\n"
"\t\t# Get output from running pod 123456-7890, using the first container by "
"default\n"
"\t\tkubectl attach 123456-7890\n"
"\n"
"\t\t# Get output from ruby-container from pod 123456-7890\n"
"\t\tkubectl attach 123456-7890 -c ruby-container\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n"
"\n"
"\t\t# Get output from the first pod of a ReplicaSet named nginx\n"
"\t\tkubectl attach rs/nginx\n"
"\t\t"

#: pkg/kubectl/cmd/explain.go:39
msgid ""
"\n"
"\t\t# Get the documentation of the resource and its fields\n"
"\t\tkubectl explain pods\n"
"\n"
"\t\t# Get the documentation of a specific field of a resource\n"
"\t\tkubectl explain pods.spec.containers"
msgstr ""
"\n"
"\t\t# Get the documentation of the resource and its fields\n"
"\t\tkubectl explain pods\n"
"\n"
"\t\t# Get the documentation of a specific field of a resource\n"
"\t\tkubectl explain pods.spec.containers"

#: pkg/kubectl/cmd/completion.go:65
msgid ""
"\n"
"\t\t# Install bash completion on a Mac using homebrew\n"
"\t\tbrew install bash-completion\n"
"\t\tprintf \"\n"
"# Bash completion support\n"
"source $(brew --prefix)/etc/bash_completion\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for bash into the current shell\n"
"\t\tsource <(kubectl completion bash)\n"
"\n"
"\t\t# Write bash completion code to a file and source if from .bash_profile\n"
"\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n"
"\t\tprintf \"\n"
"# Kubectl shell completion\n"
"source '$HOME/.kube/completion.bash.inc'\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for zsh[1] into the current shell\n"
"\t\tsource <(kubectl completion zsh)"
msgstr ""
"\n"
"\t\t# Install bash completion on a Mac using homebrew\n"
"\t\tbrew install bash-completion\n"
"\t\tprintf \"\n"
"# Bash completion support\n"
"source $(brew --prefix)/etc/bash_completion\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for bash into the current shell\n"
"\t\tsource <(kubectl completion bash)\n"
"\n"
"\t\t# Write bash completion code to a file and source if from .bash_profile\n"
"\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n"
"\t\tprintf \"\n"
"# Kubectl shell completion\n"
"source '$HOME/.kube/completion.bash.inc'\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for zsh[1] into the current shell\n"
"\t\tsource <(kubectl completion zsh)"

#: pkg/kubectl/cmd/get.go:64
msgid ""
"\n"
"\t\t# List all pods in ps output format.\n"
"\t\tkubectl get pods\n"
"\n"
"\t\t# List all pods in ps output format with more information (such as node "
"name).\n"
"\t\tkubectl get pods -o wide\n"
"\n"
"\t\t# List a single replication controller with specified NAME in ps output "
"format.\n"
"\t\tkubectl get replicationcontroller web\n"
"\n"
"\t\t# List a single pod in JSON output format.\n"
"\t\tkubectl get -o json pod web-pod-13je7\n"
"\n"
"\t\t# List a pod identified by type and name specified in \"pod.yaml\" in "
"JSON output format.\n"
"\t\tkubectl get -f pod.yaml -o json\n"
"\n"
"\t\t# Return only the phase value of the specified pod.\n"
"\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n"
"\n"
"\t\t# List all replication controllers and services together in ps output "
"format.\n"
"\t\tkubectl get rc,services\n"
"\n"
"\t\t# List one or more resources by their type and names.\n"
"\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n"
"\n"
"\t\t# List all resources with different types.\n"
"\t\tkubectl get all"
msgstr ""
"\n"
"\t\t# List all pods in ps output format.\n"
"\t\tkubectl get pods\n"
"\n"
"\t\t# List all pods in ps output format with more information (such as node "
"name).\n"
"\t\tkubectl get pods -o wide\n"
"\n"
"\t\t# List a single replication controller with specified NAME in ps output "
"format.\n"
"\t\tkubectl get replicationcontroller web\n"
"\n"
"\t\t# List a single pod in JSON output format.\n"
"\t\tkubectl get -o json pod web-pod-13je7\n"
"\n"
"\t\t# List a pod identified by type and name specified in \"pod.yaml\" in "
"JSON output format.\n"
"\t\tkubectl get -f pod.yaml -o json\n"
"\n"
"\t\t# Return only the phase value of the specified pod.\n"
"\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n"
"\n"
"\t\t# List all replication controllers and services together in ps output "
"format.\n"
"\t\tkubectl get rc,services\n"
"\n"
"\t\t# List one or more resources by their type and names.\n"
"\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n"
"\n"
"\t\t# List all resources with different types.\n"
"\t\tkubectl get all"

#: pkg/kubectl/cmd/portforward.go:53
msgid ""
"\n"
"\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports "
"5000 and 6000 in the pod\n"
"\t\tkubectl port-forward mypod 5000 6000\n"
"\n"
"\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 8888:5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod :5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 0:5000"
msgstr ""
"\n"
"\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports "
"5000 and 6000 in the pod\n"
"\t\tkubectl port-forward mypod 5000 6000\n"
"\n"
"\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 8888:5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod :5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 0:5000"

#: pkg/kubectl/cmd/drain.go:118
msgid ""
"\n"
"\t\t# Mark node \"foo\" as schedulable.\n"
"\t\t$ kubectl uncordon foo"
msgstr ""
"\n"
"\t\t# Mark node \"foo\" as schedulable.\n"
"\t\t$ kubectl uncordon foo"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L102
#: pkg/kubectl/cmd/drain.go:93
msgid ""
"\n"
"\t\t# Mark node \"foo\" as unschedulable.\n"
"\t\tkubectl cordon foo"
msgstr ""
"\n"
"\t\t# Mark node \"foo\" as unschedulable.\n"
"\t\tkubectl cordon foo"

#: pkg/kubectl/cmd/patch.go:66
msgid ""
"\n"
"\t\t# Partially update a node using strategic merge patch\n"
"\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Partially update a node identified by the type and name specified in "
"\"node.json\" using strategic merge patch\n"
"\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Update a container's image; spec.containers[*].name is required "
"because it's a merge key\n"
"\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":"
"\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n"
"\n"
"\t\t# Update a container's image using a json patch with positional arrays\n"
"\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", "
"\"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'"
msgstr ""
"\n"
"\t\t# Partially update a node using strategic merge patch\n"
"\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Partially update a node identified by the type and name specified in "
"\"node.json\" using strategic merge patch\n"
"\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Update a container's image; spec.containers[*].name is required "
"because it's a merge key\n"
"\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":"
"\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n"
"\n"
"\t\t# Update a container's image using a json patch with positional arrays\n"
"\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", "
"\"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/options.go#L37
#: pkg/kubectl/cmd/options.go:29
msgid ""
"\n"
"\t\t# Print flags inherited by all commands\n"
"\t\tkubectl options"
msgstr ""
"\n"
"\t\t# Print flags inherited by all commands\n"
"\t\tkubectl options"

#: pkg/kubectl/cmd/clusterinfo.go:41
msgid ""
"\n"
"\t\t# Print the address of the master and cluster services\n"
"\t\tkubectl cluster-info"
msgstr ""
"\n"
"\t\t# Print the address of the master and cluster services\n"
"\t\tkubectl cluster-info"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/version.go#L39
#: pkg/kubectl/cmd/version.go:32
msgid ""
"\n"
"\t\t# Print the client and server versions for the current context\n"
"\t\tkubectl version"
msgstr ""
"\n"
"\t\t# Print the client and server versions for the current context\n"
"\t\tkubectl version"

#: pkg/kubectl/cmd/apiversions.go:34
msgid ""
"\n"
"\t\t# Print the supported API versions\n"
"\t\tkubectl api-versions"
msgstr ""
"\n"
"\t\t# Print the supported API versions\n"
"\t\tkubectl api-versions"

#: pkg/kubectl/cmd/replace.go:50
msgid ""
"\n"
"\t\t# Replace a pod using the data in pod.json.\n"
"\t\tkubectl replace -f ./pod.json\n"
"\n"
"\t\t# Replace a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl replace -f -\n"
"\n"
"\t\t# Update a single-container pod's image version (tag) to v4\n"
"\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/:v4/' | "
"kubectl replace -f -\n"
"\n"
"\t\t# Force replace, delete and then re-create the resource\n"
"\t\tkubectl replace --force -f ./pod.json"
msgstr ""
"\n"
"\t\t# Replace a pod using the data in pod.json.\n"
"\t\tkubectl replace -f ./pod.json\n"
"\n"
"\t\t# Replace a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl replace -f -\n"
"\n"
"\t\t# Update a single-container pod's image version (tag) to v4\n"
"\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/:v4/' | "
"kubectl replace -f -\n"
"\n"
"\t\t# Force replace, delete and then re-create the resource\n"
"\t\tkubectl replace --force -f ./pod.json"

#: pkg/kubectl/cmd/logs.go:40
msgid ""
"\n"
"\t\t# Return snapshot logs from pod nginx with only one container\n"
"\t\tkubectl logs nginx\n"
"\n"
"\t\t# Return snapshot logs for the pods defined by label app=nginx\n"
"\t\tkubectl logs -lapp=nginx\n"
"\n"
"\t\t# Return snapshot of previous terminated ruby container logs from pod "
"web-1\n"
"\t\tkubectl logs -p -c ruby web-1\n"
"\n"
"\t\t# Begin streaming the logs of the ruby container in pod web-1\n"
"\t\tkubectl logs -f -c ruby web-1\n"
"\n"
"\t\t# Display only the most recent 20 lines of output in pod nginx\n"
"\t\tkubectl logs --tail=20 nginx\n"
"\n"
"\t\t# Show all logs from pod nginx written in the last hour\n"
"\t\tkubectl logs --since=1h nginx\n"
"\n"
"\t\t# Return snapshot logs from first container of a job named hello\n"
"\t\tkubectl logs job/hello\n"
"\n"
"\t\t# Return snapshot logs from container nginx-1 of a deployment named "
"nginx\n"
"\t\tkubectl logs deployment/nginx -c nginx-1"
msgstr ""
"\n"
"\t\t# Return snapshot logs from pod nginx with only one container\n"
"\t\tkubectl logs nginx\n"
"\n"
"\t\t# Return snapshot logs for the pods defined by label app=nginx\n"
"\t\tkubectl logs -lapp=nginx\n"
"\n"
"\t\t# Return snapshot of previous terminated ruby container logs from pod "
"web-1\n"
"\t\tkubectl logs -p -c ruby web-1\n"
"\n"
"\t\t# Begin streaming the logs of the ruby container in pod web-1\n"
"\t\tkubectl logs -f -c ruby web-1\n"
"\n"
"\t\t# Display only the most recent 20 lines of output in pod nginx\n"
"\t\tkubectl logs --tail=20 nginx\n"
"\n"
"\t\t# Show all logs from pod nginx written in the last hour\n"
"\t\tkubectl logs --since=1h nginx\n"
"\n"
"\t\t# Return snapshot logs from first container of a job named hello\n"
"\t\tkubectl logs job/hello\n"
"\n"
"\t\t# Return snapshot logs from container nginx-1 of a deployment named "
"nginx\n"
"\t\tkubectl logs deployment/nginx -c nginx-1"

#: pkg/kubectl/cmd/proxy.go:53
msgid ""
"\n"
"\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static "
"content from ./local/www/\n"
"\t\tkubectl proxy --port=8011 --www=./local/www/\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n"
"\t\t# The chosen port for the server will be output to stdout.\n"
"\t\tkubectl proxy --port=0\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-"
"api\n"
"\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/"
"pods/\n"
"\t\tkubectl proxy --api-prefix=/k8s-api"
msgstr ""
"\n"
"\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static "
"content from ./local/www/\n"
"\t\tkubectl proxy --port=8011 --www=./local/www/\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n"
"\t\t# The chosen port for the server will be output to stdout.\n"
"\t\tkubectl proxy --port=0\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-"
"api\n"
"\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/"
"pods/\n"
"\t\tkubectl proxy --api-prefix=/k8s-api"

#: pkg/kubectl/cmd/scale.go:43
msgid ""
"\n"
"\t\t# Scale a replicaset named 'foo' to 3.\n"
"\t\tkubectl scale --replicas=3 rs/foo\n"
"\n"
"\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" "
"to 3.\n"
"\t\tkubectl scale --replicas=3 -f foo.yaml\n"
"\n"
"\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n"
"\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n"
"\n"
"\t\t# Scale multiple replication controllers.\n"
"\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n"
"\n"
"\t\t# Scale job named 'cron' to 3.\n"
"\t\tkubectl scale --replicas=3 job/cron"
msgstr ""
"\n"
"\t\t# Scale a replicaset named 'foo' to 3.\n"
"\t\tkubectl scale --replicas=3 rs/foo\n"
"\n"
"\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" "
"to 3.\n"
"\t\tkubectl scale --replicas=3 -f foo.yaml\n"
"\n"
"\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n"
"\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n"
"\n"
"\t\t# Scale multiple replication controllers.\n"
"\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n"
"\n"
"\t\t# Scale job named 'cron' to 3.\n"
"\t\tkubectl scale --replicas=3 job/cron"

#: pkg/kubectl/cmd/apply_set_last_applied.go:67
msgid ""
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml\n"
"\n"
"\t\t# Execute set-last-applied against each configuration file in a "
"directory.\n"
"\t\tkubectl apply set-last-applied -f path/\n"
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file, will create the annotation if it does not already exist.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n"
"\t\t"
msgstr ""
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml\n"
"\n"
"\t\t# Execute set-last-applied against each configuration file in a "
"directory.\n"
"\t\tkubectl apply set-last-applied -f path/\n"
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file, will create the annotation if it does not already exist.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n"
"\t\t"

#: pkg/kubectl/cmd/top_pod.go:61
msgid ""
"\n"
"\t\t# Show metrics for all pods in the default namespace\n"
"\t\tkubectl top pod\n"
"\n"
"\t\t# Show metrics for all pods in the given namespace\n"
"\t\tkubectl top pod --namespace=NAMESPACE\n"
"\n"
"\t\t# Show metrics for a given pod and its containers\n"
"\t\tkubectl top pod POD_NAME --containers\n"
"\n"
"\t\t# Show metrics for the pods defined by label name=myLabel\n"
"\t\tkubectl top pod -l name=myLabel"
msgstr ""
"\n"
"\t\t# Show metrics for all pods in the default namespace\n"
"\t\tkubectl top pod\n"
"\n"
"\t\t# Show metrics for all pods in the given namespace\n"
"\t\tkubectl top pod --namespace=NAMESPACE\n"
"\n"
"\t\t# Show metrics for a given pod and its containers\n"
"\t\tkubectl top pod POD_NAME --containers\n"
"\n"
"\t\t# Show metrics for the pods defined by label name=myLabel\n"
"\t\tkubectl top pod -l name=myLabel"

#: pkg/kubectl/cmd/stop.go:40
msgid ""
"\n"
"\t\t# Shut down foo.\n"
"\t\tkubectl stop replicationcontroller foo\n"
"\n"
"\t\t# Stop pods and services with label name=myLabel.\n"
"\t\tkubectl stop pods,services -l name=myLabel\n"
"\n"
"\t\t# Shut down the service defined in service.json\n"
"\t\tkubectl stop -f service.json\n"
"\n"
"\t\t# Shut down all resources in the path/to/resources directory\n"
"\t\tkubectl stop -f path/to/resources"
msgstr ""
"\n"
"\t\t# Shut down foo.\n"
"\t\tkubectl stop replicationcontroller foo\n"
"\n"
"\t\t# Stop pods and services with label name=myLabel.\n"
"\t\tkubectl stop pods,services -l name=myLabel\n"
"\n"
"\t\t# Shut down the service defined in service.json\n"
"\t\tkubectl stop -f service.json\n"
"\n"
"\t\t# Shut down all resources in the path/to/resources directory\n"
"\t\tkubectl stop -f path/to/resources"

#: pkg/kubectl/cmd/run.go:57
msgid ""
"\n"
"\t\t# Start a single instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx\n"
"\n"
"\t\t# Start a single instance of hazelcast and let the container expose port "
"5701 .\n"
"\t\tkubectl run hazelcast --image=hazelcast --port=5701\n"
"\n"
"\t\t# Start a single instance of hazelcast and set environment variables "
"\"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n"
"\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --"
"env=\"POD_NAMESPACE=default\"\n"
"\n"
"\t\t# Start a replicated instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx --replicas=5\n"
"\n"
"\t\t# Dry run. Print the corresponding API objects without creating them.\n"
"\t\tkubectl run nginx --image=nginx --dry-run\n"
"\n"
"\t\t# Start a single instance of nginx, but overload the spec of the "
"deployment with a partial set of values parsed from JSON.\n"
"\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", "
"\"spec\": { ... } }'\n"
"\n"
"\t\t# Start a pod of busybox and keep it in the foreground, don't restart it "
"if it exits.\n"
"\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n"
"\n"
"\t\t# Start the nginx container using the default command, but use custom "
"arguments (arg1 .. argN) for that command.\n"
"\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n"
"\n"
"\t\t# Start the nginx container using a different command and custom "
"arguments.\n"
"\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n"
"\n"
"\t\t# Start the perl container to compute π to 2000 places and print it "
"out.\n"
"\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -"
"wle 'print bpi(2000)'\n"
"\n"
"\t\t# Start the cron job to compute π to 2000 places and print it out every "
"5 minutes.\n"
"\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --"
"restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'"
msgstr ""
"\n"
"\t\t# Start a single instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx\n"
"\n"
"\t\t# Start a single instance of hazelcast and let the container expose port "
"5701 .\n"
"\t\tkubectl run hazelcast --image=hazelcast --port=5701\n"
"\n"
"\t\t# Start a single instance of hazelcast and set environment variables "
"\"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n"
"\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --"
"env=\"POD_NAMESPACE=default\"\n"
"\n"
"\t\t# Start a replicated instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx --replicas=5\n"
"\n"
"\t\t# Dry run. Print the corresponding API objects without creating them.\n"
"\t\tkubectl run nginx --image=nginx --dry-run\n"
"\n"
"\t\t# Start a single instance of nginx, but overload the spec of the "
"deployment with a partial set of values parsed from JSON.\n"
"\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", "
"\"spec\": { ... } }'\n"
"\n"
"\t\t# Start a pod of busybox and keep it in the foreground, don't restart it "
"if it exits.\n"
"\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n"
"\n"
"\t\t# Start the nginx container using the default command, but use custom "
"arguments (arg1 .. argN) for that command.\n"
"\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n"
"\n"
"\t\t# Start the nginx container using a different command and custom "
"arguments.\n"
"\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n"
"\n"
"\t\t# Start the perl container to compute π to 2000 places and print it "
"out.\n"
"\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -"
"wle 'print bpi(2000)'\n"
"\n"
"\t\t# Start the cron job to compute π to 2000 places and print it out every "
"5 minutes.\n"
"\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --"
"restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'"

#: pkg/kubectl/cmd/taint.go:67
msgid ""
"\n"
"\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-"
"user' and effect 'NoSchedule'.\n"
"\t\t# If a taint with that key and effect already exists, its value is "
"replaced as specified.\n"
"\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n"
"\n"
"\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect "
"'NoSchedule' if one exists.\n"
"\t\tkubectl taint nodes foo dedicated:NoSchedule-\n"
"\n"
"\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n"
"\t\tkubectl taint nodes foo dedicated-"
msgstr ""
"\n"
"\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-"
"user' and effect 'NoSchedule'.\n"
"\t\t# If a taint with that key and effect already exists, its value is "
"replaced as specified.\n"
"\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n"
"\n"
"\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect "
"'NoSchedule' if one exists.\n"
"\t\tkubectl taint nodes foo dedicated:NoSchedule-\n"
"\n"
"\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n"
"\t\tkubectl taint nodes foo dedicated-"

#: pkg/kubectl/cmd/label.go:77
msgid ""
"\n"
"\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n"
"\t\tkubectl label pods foo unhealthy=true\n"
"\n"
"\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', "
"overwriting any existing value.\n"
"\t\tkubectl label --overwrite pods foo status=unhealthy\n"
"\n"
"\t\t# Update all pods in the namespace\n"
"\t\tkubectl label pods --all status=unhealthy\n"
"\n"
"\t\t# Update a pod identified by the type and name in \"pod.json\"\n"
"\t\tkubectl label -f pod.json status=unhealthy\n"
"\n"
"\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n"
"\t\tkubectl label pods foo status=unhealthy --resource-version=1\n"
"\n"
"\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n"
"\t\t# Does not require the --overwrite flag.\n"
"\t\tkubectl label pods foo bar-"
msgstr ""
"\n"
"\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n"
"\t\tkubectl label pods foo unhealthy=true\n"
"\n"
"\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', "
"overwriting any existing value.\n"
"\t\tkubectl label --overwrite pods foo status=unhealthy\n"
"\n"
"\t\t# Update all pods in the namespace\n"
"\t\tkubectl label pods --all status=unhealthy\n"
"\n"
"\t\t# Update a pod identified by the type and name in \"pod.json\"\n"
"\t\tkubectl label -f pod.json status=unhealthy\n"
"\n"
"\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n"
"\t\tkubectl label pods foo status=unhealthy --resource-version=1\n"
"\n"
"\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n"
"\t\t# Does not require the --overwrite flag.\n"
"\t\tkubectl label pods foo bar-"

#: pkg/kubectl/cmd/rollingupdate.go:54
msgid ""
"\n"
"\t\t# Update pods of frontend-v1 using new replication controller data in "
"frontend-v2.json.\n"
"\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n"
"\n"
"\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n"
"\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n"
"\n"
"\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the "
"image, and switching the\n"
"\t\t# name of the replication controller.\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n"
"\n"
"\t\t# Update the pods of frontend by just changing the image, and keeping "
"the old name.\n"
"\t\tkubectl rolling-update frontend --image=image:v2\n"
"\n"
"\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to "
"frontend-v2).\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback"
msgstr ""
"\n"
"\t\t# Update pods of frontend-v1 using new replication controller data in "
"frontend-v2.json.\n"
"\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n"
"\n"
"\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n"
"\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n"
"\n"
"\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the "
"image, and switching the\n"
"\t\t# name of the replication controller.\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n"
"\n"
"\t\t# Update the pods of frontend by just changing the image, and keeping "
"the old name.\n"
"\t\tkubectl rolling-update frontend --image=image:v2\n"
"\n"
"\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to "
"frontend-v2).\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback"

#: pkg/kubectl/cmd/apply_view_last_applied.go:52
msgid ""
"\n"
"\t\t# View the last-applied-configuration annotations by type/name in YAML.\n"
"\t\tkubectl apply view-last-applied deployment/nginx\n"
"\n"
"\t\t# View the last-applied-configuration annotations by file in JSON\n"
"\t\tkubectl apply view-last-applied -f deploy.yaml -o json"
msgstr ""
"\n"
"\t\t# View the last-applied-configuration annotations by type/name in YAML.\n"
"\t\tkubectl apply view-last-applied deployment/nginx\n"
"\n"
"\t\t# View the last-applied-configuration annotations by file in JSON\n"
"\t\tkubectl apply view-last-applied -f deploy.yaml -o json"

#: pkg/kubectl/cmd/apply.go:75
msgid ""
"\n"
"\t\tApply a configuration to a resource by filename or stdin.\n"
"\t\tThis resource will be created if it doesn't exist yet.\n"
"\t\tTo use 'apply', always create the resource initially with either 'apply' "
"or 'create --save-config'.\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not "
"use unless you are aware of what the current state is. See https://issues."
"k8s.io/34274."
msgstr ""
"\n"
"\t\tApply a configuration to a resource by filename or stdin.\n"
"\t\tThis resource will be created if it doesn't exist yet.\n"
"\t\tTo use 'apply', always create the resource initially with either 'apply' "
"or 'create --save-config'.\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not "
"use unless you are aware of what the current state is. See https://issues."
"k8s.io/34274."

#: pkg/kubectl/cmd/convert.go:38
msgid ""
"\n"
"\t\tConvert config files between different API versions. Both YAML\n"
"\t\tand JSON formats are accepted.\n"
"\n"
"\t\tThe command takes filename, directory, or URL as input, and convert it "
"into format\n"
"\t\tof version specified by --output-version flag. If target version is not "
"specified or\n"
"\t\tnot supported, convert to latest version.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change to output destination."
msgstr ""
"\n"
"\t\tConvert config files between different API versions. Both YAML\n"
"\t\tand JSON formats are accepted.\n"
"\n"
"\t\tThe command takes filename, directory, or URL as input, and convert it "
"into format\n"
"\t\tof version specified by --output-version flag. If target version is not "
"specified or\n"
"\t\tnot supported, convert to latest version.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change to output destination."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L68
#: pkg/kubectl/cmd/create_clusterrole.go:31
msgid ""
"\n"
"\t\tCreate a ClusterRole."
msgstr ""
"\n"
"\t\tCreate a ClusterRole."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_clusterrolebinding.go#L43
#: pkg/kubectl/cmd/create_clusterrolebinding.go:32
msgid ""
"\n"
"\t\tCreate a ClusterRoleBinding for a particular ClusterRole."
msgstr ""
"\n"
"\t\tCreate a ClusterRoleBinding for a particular ClusterRole."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_rolebinding.go#L43
#: pkg/kubectl/cmd/create_rolebinding.go:32
msgid ""
"\n"
"\t\tCreate a RoleBinding for a particular Role or ClusterRole."
msgstr ""
"\n"
"\t\tCreate a RoleBinding for a particular Role or ClusterRole."

#: pkg/kubectl/cmd/create_secret.go:200
msgid ""
"\n"
"\t\tCreate a TLS secret from the given public/private key pair.\n"
"\n"
"\t\tThe public/private key pair must exist before hand. The public key "
"certificate must be .PEM encoded and match the given private key."
msgstr ""
"\n"
"\t\tCreate a TLS secret from the given public/private key pair.\n"
"\n"
"\t\tThe public/private key pair must exist before hand. The public key "
"certificate must be .PEM encoded and match the given private key."

#: pkg/kubectl/cmd/create_configmap.go:32
msgid ""
"\n"
"\t\tCreate a configmap based on a file, directory, or specified literal "
"value.\n"
"\n"
"\t\tA single configmap may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a configmap based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a configmap based on a directory, each file whose basename "
"is a valid key in the directory will be\n"
"\t\tpackaged into the configmap.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."
msgstr ""
"\n"
"\t\tCreate a configmap based on a file, directory, or specified literal "
"value.\n"
"\n"
"\t\tA single configmap may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a configmap based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a configmap based on a directory, each file whose basename "
"is a valid key in the directory will be\n"
"\t\tpackaged into the configmap.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_namespace.go#L44
#: pkg/kubectl/cmd/create_namespace.go:32
msgid ""
"\n"
"\t\tCreate a namespace with the specified name."
msgstr ""
"\n"
"\t\tCreate a namespace with the specified name."

#: pkg/kubectl/cmd/create_secret.go:119
msgid ""
"\n"
"\t\tCreate a new secret for use with Docker registries.\n"
"\n"
"\t\tDockercfg secrets are used to authenticate against Docker registries.\n"
"\n"
"\t\tWhen using the Docker command line to push images, you can authenticate "
"to a given registry by running\n"
"\n"
"\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --"
"password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n"
"\n"
"    That produces a ~/.dockercfg file that is used by subsequent 'docker "
"push' and 'docker pull' commands to\n"
"\t\tauthenticate to the registry. The email address is optional.\n"
"\n"
"\t\tWhen creating applications, you may have a Docker registry that requires "
"authentication.  In order for the\n"
"\t\tnodes to pull images on your behalf, they have to have the credentials.  "
"You can provide this information\n"
"\t\tby creating a dockercfg secret and attaching it to your service account."
msgstr ""
"\n"
"\t\tCreate a new secret for use with Docker registries.\n"
"\n"
"\t\tDockercfg secrets are used to authenticate against Docker registries.\n"
"\n"
"\t\tWhen using the Docker command line to push images, you can authenticate "
"to a given registry by running\n"
"\n"
"\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --"
"password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n"
"\n"
"    That produces a ~/.dockercfg file that is used by subsequent 'docker "
"push' and 'docker pull' commands to\n"
"\t\tauthenticate to the registry. The email address is optional.\n"
"\n"
"\t\tWhen creating applications, you may have a Docker registry that requires "
"authentication.  In order for the\n"
"\t\tnodes to pull images on your behalf, they have to have the credentials.  "
"You can provide this information\n"
"\t\tby creating a dockercfg secret and attaching it to your service account."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_pdb.go#L49
#: pkg/kubectl/cmd/create_pdb.go:32
msgid ""
"\n"
"\t\tCreate a pod disruption budget with the specified name, selector, and "
"desired minimum available pods"
msgstr ""
"\n"
"\t\tCreate a pod disruption budget with the specified name, selector, and "
"desired minimum available pods"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create.go#L56
#: pkg/kubectl/cmd/create.go:42
msgid ""
"\n"
"\t\tCreate a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted."
msgstr ""
"\n"
"\t\tCreate a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L47
#: pkg/kubectl/cmd/create_quota.go:32
msgid ""
"\n"
"\t\tCreate a resourcequota with the specified name, hard limits and optional "
"scopes"
msgstr ""
"\n"
"\t\tCreate a resourcequota with the specified name, hard limits and optional "
"scopes"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L47
#: pkg/kubectl/cmd/create_role.go:38
msgid ""
"\n"
"\t\tCreate a role with single rule."
msgstr ""
"\n"
"\t\tCreate a role with single rule."

#: pkg/kubectl/cmd/create_secret.go:47
msgid ""
"\n"
"\t\tCreate a secret based on a file, directory, or specified literal value.\n"
"\n"
"\t\tA single secret may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a secret based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a secret based on a directory, each file whose basename is "
"a valid key in the directory will be\n"
"\t\tpackaged into the secret.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."
msgstr ""
"\n"
"\t\tCreate a secret based on a file, directory, or specified literal value.\n"
"\n"
"\t\tA single secret may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a secret based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a secret based on a directory, each file whose basename is "
"a valid key in the directory will be\n"
"\t\tpackaged into the secret.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_serviceaccount.go#L44
#: pkg/kubectl/cmd/create_serviceaccount.go:32
msgid ""
"\n"
"\t\tCreate a service account with the specified name."
msgstr ""
"\n"
"\t\tCreate a service account with the specified name."

#: pkg/kubectl/cmd/run.go:52
msgid ""
"\n"
"\t\tCreate and run a particular image, possibly replicated.\n"
"\n"
"\t\tCreates a deployment or job to manage the created container(s)."
msgstr ""
"\n"
"\t\tCreate and run a particular image, possibly replicated.\n"
"\n"
"\t\tCreates a deployment or job to manage the created container(s)."

#: pkg/kubectl/cmd/autoscale.go:34
msgid ""
"\n"
"\t\tCreates an autoscaler that automatically chooses and sets the number of "
"pods that run in a kubernetes cluster.\n"
"\n"
"\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and "
"creates an autoscaler that uses the given resource as a reference.\n"
"\t\tAn autoscaler can automatically increase or decrease number of pods "
"deployed within the system as needed."
msgstr ""
"\n"
"\t\tCreates an autoscaler that automatically chooses and sets the number of "
"pods that run in a kubernetes cluster.\n"
"\n"
"\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and "
"creates an autoscaler that uses the given resource as a reference.\n"
"\t\tAn autoscaler can automatically increase or decrease number of pods "
"deployed within the system as needed."

#: pkg/kubectl/cmd/delete.go:40
msgid ""
"\n"
"\t\tDelete resources by filenames, stdin, resources and names, or by "
"resources and label selector.\n"
"\n"
"\t\tJSON and YAML formats are accepted. Only one type of the arguments may "
"be specified: filenames,\n"
"\t\tresources and names, or resources and label selector.\n"
"\n"
"\t\tSome resources, such as pods, support graceful deletion. These resources "
"define a default period\n"
"\t\tbefore they are forcibly terminated (the grace period) but you may "
"override that value with\n"
"\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. "
"Because these resources often\n"
"\t\trepresent entities in the cluster, deletion may not be acknowledged "
"immediately. If the node\n"
"\t\thosting a pod is down or cannot reach the API server, termination may "
"take significantly longer\n"
"\t\tthan the grace period. To force delete a resource,\tyou must pass a grace"
"\tperiod of 0 and specify\n"
"\t\tthe --force flag.\n"
"\n"
"\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the "
"pod's processes have been\n"
"\t\tterminated, which can leave those processes running until the node "
"detects the deletion and\n"
"\t\tcompletes graceful deletion. If your processes use shared storage or "
"talk to a remote API and\n"
"\t\tdepend on the name of the pod to identify themselves, force deleting "
"those pods may result in\n"
"\t\tmultiple processes running on different machines using the same "
"identification which may lead\n"
"\t\tto data corruption or inconsistency. Only force delete pods when you are "
"sure the pod is\n"
"\t\tterminated, or if your application can tolerate multiple copies of the "
"same pod running at once.\n"
"\t\tAlso, if you force delete pods the scheduler may place new pods on those "
"nodes before the node\n"
"\t\thas released those resources and causing those pods to be evicted "
"immediately.\n"
"\n"
"\t\tNote that the delete command does NOT do resource version checks, so if "
"someone\n"
"\t\tsubmits an update to a resource right when you submit a delete, their "
"update\n"
"\t\twill be lost along with the rest of the resource."
msgstr ""
"\n"
"\t\tDelete resources by filenames, stdin, resources and names, or by "
"resources and label selector.\n"
"\n"
"\t\tJSON and YAML formats are accepted. Only one type of the arguments may "
"be specified: filenames,\n"
"\t\tresources and names, or resources and label selector.\n"
"\n"
"\t\tSome resources, such as pods, support graceful deletion. These resources "
"define a default period\n"
"\t\tbefore they are forcibly terminated (the grace period) but you may "
"override that value with\n"
"\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. "
"Because these resources often\n"
"\t\trepresent entities in the cluster, deletion may not be acknowledged "
"immediately. If the node\n"
"\t\thosting a pod is down or cannot reach the API server, termination may "
"take significantly longer\n"
"\t\tthan the grace period. To force delete a resource,\tyou must pass a grace"
"\tperiod of 0 and specify\n"
"\t\tthe --force flag.\n"
"\n"
"\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the "
"pod's processes have been\n"
"\t\tterminated, which can leave those processes running until the node "
"detects the deletion and\n"
"\t\tcompletes graceful deletion. If your processes use shared storage or "
"talk to a remote API and\n"
"\t\tdepend on the name of the pod to identify themselves, force deleting "
"those pods may result in\n"
"\t\tmultiple processes running on different machines using the same "
"identification which may lead\n"
"\t\tto data corruption or inconsistency. Only force delete pods when you are "
"sure the pod is\n"
"\t\tterminated, or if your application can tolerate multiple copies of the "
"same pod running at once.\n"
"\t\tAlso, if you force delete pods the scheduler may place new pods on those "
"nodes before the node\n"
"\t\thas released those resources and causing those pods to be evicted "
"immediately.\n"
"\n"
"\t\tNote that the delete command does NOT do resource version checks, so if "
"someone\n"
"\t\tsubmits an update to a resource right when you submit a delete, their "
"update\n"
"\t\twill be lost along with the rest of the resource."

#: pkg/kubectl/cmd/stop.go:31
msgid ""
"\n"
"\t\tDeprecated: Gracefully shut down a resource by name or filename.\n"
"\n"
"\t\tThe stop command is deprecated, all its functionalities are covered by "
"delete command.\n"
"\t\tSee 'kubectl delete --help' for more details.\n"
"\n"
"\t\tAttempts to shut down and delete a resource that supports graceful "
"termination.\n"
"\t\tIf the resource is scalable it will be scaled to 0 before deletion."
msgstr ""
"\n"
"\t\tDeprecated: Gracefully shut down a resource by name or filename.\n"
"\n"
"\t\tThe stop command is deprecated, all its functionalities are covered by "
"delete command.\n"
"\t\tSee 'kubectl delete --help' for more details.\n"
"\n"
"\t\tAttempts to shut down and delete a resource that supports graceful "
"termination.\n"
"\t\tIf the resource is scalable it will be scaled to 0 before deletion."

#: pkg/kubectl/cmd/top_node.go:60
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n"
"\n"
"\t\tThe top-node command allows you to see the resource consumption of nodes."
msgstr ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n"
"\n"
"\t\tThe top-node command allows you to see the resource consumption of nodes."

#: pkg/kubectl/cmd/top_pod.go:53
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n"
"\n"
"\t\tThe 'top pod' command allows you to see the resource consumption of "
"pods.\n"
"\n"
"\t\tDue to the metrics pipeline delay, they may be unavailable for a few "
"minutes\n"
"\t\tsince pod creation."
msgstr ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n"
"\n"
"\t\tThe 'top pod' command allows you to see the resource consumption of "
"pods.\n"
"\n"
"\t\tDue to the metrics pipeline delay, they may be unavailable for a few "
"minutes\n"
"\t\tsince pod creation."

#: pkg/kubectl/cmd/top.go:33
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage.\n"
"\n"
"\t\tThe top command allows you to see the resource consumption for nodes or "
"pods.\n"
"\n"
"\t\tThis command requires Heapster to be correctly configured and working on "
"the server. "
msgstr ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage.\n"
"\n"
"\t\tThe top command allows you to see the resource consumption for nodes or "
"pods.\n"
"\n"
"\t\tThis command requires Heapster to be correctly configured and working on "
"the server. "

#: pkg/kubectl/cmd/drain.go:140
msgid ""
"\n"
"\t\tDrain node in preparation for maintenance.\n"
"\n"
"\t\tThe given node will be marked unschedulable to prevent new pods from "
"arriving.\n"
"\t\t'drain' evicts the pods if the APIServer supports eviction\n"
"\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use "
"normal DELETE\n"
"\t\tto delete the pods.\n"
"\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot "
"be deleted through\n"
"\t\tthe API server).  If there are DaemonSet-managed pods, drain will not "
"proceed\n"
"\t\twithout --ignore-daemonsets, and regardless it will not delete any\n"
"\t\tDaemonSet-managed pods, because those pods would be immediately replaced "
"by the\n"
"\t\tDaemonSet controller, which ignores unschedulable markings.  If there "
"are any\n"
"\t\tpods that are neither mirror pods nor managed by ReplicationController,\n"
"\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete "
"any pods unless you\n"
"\t\tuse --force.  --force will also allow deletion to proceed if the "
"managing resource of one\n"
"\t\tor more pods is missing.\n"
"\n"
"\t\t'drain' waits for graceful termination. You should not operate on the "
"machine until\n"
"\t\tthe command completes.\n"
"\n"
"\t\tWhen you are ready to put the node back into service, use kubectl "
"uncordon, which\n"
"\t\twill make the node schedulable again.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)"
msgstr ""
"\n"
"\t\tDrain node in preparation for maintenance.\n"
"\n"
"\t\tThe given node will be marked unschedulable to prevent new pods from "
"arriving.\n"
"\t\t'drain' evicts the pods if the APIServer supports eviction\n"
"\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use "
"normal DELETE\n"
"\t\tto delete the pods.\n"
"\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot "
"be deleted through\n"
"\t\tthe API server).  If there are DaemonSet-managed pods, drain will not "
"proceed\n"
"\t\twithout --ignore-daemonsets, and regardless it will not delete any\n"
"\t\tDaemonSet-managed pods, because those pods would be immediately replaced "
"by the\n"
"\t\tDaemonSet controller, which ignores unschedulable markings.  If there "
"are any\n"
"\t\tpods that are neither mirror pods nor managed by ReplicationController,\n"
"\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete "
"any pods unless you\n"
"\t\tuse --force.  --force will also allow deletion to proceed if the "
"managing resource of one\n"
"\t\tor more pods is missing.\n"
"\n"
"\t\t'drain' waits for graceful termination. You should not operate on the "
"machine until\n"
"\t\tthe command completes.\n"
"\n"
"\t\tWhen you are ready to put the node back into service, use kubectl "
"uncordon, which\n"
"\t\twill make the node schedulable again.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)"

#: pkg/kubectl/cmd/edit.go:56
msgid ""
"\n"
"\t\tEdit a resource from the default editor.\n"
"\n"
"\t\tThe edit command allows you to directly edit any API resource you can "
"retrieve via the\n"
"\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, "
"or EDITOR\n"
"\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for "
"Windows.\n"
"\t\tYou can edit multiple objects, although changes are applied one at a "
"time. The command\n"
"\t\taccepts filenames as well as command line arguments, although the files "
"you point to must\n"
"\t\tbe previously saved versions of resources.\n"
"\n"
"\t\tEditing is done with the API version used to fetch the resource.\n"
"\t\tTo edit using a specific API version, fully-qualify the resource, "
"version, and group.\n"
"\n"
"\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n"
"\n"
"\t\tThe flag --windows-line-endings can be used to force Windows line "
"endings,\n"
"\t\totherwise the default for your operating system will be used.\n"
"\n"
"\t\tIn the event an error occurs while updating, a temporary file will be "
"created on disk\n"
"\t\tthat contains your unapplied changes. The most common error when "
"updating a resource\n"
"\t\tis another editor changing the resource on the server. When this occurs, "
"you will have\n"
"\t\tto apply your changes to the newer version of the resource, or update "
"your temporary\n"
"\t\tsaved copy to include the latest resource version."
msgstr ""
"\n"
"\t\tEdit a resource from the default editor.\n"
"\n"
"\t\tThe edit command allows you to directly edit any API resource you can "
"retrieve via the\n"
"\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, "
"or EDITOR\n"
"\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for "
"Windows.\n"
"\t\tYou can edit multiple objects, although changes are applied one at a "
"time. The command\n"
"\t\taccepts filenames as well as command line arguments, although the files "
"you point to must\n"
"\t\tbe previously saved versions of resources.\n"
"\n"
"\t\tEditing is done with the API version used to fetch the resource.\n"
"\t\tTo edit using a specific API version, fully-qualify the resource, "
"version, and group.\n"
"\n"
"\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n"
"\n"
"\t\tThe flag --windows-line-endings can be used to force Windows line "
"endings,\n"
"\t\totherwise the default for your operating system will be used.\n"
"\n"
"\t\tIn the event an error occurs while updating, a temporary file will be "
"created on disk\n"
"\t\tthat contains your unapplied changes. The most common error when "
"updating a resource\n"
"\t\tis another editor changing the resource on the server. When this occurs, "
"you will have\n"
"\t\tto apply your changes to the newer version of the resource, or update "
"your temporary\n"
"\t\tsaved copy to include the latest resource version."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L127
#: pkg/kubectl/cmd/drain.go:115
msgid ""
"\n"
"\t\tMark node as schedulable."
msgstr ""
"\n"
"\t\tMark node as schedulable."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L102
#: pkg/kubectl/cmd/drain.go:90
msgid ""
"\n"
"\t\tMark node as unschedulable."
msgstr ""
"\n"
"\t\tMark node as unschedulable."

#: pkg/kubectl/cmd/completion.go:47
msgid ""
"\n"
"\t\tOutput shell completion code for the specified shell (bash or zsh).\n"
"\t\tThe shell code must be evalutated to provide interactive\n"
"\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n"
"\t\tthe .bash_profile.\n"
"\n"
"\t\tNote: this requires the bash-completion framework, which is not "
"installed\n"
"\t\tby default on Mac.  This can be installed by using homebrew:\n"
"\n"
"\t\t    $ brew install bash-completion\n"
"\n"
"\t\tOnce installed, bash_completion must be evaluated.  This can be done by "
"adding the\n"
"\t\tfollowing line to the .bash_profile\n"
"\n"
"\t\t    $ source $(brew --prefix)/etc/bash_completion\n"
"\n"
"\t\tNote for zsh users: [1] zsh completions are only supported in versions "
"of zsh >= 5.2"
msgstr ""
"\n"
"\t\tOutput shell completion code for the specified shell (bash or zsh).\n"
"\t\tThe shell code must be evalutated to provide interactive\n"
"\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n"
"\t\tthe .bash_profile.\n"
"\n"
"\t\tNote: this requires the bash-completion framework, which is not "
"installed\n"
"\t\tby default on Mac.  This can be installed by using homebrew:\n"
"\n"
"\t\t    $ brew install bash-completion\n"
"\n"
"\t\tOnce installed, bash_completion must be evaluated.  This can be done by "
"adding the\n"
"\t\tfollowing line to the .bash_profile\n"
"\n"
"\t\t    $ source $(brew --prefix)/etc/bash_completion\n"
"\n"
"\t\tNote for zsh users: [1] zsh completions are only supported in versions "
"of zsh >= 5.2"

#: pkg/kubectl/cmd/rollingupdate.go:45
msgid ""
"\n"
"\t\tPerform a rolling update of the given ReplicationController.\n"
"\n"
"\t\tReplaces the specified replication controller with a new replication "
"controller by updating one pod at a time to use the\n"
"\t\tnew PodTemplate. The new-controller.json must specify the same namespace "
"as the\n"
"\t\texisting replication controller and overwrite at least one (common) "
"label in its replicaSelector.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)"
msgstr ""
"\n"
"\t\tPerform a rolling update of the given ReplicationController.\n"
"\n"
"\t\tReplaces the specified replication controller with a new replication "
"controller by updating one pod at a time to use the\n"
"\t\tnew PodTemplate. The new-controller.json must specify the same namespace "
"as the\n"
"\t\texisting replication controller and overwrite at least one (common) "
"label in its replicaSelector.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)"

#: pkg/kubectl/cmd/replace.go:40
msgid ""
"\n"
"\t\tReplace a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted. If replacing an existing resource, "
"the\n"
"\t\tcomplete resource spec must be provided. This can be obtained by\n"
"\n"
"\t\t    $ kubectl get TYPE NAME -o yaml\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."
msgstr ""
"\n"
"\t\tReplace a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted. If replacing an existing resource, "
"the\n"
"\t\tcomplete resource spec must be provided. This can be obtained by\n"
"\n"
"\t\t    $ kubectl get TYPE NAME -o yaml\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."

#: pkg/kubectl/cmd/scale.go:34
msgid ""
"\n"
"\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or "
"Job.\n"
"\n"
"\t\tScale also allows users to specify one or more preconditions for the "
"scale action.\n"
"\n"
"\t\tIf --current-replicas or --resource-version is specified, it is "
"validated before the\n"
"\t\tscale is attempted, and it is guaranteed that the precondition holds "
"true when the\n"
"\t\tscale is sent to the server."
msgstr ""
"\n"
"\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or "
"Job.\n"
"\n"
"\t\tScale also allows users to specify one or more preconditions for the "
"scale action.\n"
"\n"
"\t\tIf --current-replicas or --resource-version is specified, it is "
"validated before the\n"
"\t\tscale is attempted, and it is guaranteed that the precondition holds "
"true when the\n"
"\t\tscale is sent to the server."

#: pkg/kubectl/cmd/apply_set_last_applied.go:62
msgid ""
"\n"
"\t\tSet the latest last-applied-configuration annotations by setting it to "
"match the contents of a file.\n"
"\t\tThis results in the last-applied-configuration being updated as though "
"'kubectl apply -f <file>' was run,\n"
"\t\twithout updating any other parts of the object."
msgstr ""
"\n"
"\t\tSet the latest last-applied-configuration annotations by setting it to "
"match the contents of a file.\n"
"\t\tThis results in the last-applied-configuration being updated as though "
"'kubectl apply -f <file>' was run,\n"
"\t\twithout updating any other parts of the object."

#: pkg/kubectl/cmd/proxy.go:36
msgid ""
"\n"
"\t\tTo proxy all of the kubernetes api and nothing else, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/\n"
"\n"
"\t\tTo proxy only part of the kubernetes api and also some static files:\n"
"\n"
"\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/"
"api/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n"
"\n"
"\t\tTo proxy the entire kubernetes api at a different root, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/custom/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'"
msgstr ""
"\n"
"\t\tTo proxy all of the kubernetes api and nothing else, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/\n"
"\n"
"\t\tTo proxy only part of the kubernetes api and also some static files:\n"
"\n"
"\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/"
"api/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n"
"\n"
"\t\tTo proxy the entire kubernetes api at a different root, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/custom/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'"

#: pkg/kubectl/cmd/patch.go:59
msgid ""
"\n"
"\t\tUpdate field(s) of a resource using strategic merge patch\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."
msgstr ""
"\n"
"\t\tUpdate field(s) of a resource using strategic merge patch\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."

#: pkg/kubectl/cmd/label.go:70
#, c-format
msgid ""
"\n"
"\t\tUpdate the labels on a resource.\n"
"\n"
"\t\t* A label must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* If --overwrite is true, then existing labels can be overwritten, "
"otherwise attempting to overwrite a label will result in an error.\n"
"\t\t* If --resource-version is specified, then updates will use this "
"resource version, otherwise the existing resource-version will be used."
msgstr ""
"\n"
"\t\tUpdate the labels on a resource.\n"
"\n"
"\t\t* A label must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* If --overwrite is true, then existing labels can be overwritten, "
"otherwise attempting to overwrite a label will result in an error.\n"
"\t\t* If --resource-version is specified, then updates will use this "
"resource version, otherwise the existing resource-version will be used."

#: pkg/kubectl/cmd/taint.go:58
#, c-format
msgid ""
"\n"
"\t\tUpdate the taints on one or more nodes.\n"
"\n"
"\t\t* A taint consists of a key, value, and effect. As an argument here, it "
"is expressed as key=value:effect.\n"
"\t\t* The key must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* The value must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[2]d characters.\n"
"\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n"
"\t\t* Currently taint can only apply to node."
msgstr ""
"\n"
"\t\tUpdate the taints on one or more nodes.\n"
"\n"
"\t\t* A taint consists of a key, value, and effect. As an argument here, it "
"is expressed as key=value:effect.\n"
"\t\t* The key must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* The value must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[2]d characters.\n"
"\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n"
"\t\t* Currently taint can only apply to node."

#: pkg/kubectl/cmd/apply_view_last_applied.go:46
msgid ""
"\n"
"\t\tView the latest last-applied-configuration annotations by type/name or "
"file.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change output format."
msgstr ""
"\n"
"\t\tView the latest last-applied-configuration annotations by type/name or "
"file.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change output format."

#: pkg/kubectl/cmd/cp.go:37
msgid ""
"\n"
"\t    # !!!Important Note!!!\n"
"\t    # Requires that the 'tar' binary is present in your container\n"
"\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n"
"\n"
"\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in "
"the default namespace\n"
"\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n"
"\n"
"        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific "
"container\n"
"\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n"
"\n"
"\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace "
"<some-namespace>\n"
"\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n"
"\n"
"\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n"
"\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar"
msgstr ""
"\n"
"\t    # !!!Important Note!!!\n"
"\t    # Requires that the 'tar' binary is present in your container\n"
"\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n"
"\n"
"\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in "
"the default namespace\n"
"\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n"
"\n"
"        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific "
"container\n"
"\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n"
"\n"
"\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace "
"<some-namespace>\n"
"\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n"
"\n"
"\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n"
"\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar"

#: pkg/kubectl/cmd/create_secret.go:205
msgid ""
"\n"
"\t  # Create a new TLS secret named tls-secret with the given key pair:\n"
"\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/"
"to/tls.key"
msgstr ""
"\n"
"\t  # Create a new TLS secret named tls-secret with the given key pair:\n"
"\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/"
"to/tls.key"

#: pkg/kubectl/cmd/create_namespace.go:35
msgid ""
"\n"
"\t  # Create a new namespace named my-namespace\n"
"\t  kubectl create namespace my-namespace"
msgstr ""
"\n"
"\t  # Create a new namespace named my-namespace\n"
"\t  kubectl create namespace my-namespace"

#: pkg/kubectl/cmd/create_secret.go:59
msgid ""
"\n"
"\t  # Create a new secret named my-secret with keys for each file in folder "
"bar\n"
"\t  kubectl create secret generic my-secret --from-file=path/to/bar\n"
"\n"
"\t  # Create a new secret named my-secret with specified keys instead of "
"names on disk\n"
"\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/."
"ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n"
"\n"
"\t  # Create a new secret named my-secret with key1=supersecret and "
"key2=topsecret\n"
"\t  kubectl create secret generic my-secret --from-literal=key1=supersecret "
"--from-literal=key2=topsecret"
msgstr ""
"\n"
"\t  # Create a new secret named my-secret with keys for each file in folder "
"bar\n"
"\t  kubectl create secret generic my-secret --from-file=path/to/bar\n"
"\n"
"\t  # Create a new secret named my-secret with specified keys instead of "
"names on disk\n"
"\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/."
"ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n"
"\n"
"\t  # Create a new secret named my-secret with key1=supersecret and "
"key2=topsecret\n"
"\t  kubectl create secret generic my-secret --from-literal=key1=supersecret "
"--from-literal=key2=topsecret"

#: pkg/kubectl/cmd/create_serviceaccount.go:35
msgid ""
"\n"
"\t  # Create a new service account named my-service-account\n"
"\t  kubectl create serviceaccount my-service-account"
msgstr ""
"\n"
"\t  # Create a new service account named my-service-account\n"
"\t  kubectl create serviceaccount my-service-account"

#: pkg/kubectl/cmd/create_service.go:232
msgid ""
"\n"
"\t# Create a new ExternalName service named my-ns \n"
"\tkubectl create service externalname my-ns --external-name bar.com"
msgstr ""
"\n"
"\t# Create a new ExternalName service named my-ns \n"
"\tkubectl create service externalname my-ns --external-name bar.com"

#: pkg/kubectl/cmd/create_service.go:225
msgid ""
"\n"
"\tCreate an ExternalName service with the specified name.\n"
"\n"
"\tExternalName service references to an external DNS address instead of\n"
"\tonly pods, which will allow application authors to reference services\n"
"\tthat exist off platform, on other clusters, or locally."
msgstr ""
"\n"
"\tCreate an ExternalName service with the specified name.\n"
"\n"
"\tExternalName service references to an external DNS address instead of\n"
"\tonly pods, which will allow application authors to reference services\n"
"\tthat exist off platform, on other clusters, or locally."

#: pkg/kubectl/cmd/help.go:30
msgid ""
"\n"
"\tHelp provides help for any command in the application.\n"
"\tSimply type kubectl help [path to command] for full details."
msgstr ""
"\n"
"\tHelp provides help for any command in the application.\n"
"\tSimply type kubectl help [path to command] for full details."

#: pkg/kubectl/cmd/create_service.go:173
msgid ""
"\n"
"    # Create a new LoadBalancer service named my-lbs\n"
"    kubectl create service loadbalancer my-lbs --tcp=5678:8080"
msgstr ""
"\n"
"    # Create a new LoadBalancer service named my-lbs\n"
"    kubectl create service loadbalancer my-lbs --tcp=5678:8080"

#: pkg/kubectl/cmd/create_service.go:53
msgid ""
"\n"
"    # Create a new clusterIP service named my-cs\n"
"    kubectl create service clusterip my-cs --tcp=5678:8080\n"
"\n"
"    # Create a new clusterIP service named my-cs (in headless mode)\n"
"    kubectl create service clusterip my-cs --clusterip=\"None\""
msgstr ""
"\n"
"    # Create a new clusterIP service named my-cs\n"
"    kubectl create service clusterip my-cs --tcp=5678:8080\n"
"\n"
"    # Create a new clusterIP service named my-cs (in headless mode)\n"
"    kubectl create service clusterip my-cs --clusterip=\"None\""

#: pkg/kubectl/cmd/create_deployment.go:36
msgid ""
"\n"
"    # Create a new deployment named my-dep that runs the busybox image.\n"
"    kubectl create deployment my-dep --image=busybox"
msgstr ""
"\n"
"    # Create a new deployment named my-dep that runs the busybox image.\n"
"    kubectl create deployment my-dep --image=busybox"

#: pkg/kubectl/cmd/create_service.go:116
msgid ""
"\n"
"    # Create a new nodeport service named my-ns\n"
"    kubectl create service nodeport my-ns --tcp=5678:8080"
msgstr ""
"\n"
"    # Create a new nodeport service named my-ns\n"
"    kubectl create service nodeport my-ns --tcp=5678:8080"

#: pkg/kubectl/cmd/clusterinfo_dump.go:62
msgid ""
"\n"
"    # Dump current cluster state to stdout\n"
"    kubectl cluster-info dump\n"
"\n"
"    # Dump current cluster state to /path/to/cluster-state\n"
"    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n"
"\n"
"    # Dump all namespaces to stdout\n"
"    kubectl cluster-info dump --all-namespaces\n"
"\n"
"    # Dump a set of namespaces to /path/to/cluster-state\n"
"    kubectl cluster-info dump --namespaces default,kube-system --output-"
"directory=/path/to/cluster-state"
msgstr ""
"\n"
"    # Dump current cluster state to stdout\n"
"    kubectl cluster-info dump\n"
"\n"
"    # Dump current cluster state to /path/to/cluster-state\n"
"    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n"
"\n"
"    # Dump all namespaces to stdout\n"
"    kubectl cluster-info dump --all-namespaces\n"
"\n"
"    # Dump a set of namespaces to /path/to/cluster-state\n"
"    kubectl cluster-info dump --namespaces default,kube-system --output-"
"directory=/path/to/cluster-state"

#: pkg/kubectl/cmd/annotate.go:78
msgid ""
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend'.\n"
"    # If the same annotation is set multiple times, only the last value will "
"be applied\n"
"    kubectl annotate pods foo description='my frontend'\n"
"\n"
"    # Update a pod identified by type and name in \"pod.json\"\n"
"    kubectl annotate -f pod.json description='my frontend'\n"
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend running nginx', overwriting any existing value.\n"
"    kubectl annotate --overwrite pods foo description='my frontend running "
"nginx'\n"
"\n"
"    # Update all pods in the namespace\n"
"    kubectl annotate pods --all description='my frontend running nginx'\n"
"\n"
"    # Update pod 'foo' only if the resource is unchanged from version 1.\n"
"    kubectl annotate pods foo description='my frontend running nginx' --"
"resource-version=1\n"
"\n"
"    # Update pod 'foo' by removing an annotation named 'description' if it "
"exists.\n"
"    # Does not require the --overwrite flag.\n"
"    kubectl annotate pods foo description-"
msgstr ""
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend'.\n"
"    # If the same annotation is set multiple times, only the last value will "
"be applied\n"
"    kubectl annotate pods foo description='my frontend'\n"
"\n"
"    # Update a pod identified by type and name in \"pod.json\"\n"
"    kubectl annotate -f pod.json description='my frontend'\n"
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend running nginx', overwriting any existing value.\n"
"    kubectl annotate --overwrite pods foo description='my frontend running "
"nginx'\n"
"\n"
"    # Update all pods in the namespace\n"
"    kubectl annotate pods --all description='my frontend running nginx'\n"
"\n"
"    # Update pod 'foo' only if the resource is unchanged from version 1.\n"
"    kubectl annotate pods foo description='my frontend running nginx' --"
"resource-version=1\n"
"\n"
"    # Update pod 'foo' by removing an annotation named 'description' if it "
"exists.\n"
"    # Does not require the --overwrite flag.\n"
"    kubectl annotate pods foo description-"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_namespace.go#L44
#: pkg/kubectl/cmd/create_service.go:170
msgid ""
"\n"
"    Create a LoadBalancer service with the specified name."
msgstr ""
"\n"
"    Create a LoadBalancer service with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_serviceaccount.go#L44
#: pkg/kubectl/cmd/create_service.go:50
msgid ""
"\n"
"    Create a clusterIP service with the specified name."
msgstr ""
"\n"
"    Create a clusterIP service with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_deployment.go#L44
#: pkg/kubectl/cmd/create_deployment.go:33
msgid ""
"\n"
"    Create a deployment with the specified name."
msgstr ""
"\n"
"    Create a deployment with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_deployment.go#L44
#: pkg/kubectl/cmd/create_service.go:113
msgid ""
"\n"
"    Create a nodeport service with the specified name."
msgstr ""
"\n"
"    Create a nodeport service with the specified name."

#: pkg/kubectl/cmd/clusterinfo_dump.go:53
msgid ""
"\n"
"    Dumps cluster info out suitable for debugging and diagnosing cluster "
"problems.  By default, dumps everything to\n"
"    stdout. You can optionally specify a directory with --output-directory.  "
"If you specify a directory, kubernetes will\n"
"    build a set of files in that directory.  By default only dumps things in "
"the 'kube-system' namespace, but you can\n"
"    switch to a different namespace with the --namespaces flag, or specify --"
"all-namespaces to dump all namespaces.\n"
"\n"
"    The command also dumps the logs of all of the pods in the cluster, these "
"logs are dumped into different directories\n"
"    based on namespace and pod name."
msgstr ""
"\n"
"    Dumps cluster info out suitable for debugging and diagnosing cluster "
"problems.  By default, dumps everything to\n"
"    stdout. You can optionally specify a directory with --output-directory.  "
"If you specify a directory, kubernetes will\n"
"    build a set of files in that directory.  By default only dumps things in "
"the 'kube-system' namespace, but you can\n"
"    switch to a different namespace with the --namespaces flag, or specify --"
"all-namespaces to dump all namespaces.\n"
"\n"
"    The command also dumps the logs of all of the pods in the cluster, these "
"logs are dumped into different directories\n"
"    based on namespace and pod name."

#: pkg/kubectl/cmd/clusterinfo.go:37
msgid ""
"\n"
"  Display addresses of the master and services with label kubernetes.io/"
"cluster-service=true\n"
"  To further debug and diagnose cluster problems, use 'kubectl cluster-info "
"dump'."
msgstr ""
"\n"
"  Display addresses of the master and services with label kubernetes.io/"
"cluster-service=true\n"
"  To further debug and diagnose cluster problems, use 'kubectl cluster-info "
"dump'."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L61
#: pkg/kubectl/cmd/create_quota.go:62
msgid ""
"A comma-delimited set of quota scopes that must all match each object "
"tracked by the quota."
msgstr ""
"A comma-delimited set of quota scopes that must all match each object "
"tracked by the quota."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L60
#: pkg/kubectl/cmd/create_quota.go:61
msgid ""
"A comma-delimited set of resource=quantity pairs that define a hard limit."
msgstr ""
"A comma-delimited set of resource=quantity pairs that define a hard limit."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_pdb.go#L63
#: pkg/kubectl/cmd/create_pdb.go:64
msgid ""
"A label selector to use for this budget. Only equality-based selector "
"requirements are supported."
msgstr ""
"A label selector to use for this budget. Only equality-based selector "
"requirements are supported."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L106
#: pkg/kubectl/cmd/expose.go:104
msgid ""
"A label selector to use for this service. Only equality-based selector "
"requirements are supported. If empty (the default) infer the selector from "
"the replication controller or replica set.)"
msgstr ""
"A label selector to use for this service. Only equality-based selector "
"requirements are supported. If empty (the default) infer the selector from "
"the replication controller or replica set.)"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L136
#: pkg/kubectl/cmd/run.go:139
msgid "A schedule in the Cron format the job should be run with."
msgstr "A schedule in the Cron format the job should be run with."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L111
#: pkg/kubectl/cmd/expose.go:109
msgid ""
"Additional external IP address (not managed by Kubernetes) to accept for the "
"service. If this IP is routed to a node, the service can be accessed by this "
"IP in addition to its generated service IP."
msgstr ""
"Additional external IP address (not managed by Kubernetes) to accept for the "
"service. If this IP is routed to a node, the service can be accessed by this "
"IP in addition to its generated service IP."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L119
#: pkg/kubectl/cmd/expose.go:110 pkg/kubectl/cmd/run.go:122
msgid ""
"An inline JSON override for the generated object. If this is non-empty, it "
"is used to override the generated object. Requires that the object supply a "
"valid apiVersion field."
msgstr ""
"An inline JSON override for the generated object. If this is non-empty, it "
"is used to override the generated object. Requires that the object supply a "
"valid apiVersion field."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L134
#: pkg/kubectl/cmd/run.go:137
msgid ""
"An inline JSON override for the generated service object. If this is non-"
"empty, it is used to override the generated object. Requires that the object "
"supply a valid apiVersion field.  Only used if --expose is true."
msgstr ""
"An inline JSON override for the generated service object. If this is non-"
"empty, it is used to override the generated object. Requires that the object "
"supply a valid apiVersion field.  Only used if --expose is true."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/apply.go#L98
#: pkg/kubectl/cmd/apply.go:104
msgid "Apply a configuration to a resource by filename or stdin"
msgstr "Apply a configuration to a resource by filename or stdin"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/certificates.go#L71
#: pkg/kubectl/cmd/certificates.go:72
msgid "Approve a certificate signing request"
msgstr "Approve a certificate signing request"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L81
#: pkg/kubectl/cmd/create_service.go:82
msgid ""
"Assign your own ClusterIP or set to 'None' for a 'headless' service (no "
"loadbalancing)."
msgstr ""
"Assign your own ClusterIP or set to 'None' for a 'headless' service (no "
"loadbalancing)."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/attach.go#L64
#: pkg/kubectl/cmd/attach.go:70
msgid "Attach to a running container"
msgstr "Attach to a running container"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/autoscale.go#L55
#: pkg/kubectl/cmd/autoscale.go:56
msgid "Auto-scale a Deployment, ReplicaSet, or ReplicationController"
msgstr "Auto-scale a Deployment, ReplicaSet, or ReplicationController"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L115
#: pkg/kubectl/cmd/expose.go:113
msgid ""
"ClusterIP to be assigned to the service. Leave empty to auto-allocate, or "
"set to 'None' to create a headless service."
msgstr ""
"ClusterIP to be assigned to the service. Leave empty to auto-allocate, or "
"set to 'None' to create a headless service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_clusterrolebinding.go#L55
#: pkg/kubectl/cmd/create_clusterrolebinding.go:56
msgid "ClusterRole this ClusterRoleBinding should reference"
msgstr "ClusterRole this ClusterRoleBinding should reference"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_rolebinding.go#L55
#: pkg/kubectl/cmd/create_rolebinding.go:56
msgid "ClusterRole this RoleBinding should reference"
msgstr "ClusterRole this RoleBinding should reference"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L101
#: pkg/kubectl/cmd/rollingupdate.go:102
msgid ""
"Container name which will have its image upgraded. Only relevant when --"
"image is specified, ignored otherwise. Required when using --image on a "
"multi-container pod"
msgstr ""
"Container name which will have its image upgraded. Only relevant when --"
"image is specified, ignored otherwise. Required when using --image on a "
"multi-container pod"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/convert.go#L67
#: pkg/kubectl/cmd/convert.go:68
msgid "Convert config files between different API versions"
msgstr "Convert config files between different API versions"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/cp.go#L64
#: pkg/kubectl/cmd/cp.go:65
msgid "Copy files and directories to and from containers."
msgstr "Copy files and directories to and from containers."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_clusterrolebinding.go#L43
#: pkg/kubectl/cmd/create_clusterrolebinding.go:44
msgid "Create a ClusterRoleBinding for a particular ClusterRole"
msgstr "Create a ClusterRoleBinding for a particular ClusterRole"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L181
#: pkg/kubectl/cmd/create_service.go:182
msgid "Create a LoadBalancer service."
msgstr "Create a LoadBalancer service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L124
#: pkg/kubectl/cmd/create_service.go:125
msgid "Create a NodePort service."
msgstr "Create a NodePort service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_rolebinding.go#L43
#: pkg/kubectl/cmd/create_rolebinding.go:44
msgid "Create a RoleBinding for a particular Role or ClusterRole"
msgstr "Create a RoleBinding for a particular Role or ClusterRole"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L214
#: pkg/kubectl/cmd/create_secret.go:214
msgid "Create a TLS secret"
msgstr "Create a TLS secret"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L68
#: pkg/kubectl/cmd/create_service.go:69
msgid "Create a clusterIP service."
msgstr "Create a clusterIP service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_configmap.go#L59
#: pkg/kubectl/cmd/create_configmap.go:60
msgid "Create a configmap from a local file, directory or literal value"
msgstr "Create a configmap from a local file, directory or literal value"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_deployment.go#L44
#: pkg/kubectl/cmd/create_deployment.go:46
msgid "Create a deployment with the specified name."
msgstr "Create a deployment with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_namespace.go#L44
#: pkg/kubectl/cmd/create_namespace.go:45
msgid "Create a namespace with the specified name"
msgstr "Create a namespace with the specified name"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_pdb.go#L49
#: pkg/kubectl/cmd/create_pdb.go:50
msgid "Create a pod disruption budget with the specified name."
msgstr "Create a pod disruption budget with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L47
#: pkg/kubectl/cmd/create_quota.go:48
msgid "Create a quota with the specified name."
msgstr "Create a quota with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create.go#L56
#: pkg/kubectl/cmd/create.go:63
msgid "Create a resource by filename or stdin"
msgstr "Create a resource by filename or stdin"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L143
#: pkg/kubectl/cmd/create_secret.go:144
msgid "Create a secret for use with a Docker registry"
msgstr "Create a secret for use with a Docker registry"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L73
#: pkg/kubectl/cmd/create_secret.go:74
msgid "Create a secret from a local file, directory or literal value"
msgstr "Create a secret from a local file, directory or literal value"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L34
#: pkg/kubectl/cmd/create_secret.go:35
msgid "Create a secret using specified subcommand"
msgstr "Create a secret using specified subcommand"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_serviceaccount.go#L44
#: pkg/kubectl/cmd/create_serviceaccount.go:45
msgid "Create a service account with the specified name"
msgstr "Create a service account with the specified name"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L36
#: pkg/kubectl/cmd/create_service.go:37
msgid "Create a service using specified subcommand."
msgstr "Create a service using specified subcommand."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L240
#: pkg/kubectl/cmd/create_service.go:241
msgid "Create an ExternalName service."
msgstr "Create an ExternalName service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/delete.go#L130
#: pkg/kubectl/cmd/delete.go:132
msgid ""
"Delete resources by filenames, stdin, resources and names, or by resources "
"and label selector"
msgstr ""
"Delete resources by filenames, stdin, resources and names, or by resources "
"and label selector"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/delete_cluster.go#L38
#: pkg/kubectl/cmd/config/delete_cluster.go:39
msgid "Delete the specified cluster from the kubeconfig"
msgstr "Delete the specified cluster from the kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/delete_context.go#L38
#: pkg/kubectl/cmd/config/delete_context.go:39
msgid "Delete the specified context from the kubeconfig"
msgstr "Delete the specified context from the kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/certificates.go#L121
#: pkg/kubectl/cmd/certificates.go:122
msgid "Deny a certificate signing request"
msgstr "Deny a certificate signing request"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/stop.go#L58
#: pkg/kubectl/cmd/stop.go:59
msgid "Deprecated: Gracefully shut down a resource by name or filename"
msgstr "Deprecated: Gracefully shut down a resource by name or filename"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/get_contexts.go#L62
#: pkg/kubectl/cmd/config/get_contexts.go:64
msgid "Describe one or many contexts"
msgstr "Describe one or many contexts"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/top_node.go#L77
#: pkg/kubectl/cmd/top_node.go:78
msgid "Display Resource (CPU/Memory/Storage) usage of nodes"
msgstr "Display Resource (CPU/Memory/Storage) usage of nodes"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/top_pod.go#L79
#: pkg/kubectl/cmd/top_pod.go:80
msgid "Display Resource (CPU/Memory/Storage) usage of pods"
msgstr "Display Resource (CPU/Memory/Storage) usage of pods"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/top.go#L43
#: pkg/kubectl/cmd/top.go:44
msgid "Display Resource (CPU/Memory/Storage) usage."
msgstr "Display Resource (CPU/Memory/Storage) usage."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/clusterinfo.go#L49
#: pkg/kubectl/cmd/clusterinfo.go:51
msgid "Display cluster info"
msgstr "Display cluster info"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/get_clusters.go#L40
#: pkg/kubectl/cmd/config/get_clusters.go:41
msgid "Display clusters defined in the kubeconfig"
msgstr "Display clusters defined in the kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/view.go#L64
#: pkg/kubectl/cmd/config/view.go:67
msgid "Display merged kubeconfig settings or a specified kubeconfig file"
msgstr "Display merged kubeconfig settings or a specified kubeconfig file"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/get.go#L107
#: pkg/kubectl/cmd/get.go:111
msgid "Display one or many resources"
msgstr "Display one or many resources"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/current_context.go#L48
#: pkg/kubectl/cmd/config/current_context.go:49
msgid "Displays the current-context"
msgstr "Displays the current-context"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/explain.go#L50
#: pkg/kubectl/cmd/explain.go:51
msgid "Documentation of resources"
msgstr "Documentation of resources"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L176
#: pkg/kubectl/cmd/drain.go:178
msgid "Drain node in preparation for maintenance"
msgstr "Drain node in preparation for maintenance"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/clusterinfo_dump.go#L37
#: pkg/kubectl/cmd/clusterinfo_dump.go:39
msgid "Dump lots of relevant info for debugging and diagnosis"
msgstr "Dump lots of relevant info for debugging and diagnosis"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/edit.go#L100
#: pkg/kubectl/cmd/edit.go:110
msgid "Edit a resource on the server"
msgstr "Edit a resource on the server"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L159
#: pkg/kubectl/cmd/create_secret.go:160
msgid "Email for Docker registry"
msgstr "Email for Docker registry"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/exec.go#L68
#: pkg/kubectl/cmd/exec.go:69
msgid "Execute a command in a container"
msgstr "Execute a command in a container"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L102
#: pkg/kubectl/cmd/rollingupdate.go:103
msgid ""
"Explicit policy for when to pull container images. Required when --image is "
"same as existing image, ignored otherwise."
msgstr ""
"Explicit policy for when to pull container images. Required when --image is "
"same as existing image, ignored otherwise."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/portforward.go#L75
#: pkg/kubectl/cmd/portforward.go:76
msgid "Forward one or more local ports to a pod"
msgstr "Forward one or more local ports to a pod"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/help.go#L36
#: pkg/kubectl/cmd/help.go:37
msgid "Help about any command"
msgstr "Help about any command"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L105
#: pkg/kubectl/cmd/expose.go:103
msgid ""
"IP to assign to the Load Balancer. If empty, an ephemeral IP will be created "
"and used (cloud-provider specific)."
msgstr ""
"IP to assign to the Load Balancer. If empty, an ephemeral IP will be created "
"and used (cloud-provider specific)."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L114
#: pkg/kubectl/cmd/expose.go:112
msgid ""
"If non-empty, set the session affinity for the service to this; legal "
"values: 'None', 'ClientIP'"
msgstr ""
"If non-empty, set the session affinity for the service to this; legal "
"values: 'None', 'ClientIP'"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/annotate.go#L135
#: pkg/kubectl/cmd/annotate.go:136
msgid ""
"If non-empty, the annotation update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."
msgstr ""
"If non-empty, the annotation update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/label.go#L132
#: pkg/kubectl/cmd/label.go:134
msgid ""
"If non-empty, the labels update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."
msgstr ""
"If non-empty, the labels update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L98
#: pkg/kubectl/cmd/rollingupdate.go:99
msgid ""
"Image to use for upgrading the replication controller. Must be distinct from "
"the existing image (either new image or new image tag).  Can not be used "
"with --filename/-f"
msgstr ""
"Image to use for upgrading the replication controller. Must be distinct from "
"the existing image (either new image or new image tag).  Can not be used "
"with --filename/-f"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout.go#L46
#: pkg/kubectl/cmd/rollout/rollout.go:47
msgid "Manage a deployment rollout"
msgstr "Manage a deployment rollout"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L127
#: pkg/kubectl/cmd/drain.go:128
msgid "Mark node as schedulable"
msgstr "Mark node as schedulable"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L102
#: pkg/kubectl/cmd/drain.go:103
msgid "Mark node as unschedulable"
msgstr "Mark node as unschedulable"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_pause.go#L73
#: pkg/kubectl/cmd/rollout/rollout_pause.go:74
msgid "Mark the provided resource as paused"
msgstr "Mark the provided resource as paused"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/certificates.go#L35
#: pkg/kubectl/cmd/certificates.go:36
msgid "Modify certificate resources."
msgstr "Modify certificate resources."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/config.go#L39
#: pkg/kubectl/cmd/config/config.go:40
msgid "Modify kubeconfig files"
msgstr "Modify kubeconfig files"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L110
#: pkg/kubectl/cmd/expose.go:108
msgid ""
"Name or number for the port on the container that the service should direct "
"traffic to. Optional."
msgstr ""
"Name or number for the port on the container that the service should direct "
"traffic to. Optional."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/logs.go#L108
#: pkg/kubectl/cmd/logs.go:113
msgid ""
"Only return logs after a specific date (RFC3339). Defaults to all logs. Only "
"one of since-time / since may be used."
msgstr ""
"Only return logs after a specific date (RFC3339). Defaults to all logs. Only "
"one of since-time / since may be used."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/completion.go#L97
#: pkg/kubectl/cmd/completion.go:104
msgid "Output shell completion code for the specified shell (bash or zsh)"
msgstr "Output shell completion code for the specified shell (bash or zsh)"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/edit.go#L115
#: pkg/kubectl/cmd/convert.go:85
msgid ""
"Output the formatted object with the given group version (for ex: "
"'extensions/v1beta1').)"
msgstr ""
"Output the formatted object with the given group version (for ex: "
"'extensions/v1beta1').)"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L157
#: pkg/kubectl/cmd/create_secret.go:158
msgid "Password for Docker registry authentication"
msgstr "Password for Docker registry authentication"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L226
#: pkg/kubectl/cmd/create_secret.go:226
msgid "Path to PEM encoded public key certificate."
msgstr "Path to PEM encoded public key certificate."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L227
#: pkg/kubectl/cmd/create_secret.go:227
msgid "Path to private key associated with given certificate."
msgstr "Path to private key associated with given certificate."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L84
#: pkg/kubectl/cmd/rollingupdate.go:85
msgid "Perform a rolling update of the given ReplicationController"
msgstr "Perform a rolling update of the given ReplicationController"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/scale.go#L82
#: pkg/kubectl/cmd/scale.go:83
msgid ""
"Precondition for resource version. Requires that the current resource "
"version match this value in order to scale."
msgstr ""
"Precondition for resource version. Requires that the current resource "
"version match this value in order to scale."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/version.go#L39
#: pkg/kubectl/cmd/version.go:40
msgid "Print the client and server version information"
msgstr "Print the client and server version information"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/options.go#L37
#: pkg/kubectl/cmd/options.go:38
msgid "Print the list of flags inherited by all commands"
msgstr "Print the list of flags inherited by all commands"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/logs.go#L86
#: pkg/kubectl/cmd/logs.go:93
msgid "Print the logs for a container in a pod"
msgstr "Print the logs for a container in a pod"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/replace.go#L70
#: pkg/kubectl/cmd/replace.go:71
msgid "Replace a resource by filename or stdin"
msgstr "Replace a resource by filename or stdin"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_resume.go#L71
#: pkg/kubectl/cmd/rollout/rollout_resume.go:72
msgid "Resume a paused resource"
msgstr "Resume a paused resource"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_rolebinding.go#L56
#: pkg/kubectl/cmd/create_rolebinding.go:57
msgid "Role this RoleBinding should reference"
msgstr "Role this RoleBinding should reference"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L94
#: pkg/kubectl/cmd/run.go:97
msgid "Run a particular image on the cluster"
msgstr "Run a particular image on the cluster"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/proxy.go#L68
#: pkg/kubectl/cmd/proxy.go:69
msgid "Run a proxy to the Kubernetes API server"
msgstr "Run a proxy to the Kubernetes API server"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L161
#: pkg/kubectl/cmd/create_secret.go:161
msgid "Server location for Docker registry"
msgstr "Server location for Docker registry"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/scale.go#L71
#: pkg/kubectl/cmd/scale.go:71
msgid ""
"Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job"
msgstr ""
"Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/set/set.go#L37
#: pkg/kubectl/cmd/set/set.go:38
msgid "Set specific features on objects"
msgstr "Set specific features on objects"

#: pkg/kubectl/cmd/apply_set_last_applied.go:83
msgid ""
"Set the last-applied-configuration annotation on a live object to match the "
"contents of a file."
msgstr ""
"Set the last-applied-configuration annotation on a live object to match the "
"contents of a file."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/set/set_selector.go#L81
#: pkg/kubectl/cmd/set/set_selector.go:82
msgid "Set the selector on a resource"
msgstr "Set the selector on a resource"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_cluster.go#L67
#: pkg/kubectl/cmd/config/create_cluster.go:68
msgid "Sets a cluster entry in kubeconfig"
msgstr "Sets a cluster entry in kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_context.go#L57
#: pkg/kubectl/cmd/config/create_context.go:58
msgid "Sets a context entry in kubeconfig"
msgstr "Sets a context entry in kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_authinfo.go#L103
#: pkg/kubectl/cmd/config/create_authinfo.go:104
msgid "Sets a user entry in kubeconfig"
msgstr "Sets a user entry in kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/set.go#L59
#: pkg/kubectl/cmd/config/set.go:60
msgid "Sets an individual value in a kubeconfig file"
msgstr "Sets an individual value in a kubeconfig file"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/use_context.go#L48
#: pkg/kubectl/cmd/config/use_context.go:49
msgid "Sets the current-context in a kubeconfig file"
msgstr "Sets the current-context in a kubeconfig file"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/describe.go#L80
#: pkg/kubectl/cmd/describe.go:86
msgid "Show details of a specific resource or group of resources"
msgstr "Show details of a specific resource or group of resources"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_status.go#L57
#: pkg/kubectl/cmd/rollout/rollout_status.go:58
msgid "Show the status of the rollout"
msgstr "Show the status of the rollout"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L108
#: pkg/kubectl/cmd/expose.go:106
msgid "Synonym for --target-port"
msgstr "Synonym for --target-port"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L87
#: pkg/kubectl/cmd/expose.go:88
msgid ""
"Take a replication controller, service, deployment or pod and expose it as a "
"new Kubernetes Service"
msgstr ""
"Take a replication controller, service, deployment or pod and expose it as a "
"new Kubernetes Service"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L114
#: pkg/kubectl/cmd/run.go:117
msgid "The image for the container to run."
msgstr "The image for the container to run."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L116
#: pkg/kubectl/cmd/run.go:119
msgid ""
"The image pull policy for the container. If left empty, this value will not "
"be specified by the client and defaulted by the server"
msgstr ""
"The image pull policy for the container. If left empty, this value will not "
"be specified by the client and defaulted by the server"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L100
#: pkg/kubectl/cmd/rollingupdate.go:101
msgid ""
"The key to use to differentiate between two different controllers, default "
"'deployment'.  Only relevant when --image is specified, ignored otherwise"
msgstr ""
"The key to use to differentiate between two different controllers, default "
"'deployment'.  Only relevant when --image is specified, ignored otherwise"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_pdb.go#L62
#: pkg/kubectl/cmd/create_pdb.go:63
msgid ""
"The minimum number or percentage of available pods this budget requires."
msgstr ""
"The minimum number or percentage of available pods this budget requires."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L113
#: pkg/kubectl/cmd/expose.go:111
msgid "The name for the newly created object."
msgstr "The name for the newly created object."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/autoscale.go#L71
#: pkg/kubectl/cmd/autoscale.go:72
msgid ""
"The name for the newly created object. If not specified, the name of the "
"input resource will be used."
msgstr ""
"The name for the newly created object. If not specified, the name of the "
"input resource will be used."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L113
#: pkg/kubectl/cmd/run.go:116
msgid ""
"The name of the API generator to use, see http://kubernetes.io/docs/user-"
"guide/kubectl-conventions/#generators for a list."
msgstr ""
"The name of the API generator to use, see http://kubernetes.io/docs/user-"
"guide/kubectl-conventions/#generators for a list."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/autoscale.go#L66
#: pkg/kubectl/cmd/autoscale.go:67
msgid ""
"The name of the API generator to use. Currently there is only 1 generator."
msgstr ""
"The name of the API generator to use. Currently there is only 1 generator."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L98
#: pkg/kubectl/cmd/expose.go:99
msgid ""
"The name of the API generator to use. There are 2 generators: 'service/v1' "
"and 'service/v2'. The only difference between them is that service port in "
"v1 is named 'default', while it is left unnamed in v2. Default is 'service/"
"v2'."
msgstr ""
"The name of the API generator to use. There are 2 generators: 'service/v1' "
"and 'service/v2'. The only difference between them is that service port in "
"v1 is named 'default', while it is left unnamed in v2. Default is 'service/"
"v2'."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L133
#: pkg/kubectl/cmd/run.go:136
msgid ""
"The name of the generator to use for creating a service.  Only used if --"
"expose is true"
msgstr ""
"The name of the generator to use for creating a service.  Only used if --"
"expose is true"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L99
#: pkg/kubectl/cmd/expose.go:100
msgid "The network protocol for the service to be created. Default is 'TCP'."
msgstr "The network protocol for the service to be created. Default is 'TCP'."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L100
#: pkg/kubectl/cmd/expose.go:101
msgid ""
"The port that the service should serve on. Copied from the resource being "
"exposed, if unspecified"
msgstr ""
"The port that the service should serve on. Copied from the resource being "
"exposed, if unspecified"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L121
#: pkg/kubectl/cmd/run.go:124
msgid ""
"The port that this container exposes.  If --expose is true, this is also the "
"port used by the service that is created."
msgstr ""
"The port that this container exposes.  If --expose is true, this is also the "
"port used by the service that is created."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L131
#: pkg/kubectl/cmd/run.go:134
msgid ""
"The resource requirement limits for this container.  For example, 'cpu=200m,"
"memory=512Mi'.  Note that server side components may assign limits depending "
"on the server configuration, such as limit ranges."
msgstr ""
"The resource requirement limits for this container.  For example, 'cpu=200m,"
"memory=512Mi'.  Note that server side components may assign limits depending "
"on the server configuration, such as limit ranges."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L130
#: pkg/kubectl/cmd/run.go:133
msgid ""
"The resource requirement requests for this container.  For example, "
"'cpu=100m,memory=256Mi'.  Note that server side components may assign "
"requests depending on the server configuration, such as limit ranges."
msgstr ""
"The resource requirement requests for this container.  For example, "
"'cpu=100m,memory=256Mi'.  Note that server side components may assign "
"requests depending on the server configuration, such as limit ranges."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L128
#: pkg/kubectl/cmd/run.go:131
msgid ""
"The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  "
"If set to 'Always' a deployment is created, if set to 'OnFailure' a job is "
"created, if set to 'Never', a regular pod is created. For the latter two --"
"replicas must be 1.  Default 'Always', for CronJobs ` + "`" + `Never` + "`" + `."
msgstr ""
"The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  "
"If set to 'Always' a deployment is created, if set to 'OnFailure' a job is "
"created, if set to 'Never', a regular pod is created. For the latter two --"
"replicas must be 1.  Default 'Always', for CronJobs ` + "`" + `Never` + "`" + `."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L87
#: pkg/kubectl/cmd/create_secret.go:88
msgid "The type of secret to create"
msgstr "The type of secret to create"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L101
#: pkg/kubectl/cmd/expose.go:102
msgid ""
"Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is "
"'ClusterIP'."
msgstr ""
"Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is "
"'ClusterIP'."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_undo.go#L71
#: pkg/kubectl/cmd/rollout/rollout_undo.go:72
msgid "Undo a previous rollout"
msgstr "Undo a previous rollout"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/unset.go#L47
#: pkg/kubectl/cmd/config/unset.go:48
msgid "Unsets an individual value in a kubeconfig file"
msgstr "Unsets an individual value in a kubeconfig file"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/patch.go#L91
#: pkg/kubectl/cmd/patch.go:96
msgid "Update field(s) of a resource using strategic merge patch"
msgstr "Update field(s) of a resource using strategic merge patch"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/set/set_image.go#L94
#: pkg/kubectl/cmd/set/set_image.go:95
msgid "Update image of a pod template"
msgstr "Update image of a pod template"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/set/set_resources.go#L101
#: pkg/kubectl/cmd/set/set_resources.go:102
msgid "Update resource requests/limits on objects with pod templates"
msgstr "Update resource requests/limits on objects with pod templates"

#: pkg/kubectl/cmd/annotate.go:116
msgid "Update the annotations on a resource"
msgstr "Update the annotations on a resource"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/label.go#L109
#: pkg/kubectl/cmd/label.go:114
msgid "Update the labels on a resource"
msgstr "Update the labels on a resource"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/taint.go#L88
#: pkg/kubectl/cmd/taint.go:87
msgid "Update the taints on one or more nodes"
msgstr "Update the taints on one or more nodes"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L155
#: pkg/kubectl/cmd/create_secret.go:156
msgid "Username for Docker registry authentication"
msgstr "Username for Docker registry authentication"

#: pkg/kubectl/cmd/apply_view_last_applied.go:64
msgid "View latest last-applied-configuration annotations of a resource/object"
msgstr ""
"View latest last-applied-configuration annotations of a resource/object"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_history.go#L51
#: pkg/kubectl/cmd/rollout/rollout_history.go:52
msgid "View rollout history"
msgstr "View rollout history"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/clusterinfo_dump.go#L45
#: pkg/kubectl/cmd/clusterinfo_dump.go:46
msgid ""
"Where to output the files.  If empty or '-' uses stdout, otherwise creates a "
"directory hierarchy in that directory"
msgstr ""
"Where to output the files.  If empty or '-' uses stdout, otherwise creates a "
"directory hierarchy in that directory"

#: pkg/kubectl/cmd/run_test.go:85
msgid "dummy restart flag)"
msgstr "dummy restart flag)"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L253
#: pkg/kubectl/cmd/create_service.go:254
msgid "external name of service"
msgstr "external name of service"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/cmd.go#L217
#: pkg/kubectl/cmd/cmd.go:227
msgid "kubectl controls the Kubernetes cluster manager"
msgstr "kubectl controls the Kubernetes cluster manager"

#~ msgid ""
#~ "watch is only supported on individual resources and resource collections "
#~ "- %d resources were found"
#~ msgid_plural ""
#~ "watch is only supported on individual resources and resource collections "
#~ "- %d resources were found"
#~ msgstr[0] ""
#~ "watch is only supported on individual resources and resource collections "
#~ "- %d resource was found"
#~ msgstr[1] ""
#~ "watch is only supported on individual resources and resource collections "
#~ "- %d resources were found"
`)

func translationsKubectlDefaultLc_messagesK8sPoBytes() ([]byte, error) {
	return _translationsKubectlDefaultLc_messagesK8sPo, nil
}

func translationsKubectlDefaultLc_messagesK8sPo() (*asset, error) {
	bytes, err := translationsKubectlDefaultLc_messagesK8sPoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/default/LC_MESSAGES/k8s.po", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlEn_usLc_messagesK8sMo = []byte("\xde\x12\x04\x95\x00\x00\x00\x00\xeb\x00\x00\x00\x1c\x00\x00\x00t\a\x00\x009\x01\x00\x00\xcc\x0e\x00\x00\x00\x00\x00\x00\xb0\x13\x00\x00\xdc\x00\x00\x00\xb1\x13\x00\x00\xb6\x00\x00\x00\x8e\x14\x00\x00\v\x02\x00\x00E\x15\x00\x00\x1f\x01\x00\x00Q\x17\x00\x00z\x00\x00\x00q\x18\x00\x00_\x02\x00\x00\xec\x18\x00\x00|\x01\x00\x00L\x1b\x00\x00\x8f\x01\x00\x00\xc9\x1c\x00\x00k\x01\x00\x00Y\x1e\x00\x00k\x01\x00\x00\xc5\x1f\x00\x00>\x01\x00\x001!\x00\x00\x03\x02\x00\x00p\"\x00\x00o\x01\x00\x00t$\x00\x00H\x05\x00\x00\xe4%\x00\x00g\x02\x00\x00-+\x00\x00\x1b\x02\x00\x00\x95-\x00\x00q\x01\x00\x00\xb1/\x00\x00\xa8\x01\x00\x00#1\x00\x00\xd4\x01\x00\x00\xcc2\x00\x00\x02\x02\x00\x00\xa14\x00\x00\xb4\x00\x00\x00\xa46\x00\x00\xb7\x02\x00\x00Y7\x00\x00\x92\x03\x00\x00\x11:\x00\x00\xbf\x01\x00\x00\xa4=\x00\x00=\x00\x00\x00d?\x00\x00;\x00\x00\x00\xa2?\x00\x00\xcd\x02\x00\x00\xde?\x00\x00<\x00\x00\x00\xacB\x00\x00P\x00\x00\x00\xe9B\x00\x00S\x00\x00\x00:C\x00\x00<\x00\x00\x00\x8eC\x00\x00\xac\x01\x00\x00\xcbC\x00\x00\x13\x03\x00\x00xE\x00\x00\xea\x01\x00\x00\x8cH\x00\x00\xfa\x01\x00\x00wJ\x00\x00\xda\x01\x00\x00rL\x00\x00c\x01\x00\x00MN\x00\x00T\x01\x00\x00\xb1O\x00\x00\xba\x06\x00\x00\x06Q\x00\x00\xf9\x01\x00\x00\xc1W\x00\x00\xe0\x02\x00\x00\xbbY\x00\x00\x02\x03\x00\x00\x9c\\\x00\x00\xfb\x00\x00\x00\x9f_\x00\x00\xa5\x01\x00\x00\x9b`\x00\x00\xb4\x01\x00\x00Ab\x00\x00\x18\x00\x00\x00\xf6c\x00\x00<\x00\x00\x00\x0fd\x00\x00=\x00\x00\x00Ld\x00\x00\xc6\x00\x00\x00\x8ad\x00\x00g\x02\x00\x00Qe\x00\x00.\x00\x00\x00\xb9g\x00\x001\x03\x00\x00\xe8g\x00\x00g\x00\x00\x00\x1ak\x00\x00Q\x00\x00\x00\x82k\x00\x00R\x00\x00\x00\xd4k\x00\x00\"\x00\x00\x00'l\x00\x00X\x02\x00\x00Jl\x00\x004\x00\x00\x00\xa3n\x00\x00}\x00\x00\x00\xd8n\x00\x00k\x01\x00\x00Vo\x00\x00\x81\a\x00\x00\xc2p\x00\x00f\x01\x00\x00Dx\x00\x00\x85\x00\x00\x00\xaby\x00\x00\xea\x00\x00\x001z\x00\x00\xd9\x00\x00\x00\x1c{\x00\x00\n\x05\x00\x00\xf6{\x00\x00\x10\x05\x00\x00\x01\x81\x00\x00\x1c\x00\x00\x00\x12\x86\x00\x00\x1e\x00\x00\x00/\x86\x00\x00\x99\x02\x00\x00N\x86\x00\x00\xbc\x01\x00\x00\xe8\x88\x00\x00\x9c\x01\x00\x00\xa5\x8a\x00\x00q\x01\x00\x00B\x8c\x00\x00\x05\x01\x00\x00\xb4\x8d\x00\x00\xdf\x01\x00\x00\xba\x8e\x00\x00\x1c\x01\x00\x00\x9a\x90\x00\x00\xc1\x01\x00\x00\xb7\x91\x00\x00\x1b\x02\x00\x00y\x93\x00\x00\xc0\x00\x00\x00\x95\x95\x00\x00\xd5\x02\x00\x00V\x96\x00\x00\x9d\x00\x00\x00,\x99\x00\x00X\x00\x00\x00\u0299\x00\x00%\x02\x00\x00#\x9a\x00\x00o\x00\x00\x00I\x9c\x00\x00u\x00\x00\x00\xb9\x9c\x00\x00\x01\x01\x00\x00/\x9d\x00\x00v\x00\x00\x001\x9e\x00\x00t\x00\x00\x00\xa8\x9e\x00\x00\xef\x00\x00\x00\x1d\x9f\x00\x00}\x00\x00\x00\r\xa0\x00\x00j\x00\x00\x00\x8b\xa0\x00\x00\xc4\x01\x00\x00\xf6\xa0\x00\x00\xf7\x03\x00\x00\xbb\xa2\x00\x00;\x00\x00\x00\xb3\xa6\x00\x008\x00\x00\x00\xef\xa6\x00\x001\x00\x00\x00(\xa7\x00\x007\x00\x00\x00Z\xa7\x00\x00u\x02\x00\x00\x92\xa7\x00\x00\xb0\x00\x00\x00\b\xaa\x00\x00[\x00\x00\x00\xb9\xaa\x00\x00J\x00\x00\x00\x15\xab\x00\x00a\x00\x00\x00`\xab\x00\x00\xbd\x00\x00\x00\u00ab\x00\x009\x00\x00\x00\x80\xac\x00\x00\xc5\x00\x00\x00\xba\xac\x00\x00\xae\x00\x00\x00\x80\xad\x00\x00\xd6\x00\x00\x00/\xae\x00\x008\x00\x00\x00\x06\xaf\x00\x00%\x00\x00\x00?\xaf\x00\x00W\x00\x00\x00e\xaf\x00\x00\x1d\x00\x00\x00\xbd\xaf\x00\x00=\x00\x00\x00\u06ef\x00\x00u\x00\x00\x00\x19\xb0\x00\x004\x00\x00\x00\x8f\xb0\x00\x00-\x00\x00\x00\u0130\x00\x00\xa3\x00\x00\x00\xf2\xb0\x00\x003\x00\x00\x00\x96\xb1\x00\x002\x00\x00\x00\u02b1\x00\x008\x00\x00\x00\xfd\xb1\x00\x00\x1e\x00\x00\x006\xb2\x00\x00\x1a\x00\x00\x00U\xb2\x00\x009\x00\x00\x00p\xb2\x00\x00\x13\x00\x00\x00\xaa\xb2\x00\x00\x1b\x00\x00\x00\xbe\xb2\x00\x00@\x00\x00\x00\u06b2\x00\x00,\x00\x00\x00\x1b\xb3\x00\x00*\x00\x00\x00H\xb3\x00\x007\x00\x00\x00s\xb3\x00\x00'\x00\x00\x00\xab\xb3\x00\x00&\x00\x00\x00\u04f3\x00\x00.\x00\x00\x00\xfa\xb3\x00\x00=\x00\x00\x00)\xb4\x00\x00*\x00\x00\x00g\xb4\x00\x000\x00\x00\x00\x92\xb4\x00\x00,\x00\x00\x00\u00f4\x00\x00\x1f\x00\x00\x00\xf0\xb4\x00\x00]\x00\x00\x00\x10\xb5\x00\x000\x00\x00\x00n\xb5\x00\x000\x00\x00\x00\x9f\xb5\x00\x00\"\x00\x00\x00\u0435\x00\x00?\x00\x00\x00\xf3\xb5\x00\x00\x1d\x00\x00\x003\xb6\x00\x004\x00\x00\x00Q\xb6\x00\x003\x00\x00\x00\x86\xb6\x00\x00,\x00\x00\x00\xba\xb6\x00\x00\x14\x00\x00\x00\xe7\xb6\x00\x00*\x00\x00\x00\xfc\xb6\x00\x00A\x00\x00\x00'\xb7\x00\x00\x1d\x00\x00\x00i\xb7\x00\x00\x1c\x00\x00\x00\x87\xb7\x00\x00\x1a\x00\x00\x00\xa4\xb7\x00\x00)\x00\x00\x00\xbf\xb7\x00\x006\x00\x00\x00\xe9\xb7\x00\x00\x1d\x00\x00\x00 \xb8\x00\x00\x19\x00\x00\x00>\xb8\x00\x00 \x00\x00\x00X\xb8\x00\x00v\x00\x00\x00y\xb8\x00\x00(\x00\x00\x00\xf0\xb8\x00\x00\x16\x00\x00\x00\x19\xb9\x00\x00p\x00\x00\x000\xb9\x00\x00`\x00\x00\x00\xa1\xb9\x00\x00\x9b\x00\x00\x00\x02\xba\x00\x00\x97\x00\x00\x00\x9e\xba\x00\x00\xa8\x00\x00\x006\xbb\x00\x00\x1b\x00\x00\x00\u07fb\x00\x00\x18\x00\x00\x00\xfb\xbb\x00\x00\x1a\x00\x00\x00\x14\xbc\x00\x00$\x00\x00\x00/\xbc\x00\x00\x1d\x00\x00\x00T\xbc\x00\x00\x17\x00\x00\x00r\xbc\x00\x00a\x00\x00\x00\x8a\xbc\x00\x00s\x00\x00\x00\xec\xbc\x00\x00B\x00\x00\x00`\xbd\x00\x00Y\x00\x00\x00\xa3\xbd\x00\x00+\x00\x00\x00\xfd\xbd\x00\x00+\x00\x00\x00)\xbe\x00\x006\x00\x00\x00U\xbe\x00\x00;\x00\x00\x00\x8c\xbe\x00\x00q\x00\x00\x00\u023e\x00\x00/\x00\x00\x00:\xbf\x00\x001\x00\x00\x00j\xbf\x00\x00'\x00\x00\x00\x9c\xbf\x00\x00'\x00\x00\x00\u013f\x00\x00\x18\x00\x00\x00\xec\xbf\x00\x00&\x00\x00\x00\x05\xc0\x00\x00%\x00\x00\x00,\xc0\x00\x00(\x00\x00\x00R\xc0\x00\x00#\x00\x00\x00{\xc0\x00\x00K\x00\x00\x00\x9f\xc0\x00\x00 \x00\x00\x00\xeb\xc0\x00\x00_\x00\x00\x00\f\xc1\x00\x00\x1e\x00\x00\x00l\xc1\x00\x00\"\x00\x00\x00\x8b\xc1\x00\x00\"\x00\x00\x00\xae\xc1\x00\x00\x1f\x00\x00\x00\xd1\xc1\x00\x00-\x00\x00\x00\xf1\xc1\x00\x00-\x00\x00\x00\x1f\xc2\x00\x009\x00\x00\x00M\xc2\x00\x00\x1e\x00\x00\x00\x87\xc2\x00\x00\x19\x00\x00\x00\xa6\xc2\x00\x00c\x00\x00\x00\xc0\xc2\x00\x00#\x00\x00\x00$\xc3\x00\x00\x82\x00\x00\x00H\xc3\x00\x00\x94\x00\x00\x00\xcb\xc3\x00\x00H\x00\x00\x00`\xc4\x00\x00&\x00\x00\x00\xa9\xc4\x00\x00e\x00\x00\x00\xd0\xc4\x00\x00z\x00\x00\x006\xc5\x00\x00J\x00\x00\x00\xb1\xc5\x00\x00\xe5\x00\x00\x00\xfc\xc5\x00\x00W\x00\x00\x00\xe2\xc6\x00\x00E\x00\x00\x00:\xc7\x00\x00a\x00\x00\x00\x80\xc7\x00\x00v\x00\x00\x00\xe2\xc7\x00\x00\xcb\x00\x00\x00Y\xc8\x00\x00\xcf\x00\x00\x00%\xc9\x00\x00\x1e\x01\x00\x00\xf5\xc9\x00\x00\x1c\x00\x00\x00\x14\xcb\x00\x00T\x00\x00\x001\xcb\x00\x00\x17\x00\x00\x00\x86\xcb\x00\x00/\x00\x00\x00\x9e\xcb\x00\x009\x00\x00\x00\xce\xcb\x00\x00\x1e\x00\x00\x00\b\xcc\x00\x00=\x00\x00\x00'\xcc\x00\x00$\x00\x00\x00e\xcc\x00\x00\x1f\x00\x00\x00\x8a\xcc\x00\x00&\x00\x00\x00\xaa\xcc\x00\x00+\x00\x00\x00\xd1\xcc\x00\x00G\x00\x00\x00\xfd\xcc\x00\x00\x14\x00\x00\x00E\xcd\x00\x00r\x00\x00\x00Z\xcd\x00\x00\x13\x00\x00\x00\xcd\xcd\x00\x00\x18\x00\x00\x00\xe1\xcd\x00\x00/\x00\x00\x00\xfa\xcd\x00\x00\xb1\x01\x00\x00*\xce\x00\x00\xdc\x00\x00\x00\xdc\xcf\x00\x00\xb6\x00\x00\x00\xb9\xd0\x00\x00\v\x02\x00\x00p\xd1\x00\x00\x1f\x01\x00\x00|\xd3\x00\x00z\x00\x00\x00\x9c\xd4\x00\x00_\x02\x00\x00\x17\xd5\x00\x00|\x01\x00\x00w\xd7\x00\x00\x8f\x01\x00\x00\xf4\xd8\x00\x00k\x01\x00\x00\x84\xda\x00\x00k\x01\x00\x00\xf0\xdb\x00\x00>\x01\x00\x00\\\xdd\x00\x00\x03\x02\x00\x00\x9b\xde\x00\x00o\x01\x00\x00\x9f\xe0\x00\x00H\x05\x00\x00\x0f\xe2\x00\x00g\x02\x00\x00X\xe7\x00\x00\x1b\x02\x00\x00\xc0\xe9\x00\x00q\x01\x00\x00\xdc\xeb\x00\x00\xa8\x01\x00\x00N\xed\x00\x00\xd4\x01\x00\x00\xf7\xee\x00\x00\x02\x02\x00\x00\xcc\xf0\x00\x00\xb4\x00\x00\x00\xcf\xf2\x00\x00\xb7\x02\x00\x00\x84\xf3\x00\x00\x92\x03\x00\x00<\xf6\x00\x00\xbf\x01\x00\x00\xcf\xf9\x00\x00=\x00\x00\x00\x8f\xfb\x00\x00;\x00\x00\x00\xcd\xfb\x00\x00\xcd\x02\x00\x00\t\xfc\x00\x00<\x00\x00\x00\xd7\xfe\x00\x00P\x00\x00\x00\x14\xff\x00\x00S\x00\x00\x00e\xff\x00\x00<\x00\x00\x00\xb9\xff\x00\x00\xac\x01\x00\x00\xf6\xff\x00\x00\x13\x03\x00\x00\xa3\x01\x01\x00\xea\x01\x00\x00\xb7\x04\x01\x00\xfa\x01\x00\x00\xa2\x06\x01\x00\xda\x01\x00\x00\x9d\b\x01\x00c\x01\x00\x00x\n\x01\x00T\x01\x00\x00\xdc\v\x01\x00\xba\x06\x00\x001\r\x01\x00\xf9\x01\x00\x00\xec\x13\x01\x00\xe0\x02\x00\x00\xe6\x15\x01\x00\x02\x03\x00\x00\xc7\x18\x01\x00\xfb\x00\x00\x00\xca\x1b\x01\x00\xa5\x01\x00\x00\xc6\x1c\x01\x00\xb4\x01\x00\x00l\x1e\x01\x00\x18\x00\x00\x00! \x01\x00<\x00\x00\x00: \x01\x00=\x00\x00\x00w \x01\x00\xc6\x00\x00\x00\xb5 \x01\x00g\x02\x00\x00|!\x01\x00.\x00\x00\x00\xe4#\x01\x001\x03\x00\x00\x13$\x01\x00g\x00\x00\x00E'\x01\x00Q\x00\x00\x00\xad'\x01\x00R\x00\x00\x00\xff'\x01\x00\"\x00\x00\x00R(\x01\x00X\x02\x00\x00u(\x01\x004\x00\x00\x00\xce*\x01\x00}\x00\x00\x00\x03+\x01\x00k\x01\x00\x00\x81+\x01\x00\x81\a\x00\x00\xed,\x01\x00f\x01\x00\x00o4\x01\x00\x85\x00\x00\x00\xd65\x01\x00\xea\x00\x00\x00\\6\x01\x00\xd9\x00\x00\x00G7\x01\x00\n\x05\x00\x00!8\x01\x00\x10\x05\x00\x00,=\x01\x00\x1c\x00\x00\x00=B\x01\x00\x1e\x00\x00\x00ZB\x01\x00\x99\x02\x00\x00yB\x01\x00\xbc\x01\x00\x00\x13E\x01\x00\x9c\x01\x00\x00\xd0F\x01\x00q\x01\x00\x00mH\x01\x00\x05\x01\x00\x00\xdfI\x01\x00\xdf\x01\x00\x00\xe5J\x01\x00\x1c\x01\x00\x00\xc5L\x01\x00\xc1\x01\x00\x00\xe2M\x01\x00\x1b\x02\x00\x00\xa4O\x01\x00\xc0\x00\x00\x00\xc0Q\x01\x00\xd5\x02\x00\x00\x81R\x01\x00\x9d\x00\x00\x00WU\x01\x00X\x00\x00\x00\xf5U\x01\x00%\x02\x00\x00NV\x01\x00o\x00\x00\x00tX\x01\x00u\x00\x00\x00\xe4X\x01\x00\x01\x01\x00\x00ZY\x01\x00v\x00\x00\x00\\Z\x01\x00t\x00\x00\x00\xd3Z\x01\x00\xef\x00\x00\x00H[\x01\x00}\x00\x00\x008\\\x01\x00j\x00\x00\x00\xb6\\\x01\x00\xc4\x01\x00\x00!]\x01\x00\xf7\x03\x00\x00\xe6^\x01\x00;\x00\x00\x00\xdeb\x01\x008\x00\x00\x00\x1ac\x01\x001\x00\x00\x00Sc\x01\x007\x00\x00\x00\x85c\x01\x00u\x02\x00\x00\xbdc\x01\x00\xb0\x00\x00\x003f\x01\x00[\x00\x00\x00\xe4f\x01\x00J\x00\x00\x00@g\x01\x00a\x00\x00\x00\x8bg\x01\x00\xbd\x00\x00\x00\xedg\x01\x009\x00\x00\x00\xabh\x01\x00\xc5\x00\x00\x00\xe5h\x01\x00\xae\x00\x00\x00\xabi\x01\x00\xd6\x00\x00\x00Zj\x01\x008\x00\x00\x001k\x01\x00%\x00\x00\x00jk\x01\x00W\x00\x00\x00\x90k\x01\x00\x1d\x00\x00\x00\xe8k\x01\x00=\x00\x00\x00\x06l\x01\x00u\x00\x00\x00Dl\x01\x004\x00\x00\x00\xbal\x01\x00-\x00\x00\x00\xefl\x01\x00\xa3\x00\x00\x00\x1dm\x01\x003\x00\x00\x00\xc1m\x01\x002\x00\x00\x00\xf5m\x01\x008\x00\x00\x00(n\x01\x00\x1e\x00\x00\x00an\x01\x00\x1a\x00\x00\x00\x80n\x01\x009\x00\x00\x00\x9bn\x01\x00\x13\x00\x00\x00\xd5n\x01\x00\x1b\x00\x00\x00\xe9n\x01\x00@\x00\x00\x00\x05o\x01\x00,\x00\x00\x00Fo\x01\x00*\x00\x00\x00so\x01\x007\x00\x00\x00\x9eo\x01\x00'\x00\x00\x00\xd6o\x01\x00&\x00\x00\x00\xfeo\x01\x00.\x00\x00\x00%p\x01\x00=\x00\x00\x00Tp\x01\x00*\x00\x00\x00\x92p\x01\x000\x00\x00\x00\xbdp\x01\x00,\x00\x00\x00\xeep\x01\x00\x1f\x00\x00\x00\x1bq\x01\x00]\x00\x00\x00;q\x01\x000\x00\x00\x00\x99q\x01\x000\x00\x00\x00\xcaq\x01\x00\"\x00\x00\x00\xfbq\x01\x00?\x00\x00\x00\x1er\x01\x00\x1d\x00\x00\x00^r\x01\x004\x00\x00\x00|r\x01\x003\x00\x00\x00\xb1r\x01\x00,\x00\x00\x00\xe5r\x01\x00\x14\x00\x00\x00\x12s\x01\x00*\x00\x00\x00's\x01\x00A\x00\x00\x00Rs\x01\x00\x1d\x00\x00\x00\x94s\x01\x00\x1c\x00\x00\x00\xb2s\x01\x00\x1a\x00\x00\x00\xcfs\x01\x00)\x00\x00\x00\xeas\x01\x006\x00\x00\x00\x14t\x01\x00\x1d\x00\x00\x00Kt\x01\x00\x19\x00\x00\x00it\x01\x00 \x00\x00\x00\x83t\x01\x00v\x00\x00\x00\xa4t\x01\x00(\x00\x00\x00\x1bu\x01\x00\x16\x00\x00\x00Du\x01\x00p\x00\x00\x00[u\x01\x00`\x00\x00\x00\xccu\x01\x00\x9b\x00\x00\x00-v\x01\x00\x97\x00\x00\x00\xc9v\x01\x00\xa8\x00\x00\x00aw\x01\x00\x1b\x00\x00\x00\nx\x01\x00\x18\x00\x00\x00&x\x01\x00\x1a\x00\x00\x00?x\x01\x00$\x00\x00\x00Zx\x01\x00\x1d\x00\x00\x00\u007fx\x01\x00\x17\x00\x00\x00\x9dx\x01\x00a\x00\x00\x00\xb5x\x01\x00s\x00\x00\x00\x17y\x01\x00B\x00\x00\x00\x8by\x01\x00Y\x00\x00\x00\xcey\x01\x00+\x00\x00\x00(z\x01\x00+\x00\x00\x00Tz\x01\x006\x00\x00\x00\x80z\x01\x00;\x00\x00\x00\xb7z\x01\x00q\x00\x00\x00\xf3z\x01\x00/\x00\x00\x00e{\x01\x001\x00\x00\x00\x95{\x01\x00'\x00\x00\x00\xc7{\x01\x00'\x00\x00\x00\xef{\x01\x00\x18\x00\x00\x00\x17|\x01\x00&\x00\x00\x000|\x01\x00%\x00\x00\x00W|\x01\x00(\x00\x00\x00}|\x01\x00#\x00\x00\x00\xa6|\x01\x00K\x00\x00\x00\xca|\x01\x00 \x00\x00\x00\x16}\x01\x00_\x00\x00\x007}\x01\x00\x1e\x00\x00\x00\x97}\x01\x00\"\x00\x00\x00\xb6}\x01\x00\"\x00\x00\x00\xd9}\x01\x00\x1f\x00\x00\x00\xfc}\x01\x00-\x00\x00\x00\x1c~\x01\x00-\x00\x00\x00J~\x01\x009\x00\x00\x00x~\x01\x00\x1e\x00\x00\x00\xb2~\x01\x00\x19\x00\x00\x00\xd1~\x01\x00c\x00\x00\x00\xeb~\x01\x00#\x00\x00\x00O\u007f\x01\x00\x82\x00\x00\x00s\u007f\x01\x00\x94\x00\x00\x00\xf6\u007f\x01\x00H\x00\x00\x00\x8b\x80\x01\x00&\x00\x00\x00\u0500\x01\x00e\x00\x00\x00\xfb\x80\x01\x00z\x00\x00\x00a\x81\x01\x00J\x00\x00\x00\u0701\x01\x00\xe5\x00\x00\x00'\x82\x01\x00W\x00\x00\x00\r\x83\x01\x00E\x00\x00\x00e\x83\x01\x00a\x00\x00\x00\xab\x83\x01\x00v\x00\x00\x00\r\x84\x01\x00\xcb\x00\x00\x00\x84\x84\x01\x00\xcf\x00\x00\x00P\x85\x01\x00\x1e\x01\x00\x00 \x86\x01\x00\x1c\x00\x00\x00?\x87\x01\x00T\x00\x00\x00\\\x87\x01\x00\x17\x00\x00\x00\xb1\x87\x01\x00/\x00\x00\x00\u0247\x01\x009\x00\x00\x00\xf9\x87\x01\x00\x1e\x00\x00\x003\x88\x01\x00=\x00\x00\x00R\x88\x01\x00$\x00\x00\x00\x90\x88\x01\x00\x1f\x00\x00\x00\xb5\x88\x01\x00&\x00\x00\x00\u0548\x01\x00+\x00\x00\x00\xfc\x88\x01\x00G\x00\x00\x00(\x89\x01\x00\x14\x00\x00\x00p\x89\x01\x00r\x00\x00\x00\x85\x89\x01\x00\x13\x00\x00\x00\xf8\x89\x01\x00\x18\x00\x00\x00\f\x8a\x01\x00/\x00\x00\x00%\x8a\x01\x00\x01\x00\x00\x00\x00\x00\x00\x00^\x00\x00\x00\\\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00F\x00\x00\x00\xc4\x00\x00\x00\x0f\x00\x00\x00\xc3\x00\x00\x00\x00\x00\x00\x00-\x00\x00\x00\x00\x00\x00\x00\x86\x00\x00\x00\xeb\x00\x00\x00c\x00\x00\x00\x00\x00\x00\x001\x00\x00\x00o\x00\x00\x00}\x00\x00\x00\x00\x00\x00\x00J\x00\x00\x00\x00\x00\x00\x00\xd8\x00\x00\x00\x98\x00\x00\x00U\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xdb\x00\x00\x00\x17\x00\x00\x00u\x00\x00\x00\x11\x00\x00\x00\x00\x00\x00\x00\x8a\x00\x00\x00\xe8\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xc9\x00\x00\x00\xb7\x00\x00\x00\xd7\x00\x00\x00*\x00\x00\x00\x99\x00\x00\x00\x00\x00\x00\x00\x1f\x00\x00\x00\x84\x00\x00\x00\x9c\x00\x00\x00\xe6\x00\x00\x00\x9d\x00\x00\x00\xc5\x00\x00\x00\xd9\x00\x00\x00\xb9\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x19\x00\x00\x00\xcd\x00\x00\x00\xcb\x00\x00\x00y\x00\x00\x00\x97\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x18\x00\x00\x00\x00\x00\x00\x00C\x00\x00\x00\x93\x00\x00\x00\xad\x00\x00\x00\xe1\x00\x00\x00\xa6\x00\x00\x00\xd0\x00\x00\x00r\x00\x00\x00+\x00\x00\x006\x00\x00\x00\xce\x00\x00\x00\xa5\x00\x00\x00\x80\x00\x00\x00\x00\x00\x00\x00h\x00\x00\x00\xa0\x00\x00\x00\x00\x00\x00\x00\xd1\x00\x00\x00\xde\x00\x00\x00;\x00\x00\x00\x00\x00\x00\x00\xe9\x00\x00\x00\xe7\x00\x00\x00G\x00\x00\x00\xe4\x00\x00\x00z\x00\x00\x00/\x00\x00\x00V\x00\x00\x00`\x00\x00\x00\xe3\x00\x00\x00!\x00\x00\x00~\x00\x00\x00\x00\x00\x00\x00\xe2\x00\x00\x00\xd3\x00\x00\x00\x88\x00\x00\x00l\x00\x00\x00s\x00\x00\x00g\x00\x00\x00\x05\x00\x00\x00\xc2\x00\x00\x00#\x00\x00\x00\x91\x00\x00\x00\x00\x00\x00\x00\xb1\x00\x00\x00\x00\x00\x00\x00\x90\x00\x00\x00\x13\x00\x00\x00S\x00\x00\x00\x00\x00\x00\x00$\x00\x00\x00\xc1\x00\x00\x00\xb5\x00\x00\x00X\x00\x00\x00m\x00\x00\x00\t\x00\x00\x00x\x00\x00\x00\xb8\x00\x00\x00\xbd\x00\x00\x00k\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00<\x00\x00\x00E\x00\x00\x00\xbf\x00\x00\x00\xbc\x00\x00\x00\x00\x00\x00\x00:\x00\x00\x00\x82\x00\x00\x00\x81\x00\x00\x00&\x00\x00\x00\xe0\x00\x00\x00\x00\x00\x00\x00[\x00\x00\x00\x00\x00\x00\x00e\x00\x00\x00\x04\x00\x00\x00>\x00\x00\x00I\x00\x00\x00\x94\x00\x00\x00\x8f\x00\x00\x00\x92\x00\x00\x00?\x00\x00\x00Y\x00\x00\x00\xda\x00\x00\x00\x15\x00\x00\x00\x00\x00\x00\x00'\x00\x00\x004\x00\x00\x00\xcc\x00\x00\x00\f\x00\x00\x005\x00\x00\x00(\x00\x00\x00\x00\x00\x00\x00\xbb\x00\x00\x00\x00\x00\x00\x00\xa9\x00\x00\x00\x9e\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00O\x00\x00\x00 \x00\x00\x00)\x00\x00\x00\xcf\x00\x00\x00\x00\x00\x00\x00\x1b\x00\x00\x00Z\x00\x00\x00\"\x00\x00\x00\x00\x00\x00\x00v\x00\x00\x00]\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00a\x00\x00\x00j\x00\x00\x008\x00\x00\x00\xa3\x00\x00\x00q\x00\x00\x00t\x00\x00\x00_\x00\x00\x00\x10\x00\x00\x00\x9f\x00\x00\x00\x00\x00\x00\x00\v\x00\x00\x00@\x00\x00\x00\xd2\x00\x00\x00,\x00\x00\x00\x00\x00\x00\x00\x85\x00\x00\x00\x00\x00\x00\x00\xe5\x00\x00\x00\x00\x00\x00\x00\xc8\x00\x00\x00\x95\x00\x00\x00\x06\x00\x00\x00\xa8\x00\x00\x00\xae\x00\x00\x00\xa1\x00\x00\x00\x00\x00\x00\x00\xba\x00\x00\x00\x0e\x00\x00\x00{\x00\x00\x00\xa7\x00\x00\x00\x00\x00\x00\x00\xb6\x00\x00\x00i\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\xd5\x00\x00\x00L\x00\x00\x00\x00\x00\x00\x00\xea\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00w\x00\x00\x00\x12\x00\x00\x00=\x00\x00\x00\xaf\x00\x00\x00\a\x00\x00\x00\xdf\x00\x00\x00\xc0\x00\x00\x00N\x00\x00\x00%\x00\x00\x009\x00\x00\x00\x00\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00.\x00\x00\x00\x00\x00\x00\x00\u007f\x00\x00\x00\xbe\x00\x00\x00\x8d\x00\x00\x00\x00\x00\x00\x00P\x00\x00\x00\xb3\x00\x00\x00\r\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00R\x00\x00\x00D\x00\x00\x00B\x00\x00\x00n\x00\x00\x00\x00\x00\x00\x00\xd6\x00\x00\x00\x83\x00\x00\x00\n\x00\x00\x00W\x00\x00\x00\x14\x00\x00\x00Q\x00\x00\x00\xd4\x00\x00\x00d\x00\x00\x00\xac\x00\x00\x00\x16\x00\x00\x00\x96\x00\x00\x00K\x00\x00\x002\x00\x00\x00\x1a\x00\x00\x00\xb4\x00\x00\x00f\x00\x00\x00\xa2\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00A\x00\x00\x00\xc6\x00\x00\x00\x8c\x00\x00\x00\x9a\x00\x00\x00\b\x00\x00\x00\xab\x00\x00\x00M\x00\x00\x007\x00\x00\x000\x00\x00\x00\x00\x00\x00\x00\x1d\x00\x00\x00\x00\x00\x00\x00\xdc\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x9b\x00\x00\x00\x89\x00\x00\x00\x00\x00\x00\x00\xdd\x00\x00\x00\x8e\x00\x00\x00\xca\x00\x00\x00H\x00\x00\x00\x00\x00\x00\x00\xb2\x00\x00\x00\x00\x00\x00\x00\x1c\x00\x00\x00\xb0\x00\x00\x00\x00\x00\x00\x00|\x00\x00\x003\x00\x00\x00T\x00\x00\x00\x87\x00\x00\x00b\x00\x00\x00\x00\x00\x00\x00\x1e\x00\x00\x00\xaa\x00\x00\x00\xa4\x00\x00\x00\x00\x00\x00\x00p\x00\x00\x00\xc7\x00\x00\x00\x8b\x00\x00\x00\x00\n\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the cluster-admin ClusterRole\n\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin ClusterRole\n\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a new configmap named my-config based on folder bar\n\t\t  kubectl create configmap my-config --from-file=path/to/bar\n\n\t\t  # Create a new configmap named my-config with specified keys instead of file basenames on disk\n\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1.txt --from-file=key2=/path/to/bar/file2.txt\n\n\t\t  # Create a new configmap named my-config with key1=config1 and key2=config2\n\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-literal=key2=config2\x00\n\t\t  # If you don't already have a .dockercfg file, you can create a dockercfg secret directly by using:\n\t\t  kubectl create secret docker-registry my-secret --docker-server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL\x00\n\t\t  # Show metrics for all nodes\n\t\t  kubectl top node\n\n\t\t  # Show metrics for a given node\n\t\t  kubectl top node NODE_NAME\x00\n\t\t# Apply the configuration in pod.json to a pod.\n\t\tkubectl apply -f ./pod.json\n\n\t\t# Apply the JSON passed into stdin to a pod.\n\t\tcat pod.json | kubectl apply -f -\n\n\t\t# Note: --prune is still in Alpha\n\t\t# Apply the configuration in manifest.yaml that matches label app=nginx and delete all the other resources that are not in the file and match label app=nginx.\n\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n\n\t\t# Apply the configuration in manifest.yaml and delete all the other configmaps that are not in the file.\n\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/ConfigMap\x00\n\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and 10, target CPU utilization specified so a default autoscaling policy will be used:\n\t\tkubectl autoscale deployment foo --min=2 --max=10\n\n\t\t# Auto scale a replication controller \"foo\", with the number of pods between 1 and 5, target CPU utilization at 80%:\n\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80\x00\n\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n\t\tkubectl convert -f pod.yaml\n\n\t\t# Convert the live state of the resource specified by 'pod.yaml' to the latest version\n\t\t# and print to stdout in json format.\n\t\tkubectl convert -f pod.yaml --local -o json\n\n\t\t# Convert all files under current directory to latest version and create them all.\n\t\tkubectl convert -f . | kubectl create -f -\x00\n\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods\n\n\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --resource=pods\n\n\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a new resourcequota named my-quota\n\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,replicationcontrollers=2,resourcequotas=1,secrets=5,persistentvolumeclaims=10\n\n\t\t# Create a new resourcequota named best-effort\n\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort\x00\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=rails label\n\t\t# and require at least one of them being available at any point in time.\n\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-available=1\n\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=nginx label\n\t\t# and require at least half of the pods selected to be available at any point in time.\n\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%\x00\n\t\t# Create a pod using the data in pod.json.\n\t\tkubectl create -f ./pod.json\n\n\t\t# Create a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl create -f -\n\n\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format then create the resource using the edited data.\n\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json\x00\n\t\t# Create a service for a replicated nginx, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rc nginx --port=80 --target-port=8000\n\n\t\t# Create a service for a replication controller identified by type and name specified in \"nginx-controller.yaml\", which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n\n\t\t# Create a service for a pod valid-pod, which serves on port 444 with the name \"frontend\"\n\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n\n\t\t# Create a second service based on the above service, exposing the container port 8443 as port 443 with the name \"nginx-https\"\n\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-https\n\n\t\t# Create a service for a replicated streaming application on port 4100 balancing UDP traffic and named 'video-stream'.\n\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-stream\n\n\t\t# Create a service for a replicated nginx using replica set, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rs nginx --port=80 --target-port=8000\n\n\t\t# Create a service for an nginx deployment, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose deployment nginx --port=80 --target-port=8000\x00\n\t\t# Delete a pod using the type and name specified in pod.json.\n\t\tkubectl delete -f ./pod.json\n\n\t\t# Delete a pod based on the type and name in the JSON passed into stdin.\n\t\tcat pod.json | kubectl delete -f -\n\n\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n\t\tkubectl delete pod,service baz foo\n\n\t\t# Delete pods and services with label name=myLabel.\n\t\tkubectl delete pods,services -l name=myLabel\n\n\t\t# Delete a pod with minimal delay\n\t\tkubectl delete pod foo --now\n\n\t\t# Force delete a pod on a dead node\n\t\tkubectl delete pod foo --grace-period=0 --force\n\n\t\t# Delete all pods\n\t\tkubectl delete pods --all\x00\n\t\t# Describe a node\n\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n\n\t\t# Describe a pod\n\t\tkubectl describe pods/nginx\n\n\t\t# Describe a pod identified by type and name in \"pod.json\"\n\t\tkubectl describe -f pod.json\n\n\t\t# Describe all pods\n\t\tkubectl describe pods\n\n\t\t# Describe pods by label name=myLabel\n\t\tkubectl describe po -l name=myLabel\n\n\t\t# Describe all pods managed by the 'frontend' replication controller (rc-created pods\n\t\t# get the name of the rc as a prefix in the pod the name).\n\t\tkubectl describe pods frontend\x00\n\t\t# Drain node \"foo\", even if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n\t\t$ kubectl drain foo --force\n\n\t\t# As above, but abort if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a grace period of 15 minutes.\n\t\t$ kubectl drain foo --grace-period=900\x00\n\t\t# Edit the service named 'docker-registry':\n\t\tkubectl edit svc/docker-registry\n\n\t\t# Use an alternative editor\n\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n\n\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n\t\tkubectl edit job.v1.batch/myjob -o json\n\n\t\t# Edit the deployment 'mydeployment' in YAML and save the modified config in its annotation:\n\t\tkubectl edit deployment/mydeployment -o yaml --save-config\x00\n\t\t# Get output from running 'date' from pod 123456-7890, using the first container by default\n\t\tkubectl exec 123456-7890 date\n\n\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n\t\tkubectl exec 123456-7890 -c ruby-container date\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il\x00\n\t\t# Get output from running pod 123456-7890, using the first container by default\n\t\tkubectl attach 123456-7890\n\n\t\t# Get output from ruby-container from pod 123456-7890\n\t\tkubectl attach 123456-7890 -c ruby-container\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n\n\t\t# Get output from the first pod of a ReplicaSet named nginx\n\t\tkubectl attach rs/nginx\n\t\t\x00\n\t\t# Get the documentation of the resource and its fields\n\t\tkubectl explain pods\n\n\t\t# Get the documentation of a specific field of a resource\n\t\tkubectl explain pods.spec.containers\x00\n\t\t# Install bash completion on a Mac using homebrew\n\t\tbrew install bash-completion\n\t\tprintf \"\n# Bash completion support\nsource $(brew --prefix)/etc/bash_completion\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for bash into the current shell\n\t\tsource <(kubectl completion bash)\n\n\t\t# Write bash completion code to a file and source if from .bash_profile\n\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n\t\tprintf \"\n# Kubectl shell completion\nsource '$HOME/.kube/completion.bash.inc'\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for zsh[1] into the current shell\n\t\tsource <(kubectl completion zsh)\x00\n\t\t# List all pods in ps output format.\n\t\tkubectl get pods\n\n\t\t# List all pods in ps output format with more information (such as node name).\n\t\tkubectl get pods -o wide\n\n\t\t# List a single replication controller with specified NAME in ps output format.\n\t\tkubectl get replicationcontroller web\n\n\t\t# List a single pod in JSON output format.\n\t\tkubectl get -o json pod web-pod-13je7\n\n\t\t# List a pod identified by type and name specified in \"pod.yaml\" in JSON output format.\n\t\tkubectl get -f pod.yaml -o json\n\n\t\t# Return only the phase value of the specified pod.\n\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n\n\t\t# List all replication controllers and services together in ps output format.\n\t\tkubectl get rc,services\n\n\t\t# List one or more resources by their type and names.\n\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n\n\t\t# List all resources with different types.\n\t\tkubectl get all\x00\n\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports 5000 and 6000 in the pod\n\t\tkubectl port-forward mypod 5000 6000\n\n\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 8888:5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod :5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 0:5000\x00\n\t\t# Mark node \"foo\" as schedulable.\n\t\t$ kubectl uncordon foo\x00\n\t\t# Mark node \"foo\" as unschedulable.\n\t\tkubectl cordon foo\x00\n\t\t# Partially update a node using strategic merge patch\n\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Partially update a node identified by the type and name specified in \"node.json\" using strategic merge patch\n\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Update a container's image; spec.containers[*].name is required because it's a merge key\n\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n\n\t\t# Update a container's image using a json patch with positional arrays\n\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", \"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'\x00\n\t\t# Print flags inherited by all commands\n\t\tkubectl options\x00\n\t\t# Print the address of the master and cluster services\n\t\tkubectl cluster-info\x00\n\t\t# Print the client and server versions for the current context\n\t\tkubectl version\x00\n\t\t# Print the supported API versions\n\t\tkubectl api-versions\x00\n\t\t# Replace a pod using the data in pod.json.\n\t\tkubectl replace -f ./pod.json\n\n\t\t# Replace a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl replace -f -\n\n\t\t# Update a single-container pod's image version (tag) to v4\n\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/\x01:v4/' | kubectl replace -f -\n\n\t\t# Force replace, delete and then re-create the resource\n\t\tkubectl replace --force -f ./pod.json\x00\n\t\t# Return snapshot logs from pod nginx with only one container\n\t\tkubectl logs nginx\n\n\t\t# Return snapshot logs for the pods defined by label app=nginx\n\t\tkubectl logs -lapp=nginx\n\n\t\t# Return snapshot of previous terminated ruby container logs from pod web-1\n\t\tkubectl logs -p -c ruby web-1\n\n\t\t# Begin streaming the logs of the ruby container in pod web-1\n\t\tkubectl logs -f -c ruby web-1\n\n\t\t# Display only the most recent 20 lines of output in pod nginx\n\t\tkubectl logs --tail=20 nginx\n\n\t\t# Show all logs from pod nginx written in the last hour\n\t\tkubectl logs --since=1h nginx\n\n\t\t# Return snapshot logs from first container of a job named hello\n\t\tkubectl logs job/hello\n\n\t\t# Return snapshot logs from container nginx-1 of a deployment named nginx\n\t\tkubectl logs deployment/nginx -c nginx-1\x00\n\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static content from ./local/www/\n\t\tkubectl proxy --port=8011 --www=./local/www/\n\n\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n\t\t# The chosen port for the server will be output to stdout.\n\t\tkubectl proxy --port=0\n\n\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-api\n\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/pods/\n\t\tkubectl proxy --api-prefix=/k8s-api\x00\n\t\t# Scale a replicaset named 'foo' to 3.\n\t\tkubectl scale --replicas=3 rs/foo\n\n\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" to 3.\n\t\tkubectl scale --replicas=3 -f foo.yaml\n\n\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n\n\t\t# Scale multiple replication controllers.\n\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n\n\t\t# Scale job named 'cron' to 3.\n\t\tkubectl scale --replicas=3 job/cron\x00\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file.\n\t\tkubectl apply set-last-applied -f deploy.yaml\n\n\t\t# Execute set-last-applied against each configuration file in a directory.\n\t\tkubectl apply set-last-applied -f path/\n\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file, will create the annotation if it does not already exist.\n\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n\t\t\x00\n\t\t# Show metrics for all pods in the default namespace\n\t\tkubectl top pod\n\n\t\t# Show metrics for all pods in the given namespace\n\t\tkubectl top pod --namespace=NAMESPACE\n\n\t\t# Show metrics for a given pod and its containers\n\t\tkubectl top pod POD_NAME --containers\n\n\t\t# Show metrics for the pods defined by label name=myLabel\n\t\tkubectl top pod -l name=myLabel\x00\n\t\t# Shut down foo.\n\t\tkubectl stop replicationcontroller foo\n\n\t\t# Stop pods and services with label name=myLabel.\n\t\tkubectl stop pods,services -l name=myLabel\n\n\t\t# Shut down the service defined in service.json\n\t\tkubectl stop -f service.json\n\n\t\t# Shut down all resources in the path/to/resources directory\n\t\tkubectl stop -f path/to/resources\x00\n\t\t# Start a single instance of nginx.\n\t\tkubectl run nginx --image=nginx\n\n\t\t# Start a single instance of hazelcast and let the container expose port 5701 .\n\t\tkubectl run hazelcast --image=hazelcast --port=5701\n\n\t\t# Start a single instance of hazelcast and set environment variables \"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --env=\"POD_NAMESPACE=default\"\n\n\t\t# Start a replicated instance of nginx.\n\t\tkubectl run nginx --image=nginx --replicas=5\n\n\t\t# Dry run. Print the corresponding API objects without creating them.\n\t\tkubectl run nginx --image=nginx --dry-run\n\n\t\t# Start a single instance of nginx, but overload the spec of the deployment with a partial set of values parsed from JSON.\n\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", \"spec\": { ... } }'\n\n\t\t# Start a pod of busybox and keep it in the foreground, don't restart it if it exits.\n\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n\n\t\t# Start the nginx container using the default command, but use custom arguments (arg1 .. argN) for that command.\n\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n\n\t\t# Start the nginx container using a different command and custom arguments.\n\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n\n\t\t# Start the perl container to compute \u03c0 to 2000 places and print it out.\n\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\n\n\t\t# Start the cron job to compute \u03c0 to 2000 places and print it out every 5 minutes.\n\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\x00\n\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-user' and effect 'NoSchedule'.\n\t\t# If a taint with that key and effect already exists, its value is replaced as specified.\n\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n\n\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect 'NoSchedule' if one exists.\n\t\tkubectl taint nodes foo dedicated:NoSchedule-\n\n\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n\t\tkubectl taint nodes foo dedicated-\x00\n\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n\t\tkubectl label pods foo unhealthy=true\n\n\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', overwriting any existing value.\n\t\tkubectl label --overwrite pods foo status=unhealthy\n\n\t\t# Update all pods in the namespace\n\t\tkubectl label pods --all status=unhealthy\n\n\t\t# Update a pod identified by the type and name in \"pod.json\"\n\t\tkubectl label -f pod.json status=unhealthy\n\n\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n\t\tkubectl label pods foo status=unhealthy --resource-version=1\n\n\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n\t\t# Does not require the --overwrite flag.\n\t\tkubectl label pods foo bar-\x00\n\t\t# Update pods of frontend-v1 using new replication controller data in frontend-v2.json.\n\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n\n\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n\n\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the image, and switching the\n\t\t# name of the replication controller.\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n\n\t\t# Update the pods of frontend by just changing the image, and keeping the old name.\n\t\tkubectl rolling-update frontend --image=image:v2\n\n\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to frontend-v2).\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback\x00\n\t\t# View the last-applied-configuration annotations by type/name in YAML.\n\t\tkubectl apply view-last-applied deployment/nginx\n\n\t\t# View the last-applied-configuration annotations by file in JSON\n\t\tkubectl apply view-last-applied -f deploy.yaml -o json\x00\n\t\tApply a configuration to a resource by filename or stdin.\n\t\tThis resource will be created if it doesn't exist yet.\n\t\tTo use 'apply', always create the resource initially with either 'apply' or 'create --save-config'.\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not use unless you are aware of what the current state is. See https://issues.k8s.io/34274.\x00\n\t\tConvert config files between different API versions. Both YAML\n\t\tand JSON formats are accepted.\n\n\t\tThe command takes filename, directory, or URL as input, and convert it into format\n\t\tof version specified by --output-version flag. If target version is not specified or\n\t\tnot supported, convert to latest version.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change to output destination.\x00\n\t\tCreate a ClusterRole.\x00\n\t\tCreate a ClusterRoleBinding for a particular ClusterRole.\x00\n\t\tCreate a RoleBinding for a particular Role or ClusterRole.\x00\n\t\tCreate a TLS secret from the given public/private key pair.\n\n\t\tThe public/private key pair must exist before hand. The public key certificate must be .PEM encoded and match the given private key.\x00\n\t\tCreate a configmap based on a file, directory, or specified literal value.\n\n\t\tA single configmap may package one or more key/value pairs.\n\n\t\tWhen creating a configmap based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a configmap based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the configmap.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a namespace with the specified name.\x00\n\t\tCreate a new secret for use with Docker registries.\n\n\t\tDockercfg secrets are used to authenticate against Docker registries.\n\n\t\tWhen using the Docker command line to push images, you can authenticate to a given registry by running\n\n\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n\n    That produces a ~/.dockercfg file that is used by subsequent 'docker push' and 'docker pull' commands to\n\t\tauthenticate to the registry. The email address is optional.\n\n\t\tWhen creating applications, you may have a Docker registry that requires authentication.  In order for the\n\t\tnodes to pull images on your behalf, they have to have the credentials.  You can provide this information\n\t\tby creating a dockercfg secret and attaching it to your service account.\x00\n\t\tCreate a pod disruption budget with the specified name, selector, and desired minimum available pods\x00\n\t\tCreate a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted.\x00\n\t\tCreate a resourcequota with the specified name, hard limits and optional scopes\x00\n\t\tCreate a role with single rule.\x00\n\t\tCreate a secret based on a file, directory, or specified literal value.\n\n\t\tA single secret may package one or more key/value pairs.\n\n\t\tWhen creating a secret based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a secret based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the secret.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a service account with the specified name.\x00\n\t\tCreate and run a particular image, possibly replicated.\n\n\t\tCreates a deployment or job to manage the created container(s).\x00\n\t\tCreates an autoscaler that automatically chooses and sets the number of pods that run in a kubernetes cluster.\n\n\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and creates an autoscaler that uses the given resource as a reference.\n\t\tAn autoscaler can automatically increase or decrease number of pods deployed within the system as needed.\x00\n\t\tDelete resources by filenames, stdin, resources and names, or by resources and label selector.\n\n\t\tJSON and YAML formats are accepted. Only one type of the arguments may be specified: filenames,\n\t\tresources and names, or resources and label selector.\n\n\t\tSome resources, such as pods, support graceful deletion. These resources define a default period\n\t\tbefore they are forcibly terminated (the grace period) but you may override that value with\n\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. Because these resources often\n\t\trepresent entities in the cluster, deletion may not be acknowledged immediately. If the node\n\t\thosting a pod is down or cannot reach the API server, termination may take significantly longer\n\t\tthan the grace period. To force delete a resource,\tyou must pass a grace\tperiod of 0 and specify\n\t\tthe --force flag.\n\n\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the pod's processes have been\n\t\tterminated, which can leave those processes running until the node detects the deletion and\n\t\tcompletes graceful deletion. If your processes use shared storage or talk to a remote API and\n\t\tdepend on the name of the pod to identify themselves, force deleting those pods may result in\n\t\tmultiple processes running on different machines using the same identification which may lead\n\t\tto data corruption or inconsistency. Only force delete pods when you are sure the pod is\n\t\tterminated, or if your application can tolerate multiple copies of the same pod running at once.\n\t\tAlso, if you force delete pods the scheduler may place new pods on those nodes before the node\n\t\thas released those resources and causing those pods to be evicted immediately.\n\n\t\tNote that the delete command does NOT do resource version checks, so if someone\n\t\tsubmits an update to a resource right when you submit a delete, their update\n\t\twill be lost along with the rest of the resource.\x00\n\t\tDeprecated: Gracefully shut down a resource by name or filename.\n\n\t\tThe stop command is deprecated, all its functionalities are covered by delete command.\n\t\tSee 'kubectl delete --help' for more details.\n\n\t\tAttempts to shut down and delete a resource that supports graceful termination.\n\t\tIf the resource is scalable it will be scaled to 0 before deletion.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n\n\t\tThe top-node command allows you to see the resource consumption of nodes.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n\n\t\tThe 'top pod' command allows you to see the resource consumption of pods.\n\n\t\tDue to the metrics pipeline delay, they may be unavailable for a few minutes\n\t\tsince pod creation.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage.\n\n\t\tThe top command allows you to see the resource consumption for nodes or pods.\n\n\t\tThis command requires Heapster to be correctly configured and working on the server. \x00\n\t\tDrain node in preparation for maintenance.\n\n\t\tThe given node will be marked unschedulable to prevent new pods from arriving.\n\t\t'drain' evicts the pods if the APIServer supports eviction\n\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use normal DELETE\n\t\tto delete the pods.\n\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot be deleted through\n\t\tthe API server).  If there are DaemonSet-managed pods, drain will not proceed\n\t\twithout --ignore-daemonsets, and regardless it will not delete any\n\t\tDaemonSet-managed pods, because those pods would be immediately replaced by the\n\t\tDaemonSet controller, which ignores unschedulable markings.  If there are any\n\t\tpods that are neither mirror pods nor managed by ReplicationController,\n\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete any pods unless you\n\t\tuse --force.  --force will also allow deletion to proceed if the managing resource of one\n\t\tor more pods is missing.\n\n\t\t'drain' waits for graceful termination. You should not operate on the machine until\n\t\tthe command completes.\n\n\t\tWhen you are ready to put the node back into service, use kubectl uncordon, which\n\t\twill make the node schedulable again.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)\x00\n\t\tEdit a resource from the default editor.\n\n\t\tThe edit command allows you to directly edit any API resource you can retrieve via the\n\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, or EDITOR\n\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for Windows.\n\t\tYou can edit multiple objects, although changes are applied one at a time. The command\n\t\taccepts filenames as well as command line arguments, although the files you point to must\n\t\tbe previously saved versions of resources.\n\n\t\tEditing is done with the API version used to fetch the resource.\n\t\tTo edit using a specific API version, fully-qualify the resource, version, and group.\n\n\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n\n\t\tThe flag --windows-line-endings can be used to force Windows line endings,\n\t\totherwise the default for your operating system will be used.\n\n\t\tIn the event an error occurs while updating, a temporary file will be created on disk\n\t\tthat contains your unapplied changes. The most common error when updating a resource\n\t\tis another editor changing the resource on the server. When this occurs, you will have\n\t\tto apply your changes to the newer version of the resource, or update your temporary\n\t\tsaved copy to include the latest resource version.\x00\n\t\tMark node as schedulable.\x00\n\t\tMark node as unschedulable.\x00\n\t\tOutput shell completion code for the specified shell (bash or zsh).\n\t\tThe shell code must be evalutated to provide interactive\n\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n\t\tthe .bash_profile.\n\n\t\tNote: this requires the bash-completion framework, which is not installed\n\t\tby default on Mac.  This can be installed by using homebrew:\n\n\t\t    $ brew install bash-completion\n\n\t\tOnce installed, bash_completion must be evaluated.  This can be done by adding the\n\t\tfollowing line to the .bash_profile\n\n\t\t    $ source $(brew --prefix)/etc/bash_completion\n\n\t\tNote for zsh users: [1] zsh completions are only supported in versions of zsh >= 5.2\x00\n\t\tPerform a rolling update of the given ReplicationController.\n\n\t\tReplaces the specified replication controller with a new replication controller by updating one pod at a time to use the\n\t\tnew PodTemplate. The new-controller.json must specify the same namespace as the\n\t\texisting replication controller and overwrite at least one (common) label in its replicaSelector.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)\x00\n\t\tReplace a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted. If replacing an existing resource, the\n\t\tcomplete resource spec must be provided. This can be obtained by\n\n\t\t    $ kubectl get TYPE NAME -o yaml\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or Job.\n\n\t\tScale also allows users to specify one or more preconditions for the scale action.\n\n\t\tIf --current-replicas or --resource-version is specified, it is validated before the\n\t\tscale is attempted, and it is guaranteed that the precondition holds true when the\n\t\tscale is sent to the server.\x00\n\t\tSet the latest last-applied-configuration annotations by setting it to match the contents of a file.\n\t\tThis results in the last-applied-configuration being updated as though 'kubectl apply -f <file>' was run,\n\t\twithout updating any other parts of the object.\x00\n\t\tTo proxy all of the kubernetes api and nothing else, use:\n\n\t\t    $ kubectl proxy --api-prefix=/\n\n\t\tTo proxy only part of the kubernetes api and also some static files:\n\n\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/api/\n\n\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n\n\t\tTo proxy the entire kubernetes api at a different root, use:\n\n\t\t    $ kubectl proxy --api-prefix=/custom/\n\n\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'\x00\n\t\tUpdate field(s) of a resource using strategic merge patch\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tUpdate the labels on a resource.\n\n\t\t* A label must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* If --overwrite is true, then existing labels can be overwritten, otherwise attempting to overwrite a label will result in an error.\n\t\t* If --resource-version is specified, then updates will use this resource version, otherwise the existing resource-version will be used.\x00\n\t\tUpdate the taints on one or more nodes.\n\n\t\t* A taint consists of a key, value, and effect. As an argument here, it is expressed as key=value:effect.\n\t\t* The key must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* The value must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[2]d characters.\n\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n\t\t* Currently taint can only apply to node.\x00\n\t\tView the latest last-applied-configuration annotations by type/name or file.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change output format.\x00\n\t    # !!!Important Note!!!\n\t    # Requires that the 'tar' binary is present in your container\n\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n\n\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in the default namespace\n\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n\n        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific container\n\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n\n\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace <some-namespace>\n\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n\n\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar\x00\n\t  # Create a new TLS secret named tls-secret with the given key pair:\n\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/to/tls.key\x00\n\t  # Create a new namespace named my-namespace\n\t  kubectl create namespace my-namespace\x00\n\t  # Create a new secret named my-secret with keys for each file in folder bar\n\t  kubectl create secret generic my-secret --from-file=path/to/bar\n\n\t  # Create a new secret named my-secret with specified keys instead of names on disk\n\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/.ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n\n\t  # Create a new secret named my-secret with key1=supersecret and key2=topsecret\n\t  kubectl create secret generic my-secret --from-literal=key1=supersecret --from-literal=key2=topsecret\x00\n\t  # Create a new service account named my-service-account\n\t  kubectl create serviceaccount my-service-account\x00\n\t# Create a new ExternalName service named my-ns \n\tkubectl create service externalname my-ns --external-name bar.com\x00\n\tCreate an ExternalName service with the specified name.\n\n\tExternalName service references to an external DNS address instead of\n\tonly pods, which will allow application authors to reference services\n\tthat exist off platform, on other clusters, or locally.\x00\n\tHelp provides help for any command in the application.\n\tSimply type kubectl help [path to command] for full details.\x00\n    # Create a new LoadBalancer service named my-lbs\n    kubectl create service loadbalancer my-lbs --tcp=5678:8080\x00\n    # Create a new clusterIP service named my-cs\n    kubectl create service clusterip my-cs --tcp=5678:8080\n\n    # Create a new clusterIP service named my-cs (in headless mode)\n    kubectl create service clusterip my-cs --clusterip=\"None\"\x00\n    # Create a new deployment named my-dep that runs the busybox image.\n    kubectl create deployment my-dep --image=busybox\x00\n    # Create a new nodeport service named my-ns\n    kubectl create service nodeport my-ns --tcp=5678:8080\x00\n    # Dump current cluster state to stdout\n    kubectl cluster-info dump\n\n    # Dump current cluster state to /path/to/cluster-state\n    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n\n    # Dump all namespaces to stdout\n    kubectl cluster-info dump --all-namespaces\n\n    # Dump a set of namespaces to /path/to/cluster-state\n    kubectl cluster-info dump --namespaces default,kube-system --output-directory=/path/to/cluster-state\x00\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend'.\n    # If the same annotation is set multiple times, only the last value will be applied\n    kubectl annotate pods foo description='my frontend'\n\n    # Update a pod identified by type and name in \"pod.json\"\n    kubectl annotate -f pod.json description='my frontend'\n\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend running nginx', overwriting any existing value.\n    kubectl annotate --overwrite pods foo description='my frontend running nginx'\n\n    # Update all pods in the namespace\n    kubectl annotate pods --all description='my frontend running nginx'\n\n    # Update pod 'foo' only if the resource is unchanged from version 1.\n    kubectl annotate pods foo description='my frontend running nginx' --resource-version=1\n\n    # Update pod 'foo' by removing an annotation named 'description' if it exists.\n    # Does not require the --overwrite flag.\n    kubectl annotate pods foo description-\x00\n    Create a LoadBalancer service with the specified name.\x00\n    Create a clusterIP service with the specified name.\x00\n    Create a deployment with the specified name.\x00\n    Create a nodeport service with the specified name.\x00\n    Dumps cluster info out suitable for debugging and diagnosing cluster problems.  By default, dumps everything to\n    stdout. You can optionally specify a directory with --output-directory.  If you specify a directory, kubernetes will\n    build a set of files in that directory.  By default only dumps things in the 'kube-system' namespace, but you can\n    switch to a different namespace with the --namespaces flag, or specify --all-namespaces to dump all namespaces.\n\n    The command also dumps the logs of all of the pods in the cluster, these logs are dumped into different directories\n    based on namespace and pod name.\x00\n  Display addresses of the master and services with label kubernetes.io/cluster-service=true\n  To further debug and diagnose cluster problems, use 'kubectl cluster-info dump'.\x00A comma-delimited set of quota scopes that must all match each object tracked by the quota.\x00A comma-delimited set of resource=quantity pairs that define a hard limit.\x00A label selector to use for this budget. Only equality-based selector requirements are supported.\x00A label selector to use for this service. Only equality-based selector requirements are supported. If empty (the default) infer the selector from the replication controller or replica set.)\x00A schedule in the Cron format the job should be run with.\x00Additional external IP address (not managed by Kubernetes) to accept for the service. If this IP is routed to a node, the service can be accessed by this IP in addition to its generated service IP.\x00An inline JSON override for the generated object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.\x00An inline JSON override for the generated service object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.  Only used if --expose is true.\x00Apply a configuration to a resource by filename or stdin\x00Approve a certificate signing request\x00Assign your own ClusterIP or set to 'None' for a 'headless' service (no loadbalancing).\x00Attach to a running container\x00Auto-scale a Deployment, ReplicaSet, or ReplicationController\x00ClusterIP to be assigned to the service. Leave empty to auto-allocate, or set to 'None' to create a headless service.\x00ClusterRole this ClusterRoleBinding should reference\x00ClusterRole this RoleBinding should reference\x00Container name which will have its image upgraded. Only relevant when --image is specified, ignored otherwise. Required when using --image on a multi-container pod\x00Convert config files between different API versions\x00Copy files and directories to and from containers.\x00Create a ClusterRoleBinding for a particular ClusterRole\x00Create a LoadBalancer service.\x00Create a NodePort service.\x00Create a RoleBinding for a particular Role or ClusterRole\x00Create a TLS secret\x00Create a clusterIP service.\x00Create a configmap from a local file, directory or literal value\x00Create a deployment with the specified name.\x00Create a namespace with the specified name\x00Create a pod disruption budget with the specified name.\x00Create a quota with the specified name.\x00Create a resource by filename or stdin\x00Create a secret for use with a Docker registry\x00Create a secret from a local file, directory or literal value\x00Create a secret using specified subcommand\x00Create a service account with the specified name\x00Create a service using specified subcommand.\x00Create an ExternalName service.\x00Delete resources by filenames, stdin, resources and names, or by resources and label selector\x00Delete the specified cluster from the kubeconfig\x00Delete the specified context from the kubeconfig\x00Deny a certificate signing request\x00Deprecated: Gracefully shut down a resource by name or filename\x00Describe one or many contexts\x00Display Resource (CPU/Memory/Storage) usage of nodes\x00Display Resource (CPU/Memory/Storage) usage of pods\x00Display Resource (CPU/Memory/Storage) usage.\x00Display cluster info\x00Display clusters defined in the kubeconfig\x00Display merged kubeconfig settings or a specified kubeconfig file\x00Display one or many resources\x00Displays the current-context\x00Documentation of resources\x00Drain node in preparation for maintenance\x00Dump lots of relevant info for debugging and diagnosis\x00Edit a resource on the server\x00Email for Docker registry\x00Execute a command in a container\x00Explicit policy for when to pull container images. Required when --image is same as existing image, ignored otherwise.\x00Forward one or more local ports to a pod\x00Help about any command\x00IP to assign to the Load Balancer. If empty, an ephemeral IP will be created and used (cloud-provider specific).\x00If non-empty, set the session affinity for the service to this; legal values: 'None', 'ClientIP'\x00If non-empty, the annotation update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00If non-empty, the labels update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00Image to use for upgrading the replication controller. Must be distinct from the existing image (either new image or new image tag).  Can not be used with --filename/-f\x00Manage a deployment rollout\x00Mark node as schedulable\x00Mark node as unschedulable\x00Mark the provided resource as paused\x00Modify certificate resources.\x00Modify kubeconfig files\x00Name or number for the port on the container that the service should direct traffic to. Optional.\x00Only return logs after a specific date (RFC3339). Defaults to all logs. Only one of since-time / since may be used.\x00Output shell completion code for the specified shell (bash or zsh)\x00Output the formatted object with the given group version (for ex: 'extensions/v1beta1').)\x00Password for Docker registry authentication\x00Path to PEM encoded public key certificate.\x00Path to private key associated with given certificate.\x00Perform a rolling update of the given ReplicationController\x00Precondition for resource version. Requires that the current resource version match this value in order to scale.\x00Print the client and server version information\x00Print the list of flags inherited by all commands\x00Print the logs for a container in a pod\x00Replace a resource by filename or stdin\x00Resume a paused resource\x00Role this RoleBinding should reference\x00Run a particular image on the cluster\x00Run a proxy to the Kubernetes API server\x00Server location for Docker registry\x00Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job\x00Set specific features on objects\x00Set the last-applied-configuration annotation on a live object to match the contents of a file.\x00Set the selector on a resource\x00Sets a cluster entry in kubeconfig\x00Sets a context entry in kubeconfig\x00Sets a user entry in kubeconfig\x00Sets an individual value in a kubeconfig file\x00Sets the current-context in a kubeconfig file\x00Show details of a specific resource or group of resources\x00Show the status of the rollout\x00Synonym for --target-port\x00Take a replication controller, service, deployment or pod and expose it as a new Kubernetes Service\x00The image for the container to run.\x00The image pull policy for the container. If left empty, this value will not be specified by the client and defaulted by the server\x00The key to use to differentiate between two different controllers, default 'deployment'.  Only relevant when --image is specified, ignored otherwise\x00The minimum number or percentage of available pods this budget requires.\x00The name for the newly created object.\x00The name for the newly created object. If not specified, the name of the input resource will be used.\x00The name of the API generator to use, see http://kubernetes.io/docs/user-guide/kubectl-conventions/#generators for a list.\x00The name of the API generator to use. Currently there is only 1 generator.\x00The name of the API generator to use. There are 2 generators: 'service/v1' and 'service/v2'. The only difference between them is that service port in v1 is named 'default', while it is left unnamed in v2. Default is 'service/v2'.\x00The name of the generator to use for creating a service.  Only used if --expose is true\x00The network protocol for the service to be created. Default is 'TCP'.\x00The port that the service should serve on. Copied from the resource being exposed, if unspecified\x00The port that this container exposes.  If --expose is true, this is also the port used by the service that is created.\x00The resource requirement limits for this container.  For example, 'cpu=200m,memory=512Mi'.  Note that server side components may assign limits depending on the server configuration, such as limit ranges.\x00The resource requirement requests for this container.  For example, 'cpu=100m,memory=256Mi'.  Note that server side components may assign requests depending on the server configuration, such as limit ranges.\x00The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  If set to 'Always' a deployment is created, if set to 'OnFailure' a job is created, if set to 'Never', a regular pod is created. For the latter two --replicas must be 1.  Default 'Always', for CronJobs `Never`.\x00The type of secret to create\x00Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is 'ClusterIP'.\x00Undo a previous rollout\x00Unsets an individual value in a kubeconfig file\x00Update field(s) of a resource using strategic merge patch\x00Update image of a pod template\x00Update resource requests/limits on objects with pod templates\x00Update the annotations on a resource\x00Update the labels on a resource\x00Update the taints on one or more nodes\x00Username for Docker registry authentication\x00View latest last-applied-configuration annotations of a resource/object\x00View rollout history\x00Where to output the files.  If empty or '-' uses stdout, otherwise creates a directory hierarchy in that directory\x00dummy restart flag)\x00external name of service\x00kubectl controls the Kubernetes cluster manager\x00Project-Id-Version: gettext-go-examples-hello\nReport-Msgid-Bugs-To: EMAIL\nPOT-Creation-Date: 2017-03-14 21:32-0700\nPO-Revision-Date: 2017-03-14 21:33-0800\nLast-Translator: Brendan Burns <brendan.d.burns@gmail.com>\nLanguage-Team: \nLanguage: en\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 8bit\nX-Generator: Poedit 1.6.10\nX-Poedit-SourceCharset: UTF-8\nPlural-Forms: nplurals=2; plural=(n != 1);\n\x00\n\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the cluster-admin ClusterRole\n\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin ClusterRole\n\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --user=user2 --group=group1\x00\n\t\t  # Create a new configmap named my-config based on folder bar\n\t\t  kubectl create configmap my-config --from-file=path/to/bar\n\n\t\t  # Create a new configmap named my-config with specified keys instead of file basenames on disk\n\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1.txt --from-file=key2=/path/to/bar/file2.txt\n\n\t\t  # Create a new configmap named my-config with key1=config1 and key2=config2\n\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-literal=key2=config2\x00\n\t\t  # If you don't already have a .dockercfg file, you can create a dockercfg secret directly by using:\n\t\t  kubectl create secret docker-registry my-secret --docker-server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL\x00\n\t\t  # Show metrics for all nodes\n\t\t  kubectl top node\n\n\t\t  # Show metrics for a given node\n\t\t  kubectl top node NODE_NAME\x00\n\t\t# Apply the configuration in pod.json to a pod.\n\t\tkubectl apply -f ./pod.json\n\n\t\t# Apply the JSON passed into stdin to a pod.\n\t\tcat pod.json | kubectl apply -f -\n\n\t\t# Note: --prune is still in Alpha\n\t\t# Apply the configuration in manifest.yaml that matches label app=nginx and delete all the other resources that are not in the file and match label app=nginx.\n\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n\n\t\t# Apply the configuration in manifest.yaml and delete all the other configmaps that are not in the file.\n\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/ConfigMap\x00\n\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and 10, target CPU utilization specified so a default autoscaling policy will be used:\n\t\tkubectl autoscale deployment foo --min=2 --max=10\n\n\t\t# Auto scale a replication controller \"foo\", with the number of pods between 1 and 5, target CPU utilization at 80%:\n\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80\x00\n\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n\t\tkubectl convert -f pod.yaml\n\n\t\t# Convert the live state of the resource specified by 'pod.yaml' to the latest version\n\t\t# and print to stdout in json format.\n\t\tkubectl convert -f pod.yaml --local -o json\n\n\t\t# Convert all files under current directory to latest version and create them all.\n\t\tkubectl convert -f . | kubectl create -f -\x00\n\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods\n\n\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get\", \"watch\" and \"list\" on pods\n\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --resource=pods\n\n\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --resource=pods --resource-name=readablepod\x00\n\t\t# Create a new resourcequota named my-quota\n\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,replicationcontrollers=2,resourcequotas=1,secrets=5,persistentvolumeclaims=10\n\n\t\t# Create a new resourcequota named best-effort\n\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort\x00\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=rails label\n\t\t# and require at least one of them being available at any point in time.\n\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-available=1\n\n\t\t# Create a pod disruption budget named my-pdb that will select all pods with the app=nginx label\n\t\t# and require at least half of the pods selected to be available at any point in time.\n\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%\x00\n\t\t# Create a pod using the data in pod.json.\n\t\tkubectl create -f ./pod.json\n\n\t\t# Create a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl create -f -\n\n\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format then create the resource using the edited data.\n\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json\x00\n\t\t# Create a service for a replicated nginx, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rc nginx --port=80 --target-port=8000\n\n\t\t# Create a service for a replication controller identified by type and name specified in \"nginx-controller.yaml\", which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n\n\t\t# Create a service for a pod valid-pod, which serves on port 444 with the name \"frontend\"\n\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n\n\t\t# Create a second service based on the above service, exposing the container port 8443 as port 443 with the name \"nginx-https\"\n\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-https\n\n\t\t# Create a service for a replicated streaming application on port 4100 balancing UDP traffic and named 'video-stream'.\n\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-stream\n\n\t\t# Create a service for a replicated nginx using replica set, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose rs nginx --port=80 --target-port=8000\n\n\t\t# Create a service for an nginx deployment, which serves on port 80 and connects to the containers on port 8000.\n\t\tkubectl expose deployment nginx --port=80 --target-port=8000\x00\n\t\t# Delete a pod using the type and name specified in pod.json.\n\t\tkubectl delete -f ./pod.json\n\n\t\t# Delete a pod based on the type and name in the JSON passed into stdin.\n\t\tcat pod.json | kubectl delete -f -\n\n\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n\t\tkubectl delete pod,service baz foo\n\n\t\t# Delete pods and services with label name=myLabel.\n\t\tkubectl delete pods,services -l name=myLabel\n\n\t\t# Delete a pod with minimal delay\n\t\tkubectl delete pod foo --now\n\n\t\t# Force delete a pod on a dead node\n\t\tkubectl delete pod foo --grace-period=0 --force\n\n\t\t# Delete all pods\n\t\tkubectl delete pods --all\x00\n\t\t# Describe a node\n\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n\n\t\t# Describe a pod\n\t\tkubectl describe pods/nginx\n\n\t\t# Describe a pod identified by type and name in \"pod.json\"\n\t\tkubectl describe -f pod.json\n\n\t\t# Describe all pods\n\t\tkubectl describe pods\n\n\t\t# Describe pods by label name=myLabel\n\t\tkubectl describe po -l name=myLabel\n\n\t\t# Describe all pods managed by the 'frontend' replication controller (rc-created pods\n\t\t# get the name of the rc as a prefix in the pod the name).\n\t\tkubectl describe pods frontend\x00\n\t\t# Drain node \"foo\", even if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n\t\t$ kubectl drain foo --force\n\n\t\t# As above, but abort if there are pods not managed by a ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a grace period of 15 minutes.\n\t\t$ kubectl drain foo --grace-period=900\x00\n\t\t# Edit the service named 'docker-registry':\n\t\tkubectl edit svc/docker-registry\n\n\t\t# Use an alternative editor\n\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n\n\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n\t\tkubectl edit job.v1.batch/myjob -o json\n\n\t\t# Edit the deployment 'mydeployment' in YAML and save the modified config in its annotation:\n\t\tkubectl edit deployment/mydeployment -o yaml --save-config\x00\n\t\t# Get output from running 'date' from pod 123456-7890, using the first container by default\n\t\tkubectl exec 123456-7890 date\n\n\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n\t\tkubectl exec 123456-7890 -c ruby-container date\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il\x00\n\t\t# Get output from running pod 123456-7890, using the first container by default\n\t\tkubectl attach 123456-7890\n\n\t\t# Get output from ruby-container from pod 123456-7890\n\t\tkubectl attach 123456-7890 -c ruby-container\n\n\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container from pod 123456-7890\n\t\t# and sends stdout/stderr from 'bash' back to the client\n\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n\n\t\t# Get output from the first pod of a ReplicaSet named nginx\n\t\tkubectl attach rs/nginx\n\t\t\x00\n\t\t# Get the documentation of the resource and its fields\n\t\tkubectl explain pods\n\n\t\t# Get the documentation of a specific field of a resource\n\t\tkubectl explain pods.spec.containers\x00\n\t\t# Install bash completion on a Mac using homebrew\n\t\tbrew install bash-completion\n\t\tprintf \"\n# Bash completion support\nsource $(brew --prefix)/etc/bash_completion\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for bash into the current shell\n\t\tsource <(kubectl completion bash)\n\n\t\t# Write bash completion code to a file and source if from .bash_profile\n\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n\t\tprintf \"\n# Kubectl shell completion\nsource '$HOME/.kube/completion.bash.inc'\n\" >> $HOME/.bash_profile\n\t\tsource $HOME/.bash_profile\n\n\t\t# Load the kubectl completion code for zsh[1] into the current shell\n\t\tsource <(kubectl completion zsh)\x00\n\t\t# List all pods in ps output format.\n\t\tkubectl get pods\n\n\t\t# List all pods in ps output format with more information (such as node name).\n\t\tkubectl get pods -o wide\n\n\t\t# List a single replication controller with specified NAME in ps output format.\n\t\tkubectl get replicationcontroller web\n\n\t\t# List a single pod in JSON output format.\n\t\tkubectl get -o json pod web-pod-13je7\n\n\t\t# List a pod identified by type and name specified in \"pod.yaml\" in JSON output format.\n\t\tkubectl get -f pod.yaml -o json\n\n\t\t# Return only the phase value of the specified pod.\n\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n\n\t\t# List all replication controllers and services together in ps output format.\n\t\tkubectl get rc,services\n\n\t\t# List one or more resources by their type and names.\n\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n\n\t\t# List all resources with different types.\n\t\tkubectl get all\x00\n\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports 5000 and 6000 in the pod\n\t\tkubectl port-forward mypod 5000 6000\n\n\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 8888:5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod :5000\n\n\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n\t\tkubectl port-forward mypod 0:5000\x00\n\t\t# Mark node \"foo\" as schedulable.\n\t\t$ kubectl uncordon foo\x00\n\t\t# Mark node \"foo\" as unschedulable.\n\t\tkubectl cordon foo\x00\n\t\t# Partially update a node using strategic merge patch\n\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Partially update a node identified by the type and name specified in \"node.json\" using strategic merge patch\n\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n\n\t\t# Update a container's image; spec.containers[*].name is required because it's a merge key\n\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n\n\t\t# Update a container's image using a json patch with positional arrays\n\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", \"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'\x00\n\t\t# Print flags inherited by all commands\n\t\tkubectl options\x00\n\t\t# Print the address of the master and cluster services\n\t\tkubectl cluster-info\x00\n\t\t# Print the client and server versions for the current context\n\t\tkubectl version\x00\n\t\t# Print the supported API versions\n\t\tkubectl api-versions\x00\n\t\t# Replace a pod using the data in pod.json.\n\t\tkubectl replace -f ./pod.json\n\n\t\t# Replace a pod based on the JSON passed into stdin.\n\t\tcat pod.json | kubectl replace -f -\n\n\t\t# Update a single-container pod's image version (tag) to v4\n\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/\x01:v4/' | kubectl replace -f -\n\n\t\t# Force replace, delete and then re-create the resource\n\t\tkubectl replace --force -f ./pod.json\x00\n\t\t# Return snapshot logs from pod nginx with only one container\n\t\tkubectl logs nginx\n\n\t\t# Return snapshot logs for the pods defined by label app=nginx\n\t\tkubectl logs -lapp=nginx\n\n\t\t# Return snapshot of previous terminated ruby container logs from pod web-1\n\t\tkubectl logs -p -c ruby web-1\n\n\t\t# Begin streaming the logs of the ruby container in pod web-1\n\t\tkubectl logs -f -c ruby web-1\n\n\t\t# Display only the most recent 20 lines of output in pod nginx\n\t\tkubectl logs --tail=20 nginx\n\n\t\t# Show all logs from pod nginx written in the last hour\n\t\tkubectl logs --since=1h nginx\n\n\t\t# Return snapshot logs from first container of a job named hello\n\t\tkubectl logs job/hello\n\n\t\t# Return snapshot logs from container nginx-1 of a deployment named nginx\n\t\tkubectl logs deployment/nginx -c nginx-1\x00\n\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static content from ./local/www/\n\t\tkubectl proxy --port=8011 --www=./local/www/\n\n\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n\t\t# The chosen port for the server will be output to stdout.\n\t\tkubectl proxy --port=0\n\n\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-api\n\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/pods/\n\t\tkubectl proxy --api-prefix=/k8s-api\x00\n\t\t# Scale a replicaset named 'foo' to 3.\n\t\tkubectl scale --replicas=3 rs/foo\n\n\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" to 3.\n\t\tkubectl scale --replicas=3 -f foo.yaml\n\n\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n\n\t\t# Scale multiple replication controllers.\n\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n\n\t\t# Scale job named 'cron' to 3.\n\t\tkubectl scale --replicas=3 job/cron\x00\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file.\n\t\tkubectl apply set-last-applied -f deploy.yaml\n\n\t\t# Execute set-last-applied against each configuration file in a directory.\n\t\tkubectl apply set-last-applied -f path/\n\n\t\t# Set the last-applied-configuration of a resource to match the contents of a file, will create the annotation if it does not already exist.\n\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n\t\t\x00\n\t\t# Show metrics for all pods in the default namespace\n\t\tkubectl top pod\n\n\t\t# Show metrics for all pods in the given namespace\n\t\tkubectl top pod --namespace=NAMESPACE\n\n\t\t# Show metrics for a given pod and its containers\n\t\tkubectl top pod POD_NAME --containers\n\n\t\t# Show metrics for the pods defined by label name=myLabel\n\t\tkubectl top pod -l name=myLabel\x00\n\t\t# Shut down foo.\n\t\tkubectl stop replicationcontroller foo\n\n\t\t# Stop pods and services with label name=myLabel.\n\t\tkubectl stop pods,services -l name=myLabel\n\n\t\t# Shut down the service defined in service.json\n\t\tkubectl stop -f service.json\n\n\t\t# Shut down all resources in the path/to/resources directory\n\t\tkubectl stop -f path/to/resources\x00\n\t\t# Start a single instance of nginx.\n\t\tkubectl run nginx --image=nginx\n\n\t\t# Start a single instance of hazelcast and let the container expose port 5701 .\n\t\tkubectl run hazelcast --image=hazelcast --port=5701\n\n\t\t# Start a single instance of hazelcast and set environment variables \"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --env=\"POD_NAMESPACE=default\"\n\n\t\t# Start a replicated instance of nginx.\n\t\tkubectl run nginx --image=nginx --replicas=5\n\n\t\t# Dry run. Print the corresponding API objects without creating them.\n\t\tkubectl run nginx --image=nginx --dry-run\n\n\t\t# Start a single instance of nginx, but overload the spec of the deployment with a partial set of values parsed from JSON.\n\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", \"spec\": { ... } }'\n\n\t\t# Start a pod of busybox and keep it in the foreground, don't restart it if it exits.\n\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n\n\t\t# Start the nginx container using the default command, but use custom arguments (arg1 .. argN) for that command.\n\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n\n\t\t# Start the nginx container using a different command and custom arguments.\n\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n\n\t\t# Start the perl container to compute \u03c0 to 2000 places and print it out.\n\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\n\n\t\t# Start the cron job to compute \u03c0 to 2000 places and print it out every 5 minutes.\n\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'\x00\n\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-user' and effect 'NoSchedule'.\n\t\t# If a taint with that key and effect already exists, its value is replaced as specified.\n\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n\n\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect 'NoSchedule' if one exists.\n\t\tkubectl taint nodes foo dedicated:NoSchedule-\n\n\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n\t\tkubectl taint nodes foo dedicated-\x00\n\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n\t\tkubectl label pods foo unhealthy=true\n\n\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', overwriting any existing value.\n\t\tkubectl label --overwrite pods foo status=unhealthy\n\n\t\t# Update all pods in the namespace\n\t\tkubectl label pods --all status=unhealthy\n\n\t\t# Update a pod identified by the type and name in \"pod.json\"\n\t\tkubectl label -f pod.json status=unhealthy\n\n\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n\t\tkubectl label pods foo status=unhealthy --resource-version=1\n\n\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n\t\t# Does not require the --overwrite flag.\n\t\tkubectl label pods foo bar-\x00\n\t\t# Update pods of frontend-v1 using new replication controller data in frontend-v2.json.\n\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n\n\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n\n\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the image, and switching the\n\t\t# name of the replication controller.\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n\n\t\t# Update the pods of frontend by just changing the image, and keeping the old name.\n\t\tkubectl rolling-update frontend --image=image:v2\n\n\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to frontend-v2).\n\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback\x00\n\t\t# View the last-applied-configuration annotations by type/name in YAML.\n\t\tkubectl apply view-last-applied deployment/nginx\n\n\t\t# View the last-applied-configuration annotations by file in JSON\n\t\tkubectl apply view-last-applied -f deploy.yaml -o json\x00\n\t\tApply a configuration to a resource by filename or stdin.\n\t\tThis resource will be created if it doesn't exist yet.\n\t\tTo use 'apply', always create the resource initially with either 'apply' or 'create --save-config'.\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not use unless you are aware of what the current state is. See https://issues.k8s.io/34274.\x00\n\t\tConvert config files between different API versions. Both YAML\n\t\tand JSON formats are accepted.\n\n\t\tThe command takes filename, directory, or URL as input, and convert it into format\n\t\tof version specified by --output-version flag. If target version is not specified or\n\t\tnot supported, convert to latest version.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change to output destination.\x00\n\t\tCreate a ClusterRole.\x00\n\t\tCreate a ClusterRoleBinding for a particular ClusterRole.\x00\n\t\tCreate a RoleBinding for a particular Role or ClusterRole.\x00\n\t\tCreate a TLS secret from the given public/private key pair.\n\n\t\tThe public/private key pair must exist before hand. The public key certificate must be .PEM encoded and match the given private key.\x00\n\t\tCreate a configmap based on a file, directory, or specified literal value.\n\n\t\tA single configmap may package one or more key/value pairs.\n\n\t\tWhen creating a configmap based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a configmap based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the configmap.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a namespace with the specified name.\x00\n\t\tCreate a new secret for use with Docker registries.\n\n\t\tDockercfg secrets are used to authenticate against Docker registries.\n\n\t\tWhen using the Docker command line to push images, you can authenticate to a given registry by running\n\n\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n\n    That produces a ~/.dockercfg file that is used by subsequent 'docker push' and 'docker pull' commands to\n\t\tauthenticate to the registry. The email address is optional.\n\n\t\tWhen creating applications, you may have a Docker registry that requires authentication.  In order for the\n\t\tnodes to pull images on your behalf, they have to have the credentials.  You can provide this information\n\t\tby creating a dockercfg secret and attaching it to your service account.\x00\n\t\tCreate a pod disruption budget with the specified name, selector, and desired minimum available pods\x00\n\t\tCreate a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted.\x00\n\t\tCreate a resourcequota with the specified name, hard limits and optional scopes\x00\n\t\tCreate a role with single rule.\x00\n\t\tCreate a secret based on a file, directory, or specified literal value.\n\n\t\tA single secret may package one or more key/value pairs.\n\n\t\tWhen creating a secret based on a file, the key will default to the basename of the file, and the value will\n\t\tdefault to the file content.  If the basename is an invalid key, you may specify an alternate key.\n\n\t\tWhen creating a secret based on a directory, each file whose basename is a valid key in the directory will be\n\t\tpackaged into the secret.  Any directory entries except regular files are ignored (e.g. subdirectories,\n\t\tsymlinks, devices, pipes, etc).\x00\n\t\tCreate a service account with the specified name.\x00\n\t\tCreate and run a particular image, possibly replicated.\n\n\t\tCreates a deployment or job to manage the created container(s).\x00\n\t\tCreates an autoscaler that automatically chooses and sets the number of pods that run in a kubernetes cluster.\n\n\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and creates an autoscaler that uses the given resource as a reference.\n\t\tAn autoscaler can automatically increase or decrease number of pods deployed within the system as needed.\x00\n\t\tDelete resources by filenames, stdin, resources and names, or by resources and label selector.\n\n\t\tJSON and YAML formats are accepted. Only one type of the arguments may be specified: filenames,\n\t\tresources and names, or resources and label selector.\n\n\t\tSome resources, such as pods, support graceful deletion. These resources define a default period\n\t\tbefore they are forcibly terminated (the grace period) but you may override that value with\n\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. Because these resources often\n\t\trepresent entities in the cluster, deletion may not be acknowledged immediately. If the node\n\t\thosting a pod is down or cannot reach the API server, termination may take significantly longer\n\t\tthan the grace period. To force delete a resource,\tyou must pass a grace\tperiod of 0 and specify\n\t\tthe --force flag.\n\n\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the pod's processes have been\n\t\tterminated, which can leave those processes running until the node detects the deletion and\n\t\tcompletes graceful deletion. If your processes use shared storage or talk to a remote API and\n\t\tdepend on the name of the pod to identify themselves, force deleting those pods may result in\n\t\tmultiple processes running on different machines using the same identification which may lead\n\t\tto data corruption or inconsistency. Only force delete pods when you are sure the pod is\n\t\tterminated, or if your application can tolerate multiple copies of the same pod running at once.\n\t\tAlso, if you force delete pods the scheduler may place new pods on those nodes before the node\n\t\thas released those resources and causing those pods to be evicted immediately.\n\n\t\tNote that the delete command does NOT do resource version checks, so if someone\n\t\tsubmits an update to a resource right when you submit a delete, their update\n\t\twill be lost along with the rest of the resource.\x00\n\t\tDeprecated: Gracefully shut down a resource by name or filename.\n\n\t\tThe stop command is deprecated, all its functionalities are covered by delete command.\n\t\tSee 'kubectl delete --help' for more details.\n\n\t\tAttempts to shut down and delete a resource that supports graceful termination.\n\t\tIf the resource is scalable it will be scaled to 0 before deletion.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n\n\t\tThe top-node command allows you to see the resource consumption of nodes.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n\n\t\tThe 'top pod' command allows you to see the resource consumption of pods.\n\n\t\tDue to the metrics pipeline delay, they may be unavailable for a few minutes\n\t\tsince pod creation.\x00\n\t\tDisplay Resource (CPU/Memory/Storage) usage.\n\n\t\tThe top command allows you to see the resource consumption for nodes or pods.\n\n\t\tThis command requires Heapster to be correctly configured and working on the server. \x00\n\t\tDrain node in preparation for maintenance.\n\n\t\tThe given node will be marked unschedulable to prevent new pods from arriving.\n\t\t'drain' evicts the pods if the APIServer supports eviction\n\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use normal DELETE\n\t\tto delete the pods.\n\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot be deleted through\n\t\tthe API server).  If there are DaemonSet-managed pods, drain will not proceed\n\t\twithout --ignore-daemonsets, and regardless it will not delete any\n\t\tDaemonSet-managed pods, because those pods would be immediately replaced by the\n\t\tDaemonSet controller, which ignores unschedulable markings.  If there are any\n\t\tpods that are neither mirror pods nor managed by ReplicationController,\n\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete any pods unless you\n\t\tuse --force.  --force will also allow deletion to proceed if the managing resource of one\n\t\tor more pods is missing.\n\n\t\t'drain' waits for graceful termination. You should not operate on the machine until\n\t\tthe command completes.\n\n\t\tWhen you are ready to put the node back into service, use kubectl uncordon, which\n\t\twill make the node schedulable again.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)\x00\n\t\tEdit a resource from the default editor.\n\n\t\tThe edit command allows you to directly edit any API resource you can retrieve via the\n\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, or EDITOR\n\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for Windows.\n\t\tYou can edit multiple objects, although changes are applied one at a time. The command\n\t\taccepts filenames as well as command line arguments, although the files you point to must\n\t\tbe previously saved versions of resources.\n\n\t\tEditing is done with the API version used to fetch the resource.\n\t\tTo edit using a specific API version, fully-qualify the resource, version, and group.\n\n\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n\n\t\tThe flag --windows-line-endings can be used to force Windows line endings,\n\t\totherwise the default for your operating system will be used.\n\n\t\tIn the event an error occurs while updating, a temporary file will be created on disk\n\t\tthat contains your unapplied changes. The most common error when updating a resource\n\t\tis another editor changing the resource on the server. When this occurs, you will have\n\t\tto apply your changes to the newer version of the resource, or update your temporary\n\t\tsaved copy to include the latest resource version.\x00\n\t\tMark node as schedulable.\x00\n\t\tMark node as unschedulable.\x00\n\t\tOutput shell completion code for the specified shell (bash or zsh).\n\t\tThe shell code must be evalutated to provide interactive\n\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n\t\tthe .bash_profile.\n\n\t\tNote: this requires the bash-completion framework, which is not installed\n\t\tby default on Mac.  This can be installed by using homebrew:\n\n\t\t    $ brew install bash-completion\n\n\t\tOnce installed, bash_completion must be evaluated.  This can be done by adding the\n\t\tfollowing line to the .bash_profile\n\n\t\t    $ source $(brew --prefix)/etc/bash_completion\n\n\t\tNote for zsh users: [1] zsh completions are only supported in versions of zsh >= 5.2\x00\n\t\tPerform a rolling update of the given ReplicationController.\n\n\t\tReplaces the specified replication controller with a new replication controller by updating one pod at a time to use the\n\t\tnew PodTemplate. The new-controller.json must specify the same namespace as the\n\t\texisting replication controller and overwrite at least one (common) label in its replicaSelector.\n\n\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)\x00\n\t\tReplace a resource by filename or stdin.\n\n\t\tJSON and YAML formats are accepted. If replacing an existing resource, the\n\t\tcomplete resource spec must be provided. This can be obtained by\n\n\t\t    $ kubectl get TYPE NAME -o yaml\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or Job.\n\n\t\tScale also allows users to specify one or more preconditions for the scale action.\n\n\t\tIf --current-replicas or --resource-version is specified, it is validated before the\n\t\tscale is attempted, and it is guaranteed that the precondition holds true when the\n\t\tscale is sent to the server.\x00\n\t\tSet the latest last-applied-configuration annotations by setting it to match the contents of a file.\n\t\tThis results in the last-applied-configuration being updated as though 'kubectl apply -f <file>' was run,\n\t\twithout updating any other parts of the object.\x00\n\t\tTo proxy all of the kubernetes api and nothing else, use:\n\n\t\t    $ kubectl proxy --api-prefix=/\n\n\t\tTo proxy only part of the kubernetes api and also some static files:\n\n\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/api/\n\n\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n\n\t\tTo proxy the entire kubernetes api at a different root, use:\n\n\t\t    $ kubectl proxy --api-prefix=/custom/\n\n\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'\x00\n\t\tUpdate field(s) of a resource using strategic merge patch\n\n\t\tJSON and YAML formats are accepted.\n\n\t\tPlease refer to the models in https://htmlpreview.github.io/?https://github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions.html to find if a field is mutable.\x00\n\t\tUpdate the labels on a resource.\n\n\t\t* A label must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* If --overwrite is true, then existing labels can be overwritten, otherwise attempting to overwrite a label will result in an error.\n\t\t* If --resource-version is specified, then updates will use this resource version, otherwise the existing resource-version will be used.\x00\n\t\tUpdate the taints on one or more nodes.\n\n\t\t* A taint consists of a key, value, and effect. As an argument here, it is expressed as key=value:effect.\n\t\t* The key must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[1]d characters.\n\t\t* The value must begin with a letter or number, and may contain letters, numbers, hyphens, dots, and underscores, up to %[2]d characters.\n\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n\t\t* Currently taint can only apply to node.\x00\n\t\tView the latest last-applied-configuration annotations by type/name or file.\n\n\t\tThe default output will be printed to stdout in YAML format. One can use -o option\n\t\tto change output format.\x00\n\t    # !!!Important Note!!!\n\t    # Requires that the 'tar' binary is present in your container\n\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n\n\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in the default namespace\n\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n\n        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific container\n\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n\n\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace <some-namespace>\n\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n\n\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar\x00\n\t  # Create a new TLS secret named tls-secret with the given key pair:\n\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/to/tls.key\x00\n\t  # Create a new namespace named my-namespace\n\t  kubectl create namespace my-namespace\x00\n\t  # Create a new secret named my-secret with keys for each file in folder bar\n\t  kubectl create secret generic my-secret --from-file=path/to/bar\n\n\t  # Create a new secret named my-secret with specified keys instead of names on disk\n\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/.ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n\n\t  # Create a new secret named my-secret with key1=supersecret and key2=topsecret\n\t  kubectl create secret generic my-secret --from-literal=key1=supersecret --from-literal=key2=topsecret\x00\n\t  # Create a new service account named my-service-account\n\t  kubectl create serviceaccount my-service-account\x00\n\t# Create a new ExternalName service named my-ns \n\tkubectl create service externalname my-ns --external-name bar.com\x00\n\tCreate an ExternalName service with the specified name.\n\n\tExternalName service references to an external DNS address instead of\n\tonly pods, which will allow application authors to reference services\n\tthat exist off platform, on other clusters, or locally.\x00\n\tHelp provides help for any command in the application.\n\tSimply type kubectl help [path to command] for full details.\x00\n    # Create a new LoadBalancer service named my-lbs\n    kubectl create service loadbalancer my-lbs --tcp=5678:8080\x00\n    # Create a new clusterIP service named my-cs\n    kubectl create service clusterip my-cs --tcp=5678:8080\n\n    # Create a new clusterIP service named my-cs (in headless mode)\n    kubectl create service clusterip my-cs --clusterip=\"None\"\x00\n    # Create a new deployment named my-dep that runs the busybox image.\n    kubectl create deployment my-dep --image=busybox\x00\n    # Create a new nodeport service named my-ns\n    kubectl create service nodeport my-ns --tcp=5678:8080\x00\n    # Dump current cluster state to stdout\n    kubectl cluster-info dump\n\n    # Dump current cluster state to /path/to/cluster-state\n    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n\n    # Dump all namespaces to stdout\n    kubectl cluster-info dump --all-namespaces\n\n    # Dump a set of namespaces to /path/to/cluster-state\n    kubectl cluster-info dump --namespaces default,kube-system --output-directory=/path/to/cluster-state\x00\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend'.\n    # If the same annotation is set multiple times, only the last value will be applied\n    kubectl annotate pods foo description='my frontend'\n\n    # Update a pod identified by type and name in \"pod.json\"\n    kubectl annotate -f pod.json description='my frontend'\n\n    # Update pod 'foo' with the annotation 'description' and the value 'my frontend running nginx', overwriting any existing value.\n    kubectl annotate --overwrite pods foo description='my frontend running nginx'\n\n    # Update all pods in the namespace\n    kubectl annotate pods --all description='my frontend running nginx'\n\n    # Update pod 'foo' only if the resource is unchanged from version 1.\n    kubectl annotate pods foo description='my frontend running nginx' --resource-version=1\n\n    # Update pod 'foo' by removing an annotation named 'description' if it exists.\n    # Does not require the --overwrite flag.\n    kubectl annotate pods foo description-\x00\n    Create a LoadBalancer service with the specified name.\x00\n    Create a clusterIP service with the specified name.\x00\n    Create a deployment with the specified name.\x00\n    Create a nodeport service with the specified name.\x00\n    Dumps cluster info out suitable for debugging and diagnosing cluster problems.  By default, dumps everything to\n    stdout. You can optionally specify a directory with --output-directory.  If you specify a directory, kubernetes will\n    build a set of files in that directory.  By default only dumps things in the 'kube-system' namespace, but you can\n    switch to a different namespace with the --namespaces flag, or specify --all-namespaces to dump all namespaces.\n\n    The command also dumps the logs of all of the pods in the cluster, these logs are dumped into different directories\n    based on namespace and pod name.\x00\n  Display addresses of the master and services with label kubernetes.io/cluster-service=true\n  To further debug and diagnose cluster problems, use 'kubectl cluster-info dump'.\x00A comma-delimited set of quota scopes that must all match each object tracked by the quota.\x00A comma-delimited set of resource=quantity pairs that define a hard limit.\x00A label selector to use for this budget. Only equality-based selector requirements are supported.\x00A label selector to use for this service. Only equality-based selector requirements are supported. If empty (the default) infer the selector from the replication controller or replica set.)\x00A schedule in the Cron format the job should be run with.\x00Additional external IP address (not managed by Kubernetes) to accept for the service. If this IP is routed to a node, the service can be accessed by this IP in addition to its generated service IP.\x00An inline JSON override for the generated object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.\x00An inline JSON override for the generated service object. If this is non-empty, it is used to override the generated object. Requires that the object supply a valid apiVersion field.  Only used if --expose is true.\x00Apply a configuration to a resource by filename or stdin\x00Approve a certificate signing request\x00Assign your own ClusterIP or set to 'None' for a 'headless' service (no loadbalancing).\x00Attach to a running container\x00Auto-scale a Deployment, ReplicaSet, or ReplicationController\x00ClusterIP to be assigned to the service. Leave empty to auto-allocate, or set to 'None' to create a headless service.\x00ClusterRole this ClusterRoleBinding should reference\x00ClusterRole this RoleBinding should reference\x00Container name which will have its image upgraded. Only relevant when --image is specified, ignored otherwise. Required when using --image on a multi-container pod\x00Convert config files between different API versions\x00Copy files and directories to and from containers.\x00Create a ClusterRoleBinding for a particular ClusterRole\x00Create a LoadBalancer service.\x00Create a NodePort service.\x00Create a RoleBinding for a particular Role or ClusterRole\x00Create a TLS secret\x00Create a clusterIP service.\x00Create a configmap from a local file, directory or literal value\x00Create a deployment with the specified name.\x00Create a namespace with the specified name\x00Create a pod disruption budget with the specified name.\x00Create a quota with the specified name.\x00Create a resource by filename or stdin\x00Create a secret for use with a Docker registry\x00Create a secret from a local file, directory or literal value\x00Create a secret using specified subcommand\x00Create a service account with the specified name\x00Create a service using specified subcommand.\x00Create an ExternalName service.\x00Delete resources by filenames, stdin, resources and names, or by resources and label selector\x00Delete the specified cluster from the kubeconfig\x00Delete the specified context from the kubeconfig\x00Deny a certificate signing request\x00Deprecated: Gracefully shut down a resource by name or filename\x00Describe one or many contexts\x00Display Resource (CPU/Memory/Storage) usage of nodes\x00Display Resource (CPU/Memory/Storage) usage of pods\x00Display Resource (CPU/Memory/Storage) usage.\x00Display cluster info\x00Display clusters defined in the kubeconfig\x00Display merged kubeconfig settings or a specified kubeconfig file\x00Display one or many resources\x00Displays the current-context\x00Documentation of resources\x00Drain node in preparation for maintenance\x00Dump lots of relevant info for debugging and diagnosis\x00Edit a resource on the server\x00Email for Docker registry\x00Execute a command in a container\x00Explicit policy for when to pull container images. Required when --image is same as existing image, ignored otherwise.\x00Forward one or more local ports to a pod\x00Help about any command\x00IP to assign to the Load Balancer. If empty, an ephemeral IP will be created and used (cloud-provider specific).\x00If non-empty, set the session affinity for the service to this; legal values: 'None', 'ClientIP'\x00If non-empty, the annotation update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00If non-empty, the labels update will only succeed if this is the current resource-version for the object. Only valid when specifying a single resource.\x00Image to use for upgrading the replication controller. Must be distinct from the existing image (either new image or new image tag).  Can not be used with --filename/-f\x00Manage a deployment rollout\x00Mark node as schedulable\x00Mark node as unschedulable\x00Mark the provided resource as paused\x00Modify certificate resources.\x00Modify kubeconfig files\x00Name or number for the port on the container that the service should direct traffic to. Optional.\x00Only return logs after a specific date (RFC3339). Defaults to all logs. Only one of since-time / since may be used.\x00Output shell completion code for the specified shell (bash or zsh)\x00Output the formatted object with the given group version (for ex: 'extensions/v1beta1').)\x00Password for Docker registry authentication\x00Path to PEM encoded public key certificate.\x00Path to private key associated with given certificate.\x00Perform a rolling update of the given ReplicationController\x00Precondition for resource version. Requires that the current resource version match this value in order to scale.\x00Print the client and server version information\x00Print the list of flags inherited by all commands\x00Print the logs for a container in a pod\x00Replace a resource by filename or stdin\x00Resume a paused resource\x00Role this RoleBinding should reference\x00Run a particular image on the cluster\x00Run a proxy to the Kubernetes API server\x00Server location for Docker registry\x00Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job\x00Set specific features on objects\x00Set the last-applied-configuration annotation on a live object to match the contents of a file.\x00Set the selector on a resource\x00Sets a cluster entry in kubeconfig\x00Sets a context entry in kubeconfig\x00Sets a user entry in kubeconfig\x00Sets an individual value in a kubeconfig file\x00Sets the current-context in a kubeconfig file\x00Show details of a specific resource or group of resources\x00Show the status of the rollout\x00Synonym for --target-port\x00Take a replication controller, service, deployment or pod and expose it as a new Kubernetes Service\x00The image for the container to run.\x00The image pull policy for the container. If left empty, this value will not be specified by the client and defaulted by the server\x00The key to use to differentiate between two different controllers, default 'deployment'.  Only relevant when --image is specified, ignored otherwise\x00The minimum number or percentage of available pods this budget requires.\x00The name for the newly created object.\x00The name for the newly created object. If not specified, the name of the input resource will be used.\x00The name of the API generator to use, see http://kubernetes.io/docs/user-guide/kubectl-conventions/#generators for a list.\x00The name of the API generator to use. Currently there is only 1 generator.\x00The name of the API generator to use. There are 2 generators: 'service/v1' and 'service/v2'. The only difference between them is that service port in v1 is named 'default', while it is left unnamed in v2. Default is 'service/v2'.\x00The name of the generator to use for creating a service.  Only used if --expose is true\x00The network protocol for the service to be created. Default is 'TCP'.\x00The port that the service should serve on. Copied from the resource being exposed, if unspecified\x00The port that this container exposes.  If --expose is true, this is also the port used by the service that is created.\x00The resource requirement limits for this container.  For example, 'cpu=200m,memory=512Mi'.  Note that server side components may assign limits depending on the server configuration, such as limit ranges.\x00The resource requirement requests for this container.  For example, 'cpu=100m,memory=256Mi'.  Note that server side components may assign requests depending on the server configuration, such as limit ranges.\x00The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  If set to 'Always' a deployment is created, if set to 'OnFailure' a job is created, if set to 'Never', a regular pod is created. For the latter two --replicas must be 1.  Default 'Always', for CronJobs `Never`.\x00The type of secret to create\x00Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is 'ClusterIP'.\x00Undo a previous rollout\x00Unsets an individual value in a kubeconfig file\x00Update field(s) of a resource using strategic merge patch\x00Update image of a pod template\x00Update resource requests/limits on objects with pod templates\x00Update the annotations on a resource\x00Update the labels on a resource\x00Update the taints on one or more nodes\x00Username for Docker registry authentication\x00View latest last-applied-configuration annotations of a resource/object\x00View rollout history\x00Where to output the files.  If empty or '-' uses stdout, otherwise creates a directory hierarchy in that directory\x00dummy restart flag)\x00external name of service\x00kubectl controls the Kubernetes cluster manager\x00")

func translationsKubectlEn_usLc_messagesK8sMoBytes() ([]byte, error) {
	return _translationsKubectlEn_usLc_messagesK8sMo, nil
}

func translationsKubectlEn_usLc_messagesK8sMo() (*asset, error) {
	bytes, err := translationsKubectlEn_usLc_messagesK8sMoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/en_US/LC_MESSAGES/k8s.mo", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlEn_usLc_messagesK8sPo = []byte(`# Test translations for unit tests.
# Copyright (C) 2016
# This file is distributed under the same license as the PACKAGE package.
# FIRST AUTHOR brendan.d.burns@gmail.com, 2016.
#
msgid ""
msgstr ""
"Project-Id-Version: gettext-go-examples-hello\n"
"Report-Msgid-Bugs-To: EMAIL\n"
"POT-Creation-Date: 2017-03-14 21:32-0700\n"
"PO-Revision-Date: 2017-03-14 21:33-0800\n"
"Last-Translator: Brendan Burns <brendan.d.burns@gmail.com>\n"
"Language-Team: \n"
"Language: en\n"
"MIME-Version: 1.0\n"
"Content-Type: text/plain; charset=UTF-8\n"
"Content-Transfer-Encoding: 8bit\n"
"X-Generator: Poedit 1.6.10\n"
"X-Poedit-SourceCharset: UTF-8\n"
"Plural-Forms: nplurals=2; plural=(n != 1);\n"

#: pkg/kubectl/cmd/create_clusterrolebinding.go:35
msgid ""
"\n"
"\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the "
"cluster-admin ClusterRole\n"
"\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-"
"admin --user=user1 --user=user2 --group=group1"
msgstr ""
"\n"
"\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the "
"cluster-admin ClusterRole\n"
"\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-"
"admin --user=user1 --user=user2 --group=group1"

#: pkg/kubectl/cmd/create_rolebinding.go:35
msgid ""
"\n"
"\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin "
"ClusterRole\n"
"\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --"
"user=user2 --group=group1"
msgstr ""
"\n"
"\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin "
"ClusterRole\n"
"\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --"
"user=user2 --group=group1"

#: pkg/kubectl/cmd/create_configmap.go:44
msgid ""
"\n"
"\t\t  # Create a new configmap named my-config based on folder bar\n"
"\t\t  kubectl create configmap my-config --from-file=path/to/bar\n"
"\n"
"\t\t  # Create a new configmap named my-config with specified keys instead "
"of file basenames on disk\n"
"\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1."
"txt --from-file=key2=/path/to/bar/file2.txt\n"
"\n"
"\t\t  # Create a new configmap named my-config with key1=config1 and "
"key2=config2\n"
"\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-"
"literal=key2=config2"
msgstr ""
"\n"
"\t\t  # Create a new configmap named my-config based on folder bar\n"
"\t\t  kubectl create configmap my-config --from-file=path/to/bar\n"
"\n"
"\t\t  # Create a new configmap named my-config with specified keys instead "
"of file basenames on disk\n"
"\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1."
"txt --from-file=key2=/path/to/bar/file2.txt\n"
"\n"
"\t\t  # Create a new configmap named my-config with key1=config1 and "
"key2=config2\n"
"\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-"
"literal=key2=config2"

#: pkg/kubectl/cmd/create_secret.go:135
msgid ""
"\n"
"\t\t  # If you don't already have a .dockercfg file, you can create a "
"dockercfg secret directly by using:\n"
"\t\t  kubectl create secret docker-registry my-secret --docker-"
"server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-"
"password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL"
msgstr ""
"\n"
"\t\t  # If you don't already have a .dockercfg file, you can create a "
"dockercfg secret directly by using:\n"
"\t\t  kubectl create secret docker-registry my-secret --docker-"
"server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-"
"password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL"

#: pkg/kubectl/cmd/top_node.go:65
msgid ""
"\n"
"\t\t  # Show metrics for all nodes\n"
"\t\t  kubectl top node\n"
"\n"
"\t\t  # Show metrics for a given node\n"
"\t\t  kubectl top node NODE_NAME"
msgstr ""
"\n"
"\t\t  # Show metrics for all nodes\n"
"\t\t  kubectl top node\n"
"\n"
"\t\t  # Show metrics for a given node\n"
"\t\t  kubectl top node NODE_NAME"

#: pkg/kubectl/cmd/apply.go:84
msgid ""
"\n"
"\t\t# Apply the configuration in pod.json to a pod.\n"
"\t\tkubectl apply -f ./pod.json\n"
"\n"
"\t\t# Apply the JSON passed into stdin to a pod.\n"
"\t\tcat pod.json | kubectl apply -f -\n"
"\n"
"\t\t# Note: --prune is still in Alpha\n"
"\t\t# Apply the configuration in manifest.yaml that matches label app=nginx "
"and delete all the other resources that are not in the file and match label "
"app=nginx.\n"
"\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n"
"\n"
"\t\t# Apply the configuration in manifest.yaml and delete all the other "
"configmaps that are not in the file.\n"
"\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/"
"ConfigMap"
msgstr ""
"\n"
"\t\t# Apply the configuration in pod.json to a pod.\n"
"\t\tkubectl apply -f ./pod.json\n"
"\n"
"\t\t# Apply the JSON passed into stdin to a pod.\n"
"\t\tcat pod.json | kubectl apply -f -\n"
"\n"
"\t\t# Note: --prune is still in Alpha\n"
"\t\t# Apply the configuration in manifest.yaml that matches label app=nginx "
"and delete all the other resources that are not in the file and match label "
"app=nginx.\n"
"\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n"
"\n"
"\t\t# Apply the configuration in manifest.yaml and delete all the other "
"configmaps that are not in the file.\n"
"\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/"
"ConfigMap"

#: pkg/kubectl/cmd/autoscale.go:40
#, c-format
msgid ""
"\n"
"\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and "
"10, target CPU utilization specified so a default autoscaling policy will be "
"used:\n"
"\t\tkubectl autoscale deployment foo --min=2 --max=10\n"
"\n"
"\t\t# Auto scale a replication controller \"foo\", with the number of pods "
"between 1 and 5, target CPU utilization at 80%:\n"
"\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80"
msgstr ""
"\n"
"\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and "
"10, target CPU utilization specified so a default autoscaling policy will be "
"used:\n"
"\t\tkubectl autoscale deployment foo --min=2 --max=10\n"
"\n"
"\t\t# Auto scale a replication controller \"foo\", with the number of pods "
"between 1 and 5, target CPU utilization at 80%:\n"
"\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80"

#: pkg/kubectl/cmd/convert.go:49
msgid ""
"\n"
"\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n"
"\t\tkubectl convert -f pod.yaml\n"
"\n"
"\t\t# Convert the live state of the resource specified by 'pod.yaml' to the "
"latest version\n"
"\t\t# and print to stdout in json format.\n"
"\t\tkubectl convert -f pod.yaml --local -o json\n"
"\n"
"\t\t# Convert all files under current directory to latest version and create "
"them all.\n"
"\t\tkubectl convert -f . | kubectl create -f -"
msgstr ""
"\n"
"\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n"
"\t\tkubectl convert -f pod.yaml\n"
"\n"
"\t\t# Convert the live state of the resource specified by 'pod.yaml' to the "
"latest version\n"
"\t\t# and print to stdout in json format.\n"
"\t\tkubectl convert -f pod.yaml --local -o json\n"
"\n"
"\t\t# Convert all files under current directory to latest version and create "
"them all.\n"
"\t\tkubectl convert -f . | kubectl create -f -"

#: pkg/kubectl/cmd/create_clusterrole.go:34
msgid ""
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform "
"\"get\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods\n"
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods --resource-name=readablepod"
msgstr ""
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform "
"\"get\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods\n"
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods --resource-name=readablepod"

#: pkg/kubectl/cmd/create_role.go:41
msgid ""
"\n"
"\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get"
"\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --"
"resource=pods\n"
"\n"
"\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --"
"resource=pods --resource-name=readablepod"
msgstr ""
"\n"
"\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get"
"\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --"
"resource=pods\n"
"\n"
"\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --"
"resource=pods --resource-name=readablepod"

#: pkg/kubectl/cmd/create_quota.go:35
msgid ""
"\n"
"\t\t# Create a new resourcequota named my-quota\n"
"\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,"
"replicationcontrollers=2,resourcequotas=1,secrets=5,"
"persistentvolumeclaims=10\n"
"\n"
"\t\t# Create a new resourcequota named best-effort\n"
"\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort"
msgstr ""
"\n"
"\t\t# Create a new resourcequota named my-quota\n"
"\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,"
"replicationcontrollers=2,resourcequotas=1,secrets=5,"
"persistentvolumeclaims=10\n"
"\n"
"\t\t# Create a new resourcequota named best-effort\n"
"\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort"

#: pkg/kubectl/cmd/create_pdb.go:35
#, c-format
msgid ""
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=rails label\n"
"\t\t# and require at least one of them being available at any point in "
"time.\n"
"\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-"
"available=1\n"
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=nginx label\n"
"\t\t# and require at least half of the pods selected to be available at any "
"point in time.\n"
"\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%"
msgstr ""
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=rails label\n"
"\t\t# and require at least one of them being available at any point in "
"time.\n"
"\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-"
"available=1\n"
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=nginx label\n"
"\t\t# and require at least half of the pods selected to be available at any "
"point in time.\n"
"\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%"

#: pkg/kubectl/cmd/create.go:47
msgid ""
"\n"
"\t\t# Create a pod using the data in pod.json.\n"
"\t\tkubectl create -f ./pod.json\n"
"\n"
"\t\t# Create a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl create -f -\n"
"\n"
"\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format "
"then create the resource using the edited data.\n"
"\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json"
msgstr ""
"\n"
"\t\t# Create a pod using the data in pod.json.\n"
"\t\tkubectl create -f ./pod.json\n"
"\n"
"\t\t# Create a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl create -f -\n"
"\n"
"\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format "
"then create the resource using the edited data.\n"
"\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json"

#: pkg/kubectl/cmd/expose.go:53
msgid ""
"\n"
"\t\t# Create a service for a replicated nginx, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose rc nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a replication controller identified by type and "
"name specified in \"nginx-controller.yaml\", which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a pod valid-pod, which serves on port 444 with "
"the name \"frontend\"\n"
"\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n"
"\n"
"\t\t# Create a second service based on the above service, exposing the "
"container port 8443 as port 443 with the name \"nginx-https\"\n"
"\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-"
"https\n"
"\n"
"\t\t# Create a service for a replicated streaming application on port 4100 "
"balancing UDP traffic and named 'video-stream'.\n"
"\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-"
"stream\n"
"\n"
"\t\t# Create a service for a replicated nginx using replica set, which "
"serves on port 80 and connects to the containers on port 8000.\n"
"\t\tkubectl expose rs nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for an nginx deployment, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose deployment nginx --port=80 --target-port=8000"
msgstr ""
"\n"
"\t\t# Create a service for a replicated nginx, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose rc nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a replication controller identified by type and "
"name specified in \"nginx-controller.yaml\", which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a pod valid-pod, which serves on port 444 with "
"the name \"frontend\"\n"
"\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n"
"\n"
"\t\t# Create a second service based on the above service, exposing the "
"container port 8443 as port 443 with the name \"nginx-https\"\n"
"\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-"
"https\n"
"\n"
"\t\t# Create a service for a replicated streaming application on port 4100 "
"balancing UDP traffic and named 'video-stream'.\n"
"\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-"
"stream\n"
"\n"
"\t\t# Create a service for a replicated nginx using replica set, which "
"serves on port 80 and connects to the containers on port 8000.\n"
"\t\tkubectl expose rs nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for an nginx deployment, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose deployment nginx --port=80 --target-port=8000"

#: pkg/kubectl/cmd/delete.go:68
msgid ""
"\n"
"\t\t# Delete a pod using the type and name specified in pod.json.\n"
"\t\tkubectl delete -f ./pod.json\n"
"\n"
"\t\t# Delete a pod based on the type and name in the JSON passed into "
"stdin.\n"
"\t\tcat pod.json | kubectl delete -f -\n"
"\n"
"\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n"
"\t\tkubectl delete pod,service baz foo\n"
"\n"
"\t\t# Delete pods and services with label name=myLabel.\n"
"\t\tkubectl delete pods,services -l name=myLabel\n"
"\n"
"\t\t# Delete a pod with minimal delay\n"
"\t\tkubectl delete pod foo --now\n"
"\n"
"\t\t# Force delete a pod on a dead node\n"
"\t\tkubectl delete pod foo --grace-period=0 --force\n"
"\n"
"\t\t# Delete all pods\n"
"\t\tkubectl delete pods --all"
msgstr ""
"\n"
"\t\t# Delete a pod using the type and name specified in pod.json.\n"
"\t\tkubectl delete -f ./pod.json\n"
"\n"
"\t\t# Delete a pod based on the type and name in the JSON passed into "
"stdin.\n"
"\t\tcat pod.json | kubectl delete -f -\n"
"\n"
"\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n"
"\t\tkubectl delete pod,service baz foo\n"
"\n"
"\t\t# Delete pods and services with label name=myLabel.\n"
"\t\tkubectl delete pods,services -l name=myLabel\n"
"\n"
"\t\t# Delete a pod with minimal delay\n"
"\t\tkubectl delete pod foo --now\n"
"\n"
"\t\t# Force delete a pod on a dead node\n"
"\t\tkubectl delete pod foo --grace-period=0 --force\n"
"\n"
"\t\t# Delete all pods\n"
"\t\tkubectl delete pods --all"

#: pkg/kubectl/cmd/describe.go:54
msgid ""
"\n"
"\t\t# Describe a node\n"
"\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n"
"\n"
"\t\t# Describe a pod\n"
"\t\tkubectl describe pods/nginx\n"
"\n"
"\t\t# Describe a pod identified by type and name in \"pod.json\"\n"
"\t\tkubectl describe -f pod.json\n"
"\n"
"\t\t# Describe all pods\n"
"\t\tkubectl describe pods\n"
"\n"
"\t\t# Describe pods by label name=myLabel\n"
"\t\tkubectl describe po -l name=myLabel\n"
"\n"
"\t\t# Describe all pods managed by the 'frontend' replication controller (rc-"
"created pods\n"
"\t\t# get the name of the rc as a prefix in the pod the name).\n"
"\t\tkubectl describe pods frontend"
msgstr ""
"\n"
"\t\t# Describe a node\n"
"\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n"
"\n"
"\t\t# Describe a pod\n"
"\t\tkubectl describe pods/nginx\n"
"\n"
"\t\t# Describe a pod identified by type and name in \"pod.json\"\n"
"\t\tkubectl describe -f pod.json\n"
"\n"
"\t\t# Describe all pods\n"
"\t\tkubectl describe pods\n"
"\n"
"\t\t# Describe pods by label name=myLabel\n"
"\t\tkubectl describe po -l name=myLabel\n"
"\n"
"\t\t# Describe all pods managed by the 'frontend' replication controller (rc-"
"created pods\n"
"\t\t# get the name of the rc as a prefix in the pod the name).\n"
"\t\tkubectl describe pods frontend"

#: pkg/kubectl/cmd/drain.go:165
msgid ""
"\n"
"\t\t# Drain node \"foo\", even if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n"
"\t\t$ kubectl drain foo --force\n"
"\n"
"\t\t# As above, but abort if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a "
"grace period of 15 minutes.\n"
"\t\t$ kubectl drain foo --grace-period=900"
msgstr ""
"\n"
"\t\t# Drain node \"foo\", even if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n"
"\t\t$ kubectl drain foo --force\n"
"\n"
"\t\t# As above, but abort if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a "
"grace period of 15 minutes.\n"
"\t\t$ kubectl drain foo --grace-period=900"

#: pkg/kubectl/cmd/edit.go:80
msgid ""
"\n"
"\t\t# Edit the service named 'docker-registry':\n"
"\t\tkubectl edit svc/docker-registry\n"
"\n"
"\t\t# Use an alternative editor\n"
"\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n"
"\n"
"\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n"
"\t\tkubectl edit job.v1.batch/myjob -o json\n"
"\n"
"\t\t# Edit the deployment 'mydeployment' in YAML and save the modified "
"config in its annotation:\n"
"\t\tkubectl edit deployment/mydeployment -o yaml --save-config"
msgstr ""
"\n"
"\t\t# Edit the service named 'docker-registry':\n"
"\t\tkubectl edit svc/docker-registry\n"
"\n"
"\t\t# Use an alternative editor\n"
"\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n"
"\n"
"\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n"
"\t\tkubectl edit job.v1.batch/myjob -o json\n"
"\n"
"\t\t# Edit the deployment 'mydeployment' in YAML and save the modified "
"config in its annotation:\n"
"\t\tkubectl edit deployment/mydeployment -o yaml --save-config"

#: pkg/kubectl/cmd/exec.go:41
msgid ""
"\n"
"\t\t# Get output from running 'date' from pod 123456-7890, using the first "
"container by default\n"
"\t\tkubectl exec 123456-7890 date\n"
"\n"
"\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n"
"\t\tkubectl exec 123456-7890 -c ruby-container date\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il"
msgstr ""
"\n"
"\t\t# Get output from running 'date' from pod 123456-7890, using the first "
"container by default\n"
"\t\tkubectl exec 123456-7890 date\n"
"\n"
"\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n"
"\t\tkubectl exec 123456-7890 -c ruby-container date\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il"

#: pkg/kubectl/cmd/attach.go:42
msgid ""
"\n"
"\t\t# Get output from running pod 123456-7890, using the first container by "
"default\n"
"\t\tkubectl attach 123456-7890\n"
"\n"
"\t\t# Get output from ruby-container from pod 123456-7890\n"
"\t\tkubectl attach 123456-7890 -c ruby-container\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n"
"\n"
"\t\t# Get output from the first pod of a ReplicaSet named nginx\n"
"\t\tkubectl attach rs/nginx\n"
"\t\t"
msgstr ""
"\n"
"\t\t# Get output from running pod 123456-7890, using the first container by "
"default\n"
"\t\tkubectl attach 123456-7890\n"
"\n"
"\t\t# Get output from ruby-container from pod 123456-7890\n"
"\t\tkubectl attach 123456-7890 -c ruby-container\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n"
"\n"
"\t\t# Get output from the first pod of a ReplicaSet named nginx\n"
"\t\tkubectl attach rs/nginx\n"
"\t\t"

#: pkg/kubectl/cmd/explain.go:39
msgid ""
"\n"
"\t\t# Get the documentation of the resource and its fields\n"
"\t\tkubectl explain pods\n"
"\n"
"\t\t# Get the documentation of a specific field of a resource\n"
"\t\tkubectl explain pods.spec.containers"
msgstr ""
"\n"
"\t\t# Get the documentation of the resource and its fields\n"
"\t\tkubectl explain pods\n"
"\n"
"\t\t# Get the documentation of a specific field of a resource\n"
"\t\tkubectl explain pods.spec.containers"

#: pkg/kubectl/cmd/completion.go:65
msgid ""
"\n"
"\t\t# Install bash completion on a Mac using homebrew\n"
"\t\tbrew install bash-completion\n"
"\t\tprintf \"\n"
"# Bash completion support\n"
"source $(brew --prefix)/etc/bash_completion\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for bash into the current shell\n"
"\t\tsource <(kubectl completion bash)\n"
"\n"
"\t\t# Write bash completion code to a file and source if from .bash_profile\n"
"\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n"
"\t\tprintf \"\n"
"# Kubectl shell completion\n"
"source '$HOME/.kube/completion.bash.inc'\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for zsh[1] into the current shell\n"
"\t\tsource <(kubectl completion zsh)"
msgstr ""
"\n"
"\t\t# Install bash completion on a Mac using homebrew\n"
"\t\tbrew install bash-completion\n"
"\t\tprintf \"\n"
"# Bash completion support\n"
"source $(brew --prefix)/etc/bash_completion\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for bash into the current shell\n"
"\t\tsource <(kubectl completion bash)\n"
"\n"
"\t\t# Write bash completion code to a file and source if from .bash_profile\n"
"\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n"
"\t\tprintf \"\n"
"# Kubectl shell completion\n"
"source '$HOME/.kube/completion.bash.inc'\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for zsh[1] into the current shell\n"
"\t\tsource <(kubectl completion zsh)"

#: pkg/kubectl/cmd/get.go:64
msgid ""
"\n"
"\t\t# List all pods in ps output format.\n"
"\t\tkubectl get pods\n"
"\n"
"\t\t# List all pods in ps output format with more information (such as node "
"name).\n"
"\t\tkubectl get pods -o wide\n"
"\n"
"\t\t# List a single replication controller with specified NAME in ps output "
"format.\n"
"\t\tkubectl get replicationcontroller web\n"
"\n"
"\t\t# List a single pod in JSON output format.\n"
"\t\tkubectl get -o json pod web-pod-13je7\n"
"\n"
"\t\t# List a pod identified by type and name specified in \"pod.yaml\" in "
"JSON output format.\n"
"\t\tkubectl get -f pod.yaml -o json\n"
"\n"
"\t\t# Return only the phase value of the specified pod.\n"
"\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n"
"\n"
"\t\t# List all replication controllers and services together in ps output "
"format.\n"
"\t\tkubectl get rc,services\n"
"\n"
"\t\t# List one or more resources by their type and names.\n"
"\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n"
"\n"
"\t\t# List all resources with different types.\n"
"\t\tkubectl get all"
msgstr ""
"\n"
"\t\t# List all pods in ps output format.\n"
"\t\tkubectl get pods\n"
"\n"
"\t\t# List all pods in ps output format with more information (such as node "
"name).\n"
"\t\tkubectl get pods -o wide\n"
"\n"
"\t\t# List a single replication controller with specified NAME in ps output "
"format.\n"
"\t\tkubectl get replicationcontroller web\n"
"\n"
"\t\t# List a single pod in JSON output format.\n"
"\t\tkubectl get -o json pod web-pod-13je7\n"
"\n"
"\t\t# List a pod identified by type and name specified in \"pod.yaml\" in "
"JSON output format.\n"
"\t\tkubectl get -f pod.yaml -o json\n"
"\n"
"\t\t# Return only the phase value of the specified pod.\n"
"\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n"
"\n"
"\t\t# List all replication controllers and services together in ps output "
"format.\n"
"\t\tkubectl get rc,services\n"
"\n"
"\t\t# List one or more resources by their type and names.\n"
"\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n"
"\n"
"\t\t# List all resources with different types.\n"
"\t\tkubectl get all"

#: pkg/kubectl/cmd/portforward.go:53
msgid ""
"\n"
"\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports "
"5000 and 6000 in the pod\n"
"\t\tkubectl port-forward mypod 5000 6000\n"
"\n"
"\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 8888:5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod :5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 0:5000"
msgstr ""
"\n"
"\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports "
"5000 and 6000 in the pod\n"
"\t\tkubectl port-forward mypod 5000 6000\n"
"\n"
"\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 8888:5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod :5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 0:5000"

#: pkg/kubectl/cmd/drain.go:118
msgid ""
"\n"
"\t\t# Mark node \"foo\" as schedulable.\n"
"\t\t$ kubectl uncordon foo"
msgstr ""
"\n"
"\t\t# Mark node \"foo\" as schedulable.\n"
"\t\t$ kubectl uncordon foo"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L102
#: pkg/kubectl/cmd/drain.go:93
msgid ""
"\n"
"\t\t# Mark node \"foo\" as unschedulable.\n"
"\t\tkubectl cordon foo"
msgstr ""
"\n"
"\t\t# Mark node \"foo\" as unschedulable.\n"
"\t\tkubectl cordon foo"

#: pkg/kubectl/cmd/patch.go:66
msgid ""
"\n"
"\t\t# Partially update a node using strategic merge patch\n"
"\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Partially update a node identified by the type and name specified in "
"\"node.json\" using strategic merge patch\n"
"\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Update a container's image; spec.containers[*].name is required "
"because it's a merge key\n"
"\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":"
"\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n"
"\n"
"\t\t# Update a container's image using a json patch with positional arrays\n"
"\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", "
"\"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'"
msgstr ""
"\n"
"\t\t# Partially update a node using strategic merge patch\n"
"\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Partially update a node identified by the type and name specified in "
"\"node.json\" using strategic merge patch\n"
"\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Update a container's image; spec.containers[*].name is required "
"because it's a merge key\n"
"\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":"
"\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n"
"\n"
"\t\t# Update a container's image using a json patch with positional arrays\n"
"\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", "
"\"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/options.go#L37
#: pkg/kubectl/cmd/options.go:29
msgid ""
"\n"
"\t\t# Print flags inherited by all commands\n"
"\t\tkubectl options"
msgstr ""
"\n"
"\t\t# Print flags inherited by all commands\n"
"\t\tkubectl options"

#: pkg/kubectl/cmd/clusterinfo.go:41
msgid ""
"\n"
"\t\t# Print the address of the master and cluster services\n"
"\t\tkubectl cluster-info"
msgstr ""
"\n"
"\t\t# Print the address of the master and cluster services\n"
"\t\tkubectl cluster-info"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/version.go#L39
#: pkg/kubectl/cmd/version.go:32
msgid ""
"\n"
"\t\t# Print the client and server versions for the current context\n"
"\t\tkubectl version"
msgstr ""
"\n"
"\t\t# Print the client and server versions for the current context\n"
"\t\tkubectl version"

#: pkg/kubectl/cmd/apiversions.go:34
msgid ""
"\n"
"\t\t# Print the supported API versions\n"
"\t\tkubectl api-versions"
msgstr ""
"\n"
"\t\t# Print the supported API versions\n"
"\t\tkubectl api-versions"

#: pkg/kubectl/cmd/replace.go:50
msgid ""
"\n"
"\t\t# Replace a pod using the data in pod.json.\n"
"\t\tkubectl replace -f ./pod.json\n"
"\n"
"\t\t# Replace a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl replace -f -\n"
"\n"
"\t\t# Update a single-container pod's image version (tag) to v4\n"
"\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/:v4/' | "
"kubectl replace -f -\n"
"\n"
"\t\t# Force replace, delete and then re-create the resource\n"
"\t\tkubectl replace --force -f ./pod.json"
msgstr ""
"\n"
"\t\t# Replace a pod using the data in pod.json.\n"
"\t\tkubectl replace -f ./pod.json\n"
"\n"
"\t\t# Replace a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl replace -f -\n"
"\n"
"\t\t# Update a single-container pod's image version (tag) to v4\n"
"\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/:v4/' | "
"kubectl replace -f -\n"
"\n"
"\t\t# Force replace, delete and then re-create the resource\n"
"\t\tkubectl replace --force -f ./pod.json"

#: pkg/kubectl/cmd/logs.go:40
msgid ""
"\n"
"\t\t# Return snapshot logs from pod nginx with only one container\n"
"\t\tkubectl logs nginx\n"
"\n"
"\t\t# Return snapshot logs for the pods defined by label app=nginx\n"
"\t\tkubectl logs -lapp=nginx\n"
"\n"
"\t\t# Return snapshot of previous terminated ruby container logs from pod "
"web-1\n"
"\t\tkubectl logs -p -c ruby web-1\n"
"\n"
"\t\t# Begin streaming the logs of the ruby container in pod web-1\n"
"\t\tkubectl logs -f -c ruby web-1\n"
"\n"
"\t\t# Display only the most recent 20 lines of output in pod nginx\n"
"\t\tkubectl logs --tail=20 nginx\n"
"\n"
"\t\t# Show all logs from pod nginx written in the last hour\n"
"\t\tkubectl logs --since=1h nginx\n"
"\n"
"\t\t# Return snapshot logs from first container of a job named hello\n"
"\t\tkubectl logs job/hello\n"
"\n"
"\t\t# Return snapshot logs from container nginx-1 of a deployment named "
"nginx\n"
"\t\tkubectl logs deployment/nginx -c nginx-1"
msgstr ""
"\n"
"\t\t# Return snapshot logs from pod nginx with only one container\n"
"\t\tkubectl logs nginx\n"
"\n"
"\t\t# Return snapshot logs for the pods defined by label app=nginx\n"
"\t\tkubectl logs -lapp=nginx\n"
"\n"
"\t\t# Return snapshot of previous terminated ruby container logs from pod "
"web-1\n"
"\t\tkubectl logs -p -c ruby web-1\n"
"\n"
"\t\t# Begin streaming the logs of the ruby container in pod web-1\n"
"\t\tkubectl logs -f -c ruby web-1\n"
"\n"
"\t\t# Display only the most recent 20 lines of output in pod nginx\n"
"\t\tkubectl logs --tail=20 nginx\n"
"\n"
"\t\t# Show all logs from pod nginx written in the last hour\n"
"\t\tkubectl logs --since=1h nginx\n"
"\n"
"\t\t# Return snapshot logs from first container of a job named hello\n"
"\t\tkubectl logs job/hello\n"
"\n"
"\t\t# Return snapshot logs from container nginx-1 of a deployment named "
"nginx\n"
"\t\tkubectl logs deployment/nginx -c nginx-1"

#: pkg/kubectl/cmd/proxy.go:53
msgid ""
"\n"
"\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static "
"content from ./local/www/\n"
"\t\tkubectl proxy --port=8011 --www=./local/www/\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n"
"\t\t# The chosen port for the server will be output to stdout.\n"
"\t\tkubectl proxy --port=0\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-"
"api\n"
"\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/"
"pods/\n"
"\t\tkubectl proxy --api-prefix=/k8s-api"
msgstr ""
"\n"
"\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static "
"content from ./local/www/\n"
"\t\tkubectl proxy --port=8011 --www=./local/www/\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n"
"\t\t# The chosen port for the server will be output to stdout.\n"
"\t\tkubectl proxy --port=0\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-"
"api\n"
"\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/"
"pods/\n"
"\t\tkubectl proxy --api-prefix=/k8s-api"

#: pkg/kubectl/cmd/scale.go:43
msgid ""
"\n"
"\t\t# Scale a replicaset named 'foo' to 3.\n"
"\t\tkubectl scale --replicas=3 rs/foo\n"
"\n"
"\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" "
"to 3.\n"
"\t\tkubectl scale --replicas=3 -f foo.yaml\n"
"\n"
"\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n"
"\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n"
"\n"
"\t\t# Scale multiple replication controllers.\n"
"\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n"
"\n"
"\t\t# Scale job named 'cron' to 3.\n"
"\t\tkubectl scale --replicas=3 job/cron"
msgstr ""
"\n"
"\t\t# Scale a replicaset named 'foo' to 3.\n"
"\t\tkubectl scale --replicas=3 rs/foo\n"
"\n"
"\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" "
"to 3.\n"
"\t\tkubectl scale --replicas=3 -f foo.yaml\n"
"\n"
"\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n"
"\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n"
"\n"
"\t\t# Scale multiple replication controllers.\n"
"\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n"
"\n"
"\t\t# Scale job named 'cron' to 3.\n"
"\t\tkubectl scale --replicas=3 job/cron"

#: pkg/kubectl/cmd/apply_set_last_applied.go:67
msgid ""
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml\n"
"\n"
"\t\t# Execute set-last-applied against each configuration file in a "
"directory.\n"
"\t\tkubectl apply set-last-applied -f path/\n"
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file, will create the annotation if it does not already exist.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n"
"\t\t"
msgstr ""
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml\n"
"\n"
"\t\t# Execute set-last-applied against each configuration file in a "
"directory.\n"
"\t\tkubectl apply set-last-applied -f path/\n"
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file, will create the annotation if it does not already exist.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n"
"\t\t"

#: pkg/kubectl/cmd/top_pod.go:61
msgid ""
"\n"
"\t\t# Show metrics for all pods in the default namespace\n"
"\t\tkubectl top pod\n"
"\n"
"\t\t# Show metrics for all pods in the given namespace\n"
"\t\tkubectl top pod --namespace=NAMESPACE\n"
"\n"
"\t\t# Show metrics for a given pod and its containers\n"
"\t\tkubectl top pod POD_NAME --containers\n"
"\n"
"\t\t# Show metrics for the pods defined by label name=myLabel\n"
"\t\tkubectl top pod -l name=myLabel"
msgstr ""
"\n"
"\t\t# Show metrics for all pods in the default namespace\n"
"\t\tkubectl top pod\n"
"\n"
"\t\t# Show metrics for all pods in the given namespace\n"
"\t\tkubectl top pod --namespace=NAMESPACE\n"
"\n"
"\t\t# Show metrics for a given pod and its containers\n"
"\t\tkubectl top pod POD_NAME --containers\n"
"\n"
"\t\t# Show metrics for the pods defined by label name=myLabel\n"
"\t\tkubectl top pod -l name=myLabel"

#: pkg/kubectl/cmd/stop.go:40
msgid ""
"\n"
"\t\t# Shut down foo.\n"
"\t\tkubectl stop replicationcontroller foo\n"
"\n"
"\t\t# Stop pods and services with label name=myLabel.\n"
"\t\tkubectl stop pods,services -l name=myLabel\n"
"\n"
"\t\t# Shut down the service defined in service.json\n"
"\t\tkubectl stop -f service.json\n"
"\n"
"\t\t# Shut down all resources in the path/to/resources directory\n"
"\t\tkubectl stop -f path/to/resources"
msgstr ""
"\n"
"\t\t# Shut down foo.\n"
"\t\tkubectl stop replicationcontroller foo\n"
"\n"
"\t\t# Stop pods and services with label name=myLabel.\n"
"\t\tkubectl stop pods,services -l name=myLabel\n"
"\n"
"\t\t# Shut down the service defined in service.json\n"
"\t\tkubectl stop -f service.json\n"
"\n"
"\t\t# Shut down all resources in the path/to/resources directory\n"
"\t\tkubectl stop -f path/to/resources"

#: pkg/kubectl/cmd/run.go:57
msgid ""
"\n"
"\t\t# Start a single instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx\n"
"\n"
"\t\t# Start a single instance of hazelcast and let the container expose port "
"5701 .\n"
"\t\tkubectl run hazelcast --image=hazelcast --port=5701\n"
"\n"
"\t\t# Start a single instance of hazelcast and set environment variables "
"\"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n"
"\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --"
"env=\"POD_NAMESPACE=default\"\n"
"\n"
"\t\t# Start a replicated instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx --replicas=5\n"
"\n"
"\t\t# Dry run. Print the corresponding API objects without creating them.\n"
"\t\tkubectl run nginx --image=nginx --dry-run\n"
"\n"
"\t\t# Start a single instance of nginx, but overload the spec of the "
"deployment with a partial set of values parsed from JSON.\n"
"\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", "
"\"spec\": { ... } }'\n"
"\n"
"\t\t# Start a pod of busybox and keep it in the foreground, don't restart it "
"if it exits.\n"
"\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n"
"\n"
"\t\t# Start the nginx container using the default command, but use custom "
"arguments (arg1 .. argN) for that command.\n"
"\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n"
"\n"
"\t\t# Start the nginx container using a different command and custom "
"arguments.\n"
"\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n"
"\n"
"\t\t# Start the perl container to compute π to 2000 places and print it "
"out.\n"
"\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -"
"wle 'print bpi(2000)'\n"
"\n"
"\t\t# Start the cron job to compute π to 2000 places and print it out every "
"5 minutes.\n"
"\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --"
"restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'"
msgstr ""
"\n"
"\t\t# Start a single instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx\n"
"\n"
"\t\t# Start a single instance of hazelcast and let the container expose port "
"5701 .\n"
"\t\tkubectl run hazelcast --image=hazelcast --port=5701\n"
"\n"
"\t\t# Start a single instance of hazelcast and set environment variables "
"\"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n"
"\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --"
"env=\"POD_NAMESPACE=default\"\n"
"\n"
"\t\t# Start a replicated instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx --replicas=5\n"
"\n"
"\t\t# Dry run. Print the corresponding API objects without creating them.\n"
"\t\tkubectl run nginx --image=nginx --dry-run\n"
"\n"
"\t\t# Start a single instance of nginx, but overload the spec of the "
"deployment with a partial set of values parsed from JSON.\n"
"\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", "
"\"spec\": { ... } }'\n"
"\n"
"\t\t# Start a pod of busybox and keep it in the foreground, don't restart it "
"if it exits.\n"
"\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n"
"\n"
"\t\t# Start the nginx container using the default command, but use custom "
"arguments (arg1 .. argN) for that command.\n"
"\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n"
"\n"
"\t\t# Start the nginx container using a different command and custom "
"arguments.\n"
"\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n"
"\n"
"\t\t# Start the perl container to compute π to 2000 places and print it "
"out.\n"
"\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -"
"wle 'print bpi(2000)'\n"
"\n"
"\t\t# Start the cron job to compute π to 2000 places and print it out every "
"5 minutes.\n"
"\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --"
"restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'"

#: pkg/kubectl/cmd/taint.go:67
msgid ""
"\n"
"\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-"
"user' and effect 'NoSchedule'.\n"
"\t\t# If a taint with that key and effect already exists, its value is "
"replaced as specified.\n"
"\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n"
"\n"
"\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect "
"'NoSchedule' if one exists.\n"
"\t\tkubectl taint nodes foo dedicated:NoSchedule-\n"
"\n"
"\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n"
"\t\tkubectl taint nodes foo dedicated-"
msgstr ""
"\n"
"\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-"
"user' and effect 'NoSchedule'.\n"
"\t\t# If a taint with that key and effect already exists, its value is "
"replaced as specified.\n"
"\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n"
"\n"
"\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect "
"'NoSchedule' if one exists.\n"
"\t\tkubectl taint nodes foo dedicated:NoSchedule-\n"
"\n"
"\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n"
"\t\tkubectl taint nodes foo dedicated-"

#: pkg/kubectl/cmd/label.go:77
msgid ""
"\n"
"\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n"
"\t\tkubectl label pods foo unhealthy=true\n"
"\n"
"\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', "
"overwriting any existing value.\n"
"\t\tkubectl label --overwrite pods foo status=unhealthy\n"
"\n"
"\t\t# Update all pods in the namespace\n"
"\t\tkubectl label pods --all status=unhealthy\n"
"\n"
"\t\t# Update a pod identified by the type and name in \"pod.json\"\n"
"\t\tkubectl label -f pod.json status=unhealthy\n"
"\n"
"\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n"
"\t\tkubectl label pods foo status=unhealthy --resource-version=1\n"
"\n"
"\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n"
"\t\t# Does not require the --overwrite flag.\n"
"\t\tkubectl label pods foo bar-"
msgstr ""
"\n"
"\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n"
"\t\tkubectl label pods foo unhealthy=true\n"
"\n"
"\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', "
"overwriting any existing value.\n"
"\t\tkubectl label --overwrite pods foo status=unhealthy\n"
"\n"
"\t\t# Update all pods in the namespace\n"
"\t\tkubectl label pods --all status=unhealthy\n"
"\n"
"\t\t# Update a pod identified by the type and name in \"pod.json\"\n"
"\t\tkubectl label -f pod.json status=unhealthy\n"
"\n"
"\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n"
"\t\tkubectl label pods foo status=unhealthy --resource-version=1\n"
"\n"
"\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n"
"\t\t# Does not require the --overwrite flag.\n"
"\t\tkubectl label pods foo bar-"

#: pkg/kubectl/cmd/rollingupdate.go:54
msgid ""
"\n"
"\t\t# Update pods of frontend-v1 using new replication controller data in "
"frontend-v2.json.\n"
"\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n"
"\n"
"\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n"
"\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n"
"\n"
"\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the "
"image, and switching the\n"
"\t\t# name of the replication controller.\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n"
"\n"
"\t\t# Update the pods of frontend by just changing the image, and keeping "
"the old name.\n"
"\t\tkubectl rolling-update frontend --image=image:v2\n"
"\n"
"\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to "
"frontend-v2).\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback"
msgstr ""
"\n"
"\t\t# Update pods of frontend-v1 using new replication controller data in "
"frontend-v2.json.\n"
"\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n"
"\n"
"\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n"
"\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n"
"\n"
"\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the "
"image, and switching the\n"
"\t\t# name of the replication controller.\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n"
"\n"
"\t\t# Update the pods of frontend by just changing the image, and keeping "
"the old name.\n"
"\t\tkubectl rolling-update frontend --image=image:v2\n"
"\n"
"\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to "
"frontend-v2).\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback"

#: pkg/kubectl/cmd/apply_view_last_applied.go:52
msgid ""
"\n"
"\t\t# View the last-applied-configuration annotations by type/name in YAML.\n"
"\t\tkubectl apply view-last-applied deployment/nginx\n"
"\n"
"\t\t# View the last-applied-configuration annotations by file in JSON\n"
"\t\tkubectl apply view-last-applied -f deploy.yaml -o json"
msgstr ""
"\n"
"\t\t# View the last-applied-configuration annotations by type/name in YAML.\n"
"\t\tkubectl apply view-last-applied deployment/nginx\n"
"\n"
"\t\t# View the last-applied-configuration annotations by file in JSON\n"
"\t\tkubectl apply view-last-applied -f deploy.yaml -o json"

#: pkg/kubectl/cmd/apply.go:75
msgid ""
"\n"
"\t\tApply a configuration to a resource by filename or stdin.\n"
"\t\tThis resource will be created if it doesn't exist yet.\n"
"\t\tTo use 'apply', always create the resource initially with either 'apply' "
"or 'create --save-config'.\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not "
"use unless you are aware of what the current state is. See https://issues."
"k8s.io/34274."
msgstr ""
"\n"
"\t\tApply a configuration to a resource by filename or stdin.\n"
"\t\tThis resource will be created if it doesn't exist yet.\n"
"\t\tTo use 'apply', always create the resource initially with either 'apply' "
"or 'create --save-config'.\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not "
"use unless you are aware of what the current state is. See https://issues."
"k8s.io/34274."

#: pkg/kubectl/cmd/convert.go:38
msgid ""
"\n"
"\t\tConvert config files between different API versions. Both YAML\n"
"\t\tand JSON formats are accepted.\n"
"\n"
"\t\tThe command takes filename, directory, or URL as input, and convert it "
"into format\n"
"\t\tof version specified by --output-version flag. If target version is not "
"specified or\n"
"\t\tnot supported, convert to latest version.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change to output destination."
msgstr ""
"\n"
"\t\tConvert config files between different API versions. Both YAML\n"
"\t\tand JSON formats are accepted.\n"
"\n"
"\t\tThe command takes filename, directory, or URL as input, and convert it "
"into format\n"
"\t\tof version specified by --output-version flag. If target version is not "
"specified or\n"
"\t\tnot supported, convert to latest version.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change to output destination."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L68
#: pkg/kubectl/cmd/create_clusterrole.go:31
msgid ""
"\n"
"\t\tCreate a ClusterRole."
msgstr ""
"\n"
"\t\tCreate a ClusterRole."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_clusterrolebinding.go#L43
#: pkg/kubectl/cmd/create_clusterrolebinding.go:32
msgid ""
"\n"
"\t\tCreate a ClusterRoleBinding for a particular ClusterRole."
msgstr ""
"\n"
"\t\tCreate a ClusterRoleBinding for a particular ClusterRole."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_rolebinding.go#L43
#: pkg/kubectl/cmd/create_rolebinding.go:32
msgid ""
"\n"
"\t\tCreate a RoleBinding for a particular Role or ClusterRole."
msgstr ""
"\n"
"\t\tCreate a RoleBinding for a particular Role or ClusterRole."

#: pkg/kubectl/cmd/create_secret.go:200
msgid ""
"\n"
"\t\tCreate a TLS secret from the given public/private key pair.\n"
"\n"
"\t\tThe public/private key pair must exist before hand. The public key "
"certificate must be .PEM encoded and match the given private key."
msgstr ""
"\n"
"\t\tCreate a TLS secret from the given public/private key pair.\n"
"\n"
"\t\tThe public/private key pair must exist before hand. The public key "
"certificate must be .PEM encoded and match the given private key."

#: pkg/kubectl/cmd/create_configmap.go:32
msgid ""
"\n"
"\t\tCreate a configmap based on a file, directory, or specified literal "
"value.\n"
"\n"
"\t\tA single configmap may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a configmap based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a configmap based on a directory, each file whose basename "
"is a valid key in the directory will be\n"
"\t\tpackaged into the configmap.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."
msgstr ""
"\n"
"\t\tCreate a configmap based on a file, directory, or specified literal "
"value.\n"
"\n"
"\t\tA single configmap may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a configmap based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a configmap based on a directory, each file whose basename "
"is a valid key in the directory will be\n"
"\t\tpackaged into the configmap.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_namespace.go#L44
#: pkg/kubectl/cmd/create_namespace.go:32
msgid ""
"\n"
"\t\tCreate a namespace with the specified name."
msgstr ""
"\n"
"\t\tCreate a namespace with the specified name."

#: pkg/kubectl/cmd/create_secret.go:119
msgid ""
"\n"
"\t\tCreate a new secret for use with Docker registries.\n"
"\n"
"\t\tDockercfg secrets are used to authenticate against Docker registries.\n"
"\n"
"\t\tWhen using the Docker command line to push images, you can authenticate "
"to a given registry by running\n"
"\n"
"\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --"
"password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n"
"\n"
"    That produces a ~/.dockercfg file that is used by subsequent 'docker "
"push' and 'docker pull' commands to\n"
"\t\tauthenticate to the registry. The email address is optional.\n"
"\n"
"\t\tWhen creating applications, you may have a Docker registry that requires "
"authentication.  In order for the\n"
"\t\tnodes to pull images on your behalf, they have to have the credentials.  "
"You can provide this information\n"
"\t\tby creating a dockercfg secret and attaching it to your service account."
msgstr ""
"\n"
"\t\tCreate a new secret for use with Docker registries.\n"
"\n"
"\t\tDockercfg secrets are used to authenticate against Docker registries.\n"
"\n"
"\t\tWhen using the Docker command line to push images, you can authenticate "
"to a given registry by running\n"
"\n"
"\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --"
"password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n"
"\n"
"    That produces a ~/.dockercfg file that is used by subsequent 'docker "
"push' and 'docker pull' commands to\n"
"\t\tauthenticate to the registry. The email address is optional.\n"
"\n"
"\t\tWhen creating applications, you may have a Docker registry that requires "
"authentication.  In order for the\n"
"\t\tnodes to pull images on your behalf, they have to have the credentials.  "
"You can provide this information\n"
"\t\tby creating a dockercfg secret and attaching it to your service account."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_pdb.go#L49
#: pkg/kubectl/cmd/create_pdb.go:32
msgid ""
"\n"
"\t\tCreate a pod disruption budget with the specified name, selector, and "
"desired minimum available pods"
msgstr ""
"\n"
"\t\tCreate a pod disruption budget with the specified name, selector, and "
"desired minimum available pods"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create.go#L56
#: pkg/kubectl/cmd/create.go:42
msgid ""
"\n"
"\t\tCreate a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted."
msgstr ""
"\n"
"\t\tCreate a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L47
#: pkg/kubectl/cmd/create_quota.go:32
msgid ""
"\n"
"\t\tCreate a resourcequota with the specified name, hard limits and optional "
"scopes"
msgstr ""
"\n"
"\t\tCreate a resourcequota with the specified name, hard limits and optional "
"scopes"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L47
#: pkg/kubectl/cmd/create_role.go:38
msgid ""
"\n"
"\t\tCreate a role with single rule."
msgstr ""
"\n"
"\t\tCreate a role with single rule."

#: pkg/kubectl/cmd/create_secret.go:47
msgid ""
"\n"
"\t\tCreate a secret based on a file, directory, or specified literal value.\n"
"\n"
"\t\tA single secret may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a secret based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a secret based on a directory, each file whose basename is "
"a valid key in the directory will be\n"
"\t\tpackaged into the secret.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."
msgstr ""
"\n"
"\t\tCreate a secret based on a file, directory, or specified literal value.\n"
"\n"
"\t\tA single secret may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a secret based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a secret based on a directory, each file whose basename is "
"a valid key in the directory will be\n"
"\t\tpackaged into the secret.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_serviceaccount.go#L44
#: pkg/kubectl/cmd/create_serviceaccount.go:32
msgid ""
"\n"
"\t\tCreate a service account with the specified name."
msgstr ""
"\n"
"\t\tCreate a service account with the specified name."

#: pkg/kubectl/cmd/run.go:52
msgid ""
"\n"
"\t\tCreate and run a particular image, possibly replicated.\n"
"\n"
"\t\tCreates a deployment or job to manage the created container(s)."
msgstr ""
"\n"
"\t\tCreate and run a particular image, possibly replicated.\n"
"\n"
"\t\tCreates a deployment or job to manage the created container(s)."

#: pkg/kubectl/cmd/autoscale.go:34
msgid ""
"\n"
"\t\tCreates an autoscaler that automatically chooses and sets the number of "
"pods that run in a kubernetes cluster.\n"
"\n"
"\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and "
"creates an autoscaler that uses the given resource as a reference.\n"
"\t\tAn autoscaler can automatically increase or decrease number of pods "
"deployed within the system as needed."
msgstr ""
"\n"
"\t\tCreates an autoscaler that automatically chooses and sets the number of "
"pods that run in a kubernetes cluster.\n"
"\n"
"\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and "
"creates an autoscaler that uses the given resource as a reference.\n"
"\t\tAn autoscaler can automatically increase or decrease number of pods "
"deployed within the system as needed."

#: pkg/kubectl/cmd/delete.go:40
msgid ""
"\n"
"\t\tDelete resources by filenames, stdin, resources and names, or by "
"resources and label selector.\n"
"\n"
"\t\tJSON and YAML formats are accepted. Only one type of the arguments may "
"be specified: filenames,\n"
"\t\tresources and names, or resources and label selector.\n"
"\n"
"\t\tSome resources, such as pods, support graceful deletion. These resources "
"define a default period\n"
"\t\tbefore they are forcibly terminated (the grace period) but you may "
"override that value with\n"
"\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. "
"Because these resources often\n"
"\t\trepresent entities in the cluster, deletion may not be acknowledged "
"immediately. If the node\n"
"\t\thosting a pod is down or cannot reach the API server, termination may "
"take significantly longer\n"
"\t\tthan the grace period. To force delete a resource,\tyou must pass a grace"
"\tperiod of 0 and specify\n"
"\t\tthe --force flag.\n"
"\n"
"\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the "
"pod's processes have been\n"
"\t\tterminated, which can leave those processes running until the node "
"detects the deletion and\n"
"\t\tcompletes graceful deletion. If your processes use shared storage or "
"talk to a remote API and\n"
"\t\tdepend on the name of the pod to identify themselves, force deleting "
"those pods may result in\n"
"\t\tmultiple processes running on different machines using the same "
"identification which may lead\n"
"\t\tto data corruption or inconsistency. Only force delete pods when you are "
"sure the pod is\n"
"\t\tterminated, or if your application can tolerate multiple copies of the "
"same pod running at once.\n"
"\t\tAlso, if you force delete pods the scheduler may place new pods on those "
"nodes before the node\n"
"\t\thas released those resources and causing those pods to be evicted "
"immediately.\n"
"\n"
"\t\tNote that the delete command does NOT do resource version checks, so if "
"someone\n"
"\t\tsubmits an update to a resource right when you submit a delete, their "
"update\n"
"\t\twill be lost along with the rest of the resource."
msgstr ""
"\n"
"\t\tDelete resources by filenames, stdin, resources and names, or by "
"resources and label selector.\n"
"\n"
"\t\tJSON and YAML formats are accepted. Only one type of the arguments may "
"be specified: filenames,\n"
"\t\tresources and names, or resources and label selector.\n"
"\n"
"\t\tSome resources, such as pods, support graceful deletion. These resources "
"define a default period\n"
"\t\tbefore they are forcibly terminated (the grace period) but you may "
"override that value with\n"
"\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. "
"Because these resources often\n"
"\t\trepresent entities in the cluster, deletion may not be acknowledged "
"immediately. If the node\n"
"\t\thosting a pod is down or cannot reach the API server, termination may "
"take significantly longer\n"
"\t\tthan the grace period. To force delete a resource,\tyou must pass a grace"
"\tperiod of 0 and specify\n"
"\t\tthe --force flag.\n"
"\n"
"\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the "
"pod's processes have been\n"
"\t\tterminated, which can leave those processes running until the node "
"detects the deletion and\n"
"\t\tcompletes graceful deletion. If your processes use shared storage or "
"talk to a remote API and\n"
"\t\tdepend on the name of the pod to identify themselves, force deleting "
"those pods may result in\n"
"\t\tmultiple processes running on different machines using the same "
"identification which may lead\n"
"\t\tto data corruption or inconsistency. Only force delete pods when you are "
"sure the pod is\n"
"\t\tterminated, or if your application can tolerate multiple copies of the "
"same pod running at once.\n"
"\t\tAlso, if you force delete pods the scheduler may place new pods on those "
"nodes before the node\n"
"\t\thas released those resources and causing those pods to be evicted "
"immediately.\n"
"\n"
"\t\tNote that the delete command does NOT do resource version checks, so if "
"someone\n"
"\t\tsubmits an update to a resource right when you submit a delete, their "
"update\n"
"\t\twill be lost along with the rest of the resource."

#: pkg/kubectl/cmd/stop.go:31
msgid ""
"\n"
"\t\tDeprecated: Gracefully shut down a resource by name or filename.\n"
"\n"
"\t\tThe stop command is deprecated, all its functionalities are covered by "
"delete command.\n"
"\t\tSee 'kubectl delete --help' for more details.\n"
"\n"
"\t\tAttempts to shut down and delete a resource that supports graceful "
"termination.\n"
"\t\tIf the resource is scalable it will be scaled to 0 before deletion."
msgstr ""
"\n"
"\t\tDeprecated: Gracefully shut down a resource by name or filename.\n"
"\n"
"\t\tThe stop command is deprecated, all its functionalities are covered by "
"delete command.\n"
"\t\tSee 'kubectl delete --help' for more details.\n"
"\n"
"\t\tAttempts to shut down and delete a resource that supports graceful "
"termination.\n"
"\t\tIf the resource is scalable it will be scaled to 0 before deletion."

#: pkg/kubectl/cmd/top_node.go:60
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n"
"\n"
"\t\tThe top-node command allows you to see the resource consumption of nodes."
msgstr ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n"
"\n"
"\t\tThe top-node command allows you to see the resource consumption of nodes."

#: pkg/kubectl/cmd/top_pod.go:53
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n"
"\n"
"\t\tThe 'top pod' command allows you to see the resource consumption of "
"pods.\n"
"\n"
"\t\tDue to the metrics pipeline delay, they may be unavailable for a few "
"minutes\n"
"\t\tsince pod creation."
msgstr ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n"
"\n"
"\t\tThe 'top pod' command allows you to see the resource consumption of "
"pods.\n"
"\n"
"\t\tDue to the metrics pipeline delay, they may be unavailable for a few "
"minutes\n"
"\t\tsince pod creation."

#: pkg/kubectl/cmd/top.go:33
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage.\n"
"\n"
"\t\tThe top command allows you to see the resource consumption for nodes or "
"pods.\n"
"\n"
"\t\tThis command requires Heapster to be correctly configured and working on "
"the server. "
msgstr ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage.\n"
"\n"
"\t\tThe top command allows you to see the resource consumption for nodes or "
"pods.\n"
"\n"
"\t\tThis command requires Heapster to be correctly configured and working on "
"the server. "

#: pkg/kubectl/cmd/drain.go:140
msgid ""
"\n"
"\t\tDrain node in preparation for maintenance.\n"
"\n"
"\t\tThe given node will be marked unschedulable to prevent new pods from "
"arriving.\n"
"\t\t'drain' evicts the pods if the APIServer supports eviction\n"
"\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use "
"normal DELETE\n"
"\t\tto delete the pods.\n"
"\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot "
"be deleted through\n"
"\t\tthe API server).  If there are DaemonSet-managed pods, drain will not "
"proceed\n"
"\t\twithout --ignore-daemonsets, and regardless it will not delete any\n"
"\t\tDaemonSet-managed pods, because those pods would be immediately replaced "
"by the\n"
"\t\tDaemonSet controller, which ignores unschedulable markings.  If there "
"are any\n"
"\t\tpods that are neither mirror pods nor managed by ReplicationController,\n"
"\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete "
"any pods unless you\n"
"\t\tuse --force.  --force will also allow deletion to proceed if the "
"managing resource of one\n"
"\t\tor more pods is missing.\n"
"\n"
"\t\t'drain' waits for graceful termination. You should not operate on the "
"machine until\n"
"\t\tthe command completes.\n"
"\n"
"\t\tWhen you are ready to put the node back into service, use kubectl "
"uncordon, which\n"
"\t\twill make the node schedulable again.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)"
msgstr ""
"\n"
"\t\tDrain node in preparation for maintenance.\n"
"\n"
"\t\tThe given node will be marked unschedulable to prevent new pods from "
"arriving.\n"
"\t\t'drain' evicts the pods if the APIServer supports eviction\n"
"\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use "
"normal DELETE\n"
"\t\tto delete the pods.\n"
"\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot "
"be deleted through\n"
"\t\tthe API server).  If there are DaemonSet-managed pods, drain will not "
"proceed\n"
"\t\twithout --ignore-daemonsets, and regardless it will not delete any\n"
"\t\tDaemonSet-managed pods, because those pods would be immediately replaced "
"by the\n"
"\t\tDaemonSet controller, which ignores unschedulable markings.  If there "
"are any\n"
"\t\tpods that are neither mirror pods nor managed by ReplicationController,\n"
"\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete "
"any pods unless you\n"
"\t\tuse --force.  --force will also allow deletion to proceed if the "
"managing resource of one\n"
"\t\tor more pods is missing.\n"
"\n"
"\t\t'drain' waits for graceful termination. You should not operate on the "
"machine until\n"
"\t\tthe command completes.\n"
"\n"
"\t\tWhen you are ready to put the node back into service, use kubectl "
"uncordon, which\n"
"\t\twill make the node schedulable again.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)"

#: pkg/kubectl/cmd/edit.go:56
msgid ""
"\n"
"\t\tEdit a resource from the default editor.\n"
"\n"
"\t\tThe edit command allows you to directly edit any API resource you can "
"retrieve via the\n"
"\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, "
"or EDITOR\n"
"\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for "
"Windows.\n"
"\t\tYou can edit multiple objects, although changes are applied one at a "
"time. The command\n"
"\t\taccepts filenames as well as command line arguments, although the files "
"you point to must\n"
"\t\tbe previously saved versions of resources.\n"
"\n"
"\t\tEditing is done with the API version used to fetch the resource.\n"
"\t\tTo edit using a specific API version, fully-qualify the resource, "
"version, and group.\n"
"\n"
"\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n"
"\n"
"\t\tThe flag --windows-line-endings can be used to force Windows line "
"endings,\n"
"\t\totherwise the default for your operating system will be used.\n"
"\n"
"\t\tIn the event an error occurs while updating, a temporary file will be "
"created on disk\n"
"\t\tthat contains your unapplied changes. The most common error when "
"updating a resource\n"
"\t\tis another editor changing the resource on the server. When this occurs, "
"you will have\n"
"\t\tto apply your changes to the newer version of the resource, or update "
"your temporary\n"
"\t\tsaved copy to include the latest resource version."
msgstr ""
"\n"
"\t\tEdit a resource from the default editor.\n"
"\n"
"\t\tThe edit command allows you to directly edit any API resource you can "
"retrieve via the\n"
"\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, "
"or EDITOR\n"
"\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for "
"Windows.\n"
"\t\tYou can edit multiple objects, although changes are applied one at a "
"time. The command\n"
"\t\taccepts filenames as well as command line arguments, although the files "
"you point to must\n"
"\t\tbe previously saved versions of resources.\n"
"\n"
"\t\tEditing is done with the API version used to fetch the resource.\n"
"\t\tTo edit using a specific API version, fully-qualify the resource, "
"version, and group.\n"
"\n"
"\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n"
"\n"
"\t\tThe flag --windows-line-endings can be used to force Windows line "
"endings,\n"
"\t\totherwise the default for your operating system will be used.\n"
"\n"
"\t\tIn the event an error occurs while updating, a temporary file will be "
"created on disk\n"
"\t\tthat contains your unapplied changes. The most common error when "
"updating a resource\n"
"\t\tis another editor changing the resource on the server. When this occurs, "
"you will have\n"
"\t\tto apply your changes to the newer version of the resource, or update "
"your temporary\n"
"\t\tsaved copy to include the latest resource version."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L127
#: pkg/kubectl/cmd/drain.go:115
msgid ""
"\n"
"\t\tMark node as schedulable."
msgstr ""
"\n"
"\t\tMark node as schedulable."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L102
#: pkg/kubectl/cmd/drain.go:90
msgid ""
"\n"
"\t\tMark node as unschedulable."
msgstr ""
"\n"
"\t\tMark node as unschedulable."

#: pkg/kubectl/cmd/completion.go:47
msgid ""
"\n"
"\t\tOutput shell completion code for the specified shell (bash or zsh).\n"
"\t\tThe shell code must be evalutated to provide interactive\n"
"\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n"
"\t\tthe .bash_profile.\n"
"\n"
"\t\tNote: this requires the bash-completion framework, which is not "
"installed\n"
"\t\tby default on Mac.  This can be installed by using homebrew:\n"
"\n"
"\t\t    $ brew install bash-completion\n"
"\n"
"\t\tOnce installed, bash_completion must be evaluated.  This can be done by "
"adding the\n"
"\t\tfollowing line to the .bash_profile\n"
"\n"
"\t\t    $ source $(brew --prefix)/etc/bash_completion\n"
"\n"
"\t\tNote for zsh users: [1] zsh completions are only supported in versions "
"of zsh >= 5.2"
msgstr ""
"\n"
"\t\tOutput shell completion code for the specified shell (bash or zsh).\n"
"\t\tThe shell code must be evalutated to provide interactive\n"
"\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n"
"\t\tthe .bash_profile.\n"
"\n"
"\t\tNote: this requires the bash-completion framework, which is not "
"installed\n"
"\t\tby default on Mac.  This can be installed by using homebrew:\n"
"\n"
"\t\t    $ brew install bash-completion\n"
"\n"
"\t\tOnce installed, bash_completion must be evaluated.  This can be done by "
"adding the\n"
"\t\tfollowing line to the .bash_profile\n"
"\n"
"\t\t    $ source $(brew --prefix)/etc/bash_completion\n"
"\n"
"\t\tNote for zsh users: [1] zsh completions are only supported in versions "
"of zsh >= 5.2"

#: pkg/kubectl/cmd/rollingupdate.go:45
msgid ""
"\n"
"\t\tPerform a rolling update of the given ReplicationController.\n"
"\n"
"\t\tReplaces the specified replication controller with a new replication "
"controller by updating one pod at a time to use the\n"
"\t\tnew PodTemplate. The new-controller.json must specify the same namespace "
"as the\n"
"\t\texisting replication controller and overwrite at least one (common) "
"label in its replicaSelector.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)"
msgstr ""
"\n"
"\t\tPerform a rolling update of the given ReplicationController.\n"
"\n"
"\t\tReplaces the specified replication controller with a new replication "
"controller by updating one pod at a time to use the\n"
"\t\tnew PodTemplate. The new-controller.json must specify the same namespace "
"as the\n"
"\t\texisting replication controller and overwrite at least one (common) "
"label in its replicaSelector.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)"

#: pkg/kubectl/cmd/replace.go:40
msgid ""
"\n"
"\t\tReplace a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted. If replacing an existing resource, "
"the\n"
"\t\tcomplete resource spec must be provided. This can be obtained by\n"
"\n"
"\t\t    $ kubectl get TYPE NAME -o yaml\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."
msgstr ""
"\n"
"\t\tReplace a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted. If replacing an existing resource, "
"the\n"
"\t\tcomplete resource spec must be provided. This can be obtained by\n"
"\n"
"\t\t    $ kubectl get TYPE NAME -o yaml\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."

#: pkg/kubectl/cmd/scale.go:34
msgid ""
"\n"
"\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or "
"Job.\n"
"\n"
"\t\tScale also allows users to specify one or more preconditions for the "
"scale action.\n"
"\n"
"\t\tIf --current-replicas or --resource-version is specified, it is "
"validated before the\n"
"\t\tscale is attempted, and it is guaranteed that the precondition holds "
"true when the\n"
"\t\tscale is sent to the server."
msgstr ""
"\n"
"\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or "
"Job.\n"
"\n"
"\t\tScale also allows users to specify one or more preconditions for the "
"scale action.\n"
"\n"
"\t\tIf --current-replicas or --resource-version is specified, it is "
"validated before the\n"
"\t\tscale is attempted, and it is guaranteed that the precondition holds "
"true when the\n"
"\t\tscale is sent to the server."

#: pkg/kubectl/cmd/apply_set_last_applied.go:62
msgid ""
"\n"
"\t\tSet the latest last-applied-configuration annotations by setting it to "
"match the contents of a file.\n"
"\t\tThis results in the last-applied-configuration being updated as though "
"'kubectl apply -f <file>' was run,\n"
"\t\twithout updating any other parts of the object."
msgstr ""
"\n"
"\t\tSet the latest last-applied-configuration annotations by setting it to "
"match the contents of a file.\n"
"\t\tThis results in the last-applied-configuration being updated as though "
"'kubectl apply -f <file>' was run,\n"
"\t\twithout updating any other parts of the object."

#: pkg/kubectl/cmd/proxy.go:36
msgid ""
"\n"
"\t\tTo proxy all of the kubernetes api and nothing else, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/\n"
"\n"
"\t\tTo proxy only part of the kubernetes api and also some static files:\n"
"\n"
"\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/"
"api/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n"
"\n"
"\t\tTo proxy the entire kubernetes api at a different root, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/custom/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'"
msgstr ""
"\n"
"\t\tTo proxy all of the kubernetes api and nothing else, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/\n"
"\n"
"\t\tTo proxy only part of the kubernetes api and also some static files:\n"
"\n"
"\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/"
"api/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n"
"\n"
"\t\tTo proxy the entire kubernetes api at a different root, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/custom/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'"

#: pkg/kubectl/cmd/patch.go:59
msgid ""
"\n"
"\t\tUpdate field(s) of a resource using strategic merge patch\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."
msgstr ""
"\n"
"\t\tUpdate field(s) of a resource using strategic merge patch\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."

#: pkg/kubectl/cmd/label.go:70
#, c-format
msgid ""
"\n"
"\t\tUpdate the labels on a resource.\n"
"\n"
"\t\t* A label must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* If --overwrite is true, then existing labels can be overwritten, "
"otherwise attempting to overwrite a label will result in an error.\n"
"\t\t* If --resource-version is specified, then updates will use this "
"resource version, otherwise the existing resource-version will be used."
msgstr ""
"\n"
"\t\tUpdate the labels on a resource.\n"
"\n"
"\t\t* A label must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* If --overwrite is true, then existing labels can be overwritten, "
"otherwise attempting to overwrite a label will result in an error.\n"
"\t\t* If --resource-version is specified, then updates will use this "
"resource version, otherwise the existing resource-version will be used."

#: pkg/kubectl/cmd/taint.go:58
#, c-format
msgid ""
"\n"
"\t\tUpdate the taints on one or more nodes.\n"
"\n"
"\t\t* A taint consists of a key, value, and effect. As an argument here, it "
"is expressed as key=value:effect.\n"
"\t\t* The key must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* The value must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[2]d characters.\n"
"\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n"
"\t\t* Currently taint can only apply to node."
msgstr ""
"\n"
"\t\tUpdate the taints on one or more nodes.\n"
"\n"
"\t\t* A taint consists of a key, value, and effect. As an argument here, it "
"is expressed as key=value:effect.\n"
"\t\t* The key must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* The value must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[2]d characters.\n"
"\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n"
"\t\t* Currently taint can only apply to node."

#: pkg/kubectl/cmd/apply_view_last_applied.go:46
msgid ""
"\n"
"\t\tView the latest last-applied-configuration annotations by type/name or "
"file.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change output format."
msgstr ""
"\n"
"\t\tView the latest last-applied-configuration annotations by type/name or "
"file.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change output format."

#: pkg/kubectl/cmd/cp.go:37
msgid ""
"\n"
"\t    # !!!Important Note!!!\n"
"\t    # Requires that the 'tar' binary is present in your container\n"
"\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n"
"\n"
"\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in "
"the default namespace\n"
"\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n"
"\n"
"        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific "
"container\n"
"\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n"
"\n"
"\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace "
"<some-namespace>\n"
"\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n"
"\n"
"\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n"
"\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar"
msgstr ""
"\n"
"\t    # !!!Important Note!!!\n"
"\t    # Requires that the 'tar' binary is present in your container\n"
"\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n"
"\n"
"\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in "
"the default namespace\n"
"\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n"
"\n"
"        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific "
"container\n"
"\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n"
"\n"
"\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace "
"<some-namespace>\n"
"\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n"
"\n"
"\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n"
"\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar"

#: pkg/kubectl/cmd/create_secret.go:205
msgid ""
"\n"
"\t  # Create a new TLS secret named tls-secret with the given key pair:\n"
"\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/"
"to/tls.key"
msgstr ""
"\n"
"\t  # Create a new TLS secret named tls-secret with the given key pair:\n"
"\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/"
"to/tls.key"

#: pkg/kubectl/cmd/create_namespace.go:35
msgid ""
"\n"
"\t  # Create a new namespace named my-namespace\n"
"\t  kubectl create namespace my-namespace"
msgstr ""
"\n"
"\t  # Create a new namespace named my-namespace\n"
"\t  kubectl create namespace my-namespace"

#: pkg/kubectl/cmd/create_secret.go:59
msgid ""
"\n"
"\t  # Create a new secret named my-secret with keys for each file in folder "
"bar\n"
"\t  kubectl create secret generic my-secret --from-file=path/to/bar\n"
"\n"
"\t  # Create a new secret named my-secret with specified keys instead of "
"names on disk\n"
"\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/."
"ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n"
"\n"
"\t  # Create a new secret named my-secret with key1=supersecret and "
"key2=topsecret\n"
"\t  kubectl create secret generic my-secret --from-literal=key1=supersecret "
"--from-literal=key2=topsecret"
msgstr ""
"\n"
"\t  # Create a new secret named my-secret with keys for each file in folder "
"bar\n"
"\t  kubectl create secret generic my-secret --from-file=path/to/bar\n"
"\n"
"\t  # Create a new secret named my-secret with specified keys instead of "
"names on disk\n"
"\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/."
"ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n"
"\n"
"\t  # Create a new secret named my-secret with key1=supersecret and "
"key2=topsecret\n"
"\t  kubectl create secret generic my-secret --from-literal=key1=supersecret "
"--from-literal=key2=topsecret"

#: pkg/kubectl/cmd/create_serviceaccount.go:35
msgid ""
"\n"
"\t  # Create a new service account named my-service-account\n"
"\t  kubectl create serviceaccount my-service-account"
msgstr ""
"\n"
"\t  # Create a new service account named my-service-account\n"
"\t  kubectl create serviceaccount my-service-account"

#: pkg/kubectl/cmd/create_service.go:232
msgid ""
"\n"
"\t# Create a new ExternalName service named my-ns \n"
"\tkubectl create service externalname my-ns --external-name bar.com"
msgstr ""
"\n"
"\t# Create a new ExternalName service named my-ns \n"
"\tkubectl create service externalname my-ns --external-name bar.com"

#: pkg/kubectl/cmd/create_service.go:225
msgid ""
"\n"
"\tCreate an ExternalName service with the specified name.\n"
"\n"
"\tExternalName service references to an external DNS address instead of\n"
"\tonly pods, which will allow application authors to reference services\n"
"\tthat exist off platform, on other clusters, or locally."
msgstr ""
"\n"
"\tCreate an ExternalName service with the specified name.\n"
"\n"
"\tExternalName service references to an external DNS address instead of\n"
"\tonly pods, which will allow application authors to reference services\n"
"\tthat exist off platform, on other clusters, or locally."

#: pkg/kubectl/cmd/help.go:30
msgid ""
"\n"
"\tHelp provides help for any command in the application.\n"
"\tSimply type kubectl help [path to command] for full details."
msgstr ""
"\n"
"\tHelp provides help for any command in the application.\n"
"\tSimply type kubectl help [path to command] for full details."

#: pkg/kubectl/cmd/create_service.go:173
msgid ""
"\n"
"    # Create a new LoadBalancer service named my-lbs\n"
"    kubectl create service loadbalancer my-lbs --tcp=5678:8080"
msgstr ""
"\n"
"    # Create a new LoadBalancer service named my-lbs\n"
"    kubectl create service loadbalancer my-lbs --tcp=5678:8080"

#: pkg/kubectl/cmd/create_service.go:53
msgid ""
"\n"
"    # Create a new clusterIP service named my-cs\n"
"    kubectl create service clusterip my-cs --tcp=5678:8080\n"
"\n"
"    # Create a new clusterIP service named my-cs (in headless mode)\n"
"    kubectl create service clusterip my-cs --clusterip=\"None\""
msgstr ""
"\n"
"    # Create a new clusterIP service named my-cs\n"
"    kubectl create service clusterip my-cs --tcp=5678:8080\n"
"\n"
"    # Create a new clusterIP service named my-cs (in headless mode)\n"
"    kubectl create service clusterip my-cs --clusterip=\"None\""

#: pkg/kubectl/cmd/create_deployment.go:36
msgid ""
"\n"
"    # Create a new deployment named my-dep that runs the busybox image.\n"
"    kubectl create deployment my-dep --image=busybox"
msgstr ""
"\n"
"    # Create a new deployment named my-dep that runs the busybox image.\n"
"    kubectl create deployment my-dep --image=busybox"

#: pkg/kubectl/cmd/create_service.go:116
msgid ""
"\n"
"    # Create a new nodeport service named my-ns\n"
"    kubectl create service nodeport my-ns --tcp=5678:8080"
msgstr ""
"\n"
"    # Create a new nodeport service named my-ns\n"
"    kubectl create service nodeport my-ns --tcp=5678:8080"

#: pkg/kubectl/cmd/clusterinfo_dump.go:62
msgid ""
"\n"
"    # Dump current cluster state to stdout\n"
"    kubectl cluster-info dump\n"
"\n"
"    # Dump current cluster state to /path/to/cluster-state\n"
"    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n"
"\n"
"    # Dump all namespaces to stdout\n"
"    kubectl cluster-info dump --all-namespaces\n"
"\n"
"    # Dump a set of namespaces to /path/to/cluster-state\n"
"    kubectl cluster-info dump --namespaces default,kube-system --output-"
"directory=/path/to/cluster-state"
msgstr ""
"\n"
"    # Dump current cluster state to stdout\n"
"    kubectl cluster-info dump\n"
"\n"
"    # Dump current cluster state to /path/to/cluster-state\n"
"    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n"
"\n"
"    # Dump all namespaces to stdout\n"
"    kubectl cluster-info dump --all-namespaces\n"
"\n"
"    # Dump a set of namespaces to /path/to/cluster-state\n"
"    kubectl cluster-info dump --namespaces default,kube-system --output-"
"directory=/path/to/cluster-state"

#: pkg/kubectl/cmd/annotate.go:78
msgid ""
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend'.\n"
"    # If the same annotation is set multiple times, only the last value will "
"be applied\n"
"    kubectl annotate pods foo description='my frontend'\n"
"\n"
"    # Update a pod identified by type and name in \"pod.json\"\n"
"    kubectl annotate -f pod.json description='my frontend'\n"
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend running nginx', overwriting any existing value.\n"
"    kubectl annotate --overwrite pods foo description='my frontend running "
"nginx'\n"
"\n"
"    # Update all pods in the namespace\n"
"    kubectl annotate pods --all description='my frontend running nginx'\n"
"\n"
"    # Update pod 'foo' only if the resource is unchanged from version 1.\n"
"    kubectl annotate pods foo description='my frontend running nginx' --"
"resource-version=1\n"
"\n"
"    # Update pod 'foo' by removing an annotation named 'description' if it "
"exists.\n"
"    # Does not require the --overwrite flag.\n"
"    kubectl annotate pods foo description-"
msgstr ""
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend'.\n"
"    # If the same annotation is set multiple times, only the last value will "
"be applied\n"
"    kubectl annotate pods foo description='my frontend'\n"
"\n"
"    # Update a pod identified by type and name in \"pod.json\"\n"
"    kubectl annotate -f pod.json description='my frontend'\n"
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend running nginx', overwriting any existing value.\n"
"    kubectl annotate --overwrite pods foo description='my frontend running "
"nginx'\n"
"\n"
"    # Update all pods in the namespace\n"
"    kubectl annotate pods --all description='my frontend running nginx'\n"
"\n"
"    # Update pod 'foo' only if the resource is unchanged from version 1.\n"
"    kubectl annotate pods foo description='my frontend running nginx' --"
"resource-version=1\n"
"\n"
"    # Update pod 'foo' by removing an annotation named 'description' if it "
"exists.\n"
"    # Does not require the --overwrite flag.\n"
"    kubectl annotate pods foo description-"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_namespace.go#L44
#: pkg/kubectl/cmd/create_service.go:170
msgid ""
"\n"
"    Create a LoadBalancer service with the specified name."
msgstr ""
"\n"
"    Create a LoadBalancer service with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_serviceaccount.go#L44
#: pkg/kubectl/cmd/create_service.go:50
msgid ""
"\n"
"    Create a clusterIP service with the specified name."
msgstr ""
"\n"
"    Create a clusterIP service with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_deployment.go#L44
#: pkg/kubectl/cmd/create_deployment.go:33
msgid ""
"\n"
"    Create a deployment with the specified name."
msgstr ""
"\n"
"    Create a deployment with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_deployment.go#L44
#: pkg/kubectl/cmd/create_service.go:113
msgid ""
"\n"
"    Create a nodeport service with the specified name."
msgstr ""
"\n"
"    Create a nodeport service with the specified name."

#: pkg/kubectl/cmd/clusterinfo_dump.go:53
msgid ""
"\n"
"    Dumps cluster info out suitable for debugging and diagnosing cluster "
"problems.  By default, dumps everything to\n"
"    stdout. You can optionally specify a directory with --output-directory.  "
"If you specify a directory, kubernetes will\n"
"    build a set of files in that directory.  By default only dumps things in "
"the 'kube-system' namespace, but you can\n"
"    switch to a different namespace with the --namespaces flag, or specify --"
"all-namespaces to dump all namespaces.\n"
"\n"
"    The command also dumps the logs of all of the pods in the cluster, these "
"logs are dumped into different directories\n"
"    based on namespace and pod name."
msgstr ""
"\n"
"    Dumps cluster info out suitable for debugging and diagnosing cluster "
"problems.  By default, dumps everything to\n"
"    stdout. You can optionally specify a directory with --output-directory.  "
"If you specify a directory, kubernetes will\n"
"    build a set of files in that directory.  By default only dumps things in "
"the 'kube-system' namespace, but you can\n"
"    switch to a different namespace with the --namespaces flag, or specify --"
"all-namespaces to dump all namespaces.\n"
"\n"
"    The command also dumps the logs of all of the pods in the cluster, these "
"logs are dumped into different directories\n"
"    based on namespace and pod name."

#: pkg/kubectl/cmd/clusterinfo.go:37
msgid ""
"\n"
"  Display addresses of the master and services with label kubernetes.io/"
"cluster-service=true\n"
"  To further debug and diagnose cluster problems, use 'kubectl cluster-info "
"dump'."
msgstr ""
"\n"
"  Display addresses of the master and services with label kubernetes.io/"
"cluster-service=true\n"
"  To further debug and diagnose cluster problems, use 'kubectl cluster-info "
"dump'."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L61
#: pkg/kubectl/cmd/create_quota.go:62
msgid ""
"A comma-delimited set of quota scopes that must all match each object "
"tracked by the quota."
msgstr ""
"A comma-delimited set of quota scopes that must all match each object "
"tracked by the quota."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L60
#: pkg/kubectl/cmd/create_quota.go:61
msgid ""
"A comma-delimited set of resource=quantity pairs that define a hard limit."
msgstr ""
"A comma-delimited set of resource=quantity pairs that define a hard limit."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_pdb.go#L63
#: pkg/kubectl/cmd/create_pdb.go:64
msgid ""
"A label selector to use for this budget. Only equality-based selector "
"requirements are supported."
msgstr ""
"A label selector to use for this budget. Only equality-based selector "
"requirements are supported."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L106
#: pkg/kubectl/cmd/expose.go:104
msgid ""
"A label selector to use for this service. Only equality-based selector "
"requirements are supported. If empty (the default) infer the selector from "
"the replication controller or replica set.)"
msgstr ""
"A label selector to use for this service. Only equality-based selector "
"requirements are supported. If empty (the default) infer the selector from "
"the replication controller or replica set.)"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L136
#: pkg/kubectl/cmd/run.go:139
msgid "A schedule in the Cron format the job should be run with."
msgstr "A schedule in the Cron format the job should be run with."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L111
#: pkg/kubectl/cmd/expose.go:109
msgid ""
"Additional external IP address (not managed by Kubernetes) to accept for the "
"service. If this IP is routed to a node, the service can be accessed by this "
"IP in addition to its generated service IP."
msgstr ""
"Additional external IP address (not managed by Kubernetes) to accept for the "
"service. If this IP is routed to a node, the service can be accessed by this "
"IP in addition to its generated service IP."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L119
#: pkg/kubectl/cmd/expose.go:110 pkg/kubectl/cmd/run.go:122
msgid ""
"An inline JSON override for the generated object. If this is non-empty, it "
"is used to override the generated object. Requires that the object supply a "
"valid apiVersion field."
msgstr ""
"An inline JSON override for the generated object. If this is non-empty, it "
"is used to override the generated object. Requires that the object supply a "
"valid apiVersion field."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L134
#: pkg/kubectl/cmd/run.go:137
msgid ""
"An inline JSON override for the generated service object. If this is non-"
"empty, it is used to override the generated object. Requires that the object "
"supply a valid apiVersion field.  Only used if --expose is true."
msgstr ""
"An inline JSON override for the generated service object. If this is non-"
"empty, it is used to override the generated object. Requires that the object "
"supply a valid apiVersion field.  Only used if --expose is true."

#: pkg/kubectl/cmd/apply.go:104
msgid "Apply a configuration to a resource by filename or stdin"
msgstr "Apply a configuration to a resource by filename or stdin"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/certificates.go#L71
#: pkg/kubectl/cmd/certificates.go:72
msgid "Approve a certificate signing request"
msgstr "Approve a certificate signing request"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L81
#: pkg/kubectl/cmd/create_service.go:82
msgid ""
"Assign your own ClusterIP or set to 'None' for a 'headless' service (no "
"loadbalancing)."
msgstr ""
"Assign your own ClusterIP or set to 'None' for a 'headless' service (no "
"loadbalancing)."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/attach.go#L64
#: pkg/kubectl/cmd/attach.go:70
msgid "Attach to a running container"
msgstr "Attach to a running container"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/autoscale.go#L55
#: pkg/kubectl/cmd/autoscale.go:56
msgid "Auto-scale a Deployment, ReplicaSet, or ReplicationController"
msgstr "Auto-scale a Deployment, ReplicaSet, or ReplicationController"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L115
#: pkg/kubectl/cmd/expose.go:113
msgid ""
"ClusterIP to be assigned to the service. Leave empty to auto-allocate, or "
"set to 'None' to create a headless service."
msgstr ""
"ClusterIP to be assigned to the service. Leave empty to auto-allocate, or "
"set to 'None' to create a headless service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_clusterrolebinding.go#L55
#: pkg/kubectl/cmd/create_clusterrolebinding.go:56
msgid "ClusterRole this ClusterRoleBinding should reference"
msgstr "ClusterRole this ClusterRoleBinding should reference"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_rolebinding.go#L55
#: pkg/kubectl/cmd/create_rolebinding.go:56
msgid "ClusterRole this RoleBinding should reference"
msgstr "ClusterRole this RoleBinding should reference"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L101
#: pkg/kubectl/cmd/rollingupdate.go:102
msgid ""
"Container name which will have its image upgraded. Only relevant when --"
"image is specified, ignored otherwise. Required when using --image on a "
"multi-container pod"
msgstr ""
"Container name which will have its image upgraded. Only relevant when --"
"image is specified, ignored otherwise. Required when using --image on a "
"multi-container pod"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/convert.go#L67
#: pkg/kubectl/cmd/convert.go:68
msgid "Convert config files between different API versions"
msgstr "Convert config files between different API versions"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/cp.go#L64
#: pkg/kubectl/cmd/cp.go:65
msgid "Copy files and directories to and from containers."
msgstr "Copy files and directories to and from containers."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_clusterrolebinding.go#L43
#: pkg/kubectl/cmd/create_clusterrolebinding.go:44
msgid "Create a ClusterRoleBinding for a particular ClusterRole"
msgstr "Create a ClusterRoleBinding for a particular ClusterRole"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L181
#: pkg/kubectl/cmd/create_service.go:182
msgid "Create a LoadBalancer service."
msgstr "Create a LoadBalancer service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L124
#: pkg/kubectl/cmd/create_service.go:125
msgid "Create a NodePort service."
msgstr "Create a NodePort service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_rolebinding.go#L43
#: pkg/kubectl/cmd/create_rolebinding.go:44
msgid "Create a RoleBinding for a particular Role or ClusterRole"
msgstr "Create a RoleBinding for a particular Role or ClusterRole"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L214
#: pkg/kubectl/cmd/create_secret.go:214
msgid "Create a TLS secret"
msgstr "Create a TLS secret"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L68
#: pkg/kubectl/cmd/create_service.go:69
msgid "Create a clusterIP service."
msgstr "Create a clusterIP service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_configmap.go#L59
#: pkg/kubectl/cmd/create_configmap.go:60
msgid "Create a configmap from a local file, directory or literal value"
msgstr "Create a configmap from a local file, directory or literal value"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_deployment.go#L44
#: pkg/kubectl/cmd/create_deployment.go:46
msgid "Create a deployment with the specified name."
msgstr "Create a deployment with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_namespace.go#L44
#: pkg/kubectl/cmd/create_namespace.go:45
msgid "Create a namespace with the specified name"
msgstr "Create a namespace with the specified name"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_pdb.go#L49
#: pkg/kubectl/cmd/create_pdb.go:50
msgid "Create a pod disruption budget with the specified name."
msgstr "Create a pod disruption budget with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_quota.go#L47
#: pkg/kubectl/cmd/create_quota.go:48
msgid "Create a quota with the specified name."
msgstr "Create a quota with the specified name."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create.go#L56
#: pkg/kubectl/cmd/create.go:63
msgid "Create a resource by filename or stdin"
msgstr "Create a resource by filename or stdin"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L143
#: pkg/kubectl/cmd/create_secret.go:144
msgid "Create a secret for use with a Docker registry"
msgstr "Create a secret for use with a Docker registry"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L73
#: pkg/kubectl/cmd/create_secret.go:74
msgid "Create a secret from a local file, directory or literal value"
msgstr "Create a secret from a local file, directory or literal value"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L34
#: pkg/kubectl/cmd/create_secret.go:35
msgid "Create a secret using specified subcommand"
msgstr "Create a secret using specified subcommand"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_serviceaccount.go#L44
#: pkg/kubectl/cmd/create_serviceaccount.go:45
msgid "Create a service account with the specified name"
msgstr "Create a service account with the specified name"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L36
#: pkg/kubectl/cmd/create_service.go:37
msgid "Create a service using specified subcommand."
msgstr "Create a service using specified subcommand."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L240
#: pkg/kubectl/cmd/create_service.go:241
msgid "Create an ExternalName service."
msgstr "Create an ExternalName service."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/delete.go#L130
#: pkg/kubectl/cmd/delete.go:132
msgid ""
"Delete resources by filenames, stdin, resources and names, or by resources "
"and label selector"
msgstr ""
"Delete resources by filenames, stdin, resources and names, or by resources "
"and label selector"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/delete_cluster.go#L38
#: pkg/kubectl/cmd/config/delete_cluster.go:39
msgid "Delete the specified cluster from the kubeconfig"
msgstr "Delete the specified cluster from the kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/delete_context.go#L38
#: pkg/kubectl/cmd/config/delete_context.go:39
msgid "Delete the specified context from the kubeconfig"
msgstr "Delete the specified context from the kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/certificates.go#L121
#: pkg/kubectl/cmd/certificates.go:122
msgid "Deny a certificate signing request"
msgstr "Deny a certificate signing request"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/stop.go#L58
#: pkg/kubectl/cmd/stop.go:59
msgid "Deprecated: Gracefully shut down a resource by name or filename"
msgstr "Deprecated: Gracefully shut down a resource by name or filename"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/get_contexts.go#L62
#: pkg/kubectl/cmd/config/get_contexts.go:64
msgid "Describe one or many contexts"
msgstr "Describe one or many contexts"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/top_node.go#L77
#: pkg/kubectl/cmd/top_node.go:78
msgid "Display Resource (CPU/Memory/Storage) usage of nodes"
msgstr "Display Resource (CPU/Memory/Storage) usage of nodes"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/top_pod.go#L79
#: pkg/kubectl/cmd/top_pod.go:80
msgid "Display Resource (CPU/Memory/Storage) usage of pods"
msgstr "Display Resource (CPU/Memory/Storage) usage of pods"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/top.go#L43
#: pkg/kubectl/cmd/top.go:44
msgid "Display Resource (CPU/Memory/Storage) usage."
msgstr "Display Resource (CPU/Memory/Storage) usage."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/clusterinfo.go#L49
#: pkg/kubectl/cmd/clusterinfo.go:51
msgid "Display cluster info"
msgstr "Display cluster info"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/get_clusters.go#L40
#: pkg/kubectl/cmd/config/get_clusters.go:41
msgid "Display clusters defined in the kubeconfig"
msgstr "Display clusters defined in the kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/view.go#L64
#: pkg/kubectl/cmd/config/view.go:67
msgid "Display merged kubeconfig settings or a specified kubeconfig file"
msgstr "Display merged kubeconfig settings or a specified kubeconfig file"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/get.go#L107
#: pkg/kubectl/cmd/get.go:111
msgid "Display one or many resources"
msgstr "Display one or many resources"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/current_context.go#L48
#: pkg/kubectl/cmd/config/current_context.go:49
msgid "Displays the current-context"
msgstr "Displays the current-context"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/explain.go#L50
#: pkg/kubectl/cmd/explain.go:51
msgid "Documentation of resources"
msgstr "Documentation of resources"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L176
#: pkg/kubectl/cmd/drain.go:178
msgid "Drain node in preparation for maintenance"
msgstr "Drain node in preparation for maintenance"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/clusterinfo_dump.go#L37
#: pkg/kubectl/cmd/clusterinfo_dump.go:39
msgid "Dump lots of relevant info for debugging and diagnosis"
msgstr "Dump lots of relevant info for debugging and diagnosis"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/edit.go#L100
#: pkg/kubectl/cmd/edit.go:110
msgid "Edit a resource on the server"
msgstr "Edit a resource on the server"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L159
#: pkg/kubectl/cmd/create_secret.go:160
msgid "Email for Docker registry"
msgstr "Email for Docker registry"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/exec.go#L68
#: pkg/kubectl/cmd/exec.go:69
msgid "Execute a command in a container"
msgstr "Execute a command in a container"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L102
#: pkg/kubectl/cmd/rollingupdate.go:103
msgid ""
"Explicit policy for when to pull container images. Required when --image is "
"same as existing image, ignored otherwise."
msgstr ""
"Explicit policy for when to pull container images. Required when --image is "
"same as existing image, ignored otherwise."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/portforward.go#L75
#: pkg/kubectl/cmd/portforward.go:76
msgid "Forward one or more local ports to a pod"
msgstr "Forward one or more local ports to a pod"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/help.go#L36
#: pkg/kubectl/cmd/help.go:37
msgid "Help about any command"
msgstr "Help about any command"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L105
#: pkg/kubectl/cmd/expose.go:103
msgid ""
"IP to assign to the Load Balancer. If empty, an ephemeral IP will be created "
"and used (cloud-provider specific)."
msgstr ""
"IP to assign to the Load Balancer. If empty, an ephemeral IP will be created "
"and used (cloud-provider specific)."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L114
#: pkg/kubectl/cmd/expose.go:112
msgid ""
"If non-empty, set the session affinity for the service to this; legal "
"values: 'None', 'ClientIP'"
msgstr ""
"If non-empty, set the session affinity for the service to this; legal "
"values: 'None', 'ClientIP'"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/annotate.go#L135
#: pkg/kubectl/cmd/annotate.go:136
msgid ""
"If non-empty, the annotation update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."
msgstr ""
"If non-empty, the annotation update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/label.go#L132
#: pkg/kubectl/cmd/label.go:134
msgid ""
"If non-empty, the labels update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."
msgstr ""
"If non-empty, the labels update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L98
#: pkg/kubectl/cmd/rollingupdate.go:99
msgid ""
"Image to use for upgrading the replication controller. Must be distinct from "
"the existing image (either new image or new image tag).  Can not be used "
"with --filename/-f"
msgstr ""
"Image to use for upgrading the replication controller. Must be distinct from "
"the existing image (either new image or new image tag).  Can not be used "
"with --filename/-f"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout.go#L46
#: pkg/kubectl/cmd/rollout/rollout.go:47
msgid "Manage a deployment rollout"
msgstr "Manage a deployment rollout"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L127
#: pkg/kubectl/cmd/drain.go:128
msgid "Mark node as schedulable"
msgstr "Mark node as schedulable"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/drain.go#L102
#: pkg/kubectl/cmd/drain.go:103
msgid "Mark node as unschedulable"
msgstr "Mark node as unschedulable"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_pause.go#L73
#: pkg/kubectl/cmd/rollout/rollout_pause.go:74
msgid "Mark the provided resource as paused"
msgstr "Mark the provided resource as paused"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/certificates.go#L35
#: pkg/kubectl/cmd/certificates.go:36
msgid "Modify certificate resources."
msgstr "Modify certificate resources."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/config.go#L39
#: pkg/kubectl/cmd/config/config.go:40
msgid "Modify kubeconfig files"
msgstr "Modify kubeconfig files"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L110
#: pkg/kubectl/cmd/expose.go:108
msgid ""
"Name or number for the port on the container that the service should direct "
"traffic to. Optional."
msgstr ""
"Name or number for the port on the container that the service should direct "
"traffic to. Optional."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/logs.go#L108
#: pkg/kubectl/cmd/logs.go:113
msgid ""
"Only return logs after a specific date (RFC3339). Defaults to all logs. Only "
"one of since-time / since may be used."
msgstr ""
"Only return logs after a specific date (RFC3339). Defaults to all logs. Only "
"one of since-time / since may be used."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/completion.go#L97
#: pkg/kubectl/cmd/completion.go:104
msgid "Output shell completion code for the specified shell (bash or zsh)"
msgstr "Output shell completion code for the specified shell (bash or zsh)"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/edit.go#L115
#: pkg/kubectl/cmd/convert.go:85
msgid ""
"Output the formatted object with the given group version (for ex: "
"'extensions/v1beta1').)"
msgstr ""
"Output the formatted object with the given group version (for ex: "
"'extensions/v1beta1').)"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L157
#: pkg/kubectl/cmd/create_secret.go:158
msgid "Password for Docker registry authentication"
msgstr "Password for Docker registry authentication"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L226
#: pkg/kubectl/cmd/create_secret.go:226
msgid "Path to PEM encoded public key certificate."
msgstr "Path to PEM encoded public key certificate."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L227
#: pkg/kubectl/cmd/create_secret.go:227
msgid "Path to private key associated with given certificate."
msgstr "Path to private key associated with given certificate."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L84
#: pkg/kubectl/cmd/rollingupdate.go:85
msgid "Perform a rolling update of the given ReplicationController"
msgstr "Perform a rolling update of the given ReplicationController"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/scale.go#L82
#: pkg/kubectl/cmd/scale.go:83
msgid ""
"Precondition for resource version. Requires that the current resource "
"version match this value in order to scale."
msgstr ""
"Precondition for resource version. Requires that the current resource "
"version match this value in order to scale."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/version.go#L39
#: pkg/kubectl/cmd/version.go:40
msgid "Print the client and server version information"
msgstr "Print the client and server version information"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/options.go#L37
#: pkg/kubectl/cmd/options.go:38
msgid "Print the list of flags inherited by all commands"
msgstr "Print the list of flags inherited by all commands"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/logs.go#L86
#: pkg/kubectl/cmd/logs.go:93
msgid "Print the logs for a container in a pod"
msgstr "Print the logs for a container in a pod"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/replace.go#L70
#: pkg/kubectl/cmd/replace.go:71
msgid "Replace a resource by filename or stdin"
msgstr "Replace a resource by filename or stdin"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_resume.go#L71
#: pkg/kubectl/cmd/rollout/rollout_resume.go:72
msgid "Resume a paused resource"
msgstr "Resume a paused resource"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_rolebinding.go#L56
#: pkg/kubectl/cmd/create_rolebinding.go:57
msgid "Role this RoleBinding should reference"
msgstr "Role this RoleBinding should reference"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L94
#: pkg/kubectl/cmd/run.go:97
msgid "Run a particular image on the cluster"
msgstr "Run a particular image on the cluster"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/proxy.go#L68
#: pkg/kubectl/cmd/proxy.go:69
msgid "Run a proxy to the Kubernetes API server"
msgstr "Run a proxy to the Kubernetes API server"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L161
#: pkg/kubectl/cmd/create_secret.go:161
msgid "Server location for Docker registry"
msgstr "Server location for Docker registry"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/scale.go#L71
#: pkg/kubectl/cmd/scale.go:71
msgid ""
"Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job"
msgstr ""
"Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/set/set.go#L37
#: pkg/kubectl/cmd/set/set.go:38
msgid "Set specific features on objects"
msgstr "Set specific features on objects"

#: pkg/kubectl/cmd/apply_set_last_applied.go:83
msgid ""
"Set the last-applied-configuration annotation on a live object to match the "
"contents of a file."
msgstr ""
"Set the last-applied-configuration annotation on a live object to match the "
"contents of a file."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/set/set_selector.go#L81
#: pkg/kubectl/cmd/set/set_selector.go:82
msgid "Set the selector on a resource"
msgstr "Set the selector on a resource"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_cluster.go#L67
#: pkg/kubectl/cmd/config/create_cluster.go:68
msgid "Sets a cluster entry in kubeconfig"
msgstr "Sets a cluster entry in kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_context.go#L57
#: pkg/kubectl/cmd/config/create_context.go:58
msgid "Sets a context entry in kubeconfig"
msgstr "Sets a context entry in kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_authinfo.go#L103
#: pkg/kubectl/cmd/config/create_authinfo.go:104
msgid "Sets a user entry in kubeconfig"
msgstr "Sets a user entry in kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/set.go#L59
#: pkg/kubectl/cmd/config/set.go:60
msgid "Sets an individual value in a kubeconfig file"
msgstr "Sets an individual value in a kubeconfig file"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/use_context.go#L48
#: pkg/kubectl/cmd/config/use_context.go:49
msgid "Sets the current-context in a kubeconfig file"
msgstr "Sets the current-context in a kubeconfig file"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/describe.go#L80
#: pkg/kubectl/cmd/describe.go:86
msgid "Show details of a specific resource or group of resources"
msgstr "Show details of a specific resource or group of resources"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_status.go#L57
#: pkg/kubectl/cmd/rollout/rollout_status.go:58
msgid "Show the status of the rollout"
msgstr "Show the status of the rollout"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L108
#: pkg/kubectl/cmd/expose.go:106
msgid "Synonym for --target-port"
msgstr "Synonym for --target-port"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L87
#: pkg/kubectl/cmd/expose.go:88
msgid ""
"Take a replication controller, service, deployment or pod and expose it as a "
"new Kubernetes Service"
msgstr ""
"Take a replication controller, service, deployment or pod and expose it as a "
"new Kubernetes Service"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L114
#: pkg/kubectl/cmd/run.go:117
msgid "The image for the container to run."
msgstr "The image for the container to run."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L116
#: pkg/kubectl/cmd/run.go:119
msgid ""
"The image pull policy for the container. If left empty, this value will not "
"be specified by the client and defaulted by the server"
msgstr ""
"The image pull policy for the container. If left empty, this value will not "
"be specified by the client and defaulted by the server"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollingupdate.go#L100
#: pkg/kubectl/cmd/rollingupdate.go:101
msgid ""
"The key to use to differentiate between two different controllers, default "
"'deployment'.  Only relevant when --image is specified, ignored otherwise"
msgstr ""
"The key to use to differentiate between two different controllers, default "
"'deployment'.  Only relevant when --image is specified, ignored otherwise"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_pdb.go#L62
#: pkg/kubectl/cmd/create_pdb.go:63
msgid ""
"The minimum number or percentage of available pods this budget requires."
msgstr ""
"The minimum number or percentage of available pods this budget requires."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L113
#: pkg/kubectl/cmd/expose.go:111
msgid "The name for the newly created object."
msgstr "The name for the newly created object."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/autoscale.go#L71
#: pkg/kubectl/cmd/autoscale.go:72
msgid ""
"The name for the newly created object. If not specified, the name of the "
"input resource will be used."
msgstr ""
"The name for the newly created object. If not specified, the name of the "
"input resource will be used."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L113
#: pkg/kubectl/cmd/run.go:116
msgid ""
"The name of the API generator to use, see http://kubernetes.io/docs/user-"
"guide/kubectl-conventions/#generators for a list."
msgstr ""
"The name of the API generator to use, see http://kubernetes.io/docs/user-"
"guide/kubectl-conventions/#generators for a list."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/autoscale.go#L66
#: pkg/kubectl/cmd/autoscale.go:67
msgid ""
"The name of the API generator to use. Currently there is only 1 generator."
msgstr ""
"The name of the API generator to use. Currently there is only 1 generator."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L98
#: pkg/kubectl/cmd/expose.go:99
msgid ""
"The name of the API generator to use. There are 2 generators: 'service/v1' "
"and 'service/v2'. The only difference between them is that service port in "
"v1 is named 'default', while it is left unnamed in v2. Default is 'service/"
"v2'."
msgstr ""
"The name of the API generator to use. There are 2 generators: 'service/v1' "
"and 'service/v2'. The only difference between them is that service port in "
"v1 is named 'default', while it is left unnamed in v2. Default is 'service/"
"v2'."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L133
#: pkg/kubectl/cmd/run.go:136
msgid ""
"The name of the generator to use for creating a service.  Only used if --"
"expose is true"
msgstr ""
"The name of the generator to use for creating a service.  Only used if --"
"expose is true"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L99
#: pkg/kubectl/cmd/expose.go:100
msgid "The network protocol for the service to be created. Default is 'TCP'."
msgstr "The network protocol for the service to be created. Default is 'TCP'."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L100
#: pkg/kubectl/cmd/expose.go:101
msgid ""
"The port that the service should serve on. Copied from the resource being "
"exposed, if unspecified"
msgstr ""
"The port that the service should serve on. Copied from the resource being "
"exposed, if unspecified"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L121
#: pkg/kubectl/cmd/run.go:124
msgid ""
"The port that this container exposes.  If --expose is true, this is also the "
"port used by the service that is created."
msgstr ""
"The port that this container exposes.  If --expose is true, this is also the "
"port used by the service that is created."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L131
#: pkg/kubectl/cmd/run.go:134
msgid ""
"The resource requirement limits for this container.  For example, 'cpu=200m,"
"memory=512Mi'.  Note that server side components may assign limits depending "
"on the server configuration, such as limit ranges."
msgstr ""
"The resource requirement limits for this container.  For example, 'cpu=200m,"
"memory=512Mi'.  Note that server side components may assign limits depending "
"on the server configuration, such as limit ranges."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L130
#: pkg/kubectl/cmd/run.go:133
msgid ""
"The resource requirement requests for this container.  For example, "
"'cpu=100m,memory=256Mi'.  Note that server side components may assign "
"requests depending on the server configuration, such as limit ranges."
msgstr ""
"The resource requirement requests for this container.  For example, "
"'cpu=100m,memory=256Mi'.  Note that server side components may assign "
"requests depending on the server configuration, such as limit ranges."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/run.go#L128
#: pkg/kubectl/cmd/run.go:131
msgid ""
"The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  "
"If set to 'Always' a deployment is created, if set to 'OnFailure' a job is "
"created, if set to 'Never', a regular pod is created. For the latter two --"
"replicas must be 1.  Default 'Always', for CronJobs ` + "`" + `Never` + "`" + `."
msgstr ""
"The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  "
"If set to 'Always' a deployment is created, if set to 'OnFailure' a job is "
"created, if set to 'Never', a regular pod is created. For the latter two --"
"replicas must be 1.  Default 'Always', for CronJobs ` + "`" + `Never` + "`" + `."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L87
#: pkg/kubectl/cmd/create_secret.go:88
msgid "The type of secret to create"
msgstr "The type of secret to create"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/expose.go#L101
#: pkg/kubectl/cmd/expose.go:102
msgid ""
"Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is "
"'ClusterIP'."
msgstr ""
"Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is "
"'ClusterIP'."

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_undo.go#L71
#: pkg/kubectl/cmd/rollout/rollout_undo.go:72
msgid "Undo a previous rollout"
msgstr "Undo a previous rollout"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/unset.go#L47
#: pkg/kubectl/cmd/config/unset.go:48
msgid "Unsets an individual value in a kubeconfig file"
msgstr "Unsets an individual value in a kubeconfig file"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/patch.go#L91
#: pkg/kubectl/cmd/patch.go:96
msgid "Update field(s) of a resource using strategic merge patch"
msgstr "Update field(s) of a resource using strategic merge patch"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/set/set_image.go#L94
#: pkg/kubectl/cmd/set/set_image.go:95
msgid "Update image of a pod template"
msgstr "Update image of a pod template"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/set/set_resources.go#L101
#: pkg/kubectl/cmd/set/set_resources.go:102
msgid "Update resource requests/limits on objects with pod templates"
msgstr "Update resource requests/limits on objects with pod templates"

#: pkg/kubectl/cmd/annotate.go:116
msgid "Update the annotations on a resource"
msgstr "Update the annotations on a resource"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/label.go#L109
#: pkg/kubectl/cmd/label.go:114
msgid "Update the labels on a resource"
msgstr "Update the labels on a resource"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/taint.go#L88
#: pkg/kubectl/cmd/taint.go:87
msgid "Update the taints on one or more nodes"
msgstr "Update the taints on one or more nodes"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_secret.go#L155
#: pkg/kubectl/cmd/create_secret.go:156
msgid "Username for Docker registry authentication"
msgstr "Username for Docker registry authentication"

#: pkg/kubectl/cmd/apply_view_last_applied.go:64
msgid "View latest last-applied-configuration annotations of a resource/object"
msgstr ""
"View latest last-applied-configuration annotations of a resource/object"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/rollout/rollout_history.go#L51
#: pkg/kubectl/cmd/rollout/rollout_history.go:52
msgid "View rollout history"
msgstr "View rollout history"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/clusterinfo_dump.go#L45
#: pkg/kubectl/cmd/clusterinfo_dump.go:46
msgid ""
"Where to output the files.  If empty or '-' uses stdout, otherwise creates a "
"directory hierarchy in that directory"
msgstr ""
"Where to output the files.  If empty or '-' uses stdout, otherwise creates a "
"directory hierarchy in that directory"

#: pkg/kubectl/cmd/run_test.go:85
msgid "dummy restart flag)"
msgstr "dummy restart flag)"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/create_service.go#L253
#: pkg/kubectl/cmd/create_service.go:254
msgid "external name of service"
msgstr "external name of service"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/cmd.go#L217
#: pkg/kubectl/cmd/cmd.go:227
msgid "kubectl controls the Kubernetes cluster manager"
msgstr "kubectl controls the Kubernetes cluster manager"

#~ msgid ""
#~ "watch is only supported on individual resources and resource collections "
#~ "- %d resources were found"
#~ msgid_plural ""
#~ "watch is only supported on individual resources and resource collections "
#~ "- %d resources were found"
#~ msgstr[0] ""
#~ "watch is only supported on individual resources and resource collections "
#~ "- %d resource was found"
#~ msgstr[1] ""
#~ "watch is only supported on individual resources and resource collections "
#~ "- %d resources were found"
`)

func translationsKubectlEn_usLc_messagesK8sPoBytes() ([]byte, error) {
	return _translationsKubectlEn_usLc_messagesK8sPo, nil
}

func translationsKubectlEn_usLc_messagesK8sPo() (*asset, error) {
	bytes, err := translationsKubectlEn_usLc_messagesK8sPoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/en_US/LC_MESSAGES/k8s.po", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlFr_frLc_messagesK8sMo = []byte("\xde\x12\x04\x95\x00\x00\x00\x00\x11\x00\x00\x00\x1c\x00\x00\x00\xa4\x00\x00\x00\x17\x00\x00\x00,\x01\x00\x00\x00\x00\x00\x00\x88\x01\x00\x008\x00\x00\x00\x89\x01\x00\x000\x00\x00\x00\xc2\x01\x00\x000\x00\x00\x00\xf3\x01\x00\x00\x1d\x00\x00\x00$\x02\x00\x00*\x00\x00\x00B\x02\x00\x00A\x00\x00\x00m\x02\x00\x00\x1c\x00\x00\x00\xaf\x02\x00\x00\x17\x00\x00\x00\xcc\x02\x00\x00\"\x00\x00\x00\xe4\x02\x00\x00\"\x00\x00\x00\a\x03\x00\x00\x1f\x00\x00\x00*\x03\x00\x00-\x00\x00\x00J\x03\x00\x00-\x00\x00\x00x\x03\x00\x00/\x00\x00\x00\xa6\x03\x00\x00$\x00\x00\x00\xd6\x03\x00\x00\xc5\x00\x00\x00\xfb\x03\x00\x00\xab\x01\x00\x00\xc1\x04\x00\x00O\x00\x00\x00m\x06\x00\x00-\x00\x00\x00\xbd\x06\x00\x00.\x00\x00\x00\xeb\x06\x00\x00\"\x00\x00\x00\x1a\a\x00\x00-\x00\x00\x00=\a\x00\x00W\x00\x00\x00k\a\x00\x00\x1a\x00\x00\x00\xc3\a\x00\x00 \x00\x00\x00\xde\a\x00\x00#\x00\x00\x00\xff\a\x00\x00$\x00\x00\x00#\b\x00\x00'\x00\x00\x00H\b\x00\x00;\x00\x00\x00p\b\x00\x007\x00\x00\x00\xac\b\x00\x00;\x00\x00\x00\xe4\b\x00\x00.\x00\x00\x00 \t\x00\x00\x05\x01\x00\x00O\t\x00\x00\x01\x00\x00\x00\n\x00\x00\x00\v\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\t\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\a\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\b\x00\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\f\x00\x00\x00\x05\x00\x00\x00\r\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00Apply a configuration to a resource by filename or stdin\x00Delete the specified cluster from the kubeconfig\x00Delete the specified context from the kubeconfig\x00Describe one or many contexts\x00Display clusters defined in the kubeconfig\x00Display merged kubeconfig settings or a specified kubeconfig file\x00Displays the current-context\x00Modify kubeconfig files\x00Sets a cluster entry in kubeconfig\x00Sets a context entry in kubeconfig\x00Sets a user entry in kubeconfig\x00Sets an individual value in a kubeconfig file\x00Sets the current-context in a kubeconfig file\x00Unsets an individual value in a kubeconfig file\x00Update the annotations on a resource\x00watch is only supported on individual resources and resource collections - %d resources were found\x00watch is only supported on individual resources and resource collections - %d resources were found\x00Project-Id-Version: gettext-go-examples-hello\nReport-Msgid-Bugs-To: \nPOT-Creation-Date: 2013-12-12 20:03+0000\nPO-Revision-Date: 2017-01-29 22:54-0800\nLast-Translator: Brendan Burns <brendan.d.burns@gmail.com>\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 8bit\nX-Generator: Poedit 1.6.10\nX-Poedit-SourceCharset: UTF-8\nLanguage-Team: \nPlural-Forms: nplurals=2; plural=(n > 1);\nLanguage: fr\n\x00Appliquer une configuration \u00e0 une ressource par nom de fichier ou depuis stdin\x00Supprimer le cluster sp\u00e9cifi\u00e9 du kubeconfig\x00Supprimer le contexte sp\u00e9cifi\u00e9 du kubeconfig\x00D\u00e9crire un ou plusieurs contextes\x00Afficher les cluster d\u00e9finis dans kubeconfig\x00Afficher les param\u00e8tres fusionn\u00e9s de kubeconfig ou d'un fichier kubeconfig sp\u00e9cifi\u00e9\x00Affiche le contexte actuel\x00Modifier des fichiers kubeconfig\x00D\u00e9finit un cluster dans kubeconfig\x00D\u00e9finit un contexte dans kubeconfig\x00D\u00e9finit un utilisateur dans kubeconfig\x00D\u00e9finit une valeur individuelle dans un fichier kubeconfig\x00D\u00e9finit le contexte courant dans un fichier kubeconfig\x00Supprime une valeur individuelle dans un fichier kubeconfig\x00Mettre \u00e0 jour les annotations d'une ressource\x00watch n'est compatible qu'avec les ressources individuelles et les collections de ressources.  - %d ressource a \u00e9t\u00e9 trouv\u00e9e. \x00watch n'est compatible qu'avec les ressources individuelles et les collections de ressources.  - %d ressources ont \u00e9t\u00e9 trouv\u00e9es. \x00")

func translationsKubectlFr_frLc_messagesK8sMoBytes() ([]byte, error) {
	return _translationsKubectlFr_frLc_messagesK8sMo, nil
}

func translationsKubectlFr_frLc_messagesK8sMo() (*asset, error) {
	bytes, err := translationsKubectlFr_frLc_messagesK8sMoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/fr_FR/LC_MESSAGES/k8s.mo", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlFr_frLc_messagesK8sPo = []byte(`# Test translations for unit tests.
# Copyright (C) 2016
# This file is distributed under the same license as the PACKAGE package.
# FIRST AUTHOR brendan.d.burns@gmail.com, 2016.
#
msgid ""
msgstr ""
"Project-Id-Version: gettext-go-examples-hello\n"
"Report-Msgid-Bugs-To: \n"
"POT-Creation-Date: 2013-12-12 20:03+0000\n"
"PO-Revision-Date: 2017-01-29 22:54-0800\n"
"Last-Translator: Brendan Burns <brendan.d.burns@gmail.com>\n"
"MIME-Version: 1.0\n"
"Content-Type: text/plain; charset=UTF-8\n"
"Content-Transfer-Encoding: 8bit\n"
"X-Generator: Poedit 1.6.10\n"
"X-Poedit-SourceCharset: UTF-8\n"
"Language-Team: \n"
"Plural-Forms: nplurals=2; plural=(n > 1);\n"
"Language: fr\n"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/apply.go#L98
msgid "Apply a configuration to a resource by filename or stdin"
msgstr ""
"Appliquer une configuration à une ressource par nom de fichier ou depuis "
"stdin"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/delete_cluster.go#L38
msgid "Delete the specified cluster from the kubeconfig"
msgstr "Supprimer le cluster spécifié du kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/delete_context.go#L38
msgid "Delete the specified context from the kubeconfig"
msgstr "Supprimer le contexte spécifié du kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/get_contexts.go#L62
msgid "Describe one or many contexts"
msgstr "Décrire un ou plusieurs contextes"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/get_clusters.go#L40
msgid "Display clusters defined in the kubeconfig"
msgstr "Afficher les cluster définis dans kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/view.go#L64
msgid "Display merged kubeconfig settings or a specified kubeconfig file"
msgstr ""
"Afficher les paramètres fusionnés de kubeconfig ou d'un fichier kubeconfig "
"spécifié"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/current_context.go#L48
msgid "Displays the current-context"
msgstr "Affiche le contexte actuel"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/config.go#L39
msgid "Modify kubeconfig files"
msgstr "Modifier des fichiers kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_cluster.go#L67
msgid "Sets a cluster entry in kubeconfig"
msgstr "Définit un cluster dans kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_context.go#L57
msgid "Sets a context entry in kubeconfig"
msgstr "Définit un contexte dans kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_authinfo.go#L103
msgid "Sets a user entry in kubeconfig"
msgstr "Définit un utilisateur dans kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/set.go#L59
msgid "Sets an individual value in a kubeconfig file"
msgstr "Définit une valeur individuelle dans un fichier kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/use_context.go#L48
msgid "Sets the current-context in a kubeconfig file"
msgstr "Définit le contexte courant dans un fichier kubeconfig"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/unset.go#L47
msgid "Unsets an individual value in a kubeconfig file"
msgstr "Supprime une valeur individuelle dans un fichier kubeconfig"

msgid "Update the annotations on a resource"
msgstr "Mettre à jour les annotations d'une ressource"

msgid ""
"watch is only supported on individual resources and resource collections - "
"%d resources were found"
msgid_plural ""
"watch is only supported on individual resources and resource collections - "
"%d resources were found"
msgstr[0] ""
"watch n'est compatible qu'avec les ressources individuelles et les "
"collections de ressources.  - %d ressource a été trouvée. "
msgstr[1] ""
"watch n'est compatible qu'avec les ressources individuelles et les "
"collections de ressources.  - %d ressources ont été trouvées. "
`)

func translationsKubectlFr_frLc_messagesK8sPoBytes() ([]byte, error) {
	return _translationsKubectlFr_frLc_messagesK8sPo, nil
}

func translationsKubectlFr_frLc_messagesK8sPo() (*asset, error) {
	bytes, err := translationsKubectlFr_frLc_messagesK8sPoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/fr_FR/LC_MESSAGES/k8s.po", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlJa_jpLc_messagesK8sMo = []byte("\xde\x12\x04\x95\x00\x00\x00\x00\x11\x00\x00\x00\x1c\x00\x00\x00\xa4\x00\x00\x00\x17\x00\x00\x00,\x01\x00\x00\x00\x00\x00\x00\x88\x01\x00\x008\x00\x00\x00\x89\x01\x00\x000\x00\x00\x00\xc2\x01\x00\x000\x00\x00\x00\xf3\x01\x00\x00\x1d\x00\x00\x00$\x02\x00\x00*\x00\x00\x00B\x02\x00\x00A\x00\x00\x00m\x02\x00\x00\x1c\x00\x00\x00\xaf\x02\x00\x00\x17\x00\x00\x00\xcc\x02\x00\x00\"\x00\x00\x00\xe4\x02\x00\x00\"\x00\x00\x00\a\x03\x00\x00\x1f\x00\x00\x00*\x03\x00\x00-\x00\x00\x00J\x03\x00\x00-\x00\x00\x00x\x03\x00\x00/\x00\x00\x00\xa6\x03\x00\x00$\x00\x00\x00\xd6\x03\x00\x00\xc5\x00\x00\x00\xfb\x03\x00\x00\xa5\x01\x00\x00\xc1\x04\x00\x00c\x00\x00\x00g\x06\x00\x00:\x00\x00\x00\xcb\x06\x00\x00=\x00\x00\x00\x06\a\x00\x007\x00\x00\x00D\a\x00\x00:\x00\x00\x00|\a\x00\x00b\x00\x00\x00\xb7\a\x00\x00-\x00\x00\x00\x1a\b\x00\x00%\x00\x00\x00H\b\x00\x007\x00\x00\x00n\b\x00\x00:\x00\x00\x00\xa6\b\x00\x004\x00\x00\x00\xe1\b\x00\x00:\x00\x00\x00\x16\t\x00\x00:\x00\x00\x00Q\t\x00\x00:\x00\x00\x00\x8c\t\x00\x003\x00\x00\x00\xc7\t\x00\x00\x1d\x01\x00\x00\xfb\t\x00\x00\x01\x00\x00\x00\n\x00\x00\x00\v\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\t\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\a\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\b\x00\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\f\x00\x00\x00\x05\x00\x00\x00\r\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00Apply a configuration to a resource by filename or stdin\x00Delete the specified cluster from the kubeconfig\x00Delete the specified context from the kubeconfig\x00Describe one or many contexts\x00Display clusters defined in the kubeconfig\x00Display merged kubeconfig settings or a specified kubeconfig file\x00Displays the current-context\x00Modify kubeconfig files\x00Sets a cluster entry in kubeconfig\x00Sets a context entry in kubeconfig\x00Sets a user entry in kubeconfig\x00Sets an individual value in a kubeconfig file\x00Sets the current-context in a kubeconfig file\x00Unsets an individual value in a kubeconfig file\x00Update the annotations on a resource\x00watch is only supported on individual resources and resource collections - %d resources were found\x00watch is only supported on individual resources and resource collections - %d resources were found\x00Project-Id-Version: gettext-go-examples-hello\nReport-Msgid-Bugs-To: \nPOT-Creation-Date: 2013-12-12 20:03+0000\nPO-Revision-Date: 2017-06-01 17:54-0700\nLast-Translator: Giri Kuncoro <girikuncoro@gmail.com>\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 8bit\nX-Generator: Poedit 2.0.1\nX-Poedit-SourceCharset: UTF-8\nLanguage-Team: \nPlural-Forms: nplurals=2; plural=(n > 1);\nLanguage: ja\n\x00\u30d5\u30a1\u30a4\u30eb\u540d\u3092\u6307\u5b9a\u307e\u305f\u306f\u6a19\u6e96\u5165\u529b\u7d4c\u7531\u3067\u30ea\u30bd\u30fc\u30b9\u306b\u30b3\u30f3\u30d5\u30a3\u30b0\u3092\u9069\u7528\u3059\u308b\x00kubeconfig\u304b\u3089\u6307\u5b9a\u3057\u305f\u30af\u30e9\u30b9\u30bf\u30fc\u3092\u524a\u9664\u3059\u308b\x00kubeconfig\u304b\u3089\u6307\u5b9a\u3057\u305f\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u3092\u524a\u9664\u3059\u308b\x001\u3064\u307e\u305f\u306f\u8907\u6570\u306e\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u3092\u8a18\u8ff0\u3059\u308b\x00kubeconfig\u3067\u5b9a\u7fa9\u3055\u308c\u305f\u30af\u30e9\u30b9\u30bf\u30fc\u3092\u8868\u793a\u3059\u308b\x00\u30de\u30fc\u30b8\u3055\u308c\u305fkubeconfig\u306e\u8a2d\u5b9a\u307e\u305f\u306f\u6307\u5b9a\u3055\u308c\u305fkubeconfig\u30d5\u30a1\u30a4\u30eb\u3092\u8868\u793a\u3059\u308b\x00\u30ab\u30ec\u30f3\u30c8\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u3092\u8868\u793a\u3059\u308b\x00kubeconfig\u30d5\u30a1\u30a4\u30eb\u3092\u5909\u66f4\u3059\u308b\x00kubeconfig\u306b\u30af\u30e9\u30b9\u30bf\u30fc\u30a8\u30f3\u30c8\u30ea\u3092\u8a2d\u5b9a\u3059\u308b\x00kubeconfig\u306b\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u30a8\u30f3\u30c8\u30ea\u3092\u8a2d\u5b9a\u3059\u308b\x00kubeconfig\u306b\u30e6\u30fc\u30b6\u30fc\u30a8\u30f3\u30c8\u30ea\u3092\u8a2d\u5b9a\u3059\u308b\x00kubeconfig\u30d5\u30a1\u30a4\u30eb\u5185\u306e\u5909\u6570\u3092\u500b\u5225\u306b\u8a2d\u5b9a\u3059\u308b\x00kubeconfig\u306b\u30ab\u30ec\u30f3\u30c8\u30b3\u30f3\u30c6\u30ad\u30b9\u30c8\u3092\u8a2d\u5b9a\u3059\u308b\x00kubeconfig\u30d5\u30a1\u30a4\u30eb\u304b\u3089\u5909\u6570\u3092\u500b\u5225\u306b\u524a\u9664\u3059\u308b\x00\u30ea\u30bd\u30fc\u30b9\u306e\u30a2\u30ce\u30c6\u30fc\u30b7\u30e7\u30f3\u3092\u66f4\u65b0\u3059\u308b\x00watch\u306f\u5358\u4e00\u30ea\u30bd\u30fc\u30b9\u53ca\u3073\u30ea\u30bd\u30fc\u30b9\u30b3\u30ec\u30af\u30b7\u30e7\u30f3\u306e\u307f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u3059 - %d\u500b\u306e\u30ea\u30bd\u30fc\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\x00watch\u306f\u5358\u4e00\u30ea\u30bd\u30fc\u30b9\u53ca\u3073\u30ea\u30bd\u30fc\u30b9\u30b3\u30ec\u30af\u30b7\u30e7\u30f3\u306e\u307f\u30b5\u30dd\u30fc\u30c8\u3057\u3066\u3044\u307e\u3059 - %d\u500b\u306e\u30ea\u30bd\u30fc\u30b9\u304c\u898b\u3064\u304b\u308a\u307e\u3057\u305f\x00")

func translationsKubectlJa_jpLc_messagesK8sMoBytes() ([]byte, error) {
	return _translationsKubectlJa_jpLc_messagesK8sMo, nil
}

func translationsKubectlJa_jpLc_messagesK8sMo() (*asset, error) {
	bytes, err := translationsKubectlJa_jpLc_messagesK8sMoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/ja_JP/LC_MESSAGES/k8s.mo", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlJa_jpLc_messagesK8sPo = []byte(`# Test translations for unit tests.
# Copyright (C) 2017
# This file is distributed under the same license as the PACKAGE package.
# FIRST AUTHOR girikuncoro@gmail.com, 2017.
#
msgid ""
msgstr ""
"Project-Id-Version: gettext-go-examples-hello\n"
"Report-Msgid-Bugs-To: \n"
"POT-Creation-Date: 2013-12-12 20:03+0000\n"
"PO-Revision-Date: 2017-01-29 22:54-0800\n"
"Last-Translator: Giri Kuncoro <girikuncoro@gmail.com>\n"
"MIME-Version: 1.0\n"
"Content-Type: text/plain; charset=UTF-8\n"
"Content-Transfer-Encoding: 8bit\n"
"X-Generator: Poedit 1.6.10\n"
"X-Poedit-SourceCharset: UTF-8\n"
"Language-Team: \n"
"Plural-Forms: nplurals=2; plural=(n > 1);\n"
"Language: ja\n"

# https://github.com/kubernetes/kubernetes/blob/masterpkg/kubectl/cmd/apply.go#L98
msgid "Apply a configuration to a resource by filename or stdin"
msgstr "ファイル名を指定または標準入力経由でリソースにコンフィグを適用する"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/delete_cluster.go#L38
msgid "Delete the specified cluster from the kubeconfig"
msgstr "kubeconfigから指定したクラスターを削除する"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/delete_context.go#L38
msgid "Delete the specified context from the kubeconfig"
msgstr "kubeconfigから指定したコンテキストを削除する"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/get_contexts.go#L62
msgid "Describe one or many contexts"
msgstr "1つまたは複数のコンテキストを記述する"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/get_clusters.go#L40
msgid "Display clusters defined in the kubeconfig"
msgstr "kubeconfigで定義されたクラスターを表示する"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/view.go#L64
msgid "Display merged kubeconfig settings or a specified kubeconfig file"
msgstr "マージされたkubeconfigの設定または指定されたkubeconfigファイルを表示する"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/current_context.go#L48
msgid "Displays the current-context"
msgstr "カレントコンテキストを表示する"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/config.go#L39
msgid "Modify kubeconfig files"
msgstr "kubeconfigファイルを変更する"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_cluster.go#L67
msgid "Sets a cluster entry in kubeconfig"
msgstr "kubeconfigにクラスターエントリを設定する"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_context.go#L57
msgid "Sets a context entry in kubeconfig"
msgstr "kubeconfigにコンテキストエントリを設定する"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/create_authinfo.go#L103
msgid "Sets a user entry in kubeconfig"
msgstr "kubeconfigにユーザーエントリを設定する"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/set.go#L59
msgid "Sets an individual value in a kubeconfig file"
msgstr "kubeconfigファイル内の変数を個別に設定する"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/use_context.go#L48
msgid "Sets the current-context in a kubeconfig file"
msgstr "kubeconfigにカレントコンテキストを設定する"

# https://github.com/kubernetes/kubernetes/blob/master/pkg/kubectl/cmd/config/unset.go#L47
msgid "Unsets an individual value in a kubeconfig file"
msgstr "kubeconfigファイルから変数を個別に削除する"

msgid "Update the annotations on a resource"
msgstr "リソースのアノテーションを更新する"

msgid ""
"watch is only supported on individual resources and resource collections - "
"%d resources were found"
msgid_plural ""
"watch is only supported on individual resources and resource collections - "
"%d resources were found"
msgstr[0] ""
"watchは単一リソース及びリソースコレクションのみサポートしています - "
"%d個のリソースが見つかりました"
msgstr[1] ""
"watchは単一リソース及びリソースコレクションのみサポートしています - "
"%d個のリソースが見つかりました"
`)

func translationsKubectlJa_jpLc_messagesK8sPoBytes() ([]byte, error) {
	return _translationsKubectlJa_jpLc_messagesK8sPo, nil
}

func translationsKubectlJa_jpLc_messagesK8sPo() (*asset, error) {
	bytes, err := translationsKubectlJa_jpLc_messagesK8sPoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/ja_JP/LC_MESSAGES/k8s.po", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlTemplatePot = []byte(`# SOME DESCRIPTIVE TITLE.
# Copyright (C) YEAR THE PACKAGE'S COPYRIGHT HOLDER
# This file is distributed under the same license as the PACKAGE package.
# FIRST AUTHOR <EMAIL@ADDRESS>, YEAR.
#
#, fuzzy
msgid ""
msgstr ""
"Project-Id-Version: \n"
"Report-Msgid-Bugs-To: EMAIL\n"
"POT-Creation-Date: 2017-03-14 21:32-0700\n"
"PO-Revision-Date: YEAR-MO-DA HO:MI+ZONE\n"
"Last-Translator: FULL NAME <EMAIL@ADDRESS>\n"
"Language-Team: LANGUAGE <LL@li.org>\n"
"Language: \n"
"MIME-Version: 1.0\n"
"Content-Type: text/plain; charset=UTF-8\n"
"Content-Transfer-Encoding: 8bit\n"

#: pkg/kubectl/cmd/create_clusterrolebinding.go:35
msgid ""
"\n"
"\t\t  # Create a ClusterRoleBinding for user1, user2, and group1 using the "
"cluster-admin ClusterRole\n"
"\t\t  kubectl create clusterrolebinding cluster-admin --clusterrole=cluster-"
"admin --user=user1 --user=user2 --group=group1"
msgstr ""

#: pkg/kubectl/cmd/create_rolebinding.go:35
msgid ""
"\n"
"\t\t  # Create a RoleBinding for user1, user2, and group1 using the admin "
"ClusterRole\n"
"\t\t  kubectl create rolebinding admin --clusterrole=admin --user=user1 --"
"user=user2 --group=group1"
msgstr ""

#: pkg/kubectl/cmd/create_configmap.go:44
msgid ""
"\n"
"\t\t  # Create a new configmap named my-config based on folder bar\n"
"\t\t  kubectl create configmap my-config --from-file=path/to/bar\n"
"\n"
"\t\t  # Create a new configmap named my-config with specified keys instead "
"of file basenames on disk\n"
"\t\t  kubectl create configmap my-config --from-file=key1=/path/to/bar/file1."
"txt --from-file=key2=/path/to/bar/file2.txt\n"
"\n"
"\t\t  # Create a new configmap named my-config with key1=config1 and "
"key2=config2\n"
"\t\t  kubectl create configmap my-config --from-literal=key1=config1 --from-"
"literal=key2=config2"
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:135
msgid ""
"\n"
"\t\t  # If you don't already have a .dockercfg file, you can create a "
"dockercfg secret directly by using:\n"
"\t\t  kubectl create secret docker-registry my-secret --docker-"
"server=DOCKER_REGISTRY_SERVER --docker-username=DOCKER_USER --docker-"
"password=DOCKER_PASSWORD --docker-email=DOCKER_EMAIL"
msgstr ""

#: pkg/kubectl/cmd/top_node.go:65
msgid ""
"\n"
"\t\t  # Show metrics for all nodes\n"
"\t\t  kubectl top node\n"
"\n"
"\t\t  # Show metrics for a given node\n"
"\t\t  kubectl top node NODE_NAME"
msgstr ""

#: pkg/kubectl/cmd/apply.go:84
msgid ""
"\n"
"\t\t# Apply the configuration in pod.json to a pod.\n"
"\t\tkubectl apply -f ./pod.json\n"
"\n"
"\t\t# Apply the JSON passed into stdin to a pod.\n"
"\t\tcat pod.json | kubectl apply -f -\n"
"\n"
"\t\t# Note: --prune is still in Alpha\n"
"\t\t# Apply the configuration in manifest.yaml that matches label app=nginx "
"and delete all the other resources that are not in the file and match label "
"app=nginx.\n"
"\t\tkubectl apply --prune -f manifest.yaml -l app=nginx\n"
"\n"
"\t\t# Apply the configuration in manifest.yaml and delete all the other "
"configmaps that are not in the file.\n"
"\t\tkubectl apply --prune -f manifest.yaml --all --prune-whitelist=core/v1/"
"ConfigMap"
msgstr ""

#: pkg/kubectl/cmd/autoscale.go:40
#, c-format
msgid ""
"\n"
"\t\t# Auto scale a deployment \"foo\", with the number of pods between 2 and "
"10, target CPU utilization specified so a default autoscaling policy will be "
"used:\n"
"\t\tkubectl autoscale deployment foo --min=2 --max=10\n"
"\n"
"\t\t# Auto scale a replication controller \"foo\", with the number of pods "
"between 1 and 5, target CPU utilization at 80%:\n"
"\t\tkubectl autoscale rc foo --max=5 --cpu-percent=80"
msgstr ""

#: pkg/kubectl/cmd/convert.go:49
msgid ""
"\n"
"\t\t# Convert 'pod.yaml' to latest version and print to stdout.\n"
"\t\tkubectl convert -f pod.yaml\n"
"\n"
"\t\t# Convert the live state of the resource specified by 'pod.yaml' to the "
"latest version\n"
"\t\t# and print to stdout in json format.\n"
"\t\tkubectl convert -f pod.yaml --local -o json\n"
"\n"
"\t\t# Convert all files under current directory to latest version and create "
"them all.\n"
"\t\tkubectl convert -f . | kubectl create -f -"
msgstr ""

#: pkg/kubectl/cmd/create_clusterrole.go:34
msgid ""
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" that allows user to perform "
"\"get\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods\n"
"\n"
"\t\t# Create a ClusterRole named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create clusterrole pod-reader --verb=get,list,watch --"
"resource=pods --resource-name=readablepod"
msgstr ""

#: pkg/kubectl/cmd/create_role.go:41
msgid ""
"\n"
"\t\t# Create a Role named \"pod-reader\" that allows user to perform \"get"
"\", \"watch\" and \"list\" on pods\n"
"\t\tkubectl create role pod-reader --verb=get --verb=list --verb=watch --"
"resource=pods\n"
"\n"
"\t\t# Create a Role named \"pod-reader\" with ResourceName specified\n"
"\t\tkubectl create role pod-reader --verb=get --verg=list --verb=watch --"
"resource=pods --resource-name=readablepod"
msgstr ""

#: pkg/kubectl/cmd/create_quota.go:35
msgid ""
"\n"
"\t\t# Create a new resourcequota named my-quota\n"
"\t\tkubectl create quota my-quota --hard=cpu=1,memory=1G,pods=2,services=3,"
"replicationcontrollers=2,resourcequotas=1,secrets=5,"
"persistentvolumeclaims=10\n"
"\n"
"\t\t# Create a new resourcequota named best-effort\n"
"\t\tkubectl create quota best-effort --hard=pods=100 --scopes=BestEffort"
msgstr ""

#: pkg/kubectl/cmd/create_pdb.go:35
#, c-format
msgid ""
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=rails label\n"
"\t\t# and require at least one of them being available at any point in "
"time.\n"
"\t\tkubectl create poddisruptionbudget my-pdb --selector=app=rails --min-"
"available=1\n"
"\n"
"\t\t# Create a pod disruption budget named my-pdb that will select all pods "
"with the app=nginx label\n"
"\t\t# and require at least half of the pods selected to be available at any "
"point in time.\n"
"\t\tkubectl create pdb my-pdb --selector=app=nginx --min-available=50%"
msgstr ""

#: pkg/kubectl/cmd/create.go:47
msgid ""
"\n"
"\t\t# Create a pod using the data in pod.json.\n"
"\t\tkubectl create -f ./pod.json\n"
"\n"
"\t\t# Create a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl create -f -\n"
"\n"
"\t\t# Edit the data in docker-registry.yaml in JSON using the v1 API format "
"then create the resource using the edited data.\n"
"\t\tkubectl create -f docker-registry.yaml --edit --output-version=v1 -o json"
msgstr ""

#: pkg/kubectl/cmd/expose.go:53
msgid ""
"\n"
"\t\t# Create a service for a replicated nginx, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose rc nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a replication controller identified by type and "
"name specified in \"nginx-controller.yaml\", which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose -f nginx-controller.yaml --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for a pod valid-pod, which serves on port 444 with "
"the name \"frontend\"\n"
"\t\tkubectl expose pod valid-pod --port=444 --name=frontend\n"
"\n"
"\t\t# Create a second service based on the above service, exposing the "
"container port 8443 as port 443 with the name \"nginx-https\"\n"
"\t\tkubectl expose service nginx --port=443 --target-port=8443 --name=nginx-"
"https\n"
"\n"
"\t\t# Create a service for a replicated streaming application on port 4100 "
"balancing UDP traffic and named 'video-stream'.\n"
"\t\tkubectl expose rc streamer --port=4100 --protocol=udp --name=video-"
"stream\n"
"\n"
"\t\t# Create a service for a replicated nginx using replica set, which "
"serves on port 80 and connects to the containers on port 8000.\n"
"\t\tkubectl expose rs nginx --port=80 --target-port=8000\n"
"\n"
"\t\t# Create a service for an nginx deployment, which serves on port 80 and "
"connects to the containers on port 8000.\n"
"\t\tkubectl expose deployment nginx --port=80 --target-port=8000"
msgstr ""

#: pkg/kubectl/cmd/delete.go:68
msgid ""
"\n"
"\t\t# Delete a pod using the type and name specified in pod.json.\n"
"\t\tkubectl delete -f ./pod.json\n"
"\n"
"\t\t# Delete a pod based on the type and name in the JSON passed into "
"stdin.\n"
"\t\tcat pod.json | kubectl delete -f -\n"
"\n"
"\t\t# Delete pods and services with same names \"baz\" and \"foo\"\n"
"\t\tkubectl delete pod,service baz foo\n"
"\n"
"\t\t# Delete pods and services with label name=myLabel.\n"
"\t\tkubectl delete pods,services -l name=myLabel\n"
"\n"
"\t\t# Delete a pod with minimal delay\n"
"\t\tkubectl delete pod foo --now\n"
"\n"
"\t\t# Force delete a pod on a dead node\n"
"\t\tkubectl delete pod foo --grace-period=0 --force\n"
"\n"
"\t\t# Delete all pods\n"
"\t\tkubectl delete pods --all"
msgstr ""

#: pkg/kubectl/cmd/describe.go:54
msgid ""
"\n"
"\t\t# Describe a node\n"
"\t\tkubectl describe nodes kubernetes-node-emt8.c.myproject.internal\n"
"\n"
"\t\t# Describe a pod\n"
"\t\tkubectl describe pods/nginx\n"
"\n"
"\t\t# Describe a pod identified by type and name in \"pod.json\"\n"
"\t\tkubectl describe -f pod.json\n"
"\n"
"\t\t# Describe all pods\n"
"\t\tkubectl describe pods\n"
"\n"
"\t\t# Describe pods by label name=myLabel\n"
"\t\tkubectl describe po -l name=myLabel\n"
"\n"
"\t\t# Describe all pods managed by the 'frontend' replication controller (rc-"
"created pods\n"
"\t\t# get the name of the rc as a prefix in the pod the name).\n"
"\t\tkubectl describe pods frontend"
msgstr ""

#: pkg/kubectl/cmd/drain.go:165
msgid ""
"\n"
"\t\t# Drain node \"foo\", even if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet on it.\n"
"\t\t$ kubectl drain foo --force\n"
"\n"
"\t\t# As above, but abort if there are pods not managed by a "
"ReplicationController, ReplicaSet, Job, DaemonSet or StatefulSet, and use a "
"grace period of 15 minutes.\n"
"\t\t$ kubectl drain foo --grace-period=900"
msgstr ""

#: pkg/kubectl/cmd/edit.go:80
msgid ""
"\n"
"\t\t# Edit the service named 'docker-registry':\n"
"\t\tkubectl edit svc/docker-registry\n"
"\n"
"\t\t# Use an alternative editor\n"
"\t\tKUBE_EDITOR=\"nano\" kubectl edit svc/docker-registry\n"
"\n"
"\t\t# Edit the job 'myjob' in JSON using the v1 API format:\n"
"\t\tkubectl edit job.v1.batch/myjob -o json\n"
"\n"
"\t\t# Edit the deployment 'mydeployment' in YAML and save the modified "
"config in its annotation:\n"
"\t\tkubectl edit deployment/mydeployment -o yaml --save-config"
msgstr ""

#: pkg/kubectl/cmd/exec.go:41
msgid ""
"\n"
"\t\t# Get output from running 'date' from pod 123456-7890, using the first "
"container by default\n"
"\t\tkubectl exec 123456-7890 date\n"
"\n"
"\t\t# Get output from running 'date' in ruby-container from pod 123456-7890\n"
"\t\tkubectl exec 123456-7890 -c ruby-container date\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl exec 123456-7890 -c ruby-container -i -t -- bash -il"
msgstr ""

#: pkg/kubectl/cmd/attach.go:42
msgid ""
"\n"
"\t\t# Get output from running pod 123456-7890, using the first container by "
"default\n"
"\t\tkubectl attach 123456-7890\n"
"\n"
"\t\t# Get output from ruby-container from pod 123456-7890\n"
"\t\tkubectl attach 123456-7890 -c ruby-container\n"
"\n"
"\t\t# Switch to raw terminal mode, sends stdin to 'bash' in ruby-container "
"from pod 123456-7890\n"
"\t\t# and sends stdout/stderr from 'bash' back to the client\n"
"\t\tkubectl attach 123456-7890 -c ruby-container -i -t\n"
"\n"
"\t\t# Get output from the first pod of a ReplicaSet named nginx\n"
"\t\tkubectl attach rs/nginx\n"
"\t\t"
msgstr ""

#: pkg/kubectl/cmd/explain.go:39
msgid ""
"\n"
"\t\t# Get the documentation of the resource and its fields\n"
"\t\tkubectl explain pods\n"
"\n"
"\t\t# Get the documentation of a specific field of a resource\n"
"\t\tkubectl explain pods.spec.containers"
msgstr ""

#: pkg/kubectl/cmd/completion.go:65
msgid ""
"\n"
"\t\t# Install bash completion on a Mac using homebrew\n"
"\t\tbrew install bash-completion\n"
"\t\tprintf \"\n"
"# Bash completion support\n"
"source $(brew --prefix)/etc/bash_completion\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for bash into the current shell\n"
"\t\tsource <(kubectl completion bash)\n"
"\n"
"\t\t# Write bash completion code to a file and source if from .bash_profile\n"
"\t\tkubectl completion bash > ~/.kube/completion.bash.inc\n"
"\t\tprintf \"\n"
"# Kubectl shell completion\n"
"source '$HOME/.kube/completion.bash.inc'\n"
"\" >> $HOME/.bash_profile\n"
"\t\tsource $HOME/.bash_profile\n"
"\n"
"\t\t# Load the kubectl completion code for zsh[1] into the current shell\n"
"\t\tsource <(kubectl completion zsh)"
msgstr ""

#: pkg/kubectl/cmd/get.go:64
msgid ""
"\n"
"\t\t# List all pods in ps output format.\n"
"\t\tkubectl get pods\n"
"\n"
"\t\t# List all pods in ps output format with more information (such as node "
"name).\n"
"\t\tkubectl get pods -o wide\n"
"\n"
"\t\t# List a single replication controller with specified NAME in ps output "
"format.\n"
"\t\tkubectl get replicationcontroller web\n"
"\n"
"\t\t# List a single pod in JSON output format.\n"
"\t\tkubectl get -o json pod web-pod-13je7\n"
"\n"
"\t\t# List a pod identified by type and name specified in \"pod.yaml\" in "
"JSON output format.\n"
"\t\tkubectl get -f pod.yaml -o json\n"
"\n"
"\t\t# Return only the phase value of the specified pod.\n"
"\t\tkubectl get -o template pod/web-pod-13je7 --template={{.status.phase}}\n"
"\n"
"\t\t# List all replication controllers and services together in ps output "
"format.\n"
"\t\tkubectl get rc,services\n"
"\n"
"\t\t# List one or more resources by their type and names.\n"
"\t\tkubectl get rc/web service/frontend pods/web-pod-13je7\n"
"\n"
"\t\t# List all resources with different types.\n"
"\t\tkubectl get all"
msgstr ""

#: pkg/kubectl/cmd/portforward.go:53
msgid ""
"\n"
"\t\t# Listen on ports 5000 and 6000 locally, forwarding data to/from ports "
"5000 and 6000 in the pod\n"
"\t\tkubectl port-forward mypod 5000 6000\n"
"\n"
"\t\t# Listen on port 8888 locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 8888:5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod :5000\n"
"\n"
"\t\t# Listen on a random port locally, forwarding to 5000 in the pod\n"
"\t\tkubectl port-forward mypod 0:5000"
msgstr ""

#: pkg/kubectl/cmd/drain.go:118
msgid ""
"\n"
"\t\t# Mark node \"foo\" as schedulable.\n"
"\t\t$ kubectl uncordon foo"
msgstr ""

#: pkg/kubectl/cmd/drain.go:93
msgid ""
"\n"
"\t\t# Mark node \"foo\" as unschedulable.\n"
"\t\tkubectl cordon foo"
msgstr ""

#: pkg/kubectl/cmd/patch.go:66
msgid ""
"\n"
"\t\t# Partially update a node using strategic merge patch\n"
"\t\tkubectl patch node k8s-node-1 -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Partially update a node identified by the type and name specified in "
"\"node.json\" using strategic merge patch\n"
"\t\tkubectl patch -f node.json -p '{\"spec\":{\"unschedulable\":true}}'\n"
"\n"
"\t\t# Update a container's image; spec.containers[*].name is required "
"because it's a merge key\n"
"\t\tkubectl patch pod valid-pod -p '{\"spec\":{\"containers\":[{\"name\":"
"\"kubernetes-serve-hostname\",\"image\":\"new image\"}]}}'\n"
"\n"
"\t\t# Update a container's image using a json patch with positional arrays\n"
"\t\tkubectl patch pod valid-pod --type='json' -p='[{\"op\": \"replace\", "
"\"path\": \"/spec/containers/0/image\", \"value\":\"new image\"}]'"
msgstr ""

#: pkg/kubectl/cmd/options.go:29
msgid ""
"\n"
"\t\t# Print flags inherited by all commands\n"
"\t\tkubectl options"
msgstr ""

#: pkg/kubectl/cmd/clusterinfo.go:41
msgid ""
"\n"
"\t\t# Print the address of the master and cluster services\n"
"\t\tkubectl cluster-info"
msgstr ""

#: pkg/kubectl/cmd/version.go:32
msgid ""
"\n"
"\t\t# Print the client and server versions for the current context\n"
"\t\tkubectl version"
msgstr ""

#: pkg/kubectl/cmd/apiversions.go:34
msgid ""
"\n"
"\t\t# Print the supported API versions\n"
"\t\tkubectl api-versions"
msgstr ""

#: pkg/kubectl/cmd/replace.go:50
msgid ""
"\n"
"\t\t# Replace a pod using the data in pod.json.\n"
"\t\tkubectl replace -f ./pod.json\n"
"\n"
"\t\t# Replace a pod based on the JSON passed into stdin.\n"
"\t\tcat pod.json | kubectl replace -f -\n"
"\n"
"\t\t# Update a single-container pod's image version (tag) to v4\n"
"\t\tkubectl get pod mypod -o yaml | sed 's/\\(image: myimage\\):.*$/:v4/' | "
"kubectl replace -f -\n"
"\n"
"\t\t# Force replace, delete and then re-create the resource\n"
"\t\tkubectl replace --force -f ./pod.json"
msgstr ""

#: pkg/kubectl/cmd/logs.go:40
msgid ""
"\n"
"\t\t# Return snapshot logs from pod nginx with only one container\n"
"\t\tkubectl logs nginx\n"
"\n"
"\t\t# Return snapshot logs for the pods defined by label app=nginx\n"
"\t\tkubectl logs -lapp=nginx\n"
"\n"
"\t\t# Return snapshot of previous terminated ruby container logs from pod "
"web-1\n"
"\t\tkubectl logs -p -c ruby web-1\n"
"\n"
"\t\t# Begin streaming the logs of the ruby container in pod web-1\n"
"\t\tkubectl logs -f -c ruby web-1\n"
"\n"
"\t\t# Display only the most recent 20 lines of output in pod nginx\n"
"\t\tkubectl logs --tail=20 nginx\n"
"\n"
"\t\t# Show all logs from pod nginx written in the last hour\n"
"\t\tkubectl logs --since=1h nginx\n"
"\n"
"\t\t# Return snapshot logs from first container of a job named hello\n"
"\t\tkubectl logs job/hello\n"
"\n"
"\t\t# Return snapshot logs from container nginx-1 of a deployment named "
"nginx\n"
"\t\tkubectl logs deployment/nginx -c nginx-1"
msgstr ""

#: pkg/kubectl/cmd/proxy.go:53
msgid ""
"\n"
"\t\t# Run a proxy to kubernetes apiserver on port 8011, serving static "
"content from ./local/www/\n"
"\t\tkubectl proxy --port=8011 --www=./local/www/\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver on an arbitrary local port.\n"
"\t\t# The chosen port for the server will be output to stdout.\n"
"\t\tkubectl proxy --port=0\n"
"\n"
"\t\t# Run a proxy to kubernetes apiserver, changing the api prefix to k8s-"
"api\n"
"\t\t# This makes e.g. the pods api available at localhost:8001/k8s-api/v1/"
"pods/\n"
"\t\tkubectl proxy --api-prefix=/k8s-api"
msgstr ""

#: pkg/kubectl/cmd/scale.go:43
msgid ""
"\n"
"\t\t# Scale a replicaset named 'foo' to 3.\n"
"\t\tkubectl scale --replicas=3 rs/foo\n"
"\n"
"\t\t# Scale a resource identified by type and name specified in \"foo.yaml\" "
"to 3.\n"
"\t\tkubectl scale --replicas=3 -f foo.yaml\n"
"\n"
"\t\t# If the deployment named mysql's current size is 2, scale mysql to 3.\n"
"\t\tkubectl scale --current-replicas=2 --replicas=3 deployment/mysql\n"
"\n"
"\t\t# Scale multiple replication controllers.\n"
"\t\tkubectl scale --replicas=5 rc/foo rc/bar rc/baz\n"
"\n"
"\t\t# Scale job named 'cron' to 3.\n"
"\t\tkubectl scale --replicas=3 job/cron"
msgstr ""

#: pkg/kubectl/cmd/apply_set_last_applied.go:67
msgid ""
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml\n"
"\n"
"\t\t# Execute set-last-applied against each configuration file in a "
"directory.\n"
"\t\tkubectl apply set-last-applied -f path/\n"
"\n"
"\t\t# Set the last-applied-configuration of a resource to match the contents "
"of a file, will create the annotation if it does not already exist.\n"
"\t\tkubectl apply set-last-applied -f deploy.yaml --create-annotation=true\n"
"\t\t"
msgstr ""

#: pkg/kubectl/cmd/top_pod.go:61
msgid ""
"\n"
"\t\t# Show metrics for all pods in the default namespace\n"
"\t\tkubectl top pod\n"
"\n"
"\t\t# Show metrics for all pods in the given namespace\n"
"\t\tkubectl top pod --namespace=NAMESPACE\n"
"\n"
"\t\t# Show metrics for a given pod and its containers\n"
"\t\tkubectl top pod POD_NAME --containers\n"
"\n"
"\t\t# Show metrics for the pods defined by label name=myLabel\n"
"\t\tkubectl top pod -l name=myLabel"
msgstr ""

#: pkg/kubectl/cmd/stop.go:40
msgid ""
"\n"
"\t\t# Shut down foo.\n"
"\t\tkubectl stop replicationcontroller foo\n"
"\n"
"\t\t# Stop pods and services with label name=myLabel.\n"
"\t\tkubectl stop pods,services -l name=myLabel\n"
"\n"
"\t\t# Shut down the service defined in service.json\n"
"\t\tkubectl stop -f service.json\n"
"\n"
"\t\t# Shut down all resources in the path/to/resources directory\n"
"\t\tkubectl stop -f path/to/resources"
msgstr ""

#: pkg/kubectl/cmd/run.go:57
msgid ""
"\n"
"\t\t# Start a single instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx\n"
"\n"
"\t\t# Start a single instance of hazelcast and let the container expose port "
"5701 .\n"
"\t\tkubectl run hazelcast --image=hazelcast --port=5701\n"
"\n"
"\t\t# Start a single instance of hazelcast and set environment variables "
"\"DNS_DOMAIN=cluster\" and \"POD_NAMESPACE=default\" in the container.\n"
"\t\tkubectl run hazelcast --image=hazelcast --env=\"DNS_DOMAIN=cluster\" --"
"env=\"POD_NAMESPACE=default\"\n"
"\n"
"\t\t# Start a replicated instance of nginx.\n"
"\t\tkubectl run nginx --image=nginx --replicas=5\n"
"\n"
"\t\t# Dry run. Print the corresponding API objects without creating them.\n"
"\t\tkubectl run nginx --image=nginx --dry-run\n"
"\n"
"\t\t# Start a single instance of nginx, but overload the spec of the "
"deployment with a partial set of values parsed from JSON.\n"
"\t\tkubectl run nginx --image=nginx --overrides='{ \"apiVersion\": \"v1\", "
"\"spec\": { ... } }'\n"
"\n"
"\t\t# Start a pod of busybox and keep it in the foreground, don't restart it "
"if it exits.\n"
"\t\tkubectl run -i -t busybox --image=busybox --restart=Never\n"
"\n"
"\t\t# Start the nginx container using the default command, but use custom "
"arguments (arg1 .. argN) for that command.\n"
"\t\tkubectl run nginx --image=nginx -- <arg1> <arg2> ... <argN>\n"
"\n"
"\t\t# Start the nginx container using a different command and custom "
"arguments.\n"
"\t\tkubectl run nginx --image=nginx --command -- <cmd> <arg1> ... <argN>\n"
"\n"
"\t\t# Start the perl container to compute π to 2000 places and print it "
"out.\n"
"\t\tkubectl run pi --image=perl --restart=OnFailure -- perl -Mbignum=bpi -"
"wle 'print bpi(2000)'\n"
"\n"
"\t\t# Start the cron job to compute π to 2000 places and print it out every "
"5 minutes.\n"
"\t\tkubectl run pi --schedule=\"0/5 * * * ?\" --image=perl --"
"restart=OnFailure -- perl -Mbignum=bpi -wle 'print bpi(2000)'"
msgstr ""

#: pkg/kubectl/cmd/taint.go:67
msgid ""
"\n"
"\t\t# Update node 'foo' with a taint with key 'dedicated' and value 'special-"
"user' and effect 'NoSchedule'.\n"
"\t\t# If a taint with that key and effect already exists, its value is "
"replaced as specified.\n"
"\t\tkubectl taint nodes foo dedicated=special-user:NoSchedule\n"
"\n"
"\t\t# Remove from node 'foo' the taint with key 'dedicated' and effect "
"'NoSchedule' if one exists.\n"
"\t\tkubectl taint nodes foo dedicated:NoSchedule-\n"
"\n"
"\t\t# Remove from node 'foo' all the taints with key 'dedicated'\n"
"\t\tkubectl taint nodes foo dedicated-"
msgstr ""

#: pkg/kubectl/cmd/label.go:77
msgid ""
"\n"
"\t\t# Update pod 'foo' with the label 'unhealthy' and the value 'true'.\n"
"\t\tkubectl label pods foo unhealthy=true\n"
"\n"
"\t\t# Update pod 'foo' with the label 'status' and the value 'unhealthy', "
"overwriting any existing value.\n"
"\t\tkubectl label --overwrite pods foo status=unhealthy\n"
"\n"
"\t\t# Update all pods in the namespace\n"
"\t\tkubectl label pods --all status=unhealthy\n"
"\n"
"\t\t# Update a pod identified by the type and name in \"pod.json\"\n"
"\t\tkubectl label -f pod.json status=unhealthy\n"
"\n"
"\t\t# Update pod 'foo' only if the resource is unchanged from version 1.\n"
"\t\tkubectl label pods foo status=unhealthy --resource-version=1\n"
"\n"
"\t\t# Update pod 'foo' by removing a label named 'bar' if it exists.\n"
"\t\t# Does not require the --overwrite flag.\n"
"\t\tkubectl label pods foo bar-"
msgstr ""

#: pkg/kubectl/cmd/rollingupdate.go:54
msgid ""
"\n"
"\t\t# Update pods of frontend-v1 using new replication controller data in "
"frontend-v2.json.\n"
"\t\tkubectl rolling-update frontend-v1 -f frontend-v2.json\n"
"\n"
"\t\t# Update pods of frontend-v1 using JSON data passed into stdin.\n"
"\t\tcat frontend-v2.json | kubectl rolling-update frontend-v1 -f -\n"
"\n"
"\t\t# Update the pods of frontend-v1 to frontend-v2 by just changing the "
"image, and switching the\n"
"\t\t# name of the replication controller.\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --image=image:v2\n"
"\n"
"\t\t# Update the pods of frontend by just changing the image, and keeping "
"the old name.\n"
"\t\tkubectl rolling-update frontend --image=image:v2\n"
"\n"
"\t\t# Abort and reverse an existing rollout in progress (from frontend-v1 to "
"frontend-v2).\n"
"\t\tkubectl rolling-update frontend-v1 frontend-v2 --rollback"
msgstr ""

#: pkg/kubectl/cmd/apply_view_last_applied.go:52
msgid ""
"\n"
"\t\t# View the last-applied-configuration annotations by type/name in YAML.\n"
"\t\tkubectl apply view-last-applied deployment/nginx\n"
"\n"
"\t\t# View the last-applied-configuration annotations by file in JSON\n"
"\t\tkubectl apply view-last-applied -f deploy.yaml -o json"
msgstr ""

#: pkg/kubectl/cmd/apply.go:75
msgid ""
"\n"
"\t\tApply a configuration to a resource by filename or stdin.\n"
"\t\tThis resource will be created if it doesn't exist yet.\n"
"\t\tTo use 'apply', always create the resource initially with either 'apply' "
"or 'create --save-config'.\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tAlpha Disclaimer: the --prune functionality is not yet complete. Do not "
"use unless you are aware of what the current state is. See https://issues."
"k8s.io/34274."
msgstr ""

#: pkg/kubectl/cmd/convert.go:38
msgid ""
"\n"
"\t\tConvert config files between different API versions. Both YAML\n"
"\t\tand JSON formats are accepted.\n"
"\n"
"\t\tThe command takes filename, directory, or URL as input, and convert it "
"into format\n"
"\t\tof version specified by --output-version flag. If target version is not "
"specified or\n"
"\t\tnot supported, convert to latest version.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change to output destination."
msgstr ""

#: pkg/kubectl/cmd/create_clusterrole.go:31
msgid ""
"\n"
"\t\tCreate a ClusterRole."
msgstr ""

#: pkg/kubectl/cmd/create_clusterrolebinding.go:32
msgid ""
"\n"
"\t\tCreate a ClusterRoleBinding for a particular ClusterRole."
msgstr ""

#: pkg/kubectl/cmd/create_rolebinding.go:32
msgid ""
"\n"
"\t\tCreate a RoleBinding for a particular Role or ClusterRole."
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:200
msgid ""
"\n"
"\t\tCreate a TLS secret from the given public/private key pair.\n"
"\n"
"\t\tThe public/private key pair must exist before hand. The public key "
"certificate must be .PEM encoded and match the given private key."
msgstr ""

#: pkg/kubectl/cmd/create_configmap.go:32
msgid ""
"\n"
"\t\tCreate a configmap based on a file, directory, or specified literal "
"value.\n"
"\n"
"\t\tA single configmap may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a configmap based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a configmap based on a directory, each file whose basename "
"is a valid key in the directory will be\n"
"\t\tpackaged into the configmap.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."
msgstr ""

#: pkg/kubectl/cmd/create_namespace.go:32
msgid ""
"\n"
"\t\tCreate a namespace with the specified name."
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:119
msgid ""
"\n"
"\t\tCreate a new secret for use with Docker registries.\n"
"\n"
"\t\tDockercfg secrets are used to authenticate against Docker registries.\n"
"\n"
"\t\tWhen using the Docker command line to push images, you can authenticate "
"to a given registry by running\n"
"\n"
"\t\t    $ docker login DOCKER_REGISTRY_SERVER --username=DOCKER_USER --"
"password=DOCKER_PASSWORD --email=DOCKER_EMAIL'.\n"
"\n"
"    That produces a ~/.dockercfg file that is used by subsequent 'docker "
"push' and 'docker pull' commands to\n"
"\t\tauthenticate to the registry. The email address is optional.\n"
"\n"
"\t\tWhen creating applications, you may have a Docker registry that requires "
"authentication.  In order for the\n"
"\t\tnodes to pull images on your behalf, they have to have the credentials.  "
"You can provide this information\n"
"\t\tby creating a dockercfg secret and attaching it to your service account."
msgstr ""

#: pkg/kubectl/cmd/create_pdb.go:32
msgid ""
"\n"
"\t\tCreate a pod disruption budget with the specified name, selector, and "
"desired minimum available pods"
msgstr ""

#: pkg/kubectl/cmd/create.go:42
msgid ""
"\n"
"\t\tCreate a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted."
msgstr ""

#: pkg/kubectl/cmd/create_quota.go:32
msgid ""
"\n"
"\t\tCreate a resourcequota with the specified name, hard limits and optional "
"scopes"
msgstr ""

#: pkg/kubectl/cmd/create_role.go:38
msgid ""
"\n"
"\t\tCreate a role with single rule."
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:47
msgid ""
"\n"
"\t\tCreate a secret based on a file, directory, or specified literal value.\n"
"\n"
"\t\tA single secret may package one or more key/value pairs.\n"
"\n"
"\t\tWhen creating a secret based on a file, the key will default to the "
"basename of the file, and the value will\n"
"\t\tdefault to the file content.  If the basename is an invalid key, you may "
"specify an alternate key.\n"
"\n"
"\t\tWhen creating a secret based on a directory, each file whose basename is "
"a valid key in the directory will be\n"
"\t\tpackaged into the secret.  Any directory entries except regular files "
"are ignored (e.g. subdirectories,\n"
"\t\tsymlinks, devices, pipes, etc)."
msgstr ""

#: pkg/kubectl/cmd/create_serviceaccount.go:32
msgid ""
"\n"
"\t\tCreate a service account with the specified name."
msgstr ""

#: pkg/kubectl/cmd/run.go:52
msgid ""
"\n"
"\t\tCreate and run a particular image, possibly replicated.\n"
"\n"
"\t\tCreates a deployment or job to manage the created container(s)."
msgstr ""

#: pkg/kubectl/cmd/autoscale.go:34
msgid ""
"\n"
"\t\tCreates an autoscaler that automatically chooses and sets the number of "
"pods that run in a kubernetes cluster.\n"
"\n"
"\t\tLooks up a Deployment, ReplicaSet, or ReplicationController by name and "
"creates an autoscaler that uses the given resource as a reference.\n"
"\t\tAn autoscaler can automatically increase or decrease number of pods "
"deployed within the system as needed."
msgstr ""

#: pkg/kubectl/cmd/delete.go:40
msgid ""
"\n"
"\t\tDelete resources by filenames, stdin, resources and names, or by "
"resources and label selector.\n"
"\n"
"\t\tJSON and YAML formats are accepted. Only one type of the arguments may "
"be specified: filenames,\n"
"\t\tresources and names, or resources and label selector.\n"
"\n"
"\t\tSome resources, such as pods, support graceful deletion. These resources "
"define a default period\n"
"\t\tbefore they are forcibly terminated (the grace period) but you may "
"override that value with\n"
"\t\tthe --grace-period flag, or pass --now to set a grace-period of 1. "
"Because these resources often\n"
"\t\trepresent entities in the cluster, deletion may not be acknowledged "
"immediately. If the node\n"
"\t\thosting a pod is down or cannot reach the API server, termination may "
"take significantly longer\n"
"\t\tthan the grace period. To force delete a resource,\tyou must pass a grace"
"\tperiod of 0 and specify\n"
"\t\tthe --force flag.\n"
"\n"
"\t\tIMPORTANT: Force deleting pods does not wait for confirmation that the "
"pod's processes have been\n"
"\t\tterminated, which can leave those processes running until the node "
"detects the deletion and\n"
"\t\tcompletes graceful deletion. If your processes use shared storage or "
"talk to a remote API and\n"
"\t\tdepend on the name of the pod to identify themselves, force deleting "
"those pods may result in\n"
"\t\tmultiple processes running on different machines using the same "
"identification which may lead\n"
"\t\tto data corruption or inconsistency. Only force delete pods when you are "
"sure the pod is\n"
"\t\tterminated, or if your application can tolerate multiple copies of the "
"same pod running at once.\n"
"\t\tAlso, if you force delete pods the scheduler may place new pods on those "
"nodes before the node\n"
"\t\thas released those resources and causing those pods to be evicted "
"immediately.\n"
"\n"
"\t\tNote that the delete command does NOT do resource version checks, so if "
"someone\n"
"\t\tsubmits an update to a resource right when you submit a delete, their "
"update\n"
"\t\twill be lost along with the rest of the resource."
msgstr ""

#: pkg/kubectl/cmd/stop.go:31
msgid ""
"\n"
"\t\tDeprecated: Gracefully shut down a resource by name or filename.\n"
"\n"
"\t\tThe stop command is deprecated, all its functionalities are covered by "
"delete command.\n"
"\t\tSee 'kubectl delete --help' for more details.\n"
"\n"
"\t\tAttempts to shut down and delete a resource that supports graceful "
"termination.\n"
"\t\tIf the resource is scalable it will be scaled to 0 before deletion."
msgstr ""

#: pkg/kubectl/cmd/top_node.go:60
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of nodes.\n"
"\n"
"\t\tThe top-node command allows you to see the resource consumption of nodes."
msgstr ""

#: pkg/kubectl/cmd/top_pod.go:53
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage of pods.\n"
"\n"
"\t\tThe 'top pod' command allows you to see the resource consumption of "
"pods.\n"
"\n"
"\t\tDue to the metrics pipeline delay, they may be unavailable for a few "
"minutes\n"
"\t\tsince pod creation."
msgstr ""

#: pkg/kubectl/cmd/top.go:33
msgid ""
"\n"
"\t\tDisplay Resource (CPU/Memory/Storage) usage.\n"
"\n"
"\t\tThe top command allows you to see the resource consumption for nodes or "
"pods.\n"
"\n"
"\t\tThis command requires Heapster to be correctly configured and working on "
"the server. "
msgstr ""

#: pkg/kubectl/cmd/drain.go:140
msgid ""
"\n"
"\t\tDrain node in preparation for maintenance.\n"
"\n"
"\t\tThe given node will be marked unschedulable to prevent new pods from "
"arriving.\n"
"\t\t'drain' evicts the pods if the APIServer supports eviction\n"
"\t\t(http://kubernetes.io/docs/admin/disruptions/). Otherwise, it will use "
"normal DELETE\n"
"\t\tto delete the pods.\n"
"\t\tThe 'drain' evicts or deletes all pods except mirror pods (which cannot "
"be deleted through\n"
"\t\tthe API server).  If there are DaemonSet-managed pods, drain will not "
"proceed\n"
"\t\twithout --ignore-daemonsets, and regardless it will not delete any\n"
"\t\tDaemonSet-managed pods, because those pods would be immediately replaced "
"by the\n"
"\t\tDaemonSet controller, which ignores unschedulable markings.  If there "
"are any\n"
"\t\tpods that are neither mirror pods nor managed by ReplicationController,\n"
"\t\tReplicaSet, DaemonSet, StatefulSet or Job, then drain will not delete "
"any pods unless you\n"
"\t\tuse --force.  --force will also allow deletion to proceed if the "
"managing resource of one\n"
"\t\tor more pods is missing.\n"
"\n"
"\t\t'drain' waits for graceful termination. You should not operate on the "
"machine until\n"
"\t\tthe command completes.\n"
"\n"
"\t\tWhen you are ready to put the node back into service, use kubectl "
"uncordon, which\n"
"\t\twill make the node schedulable again.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_drain.svg)"
msgstr ""

#: pkg/kubectl/cmd/edit.go:56
msgid ""
"\n"
"\t\tEdit a resource from the default editor.\n"
"\n"
"\t\tThe edit command allows you to directly edit any API resource you can "
"retrieve via the\n"
"\t\tcommand line tools. It will open the editor defined by your KUBE_EDITOR, "
"or EDITOR\n"
"\t\tenvironment variables, or fall back to 'vi' for Linux or 'notepad' for "
"Windows.\n"
"\t\tYou can edit multiple objects, although changes are applied one at a "
"time. The command\n"
"\t\taccepts filenames as well as command line arguments, although the files "
"you point to must\n"
"\t\tbe previously saved versions of resources.\n"
"\n"
"\t\tEditing is done with the API version used to fetch the resource.\n"
"\t\tTo edit using a specific API version, fully-qualify the resource, "
"version, and group.\n"
"\n"
"\t\tThe default format is YAML. To edit in JSON, specify \"-o json\".\n"
"\n"
"\t\tThe flag --windows-line-endings can be used to force Windows line "
"endings,\n"
"\t\totherwise the default for your operating system will be used.\n"
"\n"
"\t\tIn the event an error occurs while updating, a temporary file will be "
"created on disk\n"
"\t\tthat contains your unapplied changes. The most common error when "
"updating a resource\n"
"\t\tis another editor changing the resource on the server. When this occurs, "
"you will have\n"
"\t\tto apply your changes to the newer version of the resource, or update "
"your temporary\n"
"\t\tsaved copy to include the latest resource version."
msgstr ""

#: pkg/kubectl/cmd/drain.go:115
msgid ""
"\n"
"\t\tMark node as schedulable."
msgstr ""

#: pkg/kubectl/cmd/drain.go:90
msgid ""
"\n"
"\t\tMark node as unschedulable."
msgstr ""

#: pkg/kubectl/cmd/completion.go:47
msgid ""
"\n"
"\t\tOutput shell completion code for the specified shell (bash or zsh).\n"
"\t\tThe shell code must be evalutated to provide interactive\n"
"\t\tcompletion of kubectl commands.  This can be done by sourcing it from\n"
"\t\tthe .bash_profile.\n"
"\n"
"\t\tNote: this requires the bash-completion framework, which is not "
"installed\n"
"\t\tby default on Mac.  This can be installed by using homebrew:\n"
"\n"
"\t\t    $ brew install bash-completion\n"
"\n"
"\t\tOnce installed, bash_completion must be evaluated.  This can be done by "
"adding the\n"
"\t\tfollowing line to the .bash_profile\n"
"\n"
"\t\t    $ source $(brew --prefix)/etc/bash_completion\n"
"\n"
"\t\tNote for zsh users: [1] zsh completions are only supported in versions "
"of zsh >= 5.2"
msgstr ""

#: pkg/kubectl/cmd/rollingupdate.go:45
msgid ""
"\n"
"\t\tPerform a rolling update of the given ReplicationController.\n"
"\n"
"\t\tReplaces the specified replication controller with a new replication "
"controller by updating one pod at a time to use the\n"
"\t\tnew PodTemplate. The new-controller.json must specify the same namespace "
"as the\n"
"\t\texisting replication controller and overwrite at least one (common) "
"label in its replicaSelector.\n"
"\n"
"\t\t![Workflow](http://kubernetes.io/images/docs/kubectl_rollingupdate.svg)"
msgstr ""

#: pkg/kubectl/cmd/replace.go:40
msgid ""
"\n"
"\t\tReplace a resource by filename or stdin.\n"
"\n"
"\t\tJSON and YAML formats are accepted. If replacing an existing resource, "
"the\n"
"\t\tcomplete resource spec must be provided. This can be obtained by\n"
"\n"
"\t\t    $ kubectl get TYPE NAME -o yaml\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."
msgstr ""

#: pkg/kubectl/cmd/scale.go:34
msgid ""
"\n"
"\t\tSet a new size for a Deployment, ReplicaSet, Replication Controller, or "
"Job.\n"
"\n"
"\t\tScale also allows users to specify one or more preconditions for the "
"scale action.\n"
"\n"
"\t\tIf --current-replicas or --resource-version is specified, it is "
"validated before the\n"
"\t\tscale is attempted, and it is guaranteed that the precondition holds "
"true when the\n"
"\t\tscale is sent to the server."
msgstr ""

#: pkg/kubectl/cmd/apply_set_last_applied.go:62
msgid ""
"\n"
"\t\tSet the latest last-applied-configuration annotations by setting it to "
"match the contents of a file.\n"
"\t\tThis results in the last-applied-configuration being updated as though "
"'kubectl apply -f <file>' was run,\n"
"\t\twithout updating any other parts of the object."
msgstr ""

#: pkg/kubectl/cmd/proxy.go:36
msgid ""
"\n"
"\t\tTo proxy all of the kubernetes api and nothing else, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/\n"
"\n"
"\t\tTo proxy only part of the kubernetes api and also some static files:\n"
"\n"
"\t\t    $ kubectl proxy --www=/my/files --www-prefix=/static/ --api-prefix=/"
"api/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/api/v1/pods'.\n"
"\n"
"\t\tTo proxy the entire kubernetes api at a different root, use:\n"
"\n"
"\t\t    $ kubectl proxy --api-prefix=/custom/\n"
"\n"
"\t\tThe above lets you 'curl localhost:8001/custom/api/v1/pods'"
msgstr ""

#: pkg/kubectl/cmd/patch.go:59
msgid ""
"\n"
"\t\tUpdate field(s) of a resource using strategic merge patch\n"
"\n"
"\t\tJSON and YAML formats are accepted.\n"
"\n"
"\t\tPlease refer to the models in https://htmlpreview.github.io/?https://"
"github.com/kubernetes/kubernetes/blob/HEAD/docs/api-reference/v1/definitions."
"html to find if a field is mutable."
msgstr ""

#: pkg/kubectl/cmd/label.go:70
#, c-format
msgid ""
"\n"
"\t\tUpdate the labels on a resource.\n"
"\n"
"\t\t* A label must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* If --overwrite is true, then existing labels can be overwritten, "
"otherwise attempting to overwrite a label will result in an error.\n"
"\t\t* If --resource-version is specified, then updates will use this "
"resource version, otherwise the existing resource-version will be used."
msgstr ""

#: pkg/kubectl/cmd/taint.go:58
#, c-format
msgid ""
"\n"
"\t\tUpdate the taints on one or more nodes.\n"
"\n"
"\t\t* A taint consists of a key, value, and effect. As an argument here, it "
"is expressed as key=value:effect.\n"
"\t\t* The key must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[1]d characters.\n"
"\t\t* The value must begin with a letter or number, and may contain letters, "
"numbers, hyphens, dots, and underscores, up to %[2]d characters.\n"
"\t\t* The effect must be NoSchedule, PreferNoSchedule or NoExecute.\n"
"\t\t* Currently taint can only apply to node."
msgstr ""

#: pkg/kubectl/cmd/apply_view_last_applied.go:46
msgid ""
"\n"
"\t\tView the latest last-applied-configuration annotations by type/name or "
"file.\n"
"\n"
"\t\tThe default output will be printed to stdout in YAML format. One can use "
"-o option\n"
"\t\tto change output format."
msgstr ""

#: pkg/kubectl/cmd/cp.go:37
msgid ""
"\n"
"\t    # !!!Important Note!!!\n"
"\t    # Requires that the 'tar' binary is present in your container\n"
"\t    # image.  If 'tar' is not present, 'kubectl cp' will fail.\n"
"\n"
"\t    # Copy /tmp/foo_dir local directory to /tmp/bar_dir in a remote pod in "
"the default namespace\n"
"\t\tkubectl cp /tmp/foo_dir <some-pod>:/tmp/bar_dir\n"
"\n"
"        # Copy /tmp/foo local file to /tmp/bar in a remote pod in a specific "
"container\n"
"\t\tkubectl cp /tmp/foo <some-pod>:/tmp/bar -c <specific-container>\n"
"\n"
"\t\t# Copy /tmp/foo local file to /tmp/bar in a remote pod in namespace "
"<some-namespace>\n"
"\t\tkubectl cp /tmp/foo <some-namespace>/<some-pod>:/tmp/bar\n"
"\n"
"\t\t# Copy /tmp/foo from a remote pod to /tmp/bar locally\n"
"\t\tkubectl cp <some-namespace>/<some-pod>:/tmp/foo /tmp/bar"
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:205
msgid ""
"\n"
"\t  # Create a new TLS secret named tls-secret with the given key pair:\n"
"\t  kubectl create secret tls tls-secret --cert=path/to/tls.cert --key=path/"
"to/tls.key"
msgstr ""

#: pkg/kubectl/cmd/create_namespace.go:35
msgid ""
"\n"
"\t  # Create a new namespace named my-namespace\n"
"\t  kubectl create namespace my-namespace"
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:59
msgid ""
"\n"
"\t  # Create a new secret named my-secret with keys for each file in folder "
"bar\n"
"\t  kubectl create secret generic my-secret --from-file=path/to/bar\n"
"\n"
"\t  # Create a new secret named my-secret with specified keys instead of "
"names on disk\n"
"\t  kubectl create secret generic my-secret --from-file=ssh-privatekey=~/."
"ssh/id_rsa --from-file=ssh-publickey=~/.ssh/id_rsa.pub\n"
"\n"
"\t  # Create a new secret named my-secret with key1=supersecret and "
"key2=topsecret\n"
"\t  kubectl create secret generic my-secret --from-literal=key1=supersecret "
"--from-literal=key2=topsecret"
msgstr ""

#: pkg/kubectl/cmd/create_serviceaccount.go:35
msgid ""
"\n"
"\t  # Create a new service account named my-service-account\n"
"\t  kubectl create serviceaccount my-service-account"
msgstr ""

#: pkg/kubectl/cmd/create_service.go:232
msgid ""
"\n"
"\t# Create a new ExternalName service named my-ns \n"
"\tkubectl create service externalname my-ns --external-name bar.com"
msgstr ""

#: pkg/kubectl/cmd/create_service.go:225
msgid ""
"\n"
"\tCreate an ExternalName service with the specified name.\n"
"\n"
"\tExternalName service references to an external DNS address instead of\n"
"\tonly pods, which will allow application authors to reference services\n"
"\tthat exist off platform, on other clusters, or locally."
msgstr ""

#: pkg/kubectl/cmd/help.go:30
msgid ""
"\n"
"\tHelp provides help for any command in the application.\n"
"\tSimply type kubectl help [path to command] for full details."
msgstr ""

#: pkg/kubectl/cmd/create_service.go:173
msgid ""
"\n"
"    # Create a new LoadBalancer service named my-lbs\n"
"    kubectl create service loadbalancer my-lbs --tcp=5678:8080"
msgstr ""

#: pkg/kubectl/cmd/create_service.go:53
msgid ""
"\n"
"    # Create a new clusterIP service named my-cs\n"
"    kubectl create service clusterip my-cs --tcp=5678:8080\n"
"\n"
"    # Create a new clusterIP service named my-cs (in headless mode)\n"
"    kubectl create service clusterip my-cs --clusterip=\"None\""
msgstr ""

#: pkg/kubectl/cmd/create_deployment.go:36
msgid ""
"\n"
"    # Create a new deployment named my-dep that runs the busybox image.\n"
"    kubectl create deployment my-dep --image=busybox"
msgstr ""

#: pkg/kubectl/cmd/create_service.go:116
msgid ""
"\n"
"    # Create a new nodeport service named my-ns\n"
"    kubectl create service nodeport my-ns --tcp=5678:8080"
msgstr ""

#: pkg/kubectl/cmd/clusterinfo_dump.go:62
msgid ""
"\n"
"    # Dump current cluster state to stdout\n"
"    kubectl cluster-info dump\n"
"\n"
"    # Dump current cluster state to /path/to/cluster-state\n"
"    kubectl cluster-info dump --output-directory=/path/to/cluster-state\n"
"\n"
"    # Dump all namespaces to stdout\n"
"    kubectl cluster-info dump --all-namespaces\n"
"\n"
"    # Dump a set of namespaces to /path/to/cluster-state\n"
"    kubectl cluster-info dump --namespaces default,kube-system --output-"
"directory=/path/to/cluster-state"
msgstr ""

#: pkg/kubectl/cmd/annotate.go:78
msgid ""
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend'.\n"
"    # If the same annotation is set multiple times, only the last value will "
"be applied\n"
"    kubectl annotate pods foo description='my frontend'\n"
"\n"
"    # Update a pod identified by type and name in \"pod.json\"\n"
"    kubectl annotate -f pod.json description='my frontend'\n"
"\n"
"    # Update pod 'foo' with the annotation 'description' and the value 'my "
"frontend running nginx', overwriting any existing value.\n"
"    kubectl annotate --overwrite pods foo description='my frontend running "
"nginx'\n"
"\n"
"    # Update all pods in the namespace\n"
"    kubectl annotate pods --all description='my frontend running nginx'\n"
"\n"
"    # Update pod 'foo' only if the resource is unchanged from version 1.\n"
"    kubectl annotate pods foo description='my frontend running nginx' --"
"resource-version=1\n"
"\n"
"    # Update pod 'foo' by removing an annotation named 'description' if it "
"exists.\n"
"    # Does not require the --overwrite flag.\n"
"    kubectl annotate pods foo description-"
msgstr ""

#: pkg/kubectl/cmd/create_service.go:170
msgid ""
"\n"
"    Create a LoadBalancer service with the specified name."
msgstr ""

#: pkg/kubectl/cmd/create_service.go:50
msgid ""
"\n"
"    Create a clusterIP service with the specified name."
msgstr ""

#: pkg/kubectl/cmd/create_deployment.go:33
msgid ""
"\n"
"    Create a deployment with the specified name."
msgstr ""

#: pkg/kubectl/cmd/create_service.go:113
msgid ""
"\n"
"    Create a nodeport service with the specified name."
msgstr ""

#: pkg/kubectl/cmd/clusterinfo_dump.go:53
msgid ""
"\n"
"    Dumps cluster info out suitable for debugging and diagnosing cluster "
"problems.  By default, dumps everything to\n"
"    stdout. You can optionally specify a directory with --output-directory.  "
"If you specify a directory, kubernetes will\n"
"    build a set of files in that directory.  By default only dumps things in "
"the 'kube-system' namespace, but you can\n"
"    switch to a different namespace with the --namespaces flag, or specify --"
"all-namespaces to dump all namespaces.\n"
"\n"
"    The command also dumps the logs of all of the pods in the cluster, these "
"logs are dumped into different directories\n"
"    based on namespace and pod name."
msgstr ""

#: pkg/kubectl/cmd/clusterinfo.go:37
msgid ""
"\n"
"  Display addresses of the master and services with label kubernetes.io/"
"cluster-service=true\n"
"  To further debug and diagnose cluster problems, use 'kubectl cluster-info "
"dump'."
msgstr ""

#: pkg/kubectl/cmd/create_quota.go:62
msgid ""
"A comma-delimited set of quota scopes that must all match each object "
"tracked by the quota."
msgstr ""

#: pkg/kubectl/cmd/create_quota.go:61
msgid ""
"A comma-delimited set of resource=quantity pairs that define a hard limit."
msgstr ""

#: pkg/kubectl/cmd/create_pdb.go:64
msgid ""
"A label selector to use for this budget. Only equality-based selector "
"requirements are supported."
msgstr ""

#: pkg/kubectl/cmd/expose.go:104
msgid ""
"A label selector to use for this service. Only equality-based selector "
"requirements are supported. If empty (the default) infer the selector from "
"the replication controller or replica set.)"
msgstr ""

#: pkg/kubectl/cmd/run.go:139
msgid "A schedule in the Cron format the job should be run with."
msgstr ""

#: pkg/kubectl/cmd/expose.go:109
msgid ""
"Additional external IP address (not managed by Kubernetes) to accept for the "
"service. If this IP is routed to a node, the service can be accessed by this "
"IP in addition to its generated service IP."
msgstr ""

#: pkg/kubectl/cmd/expose.go:110 pkg/kubectl/cmd/run.go:122
msgid ""
"An inline JSON override for the generated object. If this is non-empty, it "
"is used to override the generated object. Requires that the object supply a "
"valid apiVersion field."
msgstr ""

#: pkg/kubectl/cmd/run.go:137
msgid ""
"An inline JSON override for the generated service object. If this is non-"
"empty, it is used to override the generated object. Requires that the object "
"supply a valid apiVersion field.  Only used if --expose is true."
msgstr ""

#: pkg/kubectl/cmd/apply.go:104
msgid "Apply a configuration to a resource by filename or stdin"
msgstr ""

#: pkg/kubectl/cmd/certificates.go:72
msgid "Approve a certificate signing request"
msgstr ""

#: pkg/kubectl/cmd/create_service.go:82
msgid ""
"Assign your own ClusterIP or set to 'None' for a 'headless' service (no "
"loadbalancing)."
msgstr ""

#: pkg/kubectl/cmd/attach.go:70
msgid "Attach to a running container"
msgstr ""

#: pkg/kubectl/cmd/autoscale.go:56
msgid "Auto-scale a Deployment, ReplicaSet, or ReplicationController"
msgstr ""

#: pkg/kubectl/cmd/expose.go:113
msgid ""
"ClusterIP to be assigned to the service. Leave empty to auto-allocate, or "
"set to 'None' to create a headless service."
msgstr ""

#: pkg/kubectl/cmd/create_clusterrolebinding.go:56
msgid "ClusterRole this ClusterRoleBinding should reference"
msgstr ""

#: pkg/kubectl/cmd/create_rolebinding.go:56
msgid "ClusterRole this RoleBinding should reference"
msgstr ""

#: pkg/kubectl/cmd/rollingupdate.go:102
msgid ""
"Container name which will have its image upgraded. Only relevant when --"
"image is specified, ignored otherwise. Required when using --image on a "
"multi-container pod"
msgstr ""

#: pkg/kubectl/cmd/convert.go:68
msgid "Convert config files between different API versions"
msgstr ""

#: pkg/kubectl/cmd/cp.go:65
msgid "Copy files and directories to and from containers."
msgstr ""

#: pkg/kubectl/cmd/create_clusterrolebinding.go:44
msgid "Create a ClusterRoleBinding for a particular ClusterRole"
msgstr ""

#: pkg/kubectl/cmd/create_service.go:182
msgid "Create a LoadBalancer service."
msgstr ""

#: pkg/kubectl/cmd/create_service.go:125
msgid "Create a NodePort service."
msgstr ""

#: pkg/kubectl/cmd/create_rolebinding.go:44
msgid "Create a RoleBinding for a particular Role or ClusterRole"
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:214
msgid "Create a TLS secret"
msgstr ""

#: pkg/kubectl/cmd/create_service.go:69
msgid "Create a clusterIP service."
msgstr ""

#: pkg/kubectl/cmd/create_configmap.go:60
msgid "Create a configmap from a local file, directory or literal value"
msgstr ""

#: pkg/kubectl/cmd/create_deployment.go:46
msgid "Create a deployment with the specified name."
msgstr ""

#: pkg/kubectl/cmd/create_namespace.go:45
msgid "Create a namespace with the specified name"
msgstr ""

#: pkg/kubectl/cmd/create_pdb.go:50
msgid "Create a pod disruption budget with the specified name."
msgstr ""

#: pkg/kubectl/cmd/create_quota.go:48
msgid "Create a quota with the specified name."
msgstr ""

#: pkg/kubectl/cmd/create.go:63
msgid "Create a resource by filename or stdin"
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:144
msgid "Create a secret for use with a Docker registry"
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:74
msgid "Create a secret from a local file, directory or literal value"
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:35
msgid "Create a secret using specified subcommand"
msgstr ""

#: pkg/kubectl/cmd/create_serviceaccount.go:45
msgid "Create a service account with the specified name"
msgstr ""

#: pkg/kubectl/cmd/create_service.go:37
msgid "Create a service using specified subcommand."
msgstr ""

#: pkg/kubectl/cmd/create_service.go:241
msgid "Create an ExternalName service."
msgstr ""

#: pkg/kubectl/cmd/delete.go:132
msgid ""
"Delete resources by filenames, stdin, resources and names, or by resources "
"and label selector"
msgstr ""

#: pkg/kubectl/cmd/config/delete_cluster.go:39
msgid "Delete the specified cluster from the kubeconfig"
msgstr ""

#: pkg/kubectl/cmd/config/delete_context.go:39
msgid "Delete the specified context from the kubeconfig"
msgstr ""

#: pkg/kubectl/cmd/certificates.go:122
msgid "Deny a certificate signing request"
msgstr ""

#: pkg/kubectl/cmd/stop.go:59
msgid "Deprecated: Gracefully shut down a resource by name or filename"
msgstr ""

#: pkg/kubectl/cmd/config/get_contexts.go:64
msgid "Describe one or many contexts"
msgstr ""

#: pkg/kubectl/cmd/top_node.go:78
msgid "Display Resource (CPU/Memory/Storage) usage of nodes"
msgstr ""

#: pkg/kubectl/cmd/top_pod.go:80
msgid "Display Resource (CPU/Memory/Storage) usage of pods"
msgstr ""

#: pkg/kubectl/cmd/top.go:44
msgid "Display Resource (CPU/Memory/Storage) usage."
msgstr ""

#: pkg/kubectl/cmd/clusterinfo.go:51
msgid "Display cluster info"
msgstr ""

#: pkg/kubectl/cmd/config/get_clusters.go:41
msgid "Display clusters defined in the kubeconfig"
msgstr ""

#: pkg/kubectl/cmd/config/view.go:67
msgid "Display merged kubeconfig settings or a specified kubeconfig file"
msgstr ""

#: pkg/kubectl/cmd/get.go:111
msgid "Display one or many resources"
msgstr ""

#: pkg/kubectl/cmd/config/current_context.go:49
msgid "Displays the current-context"
msgstr ""

#: pkg/kubectl/cmd/explain.go:51
msgid "Documentation of resources"
msgstr ""

#: pkg/kubectl/cmd/drain.go:178
msgid "Drain node in preparation for maintenance"
msgstr ""

#: pkg/kubectl/cmd/clusterinfo_dump.go:39
msgid "Dump lots of relevant info for debugging and diagnosis"
msgstr ""

#: pkg/kubectl/cmd/edit.go:110
msgid "Edit a resource on the server"
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:160
msgid "Email for Docker registry"
msgstr ""

#: pkg/kubectl/cmd/exec.go:69
msgid "Execute a command in a container"
msgstr ""

#: pkg/kubectl/cmd/rollingupdate.go:103
msgid ""
"Explicit policy for when to pull container images. Required when --image is "
"same as existing image, ignored otherwise."
msgstr ""

#: pkg/kubectl/cmd/portforward.go:76
msgid "Forward one or more local ports to a pod"
msgstr ""

#: pkg/kubectl/cmd/help.go:37
msgid "Help about any command"
msgstr ""

#: pkg/kubectl/cmd/expose.go:103
msgid ""
"IP to assign to the Load Balancer. If empty, an ephemeral IP will be created "
"and used (cloud-provider specific)."
msgstr ""

#: pkg/kubectl/cmd/expose.go:112
msgid ""
"If non-empty, set the session affinity for the service to this; legal "
"values: 'None', 'ClientIP'"
msgstr ""

#: pkg/kubectl/cmd/annotate.go:136
msgid ""
"If non-empty, the annotation update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."
msgstr ""

#: pkg/kubectl/cmd/label.go:134
msgid ""
"If non-empty, the labels update will only succeed if this is the current "
"resource-version for the object. Only valid when specifying a single "
"resource."
msgstr ""

#: pkg/kubectl/cmd/rollingupdate.go:99
msgid ""
"Image to use for upgrading the replication controller. Must be distinct from "
"the existing image (either new image or new image tag).  Can not be used "
"with --filename/-f"
msgstr ""

#: pkg/kubectl/cmd/rollout/rollout.go:47
msgid "Manage a deployment rollout"
msgstr ""

#: pkg/kubectl/cmd/drain.go:128
msgid "Mark node as schedulable"
msgstr ""

#: pkg/kubectl/cmd/drain.go:103
msgid "Mark node as unschedulable"
msgstr ""

#: pkg/kubectl/cmd/rollout/rollout_pause.go:74
msgid "Mark the provided resource as paused"
msgstr ""

#: pkg/kubectl/cmd/certificates.go:36
msgid "Modify certificate resources."
msgstr ""

#: pkg/kubectl/cmd/config/config.go:40
msgid "Modify kubeconfig files"
msgstr ""

#: pkg/kubectl/cmd/expose.go:108
msgid ""
"Name or number for the port on the container that the service should direct "
"traffic to. Optional."
msgstr ""

#: pkg/kubectl/cmd/logs.go:113
msgid ""
"Only return logs after a specific date (RFC3339). Defaults to all logs. Only "
"one of since-time / since may be used."
msgstr ""

#: pkg/kubectl/cmd/completion.go:104
msgid "Output shell completion code for the specified shell (bash or zsh)"
msgstr ""

#: pkg/kubectl/cmd/convert.go:85
msgid ""
"Output the formatted object with the given group version (for ex: "
"'extensions/v1beta1').)"
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:158
msgid "Password for Docker registry authentication"
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:226
msgid "Path to PEM encoded public key certificate."
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:227
msgid "Path to private key associated with given certificate."
msgstr ""

#: pkg/kubectl/cmd/rollingupdate.go:85
msgid "Perform a rolling update of the given ReplicationController"
msgstr ""

#: pkg/kubectl/cmd/scale.go:83
msgid ""
"Precondition for resource version. Requires that the current resource "
"version match this value in order to scale."
msgstr ""

#: pkg/kubectl/cmd/version.go:40
msgid "Print the client and server version information"
msgstr ""

#: pkg/kubectl/cmd/options.go:38
msgid "Print the list of flags inherited by all commands"
msgstr ""

#: pkg/kubectl/cmd/logs.go:93
msgid "Print the logs for a container in a pod"
msgstr ""

#: pkg/kubectl/cmd/replace.go:71
msgid "Replace a resource by filename or stdin"
msgstr ""

#: pkg/kubectl/cmd/rollout/rollout_resume.go:72
msgid "Resume a paused resource"
msgstr ""

#: pkg/kubectl/cmd/create_rolebinding.go:57
msgid "Role this RoleBinding should reference"
msgstr ""

#: pkg/kubectl/cmd/run.go:97
msgid "Run a particular image on the cluster"
msgstr ""

#: pkg/kubectl/cmd/proxy.go:69
msgid "Run a proxy to the Kubernetes API server"
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:161
msgid "Server location for Docker registry"
msgstr ""

#: pkg/kubectl/cmd/scale.go:71
msgid ""
"Set a new size for a Deployment, ReplicaSet, Replication Controller, or Job"
msgstr ""

#: pkg/kubectl/cmd/set/set.go:38
msgid "Set specific features on objects"
msgstr ""

#: pkg/kubectl/cmd/apply_set_last_applied.go:83
msgid ""
"Set the last-applied-configuration annotation on a live object to match the "
"contents of a file."
msgstr ""

#: pkg/kubectl/cmd/set/set_selector.go:82
msgid "Set the selector on a resource"
msgstr ""

#: pkg/kubectl/cmd/config/create_cluster.go:68
msgid "Sets a cluster entry in kubeconfig"
msgstr ""

#: pkg/kubectl/cmd/config/create_context.go:58
msgid "Sets a context entry in kubeconfig"
msgstr ""

#: pkg/kubectl/cmd/config/create_authinfo.go:104
msgid "Sets a user entry in kubeconfig"
msgstr ""

#: pkg/kubectl/cmd/config/set.go:60
msgid "Sets an individual value in a kubeconfig file"
msgstr ""

#: pkg/kubectl/cmd/config/use_context.go:49
msgid "Sets the current-context in a kubeconfig file"
msgstr ""

#: pkg/kubectl/cmd/describe.go:86
msgid "Show details of a specific resource or group of resources"
msgstr ""

#: pkg/kubectl/cmd/rollout/rollout_status.go:58
msgid "Show the status of the rollout"
msgstr ""

#: pkg/kubectl/cmd/expose.go:106
msgid "Synonym for --target-port"
msgstr ""

#: pkg/kubectl/cmd/expose.go:88
msgid ""
"Take a replication controller, service, deployment or pod and expose it as a "
"new Kubernetes Service"
msgstr ""

#: pkg/kubectl/cmd/run.go:117
msgid "The image for the container to run."
msgstr ""

#: pkg/kubectl/cmd/run.go:119
msgid ""
"The image pull policy for the container. If left empty, this value will not "
"be specified by the client and defaulted by the server"
msgstr ""

#: pkg/kubectl/cmd/rollingupdate.go:101
msgid ""
"The key to use to differentiate between two different controllers, default "
"'deployment'.  Only relevant when --image is specified, ignored otherwise"
msgstr ""

#: pkg/kubectl/cmd/create_pdb.go:63
msgid ""
"The minimum number or percentage of available pods this budget requires."
msgstr ""

#: pkg/kubectl/cmd/expose.go:111
msgid "The name for the newly created object."
msgstr ""

#: pkg/kubectl/cmd/autoscale.go:72
msgid ""
"The name for the newly created object. If not specified, the name of the "
"input resource will be used."
msgstr ""

#: pkg/kubectl/cmd/run.go:116
msgid ""
"The name of the API generator to use, see http://kubernetes.io/docs/user-"
"guide/kubectl-conventions/#generators for a list."
msgstr ""

#: pkg/kubectl/cmd/autoscale.go:67
msgid ""
"The name of the API generator to use. Currently there is only 1 generator."
msgstr ""

#: pkg/kubectl/cmd/expose.go:99
msgid ""
"The name of the API generator to use. There are 2 generators: 'service/v1' "
"and 'service/v2'. The only difference between them is that service port in "
"v1 is named 'default', while it is left unnamed in v2. Default is 'service/"
"v2'."
msgstr ""

#: pkg/kubectl/cmd/run.go:136
msgid ""
"The name of the generator to use for creating a service.  Only used if --"
"expose is true"
msgstr ""

#: pkg/kubectl/cmd/expose.go:100
msgid "The network protocol for the service to be created. Default is 'TCP'."
msgstr ""

#: pkg/kubectl/cmd/expose.go:101
msgid ""
"The port that the service should serve on. Copied from the resource being "
"exposed, if unspecified"
msgstr ""

#: pkg/kubectl/cmd/run.go:124
msgid ""
"The port that this container exposes.  If --expose is true, this is also the "
"port used by the service that is created."
msgstr ""

#: pkg/kubectl/cmd/run.go:134
msgid ""
"The resource requirement limits for this container.  For example, 'cpu=200m,"
"memory=512Mi'.  Note that server side components may assign limits depending "
"on the server configuration, such as limit ranges."
msgstr ""

#: pkg/kubectl/cmd/run.go:133
msgid ""
"The resource requirement requests for this container.  For example, "
"'cpu=100m,memory=256Mi'.  Note that server side components may assign "
"requests depending on the server configuration, such as limit ranges."
msgstr ""

#: pkg/kubectl/cmd/run.go:131
msgid ""
"The restart policy for this Pod.  Legal values [Always, OnFailure, Never].  "
"If set to 'Always' a deployment is created, if set to 'OnFailure' a job is "
"created, if set to 'Never', a regular pod is created. For the latter two --"
"replicas must be 1.  Default 'Always', for CronJobs ` + "`" + `Never` + "`" + `."
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:88
msgid "The type of secret to create"
msgstr ""

#: pkg/kubectl/cmd/expose.go:102
msgid ""
"Type for this service: ClusterIP, NodePort, or LoadBalancer. Default is "
"'ClusterIP'."
msgstr ""

#: pkg/kubectl/cmd/rollout/rollout_undo.go:72
msgid "Undo a previous rollout"
msgstr ""

#: pkg/kubectl/cmd/config/unset.go:48
msgid "Unsets an individual value in a kubeconfig file"
msgstr ""

#: pkg/kubectl/cmd/patch.go:96
msgid "Update field(s) of a resource using strategic merge patch"
msgstr ""

#: pkg/kubectl/cmd/set/set_image.go:95
msgid "Update image of a pod template"
msgstr ""

#: pkg/kubectl/cmd/set/set_resources.go:102
msgid "Update resource requests/limits on objects with pod templates"
msgstr ""

#: pkg/kubectl/cmd/annotate.go:116
msgid "Update the annotations on a resource"
msgstr ""

#: pkg/kubectl/cmd/label.go:114
msgid "Update the labels on a resource"
msgstr ""

#: pkg/kubectl/cmd/taint.go:87
msgid "Update the taints on one or more nodes"
msgstr ""

#: pkg/kubectl/cmd/create_secret.go:156
msgid "Username for Docker registry authentication"
msgstr ""

#: pkg/kubectl/cmd/apply_view_last_applied.go:64
msgid "View latest last-applied-configuration annotations of a resource/object"
msgstr ""

#: pkg/kubectl/cmd/rollout/rollout_history.go:52
msgid "View rollout history"
msgstr ""

#: pkg/kubectl/cmd/clusterinfo_dump.go:46
msgid ""
"Where to output the files.  If empty or '-' uses stdout, otherwise creates a "
"directory hierarchy in that directory"
msgstr ""

#: pkg/kubectl/cmd/run_test.go:85
msgid "dummy restart flag)"
msgstr ""

#: pkg/kubectl/cmd/create_service.go:254
msgid "external name of service"
msgstr ""

#: pkg/kubectl/cmd/cmd.go:227
msgid "kubectl controls the Kubernetes cluster manager"
msgstr ""
`)

func translationsKubectlTemplatePotBytes() ([]byte, error) {
	return _translationsKubectlTemplatePot, nil
}

func translationsKubectlTemplatePot() (*asset, error) {
	bytes, err := translationsKubectlTemplatePotBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/template.pot", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlZh_cnLc_messagesK8sMo = []byte("\xde\x12\x04\x95\x00\x00\x00\x00\x11\x00\x00\x00\x1c\x00\x00\x00\xa4\x00\x00\x00\x17\x00\x00\x00,\x01\x00\x00\x00\x00\x00\x00\x88\x01\x00\x008\x00\x00\x00\x89\x01\x00\x000\x00\x00\x00\xc2\x01\x00\x000\x00\x00\x00\xf3\x01\x00\x00\x1d\x00\x00\x00$\x02\x00\x00*\x00\x00\x00B\x02\x00\x00A\x00\x00\x00m\x02\x00\x00\x1c\x00\x00\x00\xaf\x02\x00\x00\x17\x00\x00\x00\xcc\x02\x00\x00\"\x00\x00\x00\xe4\x02\x00\x00\"\x00\x00\x00\a\x03\x00\x00\x1f\x00\x00\x00*\x03\x00\x00-\x00\x00\x00J\x03\x00\x00-\x00\x00\x00x\x03\x00\x00/\x00\x00\x00\xa6\x03\x00\x00$\x00\x00\x00\xd6\x03\x00\x00\xc5\x00\x00\x00\xfb\x03\x00\x00\xa3\x01\x00\x00\xc1\x04\x00\x00@\x00\x00\x00e\x06\x00\x00*\x00\x00\x00\xa6\x06\x00\x00-\x00\x00\x00\xd1\x06\x00\x00\x1e\x00\x00\x00\xff\x06\x00\x00*\x00\x00\x00\x1e\a\x00\x00E\x00\x00\x00I\a\x00\x00\x18\x00\x00\x00\x8f\a\x00\x00\x18\x00\x00\x00\xa8\a\x00\x000\x00\x00\x00\xc1\a\x00\x003\x00\x00\x00\xf2\a\x00\x000\x00\x00\x00&\b\x00\x00-\x00\x00\x00W\b\x00\x00-\x00\x00\x00\x85\b\x00\x003\x00\x00\x00\xb3\b\x00\x00\x1b\x00\x00\x00\xe7\b\x00\x00\x93\x00\x00\x00\x03\t\x00\x00\x01\x00\x00\x00\n\x00\x00\x00\v\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\t\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\a\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\b\x00\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\f\x00\x00\x00\x05\x00\x00\x00\r\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00Apply a configuration to a resource by filename or stdin\x00Delete the specified cluster from the kubeconfig\x00Delete the specified context from the kubeconfig\x00Describe one or many contexts\x00Display clusters defined in the kubeconfig\x00Display merged kubeconfig settings or a specified kubeconfig file\x00Displays the current-context\x00Modify kubeconfig files\x00Sets a cluster entry in kubeconfig\x00Sets a context entry in kubeconfig\x00Sets a user entry in kubeconfig\x00Sets an individual value in a kubeconfig file\x00Sets the current-context in a kubeconfig file\x00Unsets an individual value in a kubeconfig file\x00Update the annotations on a resource\x00watch is only supported on individual resources and resource collections - %d resources were found\x00watch is only supported on individual resources and resource collections - %d resources were found\x00Project-Id-Version: gettext-go-examples-hello\nReport-Msgid-Bugs-To: \nPOT-Creation-Date: 2013-12-12 20:03+0000\nPO-Revision-Date: 2017-05-19 16:16+0800\nLast-Translator: Shiyang Wang <shiywang@redhat.com>\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 8bit\nX-Generator: Poedit 1.8.8\nX-Poedit-SourceCharset: UTF-8\nLanguage-Team: \nPlural-Forms: nplurals=2; plural=(n > 1);\nLanguage: zh\n\x00\u901a\u8fc7\u6587\u4ef6\u540d\u6216\u6807\u51c6\u8f93\u5165\u6d41(stdin)\u5bf9\u8d44\u6e90\u8fdb\u884c\u914d\u7f6e\u3002\x00\u5220\u9664 kubeconfig \u6587\u4ef6\u4e2d\u6307\u5b9a\u7684\u96c6\u7fa4\x00\u5220\u9664 kubeconfig \u6587\u4ef6\u4e2d\u6307\u5b9a\u7684\u4e0a\u4e0b\u6587\x00\u63cf\u8ff0\u4e00\u4e2a\u6216\u591a\u4e2a\u4e0a\u4e0b\u6587\x00\u663e\u793a kubeconfig \u6587\u4ef6\u4e2d\u5b9a\u4e49\u7684\u96c6\u7fa4\x00\u663e\u793a\u5408\u5e76\u7684 kubeconfig \u914d\u7f6e\u6216\u4e00\u4e2a\u6307\u5b9a\u7684 kubeconfig \u6587\u4ef6\x00\u663e\u793a\u5f53\u524d\u7684\u4e0a\u4e0b\u6587\x00\u4fee\u6539 kubeconfig \u6587\u4ef6\x00\u8bbe\u7f6e kubeconfig \u6587\u4ef6\u4e2d\u7684\u4e00\u4e2a\u96c6\u7fa4\u6761\u76ee\x00\u8bbe\u7f6e kubeconfig \u6587\u4ef6\u4e2d\u7684\u4e00\u4e2a\u4e0a\u4e0b\u6587\u6761\u76ee\x00\u8bbe\u7f6e kubeconfig \u6587\u4ef6\u4e2d\u7684\u4e00\u4e2a\u7528\u6237\u6761\u76ee\x00\u8bbe\u7f6e kubeconfig \u6587\u4ef6\u4e2d\u7684\u4e00\u4e2a\u5355\u4e2a\u503c\x00\u8bbe\u7f6e kubeconfig \u6587\u4ef6\u4e2d\u7684\u5f53\u524d\u4e0a\u4e0b\u6587\x00\u53d6\u6d88\u8bbe\u7f6e kubeconfig \u6587\u4ef6\u4e2d\u7684\u4e00\u4e2a\u5355\u4e2a\u503c\x00\u66f4\u65b0\u4e00\u4e2a\u8d44\u6e90\u7684\u6ce8\u89e3\x00watch \u4ec5\u652f\u6301\u5355\u72ec\u7684\u8d44\u6e90\u6216\u8005\u8d44\u6e90\u96c6\u5408 - \u627e\u5230\u4e86 %d \u4e2a\u8d44\u6e90\x00watch \u4ec5\u652f\u6301\u5355\u72ec\u7684\u8d44\u6e90\u6216\u8005\u8d44\u6e90\u96c6\u5408 - \u627e\u5230\u4e86 %d \u4e2a\u8d44\u6e90\x00")

func translationsKubectlZh_cnLc_messagesK8sMoBytes() ([]byte, error) {
	return _translationsKubectlZh_cnLc_messagesK8sMo, nil
}

func translationsKubectlZh_cnLc_messagesK8sMo() (*asset, error) {
	bytes, err := translationsKubectlZh_cnLc_messagesK8sMoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/zh_CN/LC_MESSAGES/k8s.mo", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlZh_cnLc_messagesK8sPo = []byte(`# Test translations for unit tests.
# Copyright (C) 2017
# This file is distributed under the same license as the PACKAGE package.
# FIRST AUTHOR shiywang@redhat.com, 2017.
#
msgid ""
msgstr ""
"Project-Id-Version: gettext-go-examples-hello\n"
"Report-Msgid-Bugs-To: \n"
"POT-Creation-Date: 2013-12-12 20:03+0000\n"
"PO-Revision-Date: 2017-05-19 16:16+0800\n"
"Last-Translator: Shiyang Wang <shiywang@redhat.com>\n"
"MIME-Version: 1.0\n"
"Content-Type: text/plain; charset=UTF-8\n"
"Content-Transfer-Encoding: 8bit\n"
"X-Generator: Poedit 1.8.8\n"
"X-Poedit-SourceCharset: UTF-8\n"
"Language-Team: \n"
"Plural-Forms: nplurals=2; plural=(n > 1);\n"
"Language: zh\n"

#: pkg/kubectl/cmd/apply.go:104
msgid "Apply a configuration to a resource by filename or stdin"
msgstr "通过文件名或标准输入流(stdin)对资源进行配置。"

#: pkg/kubectl/cmd/config/delete_cluster.go:39
msgid "Delete the specified cluster from the kubeconfig"
msgstr "删除 kubeconfig 文件中指定的集群"

#: pkg/kubectl/cmd/config/delete_context.go:39
msgid "Delete the specified context from the kubeconfig"
msgstr "删除 kubeconfig 文件中指定的上下文"

#: pkg/kubectl/cmd/config/get_contexts.go:64
msgid "Describe one or many contexts"
msgstr "描述一个或多个上下文"

#: pkg/kubectl/cmd/config/get_clusters.go:41
msgid "Display clusters defined in the kubeconfig"
msgstr "显示 kubeconfig 文件中定义的集群"

#: pkg/kubectl/cmd/config/view.go:67
msgid "Display merged kubeconfig settings or a specified kubeconfig file"
msgstr "显示合并的 kubeconfig 配置或一个指定的 kubeconfig 文件"

#: pkg/kubectl/cmd/config/current_context.go:49
msgid "Displays the current-context"
msgstr "显示当前的上下文"

#: pkg/kubectl/cmd/config/config.go:40
msgid "Modify kubeconfig files"
msgstr "修改 kubeconfig 文件"

#: pkg/kubectl/cmd/config/create_cluster.go:68
msgid "Sets a cluster entry in kubeconfig"
msgstr "设置 kubeconfig 文件中的一个集群条目"

#: pkg/kubectl/cmd/config/create_context.go:58
msgid "Sets a context entry in kubeconfig"
msgstr "设置 kubeconfig 文件中的一个上下文条目"

#: pkg/kubectl/cmd/config/create_authinfo.go:104
msgid "Sets a user entry in kubeconfig"
msgstr "设置 kubeconfig 文件中的一个用户条目"

#: pkg/kubectl/cmd/config/set.go:60
msgid "Sets an individual value in a kubeconfig file"
msgstr "设置 kubeconfig 文件中的一个单个值"

#: pkg/kubectl/cmd/config/use_context.go:49
msgid "Sets the current-context in a kubeconfig file"
msgstr "设置 kubeconfig 文件中的当前上下文"

#: pkg/kubectl/cmd/config/unset.go:48
msgid "Unsets an individual value in a kubeconfig file"
msgstr "取消设置 kubeconfig 文件中的一个单个值"

#: pkg/kubectl/cmd/annotate.go:116
msgid "Update the annotations on a resource"
msgstr "更新一个资源的注解"

msgid ""
"watch is only supported on individual resources and resource collections - "
"%d resources were found"
msgid_plural ""
"watch is only supported on individual resources and resource collections - "
"%d resources were found"
msgstr[0] "watch 仅支持单独的资源或者资源集合 - 找到了 %d 个资源"
msgstr[1] "watch 仅支持单独的资源或者资源集合 - 找到了 %d 个资源"
`)

func translationsKubectlZh_cnLc_messagesK8sPoBytes() ([]byte, error) {
	return _translationsKubectlZh_cnLc_messagesK8sPo, nil
}

func translationsKubectlZh_cnLc_messagesK8sPo() (*asset, error) {
	bytes, err := translationsKubectlZh_cnLc_messagesK8sPoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/zh_CN/LC_MESSAGES/k8s.po", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlZh_twLc_messagesK8sMo = []byte("\xde\x12\x04\x95\x00\x00\x00\x00\x11\x00\x00\x00\x1c\x00\x00\x00\xa4\x00\x00\x00\x17\x00\x00\x00,\x01\x00\x00\x00\x00\x00\x00\x88\x01\x00\x008\x00\x00\x00\x89\x01\x00\x000\x00\x00\x00\xc2\x01\x00\x000\x00\x00\x00\xf3\x01\x00\x00\x1d\x00\x00\x00$\x02\x00\x00*\x00\x00\x00B\x02\x00\x00A\x00\x00\x00m\x02\x00\x00\x1c\x00\x00\x00\xaf\x02\x00\x00\x17\x00\x00\x00\xcc\x02\x00\x00\"\x00\x00\x00\xe4\x02\x00\x00\"\x00\x00\x00\a\x03\x00\x00\x1f\x00\x00\x00*\x03\x00\x00-\x00\x00\x00J\x03\x00\x00-\x00\x00\x00x\x03\x00\x00/\x00\x00\x00\xa6\x03\x00\x00$\x00\x00\x00\xd6\x03\x00\x00\xc5\x00\x00\x00\xfb\x03\x00\x00\x98\x01\x00\x00\xc1\x04\x00\x00=\x00\x00\x00Z\x06\x00\x003\x00\x00\x00\x98\x06\x00\x00,\x00\x00\x00\xcc\x06\x00\x00\x1d\x00\x00\x00\xf9\x06\x00\x003\x00\x00\x00\x17\a\x00\x00E\x00\x00\x00K\a\x00\x00\x17\x00\x00\x00\x91\a\x00\x00\x18\x00\x00\x00\xa9\a\x00\x009\x00\x00\x00\xc2\a\x00\x003\x00\x00\x00\xfc\a\x00\x003\x00\x00\x000\b\x00\x00'\x00\x00\x00d\b\x00\x00,\x00\x00\x00\x8c\b\x00\x00-\x00\x00\x00\xb9\b\x00\x00(\x00\x00\x00\xe7\b\x00\x00\x8f\x00\x00\x00\x10\t\x00\x00\x01\x00\x00\x00\n\x00\x00\x00\v\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x11\x00\x00\x00\t\x00\x00\x00\x02\x00\x00\x00\x00\x00\x00\x00\a\x00\x00\x00\x04\x00\x00\x00\x00\x00\x00\x00\b\x00\x00\x00\x0e\x00\x00\x00\x00\x00\x00\x00\x0f\x00\x00\x00\f\x00\x00\x00\x05\x00\x00\x00\r\x00\x00\x00\x06\x00\x00\x00\x00\x00\x00\x00\x10\x00\x00\x00\x00Apply a configuration to a resource by filename or stdin\x00Delete the specified cluster from the kubeconfig\x00Delete the specified context from the kubeconfig\x00Describe one or many contexts\x00Display clusters defined in the kubeconfig\x00Display merged kubeconfig settings or a specified kubeconfig file\x00Displays the current-context\x00Modify kubeconfig files\x00Sets a cluster entry in kubeconfig\x00Sets a context entry in kubeconfig\x00Sets a user entry in kubeconfig\x00Sets an individual value in a kubeconfig file\x00Sets the current-context in a kubeconfig file\x00Unsets an individual value in a kubeconfig file\x00Update the annotations on a resource\x00watch is only supported on individual resources and resource collections - %d resources were found\x00watch is only supported on individual resources and resource collections - %d resources were found\x00Project-Id-Version: hello-world\nReport-Msgid-Bugs-To: \nPOT-Creation-Date: 2017-05-26 08:28+0800\nPO-Revision-Date: 2017-06-02 09:13+0800\nLast-Translator: William Chang <warmchang@outlook.com>\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 8bit\nX-Generator: Poedit 2.0.2\nX-Poedit-SourceCharset: UTF-8\nLanguage-Team: \nPlural-Forms: nplurals=2; plural=(n > 1);\nLanguage: zh\n\x00\u901a\u904e\u6a94\u6848\u540d\u6216\u6a19\u6e96\u8f38\u5165\u6d41(stdin)\u5c0d\u8cc7\u6e90\u9032\u884c\u914d\u7f6e\x00\u522a\u9664 kubeconfig \u6a94\u6848\u4e2d\u6307\u5b9a\u7684\u53e2\u96c6(cluster)\x00\u522a\u9664 kubeconfig \u6a94\u6848\u4e2d\u6307\u5b9a\u7684 context\x00\u63cf\u8ff0\u4e00\u500b\u6216\u591a\u500b context\x00\u986f\u793a kubeconfig \u6a94\u6848\u4e2d\u5b9a\u7fa9\u7684\u53e2\u96c6(cluster)\x00\u986f\u793a\u5408\u4f75\u7684 kubeconfig \u914d\u7f6e\u6216\u4e00\u500b\u6307\u5b9a\u7684 kubeconfig \u6a94\u6848\x00\u986f\u793a\u76ee\u524d\u7684 context\x00\u4fee\u6539 kubeconfig \u6a94\u6848\x00\u8a2d\u7f6e kubeconfig \u6a94\u6848\u4e2d\u7684\u4e00\u500b\u53e2\u96c6(cluster)\u689d\u76ee\x00\u8a2d\u7f6e kubeconfig \u6a94\u6848\u4e2d\u7684\u4e00\u500b context \u689d\u76ee\x00\u8a2d\u7f6e kubeconfig \u6a94\u6848\u4e2d\u7684\u4e00\u500b\u4f7f\u7528\u8005\u689d\u76ee\x00\u8a2d\u7f6e kubeconfig \u6a94\u6848\u4e2d\u7684\u4e00\u500b\u503c\x00\u8a2d\u7f6e kubeconfig \u6a94\u6848\u4e2d\u7684\u76ee\u524d context\x00\u53d6\u6d88\u8a2d\u7f6e kubeconfig \u6a94\u6848\u4e2d\u7684\u4e00\u500b\u503c\x00\u66f4\u65b0\u4e00\u500b\u8cc7\u6e90\u7684\u6ce8\u89e3(annotations)\x00\u4e00\u6b21\u53ea\u80fd watch \u4e00\u500b\u8cc7\u6e90\u6216\u8cc7\u6599\u96c6\u5408 - \u627e\u5230\u4e86 %d \u500b\u8cc7\u6e90\x00\u4e00\u6b21\u53ea\u80fd watch \u4e00\u500b\u8cc7\u6e90\u6216\u8cc7\u6599\u96c6\u5408 - \u627e\u5230\u4e86 %d \u500b\u8cc7\u6e90\x00")

func translationsKubectlZh_twLc_messagesK8sMoBytes() ([]byte, error) {
	return _translationsKubectlZh_twLc_messagesK8sMo, nil
}

func translationsKubectlZh_twLc_messagesK8sMo() (*asset, error) {
	bytes, err := translationsKubectlZh_twLc_messagesK8sMoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/zh_TW/LC_MESSAGES/k8s.mo", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsKubectlZh_twLc_messagesK8sPo = []byte(`# Test translations for unit tests.
# Copyright (C) 2017
# This file is distributed under the same license as the PACKAGE package.
# FIRST AUTHOR warmchang@outlook.com, 2017.
#
msgid ""
msgstr ""
"Project-Id-Version: hello-world\n"
"Report-Msgid-Bugs-To: \n"
"POT-Creation-Date: 2017-05-26 08:28+0800\n"
"PO-Revision-Date: 2017-06-02 09:13+0800\n"
"Last-Translator: William Chang <warmchang@outlook.com>\n"
"MIME-Version: 1.0\n"
"Content-Type: text/plain; charset=UTF-8\n"
"Content-Transfer-Encoding: 8bit\n"
"X-Generator: Poedit 2.0.2\n"
"X-Poedit-SourceCharset: UTF-8\n"
"Language-Team: \n"
"Plural-Forms: nplurals=2; plural=(n > 1);\n"
"Language: zh\n"

#: pkg/kubectl/cmd/apply.go:104
msgid "Apply a configuration to a resource by filename or stdin"
msgstr "通過檔案名或標準輸入流(stdin)對資源進行配置"

#: pkg/kubectl/cmd/config/delete_cluster.go:39
msgid "Delete the specified cluster from the kubeconfig"
msgstr "刪除 kubeconfig 檔案中指定的叢集(cluster)"

#: pkg/kubectl/cmd/config/delete_context.go:39
msgid "Delete the specified context from the kubeconfig"
msgstr "刪除 kubeconfig 檔案中指定的 context"

#: pkg/kubectl/cmd/config/get_contexts.go:64
msgid "Describe one or many contexts"
msgstr "描述一個或多個 context"

#: pkg/kubectl/cmd/config/get_clusters.go:41
msgid "Display clusters defined in the kubeconfig"
msgstr "顯示 kubeconfig 檔案中定義的叢集(cluster)"

#: pkg/kubectl/cmd/config/view.go:67
msgid "Display merged kubeconfig settings or a specified kubeconfig file"
msgstr "顯示合併的 kubeconfig 配置或一個指定的 kubeconfig 檔案"

#: pkg/kubectl/cmd/config/current_context.go:49
msgid "Displays the current-context"
msgstr "顯示目前的 context"

#: pkg/kubectl/cmd/config/config.go:40
msgid "Modify kubeconfig files"
msgstr "修改 kubeconfig 檔案"

#: pkg/kubectl/cmd/config/create_cluster.go:68
msgid "Sets a cluster entry in kubeconfig"
msgstr "設置 kubeconfig 檔案中的一個叢集(cluster)條目"

#: pkg/kubectl/cmd/config/create_context.go:58
msgid "Sets a context entry in kubeconfig"
msgstr "設置 kubeconfig 檔案中的一個 context 條目"

#: pkg/kubectl/cmd/config/create_authinfo.go:104
msgid "Sets a user entry in kubeconfig"
msgstr "設置 kubeconfig 檔案中的一個使用者條目"

#: pkg/kubectl/cmd/config/set.go:60
msgid "Sets an individual value in a kubeconfig file"
msgstr "設置 kubeconfig 檔案中的一個值"

#: pkg/kubectl/cmd/config/use_context.go:49
msgid "Sets the current-context in a kubeconfig file"
msgstr "設置 kubeconfig 檔案中的目前 context"

#: pkg/kubectl/cmd/config/unset.go:48
msgid "Unsets an individual value in a kubeconfig file"
msgstr "取消設置 kubeconfig 檔案中的一個值"

#: pkg/kubectl/cmd/annotate.go:116
msgid "Update the annotations on a resource"
msgstr "更新一個資源的注解(annotations)"

msgid ""
"watch is only supported on individual resources and resource collections - "
"%d resources were found"
msgid_plural ""
"watch is only supported on individual resources and resource collections - "
"%d resources were found"
msgstr[0] "一次只能 watch 一個資源或資料集合 - 找到了 %d 個資源"
msgstr[1] "一次只能 watch 一個資源或資料集合 - 找到了 %d 個資源"
`)

func translationsKubectlZh_twLc_messagesK8sPoBytes() ([]byte, error) {
	return _translationsKubectlZh_twLc_messagesK8sPo, nil
}

func translationsKubectlZh_twLc_messagesK8sPo() (*asset, error) {
	bytes, err := translationsKubectlZh_twLc_messagesK8sPoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/kubectl/zh_TW/LC_MESSAGES/k8s.po", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsTestDefaultLc_messagesK8sMo = []byte("\xde\x12\x04\x95\x00\x00\x00\x00\x03\x00\x00\x00\x1c\x00\x00\x004\x00\x00\x00\x05\x00\x00\x00L\x00\x00\x00\x00\x00\x00\x00`\x00\x00\x00\x17\x00\x00\x00a\x00\x00\x00\v\x00\x00\x00y\x00\x00\x00\xac\x01\x00\x00\x85\x00\x00\x00%\x00\x00\x002\x02\x00\x00\x03\x00\x00\x00X\x02\x00\x00\x01\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00test_plural\x00test_plural\x00test_string\x00Project-Id-Version: gettext-go-examples-hello\nReport-Msgid-Bugs-To: \nPOT-Creation-Date: 2013-12-12 20:03+0000\nPO-Revision-Date: 2016-12-13 21:35-0800\nLast-Translator: Brendan Burns <brendan.d.burns@gmail.com>\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 8bit\nX-Generator: Poedit 1.6.10\nX-Poedit-SourceCharset: UTF-8\nLanguage-Team: \nPlural-Forms: nplurals=2; plural=(n != 1);\nLanguage: en\n\x00there was %d item\x00there were %d items\x00foo\x00")

func translationsTestDefaultLc_messagesK8sMoBytes() ([]byte, error) {
	return _translationsTestDefaultLc_messagesK8sMo, nil
}

func translationsTestDefaultLc_messagesK8sMo() (*asset, error) {
	bytes, err := translationsTestDefaultLc_messagesK8sMoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/test/default/LC_MESSAGES/k8s.mo", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsTestDefaultLc_messagesK8sPo = []byte(`# Test translations for unit tests.
# Copyright (C) 2016
# This file is distributed under the same license as the PACKAGE package.
# FIRST AUTHOR brendan.d.burns@gmail.com, 2016.
#
msgid ""
msgstr ""
"Project-Id-Version: gettext-go-examples-hello\n"
"Report-Msgid-Bugs-To: \n"
"POT-Creation-Date: 2013-12-12 20:03+0000\n"
"PO-Revision-Date: 2016-12-13 21:35-0800\n"
"Last-Translator: Brendan Burns <brendan.d.burns@gmail.com>\n"
"MIME-Version: 1.0\n"
"Content-Type: text/plain; charset=UTF-8\n"
"Content-Transfer-Encoding: 8bit\n"
"X-Generator: Poedit 1.6.10\n"
"X-Poedit-SourceCharset: UTF-8\n"
"Language-Team: \n"
"Plural-Forms: nplurals=2; plural=(n != 1);\n"
"Language: en\n"

msgid "test_plural"
msgid_plural "test_plural"
msgstr[0] "there was %d item"
msgstr[1] "there were %d items"

msgid "test_string"
msgstr "foo"
`)

func translationsTestDefaultLc_messagesK8sPoBytes() ([]byte, error) {
	return _translationsTestDefaultLc_messagesK8sPo, nil
}

func translationsTestDefaultLc_messagesK8sPo() (*asset, error) {
	bytes, err := translationsTestDefaultLc_messagesK8sPoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/test/default/LC_MESSAGES/k8s.po", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsTestEn_usLc_messagesK8sMo = []byte("\xde\x12\x04\x95\x00\x00\x00\x00\x03\x00\x00\x00\x1c\x00\x00\x004\x00\x00\x00\x05\x00\x00\x00L\x00\x00\x00\x00\x00\x00\x00`\x00\x00\x00\x17\x00\x00\x00a\x00\x00\x00\v\x00\x00\x00y\x00\x00\x00\xac\x01\x00\x00\x85\x00\x00\x00%\x00\x00\x002\x02\x00\x00\x03\x00\x00\x00X\x02\x00\x00\x01\x00\x00\x00\x03\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x02\x00\x00\x00\x00test_plural\x00test_plural\x00test_string\x00Project-Id-Version: gettext-go-examples-hello\nReport-Msgid-Bugs-To: \nPOT-Creation-Date: 2013-12-12 20:03+0000\nPO-Revision-Date: 2016-12-13 22:12-0800\nLast-Translator: Brendan Burns <brendan.d.burns@gmail.com>\nMIME-Version: 1.0\nContent-Type: text/plain; charset=UTF-8\nContent-Transfer-Encoding: 8bit\nX-Generator: Poedit 1.6.10\nX-Poedit-SourceCharset: UTF-8\nLanguage-Team: \nPlural-Forms: nplurals=2; plural=(n != 1);\nLanguage: en\n\x00there was %d item\x00there were %d items\x00baz\x00")

func translationsTestEn_usLc_messagesK8sMoBytes() ([]byte, error) {
	return _translationsTestEn_usLc_messagesK8sMo, nil
}

func translationsTestEn_usLc_messagesK8sMo() (*asset, error) {
	bytes, err := translationsTestEn_usLc_messagesK8sMoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/test/en_US/LC_MESSAGES/k8s.mo", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

var _translationsTestEn_usLc_messagesK8sPo = []byte(`# Test translations for unit tests.
# Copyright (C) 2016
# This file is distributed under the same license as the PACKAGE package.
# FIRST AUTHOR brendan.d.burns@gmail.com, 2016.
#
msgid ""
msgstr ""
"Project-Id-Version: gettext-go-examples-hello\n"
"Report-Msgid-Bugs-To: \n"
"POT-Creation-Date: 2013-12-12 20:03+0000\n"
"PO-Revision-Date: 2016-12-13 22:12-0800\n"
"Last-Translator: Brendan Burns <brendan.d.burns@gmail.com>\n"
"MIME-Version: 1.0\n"
"Content-Type: text/plain; charset=UTF-8\n"
"Content-Transfer-Encoding: 8bit\n"
"X-Generator: Poedit 1.6.10\n"
"X-Poedit-SourceCharset: UTF-8\n"
"Language-Team: \n"
"Plural-Forms: nplurals=2; plural=(n != 1);\n"
"Language: en\n"

msgid "test_plural"
msgid_plural "test_plural"
msgstr[0] "there was %d item"
msgstr[1] "there were %d items"

msgid "test_string"
msgstr "baz"
`)

func translationsTestEn_usLc_messagesK8sPoBytes() ([]byte, error) {
	return _translationsTestEn_usLc_messagesK8sPo, nil
}

func translationsTestEn_usLc_messagesK8sPo() (*asset, error) {
	bytes, err := translationsTestEn_usLc_messagesK8sPoBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "translations/test/en_US/LC_MESSAGES/k8s.po", size: 0, mode: os.FileMode(0), modTime: time.Unix(0, 0)}
	a := &asset{bytes: bytes, info: info}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[cannonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"translations/extract.py":                         translationsExtractPy,
	"translations/kubectl/OWNERS":                     translationsKubectlOwners,
	"translations/kubectl/default/LC_MESSAGES/k8s.mo": translationsKubectlDefaultLc_messagesK8sMo,
	"translations/kubectl/default/LC_MESSAGES/k8s.po": translationsKubectlDefaultLc_messagesK8sPo,
	"translations/kubectl/en_US/LC_MESSAGES/k8s.mo":   translationsKubectlEn_usLc_messagesK8sMo,
	"translations/kubectl/en_US/LC_MESSAGES/k8s.po":   translationsKubectlEn_usLc_messagesK8sPo,
	"translations/kubectl/fr_FR/LC_MESSAGES/k8s.mo":   translationsKubectlFr_frLc_messagesK8sMo,
	"translations/kubectl/fr_FR/LC_MESSAGES/k8s.po":   translationsKubectlFr_frLc_messagesK8sPo,
	"translations/kubectl/ja_JP/LC_MESSAGES/k8s.mo":   translationsKubectlJa_jpLc_messagesK8sMo,
	"translations/kubectl/ja_JP/LC_MESSAGES/k8s.po":   translationsKubectlJa_jpLc_messagesK8sPo,
	"translations/kubectl/template.pot":               translationsKubectlTemplatePot,
	"translations/kubectl/zh_CN/LC_MESSAGES/k8s.mo":   translationsKubectlZh_cnLc_messagesK8sMo,
	"translations/kubectl/zh_CN/LC_MESSAGES/k8s.po":   translationsKubectlZh_cnLc_messagesK8sPo,
	"translations/kubectl/zh_TW/LC_MESSAGES/k8s.mo":   translationsKubectlZh_twLc_messagesK8sMo,
	"translations/kubectl/zh_TW/LC_MESSAGES/k8s.po":   translationsKubectlZh_twLc_messagesK8sPo,
	"translations/test/default/LC_MESSAGES/k8s.mo":    translationsTestDefaultLc_messagesK8sMo,
	"translations/test/default/LC_MESSAGES/k8s.po":    translationsTestDefaultLc_messagesK8sPo,
	"translations/test/en_US/LC_MESSAGES/k8s.mo":      translationsTestEn_usLc_messagesK8sMo,
	"translations/test/en_US/LC_MESSAGES/k8s.po":      translationsTestEn_usLc_messagesK8sPo,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"}
// AssetDir("data/img") would return []string{"a.png", "b.png"}
// AssetDir("foo.txt") and AssetDir("notexist") would return an error
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		cannonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(cannonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"translations": {nil, map[string]*bintree{
		"extract.py": {translationsExtractPy, map[string]*bintree{}},
		"kubectl": {nil, map[string]*bintree{
			"OWNERS": {translationsKubectlOwners, map[string]*bintree{}},
			"default": {nil, map[string]*bintree{
				"LC_MESSAGES": {nil, map[string]*bintree{
					"k8s.mo": {translationsKubectlDefaultLc_messagesK8sMo, map[string]*bintree{}},
					"k8s.po": {translationsKubectlDefaultLc_messagesK8sPo, map[string]*bintree{}},
				}},
			}},
			"en_US": {nil, map[string]*bintree{
				"LC_MESSAGES": {nil, map[string]*bintree{
					"k8s.mo": {translationsKubectlEn_usLc_messagesK8sMo, map[string]*bintree{}},
					"k8s.po": {translationsKubectlEn_usLc_messagesK8sPo, map[string]*bintree{}},
				}},
			}},
			"fr_FR": {nil, map[string]*bintree{
				"LC_MESSAGES": {nil, map[string]*bintree{
					"k8s.mo": {translationsKubectlFr_frLc_messagesK8sMo, map[string]*bintree{}},
					"k8s.po": {translationsKubectlFr_frLc_messagesK8sPo, map[string]*bintree{}},
				}},
			}},
			"ja_JP": {nil, map[string]*bintree{
				"LC_MESSAGES": {nil, map[string]*bintree{
					"k8s.mo": {translationsKubectlJa_jpLc_messagesK8sMo, map[string]*bintree{}},
					"k8s.po": {translationsKubectlJa_jpLc_messagesK8sPo, map[string]*bintree{}},
				}},
			}},
			"template.pot": {translationsKubectlTemplatePot, map[string]*bintree{}},
			"zh_CN": {nil, map[string]*bintree{
				"LC_MESSAGES": {nil, map[string]*bintree{
					"k8s.mo": {translationsKubectlZh_cnLc_messagesK8sMo, map[string]*bintree{}},
					"k8s.po": {translationsKubectlZh_cnLc_messagesK8sPo, map[string]*bintree{}},
				}},
			}},
			"zh_TW": {nil, map[string]*bintree{
				"LC_MESSAGES": {nil, map[string]*bintree{
					"k8s.mo": {translationsKubectlZh_twLc_messagesK8sMo, map[string]*bintree{}},
					"k8s.po": {translationsKubectlZh_twLc_messagesK8sPo, map[string]*bintree{}},
				}},
			}},
		}},
		"test": {nil, map[string]*bintree{
			"default": {nil, map[string]*bintree{
				"LC_MESSAGES": {nil, map[string]*bintree{
					"k8s.mo": {translationsTestDefaultLc_messagesK8sMo, map[string]*bintree{}},
					"k8s.po": {translationsTestDefaultLc_messagesK8sPo, map[string]*bintree{}},
				}},
			}},
			"en_US": {nil, map[string]*bintree{
				"LC_MESSAGES": {nil, map[string]*bintree{
					"k8s.mo": {translationsTestEn_usLc_messagesK8sMo, map[string]*bintree{}},
					"k8s.po": {translationsTestEn_usLc_messagesK8sPo, map[string]*bintree{}},
				}},
			}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	err = os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
	if err != nil {
		return err
	}
	return nil
}

// RestoreAssets restores an asset under the given directory recursively
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	cannonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(cannonicalName, "/")...)...)
}
