/*
 * Copyright 2015 JBoss Inc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.wildfly.camel.test.common;

import java.util.Properties;

import org.junit.Test;
import org.wildfly.camel.test.common.utils.EnvironmentUtils;

public class EnvironmentUtilsTest  {

    @Test
    public void testEnvironment() throws Exception {
    	
    	Properties props = System.getProperties();
    	props.forEach((k,v) -> System.out.println(k + "=" + v));
    	
    	String osarch = EnvironmentUtils.getOSArch();
    	System.out.println(osarch);
    	
    	String osname = EnvironmentUtils.getOSName();
    	System.out.println(osname);
    	
    }
}
