#!/bin/bash

while getopts ":p:" opt; do
  case "${opt}" in
    p)
      PRODUCT_VERSION=${OPTARG}
      ;;
    :)
      echo "ERROR: Option -$OPTARG requires an argument"
      exit 1
      ;;
    \?)
      echo "ERROR: Invalid option -$OPTARG"
      exit 1
      ;;
  esac
done
shift $((OPTIND-1))

if [ -z "${PRODUCT_VERSION}" ]; then
  echo "${0} -p <product-version>"
  exit 1
fi

TAG_VERSION=$(echo "${PRODUCT_VERSION} - 6.0" | bc)
UPSTREAM_VERSION=$(echo "${TAG_VERSION} + 0.03" | bc)

SRC_ROOT="../.."

if [ ! -f "$(basename ${0})" ]; then
  echo "Please execute this script from its own directory"
  exit 1
fi

#######################################
#
# Upgrade this repository
#
#######################################

. ./bump-version-functions.sh

#
# Upgrade maven poms
#
upgrade_app ${UPSTREAM_VERSION}

#
# Upgrade makefile constant
#
upgrade_config_makefile ${PRODUCT_VERSION}

#
# Upgrade TAG VERSION in makefile
#
var_makefile="${SRC_ROOT}/install/operator/config/vars/Makefile"
if [ -f "${var_makefile}" ]; then
  echo "------"
  echo -n "Upgrading tag version in ${var_makefile} ... "

  sed -i "s/DEFAULT_TAG :=.*/DEFAULT_TAG := ${TAG_VERSION}/g" ${var_makefile}
  echo "done"
fi

#
# Upgrade install defaults
#
go_defaults="${SRC_ROOT}/install/operator/pkg/cmd/internal/install/install_defaults.go"
if [ -f "${go_defaults}" ]; then
  echo "------"
  echo -n "Upgrading ${go_defaults} ... "
  sed -i 's/productVersion = .*/productVersion = \"'${PRODUCT_VERSION}'\"/g' ${go_defaults}
  echo "done"
fi

#
# Upgrade related images patch
#
images_patch="${SRC_ROOT}/install/operator/config/manager/patches/related-images-patch.yaml"
if [ -f "${images_patch}" ]; then
  echo "------"
  echo -n "Upgrading ${images_patch} ..."
  sed -i "s/\(.*\)fuse7-fuse\(.*\):.*/\1fuse7-fuse\2:${TAG_VERSION}/g" ${images_patch}
  echo "done"
fi

#
# Upgrade build config file for operator
#
upgrade_build_config ${PRODUCT_VERSION}

#
# Upgrade github workflow for daily releases
#
upgrade_github_workflow ${UPSTREAM_VERSION}
