/*
 * Copyright (C) 2016 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.syndesis.dv;

public final class StringConstants {

    /**
     * An empty string array.
     */
    public static final String[] EMPTY_ARRAY = new String[0];

    /**
     * An empty string
     */
    public static final String EMPTY_STRING = ""; //$NON-NLS-1$

    /**
     * A space.
     */
    public static final String SPACE = " "; //$NON-NLS-1$

    /**
     * An underscore.
     */
    public static final String UNDERSCORE = "_"; //$NON-NLS-1$

    /**
     * The String "\n"
     */
    public static final String NEW_LINE = "\n"; //$NON-NLS-1$

    /**
     * A Comma.
     */
    public static final String COMMA = ","; //$NON-NLS-1$

    /**
     * A Semi Colon.
     */
    public static final String SEMI_COLON = ";"; //$NON-NLS-1$

    /**
     * A Hyphen.
     */
    public static final String HYPHEN = "-"; //$NON-NLS-1$

    /**
     * A Dot.
     */
    public static final String DOT = "."; //$NON-NLS-1$

    /**
     * Forward slash
     */
    public static final String FS = "/"; //$NON-NLS-1$

    /**
     * Equals
     */
    public static final String EQUALS = "="; //$NON-NLS-1$

    /**
     * Open Bracket
     */
    public static final String OPEN_BRACKET = "("; //$NON-NLS-1$

    /**
     * Close Bracket
     */
    public static final String CLOSE_BRACKET = ")"; //$NON-NLS-1$

    /**
     * Open Brace
     */
    public static final String OPEN_BRACE = "{"; //$NON-NLS-1$

    /**
     * Close Brace
     */
    public static final String CLOSE_BRACE = "}"; //$NON-NLS-1$

    /**
     * Breaking tag
     */
    public static final String BR = "<br>"; //$NON-NLS-1$

    /**
     * Opening pre tag
     */
    public static final String OPEN_PRE_TAG = "<pre>"; //$NON-NLS-1$

    /**
     * Closing pre tag
     */
    public static final String CLOSE_PRE_TAG = "</pre>"; //$NON-NLS-1$

    /**
     * Non-breaking HTML space
     */
    public static final String NBSP = "&nbsp;"; //$NON-NLS-1$

    /**
     * Open pre-cmt tag with class
     */
    public static final String OPEN_PRE_CMT = "<pre-cmt class=\"json-comment\">"; //$NON-NLS-1$

    /**
     * Close pre-cmt tag
     */
    public static final String CLOSE_PRE_CMT = "</pre-cmt>"; //$NON-NLS-1$

    /**
     * Java temp directory
     */
    public static final String JAVA_IO_TMPDIR = "java.io.tmpdir"; //$NON-NLS-1$

    /**
     * Service vdb suffix
     */
    public static final String SERVICE_VDB_SUFFIX = "vdb"; //$NON-NLS-1$

    private StringConstants() {
        // utility class
    }
}
