/*
 * Copyright (C) 2016 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.syndesis.dv.server.endpoint;

import java.util.List;

import com.fasterxml.jackson.databind.annotation.JsonSerialize;

import io.syndesis.dv.model.TablePrivileges;

/**
 * Metadata, no state, related to a view.
 *
 * TODO: Eventually the list could include a type (table, view, procedure, etc.)
 */
@JsonSerialize(as = ViewListing.class)
public class ViewListing {

    private String id;
    private String name;
    private String description;
    private boolean valid;
    private List<TablePrivileges> tablePrivileges;

    public String getId() {
        return id;
    }
    public void setId(String id) {
        this.id = id;
    }
    public String getName() {
        return name;
    }
    public void setName(String name) {
        this.name = name;
    }
    public String getDescription() {
        return description;
    }
    public void setDescription(String description) {
        this.description = description;
    }
    public boolean isValid() {
        return valid;
    }
    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public List<TablePrivileges> getTablePrivileges() {
        return tablePrivileges;
    }

    public void setTablePrivileges(List<TablePrivileges> tablePrivileges) {
        this.tablePrivileges = tablePrivileges;
    }
}
