/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.hazelcast.it;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import org.junit.jupiter.api.Test;

@QuarkusTest
class HazelcastTest {

    @Test
    public void loadComponentHazelcastAtomicvalue() {
        /* A simple autogenerated test */
        RestAssured.get("/hazelcast/load/component/hazelcast-atomicvalue")
                .then()
                .statusCode(200);
    }

    @Test
    public void loadComponentHazelcastInstance() {
        /* A simple autogenerated test */
        RestAssured.get("/hazelcast/load/component/hazelcast-instance")
                .then()
                .statusCode(200);
    }

    @Test
    public void loadComponentHazelcastList() {
        /* A simple autogenerated test */
        RestAssured.get("/hazelcast/load/component/hazelcast-list")
                .then()
                .statusCode(200);
    }

    @Test
    public void loadComponentHazelcastMap() {
        /* A simple autogenerated test */
        RestAssured.get("/hazelcast/load/component/hazelcast-map")
                .then()
                .statusCode(200);
    }

    @Test
    public void loadComponentHazelcastMultimap() {
        /* A simple autogenerated test */
        RestAssured.get("/hazelcast/load/component/hazelcast-multimap")
                .then()
                .statusCode(200);
    }

    @Test
    public void loadComponentHazelcastQueue() {
        /* A simple autogenerated test */
        RestAssured.get("/hazelcast/load/component/hazelcast-queue")
                .then()
                .statusCode(200);
    }

    @Test
    public void loadComponentHazelcastReplicatedmap() {
        /* A simple autogenerated test */
        RestAssured.get("/hazelcast/load/component/hazelcast-replicatedmap")
                .then()
                .statusCode(200);
    }

    @Test
    public void loadComponentHazelcastRingbuffer() {
        /* A simple autogenerated test */
        RestAssured.get("/hazelcast/load/component/hazelcast-ringbuffer")
                .then()
                .statusCode(200);
    }

    @Test
    public void loadComponentHazelcastSeda() {
        /* A simple autogenerated test */
        RestAssured.get("/hazelcast/load/component/hazelcast-seda")
                .then()
                .statusCode(200);
    }

    @Test
    public void loadComponentHazelcastSet() {
        /* A simple autogenerated test */
        RestAssured.get("/hazelcast/load/component/hazelcast-set")
                .then()
                .statusCode(200);
    }

    @Test
    public void loadComponentHazelcastTopic() {
        /* A simple autogenerated test */
        RestAssured.get("/hazelcast/load/component/hazelcast-topic")
                .then()
                .statusCode(200);
    }

}
