/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.crypto.cms.util;

import java.util.Hashtable;

import org.apache.camel.Exchange;
import org.apache.camel.component.crypto.cms.common.AttributesGeneratorProvider;
import org.apache.camel.component.crypto.cms.exception.CryptoCmsException;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;

public class TestAttributesGeneratorProvider implements AttributesGeneratorProvider {

    @Override
    public CMSAttributeTableGenerator getAttributesGenerator(Exchange excange) throws CryptoCmsException {
        Hashtable<ASN1ObjectIdentifier, Attribute> attrs = new Hashtable<>();

        attrs.put(PKCSObjectIdentifiers.id_aa_contentHint,
                new Attribute(PKCSObjectIdentifiers.id_aa_contentHint, new DERSet(new DERUTF8String("Hint"))));
        attrs.put(PKCSObjectIdentifiers.id_aa_receiptRequest,
                new Attribute(PKCSObjectIdentifiers.id_aa_receiptRequest, new DERSet(new DERUTF8String("Request"))));

        AttributeTable attrTable = new AttributeTable(attrs);

        return new SimpleAttributeTableGenerator(attrTable);
    }

}
