# Changelog

## [camel-kafka-connector-0.5.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.5.0) (2020-09-08)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.4.0...camel-kafka-connector-0.5.0)

**Implemented enhancements:**

- Add the connector class to use in the documentation of each connector [\#321](https://github.com/apache/camel-kafka-connector/issues/321)
- Support multiple topics for connector configuration [\#197](https://github.com/apache/camel-kafka-connector/issues/197)
- Generate a catalog of supported connectors [\#141](https://github.com/apache/camel-kafka-connector/issues/141)

**Fixed bugs:**

- flaky syslog integration test  [\#367](https://github.com/apache/camel-kafka-connector/issues/367)
- UnitOfWork.done\(\) needs to be called on Polled exchanges [\#202](https://github.com/apache/camel-kafka-connector/issues/202)

**Closed issues:**

- Unreleased Resource: Database [\#436](https://github.com/apache/camel-kafka-connector/issues/436)
- Create an NSQ example [\#429](https://github.com/apache/camel-kafka-connector/issues/429)
- Archetype: Add a parameter to the archetype generator to be able to specify what connector we want to extend [\#419](https://github.com/apache/camel-kafka-connector/issues/419)
- aws2-S3-connector: \(gzip/zip\) compression with sink [\#387](https://github.com/apache/camel-kafka-connector/issues/387)
- Discussion: troubleshooting documentation? [\#381](https://github.com/apache/camel-kafka-connector/issues/381)
- Bump to Camel 3.4.3 [\#379](https://github.com/apache/camel-kafka-connector/issues/379)
- Documentation: SJMS2 connector is incompatible with activemq-all [\#378](https://github.com/apache/camel-kafka-connector/issues/378)
- Unclean startup causes an NPE on shutdown [\#376](https://github.com/apache/camel-kafka-connector/issues/376)
- Make the camel-kafka-connector archetype use the parent POM [\#362](https://github.com/apache/camel-kafka-connector/issues/362)
- Exception on endpoint being treated as a polling consumer before createPollingConsumer is called. [\#361](https://github.com/apache/camel-kafka-connector/issues/361)
- Add a Nats connector examples in camel-kafka-connector-examples repo [\#359](https://github.com/apache/camel-kafka-connector/issues/359)
- Add a compatibility matrix related to camel version in docs [\#344](https://github.com/apache/camel-kafka-connector/issues/344)
- CamelAwssqsSinkConnector does not work when specifying AWS credentials in camel.sink.endpoint [\#319](https://github.com/apache/camel-kafka-connector/issues/319)
- Create a Kinesis Firehose Connector example [\#318](https://github.com/apache/camel-kafka-connector/issues/318)
- Nullpointer exception at org.apache.camel.component.aws2.s3.AWS2S3Producer.processSingleOp [\#299](https://github.com/apache/camel-kafka-connector/issues/299)
- Add Aggregate integration test [\#291](https://github.com/apache/camel-kafka-connector/issues/291)
- Enable testRetrieveFromCassandraWithCustomStrategy on CamelSourceCassandraITCase [\#288](https://github.com/apache/camel-kafka-connector/issues/288)

**Merged pull requests:**

- Fix potentially unreleased DB resources in test code [\#437](https://github.com/apache/camel-kafka-connector/pull/437) ([orpiske](https://github.com/orpiske))
- Automatic changelog: Run it just one time during the night [\#435](https://github.com/apache/camel-kafka-connector/pull/435) ([oscerd](https://github.com/oscerd))
- Run the changelog automatic updated every hour [\#434](https://github.com/apache/camel-kafka-connector/pull/434) ([oscerd](https://github.com/oscerd))
- Update try-it-out-on-openshift-with-strimzi.adoc with latest AWS S3 connector config [\#433](https://github.com/apache/camel-kafka-connector/pull/433) ([smccarthy-ie](https://github.com/smccarthy-ie))
- Pr Build and push build needs to point to master [\#432](https://github.com/apache/camel-kafka-connector/pull/432) ([oscerd](https://github.com/oscerd))
- adding a key transformer to the AWS2-SQS connector so that the CamelH… [\#431](https://github.com/apache/camel-kafka-connector/pull/431) ([codexetreme](https://github.com/codexetreme))
- Proposed fix for issue \#414 [\#428](https://github.com/apache/camel-kafka-connector/pull/428) ([orpiske](https://github.com/orpiske))
- Camel 3.5.0 [\#427](https://github.com/apache/camel-kafka-connector/pull/427) ([oscerd](https://github.com/oscerd))
- Docs: Updated archetypes docs [\#422](https://github.com/apache/camel-kafka-connector/pull/422) ([oscerd](https://github.com/oscerd))
- Archetype: Add a parameter to the archetype generator to be able to s… [\#421](https://github.com/apache/camel-kafka-connector/pull/421) ([oscerd](https://github.com/oscerd))
- Fix a minor typo [\#420](https://github.com/apache/camel-kafka-connector/pull/420) ([oscerd](https://github.com/oscerd))
- Removed deploy phase from jenkinsfile, we already have the daily snap… [\#418](https://github.com/apache/camel-kafka-connector/pull/418) ([oscerd](https://github.com/oscerd))
- Remove deploy phase from Jenkinsfile, we have the daily snapshot depl… [\#417](https://github.com/apache/camel-kafka-connector/pull/417) ([oscerd](https://github.com/oscerd))
- \[Github Actions\] Periodic Sync Camel-kafka-connector camel-master Branch [\#416](https://github.com/apache/camel-kafka-connector/pull/416) ([github-actions[bot]](https://github.com/apps/github-actions))
- Activemq-all note for SJMS2 connector [\#415](https://github.com/apache/camel-kafka-connector/pull/415) ([oscerd](https://github.com/oscerd))
- Rework the testing documentation and adds test writing details [\#413](https://github.com/apache/camel-kafka-connector/pull/413) ([orpiske](https://github.com/orpiske))
- Added new test for Azure Storage Queue sink [\#412](https://github.com/apache/camel-kafka-connector/pull/412) ([orpiske](https://github.com/orpiske))
- Support Multiple topics on Source Connector [\#411](https://github.com/apache/camel-kafka-connector/pull/411) ([oscerd](https://github.com/oscerd))
- Added connector class on each connector documentation page [\#405](https://github.com/apache/camel-kafka-connector/pull/405) ([oscerd](https://github.com/oscerd))
- Added a pipeline for deploying on daily basis [\#404](https://github.com/apache/camel-kafka-connector/pull/404) ([oscerd](https://github.com/oscerd))
- \#389 - Fix doc- Kubernetes command [\#401](https://github.com/apache/camel-kafka-connector/pull/401) ([rogeriob2br](https://github.com/rogeriob2br))
- Fix mongodb test [\#396](https://github.com/apache/camel-kafka-connector/pull/396) ([unsortedhashsets](https://github.com/unsortedhashsets))
- Removed wrong terminal output from example in archetype docs [\#394](https://github.com/apache/camel-kafka-connector/pull/394) ([oscerd](https://github.com/oscerd))
- Kafka-clients is not a test dependency [\#393](https://github.com/apache/camel-kafka-connector/pull/393) ([oscerd](https://github.com/oscerd))
- Added automatic-sync gh action for camel-kafka-connector on camel-mas… [\#392](https://github.com/apache/camel-kafka-connector/pull/392) ([oscerd](https://github.com/oscerd))
- Adds basic aggregation test \(github issue \#291\) [\#388](https://github.com/apache/camel-kafka-connector/pull/388) ([orpiske](https://github.com/orpiske))
- Fix flaky syslog test [\#386](https://github.com/apache/camel-kafka-connector/pull/386) ([orpiske](https://github.com/orpiske))
- Added a simple troubleshooting guide [\#383](https://github.com/apache/camel-kafka-connector/pull/383) ([orpiske](https://github.com/orpiske))
- Upgrade to camel 3.4.3 [\#380](https://github.com/apache/camel-kafka-connector/pull/380) ([oscerd](https://github.com/oscerd))
- Prevent NPEs on shutdown when critical errors occur [\#377](https://github.com/apache/camel-kafka-connector/pull/377) ([orpiske](https://github.com/orpiske))
- Fixed incorrect number of log arguments in S3 exception handling [\#375](https://github.com/apache/camel-kafka-connector/pull/375) ([orpiske](https://github.com/orpiske))
- Defer topic deletion [\#374](https://github.com/apache/camel-kafka-connector/pull/374) ([orpiske](https://github.com/orpiske))
- Fixes for edge cases [\#373](https://github.com/apache/camel-kafka-connector/pull/373) ([orpiske](https://github.com/orpiske))
- Added missing fromUrl to the log message [\#372](https://github.com/apache/camel-kafka-connector/pull/372) ([orpiske](https://github.com/orpiske))
- Removes debugging message [\#370](https://github.com/apache/camel-kafka-connector/pull/370) ([orpiske](https://github.com/orpiske))
- Removing backport gh action. It doesn't work. [\#369](https://github.com/apache/camel-kafka-connector/pull/369) ([oscerd](https://github.com/oscerd))
- Minor AWS tests cleanups [\#368](https://github.com/apache/camel-kafka-connector/pull/368) ([orpiske](https://github.com/orpiske))
- Building endpoint uris should for secret options automatic use RAW\(\) … [\#366](https://github.com/apache/camel-kafka-connector/pull/366) ([davsclaus](https://github.com/davsclaus))
- Cutting down connectors [\#365](https://github.com/apache/camel-kafka-connector/pull/365) ([oscerd](https://github.com/oscerd))
- Make the camel-kafka-connector archetype use the parent POM [\#363](https://github.com/apache/camel-kafka-connector/pull/363) ([oscerd](https://github.com/oscerd))
- AWS SDK v2 integration tests: Kinesis [\#358](https://github.com/apache/camel-kafka-connector/pull/358) ([orpiske](https://github.com/orpiske))
- Use latest Strimzi's docker images [\#357](https://github.com/apache/camel-kafka-connector/pull/357) ([oscerd](https://github.com/oscerd))
- Fixed camel compatibility matrix table [\#356](https://github.com/apache/camel-kafka-connector/pull/356) ([oscerd](https://github.com/oscerd))
- Added a camel-compatibility matrix page [\#355](https://github.com/apache/camel-kafka-connector/pull/355) ([oscerd](https://github.com/oscerd))
- Upgrade Archetype docs [\#354](https://github.com/apache/camel-kafka-connector/pull/354) ([oscerd](https://github.com/oscerd))
- Fixed index adoc [\#352](https://github.com/apache/camel-kafka-connector/pull/352) ([oscerd](https://github.com/oscerd))
- Added missing connector in connectors pom [\#350](https://github.com/apache/camel-kafka-connector/pull/350) ([oscerd](https://github.com/oscerd))
- Release 0.4.0 [\#346](https://github.com/apache/camel-kafka-connector/pull/346) ([oscerd](https://github.com/oscerd))
- AWS Kinesis test fixes when in remote mode [\#345](https://github.com/apache/camel-kafka-connector/pull/345) ([orpiske](https://github.com/orpiske))

## [camel-kafka-connector-0.4.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.4.0) (2020-07-29)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.3.0...camel-kafka-connector-0.4.0)

**Implemented enhancements:**

- Being able to inject an aggregator in a sink connector [\#274](https://github.com/apache/camel-kafka-connector/issues/274)
- In case of Sink we need to use toD instead of to [\#252](https://github.com/apache/camel-kafka-connector/issues/252)
- Upgrade to Kafka 2.5.0 [\#249](https://github.com/apache/camel-kafka-connector/issues/249)
- Improve integration test support when component dependencies are present [\#211](https://github.com/apache/camel-kafka-connector/issues/211)
- Support both marshal and unmarshal in source and sinks [\#194](https://github.com/apache/camel-kafka-connector/issues/194)
- camel-kafka-connector-generator-maven-plugin: implement a component exclusion mechanism [\#148](https://github.com/apache/camel-kafka-connector/issues/148)

**Fixed bugs:**

- BigDecimal values are not handled correctly in Headers serialization and deserialization [\#325](https://github.com/apache/camel-kafka-connector/issues/325)
- Camel HDFS: does not work due to dependencies conflicts [\#263](https://github.com/apache/camel-kafka-connector/issues/263)
- NullPointerException during shutdown when using Salesforce component [\#245](https://github.com/apache/camel-kafka-connector/issues/245)

**Closed issues:**

- Camel-Elasticsearch Connector not working on OpenShift [\#342](https://github.com/apache/camel-kafka-connector/issues/342)
- aws2S3connector connected to minio ClassCastException [\#338](https://github.com/apache/camel-kafka-connector/issues/338)
- Add documentation for archetype [\#333](https://github.com/apache/camel-kafka-connector/issues/333)
- Add an archetype to be able to extend the existing connectors with converters/aggregators/transformations/pojo etc. [\#329](https://github.com/apache/camel-kafka-connector/issues/329)
- The committed block count cannot exceed the maximum limit of 50,000 blocks. [\#324](https://github.com/apache/camel-kafka-connector/issues/324)
- Upgrade to Camel 3.4.2 once released [\#322](https://github.com/apache/camel-kafka-connector/issues/322)
- CamelAwssqsSinkConnector is leaking AWS credentials into Kafka Connect log [\#320](https://github.com/apache/camel-kafka-connector/issues/320)
- How install camel-jira-kafka-connector [\#315](https://github.com/apache/camel-kafka-connector/issues/315)
- From S3 to kafka, when using Idempotent filter, Do we still fetch S3 file content ? [\#314](https://github.com/apache/camel-kafka-connector/issues/314)
- How to break messages when ingesting into kafka [\#313](https://github.com/apache/camel-kafka-connector/issues/313)
- In S3 source connector, how to fetch only new files ? [\#311](https://github.com/apache/camel-kafka-connector/issues/311)
- CAMEL-15063 work-around may be removed [\#310](https://github.com/apache/camel-kafka-connector/issues/310)
- Add an aggregation page in docs [\#303](https://github.com/apache/camel-kafka-connector/issues/303)
- Outdated camel-dependencies version? [\#297](https://github.com/apache/camel-kafka-connector/issues/297)
- Aggregator support for completionTimeout too [\#290](https://github.com/apache/camel-kafka-connector/issues/290)
- Upgrade to Camel 3.4.0 LTS version [\#283](https://github.com/apache/camel-kafka-connector/issues/283)
- Camel-MongoDB Kafka connector: example with sink connector [\#212](https://github.com/apache/camel-kafka-connector/issues/212)

**Merged pull requests:**

- Issue/194 [\#341](https://github.com/apache/camel-kafka-connector/pull/341) ([valdar](https://github.com/valdar))
- Re-enable a Cassandra test disabled due to CAMEL-15219 [\#337](https://github.com/apache/camel-kafka-connector/pull/337) ([orpiske](https://github.com/orpiske))
- Add CORE protocol support to SJMS2 connector [\#336](https://github.com/apache/camel-kafka-connector/pull/336) ([fvaleri](https://github.com/fvaleri))
- Document how to run camel-kafka-connector on Kubernetes. [\#335](https://github.com/apache/camel-kafka-connector/pull/335) ([fvaleri](https://github.com/fvaleri))
- Archetypes docs [\#334](https://github.com/apache/camel-kafka-connector/pull/334) ([oscerd](https://github.com/oscerd))
- Added Aggregation documentation [\#332](https://github.com/apache/camel-kafka-connector/pull/332) ([oscerd](https://github.com/oscerd))
- Introducing a camel-kafka-connector-extensible archetype for adding b… [\#330](https://github.com/apache/camel-kafka-connector/pull/330) ([oscerd](https://github.com/oscerd))
- Adds a new manual integration test for Slack source [\#328](https://github.com/apache/camel-kafka-connector/pull/328) ([orpiske](https://github.com/orpiske))
- Bump Camel to version 3.4.2 [\#327](https://github.com/apache/camel-kafka-connector/pull/327) ([oscerd](https://github.com/oscerd))
- Issue/325 [\#326](https://github.com/apache/camel-kafka-connector/pull/326) ([valdar](https://github.com/valdar))
- Added additional explanation about testing  [\#317](https://github.com/apache/camel-kafka-connector/pull/317) ([orpiske](https://github.com/orpiske))
- Added tests for JDBC sink [\#316](https://github.com/apache/camel-kafka-connector/pull/316) ([orpiske](https://github.com/orpiske))
- Reverts the work-around for CAMEL-15063 [\#312](https://github.com/apache/camel-kafka-connector/pull/312) ([orpiske](https://github.com/orpiske))
- Fix HDFS tests with Camel 3.4 \(related to issue \#263\) [\#309](https://github.com/apache/camel-kafka-connector/pull/309) ([orpiske](https://github.com/orpiske))
- Fixes AWS test cases when running with remote AWS services [\#308](https://github.com/apache/camel-kafka-connector/pull/308) ([orpiske](https://github.com/orpiske))
- Avoid logging the autoconfiguration summary from CamelMain [\#307](https://github.com/apache/camel-kafka-connector/pull/307) ([oscerd](https://github.com/oscerd))
- Upgrade Kafka to version 2.5.0 [\#306](https://github.com/apache/camel-kafka-connector/pull/306) ([oscerd](https://github.com/oscerd))
- Fix Typo in CamelTypeConverterTransform [\#304](https://github.com/apache/camel-kafka-connector/pull/304) ([oscerd](https://github.com/oscerd))
- Added Aggregation timeout [\#301](https://github.com/apache/camel-kafka-connector/pull/301) ([oscerd](https://github.com/oscerd))
- Fixes camel-dependencies to point to 3.4.0 [\#298](https://github.com/apache/camel-kafka-connector/pull/298) ([oscerd](https://github.com/oscerd))
- ToD support [\#296](https://github.com/apache/camel-kafka-connector/pull/296) ([oscerd](https://github.com/oscerd))
- Add tests for MongoDB [\#295](https://github.com/apache/camel-kafka-connector/pull/295) ([orpiske](https://github.com/orpiske))
- Temporarily disable HDFS tests due to issue \#263 [\#294](https://github.com/apache/camel-kafka-connector/pull/294) ([orpiske](https://github.com/orpiske))
- Bump to Camel 3.4.0 [\#293](https://github.com/apache/camel-kafka-connector/pull/293) ([oscerd](https://github.com/oscerd))
- Updated the packages docs page [\#292](https://github.com/apache/camel-kafka-connector/pull/292) ([oscerd](https://github.com/oscerd))
- Aggregate Support [\#289](https://github.com/apache/camel-kafka-connector/pull/289) ([oscerd](https://github.com/oscerd))
- Cassandra test improvements [\#286](https://github.com/apache/camel-kafka-connector/pull/286) ([orpiske](https://github.com/orpiske))
- Backport [\#285](https://github.com/apache/camel-kafka-connector/pull/285) ([oscerd](https://github.com/oscerd))
- Use release 0.3.0 as lastReleasedVersion [\#284](https://github.com/apache/camel-kafka-connector/pull/284) ([oscerd](https://github.com/oscerd))
- Fixed component exclusion in combination with filter [\#281](https://github.com/apache/camel-kafka-connector/pull/281) ([oscerd](https://github.com/oscerd))
- Component exclusion [\#278](https://github.com/apache/camel-kafka-connector/pull/278) ([oscerd](https://github.com/oscerd))
- Added tests for Camel HDFS Sink [\#277](https://github.com/apache/camel-kafka-connector/pull/277) ([orpiske](https://github.com/orpiske))

## [camel-kafka-connector-0.3.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.3.0) (2020-06-17)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.2.0...camel-kafka-connector-0.3.0)

**Implemented enhancements:**

- Use camel-depencencies to import versions of common libraries like Jakson, qpid, log4j etc. [\#241](https://github.com/apache/camel-kafka-connector/issues/241)
- Autogenerate and example config file for each connector [\#220](https://github.com/apache/camel-kafka-connector/issues/220)
- S3 source connector delete files from source bucket [\#97](https://github.com/apache/camel-kafka-connector/issues/97)
-  Create example and itest for camel-syslog [\#77](https://github.com/apache/camel-kafka-connector/issues/77)

**Fixed bugs:**

- Camel-elasticsearch-rest-kafka-connector throws java.lang.NoClassDefFoundError: org/apache/logging/log4j/LogManager [\#259](https://github.com/apache/camel-kafka-connector/issues/259)
- Wrong signature of autogenerated method `public static ConfigDef conf\(Map\<String, String\> parsedConfig\)` of each `Camel\*ConnectorConfig` [\#221](https://github.com/apache/camel-kafka-connector/issues/221)
- Possible problems in CamelSinkAWSSQSITCase tests [\#215](https://github.com/apache/camel-kafka-connector/issues/215)

**Closed issues:**

- Question: How to provide aws role:arn value to authenticate S3  [\#267](https://github.com/apache/camel-kafka-connector/issues/267)
- Add CamelAMQP source and sink example properties [\#264](https://github.com/apache/camel-kafka-connector/issues/264)
- Add download links to the connectors list page [\#261](https://github.com/apache/camel-kafka-connector/issues/261)
- AWS S3: bucket name not resolved when using URL configuration [\#260](https://github.com/apache/camel-kafka-connector/issues/260)
- Caused by: java.lang.NoClassDefFoundError: Could not initialize class org.apache.camel.kafkaconnector.CamelSinkConnectorConfig [\#251](https://github.com/apache/camel-kafka-connector/issues/251)
- Camel AWS2-S3: Add the same converters and transforms we have for AWS-S3 connector [\#250](https://github.com/apache/camel-kafka-connector/issues/250)
- pls  [\#248](https://github.com/apache/camel-kafka-connector/issues/248)
- Connectors doc generation shuld be moved from `core` to `connectors` module [\#226](https://github.com/apache/camel-kafka-connector/issues/226)
- Investigate why syslog documentation result in a missing link [\#225](https://github.com/apache/camel-kafka-connector/issues/225)
- CamelSinkTask Properties need to be cleaned up before going ahead [\#224](https://github.com/apache/camel-kafka-connector/issues/224)
- CamelSinkTask headers must be cleaned before sending them ahead [\#223](https://github.com/apache/camel-kafka-connector/issues/223)
- Updater the readme of autogenerated connectors doc page [\#219](https://github.com/apache/camel-kafka-connector/issues/219)
- Bump to Camel 3.3.0 [\#217](https://github.com/apache/camel-kafka-connector/issues/217)

**Merged pull requests:**

- Fix a javadoc issue. [\#276](https://github.com/apache/camel-kafka-connector/pull/276) ([valdar](https://github.com/valdar))
- fix \#259: Camel-elasticsearch-rest-kafka-connector throws java.lang.N… [\#275](https://github.com/apache/camel-kafka-connector/pull/275) ([valdar](https://github.com/valdar))
- Throw ConnectException due to failed exchanges [\#273](https://github.com/apache/camel-kafka-connector/pull/273) ([omarsmak](https://github.com/omarsmak))
- Issue/260 [\#272](https://github.com/apache/camel-kafka-connector/pull/272) ([valdar](https://github.com/valdar))
- Test modularization cleanups [\#271](https://github.com/apache/camel-kafka-connector/pull/271) ([orpiske](https://github.com/orpiske))
- AWS2-S3 connector: Added the same set of converters/transformers we h… [\#268](https://github.com/apache/camel-kafka-connector/pull/268) ([oscerd](https://github.com/oscerd))
- Docs download link [\#266](https://github.com/apache/camel-kafka-connector/pull/266) ([oscerd](https://github.com/oscerd))
- Add AMQP examples for source and sink [\#265](https://github.com/apache/camel-kafka-connector/pull/265) ([rgannu](https://github.com/rgannu))
- Split the tests in modules per service [\#262](https://github.com/apache/camel-kafka-connector/pull/262) ([orpiske](https://github.com/orpiske))
- chore\(pgp\): update pgp key for Nicola Ferraro [\#256](https://github.com/apache/camel-kafka-connector/pull/256) ([nicolaferraro](https://github.com/nicolaferraro))
- Updated try-it-out-on-openshift-with-strimzi.adoc [\#255](https://github.com/apache/camel-kafka-connector/pull/255) ([valdar](https://github.com/valdar))
- Adds integration tests for Salesforce [\#247](https://github.com/apache/camel-kafka-connector/pull/247) ([orpiske](https://github.com/orpiske))
- Fixed quickstarts docs [\#246](https://github.com/apache/camel-kafka-connector/pull/246) ([oscerd](https://github.com/oscerd))
- Sf fix [\#244](https://github.com/apache/camel-kafka-connector/pull/244) ([valdar](https://github.com/valdar))
- Use camel-depencencies to import versions of common libraries like Ja… [\#243](https://github.com/apache/camel-kafka-connector/pull/243) ([oscerd](https://github.com/oscerd))
- Fix CamelSinkAWSSQSITCase unreliability with blocking initialization [\#242](https://github.com/apache/camel-kafka-connector/pull/242) ([orpiske](https://github.com/orpiske))
- Bump Log4j to version 2.13.3 [\#240](https://github.com/apache/camel-kafka-connector/pull/240) ([oscerd](https://github.com/oscerd))
- Example prop autogen [\#239](https://github.com/apache/camel-kafka-connector/pull/239) ([valdar](https://github.com/valdar))
- Bump Jackson to version 2.10.4 [\#238](https://github.com/apache/camel-kafka-connector/pull/238) ([oscerd](https://github.com/oscerd))
- Bump Qpid JMS client to version 0.51.0 [\#237](https://github.com/apache/camel-kafka-connector/pull/237) ([oscerd](https://github.com/oscerd))
- Upgrade Strimzi images to 0.18.0-kafka-2.4.1 [\#236](https://github.com/apache/camel-kafka-connector/pull/236) ([oscerd](https://github.com/oscerd))
- CamelSinkTask Properties need to be cleaned up before going ahead [\#235](https://github.com/apache/camel-kafka-connector/pull/235) ([oscerd](https://github.com/oscerd))
- CamelSinkTask headers must be cleaned before sending them ahead [\#232](https://github.com/apache/camel-kafka-connector/pull/232) ([oscerd](https://github.com/oscerd))
- Bump to Camel 3.3.0 [\#231](https://github.com/apache/camel-kafka-connector/pull/231) ([oscerd](https://github.com/oscerd))
- Version bump to Camel 3.3.0 [\#230](https://github.com/apache/camel-kafka-connector/pull/230) ([orpiske](https://github.com/orpiske))
- Connectors doc generation shuld be moved from `core` to `connectors` … [\#229](https://github.com/apache/camel-kafka-connector/pull/229) ([oscerd](https://github.com/oscerd))
- Syslog docs [\#227](https://github.com/apache/camel-kafka-connector/pull/227) ([oscerd](https://github.com/oscerd))
- Fixed con cong autogen [\#222](https://github.com/apache/camel-kafka-connector/pull/222) ([valdar](https://github.com/valdar))
- Remove core from test plugin path [\#218](https://github.com/apache/camel-kafka-connector/pull/218) ([orpiske](https://github.com/orpiske))
- Sink test refactoring [\#216](https://github.com/apache/camel-kafka-connector/pull/216) ([fvaleri](https://github.com/fvaleri))
- Add contentLogLevel task property [\#193](https://github.com/apache/camel-kafka-connector/pull/193) ([fvaleri](https://github.com/fvaleri))

## [camel-kafka-connector-0.2.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.2.0) (2020-05-17)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/camel-kafka-connector-0.1.0...camel-kafka-connector-0.2.0)

**Implemented enhancements:**

- Avoid Thread.sleep in test, use Awaitility FTW [\#186](https://github.com/apache/camel-kafka-connector/issues/186)
- make the topics property consistent between source and sink connectors [\#175](https://github.com/apache/camel-kafka-connector/issues/175)
- Produce an assembly artifact containing all the released artifacts [\#165](https://github.com/apache/camel-kafka-connector/issues/165)
- Create and ad hoc connector for syslog [\#145](https://github.com/apache/camel-kafka-connector/issues/145)
- Take in to account endpoint path options order into connector code generation [\#144](https://github.com/apache/camel-kafka-connector/issues/144)

**Fixed bugs:**

- Ordering of endpoint path options is not taken in account [\#143](https://github.com/apache/camel-kafka-connector/issues/143)

**Closed issues:**

- Add connector dependencies in distribution package [\#203](https://github.com/apache/camel-kafka-connector/issues/203)
- Switch to Camel 3.2.0 [\#199](https://github.com/apache/camel-kafka-connector/issues/199)
- Cannot apply transforms to Telegram Source Connector [\#188](https://github.com/apache/camel-kafka-connector/issues/188)
- Connectors doc: Show up only the priority in the table column [\#182](https://github.com/apache/camel-kafka-connector/issues/182)
- Add an index for connectors in docs [\#169](https://github.com/apache/camel-kafka-connector/issues/169)
- Autogenerate documentation for sink and source connectors [\#167](https://github.com/apache/camel-kafka-connector/issues/167)
- Provided dependencies management [\#158](https://github.com/apache/camel-kafka-connector/issues/158)
- Checkstyle missing unused imports? [\#156](https://github.com/apache/camel-kafka-connector/issues/156)
- Generate a table with supported connectors [\#142](https://github.com/apache/camel-kafka-connector/issues/142)
- Test coverage: springboot autoconfigurations vs kafka-connect configuration format [\#132](https://github.com/apache/camel-kafka-connector/issues/132)
- Release 0.1.0 [\#130](https://github.com/apache/camel-kafka-connector/issues/130)

**Merged pull requests:**

- Syslog connector [\#214](https://github.com/apache/camel-kafka-connector/pull/214) ([valdar](https://github.com/valdar))
- Bump Testcontainers to version 1.14.2 [\#213](https://github.com/apache/camel-kafka-connector/pull/213) ([oscerd](https://github.com/oscerd))
- Removes usage of fixed hostnames in integration tests [\#210](https://github.com/apache/camel-kafka-connector/pull/210) ([orpiske](https://github.com/orpiske))
- Grammar fixes in basic concepts adoc [\#209](https://github.com/apache/camel-kafka-connector/pull/209) ([oscerd](https://github.com/oscerd))
- chore: rename poorly named variable in test code [\#208](https://github.com/apache/camel-kafka-connector/pull/208) ([orpiske](https://github.com/orpiske))
- Re-enable Cassandra test using properties [\#207](https://github.com/apache/camel-kafka-connector/pull/207) ([orpiske](https://github.com/orpiske))
- Bump to Camel 3.2.0 [\#206](https://github.com/apache/camel-kafka-connector/pull/206) ([oscerd](https://github.com/oscerd))
- Improved CamelSourceTaskTest [\#205](https://github.com/apache/camel-kafka-connector/pull/205) ([fvaleri](https://github.com/fvaleri))
- Removed Thread.seep\(...\) in unit tests in order to avoid possible sou… [\#204](https://github.com/apache/camel-kafka-connector/pull/204) ([valdar](https://github.com/valdar))
- Flakey tests [\#200](https://github.com/apache/camel-kafka-connector/pull/200) ([valdar](https://github.com/valdar))
- Generate a table with supported connectors [\#198](https://github.com/apache/camel-kafka-connector/pull/198) ([oscerd](https://github.com/oscerd))
- Make the topics property consistent between source and sink connectors [\#196](https://github.com/apache/camel-kafka-connector/pull/196) ([oscerd](https://github.com/oscerd))
- Produce an assembly artifact containing all the released artifacts [\#195](https://github.com/apache/camel-kafka-connector/pull/195) ([oscerd](https://github.com/oscerd))
- Switched to use RuntimeCatalog.asEndpointUri method to construct the … [\#192](https://github.com/apache/camel-kafka-connector/pull/192) ([valdar](https://github.com/valdar))
- Connectors doc: Show up only the priority in the table column [\#190](https://github.com/apache/camel-kafka-connector/pull/190) ([oscerd](https://github.com/oscerd))
- Added test on different component properties formats fix \#132 [\#187](https://github.com/apache/camel-kafka-connector/pull/187) ([valdar](https://github.com/valdar))
- Code cleanup [\#184](https://github.com/apache/camel-kafka-connector/pull/184) ([fvaleri](https://github.com/fvaleri))
- Lets try to use a shortname of 50 for connectors options [\#181](https://github.com/apache/camel-kafka-connector/pull/181) ([oscerd](https://github.com/oscerd))
- Camel-kafka-generator-maven-plugin: Use the Strings class from toolin… [\#180](https://github.com/apache/camel-kafka-connector/pull/180) ([oscerd](https://github.com/oscerd))
- Introduce the shortName method for option name [\#179](https://github.com/apache/camel-kafka-connector/pull/179) ([oscerd](https://github.com/oscerd))
- Added a little example of AWS-S3 source connector [\#177](https://github.com/apache/camel-kafka-connector/pull/177) ([oscerd](https://github.com/oscerd))
- Docs generation now contains also the number of options available per connectors [\#176](https://github.com/apache/camel-kafka-connector/pull/176) ([oscerd](https://github.com/oscerd))
- Adds a manual test for the Camel Slack sink connector [\#174](https://github.com/apache/camel-kafka-connector/pull/174) ([orpiske](https://github.com/orpiske))
- Special case for coap+tcp and coaps+tcp [\#173](https://github.com/apache/camel-kafka-connector/pull/173) ([oscerd](https://github.com/oscerd))
- Regen docs [\#172](https://github.com/apache/camel-kafka-connector/pull/172) ([oscerd](https://github.com/oscerd))
- Regen docs pages by adding title, so Antora will be happy [\#171](https://github.com/apache/camel-kafka-connector/pull/171) ([oscerd](https://github.com/oscerd))
- Add an index for docs [\#170](https://github.com/apache/camel-kafka-connector/pull/170) ([oscerd](https://github.com/oscerd))
- Docs sink source [\#168](https://github.com/apache/camel-kafka-connector/pull/168) ([oscerd](https://github.com/oscerd))
- Pom fixes [\#161](https://github.com/apache/camel-kafka-connector/pull/161) ([valdar](https://github.com/valdar))
- Added a building section in the docs [\#160](https://github.com/apache/camel-kafka-connector/pull/160) ([oscerd](https://github.com/oscerd))
- Fixes a couple of style violations and warnings on test code [\#157](https://github.com/apache/camel-kafka-connector/pull/157) ([orpiske](https://github.com/orpiske))
- Additional tests for different configuration styles [\#155](https://github.com/apache/camel-kafka-connector/pull/155) ([orpiske](https://github.com/orpiske))
- Release0.1.0 [\#154](https://github.com/apache/camel-kafka-connector/pull/154) ([valdar](https://github.com/valdar))
- Fixed github action issue with never released builts. [\#153](https://github.com/apache/camel-kafka-connector/pull/153) ([valdar](https://github.com/valdar))
- Upgrade testcontainers to version 1.14.1 [\#152](https://github.com/apache/camel-kafka-connector/pull/152) ([oscerd](https://github.com/oscerd))

## [camel-kafka-connector-0.1.0](https://github.com/apache/camel-kafka-connector/tree/camel-kafka-connector-0.1.0) (2020-04-25)

[Full Changelog](https://github.com/apache/camel-kafka-connector/compare/ad2bd4dccdb8ac3b339cd94cd764c8ff169ca993...camel-kafka-connector-0.1.0)

**Implemented enhancements:**

- Migrating to Junit 5 [\#74](https://github.com/apache/camel-kafka-connector/issues/74)
- Replace `confluentinc/cp-kafka` image with an upstream version [\#43](https://github.com/apache/camel-kafka-connector/issues/43)
- Test code cleanups: embedded connect runtime improvements [\#24](https://github.com/apache/camel-kafka-connector/issues/24)
- Add a CI job for PR [\#19](https://github.com/apache/camel-kafka-connector/issues/19)
- Support Map and List as Headers [\#18](https://github.com/apache/camel-kafka-connector/issues/18)
- Find a way to manage dependencies [\#15](https://github.com/apache/camel-kafka-connector/issues/15)
- Unclean shutdown causing lots of warning messages in the logs [\#13](https://github.com/apache/camel-kafka-connector/issues/13)

**Fixed bugs:**

- Unable to initialize REST resources in tests [\#120](https://github.com/apache/camel-kafka-connector/issues/120)
- ERROR - Plugin class loader for connector: was not found. [\#118](https://github.com/apache/camel-kafka-connector/issues/118)
- Flaky test: CamelSinkCassandraITCase [\#67](https://github.com/apache/camel-kafka-connector/issues/67)
- Integrations tests fails if confluentinc/cp-kafka:5.2.1 has not been pulled [\#25](https://github.com/apache/camel-kafka-connector/issues/25)

**Closed issues:**

- Create a documentation index and reflect it on the website [\#136](https://github.com/apache/camel-kafka-connector/issues/136)
- Documentation: Add instructions on how to use the packaged connectors in Kafka Connect [\#134](https://github.com/apache/camel-kafka-connector/issues/134)
- Generate documentation to be integrated with Antora and camel website [\#128](https://github.com/apache/camel-kafka-connector/issues/128)
- Define how to package the connectors  [\#127](https://github.com/apache/camel-kafka-connector/issues/127)
- Upgrade to Kafka 2.4.1 [\#105](https://github.com/apache/camel-kafka-connector/issues/105)
- Not able to add resource file [\#104](https://github.com/apache/camel-kafka-connector/issues/104)
- Not able to run aws s3 source connector  [\#95](https://github.com/apache/camel-kafka-connector/issues/95)
- Bump Kafka to version 2.4.0 [\#69](https://github.com/apache/camel-kafka-connector/issues/69)
- Unstable test: CamelSourceTaskTest.testSourcePollingTimeout [\#55](https://github.com/apache/camel-kafka-connector/issues/55)
- Add a sink and sources examples with camel-cassandraql [\#35](https://github.com/apache/camel-kafka-connector/issues/35)
- Better support for value Schema in the SourceTask [\#32](https://github.com/apache/camel-kafka-connector/issues/32)
- run integration test insided github actions? [\#31](https://github.com/apache/camel-kafka-connector/issues/31)
- INFRA - Turn off mail noise to Camel @dev mailing list [\#30](https://github.com/apache/camel-kafka-connector/issues/30)
- Allow the user to set the key of the SourceRecord explicitly [\#20](https://github.com/apache/camel-kafka-connector/issues/20)
- support camel type converters [\#16](https://github.com/apache/camel-kafka-connector/issues/16)
- The camel-kafka-connector artifacts pulls number of dependencies [\#9](https://github.com/apache/camel-kafka-connector/issues/9)
- Add Release profile [\#7](https://github.com/apache/camel-kafka-connector/issues/7)

**Merged pull requests:**

- Moved from camel-core to camel-core-engine as a dependecnies. [\#140](https://github.com/apache/camel-kafka-connector/pull/140) ([valdar](https://github.com/valdar))
- Added gpg key for valdar. [\#139](https://github.com/apache/camel-kafka-connector/pull/139) ([valdar](https://github.com/valdar))
- Test code fixes for the auto-generated connectors [\#138](https://github.com/apache/camel-kafka-connector/pull/138) ([orpiske](https://github.com/orpiske))
- Misc [\#133](https://github.com/apache/camel-kafka-connector/pull/133) ([valdar](https://github.com/valdar))
- Packaging the connectors as zip and tar.gz [\#131](https://github.com/apache/camel-kafka-connector/pull/131) ([oscerd](https://github.com/oscerd))
- Auto gen [\#129](https://github.com/apache/camel-kafka-connector/pull/129) ([valdar](https://github.com/valdar))
- Upgrade Testcontainers to version 1.14.0 [\#126](https://github.com/apache/camel-kafka-connector/pull/126) ([oscerd](https://github.com/oscerd))
- Upgrade Junit Jupiter to version 5.6.2 [\#125](https://github.com/apache/camel-kafka-connector/pull/125) ([oscerd](https://github.com/oscerd))
- Replaces our own connect runtime implementation with the embedded one from Kafka [\#124](https://github.com/apache/camel-kafka-connector/pull/124) ([orpiske](https://github.com/orpiske))
- Removed unused class HTTPEchoService [\#123](https://github.com/apache/camel-kafka-connector/pull/123) ([orpiske](https://github.com/orpiske))
- Fixes a misplaced log error message flooding the logs w/ invalid errors [\#122](https://github.com/apache/camel-kafka-connector/pull/122) ([orpiske](https://github.com/orpiske))
- Sidebar menu Tidy up name -issue 14567 [\#121](https://github.com/apache/camel-kafka-connector/pull/121) ([rimshach](https://github.com/rimshach))
- Bump Qpid JMS to version 0.50.0 [\#119](https://github.com/apache/camel-kafka-connector/pull/119) ([oscerd](https://github.com/oscerd))
- Improve documentation for the about section [\#116](https://github.com/apache/camel-kafka-connector/pull/116) ([AemieJ](https://github.com/AemieJ))
- Binded itests to test phase to better accommodate github actions disk… [\#115](https://github.com/apache/camel-kafka-connector/pull/115) ([valdar](https://github.com/valdar))
- Auto gen [\#114](https://github.com/apache/camel-kafka-connector/pull/114) ([valdar](https://github.com/valdar))
- Added a Jenkinsfile for JDK11 [\#113](https://github.com/apache/camel-kafka-connector/pull/113) ([oscerd](https://github.com/oscerd))
- Added a Jenkinsfile for JDK8 and being able to deploy automatically [\#112](https://github.com/apache/camel-kafka-connector/pull/112) ([oscerd](https://github.com/oscerd))
- Pointing to ASF Snapshot and use the apache Parent [\#111](https://github.com/apache/camel-kafka-connector/pull/111) ([oscerd](https://github.com/oscerd))
- Bump Junit Jupiter to version 5.6.1 [\#110](https://github.com/apache/camel-kafka-connector/pull/110) ([oscerd](https://github.com/oscerd))
- Bump ActiveMQ to version 5.15.12 [\#109](https://github.com/apache/camel-kafka-connector/pull/109) ([oscerd](https://github.com/oscerd))
- Avoid building all the code for sourcecheck verification [\#108](https://github.com/apache/camel-kafka-connector/pull/108) ([orpiske](https://github.com/orpiske))
- Added support for remote AWS testing [\#107](https://github.com/apache/camel-kafka-connector/pull/107) ([orpiske](https://github.com/orpiske))
- Upgrade Kafka to version 2.4.1 - fixes \#105 [\#106](https://github.com/apache/camel-kafka-connector/pull/106) ([oscerd](https://github.com/oscerd))
- Upgrade Jackson to version 2.10.3 [\#103](https://github.com/apache/camel-kafka-connector/pull/103) ([oscerd](https://github.com/oscerd))
- Auto gen step 2: generated connectors structure and dependencies. [\#102](https://github.com/apache/camel-kafka-connector/pull/102) ([valdar](https://github.com/valdar))
- Ensure that local containers used during tests are properly shutdown after the test is completed [\#101](https://github.com/apache/camel-kafka-connector/pull/101) ([orpiske](https://github.com/orpiske))
- Upgrade test containers [\#100](https://github.com/apache/camel-kafka-connector/pull/100) ([orpiske](https://github.com/orpiske))
- Bump to Camel 3.1.0 [\#99](https://github.com/apache/camel-kafka-connector/pull/99) ([oscerd](https://github.com/oscerd))
- Little updates to docs [\#98](https://github.com/apache/camel-kafka-connector/pull/98) ([oscerd](https://github.com/oscerd))
- Fix missing licenses [\#94](https://github.com/apache/camel-kafka-connector/pull/94) ([orpiske](https://github.com/orpiske))
- Adds support for running tests against external ElasticSearch instances [\#93](https://github.com/apache/camel-kafka-connector/pull/93) ([orpiske](https://github.com/orpiske))
- Adds support for running tests against external Cassandra instances [\#92](https://github.com/apache/camel-kafka-connector/pull/92) ([orpiske](https://github.com/orpiske))
- Small adjustment to sourcechecks. [\#91](https://github.com/apache/camel-kafka-connector/pull/91) ([valdar](https://github.com/valdar))
- Fixed README.adoc links after Antora init. [\#90](https://github.com/apache/camel-kafka-connector/pull/90) ([valdar](https://github.com/valdar))
- fix\(docs\): replace anchor syntax for placeholder [\#89](https://github.com/apache/camel-kafka-connector/pull/89) ([zregvart](https://github.com/zregvart))
- chore\(docs\): cleanup wording and syntax [\#88](https://github.com/apache/camel-kafka-connector/pull/88) ([zregvart](https://github.com/zregvart))
- feat\(docs\): setup Antora [\#87](https://github.com/apache/camel-kafka-connector/pull/87) ([zregvart](https://github.com/zregvart))
- \[SECURITY\] Use HTTPS to resolve dependencies in Maven Build [\#86](https://github.com/apache/camel-kafka-connector/pull/86) ([JLLeitschuh](https://github.com/JLLeitschuh))
- First step for issue \#15 [\#85](https://github.com/apache/camel-kafka-connector/pull/85) ([valdar](https://github.com/valdar))
- Upgrade Qpid JMS client to version 0.48.0 [\#84](https://github.com/apache/camel-kafka-connector/pull/84) ([oscerd](https://github.com/oscerd))
- Added support for using an external JMS broker [\#83](https://github.com/apache/camel-kafka-connector/pull/83) ([orpiske](https://github.com/orpiske))
- Added support for loading test properties from a properties file [\#82](https://github.com/apache/camel-kafka-connector/pull/82) ([orpiske](https://github.com/orpiske))
- Bump TestContainers to version 1.12.5 [\#81](https://github.com/apache/camel-kafka-connector/pull/81) ([oscerd](https://github.com/oscerd))
- Bump to Camel 3.0.1 [\#80](https://github.com/apache/camel-kafka-connector/pull/80) ([oscerd](https://github.com/oscerd))
- Upgrade Junit to version 5.6.0 [\#79](https://github.com/apache/camel-kafka-connector/pull/79) ([oscerd](https://github.com/oscerd))
- Upgrade strimzi images to the latest version [\#78](https://github.com/apache/camel-kafka-connector/pull/78) ([orpiske](https://github.com/orpiske))
- Migrates all the test cases to Junit 5 [\#75](https://github.com/apache/camel-kafka-connector/pull/75) ([orpiske](https://github.com/orpiske))
- Added sourcecheck to github actions, added master push github action … [\#73](https://github.com/apache/camel-kafka-connector/pull/73) ([valdar](https://github.com/valdar))
- Updated integration test image to kafka 2.4 [\#72](https://github.com/apache/camel-kafka-connector/pull/72) ([valdar](https://github.com/valdar))
- Fix issue \#67: Flaky test: CamelSinkCassandraITCase [\#71](https://github.com/apache/camel-kafka-connector/pull/71) ([orpiske](https://github.com/orpiske))
- Bump Kafka to version 2.4.0 [\#70](https://github.com/apache/camel-kafka-connector/pull/70) ([oscerd](https://github.com/oscerd))
- Upgrade ActiveMQ to version 5.15.11 [\#68](https://github.com/apache/camel-kafka-connector/pull/68) ([oscerd](https://github.com/oscerd))
- Added support for testing the Kafka service using Strimzi [\#66](https://github.com/apache/camel-kafka-connector/pull/66) ([valdar](https://github.com/valdar))
- Auto gen [\#65](https://github.com/apache/camel-kafka-connector/pull/65) ([valdar](https://github.com/valdar))
- Add integration test for Cassandra CQL [\#64](https://github.com/apache/camel-kafka-connector/pull/64) ([orpiske](https://github.com/orpiske))
- Bump Jackson to version 2.10.2 [\#63](https://github.com/apache/camel-kafka-connector/pull/63) ([oscerd](https://github.com/oscerd))
- Use artifactId instead of project.name to build colon-less distro paths [\#62](https://github.com/apache/camel-kafka-connector/pull/62) ([ppalaga](https://github.com/ppalaga))
- Bump Junit to version 4.13 [\#61](https://github.com/apache/camel-kafka-connector/pull/61) ([oscerd](https://github.com/oscerd))
- Should use year instead of week year [\#60](https://github.com/apache/camel-kafka-connector/pull/60) ([orpiske](https://github.com/orpiske))
- Property placeholders [\#59](https://github.com/apache/camel-kafka-connector/pull/59) ([oscerd](https://github.com/oscerd))
- Relaxing condition to accomodate some timeout glitches, fix \#55 [\#58](https://github.com/apache/camel-kafka-connector/pull/58) ([valdar](https://github.com/valdar))
- Convert the embeddable Kafka Connect runner to a JUnit rule [\#57](https://github.com/apache/camel-kafka-connector/pull/57) ([orpiske](https://github.com/orpiske))
- Stop removing JMS-related containers after they are built [\#56](https://github.com/apache/camel-kafka-connector/pull/56) ([orpiske](https://github.com/orpiske))
- Upgrade test containers to the latest version [\#54](https://github.com/apache/camel-kafka-connector/pull/54) ([orpiske](https://github.com/orpiske))
- Fixes [\#52](https://github.com/apache/camel-kafka-connector/pull/52) ([valdar](https://github.com/valdar))
- Rearrange date and time [\#51](https://github.com/apache/camel-kafka-connector/pull/51) ([omarsmak](https://github.com/omarsmak))
- Fixed missing license [\#50](https://github.com/apache/camel-kafka-connector/pull/50) ([orpiske](https://github.com/orpiske))
- fix checkstyle violation [\#49](https://github.com/apache/camel-kafka-connector/pull/49) ([omarsmak](https://github.com/omarsmak))
- Add checkstyle profile  [\#48](https://github.com/apache/camel-kafka-connector/pull/48) ([omarsmak](https://github.com/omarsmak))
- CassandraQL sink connector example [\#47](https://github.com/apache/camel-kafka-connector/pull/47) ([oscerd](https://github.com/oscerd))
- Cassandraql source example [\#46](https://github.com/apache/camel-kafka-connector/pull/46) ([oscerd](https://github.com/oscerd))
- Added a gitter badge for our chat [\#45](https://github.com/apache/camel-kafka-connector/pull/45) ([oscerd](https://github.com/oscerd))
- Fix Kafka instance type should read from the property not from the system env [\#42](https://github.com/apache/camel-kafka-connector/pull/42) ([orpiske](https://github.com/orpiske))
- Adds an example configuration for ElasticSearch Index [\#41](https://github.com/apache/camel-kafka-connector/pull/41) ([orpiske](https://github.com/orpiske))
- Allow to configure a source record key from camel message header key [\#39](https://github.com/apache/camel-kafka-connector/pull/39) ([omarsmak](https://github.com/omarsmak))
- Replaces artemis with qpid-dispatch router [\#38](https://github.com/apache/camel-kafka-connector/pull/38) ([orpiske](https://github.com/orpiske))
- Infer the suitable schema in the SourceTask [\#37](https://github.com/apache/camel-kafka-connector/pull/37) ([omarsmak](https://github.com/omarsmak))
- Adds support for ElasticSearch index operation + tests [\#36](https://github.com/apache/camel-kafka-connector/pull/36) ([orpiske](https://github.com/orpiske))
- Support camel type converter [\#34](https://github.com/apache/camel-kafka-connector/pull/34) ([omarsmak](https://github.com/omarsmak))
- Send S3ObjectSerializer I/O error to the LOG instead of stdout [\#33](https://github.com/apache/camel-kafka-connector/pull/33) ([orpiske](https://github.com/orpiske))
- Support using an external Kafka for the tests [\#29](https://github.com/apache/camel-kafka-connector/pull/29) ([orpiske](https://github.com/orpiske))
- Camel-AWS S3 example: Use a Transformation instead of a converter [\#28](https://github.com/apache/camel-kafka-connector/pull/28) ([oscerd](https://github.com/oscerd))
- Map list as headers [\#26](https://github.com/apache/camel-kafka-connector/pull/26) ([oscerd](https://github.com/oscerd))
- Setting up POM as ASF standard [\#14](https://github.com/apache/camel-kafka-connector/pull/14) ([oscerd](https://github.com/oscerd))
- Reduce log default log verbosity [\#12](https://github.com/apache/camel-kafka-connector/pull/12) ([orpiske](https://github.com/orpiske))
- Cleanup the AWS SQS Sink test [\#11](https://github.com/apache/camel-kafka-connector/pull/11) ([orpiske](https://github.com/orpiske))
- Mark camel components as provided dependencies [\#10](https://github.com/apache/camel-kafka-connector/pull/10) ([jerrinot](https://github.com/jerrinot))
- Added release profile for the beginning [\#8](https://github.com/apache/camel-kafka-connector/pull/8) ([oscerd](https://github.com/oscerd))
- Fix Sink File test [\#6](https://github.com/apache/camel-kafka-connector/pull/6) ([orpiske](https://github.com/orpiske))
- chore: update maven to v3.6.3 [\#5](https://github.com/apache/camel-kafka-connector/pull/5) ([lburgazzoli](https://github.com/lburgazzoli))
- chore\(build\): set up github actions [\#4](https://github.com/apache/camel-kafka-connector/pull/4) ([lburgazzoli](https://github.com/lburgazzoli))
- Adding Keys, Notice and License files [\#3](https://github.com/apache/camel-kafka-connector/pull/3) ([oscerd](https://github.com/oscerd))



\* *This Changelog was automatically generated by [github_changelog_generator](https://github.com/github-changelog-generator/github-changelog-generator)*
