/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.component.dsl;

import javax.annotation.Generated;
import org.apache.camel.Component;
import org.apache.camel.builder.component.AbstractComponentBuilder;
import org.apache.camel.builder.component.ComponentBuilder;
import org.apache.camel.component.resteasy.ResteasyComponent;

/**
 * Expose REST endpoints and access external REST servers.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.maven.packaging.ComponentDslMojo")
public interface ResteasyComponentBuilderFactory {

    /**
     * Resteasy (camel-resteasy)
     * Expose REST endpoints and access external REST servers.
     * 
     * Category: rest
     * Since: 3.4
     * Maven coordinates: org.apache.camel:camel-resteasy
     * 
     * @return the dsl builder
     */
    static ResteasyComponentBuilder resteasy() {
        return new ResteasyComponentBuilderImpl();
    }

    /**
     * Builder for the Resteasy component.
     */
    interface ResteasyComponentBuilder
            extends
                ComponentBuilder<ResteasyComponent> {
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default ResteasyComponentBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Proxy classes for consumer endpoints. Multiple classes can be
         * separated by comma.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: consumer
         * 
         * @param proxyConsumersClasses the value to set
         * @return the dsl builder
         */
        default ResteasyComponentBuilder proxyConsumersClasses(
                java.lang.String proxyConsumersClasses) {
            doSetProperty("proxyConsumersClasses", proxyConsumersClasses);
            return this;
        }
        /**
         * If this option is true then IN exchange headers will be copied to OUT
         * exchange headers according to copy strategy. Setting this to false,
         * allows to only include the headers from the HTTP response (not
         * propagating IN headers).
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param copyHeaders the value to set
         * @return the dsl builder
         */
        default ResteasyComponentBuilder copyHeaders(boolean copyHeaders) {
            doSetProperty("copyHeaders", copyHeaders);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default ResteasyComponentBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * This threshold in bytes controls whether the response payload should
         * be stored in memory as a byte array or be streaming based. Set this
         * to -1 to always use streaming mode.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 8192
         * Group: producer
         * 
         * @param responsePayloadStreamingThreshold the value to set
         * @return the dsl builder
         */
        default ResteasyComponentBuilder responsePayloadStreamingThreshold(
                int responsePayloadStreamingThreshold) {
            doSetProperty("responsePayloadStreamingThreshold", responsePayloadStreamingThreshold);
            return this;
        }
        /**
         * Whether to skip mapping all the Camel headers as HTTP request
         * headers. If there are no data from Camel headers needed to be
         * included in the HTTP request then this can avoid parsing overhead
         * with many object allocations for the JVM garbage collector.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param skipRequestHeaders the value to set
         * @return the dsl builder
         */
        default ResteasyComponentBuilder skipRequestHeaders(
                boolean skipRequestHeaders) {
            doSetProperty("skipRequestHeaders", skipRequestHeaders);
            return this;
        }
        /**
         * Whether to skip mapping all the HTTP response headers to Camel
         * headers. If there are no data needed from HTTP headers then this can
         * avoid parsing overhead with many object allocations for the JVM
         * garbage collector.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param skipResponseHeaders the value to set
         * @return the dsl builder
         */
        default ResteasyComponentBuilder skipResponseHeaders(
                boolean skipResponseHeaders) {
            doSetProperty("skipResponseHeaders", skipResponseHeaders);
            return this;
        }
        /**
         * Whether to allow java serialization when a request uses
         * context-type=application/x-java-serialized-object. This is by default
         * turned off. If you enable this then be aware that Java will
         * deserialize the incoming data from the request to Java and that can
         * be a potential security risk.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param allowJavaSerializedObject the value to set
         * @return the dsl builder
         */
        default ResteasyComponentBuilder allowJavaSerializedObject(
                boolean allowJavaSerializedObject) {
            doSetProperty("allowJavaSerializedObject", allowJavaSerializedObject);
            return this;
        }
        /**
         * Disables authentication scheme caching.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param authCachingDisabled the value to set
         * @return the dsl builder
         */
        default ResteasyComponentBuilder authCachingDisabled(
                boolean authCachingDisabled) {
            doSetProperty("authCachingDisabled", authCachingDisabled);
            return this;
        }
        /**
         * Disables automatic request recovery and re-execution.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param automaticRetriesDisabled the value to set
         * @return the dsl builder
         */
        default ResteasyComponentBuilder automaticRetriesDisabled(
                boolean automaticRetriesDisabled) {
            doSetProperty("automaticRetriesDisabled", automaticRetriesDisabled);
            return this;
        }
        /**
         * Whether autowiring is enabled. This is used for automatic autowiring
         * options (the option must be marked as autowired) by looking up in the
         * registry to find if there is a single instance of matching type,
         * which then gets configured on the component. This can be used for
         * automatic configuring JDBC data sources, JMS connection factories,
         * AWS Clients, etc.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: advanced
         * 
         * @param autowiredEnabled the value to set
         * @return the dsl builder
         */
        default ResteasyComponentBuilder autowiredEnabled(
                boolean autowiredEnabled) {
            doSetProperty("autowiredEnabled", autowiredEnabled);
            return this;
        }
        /**
         * Disables connection state tracking.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param connectionStateDisabled the value to set
         * @return the dsl builder
         */
        default ResteasyComponentBuilder connectionStateDisabled(
                boolean connectionStateDisabled) {
            doSetProperty("connectionStateDisabled", connectionStateDisabled);
            return this;
        }
        /**
         * Disables automatic content decompression.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param contentCompressionDisabled the value to set
         * @return the dsl builder
         */
        default ResteasyComponentBuilder contentCompressionDisabled(
                boolean contentCompressionDisabled) {
            doSetProperty("contentCompressionDisabled", contentCompressionDisabled);
            return this;
        }
        /**
         * Disables state (cookie) management.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param cookieManagementDisabled the value to set
         * @return the dsl builder
         */
        default ResteasyComponentBuilder cookieManagementDisabled(
                boolean cookieManagementDisabled) {
            doSetProperty("cookieManagementDisabled", cookieManagementDisabled);
            return this;
        }
        /**
         * Disables the default user agent set by this builder if none has been
         * provided by the user.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param defaultUserAgentDisabled the value to set
         * @return the dsl builder
         */
        default ResteasyComponentBuilder defaultUserAgentDisabled(
                boolean defaultUserAgentDisabled) {
            doSetProperty("defaultUserAgentDisabled", defaultUserAgentDisabled);
            return this;
        }
        /**
         * Disables automatic redirect handling.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: advanced
         * 
         * @param redirectHandlingDisabled the value to set
         * @return the dsl builder
         */
        default ResteasyComponentBuilder redirectHandlingDisabled(
                boolean redirectHandlingDisabled) {
            doSetProperty("redirectHandlingDisabled", redirectHandlingDisabled);
            return this;
        }
        /**
         * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
         * header to and from Camel message.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.HeaderFilterStrategy&lt;/code&gt;
         * type.
         * 
         * Group: filter
         * 
         * @param headerFilterStrategy the value to set
         * @return the dsl builder
         */
        default ResteasyComponentBuilder headerFilterStrategy(
                org.apache.camel.spi.HeaderFilterStrategy headerFilterStrategy) {
            doSetProperty("headerFilterStrategy", headerFilterStrategy);
            return this;
        }
    }

    class ResteasyComponentBuilderImpl
            extends
                AbstractComponentBuilder<ResteasyComponent>
            implements
                ResteasyComponentBuilder {
        @Override
        protected ResteasyComponent buildConcreteComponent() {
            return new ResteasyComponent();
        }
        @Override
        protected boolean setPropertyOnComponent(
                Component component,
                String name,
                Object value) {
            switch (name) {
            case "bridgeErrorHandler": ((ResteasyComponent) component).setBridgeErrorHandler((boolean) value); return true;
            case "proxyConsumersClasses": ((ResteasyComponent) component).setProxyConsumersClasses((java.lang.String) value); return true;
            case "copyHeaders": ((ResteasyComponent) component).setCopyHeaders((boolean) value); return true;
            case "lazyStartProducer": ((ResteasyComponent) component).setLazyStartProducer((boolean) value); return true;
            case "responsePayloadStreamingThreshold": ((ResteasyComponent) component).setResponsePayloadStreamingThreshold((int) value); return true;
            case "skipRequestHeaders": ((ResteasyComponent) component).setSkipRequestHeaders((boolean) value); return true;
            case "skipResponseHeaders": ((ResteasyComponent) component).setSkipResponseHeaders((boolean) value); return true;
            case "allowJavaSerializedObject": ((ResteasyComponent) component).setAllowJavaSerializedObject((boolean) value); return true;
            case "authCachingDisabled": ((ResteasyComponent) component).setAuthCachingDisabled((boolean) value); return true;
            case "automaticRetriesDisabled": ((ResteasyComponent) component).setAutomaticRetriesDisabled((boolean) value); return true;
            case "autowiredEnabled": ((ResteasyComponent) component).setAutowiredEnabled((boolean) value); return true;
            case "connectionStateDisabled": ((ResteasyComponent) component).setConnectionStateDisabled((boolean) value); return true;
            case "contentCompressionDisabled": ((ResteasyComponent) component).setContentCompressionDisabled((boolean) value); return true;
            case "cookieManagementDisabled": ((ResteasyComponent) component).setCookieManagementDisabled((boolean) value); return true;
            case "defaultUserAgentDisabled": ((ResteasyComponent) component).setDefaultUserAgentDisabled((boolean) value); return true;
            case "redirectHandlingDisabled": ((ResteasyComponent) component).setRedirectHandlingDisabled((boolean) value); return true;
            case "headerFilterStrategy": ((ResteasyComponent) component).setHeaderFilterStrategy((org.apache.camel.spi.HeaderFilterStrategy) value); return true;
            default: return false;
            }
        }
    }
}