/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.debezium.springboot;

import java.util.Map;
import javax.annotation.Generated;
import org.apache.camel.component.debezium.configuration.OracleConnectorEmbeddedDebeziumConfiguration;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Capture changes from a Oracle database.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.springboot.maven.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.debezium-oracle")
public class DebeziumOracleComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the debezium-oracle component.
     * This is enabled by default.
     */
    private Boolean enabled;
    /**
     * Additional properties for debezium components in case they can't be set
     * directly on the camel configurations (e.g: setting Kafka Connect
     * properties needed by Debezium engine, for example setting
     * KafkaOffsetBackingStore), the properties have to be prefixed with
     * additionalProperties.. E.g:
     * additionalProperties.transactional.id=12345&additionalProperties.schema.registry.url=http://localhost:8811/avro
     */
    private Map<String, Object> additionalProperties;
    /**
     * Allows for bridging the consumer to the Camel routing Error Handler,
     * which mean any exceptions occurred while the consumer is trying to pickup
     * incoming messages, or the likes, will now be processed as a message and
     * handled by the routing Error Handler. By default the consumer will use
     * the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that
     * will be logged at WARN or ERROR level and ignored.
     */
    private Boolean bridgeErrorHandler = false;
    /**
     * Allow pre-configured Configurations to be set. The option is a
     * org.apache.camel.component.debezium.configuration.OracleConnectorEmbeddedDebeziumConfiguration type.
     */
    private OracleConnectorEmbeddedDebeziumConfiguration configuration;
    /**
     * The Converter class that should be used to serialize and deserialize key
     * data for offsets. The default is JSON converter.
     */
    private String internalKeyConverter = "org.apache.kafka.connect.json.JsonConverter";
    /**
     * The Converter class that should be used to serialize and deserialize
     * value data for offsets. The default is JSON converter.
     */
    private String internalValueConverter = "org.apache.kafka.connect.json.JsonConverter";
    /**
     * The name of the Java class of the commit policy. It defines when offsets
     * commit has to be triggered based on the number of events processed and
     * the time elapsed since the last commit. This class must implement the
     * interface 'OffsetCommitPolicy'. The default is a periodic commit policy
     * based upon time intervals.
     */
    private String offsetCommitPolicy;
    /**
     * Maximum number of milliseconds to wait for records to flush and partition
     * offset data to be committed to offset storage before cancelling the
     * process and restoring the offset data to be committed in a future
     * attempt. The default is 5 seconds. The option is a long type.
     */
    private Long offsetCommitTimeoutMs = 5000L;
    /**
     * Interval at which to try committing offsets. The default is 1 minute. The
     * option is a long type.
     */
    private Long offsetFlushIntervalMs = 60000L;
    /**
     * The name of the Java class that is responsible for persistence of
     * connector offsets.
     */
    private String offsetStorage = "org.apache.kafka.connect.storage.FileOffsetBackingStore";
    /**
     * Path to file where offsets are to be stored. Required when offset.storage
     * is set to the FileOffsetBackingStore.
     */
    private String offsetStorageFileName;
    /**
     * The number of partitions used when creating the offset storage topic.
     * Required when offset.storage is set to the 'KafkaOffsetBackingStore'.
     */
    private Integer offsetStoragePartitions;
    /**
     * Replication factor used when creating the offset storage topic. Required
     * when offset.storage is set to the KafkaOffsetBackingStore
     */
    private Integer offsetStorageReplicationFactor;
    /**
     * The name of the Kafka topic where offsets are to be stored. Required when
     * offset.storage is set to the KafkaOffsetBackingStore.
     */
    private String offsetStorageTopic;
    /**
     * Whether autowiring is enabled. This is used for automatic autowiring
     * options (the option must be marked as autowired) by looking up in the
     * registry to find if there is a single instance of matching type, which
     * then gets configured on the component. This can be used for automatic
     * configuring JDBC data sources, JMS connection factories, AWS Clients,
     * etc.
     */
    private Boolean autowiredEnabled = true;
    /**
     * Specify how binary (blob, binary, etc.) columns should be represented in
     * change events, including:'bytes' represents binary data as byte array
     * (default)'base64' represents binary data as base64-encoded string'hex'
     * represents binary data as hex-encoded (base16) string
     */
    private String binaryHandlingMode = "bytes";
    /**
     * Regular expressions matching columns to exclude from change events
     * (deprecated, use column.exclude.list instead)
     */
    private String columnBlacklist;
    /**
     * Regular expressions matching columns to exclude from change events
     */
    private String columnExcludeList;
    /**
     * Regular expressions matching columns to include in change events
     */
    private String columnIncludeList;
    /**
     * A comma-separated list of regular expressions matching fully-qualified
     * names of columns that adds the columns original type and original length
     * as parameters to the corresponding field schemas in the emitted change
     * records.
     */
    private String columnPropagateSourceType;
    /**
     * Regular expressions matching columns to include in change events
     * (deprecated, use column.include.list instead)
     */
    private String columnWhitelist;
    /**
     * Optional list of custom converters that would be used instead of default
     * ones. The converters are defined using '.type' config option and
     * configured using options '.'
     */
    private String converters;
    /**
     * The adapter to use when capturing changes from the database. Options
     * include: 'logminer': (the default) to capture changes using native Oracle
     * LogMiner; 'xstream' to capture changes using Oracle XStreams
     */
    private String databaseConnectionAdapter = "LogMiner";
    /**
     * The name of the database from which the connector should capture changes
     */
    private String databaseDbname;
    /**
     * The name of the DatabaseHistory class that should be used to store and
     * recover database schema changes. The configuration properties for the
     * history are prefixed with the 'database.history.' string.
     */
    private String databaseHistory = "io.debezium.relational.history.KafkaDatabaseHistory";
    /**
     * The path to the file that will be used to record the database history
     */
    private String databaseHistoryFileFilename;
    /**
     * A list of host/port pairs that the connector will use for establishing
     * the initial connection to the Kafka cluster for retrieving database
     * schema history previously stored by the connector. This should point to
     * the same Kafka cluster used by the Kafka Connect process.
     */
    private String databaseHistoryKafkaBootstrapServers;
    /**
     * The number of milliseconds to wait while fetching cluster information
     * using Kafka admin client. The option is a long type.
     */
    private Long databaseHistoryKafkaQueryTimeoutMs = 3000L;
    /**
     * The number of attempts in a row that no data are returned from Kafka
     * before recover completes. The maximum amount of time to wait after
     * receiving no data is (recovery.attempts) x (recovery.poll.interval.ms).
     */
    private Integer databaseHistoryKafkaRecoveryAttempts = 100;
    /**
     * The number of milliseconds to wait while polling for persisted data
     * during recovery. The option is a int type.
     */
    private Integer databaseHistoryKafkaRecoveryPollIntervalMs = 100;
    /**
     * The name of the topic for the database schema history
     */
    private String databaseHistoryKafkaTopic;
    /**
     * Controls the action Debezium will take when it meets a DDL statement in
     * binlog, that it cannot parse.By default the connector will stop operating
     * but by changing the setting it can ignore the statements which it cannot
     * parse. If skipping is enabled then Debezium can miss metadata changes.
     */
    private Boolean databaseHistorySkipUnparseableDdl = false;
    /**
     * Controls what DDL will Debezium store in database history. By default
     * (false) Debezium will store all incoming DDL statements. If set to true,
     * then only DDL that manipulates a captured table will be stored.
     */
    private Boolean databaseHistoryStoreOnlyCapturedTablesDdl = false;
    /**
     * Controls what DDL will Debezium store in database history. By default
     * (false) Debezium will store all incoming DDL statements. If set to true,
     * then only DDL that manipulates a monitored table will be stored
     * (deprecated, use database.history.store.only.captured.tables.ddl instead)
     */
    private Boolean databaseHistoryStoreOnlyMonitoredTablesDdl = false;
    /**
     * Resolvable hostname or IP address of the database server.
     */
    private String databaseHostname;
    /**
     * Name of the XStream Out server to connect to.
     */
    private String databaseOutServerName;
    /**
     * Password of the database user to be used when connecting to the database.
     */
    private String databasePassword;
    /**
     * Name of the pluggable database when working with a multi-tenant set-up.
     * The CDB name must be given via database.dbname in this case.
     */
    private String databasePdbName;
    /**
     * Port of the database server.
     */
    private Integer databasePort = 1528;
    /**
     * Unique name that identifies the database server and all recorded offsets,
     * and that is used as a prefix for all schemas and topics. Each distinct
     * installation should have a separate namespace and be monitored by at most
     * one Debezium connector.
     */
    private String databaseServerName;
    /**
     * Complete JDBC URL as an alternative to specifying hostname, port and
     * database provided as a way to support alternative connection scenarios.
     */
    private String databaseUrl;
    /**
     * Name of the database user to be used when connecting to the database.
     */
    private String databaseUser;
    /**
     * A comma-separated list of regular expressions matching the
     * database-specific data type names that adds the data type's original type
     * and original length as parameters to the corresponding field schemas in
     * the emitted change records.
     */
    private String datatypePropagateSourceType;
    /**
     * Specify how DECIMAL and NUMERIC columns should be represented in change
     * events, including:'precise' (the default) uses java.math.BigDecimal to
     * represent values, which are encoded in the change events using a binary
     * representation and Kafka Connect's
     * 'org.apache.kafka.connect.data.Decimal' type; 'string' uses string to
     * represent values; 'double' represents values using Java's 'double', which
     * may not offer the precision but will be far easier to use in consumers.
     */
    private String decimalHandlingMode = "precise";
    /**
     * Specify how failures during processing of events (i.e. when encountering
     * a corrupted event) should be handled, including:'fail' (the default) an
     * exception indicating the problematic event and its position is raised,
     * causing the connector to be stopped; 'warn' the problematic event and its
     * position will be logged and the event will be skipped;'ignore' the
     * problematic event will be skipped.
     */
    private String eventProcessingFailureHandlingMode = "fail";
    /**
     * The query executed with every heartbeat.
     */
    private String heartbeatActionQuery;
    /**
     * Length of an interval in milli-seconds in in which the connector
     * periodically sends heartbeat messages to a heartbeat topic. Use 0 to
     * disable heartbeat messages. Disabled by default. The option is a int
     * type.
     */
    private Integer heartbeatIntervalMs = 0;
    /**
     * The prefix that is used to name heartbeat topics.Defaults to
     * __debezium-heartbeat.
     */
    private String heartbeatTopicsPrefix = "__debezium-heartbeat";
    /**
     * Whether the connector should publish changes in the database schema to a
     * Kafka topic with the same name as the database server ID. Each schema
     * change will be recorded using a key that contains the database name and
     * whose value include logical description of the new schema and optionally
     * the DDL statement(s).The default is 'true'. This is independent of how
     * the connector internally records database history.
     */
    private Boolean includeSchemaChanges = true;
    /**
     * Whether the connector parse table and column's comment to metadata
     * object.Note: Enable this option will bring the implications on memory
     * usage. The number and size of ColumnImpl objects is what largely impacts
     * how much memory is consumed by the Debezium connectors, and adding a
     * String to each of them can potentially be quite heavy. The default is
     * 'false'.
     */
    private Boolean includeSchemaComments = false;
    /**
     * Specify how INTERVAL columns should be represented in change events,
     * including:'string' represents values as an exact ISO formatted
     * string'numeric' (default) represents values using the inexact conversion
     * into microseconds
     */
    private String intervalHandlingMode = "numeric";
    /**
     * When set to false, the default, LOB fields will not be captured nor
     * emitted. When set to true, the connector will capture LOB fields and emit
     * changes for those fields like any other column type.
     */
    private Boolean lobEnabled = false;
    /**
     * Sets the specific archive log destination as the source for reading
     * archive logs.When not set, the connector will automatically select the
     * first LOCAL and VALID destination.
     */
    private String logMiningArchiveDestinationName;
    /**
     * The number of hours in the past from SYSDATE to mine archive logs. Using
     * 0 mines all available archive logs
     */
    private Long logMiningArchiveLogHours = 0L;
    /**
     * When set to false, the default, the connector will mine both archive log
     * and redo logs to emit change events. When set to true, the connector will
     * only mine archive logs. There are circumstances where its advantageous to
     * only mine archive logs and accept latency in event emission due to
     * frequent revolving redo logs.
     */
    private Boolean logMiningArchiveLogOnlyMode = false;
    /**
     * The interval in milliseconds to wait between polls checking to see if the
     * SCN is in the archive logs. The option is a long type.
     */
    private Long logMiningArchiveLogOnlyScnPollIntervalMs = 10000L;
    /**
     * The starting SCN interval size that the connector will use for reading
     * data from redo/archive logs.
     */
    private Long logMiningBatchSizeDefault = 20000L;
    /**
     * The maximum SCN interval size that this connector will use when reading
     * from redo/archive logs.
     */
    private Long logMiningBatchSizeMax = 100000L;
    /**
     * The minimum SCN interval size that this connector will try to read from
     * redo/archive logs. Active batch size will be also increased/decreased by
     * this amount for tuning connector throughput when needed.
     */
    private Long logMiningBatchSizeMin = 1000L;
    /**
     * When set to true the underlying buffer cache is not retained when the
     * connector is stopped. When set to false (the default), the buffer cache
     * is retained across restarts.
     */
    private Boolean logMiningBufferDropOnStop = false;
    /**
     * Specifies the XML configuration for the Infinispan 'events' cache
     */
    private String logMiningBufferInfinispanCacheEvents;
    /**
     * Specifies the XML configuration for the Infinispan
     * 'processed-transactions' cache
     */
    private String logMiningBufferInfinispanCacheProcessedTransactions;
    /**
     * Specifies the XML configuration for the Infinispan 'schema-changes' cache
     */
    private String logMiningBufferInfinispanCacheSchemaChanges;
    /**
     * Specifies the XML configuration for the Infinispan 'transactions' cache
     */
    private String logMiningBufferInfinispanCacheTransactions;
    /**
     * The buffer type controls how the connector manages buffering transaction
     * data. memory - Uses the JVM process' heap to buffer all transaction data.
     * infinispan_embedded - This option uses an embedded Infinispan cache to
     * buffer transaction data and persist it to disk. infinispan_remote - This
     * option uses a remote Infinispan cluster to buffer transaction data and
     * persist it to disk.
     */
    private String logMiningBufferType = "memory";
    /**
     * Used for SCN gap detection, if the difference between current SCN and
     * previous end SCN is bigger than this value, and the time difference of
     * current SCN and previous end SCN is smaller than
     * log.mining.scn.gap.detection.time.interval.max.ms, consider it a SCN gap.
     */
    private Long logMiningScnGapDetectionGapSizeMin = 1000000L;
    /**
     * Used for SCN gap detection, if the difference between current SCN and
     * previous end SCN is bigger than
     * log.mining.scn.gap.detection.gap.size.min, and the time difference of
     * current SCN and previous end SCN is smaller than this value, consider it
     * a SCN gap. The option is a long type.
     */
    private Long logMiningScnGapDetectionTimeIntervalMaxMs = 20000L;
    /**
     * The maximum number of milliseconds that a LogMiner session lives for
     * before being restarted. Defaults to 0 (indefinite until a log switch
     * occurs). The option is a long type.
     */
    private Long logMiningSessionMaxMs = 0L;
    /**
     * The amount of time that the connector will sleep after reading data from
     * redo/archive logs and before starting reading data again. Value is in
     * milliseconds. The option is a long type.
     */
    private Long logMiningSleepTimeDefaultMs = 1000L;
    /**
     * The maximum amount of time that the connector will use to tune the
     * optimal sleep time when reading data from LogMiner. Value is in
     * milliseconds. The option is a long type.
     */
    private Long logMiningSleepTimeIncrementMs = 200L;
    /**
     * The maximum amount of time that the connector will sleep after reading
     * data from redo/archive logs and before starting reading data again. Value
     * is in milliseconds. The option is a long type.
     */
    private Long logMiningSleepTimeMaxMs = 3000L;
    /**
     * The minimum amount of time that the connector will sleep after reading
     * data from redo/archive logs and before starting reading data again. Value
     * is in milliseconds. The option is a long type.
     */
    private Long logMiningSleepTimeMinMs = 0L;
    /**
     * There are strategies: Online catalog with faster mining but no captured
     * DDL. Another - with data dictionary loaded into REDO LOG files
     */
    private String logMiningStrategy = "redo_log_catalog";
    /**
     * Hours to keep long running transactions in transaction buffer between log
     * mining sessions. By default, all transactions are retained.
     */
    private Long logMiningTransactionRetentionHours = 0L;
    /**
     * Comma separated list of usernames to exclude from LogMiner query.
     */
    private String logMiningUsernameExcludeList;
    /**
     * Maximum size of each batch of source records. Defaults to 2048.
     */
    private Integer maxBatchSize = 2048;
    /**
     * Maximum size of the queue for change events read from the database log
     * but not yet recorded or forwarded. Defaults to 8192, and should always be
     * larger than the maximum batch size.
     */
    private Integer maxQueueSize = 8192;
    /**
     * Maximum size of the queue in bytes for change events read from the
     * database log but not yet recorded or forwarded. Defaults to 0. Mean the
     * feature is not enabled
     */
    private Long maxQueueSizeInBytes = 0L;
    /**
     * A semicolon-separated list of expressions that match fully-qualified
     * tables and column(s) to be used as message key. Each expression must
     * match the pattern ':',where the table names could be defined as
     * (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on the
     * specific connector,and the key columns are a comma-separated list of
     * columns representing the custom key. For any table without an explicit
     * key configuration the table's primary key column(s) will be used as
     * message key.Example:
     * dbserver1.inventory.orderlines:orderId,orderLineId;dbserver1.inventory.orders:id
     */
    private String messageKeyColumns;
    /**
     * Time to wait for new change events to appear after receiving no events,
     * given in milliseconds. Defaults to 500 ms. The option is a long type.
     */
    private Long pollIntervalMs = 500L;
    /**
     * Enables transaction metadata extraction together with event counting
     */
    private Boolean provideTransactionMetadata = false;
    /**
     * The maximum number of records that should be loaded into memory while
     * streaming. A value of 0 uses the default JDBC fetch size.
     */
    private Integer queryFetchSize = 0;
    /**
     * A comma-separated list of RAC node hostnames or ip addresses
     */
    private String racNodes;
    /**
     * Time to wait before restarting connector after retriable exception
     * occurs. Defaults to 10000ms. The option is a long type.
     */
    private Long retriableRestartConnectorWaitMs = 10000L;
    /**
     * Whether field names will be sanitized to Avro naming conventions
     */
    private Boolean sanitizeFieldNames = false;
    /**
     * Specify how schema names should be adjusted for compatibility with the
     * message converter used by the connector, including:'avro' replaces the
     * characters that cannot be used in the Avro type name with underscore
     * (default)'none' does not apply any adjustment
     */
    private String schemaNameAdjustmentMode = "avro";
    /**
     * The name of the data collection that is used to send signals/commands to
     * Debezium. Signaling is disabled when not set.
     */
    private String signalDataCollection;
    /**
     * The comma-separated list of operations to skip during streaming, defined
     * as: 'c' for inserts/create; 'u' for updates; 'd' for deletes, 't' for
     * truncates, and 'none' to indicate nothing skipped. By default, no
     * operations will be skipped.
     */
    private String skippedOperations;
    /**
     * A delay period before a snapshot will begin, given in milliseconds.
     * Defaults to 0 ms. The option is a long type.
     */
    private Long snapshotDelayMs = 0L;
    /**
     * A token to replace on snapshot predicate template
     */
    private String snapshotEnhancePredicateScn;
    /**
     * The maximum number of records that should be loaded into memory while
     * performing a snapshot
     */
    private Integer snapshotFetchSize;
    /**
     * this setting must be set to specify a list of tables/collections whose
     * snapshot must be taken on creating or restarting the connector.
     */
    private String snapshotIncludeCollectionList;
    /**
     * Controls how the connector holds locks on tables while performing the
     * schema snapshot. The default is 'shared', which means the connector will
     * hold a table lock that prevents exclusive table access for just the
     * initial portion of the snapshot while the database schemas and other
     * metadata are being read. The remaining work in a snapshot involves
     * selecting all rows from each table, and this is done using a flashback
     * query that requires no locks. However, in some cases it may be desirable
     * to avoid locks entirely which can be done by specifying 'none'. This mode
     * is only safe to use if no schema changes are happening while the snapshot
     * is taken.
     */
    private String snapshotLockingMode = "shared";
    /**
     * The maximum number of millis to wait for table locks at the beginning of
     * a snapshot. If locks cannot be acquired in this time frame, the snapshot
     * will be aborted. Defaults to 10 seconds. The option is a long type.
     */
    private Long snapshotLockTimeoutMs = 10000L;
    /**
     * The maximum number of threads used to perform the snapshot. Defaults to
     * 1.
     */
    private Integer snapshotMaxThreads = 1;
    /**
     * The criteria for running a snapshot upon startup of the connector.
     * Options include: 'initial' (the default) to specify the connector should
     * run a snapshot only when no offsets are available for the logical server
     * name; 'schema_only' to specify the connector should run a snapshot of the
     * schema when no offsets are available for the logical server name.
     */
    private String snapshotMode = "initial";
    /**
     * This property contains a comma-separated list of fully-qualified tables
     * (DB_NAME.TABLE_NAME) or (SCHEMA_NAME.TABLE_NAME), depending on
     * thespecific connectors. Select statements for the individual tables are
     * specified in further configuration properties, one for each table,
     * identified by the id
     * 'snapshot.select.statement.overrides.DB_NAME.TABLE_NAME' or
     * 'snapshot.select.statement.overrides.SCHEMA_NAME.TABLE_NAME',
     * respectively. The value of those properties is the select statement to
     * use when retrieving data from the specific table during snapshotting. A
     * possible use case for large append-only tables is setting a specific
     * point where to start (resume) snapshotting, in case a previous
     * snapshotting was interrupted.
     */
    private String snapshotSelectStatementOverrides;
    /**
     * A version of the format of the publicly visible source part in the
     * message
     */
    private String sourceStructVersion = "v2";
    /**
     * A comma-separated list of regular expressions that match the
     * fully-qualified names of tables to be excluded from monitoring
     * (deprecated, use table.exclude.list instead)
     */
    private String tableBlacklist;
    /**
     * A comma-separated list of regular expressions that match the
     * fully-qualified names of tables to be excluded from monitoring
     */
    private String tableExcludeList;
    /**
     * The tables for which changes are to be captured
     */
    private String tableIncludeList;
    /**
     * The tables for which changes are to be captured (deprecated, use
     * table.include.list instead)
     */
    private String tableWhitelist;
    /**
     * Time, date, and timestamps can be represented with different kinds of
     * precisions, including:'adaptive' (the default) bases the precision of
     * time, date, and timestamp values on the database column's precision;
     * 'adaptive_time_microseconds' like 'adaptive' mode, but TIME fields always
     * use microseconds precision;'connect' always represents time, date, and
     * timestamp values using Kafka Connect's built-in representations for Time,
     * Date, and Timestamp, which uses millisecond precision regardless of the
     * database columns' precision .
     */
    private String timePrecisionMode = "adaptive";
    /**
     * Whether delete operations should be represented by a delete event and a
     * subsquenttombstone event (true) or only by a delete event (false).
     * Emitting the tombstone event (the default behavior) allows Kafka to
     * completely delete all events pertaining to the given key once the source
     * record got deleted.
     */
    private Boolean tombstonesOnDelete = false;
    /**
     * The name of the transaction metadata topic. The placeholder
     * ${database.server.name} can be used for referring to the connector's
     * logical name; defaults to ${database.server.name}.transaction.
     */
    private String transactionTopic = "${database.server.name}.transaction";
    /**
     * Specify the constant that will be provided by Debezium to indicate that
     * the original value is unavailable and not provided by the database.
     */
    private String unavailableValuePlaceholder = "__debezium_unavailable_value";

    public Map<String, Object> getAdditionalProperties() {
        return additionalProperties;
    }

    public void setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
    }

    public Boolean getBridgeErrorHandler() {
        return bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(Boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public OracleConnectorEmbeddedDebeziumConfiguration getConfiguration() {
        return configuration;
    }

    public void setConfiguration(
            OracleConnectorEmbeddedDebeziumConfiguration configuration) {
        this.configuration = configuration;
    }

    public String getInternalKeyConverter() {
        return internalKeyConverter;
    }

    public void setInternalKeyConverter(String internalKeyConverter) {
        this.internalKeyConverter = internalKeyConverter;
    }

    public String getInternalValueConverter() {
        return internalValueConverter;
    }

    public void setInternalValueConverter(String internalValueConverter) {
        this.internalValueConverter = internalValueConverter;
    }

    public String getOffsetCommitPolicy() {
        return offsetCommitPolicy;
    }

    public void setOffsetCommitPolicy(String offsetCommitPolicy) {
        this.offsetCommitPolicy = offsetCommitPolicy;
    }

    public Long getOffsetCommitTimeoutMs() {
        return offsetCommitTimeoutMs;
    }

    public void setOffsetCommitTimeoutMs(Long offsetCommitTimeoutMs) {
        this.offsetCommitTimeoutMs = offsetCommitTimeoutMs;
    }

    public Long getOffsetFlushIntervalMs() {
        return offsetFlushIntervalMs;
    }

    public void setOffsetFlushIntervalMs(Long offsetFlushIntervalMs) {
        this.offsetFlushIntervalMs = offsetFlushIntervalMs;
    }

    public String getOffsetStorage() {
        return offsetStorage;
    }

    public void setOffsetStorage(String offsetStorage) {
        this.offsetStorage = offsetStorage;
    }

    public String getOffsetStorageFileName() {
        return offsetStorageFileName;
    }

    public void setOffsetStorageFileName(String offsetStorageFileName) {
        this.offsetStorageFileName = offsetStorageFileName;
    }

    public Integer getOffsetStoragePartitions() {
        return offsetStoragePartitions;
    }

    public void setOffsetStoragePartitions(Integer offsetStoragePartitions) {
        this.offsetStoragePartitions = offsetStoragePartitions;
    }

    public Integer getOffsetStorageReplicationFactor() {
        return offsetStorageReplicationFactor;
    }

    public void setOffsetStorageReplicationFactor(
            Integer offsetStorageReplicationFactor) {
        this.offsetStorageReplicationFactor = offsetStorageReplicationFactor;
    }

    public String getOffsetStorageTopic() {
        return offsetStorageTopic;
    }

    public void setOffsetStorageTopic(String offsetStorageTopic) {
        this.offsetStorageTopic = offsetStorageTopic;
    }

    public Boolean getAutowiredEnabled() {
        return autowiredEnabled;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public String getBinaryHandlingMode() {
        return binaryHandlingMode;
    }

    public void setBinaryHandlingMode(String binaryHandlingMode) {
        this.binaryHandlingMode = binaryHandlingMode;
    }

    public String getColumnBlacklist() {
        return columnBlacklist;
    }

    public void setColumnBlacklist(String columnBlacklist) {
        this.columnBlacklist = columnBlacklist;
    }

    public String getColumnExcludeList() {
        return columnExcludeList;
    }

    public void setColumnExcludeList(String columnExcludeList) {
        this.columnExcludeList = columnExcludeList;
    }

    public String getColumnIncludeList() {
        return columnIncludeList;
    }

    public void setColumnIncludeList(String columnIncludeList) {
        this.columnIncludeList = columnIncludeList;
    }

    public String getColumnPropagateSourceType() {
        return columnPropagateSourceType;
    }

    public void setColumnPropagateSourceType(String columnPropagateSourceType) {
        this.columnPropagateSourceType = columnPropagateSourceType;
    }

    public String getColumnWhitelist() {
        return columnWhitelist;
    }

    public void setColumnWhitelist(String columnWhitelist) {
        this.columnWhitelist = columnWhitelist;
    }

    public String getConverters() {
        return converters;
    }

    public void setConverters(String converters) {
        this.converters = converters;
    }

    public String getDatabaseConnectionAdapter() {
        return databaseConnectionAdapter;
    }

    public void setDatabaseConnectionAdapter(String databaseConnectionAdapter) {
        this.databaseConnectionAdapter = databaseConnectionAdapter;
    }

    public String getDatabaseDbname() {
        return databaseDbname;
    }

    public void setDatabaseDbname(String databaseDbname) {
        this.databaseDbname = databaseDbname;
    }

    public String getDatabaseHistory() {
        return databaseHistory;
    }

    public void setDatabaseHistory(String databaseHistory) {
        this.databaseHistory = databaseHistory;
    }

    public String getDatabaseHistoryFileFilename() {
        return databaseHistoryFileFilename;
    }

    public void setDatabaseHistoryFileFilename(
            String databaseHistoryFileFilename) {
        this.databaseHistoryFileFilename = databaseHistoryFileFilename;
    }

    public String getDatabaseHistoryKafkaBootstrapServers() {
        return databaseHistoryKafkaBootstrapServers;
    }

    public void setDatabaseHistoryKafkaBootstrapServers(
            String databaseHistoryKafkaBootstrapServers) {
        this.databaseHistoryKafkaBootstrapServers = databaseHistoryKafkaBootstrapServers;
    }

    public Long getDatabaseHistoryKafkaQueryTimeoutMs() {
        return databaseHistoryKafkaQueryTimeoutMs;
    }

    public void setDatabaseHistoryKafkaQueryTimeoutMs(
            Long databaseHistoryKafkaQueryTimeoutMs) {
        this.databaseHistoryKafkaQueryTimeoutMs = databaseHistoryKafkaQueryTimeoutMs;
    }

    public Integer getDatabaseHistoryKafkaRecoveryAttempts() {
        return databaseHistoryKafkaRecoveryAttempts;
    }

    public void setDatabaseHistoryKafkaRecoveryAttempts(
            Integer databaseHistoryKafkaRecoveryAttempts) {
        this.databaseHistoryKafkaRecoveryAttempts = databaseHistoryKafkaRecoveryAttempts;
    }

    public Integer getDatabaseHistoryKafkaRecoveryPollIntervalMs() {
        return databaseHistoryKafkaRecoveryPollIntervalMs;
    }

    public void setDatabaseHistoryKafkaRecoveryPollIntervalMs(
            Integer databaseHistoryKafkaRecoveryPollIntervalMs) {
        this.databaseHistoryKafkaRecoveryPollIntervalMs = databaseHistoryKafkaRecoveryPollIntervalMs;
    }

    public String getDatabaseHistoryKafkaTopic() {
        return databaseHistoryKafkaTopic;
    }

    public void setDatabaseHistoryKafkaTopic(String databaseHistoryKafkaTopic) {
        this.databaseHistoryKafkaTopic = databaseHistoryKafkaTopic;
    }

    public Boolean getDatabaseHistorySkipUnparseableDdl() {
        return databaseHistorySkipUnparseableDdl;
    }

    public void setDatabaseHistorySkipUnparseableDdl(
            Boolean databaseHistorySkipUnparseableDdl) {
        this.databaseHistorySkipUnparseableDdl = databaseHistorySkipUnparseableDdl;
    }

    public Boolean getDatabaseHistoryStoreOnlyCapturedTablesDdl() {
        return databaseHistoryStoreOnlyCapturedTablesDdl;
    }

    public void setDatabaseHistoryStoreOnlyCapturedTablesDdl(
            Boolean databaseHistoryStoreOnlyCapturedTablesDdl) {
        this.databaseHistoryStoreOnlyCapturedTablesDdl = databaseHistoryStoreOnlyCapturedTablesDdl;
    }

    public Boolean getDatabaseHistoryStoreOnlyMonitoredTablesDdl() {
        return databaseHistoryStoreOnlyMonitoredTablesDdl;
    }

    public void setDatabaseHistoryStoreOnlyMonitoredTablesDdl(
            Boolean databaseHistoryStoreOnlyMonitoredTablesDdl) {
        this.databaseHistoryStoreOnlyMonitoredTablesDdl = databaseHistoryStoreOnlyMonitoredTablesDdl;
    }

    public String getDatabaseHostname() {
        return databaseHostname;
    }

    public void setDatabaseHostname(String databaseHostname) {
        this.databaseHostname = databaseHostname;
    }

    public String getDatabaseOutServerName() {
        return databaseOutServerName;
    }

    public void setDatabaseOutServerName(String databaseOutServerName) {
        this.databaseOutServerName = databaseOutServerName;
    }

    public String getDatabasePassword() {
        return databasePassword;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public String getDatabasePdbName() {
        return databasePdbName;
    }

    public void setDatabasePdbName(String databasePdbName) {
        this.databasePdbName = databasePdbName;
    }

    public Integer getDatabasePort() {
        return databasePort;
    }

    public void setDatabasePort(Integer databasePort) {
        this.databasePort = databasePort;
    }

    public String getDatabaseServerName() {
        return databaseServerName;
    }

    public void setDatabaseServerName(String databaseServerName) {
        this.databaseServerName = databaseServerName;
    }

    public String getDatabaseUrl() {
        return databaseUrl;
    }

    public void setDatabaseUrl(String databaseUrl) {
        this.databaseUrl = databaseUrl;
    }

    public String getDatabaseUser() {
        return databaseUser;
    }

    public void setDatabaseUser(String databaseUser) {
        this.databaseUser = databaseUser;
    }

    public String getDatatypePropagateSourceType() {
        return datatypePropagateSourceType;
    }

    public void setDatatypePropagateSourceType(
            String datatypePropagateSourceType) {
        this.datatypePropagateSourceType = datatypePropagateSourceType;
    }

    public String getDecimalHandlingMode() {
        return decimalHandlingMode;
    }

    public void setDecimalHandlingMode(String decimalHandlingMode) {
        this.decimalHandlingMode = decimalHandlingMode;
    }

    public String getEventProcessingFailureHandlingMode() {
        return eventProcessingFailureHandlingMode;
    }

    public void setEventProcessingFailureHandlingMode(
            String eventProcessingFailureHandlingMode) {
        this.eventProcessingFailureHandlingMode = eventProcessingFailureHandlingMode;
    }

    public String getHeartbeatActionQuery() {
        return heartbeatActionQuery;
    }

    public void setHeartbeatActionQuery(String heartbeatActionQuery) {
        this.heartbeatActionQuery = heartbeatActionQuery;
    }

    public Integer getHeartbeatIntervalMs() {
        return heartbeatIntervalMs;
    }

    public void setHeartbeatIntervalMs(Integer heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
    }

    public String getHeartbeatTopicsPrefix() {
        return heartbeatTopicsPrefix;
    }

    public void setHeartbeatTopicsPrefix(String heartbeatTopicsPrefix) {
        this.heartbeatTopicsPrefix = heartbeatTopicsPrefix;
    }

    public Boolean getIncludeSchemaChanges() {
        return includeSchemaChanges;
    }

    public void setIncludeSchemaChanges(Boolean includeSchemaChanges) {
        this.includeSchemaChanges = includeSchemaChanges;
    }

    public Boolean getIncludeSchemaComments() {
        return includeSchemaComments;
    }

    public void setIncludeSchemaComments(Boolean includeSchemaComments) {
        this.includeSchemaComments = includeSchemaComments;
    }

    public String getIntervalHandlingMode() {
        return intervalHandlingMode;
    }

    public void setIntervalHandlingMode(String intervalHandlingMode) {
        this.intervalHandlingMode = intervalHandlingMode;
    }

    public Boolean getLobEnabled() {
        return lobEnabled;
    }

    public void setLobEnabled(Boolean lobEnabled) {
        this.lobEnabled = lobEnabled;
    }

    public String getLogMiningArchiveDestinationName() {
        return logMiningArchiveDestinationName;
    }

    public void setLogMiningArchiveDestinationName(
            String logMiningArchiveDestinationName) {
        this.logMiningArchiveDestinationName = logMiningArchiveDestinationName;
    }

    public Long getLogMiningArchiveLogHours() {
        return logMiningArchiveLogHours;
    }

    public void setLogMiningArchiveLogHours(Long logMiningArchiveLogHours) {
        this.logMiningArchiveLogHours = logMiningArchiveLogHours;
    }

    public Boolean getLogMiningArchiveLogOnlyMode() {
        return logMiningArchiveLogOnlyMode;
    }

    public void setLogMiningArchiveLogOnlyMode(
            Boolean logMiningArchiveLogOnlyMode) {
        this.logMiningArchiveLogOnlyMode = logMiningArchiveLogOnlyMode;
    }

    public Long getLogMiningArchiveLogOnlyScnPollIntervalMs() {
        return logMiningArchiveLogOnlyScnPollIntervalMs;
    }

    public void setLogMiningArchiveLogOnlyScnPollIntervalMs(
            Long logMiningArchiveLogOnlyScnPollIntervalMs) {
        this.logMiningArchiveLogOnlyScnPollIntervalMs = logMiningArchiveLogOnlyScnPollIntervalMs;
    }

    public Long getLogMiningBatchSizeDefault() {
        return logMiningBatchSizeDefault;
    }

    public void setLogMiningBatchSizeDefault(Long logMiningBatchSizeDefault) {
        this.logMiningBatchSizeDefault = logMiningBatchSizeDefault;
    }

    public Long getLogMiningBatchSizeMax() {
        return logMiningBatchSizeMax;
    }

    public void setLogMiningBatchSizeMax(Long logMiningBatchSizeMax) {
        this.logMiningBatchSizeMax = logMiningBatchSizeMax;
    }

    public Long getLogMiningBatchSizeMin() {
        return logMiningBatchSizeMin;
    }

    public void setLogMiningBatchSizeMin(Long logMiningBatchSizeMin) {
        this.logMiningBatchSizeMin = logMiningBatchSizeMin;
    }

    public Boolean getLogMiningBufferDropOnStop() {
        return logMiningBufferDropOnStop;
    }

    public void setLogMiningBufferDropOnStop(Boolean logMiningBufferDropOnStop) {
        this.logMiningBufferDropOnStop = logMiningBufferDropOnStop;
    }

    public String getLogMiningBufferInfinispanCacheEvents() {
        return logMiningBufferInfinispanCacheEvents;
    }

    public void setLogMiningBufferInfinispanCacheEvents(
            String logMiningBufferInfinispanCacheEvents) {
        this.logMiningBufferInfinispanCacheEvents = logMiningBufferInfinispanCacheEvents;
    }

    public String getLogMiningBufferInfinispanCacheProcessedTransactions() {
        return logMiningBufferInfinispanCacheProcessedTransactions;
    }

    public void setLogMiningBufferInfinispanCacheProcessedTransactions(
            String logMiningBufferInfinispanCacheProcessedTransactions) {
        this.logMiningBufferInfinispanCacheProcessedTransactions = logMiningBufferInfinispanCacheProcessedTransactions;
    }

    public String getLogMiningBufferInfinispanCacheSchemaChanges() {
        return logMiningBufferInfinispanCacheSchemaChanges;
    }

    public void setLogMiningBufferInfinispanCacheSchemaChanges(
            String logMiningBufferInfinispanCacheSchemaChanges) {
        this.logMiningBufferInfinispanCacheSchemaChanges = logMiningBufferInfinispanCacheSchemaChanges;
    }

    public String getLogMiningBufferInfinispanCacheTransactions() {
        return logMiningBufferInfinispanCacheTransactions;
    }

    public void setLogMiningBufferInfinispanCacheTransactions(
            String logMiningBufferInfinispanCacheTransactions) {
        this.logMiningBufferInfinispanCacheTransactions = logMiningBufferInfinispanCacheTransactions;
    }

    public String getLogMiningBufferType() {
        return logMiningBufferType;
    }

    public void setLogMiningBufferType(String logMiningBufferType) {
        this.logMiningBufferType = logMiningBufferType;
    }

    public Long getLogMiningScnGapDetectionGapSizeMin() {
        return logMiningScnGapDetectionGapSizeMin;
    }

    public void setLogMiningScnGapDetectionGapSizeMin(
            Long logMiningScnGapDetectionGapSizeMin) {
        this.logMiningScnGapDetectionGapSizeMin = logMiningScnGapDetectionGapSizeMin;
    }

    public Long getLogMiningScnGapDetectionTimeIntervalMaxMs() {
        return logMiningScnGapDetectionTimeIntervalMaxMs;
    }

    public void setLogMiningScnGapDetectionTimeIntervalMaxMs(
            Long logMiningScnGapDetectionTimeIntervalMaxMs) {
        this.logMiningScnGapDetectionTimeIntervalMaxMs = logMiningScnGapDetectionTimeIntervalMaxMs;
    }

    public Long getLogMiningSessionMaxMs() {
        return logMiningSessionMaxMs;
    }

    public void setLogMiningSessionMaxMs(Long logMiningSessionMaxMs) {
        this.logMiningSessionMaxMs = logMiningSessionMaxMs;
    }

    public Long getLogMiningSleepTimeDefaultMs() {
        return logMiningSleepTimeDefaultMs;
    }

    public void setLogMiningSleepTimeDefaultMs(Long logMiningSleepTimeDefaultMs) {
        this.logMiningSleepTimeDefaultMs = logMiningSleepTimeDefaultMs;
    }

    public Long getLogMiningSleepTimeIncrementMs() {
        return logMiningSleepTimeIncrementMs;
    }

    public void setLogMiningSleepTimeIncrementMs(
            Long logMiningSleepTimeIncrementMs) {
        this.logMiningSleepTimeIncrementMs = logMiningSleepTimeIncrementMs;
    }

    public Long getLogMiningSleepTimeMaxMs() {
        return logMiningSleepTimeMaxMs;
    }

    public void setLogMiningSleepTimeMaxMs(Long logMiningSleepTimeMaxMs) {
        this.logMiningSleepTimeMaxMs = logMiningSleepTimeMaxMs;
    }

    public Long getLogMiningSleepTimeMinMs() {
        return logMiningSleepTimeMinMs;
    }

    public void setLogMiningSleepTimeMinMs(Long logMiningSleepTimeMinMs) {
        this.logMiningSleepTimeMinMs = logMiningSleepTimeMinMs;
    }

    public String getLogMiningStrategy() {
        return logMiningStrategy;
    }

    public void setLogMiningStrategy(String logMiningStrategy) {
        this.logMiningStrategy = logMiningStrategy;
    }

    public Long getLogMiningTransactionRetentionHours() {
        return logMiningTransactionRetentionHours;
    }

    public void setLogMiningTransactionRetentionHours(
            Long logMiningTransactionRetentionHours) {
        this.logMiningTransactionRetentionHours = logMiningTransactionRetentionHours;
    }

    public String getLogMiningUsernameExcludeList() {
        return logMiningUsernameExcludeList;
    }

    public void setLogMiningUsernameExcludeList(
            String logMiningUsernameExcludeList) {
        this.logMiningUsernameExcludeList = logMiningUsernameExcludeList;
    }

    public Integer getMaxBatchSize() {
        return maxBatchSize;
    }

    public void setMaxBatchSize(Integer maxBatchSize) {
        this.maxBatchSize = maxBatchSize;
    }

    public Integer getMaxQueueSize() {
        return maxQueueSize;
    }

    public void setMaxQueueSize(Integer maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
    }

    public Long getMaxQueueSizeInBytes() {
        return maxQueueSizeInBytes;
    }

    public void setMaxQueueSizeInBytes(Long maxQueueSizeInBytes) {
        this.maxQueueSizeInBytes = maxQueueSizeInBytes;
    }

    public String getMessageKeyColumns() {
        return messageKeyColumns;
    }

    public void setMessageKeyColumns(String messageKeyColumns) {
        this.messageKeyColumns = messageKeyColumns;
    }

    public Long getPollIntervalMs() {
        return pollIntervalMs;
    }

    public void setPollIntervalMs(Long pollIntervalMs) {
        this.pollIntervalMs = pollIntervalMs;
    }

    public Boolean getProvideTransactionMetadata() {
        return provideTransactionMetadata;
    }

    public void setProvideTransactionMetadata(Boolean provideTransactionMetadata) {
        this.provideTransactionMetadata = provideTransactionMetadata;
    }

    public Integer getQueryFetchSize() {
        return queryFetchSize;
    }

    public void setQueryFetchSize(Integer queryFetchSize) {
        this.queryFetchSize = queryFetchSize;
    }

    public String getRacNodes() {
        return racNodes;
    }

    public void setRacNodes(String racNodes) {
        this.racNodes = racNodes;
    }

    public Long getRetriableRestartConnectorWaitMs() {
        return retriableRestartConnectorWaitMs;
    }

    public void setRetriableRestartConnectorWaitMs(
            Long retriableRestartConnectorWaitMs) {
        this.retriableRestartConnectorWaitMs = retriableRestartConnectorWaitMs;
    }

    public Boolean getSanitizeFieldNames() {
        return sanitizeFieldNames;
    }

    public void setSanitizeFieldNames(Boolean sanitizeFieldNames) {
        this.sanitizeFieldNames = sanitizeFieldNames;
    }

    public String getSchemaNameAdjustmentMode() {
        return schemaNameAdjustmentMode;
    }

    public void setSchemaNameAdjustmentMode(String schemaNameAdjustmentMode) {
        this.schemaNameAdjustmentMode = schemaNameAdjustmentMode;
    }

    public String getSignalDataCollection() {
        return signalDataCollection;
    }

    public void setSignalDataCollection(String signalDataCollection) {
        this.signalDataCollection = signalDataCollection;
    }

    public String getSkippedOperations() {
        return skippedOperations;
    }

    public void setSkippedOperations(String skippedOperations) {
        this.skippedOperations = skippedOperations;
    }

    public Long getSnapshotDelayMs() {
        return snapshotDelayMs;
    }

    public void setSnapshotDelayMs(Long snapshotDelayMs) {
        this.snapshotDelayMs = snapshotDelayMs;
    }

    public String getSnapshotEnhancePredicateScn() {
        return snapshotEnhancePredicateScn;
    }

    public void setSnapshotEnhancePredicateScn(
            String snapshotEnhancePredicateScn) {
        this.snapshotEnhancePredicateScn = snapshotEnhancePredicateScn;
    }

    public Integer getSnapshotFetchSize() {
        return snapshotFetchSize;
    }

    public void setSnapshotFetchSize(Integer snapshotFetchSize) {
        this.snapshotFetchSize = snapshotFetchSize;
    }

    public String getSnapshotIncludeCollectionList() {
        return snapshotIncludeCollectionList;
    }

    public void setSnapshotIncludeCollectionList(
            String snapshotIncludeCollectionList) {
        this.snapshotIncludeCollectionList = snapshotIncludeCollectionList;
    }

    public String getSnapshotLockingMode() {
        return snapshotLockingMode;
    }

    public void setSnapshotLockingMode(String snapshotLockingMode) {
        this.snapshotLockingMode = snapshotLockingMode;
    }

    public Long getSnapshotLockTimeoutMs() {
        return snapshotLockTimeoutMs;
    }

    public void setSnapshotLockTimeoutMs(Long snapshotLockTimeoutMs) {
        this.snapshotLockTimeoutMs = snapshotLockTimeoutMs;
    }

    public Integer getSnapshotMaxThreads() {
        return snapshotMaxThreads;
    }

    public void setSnapshotMaxThreads(Integer snapshotMaxThreads) {
        this.snapshotMaxThreads = snapshotMaxThreads;
    }

    public String getSnapshotMode() {
        return snapshotMode;
    }

    public void setSnapshotMode(String snapshotMode) {
        this.snapshotMode = snapshotMode;
    }

    public String getSnapshotSelectStatementOverrides() {
        return snapshotSelectStatementOverrides;
    }

    public void setSnapshotSelectStatementOverrides(
            String snapshotSelectStatementOverrides) {
        this.snapshotSelectStatementOverrides = snapshotSelectStatementOverrides;
    }

    public String getSourceStructVersion() {
        return sourceStructVersion;
    }

    public void setSourceStructVersion(String sourceStructVersion) {
        this.sourceStructVersion = sourceStructVersion;
    }

    public String getTableBlacklist() {
        return tableBlacklist;
    }

    public void setTableBlacklist(String tableBlacklist) {
        this.tableBlacklist = tableBlacklist;
    }

    public String getTableExcludeList() {
        return tableExcludeList;
    }

    public void setTableExcludeList(String tableExcludeList) {
        this.tableExcludeList = tableExcludeList;
    }

    public String getTableIncludeList() {
        return tableIncludeList;
    }

    public void setTableIncludeList(String tableIncludeList) {
        this.tableIncludeList = tableIncludeList;
    }

    public String getTableWhitelist() {
        return tableWhitelist;
    }

    public void setTableWhitelist(String tableWhitelist) {
        this.tableWhitelist = tableWhitelist;
    }

    public String getTimePrecisionMode() {
        return timePrecisionMode;
    }

    public void setTimePrecisionMode(String timePrecisionMode) {
        this.timePrecisionMode = timePrecisionMode;
    }

    public Boolean getTombstonesOnDelete() {
        return tombstonesOnDelete;
    }

    public void setTombstonesOnDelete(Boolean tombstonesOnDelete) {
        this.tombstonesOnDelete = tombstonesOnDelete;
    }

    public String getTransactionTopic() {
        return transactionTopic;
    }

    public void setTransactionTopic(String transactionTopic) {
        this.transactionTopic = transactionTopic;
    }

    public String getUnavailableValuePlaceholder() {
        return unavailableValuePlaceholder;
    }

    public void setUnavailableValuePlaceholder(
            String unavailableValuePlaceholder) {
        this.unavailableValuePlaceholder = unavailableValuePlaceholder;
    }
}