/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.xmlsecurity.springboot;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.stereotype.Component;

/**
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.springboot.maven.SpringBootAutoConfigurationMojo")
@Configuration(proxyBeanMethods = false)
@ConfigurationPropertiesBinding
@Component
public class XmlSignerComponentConverter implements GenericConverter {

    @Autowired
    private ApplicationContext applicationContext;

    public Set<ConvertiblePair> getConvertibleTypes() {
        Set<ConvertiblePair> answer = new LinkedHashSet<>();
        answer.add(new ConvertiblePair(String.class, javax.xml.crypto.AlgorithmMethod.class));
        answer.add(new ConvertiblePair(String.class, org.apache.camel.component.xmlsecurity.api.KeyAccessor.class));
        answer.add(new ConvertiblePair(String.class, javax.xml.crypto.dsig.spec.XPathFilterParameterSpec.class));
        answer.add(new ConvertiblePair(String.class, org.apache.camel.component.xmlsecurity.api.XmlSignatureProperties.class));
        answer.add(new ConvertiblePair(String.class, org.apache.camel.component.xmlsecurity.processor.XmlSignerConfiguration.class));
        answer.add(new ConvertiblePair(String.class, javax.xml.crypto.URIDereferencer.class));
        return answer;
    }

    public Object convert(
            Object source,
            TypeDescriptor sourceType,
            TypeDescriptor targetType) {
        if (source == null) {
            return null;
        }
        String ref = source.toString();
        if (!ref.startsWith("#")) {
            return null;
        }
        ref = ref.startsWith("#bean:") ? ref.substring(6) : ref.substring(1);
        switch (targetType.getName()) {
            case "javax.xml.crypto.AlgorithmMethod": return applicationContext.getBean(ref, javax.xml.crypto.AlgorithmMethod.class);
            case "org.apache.camel.component.xmlsecurity.api.KeyAccessor": return applicationContext.getBean(ref, org.apache.camel.component.xmlsecurity.api.KeyAccessor.class);
            case "javax.xml.crypto.dsig.spec.XPathFilterParameterSpec": return applicationContext.getBean(ref, javax.xml.crypto.dsig.spec.XPathFilterParameterSpec.class);
            case "org.apache.camel.component.xmlsecurity.api.XmlSignatureProperties": return applicationContext.getBean(ref, org.apache.camel.component.xmlsecurity.api.XmlSignatureProperties.class);
            case "org.apache.camel.component.xmlsecurity.processor.XmlSignerConfiguration": return applicationContext.getBean(ref, org.apache.camel.component.xmlsecurity.processor.XmlSignerConfiguration.class);
            case "javax.xml.crypto.URIDereferencer": return applicationContext.getBean(ref, javax.xml.crypto.URIDereferencer.class);
        }
        return null;
    }
}