/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.resteasy.springboot;

import javax.annotation.Generated;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.spring.boot.ComponentConfigurationPropertiesCommon;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * Expose REST endpoints and access external REST servers.
 * 
 * Generated by camel-package-maven-plugin - do not edit this file!
 */
@Generated("org.apache.camel.springboot.maven.SpringBootAutoConfigurationMojo")
@ConfigurationProperties(prefix = "camel.component.resteasy")
public class ResteasyComponentConfiguration
        extends
            ComponentConfigurationPropertiesCommon {

    /**
     * Whether to enable auto configuration of the resteasy component. This is
     * enabled by default.
     */
    private Boolean enabled;
    /**
     * Allows for bridging the consumer to the Camel routing Error Handler,
     * which mean any exceptions occurred while the consumer is trying to pickup
     * incoming messages, or the likes, will now be processed as a message and
     * handled by the routing Error Handler. By default the consumer will use
     * the org.apache.camel.spi.ExceptionHandler to deal with exceptions, that
     * will be logged at WARN or ERROR level and ignored.
     */
    private Boolean bridgeErrorHandler = false;
    /**
     * If enabled and an Exchange failed processing on the consumer side the
     * response's body won't contain the exception's stack trace.
     */
    private Boolean muteException = false;
    /**
     * Proxy classes for consumer endpoints. Multiple classes can be separated
     * by comma.
     */
    private String proxyConsumersClasses;
    /**
     * If this option is true then IN exchange headers will be copied to OUT
     * exchange headers according to copy strategy. Setting this to false,
     * allows to only include the headers from the HTTP response (not
     * propagating IN headers).
     */
    private Boolean copyHeaders = true;
    /**
     * Whether the producer should be started lazy (on the first message). By
     * starting lazy you can use this to allow CamelContext and routes to
     * startup in situations where a producer may otherwise fail during starting
     * and cause the route to fail being started. By deferring this startup to
     * be lazy then the startup failure can be handled during routing messages
     * via Camel's routing error handlers. Beware that when the first message is
     * processed then creating and starting the producer may take a little time
     * and prolong the total processing time of the processing.
     */
    private Boolean lazyStartProducer = false;
    /**
     * This threshold in bytes controls whether the response payload should be
     * stored in memory as a byte array or be streaming based. Set this to -1 to
     * always use streaming mode.
     */
    private Integer responsePayloadStreamingThreshold = 8192;
    /**
     * Whether to the HTTP request should follow redirects. By default the HTTP
     * request does not follow redirects
     */
    private Boolean followRedirects = false;
    /**
     * Whether to skip mapping all the Camel headers as HTTP request headers. If
     * there are no data from Camel headers needed to be included in the HTTP
     * request then this can avoid parsing overhead with many object allocations
     * for the JVM garbage collector.
     */
    private Boolean skipRequestHeaders = false;
    /**
     * Whether to skip mapping all the HTTP response headers to Camel headers.
     * If there are no data needed from HTTP headers then this can avoid parsing
     * overhead with many object allocations for the JVM garbage collector.
     */
    private Boolean skipResponseHeaders = false;
    /**
     * Whether to allow java serialization when a request uses
     * context-type=application/x-java-serialized-object. This is by default
     * turned off. If you enable this then be aware that Java will deserialize
     * the incoming data from the request to Java and that can be a potential
     * security risk.
     */
    private Boolean allowJavaSerializedObject = false;
    /**
     * Disables authentication scheme caching
     */
    private Boolean authCachingDisabled = false;
    /**
     * Disables automatic request recovery and re-execution
     */
    private Boolean automaticRetriesDisabled = false;
    /**
     * Whether autowiring is enabled. This is used for automatic autowiring
     * options (the option must be marked as autowired) by looking up in the
     * registry to find if there is a single instance of matching type, which
     * then gets configured on the component. This can be used for automatic
     * configuring JDBC data sources, JMS connection factories, AWS Clients,
     * etc.
     */
    private Boolean autowiredEnabled = true;
    /**
     * Disables connection state tracking
     */
    private Boolean connectionStateDisabled = false;
    /**
     * Disables automatic content decompression
     */
    private Boolean contentCompressionDisabled = false;
    /**
     * Disables state (cookie) management
     */
    private Boolean cookieManagementDisabled = false;
    /**
     * Disables the default user agent set by this builder if none has been
     * provided by the user
     */
    private Boolean defaultUserAgentDisabled = false;
    /**
     * Disables automatic redirect handling
     */
    private Boolean redirectHandlingDisabled = false;
    /**
     * To use a custom org.apache.camel.spi.HeaderFilterStrategy to filter
     * header to and from Camel message. The option is a
     * org.apache.camel.spi.HeaderFilterStrategy type.
     */
    private HeaderFilterStrategy headerFilterStrategy;

    public Boolean getBridgeErrorHandler() {
        return bridgeErrorHandler;
    }

    public void setBridgeErrorHandler(Boolean bridgeErrorHandler) {
        this.bridgeErrorHandler = bridgeErrorHandler;
    }

    public Boolean getMuteException() {
        return muteException;
    }

    public void setMuteException(Boolean muteException) {
        this.muteException = muteException;
    }

    public String getProxyConsumersClasses() {
        return proxyConsumersClasses;
    }

    public void setProxyConsumersClasses(String proxyConsumersClasses) {
        this.proxyConsumersClasses = proxyConsumersClasses;
    }

    public Boolean getCopyHeaders() {
        return copyHeaders;
    }

    public void setCopyHeaders(Boolean copyHeaders) {
        this.copyHeaders = copyHeaders;
    }

    public Boolean getLazyStartProducer() {
        return lazyStartProducer;
    }

    public void setLazyStartProducer(Boolean lazyStartProducer) {
        this.lazyStartProducer = lazyStartProducer;
    }

    public Integer getResponsePayloadStreamingThreshold() {
        return responsePayloadStreamingThreshold;
    }

    public void setResponsePayloadStreamingThreshold(
            Integer responsePayloadStreamingThreshold) {
        this.responsePayloadStreamingThreshold = responsePayloadStreamingThreshold;
    }

    public Boolean getFollowRedirects() {
        return followRedirects;
    }

    public void setFollowRedirects(Boolean followRedirects) {
        this.followRedirects = followRedirects;
    }

    public Boolean getSkipRequestHeaders() {
        return skipRequestHeaders;
    }

    public void setSkipRequestHeaders(Boolean skipRequestHeaders) {
        this.skipRequestHeaders = skipRequestHeaders;
    }

    public Boolean getSkipResponseHeaders() {
        return skipResponseHeaders;
    }

    public void setSkipResponseHeaders(Boolean skipResponseHeaders) {
        this.skipResponseHeaders = skipResponseHeaders;
    }

    public Boolean getAllowJavaSerializedObject() {
        return allowJavaSerializedObject;
    }

    public void setAllowJavaSerializedObject(Boolean allowJavaSerializedObject) {
        this.allowJavaSerializedObject = allowJavaSerializedObject;
    }

    public Boolean getAuthCachingDisabled() {
        return authCachingDisabled;
    }

    public void setAuthCachingDisabled(Boolean authCachingDisabled) {
        this.authCachingDisabled = authCachingDisabled;
    }

    public Boolean getAutomaticRetriesDisabled() {
        return automaticRetriesDisabled;
    }

    public void setAutomaticRetriesDisabled(Boolean automaticRetriesDisabled) {
        this.automaticRetriesDisabled = automaticRetriesDisabled;
    }

    public Boolean getAutowiredEnabled() {
        return autowiredEnabled;
    }

    public void setAutowiredEnabled(Boolean autowiredEnabled) {
        this.autowiredEnabled = autowiredEnabled;
    }

    public Boolean getConnectionStateDisabled() {
        return connectionStateDisabled;
    }

    public void setConnectionStateDisabled(Boolean connectionStateDisabled) {
        this.connectionStateDisabled = connectionStateDisabled;
    }

    public Boolean getContentCompressionDisabled() {
        return contentCompressionDisabled;
    }

    public void setContentCompressionDisabled(Boolean contentCompressionDisabled) {
        this.contentCompressionDisabled = contentCompressionDisabled;
    }

    public Boolean getCookieManagementDisabled() {
        return cookieManagementDisabled;
    }

    public void setCookieManagementDisabled(Boolean cookieManagementDisabled) {
        this.cookieManagementDisabled = cookieManagementDisabled;
    }

    public Boolean getDefaultUserAgentDisabled() {
        return defaultUserAgentDisabled;
    }

    public void setDefaultUserAgentDisabled(Boolean defaultUserAgentDisabled) {
        this.defaultUserAgentDisabled = defaultUserAgentDisabled;
    }

    public Boolean getRedirectHandlingDisabled() {
        return redirectHandlingDisabled;
    }

    public void setRedirectHandlingDisabled(Boolean redirectHandlingDisabled) {
        this.redirectHandlingDisabled = redirectHandlingDisabled;
    }

    public HeaderFilterStrategy getHeaderFilterStrategy() {
        return headerFilterStrategy;
    }

    public void setHeaderFilterStrategy(
            HeaderFilterStrategy headerFilterStrategy) {
        this.headerFilterStrategy = headerFilterStrategy;
    }
}