/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.builder.endpoint.dsl;

import java.util.*;
import java.util.Map;
import java.util.concurrent.*;
import java.util.function.*;
import java.util.stream.*;
import javax.annotation.Generated;
import org.apache.camel.builder.EndpointConsumerBuilder;
import org.apache.camel.builder.EndpointProducerBuilder;
import org.apache.camel.builder.endpoint.AbstractEndpointBuilder;

/**
 * Store and retrieve blobs from Azure Storage Blob Service.
 * 
 * Generated by camel build tools - do NOT edit this file!
 */
@Generated("org.apache.camel.maven.packaging.EndpointDslMojo")
public interface BlobEndpointBuilderFactory {


    /**
     * Builder for endpoint consumers for the Azure Storage Blob Service
     * component.
     */
    public interface BlobEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default AdvancedBlobEndpointConsumerBuilder advanced() {
            return (AdvancedBlobEndpointConsumerBuilder) this;
        }
        /**
         * The blob name, to consume specific blob from a container. However, on
         * producer it is only required for the operations on the blob level.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param blobName the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder blobName(String blobName) {
            doSetProperty("blobName", blobName);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder blobOffset(long blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder blobOffset(String blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param blobServiceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder blobServiceClient(
                com.azure.storage.blob.BlobServiceClient blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param blobServiceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder blobServiceClient(
                String blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder blobType(
                org.apache.camel.component.azure.storage.blob.BlobType blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder blobType(String blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder closeStreamAfterRead(
                boolean closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder closeStreamAfterRead(
                String closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder credentials(
                com.azure.storage.common.StorageSharedKeyCredential credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.CredentialType&lt;/code&gt; type.
         * 
         * Default: AZURE_IDENTITY
         * Group: common
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder credentialType(
                org.apache.camel.component.azure.storage.blob.CredentialType credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.CredentialType&lt;/code&gt; type.
         * 
         * Default: AZURE_IDENTITY
         * Group: common
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder credentialType(String credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder dataCount(Long dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder dataCount(String dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * The file directory where the downloaded blobs will be saved to, this
         * can be used in both, producer and consumer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileDir the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder fileDir(String fileDir) {
            doSetProperty("fileDir", fileDir);
            return this;
        }
        /**
         * Specifies the maximum number of blobs to return, including all
         * BlobPrefix elements. If the request does not specify
         * maxResultsPerPage or specifies a value greater than 5,000, the server
         * will return up to 5,000 items.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResultsPerPage the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder maxResultsPerPage(
                Integer maxResultsPerPage) {
            doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }
        /**
         * Specifies the maximum number of blobs to return, including all
         * BlobPrefix elements. If the request does not specify
         * maxResultsPerPage or specifies a value greater than 5,000, the server
         * will return up to 5,000 items.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResultsPerPage the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder maxResultsPerPage(
                String maxResultsPerPage) {
            doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder maxRetryRequests(
                int maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder maxRetryRequests(
                String maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Filters the results to return only blobs whose names begin with the
         * specified prefix. May be null to return all blobs.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder prefix(String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * Filters the results to return only blobs whose names match the
         * specified regular expression. May be null to return all if both
         * prefix and regex are set, regex takes the priority and prefix is
         * ignored.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param regex the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder regex(String regex) {
            doSetProperty("regex", regex);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * BlobServiceClient#getBlobContainerClient(String), and operations on a
         * blob are available on BlobClient through
         * BlobContainerClient#getBlobClient(String).
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder serviceClient(
                com.azure.storage.blob.BlobServiceClient serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * BlobServiceClient#getBlobContainerClient(String), and operations on a
         * blob are available on BlobClient through
         * BlobContainerClient#getBlobClient(String).
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder serviceClient(String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * An optional timeout value beyond which a RuntimeException will be
         * raised.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder timeout(java.time.Duration timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * An optional timeout value beyond which a RuntimeException will be
         * raised.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                boolean sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * If the polling consumer did not poll any files, you can enable this
         * option to send an empty message (no body) instead.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer
         * 
         * @param sendEmptyMessageWhenIdle the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder sendEmptyMessageWhenIdle(
                String sendEmptyMessageWhenIdle) {
            doSetProperty("sendEmptyMessageWhenIdle", sendEmptyMessageWhenIdle);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder backoffErrorThreshold(
                int backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent error polls (failed due some error) that
         * should happen before the backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffErrorThreshold the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder backoffErrorThreshold(
                String backoffErrorThreshold) {
            doSetProperty("backoffErrorThreshold", backoffErrorThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder backoffIdleThreshold(
                int backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * The number of subsequent idle polls that should happen before the
         * backoffMultipler should kick-in.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffIdleThreshold the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder backoffIdleThreshold(
                String backoffIdleThreshold) {
            doSetProperty("backoffIdleThreshold", backoffIdleThreshold);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder backoffMultiplier(
                int backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * To let the scheduled polling consumer backoff if there has been a
         * number of subsequent idles/errors in a row. The multiplier is then
         * the number of polls that will be skipped before the next actual
         * attempt is happening again. When this option is in use then
         * backoffIdleThreshold and/or backoffErrorThreshold must also be
         * configured.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param backoffMultiplier the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder backoffMultiplier(
                String backoffMultiplier) {
            doSetProperty("backoffMultiplier", backoffMultiplier);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder delay(long delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * Milliseconds before the next poll.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 500
         * Group: scheduler
         * 
         * @param delay the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder delay(String delay) {
            doSetProperty("delay", delay);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder greedy(boolean greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * If greedy is enabled, then the ScheduledPollConsumer will run
         * immediately again, if the previous run polled 1 or more messages.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: scheduler
         * 
         * @param greedy the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder greedy(String greedy) {
            doSetProperty("greedy", greedy);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder initialDelay(long initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Milliseconds before the first poll starts.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 1000
         * Group: scheduler
         * 
         * @param initialDelay the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder initialDelay(String initialDelay) {
            doSetProperty("initialDelay", initialDelay);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder repeatCount(long repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * Specifies a maximum limit of number of fires. So if you set it to 1,
         * the scheduler will only fire once. If you set it to 5, it will only
         * fire five times. A value of zero or negative means fire forever.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: scheduler
         * 
         * @param repeatCount the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder repeatCount(String repeatCount) {
            doSetProperty("repeatCount", repeatCount);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder runLoggingLevel(
                org.apache.camel.LoggingLevel runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * The consumer logs a start/complete log line when it polls. This
         * option allows you to configure the logging level for that.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.LoggingLevel&lt;/code&gt; type.
         * 
         * Default: TRACE
         * Group: scheduler
         * 
         * @param runLoggingLevel the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder runLoggingLevel(
                String runLoggingLevel) {
            doSetProperty("runLoggingLevel", runLoggingLevel);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder scheduledExecutorService(
                ScheduledExecutorService scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * Allows for configuring a custom/shared thread pool to use for the
         * consumer. By default each consumer has its own single threaded thread
         * pool.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.ScheduledExecutorService&lt;/code&gt; type.
         * 
         * Group: scheduler
         * 
         * @param scheduledExecutorService the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder scheduledExecutorService(
                String scheduledExecutorService) {
            doSetProperty("scheduledExecutorService", scheduledExecutorService);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option is a: &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder scheduler(Object scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To use a cron scheduler from either camel-spring or camel-quartz
         * component. Use value spring or quartz for built in scheduler.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Object&lt;/code&gt; type.
         * 
         * Default: none
         * Group: scheduler
         * 
         * @param scheduler the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder scheduler(String scheduler) {
            doSetProperty("scheduler", scheduler);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param key the option key
         * @param value the option value
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder schedulerProperties(
                String key,
                Object value) {
            doSetMultiValueProperty("schedulerProperties", "scheduler." + key, value);
            return this;
        }
        /**
         * To configure additional properties when using a custom scheduler or
         * any of the Quartz, Spring based scheduler.
         * 
         * The option is a: &lt;code&gt;java.util.Map&amp;lt;java.lang.String,
         * java.lang.Object&amp;gt;&lt;/code&gt; type.
         * The option is multivalued, and you can use the
         * schedulerProperties(String, Object) method to add a value (call the
         * method multiple times to set more values).
         * 
         * Group: scheduler
         * 
         * @param values the values
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder schedulerProperties(Map values) {
            doSetMultiValueProperties("schedulerProperties", "scheduler.", values);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder startScheduler(
                boolean startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Whether the scheduler should be auto started.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param startScheduler the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder startScheduler(String startScheduler) {
            doSetProperty("startScheduler", startScheduler);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option is a:
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder timeUnit(TimeUnit timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Time unit for initialDelay and delay options.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.util.concurrent.TimeUnit&lt;/code&gt; type.
         * 
         * Default: MILLISECONDS
         * Group: scheduler
         * 
         * @param timeUnit the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder timeUnit(String timeUnit) {
            doSetProperty("timeUnit", timeUnit);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder useFixedDelay(boolean useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Controls if fixed delay or fixed rate is used. See
         * ScheduledExecutorService in JDK for details.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: scheduler
         * 
         * @param useFixedDelay the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder useFixedDelay(String useFixedDelay) {
            doSetProperty("useFixedDelay", useFixedDelay);
            return this;
        }
        /**
         * Access key for the associated azure account name to be used for
         * authentication with azure blob services.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Source Blob Access Key: for copyblob operation, sadly, we need to
         * have an accessKey for the source blob we want to copy Passing an
         * accessKey as header, it's unsafe so we could set as key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sourceBlobAccessKey the value to set
         * @return the dsl builder
         */
        default BlobEndpointConsumerBuilder sourceBlobAccessKey(
                String sourceBlobAccessKey) {
            doSetProperty("sourceBlobAccessKey", sourceBlobAccessKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint consumers for the Azure Storage Blob
     * Service component.
     */
    public interface AdvancedBlobEndpointConsumerBuilder
            extends
                EndpointConsumerBuilder {
        default BlobEndpointConsumerBuilder basic() {
            return (BlobEndpointConsumerBuilder) this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedBlobEndpointConsumerBuilder bridgeErrorHandler(
                boolean bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * Allows for bridging the consumer to the Camel routing Error Handler,
         * which mean any exceptions occurred while the consumer is trying to
         * pickup incoming messages, or the likes, will now be processed as a
         * message and handled by the routing Error Handler. By default the
         * consumer will use the org.apache.camel.spi.ExceptionHandler to deal
         * with exceptions, that will be logged at WARN or ERROR level and
         * ignored.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: consumer (advanced)
         * 
         * @param bridgeErrorHandler the value to set
         * @return the dsl builder
         */
        default AdvancedBlobEndpointConsumerBuilder bridgeErrorHandler(
                String bridgeErrorHandler) {
            doSetProperty("bridgeErrorHandler", bridgeErrorHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedBlobEndpointConsumerBuilder exceptionHandler(
                org.apache.camel.spi.ExceptionHandler exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * To let the consumer use a custom ExceptionHandler. Notice if the
         * option bridgeErrorHandler is enabled then this option is not in use.
         * By default the consumer will deal with exceptions, that will be
         * logged at WARN or ERROR level and ignored.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.ExceptionHandler&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exceptionHandler the value to set
         * @return the dsl builder
         */
        default AdvancedBlobEndpointConsumerBuilder exceptionHandler(
                String exceptionHandler) {
            doSetProperty("exceptionHandler", exceptionHandler);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedBlobEndpointConsumerBuilder exchangePattern(
                org.apache.camel.ExchangePattern exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * Sets the exchange pattern when the consumer creates an exchange.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.ExchangePattern&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param exchangePattern the value to set
         * @return the dsl builder
         */
        default AdvancedBlobEndpointConsumerBuilder exchangePattern(
                String exchangePattern) {
            doSetProperty("exchangePattern", exchangePattern);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedBlobEndpointConsumerBuilder pollStrategy(
                org.apache.camel.spi.PollingConsumerPollStrategy pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
        /**
         * A pluggable org.apache.camel.PollingConsumerPollingStrategy allowing
         * you to provide your custom implementation to control error handling
         * usually occurred during the poll operation before an Exchange have
         * been created and being routed in Camel.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.spi.PollingConsumerPollStrategy&lt;/code&gt; type.
         * 
         * Group: consumer (advanced)
         * 
         * @param pollStrategy the value to set
         * @return the dsl builder
         */
        default AdvancedBlobEndpointConsumerBuilder pollStrategy(
                String pollStrategy) {
            doSetProperty("pollStrategy", pollStrategy);
            return this;
        }
    }

    /**
     * Builder for endpoint producers for the Azure Storage Blob Service
     * component.
     */
    public interface BlobEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default AdvancedBlobEndpointProducerBuilder advanced() {
            return (AdvancedBlobEndpointProducerBuilder) this;
        }
        /**
         * The blob name, to consume specific blob from a container. However, on
         * producer it is only required for the operations on the blob level.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param blobName the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobName(String blobName) {
            doSetProperty("blobName", blobName);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobOffset(long blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobOffset(String blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param blobServiceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobServiceClient(
                com.azure.storage.blob.BlobServiceClient blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param blobServiceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobServiceClient(
                String blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobType(
                org.apache.camel.component.azure.storage.blob.BlobType blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobType(String blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder closeStreamAfterRead(
                boolean closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder closeStreamAfterRead(
                String closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder credentials(
                com.azure.storage.common.StorageSharedKeyCredential credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.CredentialType&lt;/code&gt; type.
         * 
         * Default: AZURE_IDENTITY
         * Group: common
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder credentialType(
                org.apache.camel.component.azure.storage.blob.CredentialType credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.CredentialType&lt;/code&gt; type.
         * 
         * Default: AZURE_IDENTITY
         * Group: common
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder credentialType(String credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder dataCount(Long dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder dataCount(String dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * The file directory where the downloaded blobs will be saved to, this
         * can be used in both, producer and consumer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileDir the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder fileDir(String fileDir) {
            doSetProperty("fileDir", fileDir);
            return this;
        }
        /**
         * Specifies the maximum number of blobs to return, including all
         * BlobPrefix elements. If the request does not specify
         * maxResultsPerPage or specifies a value greater than 5,000, the server
         * will return up to 5,000 items.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResultsPerPage the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder maxResultsPerPage(
                Integer maxResultsPerPage) {
            doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }
        /**
         * Specifies the maximum number of blobs to return, including all
         * BlobPrefix elements. If the request does not specify
         * maxResultsPerPage or specifies a value greater than 5,000, the server
         * will return up to 5,000 items.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResultsPerPage the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder maxResultsPerPage(
                String maxResultsPerPage) {
            doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder maxRetryRequests(
                int maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder maxRetryRequests(
                String maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Filters the results to return only blobs whose names begin with the
         * specified prefix. May be null to return all blobs.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder prefix(String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * Filters the results to return only blobs whose names match the
         * specified regular expression. May be null to return all if both
         * prefix and regex are set, regex takes the priority and prefix is
         * ignored.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param regex the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder regex(String regex) {
            doSetProperty("regex", regex);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * BlobServiceClient#getBlobContainerClient(String), and operations on a
         * blob are available on BlobClient through
         * BlobContainerClient#getBlobClient(String).
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder serviceClient(
                com.azure.storage.blob.BlobServiceClient serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * BlobServiceClient#getBlobContainerClient(String), and operations on a
         * blob are available on BlobClient through
         * BlobContainerClient#getBlobClient(String).
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder serviceClient(String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * An optional timeout value beyond which a RuntimeException will be
         * raised.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder timeout(java.time.Duration timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * An optional timeout value beyond which a RuntimeException will be
         * raised.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * A user-controlled value that you can use to track requests. The value
         * of the sequence number must be between 0 and 263 - 1.The default
         * value is 0.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: producer
         * 
         * @param blobSequenceNumber the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobSequenceNumber(
                Long blobSequenceNumber) {
            doSetProperty("blobSequenceNumber", blobSequenceNumber);
            return this;
        }
        /**
         * A user-controlled value that you can use to track requests. The value
         * of the sequence number must be between 0 and 263 - 1.The default
         * value is 0.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: producer
         * 
         * @param blobSequenceNumber the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blobSequenceNumber(
                String blobSequenceNumber) {
            doSetProperty("blobSequenceNumber", blobSequenceNumber);
            return this;
        }
        /**
         * Specifies which type of blocks to return.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.blob.models.BlockListType&lt;/code&gt;
         * type.
         * 
         * Default: COMMITTED
         * Group: producer
         * 
         * @param blockListType the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blockListType(
                com.azure.storage.blob.models.BlockListType blockListType) {
            doSetProperty("blockListType", blockListType);
            return this;
        }
        /**
         * Specifies which type of blocks to return.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.blob.models.BlockListType&lt;/code&gt;
         * type.
         * 
         * Default: COMMITTED
         * Group: producer
         * 
         * @param blockListType the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder blockListType(String blockListType) {
            doSetProperty("blockListType", blockListType);
            return this;
        }
        /**
         * When using getChangeFeed producer operation, this gives additional
         * context that is passed through the Http pipeline during the service
         * call.
         * 
         * The option is a: &lt;code&gt;com.azure.core.util.Context&lt;/code&gt;
         * type.
         * 
         * Group: producer
         * 
         * @param changeFeedContext the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder changeFeedContext(
                com.azure.core.util.Context changeFeedContext) {
            doSetProperty("changeFeedContext", changeFeedContext);
            return this;
        }
        /**
         * When using getChangeFeed producer operation, this gives additional
         * context that is passed through the Http pipeline during the service
         * call.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.core.util.Context&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param changeFeedContext the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder changeFeedContext(
                String changeFeedContext) {
            doSetProperty("changeFeedContext", changeFeedContext);
            return this;
        }
        /**
         * When using getChangeFeed producer operation, this filters the results
         * to return events approximately before the end time. Note: A few
         * events belonging to the next hour can also be returned. A few events
         * belonging to this hour can be missing; to ensure all events from the
         * hour are returned, round the end time up by an hour.
         * 
         * The option is a: &lt;code&gt;java.time.OffsetDateTime&lt;/code&gt;
         * type.
         * 
         * Group: producer
         * 
         * @param changeFeedEndTime the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder changeFeedEndTime(
                java.time.OffsetDateTime changeFeedEndTime) {
            doSetProperty("changeFeedEndTime", changeFeedEndTime);
            return this;
        }
        /**
         * When using getChangeFeed producer operation, this filters the results
         * to return events approximately before the end time. Note: A few
         * events belonging to the next hour can also be returned. A few events
         * belonging to this hour can be missing; to ensure all events from the
         * hour are returned, round the end time up by an hour.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.OffsetDateTime&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param changeFeedEndTime the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder changeFeedEndTime(
                String changeFeedEndTime) {
            doSetProperty("changeFeedEndTime", changeFeedEndTime);
            return this;
        }
        /**
         * When using getChangeFeed producer operation, this filters the results
         * to return events approximately after the start time. Note: A few
         * events belonging to the previous hour can also be returned. A few
         * events belonging to this hour can be missing; to ensure all events
         * from the hour are returned, round the start time down by an hour.
         * 
         * The option is a: &lt;code&gt;java.time.OffsetDateTime&lt;/code&gt;
         * type.
         * 
         * Group: producer
         * 
         * @param changeFeedStartTime the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder changeFeedStartTime(
                java.time.OffsetDateTime changeFeedStartTime) {
            doSetProperty("changeFeedStartTime", changeFeedStartTime);
            return this;
        }
        /**
         * When using getChangeFeed producer operation, this filters the results
         * to return events approximately after the start time. Note: A few
         * events belonging to the previous hour can also be returned. A few
         * events belonging to this hour can be missing; to ensure all events
         * from the hour are returned, round the start time down by an hour.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.OffsetDateTime&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param changeFeedStartTime the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder changeFeedStartTime(
                String changeFeedStartTime) {
            doSetProperty("changeFeedStartTime", changeFeedStartTime);
            return this;
        }
        /**
         * Close the stream after write or keep it open, default is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param closeStreamAfterWrite the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder closeStreamAfterWrite(
                boolean closeStreamAfterWrite) {
            doSetProperty("closeStreamAfterWrite", closeStreamAfterWrite);
            return this;
        }
        /**
         * Close the stream after write or keep it open, default is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param closeStreamAfterWrite the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder closeStreamAfterWrite(
                String closeStreamAfterWrite) {
            doSetProperty("closeStreamAfterWrite", closeStreamAfterWrite);
            return this;
        }
        /**
         * When is set to true, the staged blocks will not be committed
         * directly.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param commitBlockListLater the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder commitBlockListLater(
                boolean commitBlockListLater) {
            doSetProperty("commitBlockListLater", commitBlockListLater);
            return this;
        }
        /**
         * When is set to true, the staged blocks will not be committed
         * directly.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param commitBlockListLater the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder commitBlockListLater(
                String commitBlockListLater) {
            doSetProperty("commitBlockListLater", commitBlockListLater);
            return this;
        }
        /**
         * When is set to true, the append blocks will be created when
         * committing append blocks.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param createAppendBlob the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder createAppendBlob(
                boolean createAppendBlob) {
            doSetProperty("createAppendBlob", createAppendBlob);
            return this;
        }
        /**
         * When is set to true, the append blocks will be created when
         * committing append blocks.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param createAppendBlob the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder createAppendBlob(
                String createAppendBlob) {
            doSetProperty("createAppendBlob", createAppendBlob);
            return this;
        }
        /**
         * When is set to true, the page blob will be created when uploading
         * page blob.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param createPageBlob the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder createPageBlob(
                boolean createPageBlob) {
            doSetProperty("createPageBlob", createPageBlob);
            return this;
        }
        /**
         * When is set to true, the page blob will be created when uploading
         * page blob.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: producer
         * 
         * @param createPageBlob the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder createPageBlob(String createPageBlob) {
            doSetProperty("createPageBlob", createPageBlob);
            return this;
        }
        /**
         * Override the default expiration (millis) of URL download link.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param downloadLinkExpiration the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder downloadLinkExpiration(
                Long downloadLinkExpiration) {
            doSetProperty("downloadLinkExpiration", downloadLinkExpiration);
            return this;
        }
        /**
         * Override the default expiration (millis) of URL download link.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: producer
         * 
         * @param downloadLinkExpiration the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder downloadLinkExpiration(
                String downloadLinkExpiration) {
            doSetProperty("downloadLinkExpiration", downloadLinkExpiration);
            return this;
        }
        /**
         * The blob operation that can be used with this component on the
         * producer.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition&lt;/code&gt; type.
         * 
         * Default: listBlobContainers
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder operation(
                org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * The blob operation that can be used with this component on the
         * producer.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition&lt;/code&gt; type.
         * 
         * Default: listBlobContainers
         * Group: producer
         * 
         * @param operation the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder operation(String operation) {
            doSetProperty("operation", operation);
            return this;
        }
        /**
         * Specifies the maximum size for the page blob, up to 8 TB. The page
         * blob size must be aligned to a 512-byte boundary.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 512
         * Group: producer
         * 
         * @param pageBlobSize the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder pageBlobSize(Long pageBlobSize) {
            doSetProperty("pageBlobSize", pageBlobSize);
            return this;
        }
        /**
         * Specifies the maximum size for the page blob, up to 8 TB. The page
         * blob size must be aligned to a 512-byte boundary.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Default: 512
         * Group: producer
         * 
         * @param pageBlobSize the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder pageBlobSize(String pageBlobSize) {
            doSetProperty("pageBlobSize", pageBlobSize);
            return this;
        }
        /**
         * Access key for the associated azure account name to be used for
         * authentication with azure blob services.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Source Blob Access Key: for copyblob operation, sadly, we need to
         * have an accessKey for the source blob we want to copy Passing an
         * accessKey as header, it's unsafe so we could set as key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sourceBlobAccessKey the value to set
         * @return the dsl builder
         */
        default BlobEndpointProducerBuilder sourceBlobAccessKey(
                String sourceBlobAccessKey) {
            doSetProperty("sourceBlobAccessKey", sourceBlobAccessKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint producers for the Azure Storage Blob
     * Service component.
     */
    public interface AdvancedBlobEndpointProducerBuilder
            extends
                EndpointProducerBuilder {
        default BlobEndpointProducerBuilder basic() {
            return (BlobEndpointProducerBuilder) this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedBlobEndpointProducerBuilder lazyStartProducer(
                boolean lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
        /**
         * Whether the producer should be started lazy (on the first message).
         * By starting lazy you can use this to allow CamelContext and routes to
         * startup in situations where a producer may otherwise fail during
         * starting and cause the route to fail being started. By deferring this
         * startup to be lazy then the startup failure can be handled during
         * routing messages via Camel's routing error handlers. Beware that when
         * the first message is processed then creating and starting the
         * producer may take a little time and prolong the total processing time
         * of the processing.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: false
         * Group: producer (advanced)
         * 
         * @param lazyStartProducer the value to set
         * @return the dsl builder
         */
        default AdvancedBlobEndpointProducerBuilder lazyStartProducer(
                String lazyStartProducer) {
            doSetProperty("lazyStartProducer", lazyStartProducer);
            return this;
        }
    }

    /**
     * Builder for endpoint for the Azure Storage Blob Service component.
     */
    public interface BlobEndpointBuilder
            extends
                BlobEndpointConsumerBuilder,
                BlobEndpointProducerBuilder {
        default AdvancedBlobEndpointBuilder advanced() {
            return (AdvancedBlobEndpointBuilder) this;
        }
        /**
         * The blob name, to consume specific blob from a container. However, on
         * producer it is only required for the operations on the blob level.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param blobName the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder blobName(String blobName) {
            doSetProperty("blobName", blobName);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option is a: &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder blobOffset(long blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Set the blob offset for the upload or download operations, default is
         * 0.
         * 
         * The option will be converted to a &lt;code&gt;long&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param blobOffset the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder blobOffset(String blobOffset) {
            doSetProperty("blobOffset", blobOffset);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param blobServiceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder blobServiceClient(
                com.azure.storage.blob.BlobServiceClient blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * getBlobContainerClient(String), and operations on a blob are
         * available on BlobClient through
         * getBlobContainerClient(String).getBlobClient(String).
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param blobServiceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder blobServiceClient(String blobServiceClient) {
            doSetProperty("blobServiceClient", blobServiceClient);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder blobType(
                org.apache.camel.component.azure.storage.blob.BlobType blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * The blob type in order to initiate the appropriate settings for each
         * blob type.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.BlobType&lt;/code&gt; type.
         * 
         * Default: blockblob
         * Group: common
         * 
         * @param blobType the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder blobType(String blobType) {
            doSetProperty("blobType", blobType);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option is a: &lt;code&gt;boolean&lt;/code&gt; type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder closeStreamAfterRead(
                boolean closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * Close the stream after read or keep it open, default is true.
         * 
         * The option will be converted to a &lt;code&gt;boolean&lt;/code&gt;
         * type.
         * 
         * Default: true
         * Group: common
         * 
         * @param closeStreamAfterRead the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder closeStreamAfterRead(
                String closeStreamAfterRead) {
            doSetProperty("closeStreamAfterRead", closeStreamAfterRead);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder credentials(
                com.azure.storage.common.StorageSharedKeyCredential credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * StorageSharedKeyCredential can be injected to create the azure
         * client, this holds the important authentication information.
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.common.StorageSharedKeyCredential&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param credentials the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder credentials(String credentials) {
            doSetProperty("credentials", credentials);
            return this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option is a:
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.CredentialType&lt;/code&gt; type.
         * 
         * Default: AZURE_IDENTITY
         * Group: common
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder credentialType(
                org.apache.camel.component.azure.storage.blob.CredentialType credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * Determines the credential strategy to adopt.
         * 
         * The option will be converted to a
         * &lt;code&gt;org.apache.camel.component.azure.storage.blob.CredentialType&lt;/code&gt; type.
         * 
         * Default: AZURE_IDENTITY
         * Group: common
         * 
         * @param credentialType the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder credentialType(String credentialType) {
            doSetProperty("credentialType", credentialType);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option is a: &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder dataCount(Long dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * How many bytes to include in the range. Must be greater than or equal
         * to 0 if specified.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Long&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param dataCount the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder dataCount(String dataCount) {
            doSetProperty("dataCount", dataCount);
            return this;
        }
        /**
         * The file directory where the downloaded blobs will be saved to, this
         * can be used in both, producer and consumer.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param fileDir the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder fileDir(String fileDir) {
            doSetProperty("fileDir", fileDir);
            return this;
        }
        /**
         * Specifies the maximum number of blobs to return, including all
         * BlobPrefix elements. If the request does not specify
         * maxResultsPerPage or specifies a value greater than 5,000, the server
         * will return up to 5,000 items.
         * 
         * The option is a: &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResultsPerPage the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder maxResultsPerPage(Integer maxResultsPerPage) {
            doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }
        /**
         * Specifies the maximum number of blobs to return, including all
         * BlobPrefix elements. If the request does not specify
         * maxResultsPerPage or specifies a value greater than 5,000, the server
         * will return up to 5,000 items.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.lang.Integer&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param maxResultsPerPage the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder maxResultsPerPage(String maxResultsPerPage) {
            doSetProperty("maxResultsPerPage", maxResultsPerPage);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option is a: &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder maxRetryRequests(int maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Specifies the maximum number of additional HTTP Get requests that
         * will be made while reading the data from a response body.
         * 
         * The option will be converted to a &lt;code&gt;int&lt;/code&gt; type.
         * 
         * Default: 0
         * Group: common
         * 
         * @param maxRetryRequests the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder maxRetryRequests(String maxRetryRequests) {
            doSetProperty("maxRetryRequests", maxRetryRequests);
            return this;
        }
        /**
         * Filters the results to return only blobs whose names begin with the
         * specified prefix. May be null to return all blobs.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param prefix the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder prefix(String prefix) {
            doSetProperty("prefix", prefix);
            return this;
        }
        /**
         * Filters the results to return only blobs whose names match the
         * specified regular expression. May be null to return all if both
         * prefix and regex are set, regex takes the priority and prefix is
         * ignored.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param regex the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder regex(String regex) {
            doSetProperty("regex", regex);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * BlobServiceClient#getBlobContainerClient(String), and operations on a
         * blob are available on BlobClient through
         * BlobContainerClient#getBlobClient(String).
         * 
         * The option is a:
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder serviceClient(
                com.azure.storage.blob.BlobServiceClient serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * Client to a storage account. This client does not hold any state
         * about a particular storage account but is instead a convenient way of
         * sending off appropriate requests to the resource on the service. It
         * may also be used to construct URLs to blobs and containers. This
         * client contains operations on a service account. Operations on a
         * container are available on BlobContainerClient through
         * BlobServiceClient#getBlobContainerClient(String), and operations on a
         * blob are available on BlobClient through
         * BlobContainerClient#getBlobClient(String).
         * 
         * The option will be converted to a
         * &lt;code&gt;com.azure.storage.blob.BlobServiceClient&lt;/code&gt;
         * type.
         * 
         * Group: common
         * 
         * @param serviceClient the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder serviceClient(String serviceClient) {
            doSetProperty("serviceClient", serviceClient);
            return this;
        }
        /**
         * An optional timeout value beyond which a RuntimeException will be
         * raised.
         * 
         * The option is a: &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder timeout(java.time.Duration timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * An optional timeout value beyond which a RuntimeException will be
         * raised.
         * 
         * The option will be converted to a
         * &lt;code&gt;java.time.Duration&lt;/code&gt; type.
         * 
         * Group: common
         * 
         * @param timeout the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder timeout(String timeout) {
            doSetProperty("timeout", timeout);
            return this;
        }
        /**
         * Access key for the associated azure account name to be used for
         * authentication with azure blob services.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param accessKey the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder accessKey(String accessKey) {
            doSetProperty("accessKey", accessKey);
            return this;
        }
        /**
         * Source Blob Access Key: for copyblob operation, sadly, we need to
         * have an accessKey for the source blob we want to copy Passing an
         * accessKey as header, it's unsafe so we could set as key.
         * 
         * The option is a: &lt;code&gt;java.lang.String&lt;/code&gt; type.
         * 
         * Group: security
         * 
         * @param sourceBlobAccessKey the value to set
         * @return the dsl builder
         */
        default BlobEndpointBuilder sourceBlobAccessKey(
                String sourceBlobAccessKey) {
            doSetProperty("sourceBlobAccessKey", sourceBlobAccessKey);
            return this;
        }
    }

    /**
     * Advanced builder for endpoint for the Azure Storage Blob Service
     * component.
     */
    public interface AdvancedBlobEndpointBuilder
            extends
                AdvancedBlobEndpointConsumerBuilder,
                AdvancedBlobEndpointProducerBuilder {
        default BlobEndpointBuilder basic() {
            return (BlobEndpointBuilder) this;
        }
    }

    public interface BlobBuilders {
        /**
         * Azure Storage Blob Service (camel-azure-storage-blob)
         * Store and retrieve blobs from Azure Storage Blob Service.
         * 
         * Category: cloud,file
         * Since: 3.3
         * Maven coordinates: org.apache.camel:camel-azure-storage-blob
         * 
         * @return the dsl builder for the headers' name.
         */
        default BlobHeaderNameBuilder azureStorageBlob() {
            return BlobHeaderNameBuilder.INSTANCE;
        }
        /**
         * Azure Storage Blob Service (camel-azure-storage-blob)
         * Store and retrieve blobs from Azure Storage Blob Service.
         * 
         * Category: cloud,file
         * Since: 3.3
         * Maven coordinates: org.apache.camel:camel-azure-storage-blob
         * 
         * Syntax: <code>azure-storage-blob:accountName/containerName</code>
         * 
         * Path parameter: accountName
         * Azure account name to be used for authentication with azure blob
         * services
         * 
         * Path parameter: containerName
         * The blob container name
         * 
         * @param path accountName/containerName
         * @return the dsl builder
         */
        default BlobEndpointBuilder azureStorageBlob(String path) {
            return BlobEndpointBuilderFactory.endpointBuilder("azure-storage-blob", path);
        }
        /**
         * Azure Storage Blob Service (camel-azure-storage-blob)
         * Store and retrieve blobs from Azure Storage Blob Service.
         * 
         * Category: cloud,file
         * Since: 3.3
         * Maven coordinates: org.apache.camel:camel-azure-storage-blob
         * 
         * Syntax: <code>azure-storage-blob:accountName/containerName</code>
         * 
         * Path parameter: accountName
         * Azure account name to be used for authentication with azure blob
         * services
         * 
         * Path parameter: containerName
         * The blob container name
         * 
         * @param componentName to use a custom component name for the endpoint
         * instead of the default name
         * @param path accountName/containerName
         * @return the dsl builder
         */
        default BlobEndpointBuilder azureStorageBlob(
                String componentName,
                String path) {
            return BlobEndpointBuilderFactory.endpointBuilder(componentName, path);
        }
    }

    /**
     * The builder of headers' name for the Azure Storage Blob Service
     * component.
     */
    public static class BlobHeaderNameBuilder {
        /**
         * The internal instance of the builder used to access to all the
         * methods representing the name of headers.
         */
        private static final BlobHeaderNameBuilder INSTANCE = new BlobHeaderNameBuilder();

        /**
         * (All) Specify the producer operation to execute, please see the doc
         * on this page related to producer operation.
         * 
         * The option is a: {@code
         * org.apache.camel.component.azure.storage.blob.BlobOperationsDefinition} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageBlobOperation}.
         */
        public String azureStorageBlobOperation() {
            return "AzureStorageBlobOperation";
        }

        /**
         * (uploadBlockBlob, commitBlobBlockList, createAppendBlob,
         * createPageBlob) Additional parameters for a set of operations.
         * 
         * The option is a: {@code BlobHttpHeaders} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageBlobHttpHeaders}.
         */
        public String azureStorageBlobHttpHeaders() {
            return "AzureStorageBlobHttpHeaders";
        }

        /**
         * The E Tag of the blob.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobETag}.
         */
        public String azureStorageBlobETag() {
            return "AzureStorageBlobETag";
        }

        /**
         * Creation time of the blob.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobCreationTime}.
         */
        public String azureStorageBlobCreationTime() {
            return "AzureStorageBlobCreationTime";
        }

        /**
         * Datetime when the blob was last modified.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobLastModified}.
         */
        public String azureStorageBlobLastModified() {
            return "AzureStorageBlobLastModified";
        }

        /**
         * Content type specified for the blob.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobContentType}.
         */
        public String azureStorageBlobContentType() {
            return "AzureStorageBlobContentType";
        }

        /**
         * (producer) (Most operations related to upload blob) Most operations
         * related to upload blobAn MD5 hash of the block content. This hash is
         * used to verify the integrity of the block during transport. When this
         * header is specified, the storage service compares the hash of the
         * content that has arrived with this header value. Note that this MD5
         * hash is not stored with the blob. If the two hashes do not match, the
         * operation will fail. (consumer) Content MD5 specified for the blob.
         * 
         * The option is a: {@code byte[]} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AzureStorageBlobContentMD5}.
         */
        public String azureStorageBlobContentMD5() {
            return "AzureStorageBlobContentMD5";
        }

        /**
         * Content encoding specified for the blob.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobContentEncoding}.
         */
        public String azureStorageBlobContentEncoding() {
            return "AzureStorageBlobContentEncoding";
        }

        /**
         * Content disposition specified for the blob.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobContentDisposition}.
         */
        public String azureStorageBlobContentDisposition() {
            return "AzureStorageBlobContentDisposition";
        }

        /**
         * Content language specified for the blob.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobContentLanguage}.
         */
        public String azureStorageBlobContentLanguage() {
            return "AzureStorageBlobContentLanguage";
        }

        /**
         * Cache control specified for the blob.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobCacheControl}.
         */
        public String azureStorageBlobCacheControl() {
            return "AzureStorageBlobCacheControl";
        }

        /**
         * The size of the blob.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobBlobSize}.
         */
        public String azureStorageBlobBlobSize() {
            return "AzureStorageBlobBlobSize";
        }

        /**
         * When uploading a blob with the uploadBlockBlob-operation this can be
         * used to tell the client what the length of an InputStream is.
         * 
         * The option is a: {@code long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobBlobUploadSize}.
         */
        public String azureStorageBlobBlobUploadSize() {
            return "AzureStorageBlobBlobUploadSize";
        }

        /**
         * (producer) (createPageBlob) A user-controlled value that you can use
         * to track requests. The value of the sequence number must be between 0
         * and 263 - 1. The default value is 0. (consumer) The current sequence
         * number for a page blob.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code
         * AzureStorageBlobSequenceNumber}.
         */
        public String azureStorageBlobSequenceNumber() {
            return "AzureStorageBlobSequenceNumber";
        }

        /**
         * The type of the blob.
         * 
         * The option is a: {@code
         * org.apache.camel.component.azure.storage.blob.BlobType} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobBlobType}.
         */
        public String azureStorageBlobBlobType() {
            return "AzureStorageBlobBlobType";
        }

        /**
         * Status of the lease on the blob.
         * 
         * The option is a: {@code
         * com.azure.storage.blob.models.LeaseStatusType} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobLeaseStatus}.
         */
        public String azureStorageBlobLeaseStatus() {
            return "AzureStorageBlobLeaseStatus";
        }

        /**
         * State of the lease on the blob.
         * 
         * The option is a: {@code com.azure.storage.blob.models.LeaseStateType}
         * type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobLeaseState}.
         */
        public String azureStorageBlobLeaseState() {
            return "AzureStorageBlobLeaseState";
        }

        /**
         * Type of lease on the blob.
         * 
         * The option is a: {@code
         * com.azure.storage.blob.models.LeaseDurationType} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobLeaseDuration}.
         */
        public String azureStorageBlobLeaseDuration() {
            return "AzureStorageBlobLeaseDuration";
        }

        /**
         * Identifier of the last copy operation performed on the blob.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobCopyId}.
         */
        public String azureStorageBlobCopyId() {
            return "AzureStorageBlobCopyId";
        }

        /**
         * Status of the last copy operation performed on the blob.
         * 
         * The option is a: {@code com.azure.storage.blob.models.CopyStatusType}
         * type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobCopyStatus}.
         */
        public String azureStorageBlobCopyStatus() {
            return "AzureStorageBlobCopyStatus";
        }

        /**
         * Source of the last copy operation performed on the blob.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobCopySource}.
         */
        public String azureStorageBlobCopySource() {
            return "AzureStorageBlobCopySource";
        }

        /**
         * Progress of the last copy operation performed on the blob.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobCopyProgress}.
         */
        public String azureStorageBlobCopyProgress() {
            return "AzureStorageBlobCopyProgress";
        }

        /**
         * Datetime when the last copy operation on the blob completed.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobCopyCompletionTime}.
         */
        public String azureStorageBlobCopyCompletionTime() {
            return "AzureStorageBlobCopyCompletionTime";
        }

        /**
         * Description of the last copy operation on the blob.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobCopyStatusDescription}.
         */
        public String azureStorageBlobCopyStatusDescription() {
            return "AzureStorageBlobCopyStatusDescription";
        }

        /**
         * Snapshot identifier of the last incremental copy snapshot for the
         * blob.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobCopyDestinationSnapshot}.
         */
        public String azureStorageBlobCopyDestinationSnapshot() {
            return "AzureStorageBlobCopyDestinationSnapshot";
        }

        /**
         * Flag indicating if the blob's content is encrypted on the server.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobIsServerEncrypted}.
         */
        public String azureStorageBlobIsServerEncrypted() {
            return "AzureStorageBlobIsServerEncrypted";
        }

        /**
         * Flag indicating if the blob was incrementally copied.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobIsIncrementalCopy}.
         */
        public String azureStorageBlobIsIncrementalCopy() {
            return "AzureStorageBlobIsIncrementalCopy";
        }

        /**
         * (producer) (uploadBlockBlob, commitBlobBlockList) Defines values for
         * AccessTier. (consumer) Access tier of the blob.
         * 
         * The option is a: {@code AccessTier} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AzureStorageBlobAccessTier}.
         */
        public String azureStorageBlobAccessTier() {
            return "AzureStorageBlobAccessTier";
        }

        /**
         * Flag indicating if the access tier of the blob was inferred from
         * properties of the blob.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobIsAccessTierInferred}.
         */
        public String azureStorageBlobIsAccessTierInferred() {
            return "AzureStorageBlobIsAccessTierInferred";
        }

        /**
         * Archive status of the blob.
         * 
         * The option is a: {@code ArchiveStatus} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobArchiveStatus}.
         */
        public String azureStorageBlobArchiveStatus() {
            return "AzureStorageBlobArchiveStatus";
        }

        /**
         * Datetime when the access tier of the blob last changed.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobaccessTierChangeTime}.
         */
        public String azureStorageBlobaccessTierChangeTime() {
            return "AzureStorageBlobaccessTierChangeTime";
        }

        /**
         * (producer) (Operations related to container and blob) Operations
         * related to container and blob Metadata to associate with the
         * container or blob. (consumer) Additional metadata associated with the
         * blob.
         * 
         * The option is a: {@code Map<String,String>} type.
         * 
         * Group: common
         * 
         * @return the name of the header {@code AzureStorageBlobMetadata}.
         */
        public String azureStorageBlobMetadata() {
            return "AzureStorageBlobMetadata";
        }

        /**
         * Number of blocks committed to an append blob.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobCommittedBlockCount}.
         */
        public String azureStorageBlobCommittedBlockCount() {
            return "AzureStorageBlobCommittedBlockCount";
        }

        /**
         * The offset at which the block was committed to the block blob.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobAppendOffset}.
         */
        public String azureStorageBlobAppendOffset() {
            return "AzureStorageBlobAppendOffset";
        }

        /**
         * Returns non-parsed httpHeaders that can be used by the user.
         * 
         * The option is a: {@code HttpHeaders} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobRawHttpHeaders}.
         */
        public String azureStorageBlobRawHttpHeaders() {
            return "AzureStorageBlobRawHttpHeaders";
        }

        /**
         * The downloaded filename from the operation downloadBlobToFile.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobFileName}.
         */
        public String azureStorageBlobFileName() {
            return "AzureStorageBlobFileName";
        }

        /**
         * The download link generated by downloadLink operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: consumer
         * 
         * @return the name of the header {@code AzureStorageBlobDownloadLink}.
         */
        public String azureStorageBlobDownloadLink() {
            return "AzureStorageBlobDownloadLink";
        }

        /**
         * (listBlobs) Defines options available to configure the behavior of a
         * call to listBlobsFlatSegment on a BlobContainerClient object.
         * 
         * The option is a: {@code ListBlobsOptions} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobListBlobOptions}.
         */
        public String azureStorageBlobListBlobOptions() {
            return "AzureStorageBlobListBlobOptions";
        }

        /**
         * (listBlobs) The details for listing specific blobs.
         * 
         * The option is a: {@code BlobListDetails} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageBlobListDetails}.
         */
        public String azureStorageBlobListDetails() {
            return "AzureStorageBlobListDetails";
        }

        /**
         * (listBlobs,getBlob) Filters the results to return only blobs whose
         * names begin with the specified prefix. May be null to return all
         * blobs.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageBlobPrefix}.
         */
        public String azureStorageBlobPrefix() {
            return "AzureStorageBlobPrefix";
        }

        /**
         * (listBlobs,getBlob) Filters the results to return only blobs whose
         * names match the specified regular expression. May be null to return
         * all. If both prefix and regex are set, regex takes the priority and
         * prefix is ignored.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageBlobRegex}.
         */
        public String azureStorageBlobRegex() {
            return "AzureStorageBlobRegex";
        }

        /**
         * (listBlobs) Specifies the maximum number of blobs to return,
         * including all BlobPrefix elements. If the request does not specify
         * maxResultsPerPage or specifies a value greater than 5,000, the server
         * will return up to 5,000 items.
         * 
         * The option is a: {@code Integer} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobMaxResultsPerPage}.
         */
        public String azureStorageBlobMaxResultsPerPage() {
            return "AzureStorageBlobMaxResultsPerPage";
        }

        /**
         * (All) An optional timeout value beyond which a RuntimeException will
         * be raised.
         * 
         * The option is a: {@code Duration} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageBlobTimeout}.
         */
        public String azureStorageBlobTimeout() {
            return "AzureStorageBlobTimeout";
        }

        /**
         * (createContainer) Specifies how the data in this container is
         * available to the public. Pass null for no public access.
         * 
         * The option is a: {@code PublicAccessType} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobPublicAccessType}.
         */
        public String azureStorageBlobPublicAccessType() {
            return "AzureStorageBlobPublicAccessType";
        }

        /**
         * (Operations related to container and blob) This contains values which
         * will restrict the successful operation of a variety of requests to
         * the conditions present. These conditions are entirely optional.
         * 
         * The option is a: {@code BlobRequestConditions} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobRequestCondition}.
         */
        public String azureStorageBlobRequestCondition() {
            return "AzureStorageBlobRequestCondition";
        }

        /**
         * (Operations related to container and blob) Override/set the container
         * name on the exchange headers.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobBlobContainerName}.
         */
        public String azureStorageBlobBlobContainerName() {
            return "AzureStorageBlobBlobContainerName";
        }

        /**
         * (Operations related to blob) Override/set the blob name on the
         * exchange headers.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageBlobBlobName}.
         */
        public String azureStorageBlobBlobName() {
            return "AzureStorageBlobBlobName";
        }

        /**
         * (downloadBlobToFile) The file directory where the downloaded blobs
         * will be saved to.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageBlobFileDir}.
         */
        public String azureStorageBlobFileDir() {
            return "AzureStorageBlobFileDir";
        }

        /**
         * (Operations related to page blob) A PageRange object. Given that
         * pages must be aligned with 512-byte boundaries, the start offset must
         * be a modulus of 512 and the end offset must be a modulus of 512 - 1.
         * Examples of valid byte ranges are 0-511, 512-1023, etc.
         * 
         * The option is a: {@code PageRange} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageBlobPageBlobRange}.
         */
        public String azureStorageBlobPageBlobRange() {
            return "AzureStorageBlobPageBlobRange";
        }

        /**
         * (createPageBlob, resizePageBlob) Specifies the maximum size for the
         * page blob, up to 8 TB. The page blob size must be aligned to a
         * 512-byte boundary.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageBlobPageBlobSize}.
         */
        public String azureStorageBlobPageBlobSize() {
            return "AzureStorageBlobPageBlobSize";
        }

        /**
         * (stageBlockBlobList) When is set to true, the staged blocks will not
         * be committed directly.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobCommitBlobBlockListLater}.
         */
        public String azureStorageBlobCommitBlobBlockListLater() {
            return "AzureStorageBlobCommitBlobBlockListLater";
        }

        /**
         * (getBlobBlockList) Specifies which type of blocks to return.
         * 
         * The option is a: {@code com.azure.storage.blob.models.BlockListType}
         * type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageBlobBlockListType}.
         */
        public String azureStorageBlobBlockListType() {
            return "AzureStorageBlobBlockListType";
        }

        /**
         * (commitAppendBlob) When is set to true, the append blocks will be
         * created when committing append blocks.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobCreateAppendBlob}.
         */
        public String azureStorageBlobCreateAppendBlob() {
            return "AzureStorageBlobCreateAppendBlob";
        }

        /**
         * (uploadPageBlob) When is set to true, the page blob will be created
         * when uploading page blob.
         * 
         * The option is a: {@code boolean} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobCreatePageBlob}.
         */
        public String azureStorageBlobCreatePageBlob() {
            return "AzureStorageBlobCreatePageBlob";
        }

        /**
         * (deleteBlob) Specifies the behavior for deleting the snapshots on
         * this blob. Include will delete the base blob and all snapshots. Only
         * will delete only the snapshots. If a snapshot is being deleted, you
         * must pass null.
         * 
         * The option is a: {@code
         * com.azure.storage.blob.models.DeleteSnapshotsOptionType} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobDeleteSnapshotsOptionType}.
         */
        public String azureStorageBlobDeleteSnapshotsOptionType() {
            return "AzureStorageBlobDeleteSnapshotsOptionType";
        }

        /**
         * (listBlobContainers) A ListBlobContainersOptions which specifies what
         * data should be returned by the service.
         * 
         * The option is a: {@code ListBlobContainersOptions} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobListBlobContainersOptions}.
         */
        public String azureStorageBlobListBlobContainersOptions() {
            return "AzureStorageBlobListBlobContainersOptions";
        }

        /**
         * (downloadBlobToFile) ParallelTransferOptions to use to download to
         * file. Number of parallel transfers parameter is ignored.
         * 
         * The option is a: {@code ParallelTransferOptions} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobParallelTransferOptions}.
         */
        public String azureStorageBlobParallelTransferOptions() {
            return "AzureStorageBlobParallelTransferOptions";
        }

        /**
         * (downloadLink) Override the default expiration (millis) of URL
         * download link.
         * 
         * The option is a: {@code Long} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobDownloadLinkExpiration}.
         */
        public String azureStorageBlobDownloadLinkExpiration() {
            return "AzureStorageBlobDownloadLinkExpiration";
        }

        /**
         * (copyBlob) The source blob account name to be used as source account
         * name in a copy blob operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobSourceBlobAccountName}.
         */
        public String azureStorageBlobSourceBlobAccountName() {
            return "AzureStorageBlobSourceBlobAccountName";
        }

        /**
         * (copyBlob) The source blob container name to be used as source
         * container name in a copy blob operation.
         * 
         * The option is a: {@code String} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobSourceBlobContainerName}.
         */
        public String azureStorageBlobSourceBlobContainerName() {
            return "AzureStorageBlobSourceBlobContainerName";
        }

        /**
         * (getChangeFeed) It filters the results to return events approximately
         * after the start time. Note: A few events belonging to the previous
         * hour can also be returned. A few events belonging to this hour can be
         * missing; to ensure all events from the hour are returned, round the
         * start time down by an hour.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobChangeFeedStartTime}.
         */
        public String azureStorageBlobChangeFeedStartTime() {
            return "AzureStorageBlobChangeFeedStartTime";
        }

        /**
         * (getChangeFeed) It filters the results to return events approximately
         * before the end time. Note: A few events belonging to the next hour
         * can also be returned. A few events belonging to this hour can be
         * missing; to ensure all events from the hour are returned, round the
         * end time up by an hour.
         * 
         * The option is a: {@code OffsetDateTime} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code
         * AzureStorageBlobChangeFeedEndTime}.
         */
        public String azureStorageBlobChangeFeedEndTime() {
            return "AzureStorageBlobChangeFeedEndTime";
        }

        /**
         * (getChangeFeed) This gives additional context that is passed through
         * the Http pipeline during the service call.
         * 
         * The option is a: {@code Context} type.
         * 
         * Group: producer
         * 
         * @return the name of the header {@code AzureStorageBlobContext}.
         */
        public String azureStorageBlobContext() {
            return "AzureStorageBlobContext";
        }
    }
    static BlobEndpointBuilder endpointBuilder(String componentName, String path) {
        class BlobEndpointBuilderImpl extends AbstractEndpointBuilder implements BlobEndpointBuilder, AdvancedBlobEndpointBuilder {
            public BlobEndpointBuilderImpl(String path) {
                super(componentName, path);
            }
        }
        return new BlobEndpointBuilderImpl(path);
    }
}