/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.web;

import org.apache.catalina.Context;
import org.apache.catalina.Wrapper;
import org.apache.catalina.core.StandardWrapper;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.web.WebExtension;
import org.jboss.as.web.WebSubsystemServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;

public class WebDeploymentServletDefinition
extends SimpleResourceDefinition {
    public static final WebDeploymentServletDefinition INSTANCE = new WebDeploymentServletDefinition();
    protected static final SimpleAttributeDefinition LOAD_TIME = new SimpleAttributeDefinitionBuilder("load-time", ModelType.LONG, true).build();
    protected static final SimpleAttributeDefinition MAX_TIME = new SimpleAttributeDefinitionBuilder("maxTime", ModelType.LONG, true).build();
    protected static final SimpleAttributeDefinition MIN_TIME = new SimpleAttributeDefinitionBuilder("min-time", ModelType.LONG, true).build();
    protected static final SimpleAttributeDefinition PROCESSING_TIME = new SimpleAttributeDefinitionBuilder("processingTime", ModelType.LONG, true).build();
    protected static final SimpleAttributeDefinition REQUEST_COUNT = new SimpleAttributeDefinitionBuilder("requestCount", ModelType.INT, true).build();

    private WebDeploymentServletDefinition() {
        super(PathElement.pathElement((String)"servlet"), (ResourceDescriptionResolver)WebExtension.getResourceDescriptionResolver("deployment.servlet"));
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
        registration.registerMetric((AttributeDefinition)LOAD_TIME, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, StandardWrapper wrapper) {
                response.set(wrapper.getLoadTime());
            }
        });
        registration.registerMetric((AttributeDefinition)MAX_TIME, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, StandardWrapper wrapper) {
                response.set(wrapper.getMinTime());
            }
        });
        registration.registerMetric((AttributeDefinition)MIN_TIME, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, StandardWrapper wrapper) {
                response.set(wrapper.getLoadTime());
            }
        });
        registration.registerMetric((AttributeDefinition)PROCESSING_TIME, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, StandardWrapper wrapper) {
                response.set(wrapper.getProcessingTime());
            }
        });
        registration.registerMetric((AttributeDefinition)REQUEST_COUNT, (OperationStepHandler)new AbstractMetricsHandler(){

            @Override
            void handle(ModelNode response, String name, StandardWrapper wrapper) {
                response.set(wrapper.getRequestCount());
            }
        });
    }

    static abstract class AbstractMetricsHandler
    implements OperationStepHandler {
        AbstractMetricsHandler() {
        }

        abstract void handle(ModelNode var1, String var2, StandardWrapper var3);

        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            final PathAddress address = PathAddress.pathAddress((ModelNode)operation.get("address"));
            Resource web = context.readResourceFromRoot(address.subAddress(0, address.size() - 1), false);
            ModelNode subModel = web.getModel();
            final String host = subModel.require("virtual-host").asString();
            final String path = subModel.require("context-root").asString();
            final ModelNode node = web.requireChild(address.getLastElement()).getModel();
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ServiceController controller = context.getServiceRegistry(false).getService(WebSubsystemServices.deploymentServiceName(host, path));
                    if (controller != null) {
                        String name = node.get("servlet-name").asString();
                        Context webContext = (Context)Context.class.cast(controller.getValue());
                        Wrapper wrapper = (Wrapper)Wrapper.class.cast(webContext.findChild(name));
                        ModelNode response = new ModelNode();
                        AbstractMetricsHandler.this.handle(response, address.getLastElement().getValue(), (StandardWrapper)wrapper);
                        context.getResult().set(response);
                    }
                    context.completeStep();
                }
            }, OperationContext.Stage.RUNTIME);
            context.completeStep();
        }
    }
}

