/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.cache.infinispan.util.AddressAdapter;
import org.infinispan.remoting.transport.Address;

public class AddressAdapterImpl
implements AddressAdapter,
Externalizable {
    private Address address;

    public AddressAdapterImpl() {
    }

    public AddressAdapterImpl(Address address) {
        this.address = address;
    }

    static AddressAdapter newInstance(Address address) {
        return new AddressAdapterImpl(address);
    }

    public static List<AddressAdapter> toAddressAdapter(List<Address> ispnAddresses) {
        ArrayList<AddressAdapter> addresses = new ArrayList<AddressAdapter>(ispnAddresses.size());
        for (Address address : ispnAddresses) {
            addresses.add(AddressAdapterImpl.newInstance(address));
        }
        return addresses;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.address = (Address)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.address);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AddressAdapterImpl)) {
            return false;
        }
        AddressAdapterImpl other = (AddressAdapterImpl)obj;
        return other.address.equals(this.address);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.address.hashCode();
        return result;
    }
}

