/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.config;

import java.util.Collection;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.persistence.metamodel.Metamodel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.data.jpa.mapping.JpaMetamodelMappingContext;
import org.springframework.data.util.StreamUtils;
import org.springframework.lang.Nullable;

class JpaMetamodelMappingContextFactoryBean
extends AbstractFactoryBean<JpaMetamodelMappingContext>
implements ApplicationContextAware {
    private static final Logger LOG = LoggerFactory.getLogger(JpaMetamodelMappingContextFactoryBean.class);
    @Nullable
    private ListableBeanFactory beanFactory;

    JpaMetamodelMappingContextFactoryBean() {
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.beanFactory = applicationContext;
    }

    public Class<?> getObjectType() {
        return JpaMetamodelMappingContext.class;
    }

    protected JpaMetamodelMappingContext createInstance() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Initializing JpaMetamodelMappingContext\u2026");
        }
        JpaMetamodelMappingContext context = new JpaMetamodelMappingContext(this.getMetamodels());
        context.initialize();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished initializing JpaMetamodelMappingContext!");
        }
        return context;
    }

    private Set<Metamodel> getMetamodels() {
        if (this.beanFactory == null) {
            throw new IllegalStateException("BeanFactory must not be null!");
        }
        Collection factories = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, EntityManagerFactory.class).values();
        return (Set)factories.stream().map(EntityManagerFactory::getMetamodel).collect(StreamUtils.toUnmodifiableSet());
    }
}

