/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CallerBlocksPolicy
implements RejectedExecutionHandler {
    private static final Log logger = LogFactory.getLog(CallerBlocksPolicy.class);
    private final long maxWait;

    public CallerBlocksPolicy(long maxWait) {
        this.maxWait = maxWait;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
        if (executor.isShutdown()) throw new RejectedExecutionException("Executor has been shut down");
        try {
            BlockingQueue<Runnable> queue = executor.getQueue();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Attempting to queue task execution for " + this.maxWait + " milliseconds"));
            }
            if (!queue.offer(r, this.maxWait, TimeUnit.MILLISECONDS)) {
                throw new RejectedExecutionException("Max wait time expired to queue task");
            }
            if (!logger.isDebugEnabled()) return;
            logger.debug((Object)"Task execution queued");
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RejectedExecutionException("Interrupted", e);
        }
    }
}

