## helm init

Initialize Helm on both client and server

### Synopsis


This command installs Tiller (the Helm server-side component) onto your
Kubernetes Cluster and sets up local configuration in $HELM_HOME (default ~/.helm/).

As with the rest of the Helm commands, 'helm init' discovers Kubernetes clusters
by reading $KUBECONFIG (default '~/.kube/config') and using the default context.

To set up just a local environment, use '--client-only'. That will configure
$HELM_HOME, but not attempt to connect to a Kubernetes cluster and install the Tiller
deployment.

When installing Tiller, 'helm init' will attempt to install the latest released
version. You can specify an alternative image with '--tiller-image'. For those
frequently working on the latest code, the flag '--canary-image' will install
the latest pre-release version of Tiller (e.g. the HEAD commit in the GitHub
repository on the master branch).

To dump a manifest containing the Tiller deployment YAML, combine the
'--dry-run' and '--debug' flags.


```
helm init [flags]
```

### Options

```
      --automount-service-account-token    Auto-mount the given service account to tiller (default true)
      --canary-image                       Use the canary Tiller image
  -c, --client-only                        If set does not install Tiller
      --dry-run                            Do not install local or remote
      --force-upgrade                      Force upgrade of Tiller to the current helm version
  -h, --help                               help for init
      --history-max int                    Limit the maximum number of revisions saved per release. Use 0 for no limit.
      --local-repo-url string              URL for local repository (default "http://127.0.0.1:8879/charts")
      --net-host                           Install Tiller with net=host
      --node-selectors string              Labels to specify the node on which Tiller is installed (app=tiller,helm=rocks)
  -o, --output OutputFormat                Skip installation and output Tiller's manifest in specified format (json or yaml)
      --override stringArray               Override values for the Tiller Deployment manifest (can specify multiple or separate values with commas: key1=val1,key2=val2)
      --replicas int                       Amount of tiller instances to run on the cluster (default 1)
      --service-account string             Name of service account
      --skip-refresh                       Do not refresh (download) the local repository cache
      --skip-repos                         Skip adding the stable and local repositories
      --stable-repo-url string             URL for stable repository (default "https://charts.helm.sh/stable")
  -i, --tiller-image string                Override Tiller image
      --tiller-tls                         Install Tiller with TLS enabled
      --tiller-tls-cert string             Path to TLS certificate file to install with Tiller
      --tiller-tls-hostname string         The server name used to verify the hostname on the returned certificates from Tiller
      --tiller-tls-key string              Path to TLS key file to install with Tiller
      --tiller-tls-verify                  Install Tiller with TLS enabled and to verify remote certificates
      --tls-ca-cert string                 Path to CA root certificate
      --upgrade                            Upgrade if Tiller is already installed
      --use-deprecated-stable-repository   Use the old (googleapis) repository URL even though that URL is being shutdown.
      --wait                               Block until Tiller is running and ready to receive requests
```

### Options inherited from parent commands

```
      --debug                           Enable verbose output
      --home string                     Location of your Helm config. Overrides $HELM_HOME (default "~/.helm")
      --host string                     Address of Tiller. Overrides $HELM_HOST
      --kube-context string             Name of the kubeconfig context to use
      --kubeconfig string               Absolute path of the kubeconfig file to be used
      --tiller-connection-timeout int   The duration (in seconds) Helm will wait to establish a connection to Tiller (default 300)
      --tiller-namespace string         Namespace of Tiller (default "kube-system")
```

### SEE ALSO

* [helm](helm.md)	 - The Helm package manager for Kubernetes.

###### Auto generated by spf13/cobra on 15-Oct-2020
