// Code generated by github.com/swaggest/json-cli v1.7.7, DO NOT EDIT.

package jsonschema

import (
	"encoding/json"
	"testing"

	"github.com/stretchr/testify/require"
	"github.com/swaggest/assertjson"
)

func TestSchema_MarshalJSON_roundtrip(t *testing.T) {
	var (
		jsonValue = []byte(`{"$id":"cbbfff","$schema":"cdef","$ref":"aadce","$comment":"dc","title":"daecfe","description":"cddbd","readOnly":true,"examples":["accdf"],"multipleOf":9682.647,"maximum":8027.772,"exclusiveMaximum":3134.928,"minimum":928.915,"exclusiveMinimum":6923.534,"maxLength":5182,"minLength":8764,"pattern":"adeadb","additionalItems":{"$id":"cda","$schema":"bdc","$ref":"dbfee","$comment":"fcceaf","title":"fedacd","description":"ab","readOnly":true,"examples":["edc"],"multipleOf":4692.916,"maximum":9086.046,"exclusiveMaximum":962.626,"minimum":2936.848,"exclusiveMinimum":9033.798,"maxLength":2878,"minLength":1195,"pattern":"bffd","additionalItems":{"$id":"eae","$schema":"db","$ref":"bfdbc","$comment":"ec","title":"eb","description":"fffbce","readOnly":true,"examples":["dca"],"multipleOf":1400.521,"maximum":5149.376,"exclusiveMaximum":7924.243,"minimum":9446.003,"exclusiveMinimum":298.984,"maxLength":5866,"minLength":8831,"pattern":"bcf","items":{"$id":"fa","$schema":"abdfad","$ref":"aeab","$comment":"bafd","title":"eaceae","description":"cc","readOnly":true,"examples":["eadf"],"multipleOf":738.846,"maximum":1148.345,"exclusiveMaximum":7869.728,"minimum":9494.943,"exclusiveMinimum":641.609,"maxLength":4499,"minLength":3553,"pattern":"bcacc","additionalItems":{"$id":"fcadff","$schema":"eca","$ref":"bdb","$comment":"dfe","title":"cfdcf","description":"baf","readOnly":true,"examples":["dda"],"multipleOf":1920.369,"maximum":6968.485,"exclusiveMaximum":4643.651,"minimum":660.936,"exclusiveMinimum":2304.398,"maxLength":7555,"minLength":5082,"pattern":"de","items":[{"$id":"befdf","$schema":"dcba","$ref":"bffbb","$comment":"cdf","title":"caf","description":"eeacab","readOnly":true,"examples":["bd"],"multipleOf":2330.51,"maximum":7174.199,"exclusiveMaximum":8071.245,"minimum":6129.868,"exclusiveMinimum":3879.219,"maxLength":4269,"minLength":8635,"pattern":"cfcbcf","additionalItems":{"$id":"ce","$schema":"bb","$ref":"eabafb","$comment":"ab","title":"daac","description":"cba","readOnly":true,"examples":["df"],"multipleOf":1955.099,"maximum":9387.178,"exclusiveMaximum":5814.008,"minimum":3711.968,"exclusiveMinimum":9700.23,"maxLength":500,"minLength":8468,"pattern":"efc","items":{"ec":"babfe"},"bffb":"bdea"},"aaead":"ac"}],"abdb":"cccf"},"bed":"cec"},"efecaf":"fdeeb"},"afcfaf":"ec"},"items":{"$id":"eaeeaf","$schema":"ccb","$ref":"fdcbaf","$comment":"abcdaf","title":"ac","description":"dcefd","readOnly":true,"examples":["dfecaf"],"multipleOf":4595.993,"maximum":9479.754,"exclusiveMaximum":9613.211,"minimum":8271.328,"exclusiveMinimum":3342.518,"maxLength":150,"minLength":4721,"pattern":"dbc","additionalItems":{"$id":"fbd","$schema":"becee","$ref":"bceeab","$comment":"efefda","title":"ad","description":"dc","readOnly":true,"examples":["aadabb"],"multipleOf":2353.448,"maximum":8928.994,"exclusiveMaximum":8151.185,"minimum":5778.994,"exclusiveMinimum":5439.428,"maxLength":1840,"minLength":1913,"pattern":"eccf","items":{"$id":"eeacfa","$schema":"ffd","$ref":"cd","$comment":"afa","title":"fcac","description":"ddd","readOnly":true,"examples":["aceba"],"multipleOf":6980.874,"maximum":9005.385,"exclusiveMaximum":8644.93,"minimum":47.628,"exclusiveMinimum":3227.487,"maxLength":2642,"minLength":6708,"pattern":"bcacab","additionalItems":{"$id":"ae","$schema":"feb","$ref":"adfd","$comment":"efe","title":"ec","description":"dff","readOnly":true,"examples":["facf"],"multipleOf":2524.415,"maximum":2988.703,"exclusiveMaximum":8549.125,"minimum":5407.655,"exclusiveMinimum":5277.619,"maxLength":8599,"minLength":8022,"pattern":"eda","maxItems":443,"minItems":5190,"uniqueItems":true,"contains":{"$id":"cafacf","$schema":"eddbb","$ref":"aeccac","$comment":"cbe","title":"ef","description":"befe","readOnly":true,"examples":["dbfbf"],"multipleOf":1393.661,"maximum":9163.139,"exclusiveMaximum":5403.505,"minimum":9096.446,"exclusiveMinimum":4671.386,"maxLength":2571,"minLength":2187,"pattern":"cffaee","additionalItems":{"$id":"dcddce","$schema":"ebceba","$ref":"ce","$comment":"cdbcc","title":"ecabba","description":"ccfc","readOnly":true,"examples":["dfce"],"multipleOf":3930.01,"maximum":8729.351,"exclusiveMaximum":808.757,"minimum":8447.251,"exclusiveMinimum":3521.861,"maxLength":5384,"minLength":10,"pattern":"abcce","items":{"$id":"caee","$schema":"cbed","$ref":"edbe","$comment":"bddcd","title":"eb","description":"bbab","readOnly":true,"examples":["ddf"],"multipleOf":4461.549,"maximum":3003.183,"exclusiveMaximum":9680.159,"minimum":1430.915,"exclusiveMinimum":3596.243,"maxLength":9013,"pattern":"be","additionalItems":{"becfee":"aaab"},"fe":"da"},"ce":"bfcfa"},"af":"bfe"},"cf":"accb"},"aa":"dfba"},"ab":"ac"},"faceb":"cffd"},"maxItems":7876,"minItems":5111,"uniqueItems":true,"contains":{"$id":"effa","$schema":"bfd","$ref":"dde","$comment":"ecf","title":"fbffc","description":"ffde","readOnly":true,"examples":["df"],"multipleOf":7662.348,"maximum":7357.585,"exclusiveMaximum":3425.199,"minimum":9096.46,"exclusiveMinimum":8458.669,"maxLength":2774,"minLength":4288,"pattern":"caf","additionalItems":{"$id":"bdeeae","$schema":"faabea","$ref":"befcaa","$comment":"bf","title":"aacdcd","description":"bdc","readOnly":true,"examples":["ebaebb"],"multipleOf":6881.473,"maximum":104.632,"exclusiveMaximum":6088.522,"minimum":5386.734,"exclusiveMinimum":1063.007,"maxLength":30,"minLength":2807,"pattern":"cfeb","items":{"$id":"bfddfd","$schema":"ea","$ref":"ba","$comment":"dbebb","title":"aac","description":"cfd","readOnly":true,"examples":["ad"],"multipleOf":8745.228,"maximum":1468.777,"exclusiveMaximum":8478.052,"minimum":2643.71,"exclusiveMinimum":6477.591,"maxLength":8191,"minLength":5856,"pattern":"abaceb","additionalItems":{"$id":"ed","$schema":"bdfeda","$ref":"ef","$comment":"dd","title":"ab","description":"fdecf","readOnly":true,"examples":["adbbf"],"multipleOf":4529.082,"maximum":8803.554,"exclusiveMaximum":6283.462,"minimum":4980.335,"exclusiveMinimum":2901.678,"maxLength":3334,"minLength":93,"pattern":"bbbeea","items":[{"$id":"ec","$schema":"bada","$ref":"dbe","$comment":"cceec","title":"aa","description":"ceadd","readOnly":true,"examples":["bcdde"],"multipleOf":4394.605,"maximum":7019.063,"exclusiveMaximum":1605.003,"minimum":2404.316,"exclusiveMinimum":8792.838,"maxLength":5742,"minLength":4785,"pattern":"efaafd","additionalItems":{"$id":"ccfe","$schema":"cca","$ref":"ea","$comment":"eceb","title":"dcbef","description":"afab","readOnly":true,"examples":["cefedf"],"multipleOf":9727.903,"maximum":4158.505,"exclusiveMaximum":7674.981,"minimum":1959.72,"exclusiveMinimum":8242.554,"maxLength":1660,"minLength":6326,"pattern":"caefa","items":{"ebad":"edddff"},"bb":"dcdec"},"abcc":"cc"}],"de":"cfdca"},"cddfdf":"accefd"},"ecdb":"bb"},"ccccf":"ada"},"maxProperties":4581,"minProperties":6737,"required":["ea"],"additionalProperties":{"$id":"eabbff","$schema":"efccf","$ref":"cbbbd","$comment":"ccdfa","title":"fb","description":"dbbff","readOnly":true,"examples":["afbeaf"],"multipleOf":4933.189,"maximum":3771.449,"exclusiveMaximum":7339.696,"minimum":267.252,"exclusiveMinimum":1848.369,"maxLength":1109,"minLength":9207,"pattern":"ebbac","additionalItems":{"$id":"faf","$schema":"beda","$ref":"fdc","$comment":"bdbb","title":"bebdb","description":"cdaef","readOnly":true,"examples":["dc"],"multipleOf":4464.657,"maximum":1468.368,"exclusiveMaximum":3288.864,"minimum":7293.46,"exclusiveMinimum":3441.308,"maxLength":1887,"minLength":475,"pattern":"dfcbd","items":{"$id":"aaa","$schema":"bbbb","$ref":"aebbfb","$comment":"efbafb","title":"befffe","description":"decac","readOnly":true,"examples":["fbd"],"multipleOf":2065.334,"maximum":7205.459,"exclusiveMaximum":762.812,"minimum":8473.593,"exclusiveMinimum":5079.709,"maxLength":5686,"minLength":2615,"pattern":"afecef","additionalItems":{"$id":"bc","$schema":"dfcd","$ref":"bcfbd","$comment":"fbcadd","title":"affee","description":"afdfca","readOnly":true,"examples":["bcfef"],"multipleOf":7587.711,"maximum":2088.699,"exclusiveMaximum":7169.573,"minimum":7444.97,"exclusiveMinimum":9873.274,"maxLength":9777,"minLength":2781,"pattern":"bf","items":[{"$id":"ccdf","$schema":"eda","$ref":"cdcfdf","$comment":"ba","title":"beebc","description":"aa","readOnly":true,"examples":["acfde"],"multipleOf":2203.62,"maximum":3565.182,"exclusiveMaximum":3021.665,"minimum":9099.925,"exclusiveMinimum":8830.402,"maxLength":1787,"minLength":5432,"pattern":"daa","additionalItems":{"$id":"addbf","$schema":"afeed","$ref":"ef","$comment":"aabff","title":"cbcbf","description":"aabca","readOnly":true,"examples":["edbacb"],"multipleOf":1313.008,"maximum":9093.211,"exclusiveMaximum":1605.113,"minimum":6055.185,"exclusiveMinimum":8700.947,"maxLength":7668,"minLength":9871,"pattern":"edc","items":{"adecb":"cdbc"},"fff":"fedcff"},"abcbdd":"aedc"}],"fafe":"bfabe"},"cfefbb":"ea"},"ef":"bc"},"accfeb":"ecb"},"definitions":{"abf":{"$id":"eba","$schema":"ec","$ref":"daf","$comment":"fececc","title":"ad","description":"faccdc","readOnly":true,"examples":["fbdeaf"],"multipleOf":968.643,"maximum":3203.873,"exclusiveMaximum":1464.101,"minimum":9824.927,"exclusiveMinimum":4151.62,"maxLength":6363,"minLength":5249,"pattern":"debf","additionalItems":{"$id":"ee","$schema":"efcae","$ref":"aa","$comment":"eedbbd","title":"ebfac","description":"afcccc","readOnly":true,"examples":["dcd"],"multipleOf":4772.999,"maximum":2790.63,"exclusiveMaximum":4498.865,"minimum":6088.703,"exclusiveMinimum":9358.699,"maxLength":6825,"minLength":3901,"pattern":"ee","items":{"$id":"bcab","$schema":"ad","$ref":"de","$comment":"fdddef","title":"cab","description":"ad","readOnly":true,"examples":["bbf"],"multipleOf":3719.849,"maximum":1632.602,"exclusiveMaximum":3553.724,"minimum":6381.138,"exclusiveMinimum":577.49,"maxLength":2362,"minLength":6316,"pattern":"dbddbf","additionalItems":{"$id":"deebeb","$schema":"ffc","$ref":"fcf","$comment":"cdffb","title":"aeabef","description":"bc","readOnly":true,"examples":["fdfa"],"multipleOf":8596.65,"maximum":8611.056,"exclusiveMaximum":6716.312,"minimum":8137.529,"exclusiveMinimum":6335.107,"maxLength":7212,"minLength":1248,"pattern":"dba","items":[{"$id":"dace","$schema":"ffe","$ref":"aab","$comment":"caa","title":"ceeffd","description":"bc","readOnly":true,"examples":["bbaeb"],"multipleOf":4228.104,"maximum":7519.105,"exclusiveMaximum":1075.981,"minimum":1014.964,"exclusiveMinimum":6237.08,"maxLength":5849,"minLength":480,"pattern":"beaeaa","additionalItems":{"$id":"abc","$schema":"bc","$ref":"fe","$comment":"efb","title":"fcffcd","description":"db","readOnly":true,"examples":["aca"],"multipleOf":4698.421,"maximum":5997.322,"exclusiveMaximum":9794.854,"minimum":4118.917,"exclusiveMinimum":3644.416,"maxLength":7378,"pattern":"af","items":true,"maxItems":9209,"uniqueItems":true,"contains":{"dbeea":"efbada"},"cfecef":"fdea"},"bcaceb":"bbed"}],"bef":"ccff"},"fbedff":"bdfa"},"ccb":"afadf"},"dff":"cafe"}},"properties":{"faa":{"$id":"da","$schema":"faeff","$ref":"bcfcec","$comment":"fec","title":"ceb","description":"cf","readOnly":true,"examples":["cabe"],"multipleOf":3426.232,"maximum":1138.85,"exclusiveMaximum":4171.074,"minimum":6518.241,"exclusiveMinimum":7608.632,"maxLength":4027,"minLength":8625,"pattern":"eebe","additionalItems":{"$id":"dfddca","$schema":"eebb","$ref":"eccc","$comment":"eb","title":"bb","description":"fab","readOnly":true,"examples":["faaf"],"multipleOf":7405.04,"maximum":5476.095,"exclusiveMaximum":3179.993,"minimum":2202.067,"exclusiveMinimum":4956.045,"maxLength":6714,"minLength":8555,"pattern":"cdac","items":{"$id":"cfac","$schema":"bfe","$ref":"bfaea","$comment":"affeea","title":"bc","description":"ebf","readOnly":true,"examples":["ad"],"multipleOf":9675.203,"maximum":7744.998,"exclusiveMaximum":322.924,"minimum":3258.774,"exclusiveMinimum":4786.324,"maxLength":8898,"minLength":813,"pattern":"edaddd","additionalItems":{"$id":"bdab","$schema":"cdadb","$ref":"ecbacf","$comment":"caeae","title":"ce","description":"de","readOnly":true,"examples":["eaca"],"multipleOf":8477.157,"maximum":8713.779,"exclusiveMaximum":4541.136,"minimum":8820.957,"exclusiveMinimum":155.02,"maxLength":4297,"minLength":8731,"pattern":"cbdead","items":[{"$id":"bbdb","$schema":"bf","$ref":"ebdf","$comment":"ed","title":"bdfeb","description":"cfba","readOnly":true,"examples":["dacee"],"multipleOf":7056.506,"maximum":3449.269,"exclusiveMaximum":287.194,"minimum":8978.609,"exclusiveMinimum":4085.849,"maxLength":4346,"minLength":9311,"pattern":"bc","additionalItems":{"$id":"efb","$schema":"aed","$ref":"ffd","$comment":"cf","title":"ec","description":"fbfee","readOnly":true,"examples":["eaca"],"multipleOf":2483.659,"maximum":5295.014,"exclusiveMaximum":2951.491,"minimum":9514.692,"exclusiveMinimum":8726.989,"maxLength":3125,"pattern":"ebc","items":true,"maxItems":8970,"uniqueItems":true,"contains":{"facff":"dbb"},"bdce":"fbf"},"ca":"ed"}],"dbcc":"cba"},"dcbe":"cdeec"},"dcdfa":"cdeac"},"ceb":"caeed"}},"patternProperties":{"fca":{"$id":"cbfed","$schema":"bcaaf","$ref":"bcef","$comment":"bfab","title":"bacfe","description":"eabc","readOnly":true,"examples":["ebfc"],"multipleOf":5071.687,"maximum":8533.244,"exclusiveMaximum":4547.468,"minimum":7213.709,"exclusiveMinimum":5879.127,"maxLength":9310,"minLength":2641,"pattern":"cfbb","additionalItems":{"$id":"dafcaf","$schema":"eefe","$ref":"aafddd","$comment":"bf","title":"bdaaec","description":"eaadfb","readOnly":true,"examples":["cafff"],"multipleOf":2338.453,"maximum":7988.736,"exclusiveMaximum":1767.612,"minimum":6137.632,"exclusiveMinimum":3911.6,"maxLength":7262,"minLength":3206,"pattern":"ae","items":{"$id":"ea","$schema":"bfbfd","$ref":"fbbd","$comment":"edfbbd","title":"ee","description":"bbcb","readOnly":true,"examples":["bfecf"],"multipleOf":8009.204,"maximum":3304.587,"exclusiveMaximum":5466.654,"minimum":8435.098,"exclusiveMinimum":1816.913,"maxLength":4284,"minLength":7008,"pattern":"bdccfc","additionalItems":{"$id":"deeca","$schema":"fafe","$ref":"aaf","$comment":"ae","title":"cabb","description":"aafcb","readOnly":true,"examples":["deed"],"multipleOf":530.52,"maximum":8218.672,"exclusiveMaximum":8390.621,"minimum":6282.768,"exclusiveMinimum":3665.756,"maxLength":9563,"minLength":9223,"pattern":"babb","items":[{"$id":"eaefb","$schema":"bc","$ref":"baaf","$comment":"cdff","title":"ea","description":"be","readOnly":true,"examples":["cf"],"multipleOf":1924.3,"maximum":3949.428,"exclusiveMaximum":1052.784,"minimum":4616.336,"exclusiveMinimum":963.585,"maxLength":5609,"minLength":4369,"pattern":"aefff","additionalItems":{"$id":"cc","$schema":"aea","$ref":"ebada","$comment":"cab","title":"afbbc","description":"deecba","readOnly":true,"examples":["cabd"],"multipleOf":1294.715,"maximum":8731.071,"exclusiveMaximum":7809.456,"minimum":7003.194,"exclusiveMinimum":2616.332,"maxLength":4705,"pattern":"fdea","items":true,"maxItems":3635,"uniqueItems":true,"contains":{"edfdc":"dfd"},"fbfad":"fcbee"},"eafbaa":"ddc"}],"efc":"fcfa"},"ebb":"dfca"},"dffab":"bc"},"fc":"af"}},"dependencies":{"eefed":{"$id":"ece","$schema":"cedfbd","$ref":"aabdec","$comment":"df","title":"cbebf","description":"dafa","readOnly":true,"examples":["adedfc"],"multipleOf":3930.337,"maximum":9490.775,"exclusiveMaximum":7906.579,"minimum":9523.513,"exclusiveMinimum":6451.139,"maxLength":1071,"minLength":3939,"pattern":"ecd","additionalItems":{"$id":"aeddba","$schema":"ebfd","$ref":"ad","$comment":"fe","title":"cedb","description":"ecbda","readOnly":true,"examples":["da"],"multipleOf":3638.036,"maximum":2364.605,"exclusiveMaximum":6575.577,"minimum":6606.323,"exclusiveMinimum":4533.265,"maxLength":896,"minLength":7691,"pattern":"cbecc","items":{"$id":"ea","$schema":"fdcade","$ref":"bebfbb","$comment":"cccdd","title":"cbabc","description":"afbefe","readOnly":true,"examples":["eeccb"],"multipleOf":2772.724,"maximum":2653.558,"exclusiveMaximum":5348.788,"minimum":1100.658,"exclusiveMinimum":7679.861,"maxLength":7113,"minLength":531,"pattern":"bafaae","additionalItems":{"$id":"ffdcfb","$schema":"eecee","$ref":"bbccef","$comment":"fabfcb","title":"cf","description":"fbae","readOnly":true,"examples":["ccac"],"multipleOf":3537.124,"maximum":4924.12,"exclusiveMaximum":2539.135,"minimum":667.921,"exclusiveMinimum":9110.269,"maxLength":5970,"minLength":7256,"pattern":"fec","maxItems":345,"minItems":2813,"uniqueItems":true,"contains":{"$id":"ddbe","$schema":"cbc","$ref":"eb","$comment":"cbea","title":"cfe","description":"aedcf","readOnly":true,"examples":["eabcab"],"multipleOf":7397.659,"maximum":9904.072,"exclusiveMaximum":5437.349,"minimum":7739.389,"exclusiveMinimum":7314.642,"maxLength":3343,"minLength":6023,"pattern":"bfeada","additionalItems":{"$id":"deaba","$schema":"db","$ref":"ee","$comment":"bbefdc","title":"ecbbff","description":"bbcaf","readOnly":true,"examples":["bbcda"],"multipleOf":4218.909,"maximum":7580.859,"exclusiveMaximum":4385.947,"minimum":8519.606,"exclusiveMinimum":8014.083,"maxLength":8442,"minLength":157,"pattern":"ed","items":{"eee":"ca"},"eaa":"cbede"},"edde":"daea"},"bfcfc":"facbd"},"bd":"fdceb"},"ea":"ab"},"ddc":"dbb"}},"propertyNames":{"$id":"cfccc","$schema":"fdef","$ref":"fafa","$comment":"ebfcf","title":"bdfbb","description":"ccefc","readOnly":true,"examples":["ccabb"],"multipleOf":3563.046,"maximum":9357.596,"exclusiveMaximum":5051.997,"minimum":2836.162,"exclusiveMinimum":4028.073,"maxLength":2746,"minLength":8544,"pattern":"aae","additionalItems":{"$id":"cdeb","$schema":"cb","$ref":"dbc","$comment":"aacb","title":"ce","description":"ceeff","readOnly":true,"examples":["affaac"],"multipleOf":9377.255,"maximum":3914.912,"exclusiveMaximum":9899.648,"minimum":2402.482,"exclusiveMinimum":9820.002,"maxLength":6864,"minLength":5850,"pattern":"fab","items":{"$id":"cabca","$schema":"bf","$ref":"dbedae","$comment":"ce","title":"abba","description":"eefac","readOnly":true,"examples":["fcddb"],"multipleOf":3217.16,"maximum":3182.862,"exclusiveMaximum":7802.243,"minimum":685.972,"exclusiveMinimum":1458.709,"maxLength":3531,"minLength":2449,"pattern":"dbaef","additionalItems":{"$id":"eb","$schema":"cfdd","$ref":"fe","$comment":"eacb","title":"febab","description":"eec","readOnly":true,"examples":["acaab"],"multipleOf":3346.537,"maximum":4538.846,"exclusiveMaximum":8531.366,"minimum":5578.695,"exclusiveMinimum":8855.367,"maxLength":5061,"minLength":1814,"pattern":"cbbffe","items":[{"$id":"abcebc","$schema":"eebdc","$ref":"deceb","$comment":"dd","title":"dcadb","description":"fbbc","readOnly":true,"examples":["ceccf"],"multipleOf":4097.903,"maximum":9599.869,"exclusiveMaximum":873.438,"minimum":5164.115,"exclusiveMinimum":3711.268,"maxLength":6428,"minLength":6721,"pattern":"ede","additionalItems":{"$id":"cfa","$schema":"fdac","$ref":"fdfafe","$comment":"fefebb","title":"addc","description":"bbccf","readOnly":true,"examples":["faca"],"multipleOf":3644.29,"maximum":8680.533,"exclusiveMaximum":8922.847,"minimum":5411.264,"exclusiveMinimum":278.09,"maxLength":7982,"minLength":854,"pattern":"aef","items":{"edfca":"edcf"},"efbf":"ecc"},"ba":"bfbed"}],"df":"af"},"decd":"dbba"},"add":"ebe"},"dfaafa":"eebe"},"enum":["adbe"],"type":"array","format":"feaa","contentMediaType":"efee","contentEncoding":"aebc","if":{"$id":"ad","$schema":"fdbed","$ref":"ddad","$comment":"ebef","title":"feb","description":"ec","readOnly":true,"examples":["ac"],"multipleOf":7511.147,"maximum":4628.785,"exclusiveMaximum":2118.002,"minimum":5325.378,"exclusiveMinimum":8301.735,"maxLength":8259,"minLength":2401,"pattern":"bfbde","additionalItems":{"$id":"bb","$schema":"edbefe","$ref":"ed","$comment":"fbdffc","title":"fbcfeb","description":"edeccc","readOnly":true,"examples":["daccfa"],"multipleOf":8106.48,"maximum":5153.686,"exclusiveMaximum":8600.126,"minimum":452.093,"exclusiveMinimum":4586.05,"maxLength":119,"minLength":9306,"pattern":"db","items":{"$id":"cb","$schema":"cf","$ref":"bfeba","$comment":"abf","title":"fafde","description":"fbeaad","readOnly":true,"examples":["bfae"],"multipleOf":5154.422,"maximum":5192.47,"exclusiveMaximum":4000.059,"minimum":2402.211,"exclusiveMinimum":9862.482,"maxLength":3859,"minLength":282,"pattern":"ffae","additionalItems":{"$id":"ceec","$schema":"ce","$ref":"cddb","$comment":"fdcba","title":"ba","description":"be","readOnly":true,"examples":["cec"],"multipleOf":4107.622,"maximum":416.701,"exclusiveMaximum":2240.753,"minimum":9897.08,"exclusiveMinimum":7230.852,"maxLength":4649,"minLength":5963,"pattern":"eedbbb","items":[{"$id":"bbbc","$schema":"cfbadf","$ref":"adfbd","$comment":"eafe","title":"ddfae","description":"cdadb","readOnly":true,"examples":["eedeaa"],"multipleOf":2507.821,"maximum":2206.72,"exclusiveMaximum":4758.479,"minimum":439.171,"exclusiveMinimum":4731.603,"maxLength":7132,"minLength":1690,"pattern":"efffd","additionalItems":{"$id":"aff","$schema":"ffbfbe","$ref":"bf","$comment":"cdaeaf","title":"cbedeb","description":"ed","readOnly":true,"examples":["dbdafc"],"multipleOf":8676.404,"maximum":8255.458,"exclusiveMaximum":8498.869,"minimum":181.05,"exclusiveMinimum":8084.305,"maxLength":5731,"minLength":1307,"pattern":"eccd","items":{"ffb":"ed"},"fda":"ccfdd"},"dbbccd":"ad"}],"ddadff":"abff"},"eeced":"bb"},"baaad":"fdbdf"},"ffb":"bbce"},"then":{"$id":"fb","$schema":"fb","$ref":"adb","$comment":"ac","title":"cecab","description":"afeef","readOnly":true,"examples":["adfae"],"multipleOf":7029.614,"maximum":235.932,"exclusiveMaximum":1850.165,"minimum":5306.341,"exclusiveMinimum":5657.756,"maxLength":3771,"minLength":9088,"pattern":"bed","additionalItems":{"$id":"badaa","$schema":"eb","$ref":"cddfb","$comment":"fdc","title":"ad","description":"fd","readOnly":true,"examples":["dcc"],"multipleOf":4663.624,"maximum":777.466,"exclusiveMaximum":4910.594,"minimum":2089.227,"exclusiveMinimum":7668.857,"maxLength":8392,"minLength":6343,"pattern":"ddfae","items":{"$id":"fcb","$schema":"caa","$ref":"bc","$comment":"dfcde","title":"aeaabe","description":"dc","readOnly":true,"examples":["bcedff"],"multipleOf":1937.652,"maximum":146.673,"exclusiveMaximum":772.081,"minimum":2152.881,"exclusiveMinimum":7565.477,"maxLength":1174,"minLength":5641,"pattern":"bcbdd","additionalItems":{"$id":"dea","$schema":"bcf","$ref":"bbe","$comment":"ddd","title":"cfdbcb","description":"afed","readOnly":true,"examples":["aaddc"],"multipleOf":754.033,"maximum":2189.55,"exclusiveMaximum":4257.818,"minimum":3308.452,"exclusiveMinimum":6020.476,"maxLength":3179,"minLength":4254,"pattern":"fdb","items":[{"$id":"cfda","$schema":"ae","$ref":"cccbcb","$comment":"dfcfc","title":"eb","description":"eeba","readOnly":true,"examples":["fcff"],"multipleOf":163.951,"maximum":6194.302,"exclusiveMaximum":2208.965,"minimum":9807.01,"exclusiveMinimum":5115.111,"maxLength":6435,"minLength":7883,"pattern":"dbbcde","additionalItems":{"$id":"cbee","$schema":"ccd","$ref":"edddc","$comment":"abdc","title":"cef","description":"fffa","readOnly":true,"examples":["fcfbd"],"multipleOf":8167.723,"maximum":4336.992,"exclusiveMaximum":8778.136,"minimum":444.218,"exclusiveMinimum":5710.517,"maxLength":6953,"minLength":9640,"pattern":"afbe","items":{"fadcee":"dcbfe"},"bbdebf":"ffeef"},"fbea":"aebcf"}],"fde":"eba"},"aadb":"fcfa"},"eea":"bde"},"dbfbd":"eddd"},"else":{"$id":"adcfab","$schema":"bbcda","$ref":"eb","$comment":"cd","title":"dcbd","description":"aaaca","readOnly":true,"examples":["ff"],"multipleOf":4979.965,"maximum":7419.9,"exclusiveMaximum":9700.117,"minimum":9828.825,"exclusiveMinimum":9811.716,"maxLength":4161,"minLength":3199,"pattern":"aac","additionalItems":{"$id":"ecfb","$schema":"fcd","$ref":"fefdbd","$comment":"ccffd","title":"afbd","description":"da","readOnly":true,"examples":["cab"],"multipleOf":726.083,"maximum":4190.405,"exclusiveMaximum":1727.838,"minimum":6722.745,"exclusiveMinimum":3224.252,"maxLength":7952,"minLength":2484,"pattern":"cbdcae","items":{"$id":"bfbf","$schema":"eaf","$ref":"cb","$comment":"cdfd","title":"bea","description":"bacf","readOnly":true,"examples":["ed"],"multipleOf":9255.547,"maximum":6763.89,"exclusiveMaximum":9280.021,"minimum":2317.8,"exclusiveMinimum":2179.355,"maxLength":4136,"minLength":6830,"pattern":"ceedf","additionalItems":{"$id":"bdcb","$schema":"bbdbb","$ref":"ff","$comment":"efceea","title":"cdcfac","description":"bebdb","readOnly":true,"examples":["cced"],"multipleOf":464.688,"maximum":4718.719,"exclusiveMaximum":6277.669,"minimum":9818.262,"exclusiveMinimum":6554.632,"maxLength":1329,"minLength":2560,"pattern":"cfdc","items":[{"$id":"cd","$schema":"dd","$ref":"cb","$comment":"ecfeb","title":"de","description":"ccac","readOnly":true,"examples":["acfcef"],"multipleOf":9481.089,"maximum":2777.85,"exclusiveMaximum":9892.559,"minimum":8272.176,"exclusiveMinimum":2411.349,"maxLength":3645,"minLength":9337,"pattern":"cee","additionalItems":{"$id":"ed","$schema":"afdbd","$ref":"dfcbb","$comment":"dae","title":"be","description":"bacbab","readOnly":true,"examples":["bbfaf"],"multipleOf":8788.026,"maximum":875.64,"exclusiveMaximum":4024.206,"minimum":3998.15,"exclusiveMinimum":2032.733,"maxLength":2796,"minLength":4064,"pattern":"ebcf","items":{"bcfdbc":"fba"},"adcfdb":"abf"},"eacae":"cdcbb"}],"daddac":"ebedcb"},"cbddde":"fefc"},"ecfb":"eabecc"},"dbb":"fd"},"allOf":[{"$id":"ddaa","$schema":"dfcc","$ref":"fa","$comment":"bc","title":"fdac","description":"db","readOnly":true,"examples":["bccdc"],"multipleOf":293.692,"maximum":6285.031,"exclusiveMaximum":5551.313,"minimum":6455.082,"exclusiveMinimum":2930.686,"maxLength":2494,"minLength":5775,"pattern":"cebc","additionalItems":{"$id":"bdf","$schema":"ea","$ref":"badfe","$comment":"edadda","title":"debbf","description":"accdcb","readOnly":true,"examples":["ebdfa"],"multipleOf":4446.366,"maximum":7311.645,"exclusiveMaximum":9567.352,"minimum":5455.166,"exclusiveMinimum":9321.21,"maxLength":6065,"minLength":4354,"pattern":"fdba","items":{"$id":"adffc","$schema":"feaf","$ref":"eb","$comment":"db","title":"cd","description":"cdcdef","readOnly":true,"examples":["dd"],"multipleOf":6789.959,"maximum":1564.413,"exclusiveMaximum":7240.122,"minimum":1939.455,"exclusiveMinimum":26.43,"maxLength":4951,"minLength":4077,"pattern":"aaea","additionalItems":{"$id":"af","$schema":"faafb","$ref":"cdbfab","$comment":"aad","title":"fc","description":"aeb","readOnly":true,"examples":["aecfe"],"multipleOf":3038.281,"maximum":8927.122,"exclusiveMaximum":5217.071,"minimum":8363.857,"exclusiveMinimum":7123.41,"maxLength":5265,"minLength":3053,"pattern":"ebea","items":[{"$id":"ade","$schema":"cbdbdf","$ref":"ebeebc","$comment":"aeea","title":"dfcbf","description":"dacfa","readOnly":true,"examples":["cccccd"],"multipleOf":8251.928,"maximum":703.668,"exclusiveMaximum":320.81,"minimum":5588.936,"exclusiveMinimum":8779.726,"maxLength":6752,"minLength":346,"pattern":"aed","additionalItems":{"$id":"ddef","$schema":"dac","$ref":"ddfed","$comment":"cef","title":"dbde","description":"abafb","readOnly":true,"examples":["ec"],"multipleOf":1913.529,"maximum":2146.768,"exclusiveMaximum":3871.075,"minimum":9712.17,"exclusiveMinimum":8540.744,"maxLength":2522,"pattern":"faf","items":true,"maxItems":6236,"uniqueItems":true,"contains":{"afbcef":"eda"},"ddfa":"cefaf"},"bcba":"bd"}],"ac":"aecbe"},"dacc":"bceddc"},"ee":"bfe"},"ffaebd":"bca"}],"anyOf":[{"$id":"fadcb","$schema":"feabcf","$ref":"cea","$comment":"bdabd","title":"fa","description":"bdfeb","readOnly":true,"examples":["bdacaa"],"multipleOf":7334.327,"maximum":6262.463,"exclusiveMaximum":7221.387,"minimum":976.729,"exclusiveMinimum":2771.143,"maxLength":2510,"minLength":4077,"pattern":"abbbed","additionalItems":{"$id":"ca","$schema":"bdd","$ref":"cbeec","$comment":"aefbe","title":"ef","description":"bfe","readOnly":true,"examples":["eb"],"multipleOf":6060.747,"maximum":8080.599,"exclusiveMaximum":261.573,"minimum":9572.734,"exclusiveMinimum":71.46,"maxLength":2596,"minLength":595,"pattern":"fbcb","items":{"$id":"eaaef","$schema":"feecd","$ref":"dbca","$comment":"cbee","title":"ba","description":"bdb","readOnly":true,"examples":["ea"],"multipleOf":1501.835,"maximum":4590.221,"exclusiveMaximum":2659.804,"minimum":9086.513,"exclusiveMinimum":6895.259,"maxLength":34,"minLength":151,"pattern":"ac","additionalItems":{"$id":"ce","$schema":"cac","$ref":"facac","$comment":"da","title":"fc","description":"dffb","readOnly":true,"examples":["fee"],"multipleOf":4845.216,"maximum":8645.436,"exclusiveMaximum":8874.663,"minimum":2810.56,"exclusiveMinimum":1375.298,"maxLength":9588,"minLength":9644,"pattern":"eca","items":[{"$id":"cebb","$schema":"bdaef","$ref":"caaeb","$comment":"aacd","title":"cdcaaa","description":"ee","readOnly":true,"examples":["ddbe"],"multipleOf":4123.377,"maximum":156.577,"exclusiveMaximum":6115.829,"minimum":6000.682,"exclusiveMinimum":5468.798,"maxLength":2517,"minLength":3893,"pattern":"addbb","additionalItems":{"$id":"dddce","$schema":"cca","$ref":"cedcf","$comment":"ba","title":"bf","description":"dfabeb","readOnly":true,"examples":["dcaea"],"multipleOf":4509.476,"maximum":9274.157,"exclusiveMaximum":3487.919,"minimum":7014.945,"exclusiveMinimum":3833.42,"maxLength":4125,"pattern":"fffbdd","items":true,"maxItems":6310,"uniqueItems":true,"contains":{"fcaec":"edaa"},"fab":"deaea"},"efccae":"ec"}],"ccac":"dfba"},"deafeb":"ed"},"ee":"ffdcaa"},"dfcaac":"fedb"}],"oneOf":[{"$id":"ecaaf","$schema":"edbffb","$ref":"acfcdf","$comment":"efcbfe","title":"feba","description":"eee","readOnly":true,"examples":["ebdad"],"multipleOf":7921.044,"maximum":5551.489,"exclusiveMaximum":3985.278,"minimum":9707.449,"exclusiveMinimum":9921.167,"maxLength":918,"minLength":598,"pattern":"add","additionalItems":{"$id":"aef","$schema":"faf","$ref":"bbaac","$comment":"bf","title":"de","description":"feebcf","readOnly":true,"examples":["fb"],"multipleOf":2772.924,"maximum":6934.009,"exclusiveMaximum":961.534,"minimum":4384.82,"exclusiveMinimum":1188.185,"maxLength":2187,"minLength":3179,"pattern":"efdbcc","items":{"$id":"fe","$schema":"cf","$ref":"ddcebb","$comment":"aab","title":"abae","description":"cdfdab","readOnly":true,"examples":["ebabf"],"multipleOf":2317.406,"maximum":8471.282,"exclusiveMaximum":9560.112,"minimum":5034.273,"exclusiveMinimum":915.799,"maxLength":5272,"minLength":775,"pattern":"cdfddf","additionalItems":{"$id":"affa","$schema":"ebaff","$ref":"cb","$comment":"fef","title":"dee","description":"fabac","readOnly":true,"examples":["ee"],"multipleOf":5941.849,"maximum":7937.101,"exclusiveMaximum":1253.694,"minimum":1766.055,"exclusiveMinimum":7853.904,"maxLength":931,"minLength":6200,"pattern":"db","items":[{"$id":"cdd","$schema":"fce","$ref":"fabeaa","$comment":"fd","title":"bdbdc","description":"bcd","readOnly":true,"examples":["ab"],"multipleOf":2498.53,"maximum":3839.759,"exclusiveMaximum":3052.711,"minimum":1890.437,"exclusiveMinimum":9424.467,"maxLength":4688,"minLength":6189,"pattern":"feef","additionalItems":{"$id":"adf","$schema":"dfecea","$ref":"fcebc","$comment":"aceafc","title":"aaed","description":"badff","readOnly":true,"examples":["badda"],"multipleOf":6639.797,"maximum":5644.571,"exclusiveMaximum":8519.694,"minimum":7847.015,"exclusiveMinimum":1903.031,"maxLength":6429,"pattern":"ddea","items":true,"maxItems":8919,"uniqueItems":true,"contains":{"db":"ad"},"fda":"eeb"},"ccefbc":"cba"}],"edeaa":"fccddc"},"fdcca":"abfdf"},"adedaf":"fcebcb"},"fe":"fcdc"}],"not":{"$id":"eea","$schema":"de","$ref":"edbfba","$comment":"aeebb","title":"dbc","description":"ba","readOnly":true,"examples":["bfefd"],"multipleOf":3850.021,"maximum":9929.821,"exclusiveMaximum":7684.81,"minimum":3242.289,"exclusiveMinimum":6185.427,"maxLength":354,"minLength":4918,"pattern":"ba","additionalItems":{"$id":"efcfe","$schema":"bddfe","$ref":"aadbcf","$comment":"ee","title":"ddcbc","description":"ad","readOnly":true,"examples":["febbde"],"multipleOf":6827.044,"maximum":6754.8,"exclusiveMaximum":9375.545,"minimum":7955.232,"exclusiveMinimum":3941.896,"maxLength":400,"minLength":2726,"pattern":"dbb","items":{"$id":"fc","$schema":"fdfc","$ref":"aeb","$comment":"eafb","title":"ddaff","description":"acf","readOnly":true,"examples":["defbfe"],"multipleOf":4536.297,"maximum":7719.146,"exclusiveMaximum":979.323,"minimum":4583.946,"exclusiveMinimum":3187.435,"maxLength":2922,"minLength":1206,"pattern":"dfbcbd","additionalItems":{"$id":"dcefdb","$schema":"dbcdaf","$ref":"aebe","$comment":"eeeece","title":"bcac","description":"bee","readOnly":true,"examples":["fec"],"multipleOf":9100.642,"maximum":7262.292,"exclusiveMaximum":9802.02,"minimum":890.502,"exclusiveMinimum":7581.167,"maxLength":3267,"minLength":5741,"pattern":"aaeae","items":[{"$id":"bdbcfb","$schema":"cad","$ref":"bb","$comment":"aaace","title":"cd","description":"bdea","readOnly":true,"examples":["afc"],"multipleOf":9712.862,"maximum":3451.281,"exclusiveMaximum":1650.558,"minimum":9804.067,"exclusiveMinimum":7272.627,"maxLength":6313,"minLength":8907,"pattern":"dcc","additionalItems":{"$id":"edd","$schema":"ba","$ref":"afdbc","$comment":"aef","title":"dfb","description":"debad","readOnly":true,"examples":["fdfbe"],"multipleOf":1296.829,"maximum":1523.861,"exclusiveMaximum":7561.943,"minimum":4014.753,"exclusiveMinimum":7937.774,"maxLength":1972,"minLength":5849,"pattern":"ccc","items":{"cdcac":"ddf"},"efad":"bfdead"},"fdcdbd":"cef"}],"dbbcf":"ebefc"},"fbefbd":"bad"},"faff":"aef"},"fe":"debe"},"ffaeb":"cf"}`)
		v         Schema
	)

	require.NoError(t, json.Unmarshal(jsonValue, &v))

	marshaled, err := json.Marshal(v)
	require.NoError(t, err)
	require.NoError(t, json.Unmarshal(marshaled, &v))
	assertjson.Equal(t, jsonValue, marshaled)
}

func TestSchemaOrBool_MarshalJSON_roundtrip(t *testing.T) {
	var (
		jsonValue = []byte(`{"$id":"fb","$schema":"eafab","$ref":"dcfea","$comment":"bbcb","title":"ed","description":"eadc","readOnly":true,"examples":["faad"],"multipleOf":839.87,"maximum":6022.654,"exclusiveMaximum":1086.478,"minimum":8214.408,"exclusiveMinimum":5293.03,"maxLength":347,"minLength":6601,"pattern":"dca","additionalItems":{"$id":"ebb","$schema":"efcbc","$ref":"ff","$comment":"eaadfb","title":"fbcbe","description":"efcf","readOnly":true,"examples":["ebdef"],"multipleOf":1901.305,"maximum":5830.016,"exclusiveMaximum":2961.337,"minimum":500.166,"exclusiveMinimum":63.096,"maxLength":9526,"minLength":4316,"pattern":"dbefb","additionalItems":{"$id":"adafc","$schema":"abeabb","$ref":"cdbb","$comment":"fbec","title":"bea","description":"cdcfdc","readOnly":true,"examples":["ffdf"],"multipleOf":1101.655,"maximum":7894.22,"exclusiveMaximum":740.115,"minimum":1918.185,"exclusiveMinimum":3197.588,"maxLength":3318,"minLength":6608,"pattern":"fcf","items":{"$id":"cfde","$schema":"afee","$ref":"aabbbd","$comment":"edb","title":"fdb","description":"fea","readOnly":true,"examples":["ccdbbe"],"multipleOf":405.274,"maximum":3149.975,"exclusiveMaximum":8668.097,"minimum":3669.226,"exclusiveMinimum":2370.132,"maxLength":2919,"minLength":3804,"pattern":"aaae","additionalItems":{"$id":"cf","$schema":"bbfcbe","$ref":"bafdb","$comment":"befbe","title":"da","description":"cacbcf","readOnly":true,"examples":["bc"],"multipleOf":5291.343,"maximum":3012.314,"exclusiveMaximum":7935.053,"minimum":1696.026,"exclusiveMinimum":359.756,"maxLength":8568,"minLength":1914,"pattern":"fafff","items":[{"$id":"ee","$schema":"bb","$ref":"acfeaf","$comment":"ecaf","title":"fefdae","description":"cc","readOnly":true,"examples":["ed"],"multipleOf":7762.282,"maximum":2534.579,"exclusiveMaximum":4916.08,"minimum":5235.021,"exclusiveMinimum":2044.664,"maxLength":8275,"minLength":7292,"pattern":"edc","additionalItems":{"$id":"afd","$schema":"ccfbbb","$ref":"cfdcfa","$comment":"adca","title":"edbdcb","description":"afac","readOnly":true,"examples":["bfaaf"],"multipleOf":3253.988,"maximum":9288.158,"exclusiveMaximum":8389.61,"minimum":8340.642,"exclusiveMinimum":629.177,"maxLength":8887,"minLength":1054,"pattern":"ae","items":{"aeff":"dbe"},"aadf":"cdc"},"dfaace":"fefcde"}],"dafee":"bfcefe"},"acea":"afcba"},"cbc":"afbcd"},"cabcea":"fca"},"bbee":"fa"}`)
		v         SchemaOrBool
	)

	require.NoError(t, json.Unmarshal(jsonValue, &v))

	marshaled, err := json.Marshal(v)
	require.NoError(t, err)
	require.NoError(t, json.Unmarshal(marshaled, &v))
	assertjson.Equal(t, jsonValue, marshaled)
}

func TestItems_MarshalJSON_roundtrip(t *testing.T) {
	var (
		jsonValue = []byte(`{"$id":"ecaccf","$schema":"eae","$ref":"ea","$comment":"fff","title":"bb","description":"eebacd","readOnly":true,"examples":["dbfad"],"multipleOf":4917.775,"maximum":1175.302,"exclusiveMaximum":8524.027,"minimum":8839.227,"exclusiveMinimum":241.326,"maxLength":2756,"minLength":904,"pattern":"acab","additionalItems":{"$id":"eeb","$schema":"efb","$ref":"cd","$comment":"afffb","title":"ccc","description":"debdc","readOnly":true,"examples":["cae"],"multipleOf":634.542,"maximum":8815.53,"exclusiveMaximum":5843.11,"minimum":1096.463,"exclusiveMinimum":3357.815,"maxLength":182,"minLength":8818,"pattern":"bdbcfa","items":{"$id":"edcc","$schema":"dc","$ref":"bcd","$comment":"acdac","title":"ef","description":"dfb","readOnly":true,"examples":["acedfd"],"multipleOf":9892.658,"maximum":3759.378,"exclusiveMaximum":7804.789,"minimum":6946.61,"exclusiveMinimum":2279.031,"maxLength":9180,"minLength":307,"pattern":"cd","additionalItems":{"$id":"babdaa","$schema":"dced","$ref":"bafbba","$comment":"bfabe","title":"aadfe","description":"ecdeb","readOnly":true,"examples":["faefa"],"multipleOf":263.37,"maximum":6503.247,"exclusiveMaximum":3641.354,"minimum":6155.106,"exclusiveMinimum":4627.148,"maxLength":8139,"minLength":6086,"pattern":"cbac","items":[{"$id":"bc","$schema":"febdf","$ref":"ada","$comment":"cfa","title":"aacb","description":"aef","readOnly":true,"examples":["cce"],"multipleOf":8393.564,"maximum":3310.813,"exclusiveMaximum":2755.892,"minimum":6597.438,"exclusiveMinimum":106.683,"maxLength":4665,"minLength":4254,"pattern":"fcdf","additionalItems":{"$id":"ab","$schema":"cce","$ref":"ab","$comment":"dddea","title":"accbbd","description":"bda","readOnly":true,"examples":["be"],"multipleOf":4420.475,"maximum":8826.137,"exclusiveMaximum":5042.62,"minimum":6316.306,"exclusiveMinimum":1749.19,"maxLength":9637,"minLength":5231,"pattern":"adbf","items":{"fc":"bfefcd"},"ebfaa":"bad"},"abfddd":"dcc"}],"fd":"fabad"},"bba":"cfa"},"ff":"deab"},"ffafcc":"fe"}`)
		v         Items
	)

	require.NoError(t, json.Unmarshal(jsonValue, &v))

	marshaled, err := json.Marshal(v)
	require.NoError(t, err)
	require.NoError(t, json.Unmarshal(marshaled, &v))
	assertjson.Equal(t, jsonValue, marshaled)
}

func TestDependenciesAdditionalProperties_MarshalJSON_roundtrip(t *testing.T) {
	var (
		jsonValue = []byte(`{"$id":"feff","$schema":"cebde","$ref":"ebaab","$comment":"fee","title":"acfcc","description":"ba","readOnly":true,"examples":["fa"],"multipleOf":937.049,"maximum":7372.905,"exclusiveMaximum":656.92,"minimum":7958.373,"exclusiveMinimum":8799.476,"maxLength":8269,"minLength":8214,"pattern":"abccf","additionalItems":{"$id":"bca","$schema":"fcaa","$ref":"eced","$comment":"caeedf","title":"bcebd","description":"eaeda","readOnly":true,"examples":["ca"],"multipleOf":8975.313,"maximum":2489.733,"exclusiveMaximum":1204.112,"minimum":7923.336,"exclusiveMinimum":5142.737,"maxLength":7192,"minLength":3209,"pattern":"ecbb","items":{"$id":"cebf","$schema":"ed","$ref":"bbae","$comment":"ea","title":"effe","description":"cfbcac","readOnly":true,"examples":["ddeda"],"multipleOf":7347.664,"maximum":9682.046,"exclusiveMaximum":2876.071,"minimum":2871.947,"exclusiveMinimum":3876.624,"maxLength":8030,"minLength":9187,"pattern":"bb","additionalItems":{"$id":"bc","$schema":"ddeeec","$ref":"cdddbb","$comment":"dbf","title":"cfafc","description":"afd","readOnly":true,"examples":["faaa"],"multipleOf":5919.355,"maximum":8817.027,"exclusiveMaximum":9939.18,"minimum":7761.035,"exclusiveMinimum":11.408,"maxLength":5713,"minLength":9096,"pattern":"bcdfd","items":[{"$id":"ecbe","$schema":"fad","$ref":"ff","$comment":"febd","title":"fead","description":"dd","readOnly":true,"examples":["edffc"],"multipleOf":1276.301,"maximum":1356.835,"exclusiveMaximum":6245.475,"minimum":1594.443,"exclusiveMinimum":8137.128,"maxLength":4453,"minLength":9905,"pattern":"feaeda","additionalItems":{"$id":"cf","$schema":"abbcdd","$ref":"aaeaaa","$comment":"bccdcc","title":"bfd","description":"fe","readOnly":true,"examples":["caf"],"multipleOf":1174.659,"maximum":3405.787,"exclusiveMaximum":5652.17,"minimum":6399.162,"exclusiveMinimum":7075.892,"maxLength":6218,"minLength":8880,"pattern":"ccaddb","items":{"baf":"eb"},"ecac":"ee"},"ccd":"cedbeb"}],"caeeca":"dcef"},"fbcaab":"dc"},"fdb":"afebc"},"dbb":"fb"}`)
		v         DependenciesAdditionalProperties
	)

	require.NoError(t, json.Unmarshal(jsonValue, &v))

	marshaled, err := json.Marshal(v)
	require.NoError(t, err)
	require.NoError(t, json.Unmarshal(marshaled, &v))
	assertjson.Equal(t, jsonValue, marshaled)
}

func TestType_MarshalJSON_roundtrip(t *testing.T) {
	var (
		jsonValue = []byte(`"object"`)
		v         Type
	)

	require.NoError(t, json.Unmarshal(jsonValue, &v))

	marshaled, err := json.Marshal(v)
	require.NoError(t, err)
	require.NoError(t, json.Unmarshal(marshaled, &v))
	assertjson.Equal(t, jsonValue, marshaled)
}

func TestSchemaWithWriteOnly_MarshalJSON_roundtrip(t *testing.T) {
	var (
		jsonValue = []byte(`{"$id":"someid","title":"title","description":"description","writeOnly":true}`)
		v         Schema
	)

	require.NoError(t, json.Unmarshal(jsonValue, &v))
	marshaled, err := json.Marshal(v)
	require.NoError(t, err)
	require.NoError(t, json.Unmarshal(marshaled, &v))
	assertjson.Equal(t, jsonValue, marshaled)
}

func TestSchemaWithDeprecated_MarshalJSON_roundtrip(t *testing.T) {
	var (
		jsonValue = []byte(`{"$id":"someid","title":"title","description":"description","deprecated":true}`)
		v         Schema
	)

	require.NoError(t, json.Unmarshal(jsonValue, &v))
	marshaled, err := json.Marshal(v)
	require.NoError(t, err)
	require.NoError(t, json.Unmarshal(marshaled, &v))
	assertjson.Equal(t, jsonValue, marshaled)
}
