/*******************************************************************************
 * Copyright (c) 2021 Red Hat, Inc.
 * Distributed under license by Red Hat, Inc. All rights reserved.
 * This program is made available under the terms of the
 * Eclipse Public License v2.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 * Red Hat, Inc.
 ******************************************************************************/
package schema

type Pom struct {
	Dependencies struct {
		Text       string `xml:",chardata"`
		Dependency []struct {
			Text       string `xml:",chardata"`
			GroupId    string `xml:"groupId"`
			ArtifactId string `xml:"artifactId"`
			Version    string `xml:"version"`
			Scope      string `xml:"scope"`
		} `xml:"dependency"`
	} `xml:"dependencies"`
	Modules struct {
		Module string `xml:"module"`
	} `xml:"modules,omitempty"`
	Build struct {
		Plugins struct {
			Plugin []struct {
				GroupId       string `xml:"groupId"`
				ArtifactId    string `xml:"artifactId"`
				Version       string `xml:"version"`
				Scope         string `xml:"scope"`
				Configuration struct {
					JavaOpts string `xml:"javaOpts"`
				} `xml:"configuration"`
			} `xml:"plugin"`
		} `xml:"plugins"`
	} `xml:"build,omitempty"`
	ArtifactId string `xml:"artifactId"`
	Profiles   struct {
		Profile []struct {
			Build struct {
				Plugins struct {
					Plugin []struct {
						GroupId       string `xml:"groupId"`
						ArtifactId    string `xml:"artifactId"`
						Version       string `xml:"version"`
						Scope         string `xml:"scope"`
						Configuration struct {
							JavaOpts string `xml:"javaOpts"`
						} `xml:"configuration"`
					} `xml:"plugin"`
				} `xml:"plugins"`
			} `xml:"build,omitempty"`
		} `xml:"profile"`
	} `xml:"profiles"`
}
