/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.json;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.integration.support.json.JsonObjectMapperAdapter;
import org.springframework.util.ClassUtils;

public abstract class AbstractJacksonJsonObjectMapper<N, P, J>
extends JsonObjectMapperAdapter<N, P>
implements BeanClassLoaderAware {
    protected static final Collection<Class<?>> supportedJsonTypes = Arrays.asList(String.class, byte[].class, File.class, URL.class, InputStream.class, Reader.class);
    private volatile ClassLoader classLoader = ClassUtils.getDefaultClassLoader();

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public <T> T fromJson(Object json, Class<T> valueType) throws Exception {
        return this.fromJson(json, this.constructType(valueType));
    }

    @Override
    public <T> T fromJson(Object json, Map<String, Object> javaTypes) throws Exception {
        J javaType = this.extractJavaType(javaTypes);
        return this.fromJson(json, javaType);
    }

    protected J createJavaType(Map<String, Object> javaTypes, String javaTypeKey) throws Exception {
        Object classValue = javaTypes.get(javaTypeKey);
        if (classValue == null) {
            throw new IllegalArgumentException("Could not resolve '" + javaTypeKey + "' in 'javaTypes'.");
        }
        Class aClass = null;
        aClass = classValue instanceof Class ? (Class)classValue : ClassUtils.forName((String)classValue.toString(), (ClassLoader)this.classLoader);
        return this.constructType(aClass);
    }

    protected abstract <T> T fromJson(Object var1, J var2) throws Exception;

    protected abstract J extractJavaType(Map<String, Object> var1) throws Exception;

    protected abstract J constructType(Type var1);
}

