/*
 * Decompiled with CFR 0.152.
 */
package io.konveyor.tackle.core.internal;

import io.konveyor.tackle.core.internal.RuleEntryParams;
import io.konveyor.tackle.core.internal.SymbolInformationTypeRequestor;
import io.konveyor.tackle.core.internal.query.AnnotationQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.search.JavaSearchParticipant;
import org.eclipse.jdt.ls.core.internal.IDelegateCommandHandler;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.lsp4j.SymbolInformation;

public class SampleDelegateCommandHandler
implements IDelegateCommandHandler {
    public static final String COMMAND_ID = "io.konveyor.tackle.samplecommand";
    public static final String RULE_ENTRY_COMMAND_ID = "io.konveyor.tackle.ruleEntry";
    private static final String FullAnalysisMode = "full";
    private static final String sourceOnlyAnalysisMode = "source-only";

    public Object executeCommand(String commandId, List<Object> arguments, IProgressMonitor progress) throws Exception {
        switch (commandId) {
            case "io.konveyor.tackle.samplecommand": {
                return "Hello World";
            }
            case "io.konveyor.tackle.ruleEntry": {
                JavaLanguageServerPlugin.logInfo((String)("Here we get the arguments for rule entry: " + arguments));
                RuleEntryParams params = new RuleEntryParams(commandId, arguments);
                return SampleDelegateCommandHandler.search(params.getProjectName(), params.getIncludedPaths(), params.getQuery(), params.getAnnotationQuery(), params.getLocation(), params.getAnalysisMode(), progress);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported command '%s'!", commandId));
    }

    private static void waitForJavaSourceDownloads() {
        JobHelpers.waitForInitializeJobs();
        JobHelpers.waitForBuildJobs((int)300000);
        JobHelpers.waitForDownloadSourcesJobs((int)300000);
    }

    private static SearchPattern mapLocationToSearchPatternLocation(int location, String query) throws Exception {
        Pattern orPattern = Pattern.compile(".*\\(.*\\|.*\\).*");
        if (orPattern.matcher(query).matches()) {
            int startListIndex = query.indexOf("(");
            int endListIndex = query.indexOf(")");
            String startQuery = query.substring(0, startListIndex);
            String endQuery = query.substring(endListIndex + 1, query.length());
            boolean optionalList = endQuery.startsWith("?");
            String listString = query.substring(startListIndex + 1, endListIndex);
            String[] list = listString.split("\\|");
            ArrayList<SearchPattern> l = new ArrayList<SearchPattern>();
            if (optionalList) {
                endQuery = endQuery.substring(1, endQuery.length());
                l.add(SampleDelegateCommandHandler.mapLocationToSearchPatternLocation(location, String.valueOf(startQuery) + endQuery));
            }
            String[] stringArray = list;
            int n = list.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                SearchPattern p = SampleDelegateCommandHandler.mapLocationToSearchPatternLocation(location, String.valueOf(startQuery) + s + endQuery);
                l.add(p);
                ++n2;
            }
            SearchPattern p = l.subList(1, l.size()).stream().reduce((SearchPattern)l.get(0), SearchPattern::createOrPattern);
            return p;
        }
        if (location == 0) {
            JavaLanguageServerPlugin.logInfo((String)("default query passed " + query + ", searching everything"));
            ArrayList<SearchPattern> l = new ArrayList<SearchPattern>();
            SearchPattern p = SampleDelegateCommandHandler.getPatternSingleQuery(10, query);
            if (p != null) {
                l.add(p);
            }
            if ((p = SampleDelegateCommandHandler.getPatternSingleQuery(2, query)) != null) {
                l.add(p);
            }
            if ((p = SampleDelegateCommandHandler.getPatternSingleQuery(3, query)) != null) {
                l.add(p);
            }
            JavaLanguageServerPlugin.logInfo((String)("list of p: " + p));
            p = l.subList(1, l.size()).stream().reduce((SearchPattern)l.get(0), SearchPattern::createOrPattern);
            return p;
        }
        return SampleDelegateCommandHandler.getPatternSingleQuery(location, query);
    }

    private static SearchPattern getPatternSingleQuery(int location, String query) throws Exception {
        int pattern = 2;
        if (!(query.contains("?") && query.contains("*") || location == 11)) {
            JavaLanguageServerPlugin.logInfo((String)"Using full match");
            pattern = 8;
        }
        switch (location) {
            case 4: 
            case 8: 
            case 10: {
                return SearchPattern.createPattern((String)query, (int)0, (int)3, (int)pattern);
            }
            case 1: 
            case 5: {
                return SearchPattern.createPattern((String)query, (int)0, (int)1, (int)pattern);
            }
            case 7: 
            case 9: {
                return SearchPattern.createPattern((String)query, (int)0, (int)2, (int)pattern);
            }
            case 2: {
                if (query.contains(".")) {
                    return SearchPattern.createPattern((String)query, (int)1, (int)0x2000000, (int)18);
                }
                return SearchPattern.createPattern((String)query, (int)1, (int)2, (int)18);
            }
            case 3: {
                return SearchPattern.createPattern((String)query, (int)3, (int)3, (int)pattern);
            }
            case 11: {
                return SearchPattern.createPattern((String)query, (int)2, (int)3, (int)pattern);
            }
            case 12: {
                return SearchPattern.createPattern((String)query, (int)0, (int)64, (int)pattern);
            }
            case 13: {
                return SearchPattern.createPattern((String)query, (int)1, (int)0, (int)2);
            }
        }
        throw new Exception("unable to create search pattern");
    }

    private static List<SymbolInformation> search(String projectName, ArrayList<String> includedPaths, String query, AnnotationQuery annotationQuery, int location, String analsysisMode, IProgressMonitor monitor) throws Exception {
        SearchPattern pattern;
        IJavaSearchScope scope;
        Object warnings;
        IJavaProject project = ProjectUtils.getJavaProject((String)projectName);
        IJavaProject[] targetProjects = project != null ? new IJavaProject[]{project} : ProjectUtils.getJavaProjects();
        JavaLanguageServerPlugin.logInfo((String)("Searching in target project: " + targetProjects));
        int s = 11;
        if (analsysisMode.equals(sourceOnlyAnalysisMode)) {
            JavaLanguageServerPlugin.logInfo((String)"KONVEYOR_LOG: source-only analysis mode only scoping to Sources");
            s = 1;
        } else {
            JavaLanguageServerPlugin.logInfo((String)"KONVEYOR_LOG: waiting for source downloads");
            SampleDelegateCommandHandler.waitForJavaSourceDownloads();
            JavaLanguageServerPlugin.logInfo((String)"KONVEYOR_LOG: waited for source downloads");
        }
        IJavaProject[] iJavaProjectArray = targetProjects;
        int n = targetProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject iJavaProject = iJavaProjectArray[n2];
            List errors = ResourceUtils.getErrorMarkers((IResource)iJavaProject.getProject());
            warnings = ResourceUtils.getWarningMarkers((IResource)iJavaProject.getProject());
            JavaLanguageServerPlugin.logInfo((String)("KONVEYOR_LOG: found errors: " + errors.toString().replace("\n", " ") + " warnings: " + warnings.toString().replace("\n", " ")));
            ++n2;
        }
        if (includedPaths != null && includedPaths.size() > 0) {
            ArrayList<IPackageFragment> includedFragments = new ArrayList<IPackageFragment>();
            warnings = targetProjects;
            int errors = targetProjects.length;
            int n3 = 0;
            while (n3 < errors) {
                IJavaProject proj = warnings[n3];
                IPackageFragment[] iPackageFragmentArray = proj.getPackageFragments();
                int n4 = iPackageFragmentArray.length;
                int n5 = 0;
                while (n5 < n4) {
                    IPackageFragment fragment = iPackageFragmentArray[n5];
                    IPath fragmentPath = fragment.getPath();
                    if (fragmentPath.getFileExtension() == null) {
                        fragmentPath = fragmentPath.removeFirstSegments(1);
                        for (String includedPath : includedPaths) {
                            IPath includedIPath = Path.fromOSString((String)includedPath);
                            if (includedPath.startsWith(proj.getElementName())) {
                                includedIPath = includedIPath.removeFirstSegments(1);
                            }
                            if (includedIPath.segmentCount() > fragmentPath.segmentCount() || includedIPath.matchingFirstSegments(fragmentPath) != includedIPath.segmentCount()) continue;
                            includedFragments.add(fragment);
                        }
                    }
                    ++n5;
                }
                ++n3;
            }
            IJavaElement[] includedElements = new IJavaElement[includedFragments.size()];
            includedElements = includedFragments.toArray(includedElements);
            scope = SearchEngine.createJavaSearchScope((boolean)true, (IJavaElement[])includedElements, (int)s);
        } else {
            scope = SearchEngine.createJavaSearchScope((boolean)true, (IJavaElement[])targetProjects, (int)s);
        }
        JavaLanguageServerPlugin.logInfo((String)("scope: " + scope));
        try {
            pattern = SampleDelegateCommandHandler.mapLocationToSearchPatternLocation(location, query);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logInfo((String)("KONVEYOR_LOG: Unable to get search pattern: " + e.toString().replace("\n", " ")));
            throw e;
        }
        JavaLanguageServerPlugin.logInfo((String)("KONVEYOR_LOG: pattern: " + pattern.toString().replace("\n", " ")));
        SearchEngine searchEngine = new SearchEngine();
        ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>();
        SymbolInformationTypeRequestor requestor = new SymbolInformationTypeRequestor(symbols, 0, monitor, location, query, annotationQuery);
        JavaSearchParticipant participent = new JavaSearchParticipant();
        SearchParticipant[] participents = new SearchParticipant[]{participent};
        try {
            searchEngine.search(pattern, participents, scope, (SearchRequestor)requestor, monitor);
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logInfo((String)("KONVEYOR_LOG: unable to get search " + e.toString().replace("\n", " ")));
        }
        JavaLanguageServerPlugin.logInfo((String)("KONVEYOR_LOG: got: " + requestor.getAllSearchMatches() + " search matches for " + query + " location " + location + " matches" + requestor.getSymbols().size()));
        return requestor.getSymbols();
    }
}

