/*
 * Decompiled with CFR 0.152.
 */
package io.konveyor.tackle.core.internal.symbol;

import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.ConstructorInvocation;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;

public class CustomASTVisitor
extends ASTVisitor {
    private String query;
    private SearchMatch match;
    private boolean symbolMatches;
    private QueryLocation location;

    public CustomASTVisitor(String query, SearchMatch match, QueryLocation location) {
        this.query = query.replaceAll("(?<!\\.)\\*", ".*");
        this.symbolMatches = false;
        this.match = match;
        this.location = location;
    }

    private boolean shouldVisit(ASTNode node) {
        return this.match.getOffset() + this.match.getLength() == node.getStartPosition() + node.getLength();
    }

    public boolean visit(MethodInvocation node) {
        block6: {
            String fullyQualifiedName;
            block7: {
                if (this.location != QueryLocation.METHOD_CALL || !this.shouldVisit((ASTNode)node)) {
                    return true;
                }
                try {
                    ITypeBinding declaringClass;
                    IMethodBinding binding = node.resolveMethodBinding();
                    if (binding == null || (declaringClass = binding.getDeclaringClass()) == null) break block6;
                    if (declaringClass.getErasure() != null) {
                        declaringClass = declaringClass.getErasure();
                    }
                    if (!(fullyQualifiedName = String.valueOf(declaringClass.getQualifiedName()) + "." + binding.getName()).matches(this.query)) break block7;
                    this.symbolMatches = true;
                    return false;
                }
                catch (Exception e) {
                    JavaLanguageServerPlugin.logInfo((String)("KONVEYOR_LOG: error visiting MethodInvocation node: " + e));
                    this.symbolMatches = true;
                    return false;
                }
            }
            JavaLanguageServerPlugin.logInfo((String)("method fqn " + fullyQualifiedName + " did not match with " + this.query));
            return true;
        }
        JavaLanguageServerPlugin.logInfo((String)"failed to get accurate info for MethodInvocation, falling back");
        this.symbolMatches = true;
        return false;
    }

    public boolean visit(ConstructorInvocation node) {
        block5: {
            String fullyQualifiedName;
            block6: {
                if (this.location != QueryLocation.CONSTRUCTOR_CALL || !this.shouldVisit((ASTNode)node)) {
                    return true;
                }
                try {
                    ITypeBinding declaringClass;
                    IMethodBinding binding = node.resolveConstructorBinding();
                    if (binding == null || (declaringClass = binding.getDeclaringClass()) == null) break block5;
                    fullyQualifiedName = declaringClass.getQualifiedName();
                    if (!fullyQualifiedName.matches(this.query)) break block6;
                    this.symbolMatches = true;
                    return false;
                }
                catch (Exception e) {
                    JavaLanguageServerPlugin.logInfo((String)("KONVEYOR_LOG: error visiting ConstructorInvocation node: " + e));
                    this.symbolMatches = true;
                    return false;
                }
            }
            JavaLanguageServerPlugin.logInfo((String)("constructor fqn " + fullyQualifiedName + " did not match with " + this.query));
            return true;
        }
        JavaLanguageServerPlugin.logInfo((String)"failed to get accurate info for ConstructorInvocation, falling back");
        this.symbolMatches = true;
        return false;
    }

    public boolean visit(ClassInstanceCreation node) {
        block5: {
            String fullyQualifiedName;
            block6: {
                if (this.location != QueryLocation.CONSTRUCTOR_CALL || !this.shouldVisit((ASTNode)node)) {
                    return true;
                }
                try {
                    ITypeBinding declaringClass;
                    IMethodBinding binding = node.resolveConstructorBinding();
                    if (binding == null || (declaringClass = binding.getDeclaringClass()) == null) break block5;
                    fullyQualifiedName = declaringClass.getQualifiedName();
                    if (!fullyQualifiedName.matches(this.query)) break block6;
                    this.symbolMatches = true;
                    return false;
                }
                catch (Exception e) {
                    JavaLanguageServerPlugin.logInfo((String)("error visiting ConstructorInvocation node: " + e));
                    this.symbolMatches = true;
                    return false;
                }
            }
            JavaLanguageServerPlugin.logInfo((String)("constructor fqn " + fullyQualifiedName + " did not match with " + this.query));
            return true;
        }
        JavaLanguageServerPlugin.logInfo((String)"failed to get accurate info for ClassInstanceCreation, falling back");
        this.symbolMatches = true;
        return false;
    }

    public boolean symbolMatches() {
        return this.symbolMatches;
    }

    public static enum QueryLocation {
        METHOD_CALL,
        CONSTRUCTOR_CALL;

    }
}

