/*
 * Decompiled with CFR 0.152.
 */
package io.konveyor.tackle.core.internal.symbol;

import io.konveyor.tackle.core.internal.symbol.CustomASTVisitor;
import io.konveyor.tackle.core.internal.symbol.SymbolProvider;
import io.konveyor.tackle.core.internal.symbol.WithQuery;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.search.MethodReferenceMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;

public class MethodCallSymbolProvider
implements SymbolProvider,
WithQuery {
    private String query;

    @Override
    public List<SymbolInformation> get(SearchMatch match) {
        SymbolKind k = this.convertSymbolKind((IJavaElement)match.getElement());
        ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>();
        try {
            MethodReferenceMatch m = (MethodReferenceMatch)match;
            IMethod e = (IMethod)m.getElement();
            SymbolInformation symbol = new SymbolInformation();
            Location location = this.getLocation((IJavaElement)match.getElement(), match);
            symbol.setName(e.getElementName());
            symbol.setKind(this.convertSymbolKind((IJavaElement)e));
            symbol.setContainerName(e.getParent().getElementName());
            symbol.setLocation(location);
            if (this.query.contains(".")) {
                IClassFile cls;
                ICompilationUnit unit = e.getCompilationUnit();
                if (unit == null && (cls = (IClassFile)e.getAncestor(6)) != null) {
                    unit = cls.becomeWorkingCopy(null, null, null);
                }
                if (this.queryQualificationMatches(this.query, unit, location)) {
                    ASTParser astParser = ASTParser.newParser((int)AST.getJLSLatest());
                    astParser.setSource(unit);
                    astParser.setResolveBindings(true);
                    CompilationUnit cu = (CompilationUnit)astParser.createAST(null);
                    CustomASTVisitor visitor = new CustomASTVisitor(this.query, match, CustomASTVisitor.QueryLocation.METHOD_CALL);
                    cu.accept((ASTVisitor)visitor);
                    if (visitor.symbolMatches()) {
                        symbols.add(symbol);
                    }
                }
            } else {
                symbols.add(symbol);
            }
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logInfo((String)("unable to convert for variable: " + String.valueOf(e)));
        }
        return symbols;
    }

    @Override
    public void setQuery(String query) {
        this.query = query;
    }
}

