/*
 * Decompiled with CFR 0.152.
 */
package io.konveyor.tackle.core.internal.symbol;

import io.konveyor.tackle.core.internal.symbol.SymbolProvider;
import io.konveyor.tackle.core.internal.symbol.WithQuery;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.lsp4j.SymbolInformation;

public class ReturnTypeSymbolProvider
implements SymbolProvider,
WithQuery {
    private String query;

    @Override
    public List<SymbolInformation> get(SearchMatch match) throws CoreException {
        ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>();
        try {
            IMethod method = (IMethod)match.getElement();
            String signature = method.getReturnType();
            String[] strings = this.query.split("\\.");
            JavaLanguageServerPlugin.logInfo((String)("signature: " + signature + "query: " + this.query));
            String[] stringArray = strings;
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                String s = string.replaceAll("\\*", "");
                s = s.replaceAll("\\[", "");
                JavaLanguageServerPlugin.logInfo((String)("signature: " + signature + "replaced string" + s));
                if (signature.contains(s)) {
                    JavaLanguageServerPlugin.logInfo((String)s);
                    SymbolInformation symbol = new SymbolInformation();
                    symbol.setName(method.getElementName());
                    symbol.setKind(this.convertSymbolKind((IJavaElement)method));
                    symbol.setContainerName(method.getParent().getElementName());
                    symbol.setLocation(this.getLocation((IJavaElement)method, match));
                    symbols.add(symbol);
                    return symbols;
                }
                ++n2;
            }
            return null;
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logInfo((String)("unable to get for return type: " + String.valueOf(e)));
            return null;
        }
    }

    @Override
    public void setQuery(String query) {
        this.query = query;
    }
}

