/*
 * Decompiled with CFR 0.152.
 */
package io.konveyor.tackle.core.internal.symbol;

import io.konveyor.tackle.core.internal.query.AnnotationQuery;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.core.Annotation;
import org.eclipse.jdt.internal.core.SourceRefElement;

public interface WithAnnotationQuery {
    public AnnotationQuery getAnnotationQuery();

    public void setAnnotationQuery(AnnotationQuery var1);

    /*
     * Enabled aggressive exception aggregation
     */
    default public boolean matchesAnnotationQuery(SearchMatch match, List<Class<? extends SourceRefElement>> matchClasses) {
        if (this.getAnnotationQuery() != null) {
            try {
                IAnnotation[] annotations = matchClasses.stream().filter(c -> c.isInstance(match.getElement())).map(c -> (SourceRefElement)c.cast(match.getElement())).map(this::tryToGetAnnotations).findFirst().orElse(new IAnnotation[0]);
                if (annotations.length == 0) {
                    return false;
                }
                IAnnotation[] iAnnotationArray = annotations;
                int n = annotations.length;
                int n2 = 0;
                while (n2 < n) {
                    IAnnotation annotation = iAnnotationArray[n2];
                    String fqn = this.getFQN(annotation);
                    if (Pattern.matches(this.getAnnotationQuery().getType(), fqn)) {
                        if (this.getAnnotationQuery().getElements() != null && !this.getAnnotationQuery().getElements().entrySet().isEmpty()) {
                            IMemberValuePair[] memberValuePairs = annotation.getMemberValuePairs();
                            Set<Map.Entry<String, String>> annotationElements = this.getAnnotationQuery().getElements().entrySet();
                            IMemberValuePair[] iMemberValuePairArray = memberValuePairs;
                            int n3 = memberValuePairs.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IMemberValuePair member = iMemberValuePairArray[n4];
                                for (Map.Entry<String, String> annotationElement : annotationElements) {
                                    if (!annotationElement.getKey().equals(member.getMemberName())) continue;
                                    if (member.getValue() instanceof Object[]) {
                                        Object[] values = (Object[])member.getValue();
                                        return Arrays.stream(values).anyMatch(v -> Pattern.matches((String)annotationElement.getValue(), v.toString()));
                                    }
                                    if (!Pattern.matches(annotationElement.getValue(), member.getValue().toString())) continue;
                                    return true;
                                }
                                ++n4;
                            }
                        } else {
                            return true;
                        }
                    }
                    ++n2;
                }
                return false;
            }
            catch (JavaModelException e) {
                return false;
            }
        }
        return true;
    }

    private IAnnotation[] tryToGetAnnotations(SourceRefElement t) {
        try {
            return t.getAnnotations();
        }
        catch (JavaModelException e) {
            return new IAnnotation[0];
        }
    }

    private String getFQN(IAnnotation annotation) {
        String name = annotation.getElementName();
        if (Pattern.matches(".*\\.", name)) {
            return name;
        }
        return this.tryToGetImports(annotation).stream().filter(i -> i.getElementName().endsWith(name)).findFirst().map(IImportDeclaration::getElementName).orElse("");
    }

    private List<IImportDeclaration> tryToGetImports(IAnnotation annotation) {
        try {
            return Optional.ofNullable(((Annotation)annotation).getCompilationUnit().getImports()).map(iImportDeclarationArray -> Arrays.asList(iImportDeclarationArray)).orElse(List.of());
        }
        catch (Throwable e) {
            e.printStackTrace();
            return List.of();
        }
    }
}

