# Analysis Output

The analyzer engine generates output of the analysis in a YAML file specified by `--output-file` option in the CLI. 

## Output Structure

The engine takes one or more _Rules_ or _Rulesets_ as input via the `--rules` option. See [passing rules as input](./rules.md#passing-rules-as-input) for more information.

The YAML output of analysis contains a list with each item in the list being a [_Ruleset_](https://github.com/konveyor/analyzer-lsp/blob/0008c1e70ae770d9ca7f73a5b723ce0fa7688b69/output/v1/konveyor/violations.go#L14-L33) type. Each of these rulesets in the output corresponds to its respective input ruleset:

```yaml
- name: ruleset-1  (1)
  description: |   (2)
    Text description about ruleset 1
  tags:            (3)
  - tag1
  violations:      (4)
    rule-1:
      <violation>
  errors:          (5)
    rule-2: "failed to evaluate"
  unmatched:       (6)
  - rule-2
  skipped:         (7)
  - rule-3
```

1. **name**: Name of the input ruleset for which output is generated.
2. **description**: Description of the ruleset copied from input ruleset.
3. **tags**: A list of tags generated by all the matched "Tagging" rules in the ruleset. (See [Tag Action](./rules.md#tag-action))
4. **violations**: A map containing a [Violation](https://github.com/konveyor/analyzer-lsp/blob/0008c1e70ae770d9ca7f73a5b723ce0fa7688b69/output/v1/konveyor/violations.go#L52-L74) type for every matched rule in the ruleset. (Keys are Rule IDs and values are their respective _Violations_)
5. **errors**: A map containing error strings for rules that the engine failed to evaluate. (Keys are Rule IDs and values are error strings indicating evaluation error)
6. **unmatched**: A list of Rule IDs in the ruleset that were evaluated but not matched.
7. **skipped**: A list of Rule IDs in the ruleset that were skipped because they didn't match the input label selector. (See [Label Selector](./labels.md#rule-label-selector))


### Violations

For every rule that is matched, the analyzer engine creates a _Violation_ in the output. 

* **description**: Text description about the match copied as-is from the rule. (See [Rule Metadata](./rules.md#rule-metadata))

* **category**: Pre-defined category string that indicates impact / severity of the problem. It is copied as-is from the rule. (See [Rule Categories](./rules.md#rule-categories))

* **labels**: A list of string labels copied as-is from the rule. (See [Rule Metadata](./rules.md#rule-metadata))

* **links**: A list of hyperlinks provided copied as-is from the rule. (See [Rule Links](./rules.md#links))
  * Each item in the list is a struct with following fields:
    * **url**: URL string.
    * **title**: Title string.

* **incidents**: A list of [_Incident_](https://github.com/konveyor/analyzer-lsp/blob/0008c1e70ae770d9ca7f73a5b723ce0fa7688b69/output/v1/konveyor/violations.go#L77-L87) type indicating a match of the rule in the source code.
  * There can be multiple matches of a rule. Each such incident has following fields:
    * **uri**: File uri in the source code where the rule was matched.
    * **lineNumber**: The line number in the file where match was found.
    * **message**: A message copied as-is from the rule. (See [Message Action](./rules.md#message-action))
    * **codeSnip**: Relevant lines from the source code where the rule was matched.
    * **variables**: A map containing values of matched _CustomVariables_ in the rule. (See [Custom Variables](./rules.md#custom-variables))

* **effort**: Integer indicating story points for each incident as determined by the rule author. (See [Rule Metadata](./rules.md#rule-metadata))

### User Interface for Analysis Output

There is a standalone user interface available to visualize the YAML output in a static UI that runs in the browser. Check it out [here](https://github.com/konveyor/static-report). The [README](https://github.com/konveyor/static-report#readme) explains how it works with the YAML output.

