# Kai Terminology

This document contains definitions for terms used in the Kai project.

- [Kai Terminology](#kai-terminology)
  - [Agent](#agent)
  - [Generative AI (GenAI)](#generative-ai-genai)
  - [LLM (Large Language Model)](#llm-large-language-model)

## Agent

An **agent** refers to a system or program that is capable of autonomously
performing tasks on behalf of a user or another system by designing its workflow
and utilizing available tools.

AI agents can encompass a wide range of functionalities beyond natural language
processing including decision-making, problem-solving, interacting with external
environments and executing actions.

These agents can be deployed in various applications to solve complex tasks in
various enterprise contexts from software design and IT automation to
code-generation tools and conversational assistants. They use the advanced
natural language processing techniques of large language models (LLMs) to
comprehend and respond to user inputs step-by-step and determine when to call on
external tools.

Source: [IBM](https://www.ibm.com/think/topics/ai-agents)

## Generative AI (GenAI)

**Generative AI** refers to deep-learning models that can take raw data — say,
all of Wikipedia or the collected works of Rembrandt — and “learn” to generate
statistically probable outputs when prompted. At a high level, generative models
encode a simplified representation of their training data and draw from it to
create a new work that’s similar, but not identical, to the original data.

Source: [IBM](https://research.ibm.com/blog/what-is-generative-AI)

## LLM (Large Language Model)

In a nutshell, **LLMs** are designed to understand and generate text like a
human, in addition to other forms of content, based on the vast amount of data
used to train them. They have the ability to infer from context, generate
coherent and contextually relevant responses, translate to languages other than
English, summarize text, answer questions (general conversation and FAQs) and
even assist in creative writing or code generation tasks.

Source: [IBM](https://www.ibm.com/topics/large-language-models)
