/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.bridge.FieldBridge;
import org.hibernate.search.query.dsl.TermMatchingContext;
import org.hibernate.search.query.dsl.TermTermination;
import org.hibernate.search.query.dsl.impl.ConnectedMultiFieldsTermQueryBuilder;
import org.hibernate.search.query.dsl.impl.FieldBridgeCustomization;
import org.hibernate.search.query.dsl.impl.FieldsContext;
import org.hibernate.search.query.dsl.impl.QueryBuildingContext;
import org.hibernate.search.query.dsl.impl.QueryCustomizer;
import org.hibernate.search.query.dsl.impl.TermQueryContext;

public class ConnectedTermMatchingContext
implements TermMatchingContext,
FieldBridgeCustomization<TermMatchingContext> {
    private final QueryBuildingContext queryContext;
    private final QueryCustomizer queryCustomizer;
    private final TermQueryContext termContext;
    private final FieldsContext fieldsContext;

    public ConnectedTermMatchingContext(TermQueryContext termContext, String field, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.termContext = termContext;
        this.fieldsContext = new FieldsContext(new String[]{field}, queryContext);
    }

    public ConnectedTermMatchingContext(TermQueryContext termContext, String[] fields, QueryCustomizer queryCustomizer, QueryBuildingContext queryContext) {
        this.queryContext = queryContext;
        this.queryCustomizer = queryCustomizer;
        this.termContext = termContext;
        this.fieldsContext = new FieldsContext(fields, queryContext);
    }

    @Override
    public TermTermination matching(Object value) {
        return new ConnectedMultiFieldsTermQueryBuilder(this.termContext, value, this.fieldsContext, this.queryCustomizer, this.queryContext);
    }

    @Override
    public TermMatchingContext andField(String field) {
        this.fieldsContext.add(field);
        return this;
    }

    @Override
    public TermMatchingContext boostedTo(float boost) {
        this.fieldsContext.boostedTo(boost);
        return this;
    }

    @Override
    public TermMatchingContext ignoreAnalyzer() {
        this.fieldsContext.ignoreAnalyzer();
        return this;
    }

    @Override
    public TermMatchingContext ignoreFieldBridge() {
        this.fieldsContext.ignoreFieldBridge();
        return this;
    }

    @Override
    public TermMatchingContext withFieldBridge(FieldBridge fieldBridge) {
        this.fieldsContext.withFieldBridge(fieldBridge);
        return this;
    }
}

