/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.business.jaxws;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.Annuity;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.AnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.AnnuityValueObject;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.Contact;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.Payor;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.Payout;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.PayoutValueObject;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.Rider;
import com.ibm.wssvt.acme.annuity.common.business.AnnuityBusinessServiceLookup;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.business.jaxws.AnnuityMgmtSvcJAXWS;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerBusinessModuleException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityLoggerFactory;
import com.ibm.wssvt.acme.annuity.common.util.RunningServerInfo;
import com.ibm.wssvt.acme.common.bean.Configrable;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;

public class JAXWSBusinessBaseProxyJCDI
implements AnnuityMgmtSvcJAXWS {
    @Inject
    AnnuityValueObject avo;

    @Override
    public AnnuityValueObject createAnnuity(AnnuityValueObject annuityVO) throws ServerBusinessModuleException, ServerPersistenceModuleException, EntityAlreadyExistsException, InvalidArgumentException {
        this.checkAnnuityValueObject(annuityVO);
        IAnnuity annuity = annuityVO.getAnnuity();
        AcmeLogger logger = this.getLogger(annuity);
        try {
            annuity = (Annuity)this.getAnnuityService(annuity).createAnnuity(annuity);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        RunningServerInfo.getInstance().setRunningServerInfo(annuity);
        if (this.avo != null) {
            logger.fine("JCDI is enabled successfully");
            this.avo.setAnnuity(annuity);
            logger.fine("create annuity - ready to return. result annuityVO: " + this.avo);
            return this.avo;
        }
        System.out.println("Failed to enable JCDI");
        return null;
    }

    @Override
    public AnnuityHolder createAnnuityHolder(AnnuityHolder annHolder) throws ServerBusinessModuleException, ServerPersistenceModuleException, EntityAlreadyExistsException, InvalidArgumentException {
        this.checkConfigrableArgument(annHolder);
        AnnuityHolder results = null;
        try {
            results = (AnnuityHolder)this.getAnnuityService(annHolder).createAnnuityHolder(annHolder);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        RunningServerInfo.getInstance().setRunningServerInfo(results);
        return results;
    }

    @Override
    public Contact createContact(Contact contact) throws ServerBusinessModuleException, ServerPersistenceModuleException, EntityAlreadyExistsException, InvalidArgumentException {
        this.checkConfigrableArgument(contact);
        Contact results = null;
        try {
            results = (Contact)this.getAnnuityService(contact).createContact(contact);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        RunningServerInfo.getInstance().setRunningServerInfo(results);
        return results;
    }

    @Override
    public Payor createPayor(Payor payor) throws ServerBusinessModuleException, ServerPersistenceModuleException, EntityAlreadyExistsException, InvalidArgumentException {
        this.checkConfigrableArgument(payor);
        Payor results = null;
        try {
            results = (Payor)this.getAnnuityService(payor).createPayor(payor);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        RunningServerInfo.getInstance().setRunningServerInfo(results);
        return results;
    }

    @Override
    public PayoutValueObject createPayout(PayoutValueObject payoutVO) throws ServerBusinessModuleException, ServerPersistenceModuleException, EntityAlreadyExistsException, InvalidArgumentException {
        this.checkPayoutValueObject(payoutVO);
        Payout results = null;
        try {
            results = (Payout)this.getAnnuityService(payoutVO.getPayout()).createPayout(payoutVO.getPayout());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        RunningServerInfo.getInstance().setRunningServerInfo(results);
        PayoutValueObject resObject = new PayoutValueObject();
        resObject.setPayout(results);
        return resObject;
    }

    @Override
    public void deleteAnnuity(AnnuityValueObject annuityVO) throws ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkAnnuityValueObject(annuityVO);
        try {
            this.getAnnuityService(annuityVO.getAnnuity()).deleteAnnuity(annuityVO.getAnnuity());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
    }

    @Override
    public void deleteAnnuityHolder(AnnuityHolder annHolder) throws ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkConfigrableArgument(annHolder);
        try {
            this.getAnnuityService(annHolder).deleteAnnuityHolder(annHolder);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
    }

    @Override
    public void deleteContact(Contact contact) throws ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkConfigrableArgument(contact);
        try {
            this.getAnnuityService(contact).deleteContact(contact);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
    }

    @Override
    public void deletePayor(Payor payor) throws ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkConfigrableArgument(payor);
        try {
            this.getAnnuityService(payor).deletePayor(payor);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
    }

    @Override
    public void deletePayout(PayoutValueObject payoutVO) throws ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkPayoutValueObject(payoutVO);
        try {
            this.getAnnuityService(payoutVO.getPayout()).deletePayout(payoutVO.getPayout());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
    }

    @Override
    public void deleteRider(Rider rider) throws ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkConfigrableArgument(rider);
        try {
            this.getAnnuityService(rider).deleteRider(rider);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
    }

    @Override
    public AnnuityValueObject findAnnuityById(AnnuityValueObject annuityVO) throws EntityNotFoundException, ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkAnnuityValueObject(annuityVO);
        AnnuityValueObject results = null;
        try {
            IAnnuity ann = this.getAnnuityService(annuityVO.getAnnuity()).findAnnuityById(annuityVO.getAnnuity());
            RunningServerInfo.getInstance().setRunningServerInfo(ann);
            results = new AnnuityValueObject();
            results.setAnnuity(ann);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        return results;
    }

    @Override
    public AnnuityHolder findAnnuityHolder(AnnuityValueObject annuityVO) throws EntityNotFoundException, ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkAnnuityValueObject(annuityVO);
        AnnuityHolder results = null;
        try {
            results = (AnnuityHolder)this.getAnnuityService(annuityVO.getAnnuity()).findAnnuityHolder(annuityVO.getAnnuity());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        RunningServerInfo.getInstance().setRunningServerInfo(results);
        return results;
    }

    @Override
    public Contact findContactById(Contact contact) throws EntityNotFoundException, ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkConfigrableArgument(contact);
        Contact results = null;
        try {
            results = (Contact)this.getAnnuityService(contact).findContactById(contact);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        RunningServerInfo.getInstance().setRunningServerInfo(results);
        return results;
    }

    @Override
    public List<AnnuityValueObject> findHolderAnnuities(AnnuityHolder annuityHolder) throws ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkConfigrableArgument(annuityHolder);
        ArrayList<AnnuityValueObject> results = new ArrayList<AnnuityValueObject>();
        try {
            List<IAnnuity> annuities = this.getAnnuityService(annuityHolder).findHolderAnnuities(annuityHolder);
            for (IAnnuity annuity : annuities) {
                RunningServerInfo.getInstance().setRunningServerInfo(annuity);
                AnnuityValueObject annVo = new AnnuityValueObject();
                annVo.setAnnuity(annuity);
                results.add(annVo);
            }
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        return results;
    }

    @Override
    public AnnuityHolder findHolderById(AnnuityHolder annuityHolder) throws EntityNotFoundException, ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkConfigrableArgument(annuityHolder);
        AnnuityHolder results = null;
        try {
            results = (AnnuityHolder)this.getAnnuityService(annuityHolder).findHolderById(annuityHolder);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        RunningServerInfo.getInstance().setRunningServerInfo(results);
        return results;
    }

    @Override
    public List<AnnuityValueObject> findPayorAnnuities(Payor payor) throws ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkConfigrableArgument(payor);
        ArrayList<AnnuityValueObject> results = new ArrayList<AnnuityValueObject>();
        try {
            List<IAnnuity> annuities = this.getAnnuityService(payor).findPayorAnnuities(payor);
            for (IAnnuity annuity : annuities) {
                RunningServerInfo.getInstance().setRunningServerInfo(annuity);
                AnnuityValueObject annVo = new AnnuityValueObject();
                annVo.setAnnuity(annuity);
                results.add(annVo);
            }
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        return results;
    }

    @Override
    public Payor findPayorById(Payor payor) throws EntityNotFoundException, ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkConfigrableArgument(payor);
        Payor results = null;
        try {
            results = (Payor)this.getAnnuityService(payor).findPayorById(payor);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        RunningServerInfo.getInstance().setRunningServerInfo(results);
        return results;
    }

    @Override
    public PayoutValueObject findPayoutById(PayoutValueObject payoutVO) throws EntityNotFoundException, ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkPayoutValueObject(payoutVO);
        Payout results = null;
        try {
            results = (Payout)this.getAnnuityService(payoutVO.getPayout()).findPayoutById(payoutVO.getPayout());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        RunningServerInfo.getInstance().setRunningServerInfo(results);
        PayoutValueObject pvoResult = new PayoutValueObject();
        pvoResult.setPayout(results);
        return pvoResult;
    }

    @Override
    public Rider findRiderById(Rider rider) throws EntityNotFoundException, ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkConfigrableArgument(rider);
        Rider results = null;
        try {
            results = (Rider)this.getAnnuityService(rider).findRiderById(rider);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        RunningServerInfo.getInstance().setRunningServerInfo(results);
        return results;
    }

    @Override
    public AnnuityValueObject updateAnnuity(AnnuityValueObject annuityVO) throws ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkAnnuityValueObject(annuityVO);
        IAnnuity annuity = annuityVO.getAnnuity();
        try {
            annuity = (Annuity)this.getAnnuityService(annuity).updateAnnuity(annuity);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        RunningServerInfo.getInstance().setRunningServerInfo(annuity);
        AnnuityValueObject result = new AnnuityValueObject();
        result.setAnnuity(annuity);
        return result;
    }

    @Override
    public AnnuityHolder updateAnnuityHolder(AnnuityHolder annHolder) throws ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkConfigrableArgument(annHolder);
        AnnuityHolder results = null;
        try {
            results = (AnnuityHolder)this.getAnnuityService(annHolder).updateAnnuityHolder(annHolder);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        RunningServerInfo.getInstance().setRunningServerInfo(results);
        return results;
    }

    @Override
    public Contact updateContact(Contact contact) throws ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkConfigrableArgument(contact);
        Contact results = null;
        try {
            results = (Contact)this.getAnnuityService(contact).updateContact(contact);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        RunningServerInfo.getInstance().setRunningServerInfo(results);
        return results;
    }

    @Override
    public Payor updatePayor(Payor payor) throws ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkConfigrableArgument(payor);
        Payor results = null;
        try {
            results = (Payor)this.getAnnuityService(payor).updatePayor(payor);
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        RunningServerInfo.getInstance().setRunningServerInfo(results);
        return results;
    }

    @Override
    public PayoutValueObject updatePayout(PayoutValueObject payoutVO) throws ServerBusinessModuleException, ServerPersistenceModuleException, InvalidArgumentException {
        this.checkPayoutValueObject(payoutVO);
        Payout results = null;
        try {
            results = (Payout)this.getAnnuityService(payoutVO.getPayout()).updatePayout(payoutVO.getPayout());
        }
        catch (ServerInternalErrorException e) {
            this.convertServerException((Exception)((Object)e));
        }
        RunningServerInfo.getInstance().setRunningServerInfo(results);
        PayoutValueObject pvoResult = new PayoutValueObject();
        pvoResult.setPayout(results);
        return pvoResult;
    }

    private void checkConfigrableArgument(Configrable<String, String> configrable) throws InvalidArgumentException {
        if (configrable == null) {
            throw new InvalidArgumentException("The input parameter is invalid.  It null.");
        }
        if (configrable.getConfiguration() == null) {
            throw new InvalidArgumentException("The input parameter has null configuration. It is invalid.");
        }
    }

    private void checkAnnuityValueObject(AnnuityValueObject annuityVO) throws InvalidArgumentException {
        if (annuityVO == null) {
            throw new InvalidArgumentException("The AnnuityValueObject parameter is invalid.  It is null");
        }
        if (annuityVO.getAnnuity() == null) {
            throw new InvalidArgumentException("The AnnuityValueObject contains no valid Annuity");
        }
        this.checkConfigrableArgument(annuityVO.getAnnuity());
    }

    private void checkPayoutValueObject(PayoutValueObject payoutVO) throws InvalidArgumentException {
        if (payoutVO == null) {
            throw new InvalidArgumentException("The PayoutValueObject parameter is invalid.  It is null");
        }
        if (payoutVO.getPayout() == null) {
            throw new InvalidArgumentException("The PayoutValueObject contains no valid Payout");
        }
        this.checkConfigrableArgument(payoutVO.getPayout());
    }

    private AcmeLogger getLogger(Configrable<String, String> configrable) {
        return AnnuityLoggerFactory.getAcmeServerLogger(configrable, this.getClass().getName());
    }

    private void convertServerException(Exception e) throws ServerPersistenceModuleException, ServerBusinessModuleException {
        if (e instanceof ServerInternalErrorException) {
            if (e instanceof ServerPersistenceModuleException) {
                throw new ServerPersistenceModuleException(e);
            }
            throw new ServerBusinessModuleException(e);
        }
        if (e instanceof RemoteException) {
            throw new ServerBusinessModuleException("Remote Exception" + e.getMessage(), e);
        }
        throw new ServerBusinessModuleException("Unknown Server Exception: " + e.getMessage(), e);
    }

    protected IAnnuityService getAnnuityService(Configrable<String, String> configrable) throws ServerBusinessModuleException {
        try {
            return new AnnuityBusinessServiceLookup().getAnnuityAnnuityService(configrable);
        }
        catch (Exception e) {
            AcmeLogger logger = this.getLogger(configrable);
            logger.info("Annuity Service lookup returned the error:" + e.getMessage());
            throw new ServerBusinessModuleException(e.getMessage(), e);
        }
    }
}

