/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.client.adapter.EJB31AsynchServerAdapter;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.util.AnnuityType;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;

public class AsynchMethodHelper {
    private static final int DEFAULT_MAX_LOOPS = 100;
    private static final int DEFAULT_ASYNCH_WAIT = 10;

    public static void verifyContactDelete(IContact contact, AbastractAnnuityExecutionUnit eu, AcmeLogger logger) throws InvalidExecutionUnitParameterException, InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException, InterruptedException, ExecutionUnitVerificationException {
        if (AsynchMethodHelper.isFireForgetVerficationDisabled(eu)) {
            return;
        }
        IContact results = null;
        IContact result = eu.getAnnuityBeansFactory().createContact();
        result.setId(contact.getId());
        result.setConfiguration(eu.getConfiguration());
        try {
            results = eu.getServerAdapter().findContactById(result);
            int asynchMethodMaxLoops = AsynchMethodHelper.getAsynchMaxLoops(eu);
            for (int loop = 0; AsynchMethodHelper.isFireForgetVerficationEnabled(eu) && results != null && loop <= asynchMethodMaxLoops; ++loop) {
                results = eu.getServerAdapter().findContactById(result);
                logger.info("Waiting for Asynchronous deletion to finish... attempt: " + loop);
                AsynchMethodHelper.waitForAsynchMethod(eu);
            }
            if (results != null) {
                throw new AsynchMethodVerificationException((String)contact.getId());
            }
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
    }

    public static void verifyPayerDelete(IPayor payor, AbastractAnnuityExecutionUnit eu, AcmeLogger logger) throws InvalidExecutionUnitParameterException, InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException, InterruptedException, ExecutionUnitVerificationException {
        if (AsynchMethodHelper.isFireForgetVerficationDisabled(eu)) {
            return;
        }
        IPayor results = null;
        IPayor result = eu.getAnnuityBeansFactory().createPayor();
        result.setId(payor.getId());
        result.setConfiguration(eu.getConfiguration());
        try {
            results = eu.getServerAdapter().findPayorById(result);
            int asynchMethodMaxLoops = AsynchMethodHelper.getAsynchMaxLoops(eu);
            for (int loop = 0; AsynchMethodHelper.isFireForgetVerficationEnabled(eu) && results != null && loop <= asynchMethodMaxLoops; ++loop) {
                results = eu.getServerAdapter().findPayorById(result);
                logger.info("Waiting for Asynchronous deletion to finish... attempt: " + loop);
                AsynchMethodHelper.waitForAsynchMethod(eu);
            }
            if (results != null) {
                throw new AsynchMethodVerificationException((String)payor.getId());
            }
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
    }

    public static void verifyHolderDelete(IAnnuityHolder holder, AbastractAnnuityExecutionUnit eu, AcmeLogger logger) throws InvalidExecutionUnitParameterException, InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException, InterruptedException, ExecutionUnitVerificationException {
        if (AsynchMethodHelper.isFireForgetVerficationDisabled(eu)) {
            return;
        }
        IAnnuityHolder results = null;
        IAnnuityHolder result = eu.getAnnuityBeansFactory().createAnnuityHolder();
        result.setId(holder.getId());
        result.setConfiguration(eu.getConfiguration());
        try {
            results = eu.getServerAdapter().findHolderById(result);
            int asynchMethodMaxLoops = AsynchMethodHelper.getAsynchMaxLoops(eu);
            for (int loop = 0; AsynchMethodHelper.isFireForgetVerficationEnabled(eu) && results != null && loop <= asynchMethodMaxLoops; ++loop) {
                results = eu.getServerAdapter().findHolderById(result);
                logger.info("Waiting for Asynchronous deletion to finish... attempt: " + loop);
                AsynchMethodHelper.waitForAsynchMethod(eu);
            }
            if (results != null) {
                throw new AsynchMethodVerificationException((String)holder.getId());
            }
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
    }

    public static void verifyAnnuityDelete(IAnnuity annuity, AnnuityType annuityType, AbastractAnnuityExecutionUnit eu, AcmeLogger logger) throws InvalidExecutionUnitParameterException, InvalidArgumentException, ServerInternalErrorException, ServerAdapterCommunicationException, RemoteException, InterruptedException, ExecutionUnitVerificationException {
        if (AsynchMethodHelper.isFireForgetVerficationDisabled(eu)) {
            return;
        }
        IAnnuity results = null;
        IAnnuity result = BasicExecutionUnitLibrarry.getAnnuity(eu.getAnnuityBeansFactory(), annuityType);
        result.setId(annuity.getId());
        result.setConfiguration(eu.getConfiguration());
        try {
            results = eu.getServerAdapter().findAnnuityById(result);
            int asynchMethodMaxLoops = AsynchMethodHelper.getAsynchMaxLoops(eu);
            for (int loop = 0; AsynchMethodHelper.isFireForgetVerficationEnabled(eu) && results != null && loop <= asynchMethodMaxLoops; ++loop) {
                results = eu.getServerAdapter().findAnnuityById(result);
                logger.info("Waiting for Asynchronous deletion to finish... attempt: " + loop);
                AsynchMethodHelper.waitForAsynchMethod(eu);
            }
            if (results != null) {
                throw new AsynchMethodVerificationException((String)annuity.getId());
            }
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
    }

    private static int getAsynchMaxLoops(AbastractAnnuityExecutionUnit eu) {
        try {
            return eu.getParameterValueInt("asynch.method.max.loops");
        }
        catch (InvalidExecutionUnitParameterException ex1) {
            try {
                return Integer.parseInt((String)eu.getServerAdapter().getConfiguration().getParameterValue((Object)"asynch.method.max.loops"));
            }
            catch (Exception ex2) {
                return 100;
            }
        }
    }

    private static boolean getFireForgetVerification(AbastractAnnuityExecutionUnit eu) {
        try {
            return eu.getParameterValueBoolean("fire.and.forget.verify");
        }
        catch (InvalidExecutionUnitParameterException ex1) {
            try {
                return Boolean.parseBoolean((String)eu.getServerAdapter().getConfiguration().getParameterValue((Object)"fire.and.forget.verify"));
            }
            catch (Exception ex2) {
                return true;
            }
        }
    }

    private static int getAsynchMethodWait(AbastractAnnuityExecutionUnit eu) {
        try {
            return eu.getParameterValueInt("asynch.method.wait");
        }
        catch (InvalidExecutionUnitParameterException ex1) {
            try {
                return Integer.parseInt((String)eu.getServerAdapter().getConfiguration().getParameterValue((Object)"asynch.method.wait"));
            }
            catch (Exception ex2) {
                return 10;
            }
        }
    }

    private static boolean isFireForgetVerficationEnabled(AbastractAnnuityExecutionUnit eu) throws InvalidExecutionUnitParameterException {
        return eu.getServerAdapter().getClass().equals(EJB31AsynchServerAdapter.class) && AsynchMethodHelper.getFireForgetVerification(eu);
    }

    private static boolean isFireForgetVerficationDisabled(AbastractAnnuityExecutionUnit eu) throws InvalidExecutionUnitParameterException {
        return eu.getServerAdapter().getClass().equals(EJB31AsynchServerAdapter.class) && !AsynchMethodHelper.getFireForgetVerification(eu);
    }

    private static void waitForAsynchMethod(AbastractAnnuityExecutionUnit eu) throws InterruptedException, InvalidExecutionUnitParameterException {
        if (eu.getServerAdapter().getClass().equals(EJB31AsynchServerAdapter.class)) {
            Thread.sleep(AsynchMethodHelper.getAsynchMethodWait(eu));
        }
    }

    public static class AsynchMethodVerificationException
    extends ExecutionUnitVerificationException {
        private static final long serialVersionUID = -5980657797922030535L;

        public AsynchMethodVerificationException(String ObjID) {
            super("Deletion of Object with ID = " + ObjID + "was not successful! The object still exists in DB.");
        }
    }
}

