/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit;

import com.ibm.wssvt.acme.annuity.common.client.executionunit.AbastractAnnuityExecutionUnit;
import com.ibm.wssvt.acme.common.executionunit.ExecutionUnitVerificationException;
import com.ibm.wssvt.acme.common.executionunit.InvalidExecutionUnitParameterException;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class ExecuteWebURLEU
extends AbastractAnnuityExecutionUnit {
    private static final long serialVersionUID = 5882648036323517725L;
    private static final String URL_KEY = "url";
    private static final String SUCCESS_MSG_KEY = "successMessage";
    private static final String USE_SECURITY_KEY = "useSecurity";
    private static final String USER_NAME_KEY = "userName";
    private static final String USER_PASSWORD_KEY = "userPassword";
    private static final String WEB_APP_NAME_KEY = "webAppName";
    private static final String BASIC_AUTH = "BASIC_AUTH";
    private static final String FORM_AUTH = "FORM_AUTH";
    private String url = null;
    private String successMsg = null;
    private AcmeLogger logger = null;
    private String useSecurity = "NONE";
    private String userName;
    private String userPassword;
    private URL urlObj;
    private String webAppName;
    private static Map<Long, HttpClient> clients = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        block9: {
            this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
            GetMethod getMethod = null;
            try {
                this.setEUParams();
                HttpClient client = this.getClient();
                getMethod = new GetMethod(this.url);
                int responseCode = client.executeMethod((HttpMethod)getMethod);
                this.logger.fine("URL execution response code is: " + responseCode);
                String response = getMethod.getResponseBodyAsString();
                this.logger.fine("response is: " + response);
                if (this.successMsg == null) {
                    return;
                }
                if (response.indexOf(this.successMsg) > -1) {
                    this.logger.fine("Accessed the URL:" + this.url + " and found Success Criteria");
                    break block9;
                }
                String msg = "Accessed the URL: " + this.url + " but could not find the Success Msg criteria of: '" + this.successMsg + "'";
                this.logger.info(msg);
                this.logger.info("URL Data was: " + response);
                throw new ExecutionUnitVerificationException(msg);
            }
            catch (Exception e) {
                this.getExecutionUnitEvent().addException(e);
            }
            finally {
                if (getMethod != null) {
                    getMethod.releaseConnection();
                }
            }
        }
    }

    private void setEUParams() throws InvalidExecutionUnitParameterException {
        this.url = (String)this.getConfiguration().getParameterValue((Object)URL_KEY);
        if (this.url == null || this.url.trim().length() == 0) {
            String msg = "The URL value is invalid. Its null or empty";
            this.logger.info(msg);
            throw new InvalidExecutionUnitParameterException(msg);
        }
        this.logger.fine("url: " + this.url);
        try {
            this.urlObj = new URL(this.url);
        }
        catch (MalformedURLException e) {
            String msg = "the URL provided is not a valid URL. Current value is: " + this.url + " Got a MalformedURLException when attempted to create a URL object of this URL. Error is: " + e;
            throw new InvalidExecutionUnitParameterException(msg);
        }
        this.successMsg = (String)this.getConfiguration().getParameterValue((Object)SUCCESS_MSG_KEY);
        if (this.successMsg == null || this.successMsg.trim().length() == 0) {
            this.logger.warning("success Message for this url is null. This EU will not validate the Web Execution!!!");
            this.successMsg = null;
        }
        this.logger.fine("successMsg: " + this.successMsg);
        this.useSecurity = (String)this.getConfiguration().getParameterValue((Object)USE_SECURITY_KEY);
        if (this.useSecurity != null && this.useSecurity.trim().length() >= 0) {
            if (BASIC_AUTH.equalsIgnoreCase(this.useSecurity) || FORM_AUTH.equalsIgnoreCase(this.useSecurity) || "NONE".equalsIgnoreCase(this.useSecurity)) {
                this.userName = (String)this.getConfiguration().getParameterValue((Object)USER_NAME_KEY);
                this.userPassword = (String)this.getConfiguration().getParameterValue((Object)USER_PASSWORD_KEY);
                if (this.userName == null || this.userName.trim().length() == 0) {
                    String msg = "Connection to web is set to use security, but the userName is null or empty.  Current value is: " + this.userName;
                    this.logger.info(msg);
                    throw new InvalidExecutionUnitParameterException(msg);
                }
                if (this.userPassword == null || this.userPassword.trim().length() == 0) {
                    String msg = "Connection to web is set to use security, but the userPassword is null or empty.  Current value is: " + this.userPassword;
                    this.logger.info(msg);
                    throw new InvalidExecutionUnitParameterException(msg);
                }
                if (FORM_AUTH.equalsIgnoreCase(this.useSecurity)) {
                    this.webAppName = (String)this.getConfiguration().getParameterValue((Object)WEB_APP_NAME_KEY);
                    if (this.webAppName == null || this.webAppName.trim().length() == 0) {
                        String msg = "Connection to web is set to use FORM security, but the webAppName is null or empty.  Current value is: " + this.webAppName;
                        this.logger.info(msg);
                        throw new InvalidExecutionUnitParameterException(msg);
                    }
                    this.logger.fine("useSecurity: " + this.useSecurity);
                    this.logger.fine("userName: " + this.userName);
                    this.logger.fine("userPassword: " + this.userPassword);
                    this.logger.fine("webAppName: " + this.webAppName);
                }
                if ("NONE".equalsIgnoreCase(this.useSecurity)) {
                    this.logger.info("the useSecurity is set to NONE.  Security will not be used.");
                }
            } else {
                throw new InvalidExecutionUnitParameterException("The useSecurity key is not valid.  valid values are BASIC_AUTH, FORM_AUTH, or NONE. Provided value is: " + this.useSecurity);
            }
        }
    }

    private synchronized HttpClient getClient() {
        HttpClient client = clients.get(Thread.currentThread().getId());
        if (client == null) {
            this.logger.fine("starting a new client.");
            client = new HttpClient();
            clients.put(Thread.currentThread().getId(), client);
            if (BASIC_AUTH.equalsIgnoreCase(this.useSecurity)) {
                this.logger.fine("using BASIC AUTH Security");
                this.loginWithBasicAuth(client);
            }
            if (FORM_AUTH.equalsIgnoreCase(this.useSecurity)) {
                this.logger.fine("using FORM AUTH Security");
                this.loginWithFormAuth(client);
            }
        }
        return client;
    }

    private void loginWithFormAuth(HttpClient client) {
        this.logger.fine("Setting the client for FORM AUTH Security.");
        NameValuePair[] data = new NameValuePair[]{new NameValuePair("j_username", this.userName), new NameValuePair("j_password", this.userPassword), new NameValuePair("Login", "login")};
        String loginURL = this.urlObj.getProtocol() + "://" + this.urlObj.getHost() + ":" + this.urlObj.getPort() + "/" + this.webAppName + "/j_security_check";
        this.logger.fine("the POST url for the Form Security is: " + loginURL);
        PostMethod loginPost = new PostMethod(loginURL);
        loginPost.addParameters(data);
        try {
            int responseCode = client.executeMethod((HttpMethod)loginPost);
            this.logger.fine("response code is: " + responseCode);
        }
        catch (HttpException e) {
            String msg = "Unexpected HTTPException when executing the post method with url: " + loginURL + " Error: " + (Object)((Object)e);
            this.logger.info(msg);
            throw new RuntimeException(msg, e);
        }
        catch (IOException e) {
            String msg = "Unexpected IOException when executing the post method with url: " + loginURL + " Error: " + e;
            this.logger.info(msg);
            throw new RuntimeException(msg, e);
        }
        finally {
            loginPost.releaseConnection();
        }
        this.logger.fine("client is ready with form security");
    }

    private void loginWithBasicAuth(HttpClient client) {
        this.logger.fine("Setting the client for BASIC AUTH Security.");
        client.getParams().setAuthenticationPreemptive(true);
        UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.userName, this.userPassword);
        AuthScope authScope = new AuthScope(this.urlObj.getHost(), this.urlObj.getPort(), AuthScope.ANY_REALM);
        client.getState().setCredentials(authScope, (Credentials)defaultcreds);
        ArrayList<String> authPrefs = new ArrayList<String>(1);
        authPrefs.add("Basic");
        client.getParams().setParameter("http.auth.scheme-priority", authPrefs);
        this.logger.fine("Client is set for BASIC AUTH Security.");
    }
}

