/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.client.executionunit.policy;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IFund;
import com.ibm.wssvt.acme.annuity.common.bean.IPolicy;
import com.ibm.wssvt.acme.annuity.common.bean.Identifiable;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.BasicExecutionUnitLibrarry;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.ExecutionUnitVerificationHelper;
import com.ibm.wssvt.acme.annuity.common.client.executionunit.policy.AbastractPolicyExecutionUnit;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterCommunicationException;
import com.ibm.wssvt.acme.common.executionunit.IExecutionUnit;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ReadPolicyFundsFromStateEU
extends AbastractPolicyExecutionUnit {
    private static final long serialVersionUID = -5232684206187027962L;
    private String useId = null;
    private int maxId = 0;
    private int startId = 0;
    private String stateName = "TX";
    private static final String USE_ID = "useId";
    private static final String MAX_ID = "maxId";
    private static final String START_ID_KEY = "startId";
    private static final String STATE_NAME = "stateName";
    AcmeLogger logger = null;

    public void execute() {
        String sHolderId = null;
        Identifiable policyHolder = null;
        this.setScenarioVariables();
        if (this.useId == null && this.maxId == 0) {
            this.logger.severe("Scenario parameter error: Either useId or maxId must be set > 0 for scenario: " + this.getDescription() + ": failed to execute");
            InvalidArgumentException e = new InvalidArgumentException("Scenario parameter error: Either useId or maxId must be set > 0 for scenario");
            this.getExecutionUnitEvent().addException((Exception)((Object)e));
            return;
        }
        this.logger.fine("After getting parameters, Begin execution");
        sHolderId = this.useId != null ? this.useId : Integer.toString(this.getRandomInteger(this.startId, this.maxId));
        int count = 0;
        while (policyHolder == null && count < 3) {
            sHolderId = this.useId != null ? this.useId : Integer.toString(this.getRandomInteger(this.startId, this.maxId));
            this.logger.fine("Looking up id: " + sHolderId);
            try {
                policyHolder = this.findAnnuityHolder(sHolderId);
            }
            catch (Exception e) {
                if (this.useId != null) {
                    this.logger.warning("failed to find Holder, Id = " + sHolderId + " Error: " + e);
                    this.getExecutionUnitEvent().addException(e);
                    return;
                }
                this.logger.warning("Exception while looking up Holder with, id: " + sHolderId + "Error: " + e);
                ++count;
            }
        }
        if (count >= 3) {
            this.logger.warning("failed to find Holder in " + count + " attempts, Id = " + sHolderId);
            EntityNotFoundException e = new EntityNotFoundException("failed to find Holder in " + count + " attempts, Id = " + sHolderId);
            this.getExecutionUnitEvent().addException((Exception)((Object)e));
            return;
        }
        this.logger.fine("Successful find of Holder, id = " + (String)policyHolder.getId() + " Call verify.");
        try {
            ExecutionUnitVerificationHelper.assertEquals((IExecutionUnit)this, (Comparable)((Object)sHolderId), (Comparable)policyHolder.getId(), "Returned Annuity Holder id is not equal to requested id", "Mismatch was found.");
        }
        catch (Exception e) {
            this.logger.severe("Failed on verify find holder. Error: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        List<IFund> stateFunds = null;
        if (this.stateName == null) {
            this.stateName = "TX";
        }
        try {
            this.logger.fine("Looking up Funds for holder ID: " + (String)policyHolder.getId() + " in state: " + this.stateName);
            policyHolder.setConfiguration(this.getConfiguration());
            stateFunds = this.getServerAdapter().findFundsFromState((IAnnuityHolder)policyHolder, this.stateName);
            this.logger.fine("Looked up Funds for holder ID: " + (String)policyHolder.getId() + " in state: " + this.stateName);
        }
        catch (Exception e) {
            this.logger.severe("Error Holder ID: " + (String)policyHolder.getId() + " failed finding funds for State: " + this.stateName + ". Exception: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        if (stateFunds != null) {
            Iterator<IFund> fundIt = stateFunds.iterator();
            this.logger.fine("The funds in State " + this.stateName + " are :");
            while (fundIt.hasNext()) {
                IFund fund = fundIt.next();
                this.logger.fine("Fund's name is " + fund.getFundName());
            }
        }
        this.logger.fine("Verify by querying policies for this holder");
        ArrayList<IFund> verifyList = new ArrayList<IFund>();
        List<IPolicy> policyListResults = null;
        try {
            this.logger.fine("Looking up policies for holder ID: " + (String)policyHolder.getId());
            policyHolder.setConfiguration(this.getConfiguration());
            policyListResults = this.getServerAdapter().findHolderPolicies((IAnnuityHolder)policyHolder);
        }
        catch (Exception e) {
            this.logger.severe("Error Holder ID: " + (String)policyHolder.getId() + " failed finding policies. Exception: " + e);
            this.getExecutionUnitEvent().addException(e);
            return;
        }
        if (policyListResults != null) {
            Iterator<IPolicy> it = policyListResults.iterator();
            IFund fundInState = null;
            while (it.hasNext()) {
                IPolicy pol = it.next();
                for (int i = 1; i <= pol.getFunds().size(); ++i) {
                    if (!pol.getFunds().get(new Integer(i)).getAddress().getState().equalsIgnoreCase(this.stateName)) continue;
                    fundInState = pol.getFunds().get(new Integer(i));
                    this.logger.fine("Found fund with name : " + pol.getFunds().get(new Integer(i)).getFundName() + " with address in " + this.stateName);
                    verifyList.add(fundInState);
                }
            }
            if (verifyList.isEmpty()) {
                this.logger.fine("There are no Funds which have address at State " + this.stateName);
            }
        } else {
            this.logger.warning("Holder ID: " + sHolderId + " has 0 policies");
            EntityNotFoundException e = new EntityNotFoundException("Holder ID: " + sHolderId + " has 0 policies");
            this.getExecutionUnitEvent().addException((Exception)((Object)e));
            return;
        }
        this.logger.fine("Comparing query results");
        try {
            ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, stateFunds, verifyList, "Results of queries do not match!", "State and Policy queries returned different results.");
            for (int i = 0; i < stateFunds.size(); ++i) {
                ExecutionUnitVerificationHelper.assertEqual((IExecutionUnit)this, stateFunds.get(i), (IFund)verifyList.get(i), "Results of queries do not match!", "Result from state query () is not equal to result from policy query ().");
            }
        }
        catch (Exception e) {
            this.logger.severe("Validation of fund lists from state failed for holder: " + sHolderId);
            this.getExecutionUnitEvent().addException(e);
        }
        this.logger.fine("Finished comparing results");
    }

    private void setScenarioVariables() {
        this.logger = this.getLogger(((Object)((Object)this)).getClass().getName());
        try {
            this.useId = (String)this.getConfiguration().getParameterValue((Object)USE_ID);
        }
        catch (Exception e) {
            this.logger.warning("useId parameter not in config file, use random");
        }
        try {
            this.maxId = this.getParameterValueInt(MAX_ID);
        }
        catch (Exception e) {
            this.logger.warning("maxId parameter not in config file, use default max");
        }
        try {
            this.stateName = (String)this.getConfiguration().getParameterValue((Object)STATE_NAME);
        }
        catch (Exception e) {
            this.logger.warning("State parameter not in config file, using state TX");
        }
        try {
            this.startId = this.getParameterValueInt(START_ID_KEY);
        }
        catch (Exception e) {
            this.logger.warning("the attribute:startId is missing for scenario: " + this.getDescription() + " .Setting the default to 1");
            this.startId = 1;
        }
    }

    private IAnnuityHolder findAnnuityHolder(String id) throws EntityNotFoundException, InvalidArgumentException, ServerAdapterCommunicationException, ServerInternalErrorException, RemoteException {
        IAnnuityHolder annuityHolder = null;
        annuityHolder = BasicExecutionUnitLibrarry.getAnnuityHolder(this.getAnnuityBeansFactory());
        annuityHolder.setId(id);
        annuityHolder.setConfiguration(this.getConfiguration());
        annuityHolder = this.getServerAdapter().findHolderById(annuityHolder);
        return annuityHolder;
    }
}

