/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.persistence;

import com.ibm.wssvt.acme.annuity.common.persistence.AnnuityPersistenceType;
import com.ibm.wssvt.acme.annuity.common.persistence.JPAPersistenceUnitName;
import com.ibm.wssvt.acme.common.bean.Configrable;

public class PersistenceUnitNameHelper {
    private static final String PERSISTENCE_UNIT_NAME = "persistenceUnitName";

    public static void setPersistenceUnitName(Configrable<String, String> configrable, JPAPersistenceUnitName persistenceUnitName) {
        if (configrable == null) {
            return;
        }
        String currentPUName = (String)configrable.getConfiguration().getParameterValue((Object)PERSISTENCE_UNIT_NAME);
        if (currentPUName != null && currentPUName.trim().length() > 0) {
            return;
        }
        if (persistenceUnitName == null) {
            String beansFactoryName = (String)configrable.getConfiguration().getParameterValue((Object)"internal.beansFactoryClass");
            String persistenceType = (String)configrable.getConfiguration().getParameterValue((Object)"persistenceType");
            if (beansFactoryName == null || persistenceType == null) {
                configrable.getConfiguration().addParameter((Object)PERSISTENCE_UNIT_NAME, (Object)"");
                return;
            }
            if (AnnuityPersistenceType.JPA_SA.toString().equals(persistenceType)) {
                if (beansFactoryName.contains("JAXBJPABeansFactory")) {
                    configrable.getConfiguration().addParameter((Object)PERSISTENCE_UNIT_NAME, (Object)JPAPersistenceUnitName.AnnuitySAJAXBJPA.toString());
                } else if (beansFactoryName.contains("JPABeansFactory")) {
                    configrable.getConfiguration().addParameter((Object)PERSISTENCE_UNIT_NAME, (Object)JPAPersistenceUnitName.AnnuitySAJPAOnly.toString());
                } else if (beansFactoryName.contains("JavaBeansFactory")) {
                    configrable.getConfiguration().addParameter((Object)PERSISTENCE_UNIT_NAME, (Object)"");
                }
            } else if (AnnuityPersistenceType.JPA_EJB.toString().equals(persistenceType)) {
                if (beansFactoryName.contains("JAXBJPABeansFactory")) {
                    configrable.getConfiguration().addParameter((Object)PERSISTENCE_UNIT_NAME, (Object)JPAPersistenceUnitName.AnnuityDSJAXBJPA.toString());
                } else if (beansFactoryName.contains("JPABeansFactory")) {
                    configrable.getConfiguration().addParameter((Object)PERSISTENCE_UNIT_NAME, (Object)JPAPersistenceUnitName.AnnuityDSJPAOnly.toString());
                } else if (beansFactoryName.contains("JavaBeansFactory")) {
                    configrable.getConfiguration().addParameter((Object)PERSISTENCE_UNIT_NAME, (Object)"");
                }
            }
        } else {
            configrable.getConfiguration().addParameter((Object)PERSISTENCE_UNIT_NAME, (Object)persistenceUnitName.toString());
        }
    }
}

