/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.persistence.impl.jpasa;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPersisteble;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.AnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.annuity.common.persistence.AnnuityPersistence;
import com.ibm.wssvt.acme.annuity.common.persistence.JPAPersistenceUnitName;
import com.ibm.wssvt.acme.annuity.common.persistence.PersistenceUnitNameHelper;
import com.ibm.wssvt.acme.annuity.common.persistence.impl.jpasa.BasicPersistenceJPASAImpl;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import com.ibm.wssvt.acme.common.log.AcmeLogger;
import java.util.List;
import java.util.logging.Level;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceException;
import javax.persistence.Query;

public class PersistenceJPASAImpl
extends BasicPersistenceJPASAImpl<String>
implements AnnuityPersistence<IPersisteble<String>, String, String> {
    private AcmeLogger logger;

    public PersistenceJPASAImpl(AcmeLogger logger) {
        super(logger);
        this.logger = logger;
    }

    @Override
    public List<IAnnuity> getHolderAnnuities(IAnnuityHolder holder) throws InvalidArgumentException, ServerPersistenceModuleException {
        this.logger.fine("getHolderAnnuities");
        if (holder == null) {
            this.logger.fine("Invalid annuity holder - its null, returning Exception" + this.logger.getAllLogs());
            throw new InvalidArgumentException("Invalid Annuity Holder argument");
        }
        EntityManagerFactory factory = null;
        EntityManager em = null;
        try {
            List l;
            factory = super.getEntityManagerFactory(holder);
            em = factory.createEntityManager();
            Query query = em.createNamedQuery("GetHolderAnnuities");
            query.setParameter("holderId", holder.getId());
            List list = l = query.getResultList();
            return list;
        }
        catch (PersistenceException e) {
            String msg = "Persistence Module returned an error - see error message for details. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.WARNING, msg, (Throwable)e);
            throw new ServerPersistenceModuleException(msg);
        }
        catch (Throwable t) {
            String msg = "Encountered a non-declered exception. Error: " + ExceptionFormatter.deepFormatToString((Throwable)t) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, t);
            throw new ServerPersistenceModuleException(msg);
        }
        finally {
            this.logger.fine("- close em");
            if (em != null) {
                em.close();
            }
        }
    }

    @Override
    public IAnnuityHolder getAnnuityHolder(IAnnuity annuity) throws EntityNotFoundException, ServerPersistenceModuleException, InvalidArgumentException {
        this.logger.fine("getAnnuityHolder");
        if (annuity == null) {
            this.logger.fine("Invalid annuity - its null, returning Exception" + this.logger.getAllLogs());
            throw new InvalidArgumentException("Invalid Annuity argument");
        }
        try {
            PersistenceUnitNameHelper.setPersistenceUnitName(annuity, null);
            String persistenceUnitName = (String)annuity.getConfiguration().getParameterValue((Object)"persistenceUnitName");
            this.logger.fine("persistenceUnitName: " + persistenceUnitName);
            if (JPAPersistenceUnitName.AnnuitySAJAXBJPA.toString().equals(persistenceUnitName)) {
                return this.readObject(AnnuityHolder.class, (Object)annuity.getAnnuityHolderId(), annuity);
            }
            if (JPAPersistenceUnitName.AnnuitySAJPAOnly.toString().equals(persistenceUnitName)) {
                return this.readObject(com.ibm.wssvt.acme.annuity.common.bean.jpa.AnnuityHolder.class, (Object)annuity.getAnnuityHolderId(), annuity);
            }
            throw new InvalidArgumentException("The parameter persistenceUnitName was not set.  Please provide a valid value! Failed to getAnnuityHolder" + this.logger.getAllLogs());
        }
        catch (Throwable e) {
            String msg = "Encountered a non-declered exception. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, e);
            throw new ServerPersistenceModuleException(msg);
        }
    }

    @Override
    public List<IAnnuity> getPayorAnnuities(IPayor payor) throws InvalidArgumentException, ServerPersistenceModuleException {
        this.logger.fine("getPayorAnnuities");
        if (payor == null) {
            this.logger.fine("Invalid payor - its null, returning Exception" + this.logger.getAllLogs());
            throw new InvalidArgumentException("Invalid Payor argument -its null.");
        }
        EntityManager em = null;
        try {
            EntityManagerFactory emf = super.getEntityManagerFactory(payor);
            em = emf.createEntityManager();
            Query query = em.createNamedQuery("GetPayorAnnuities");
            query.setParameter(1, payor.getId());
            List annuities = query.getResultList();
            for (IAnnuity annuity : annuities) {
                annuity.getPayouts();
            }
            List list = annuities;
            return list;
        }
        catch (PersistenceException e) {
            String msg = "Persistence Module returned an error - see error message for details. Error: " + ExceptionFormatter.deepFormatToString((Throwable)e) + this.logger.getAllLogs();
            this.logger.log(Level.WARNING, msg, (Throwable)e);
            throw new ServerPersistenceModuleException(msg);
        }
        catch (Throwable t) {
            String msg = "Encountered a non-declered exception. Error: " + ExceptionFormatter.deepFormatToString((Throwable)t) + this.logger.getAllLogs();
            this.logger.log(Level.SEVERE, msg, t);
            throw new ServerPersistenceModuleException(msg);
        }
        finally {
            this.logger.fine("- close em");
            if (em != null) {
                em.close();
            }
        }
    }
}

