/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.annuity.common.servicelookup.ejb3jaxws;

import com.ibm.wssvt.acme.annuity.common.bean.IAnnuity;
import com.ibm.wssvt.acme.annuity.common.bean.IAnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.IContact;
import com.ibm.wssvt.acme.annuity.common.bean.IPayor;
import com.ibm.wssvt.acme.annuity.common.bean.IPayout;
import com.ibm.wssvt.acme.annuity.common.bean.IRider;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.AnnuityHolder;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.AnnuityValueObject;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.Contact;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.Payor;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.PayoutValueObject;
import com.ibm.wssvt.acme.annuity.common.bean.jaxbjpa.Rider;
import com.ibm.wssvt.acme.annuity.common.business.IAnnuityService;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.ejb3impl.AnnuityMgmtSvcEJB30JAXWS;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.ejb3impl.EntityAlreadyExistsException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.ejb3impl.EntityNotFoundException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.ejb3impl.InvalidArgumentException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.ejb3impl.ServerBusinessModuleException_Exception;
import com.ibm.wssvt.acme.annuity.common.client.jaxws.ejb3impl.ServerPersistenceModuleException_Exception;
import com.ibm.wssvt.acme.annuity.common.exception.EntityAlreadyExistsException;
import com.ibm.wssvt.acme.annuity.common.exception.EntityNotFoundException;
import com.ibm.wssvt.acme.annuity.common.exception.InvalidArgumentException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerBusinessModuleException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerInternalErrorException;
import com.ibm.wssvt.acme.annuity.common.exception.ServerPersistenceModuleException;
import com.ibm.wssvt.acme.common.exception.ExceptionFormatter;
import java.util.ArrayList;
import java.util.List;

public class EJB3JAXWSJAXWSSyncServiceProxy
implements IAnnuityService {
    private AnnuityMgmtSvcEJB30JAXWS webService;

    public EJB3JAXWSJAXWSSyncServiceProxy(AnnuityMgmtSvcEJB30JAXWS webServiceInterface) {
        this.webService = webServiceInterface;
    }

    private void processCommonExceptions(Exception e) throws InvalidArgumentException, ServerBusinessModuleException, ServerPersistenceModuleException {
        if (e instanceof InvalidArgumentException_Exception) {
            throw new InvalidArgumentException(e);
        }
        if (e instanceof ServerBusinessModuleException_Exception) {
            throw new ServerBusinessModuleException(e);
        }
        if (e instanceof ServerPersistenceModuleException_Exception) {
            throw new ServerPersistenceModuleException(e);
        }
        e.printStackTrace();
        throw new RuntimeException("Unexpected error. Erros is: " + ExceptionFormatter.deepFormatToString((Throwable)e), e);
    }

    @Override
    public IAnnuity createAnnuity(IAnnuity ann) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(ann);
            result = this.webService.createAnnuity(annuityValueObject);
            annuityValueObject.getAnnuity();
        }
        catch (EntityAlreadyExistsException_Exception e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : result.getAnnuity();
    }

    @Override
    public IAnnuity findAnnuityById(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(annuity);
            result = this.webService.findAnnuityById(annuityValueObject);
            annuityValueObject.getAnnuity();
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : result.getAnnuity();
    }

    @Override
    public IAnnuityHolder findAnnuityHolder(IAnnuity annuity) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(annuity);
            result = this.webService.findAnnuityHolder(annuityValueObject);
            annuityValueObject.getAnnuity();
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result;
    }

    @Override
    public IContact findContactById(IContact contact) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.findContactById((Contact)contact);
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.processCommonExceptions(e);
        }
        return result;
    }

    @Override
    public List<IAnnuity> findHolderAnnuities(IAnnuityHolder annuityHolder) throws ServerInternalErrorException, InvalidArgumentException {
        ArrayList<IAnnuity> result = new ArrayList<IAnnuity>();
        List<Object> tempList = new ArrayList();
        try {
            tempList = this.webService.findHolderAnnuities((AnnuityHolder)annuityHolder);
            for (AnnuityValueObject annuityValueObject : tempList) {
                result.add(annuityValueObject.getAnnuity());
            }
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result;
    }

    @Override
    public IAnnuityHolder findHolderById(IAnnuityHolder annuityHolder) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.findHolderById((AnnuityHolder)annuityHolder);
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result;
    }

    @Override
    public List<IAnnuity> findPayorAnnuities(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        ArrayList<IAnnuity> result = null;
        try {
            List<AnnuityValueObject> tempList = this.webService.findPayorAnnuities((Payor)payor);
            if (tempList != null) {
                result = new ArrayList<IAnnuity>();
                for (AnnuityValueObject object : tempList) {
                    result.add(object.getAnnuity());
                }
            }
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result;
    }

    @Override
    public IPayor findPayorById(IPayor payor) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.findPayorById((Payor)payor);
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result;
    }

    @Override
    public IPayout findPayoutById(IPayout payout) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(payout);
            result = this.webService.findPayoutById(in);
            in.getPayout();
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : result.getPayout();
    }

    @Override
    public IRider findRiderById(IRider rider) throws EntityNotFoundException, ServerInternalErrorException, InvalidArgumentException {
        Rider result = null;
        try {
            result = this.webService.findRiderById((Rider)rider);
        }
        catch (EntityNotFoundException_Exception e) {
            throw new EntityNotFoundException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result;
    }

    @Override
    public IAnnuityHolder createAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.createAnnuityHolder((AnnuityHolder)annHolder);
        }
        catch (EntityAlreadyExistsException_Exception e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result;
    }

    @Override
    public IContact createContact(IContact contact) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.createContact((Contact)contact);
        }
        catch (EntityAlreadyExistsException_Exception e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result;
    }

    @Override
    public IPayor createPayor(IPayor payor) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.createPayor((Payor)payor);
        }
        catch (EntityAlreadyExistsException_Exception e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result;
    }

    @Override
    public IPayout createPayout(IPayout payout) throws ServerInternalErrorException, EntityAlreadyExistsException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(payout);
            result = this.webService.createPayout(in);
            in.getPayout();
        }
        catch (EntityAlreadyExistsException_Exception e) {
            throw new EntityAlreadyExistsException(e);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : result.getPayout();
    }

    @Override
    public void deleteAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(annuity);
            this.webService.deleteAnnuity(annuityValueObject);
            annuityValueObject.getAnnuity();
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deleteAnnuityHolder((AnnuityHolder)annHolder);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deleteContact((Contact)contact);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deletePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deletePayor((Payor)payor);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deletePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(payout);
            this.webService.deletePayout(in);
            in.getPayout();
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public void deleteRider(IRider rider) throws ServerInternalErrorException, InvalidArgumentException {
        try {
            this.webService.deleteRider((Rider)rider);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
    }

    @Override
    public IAnnuity updateAnnuity(IAnnuity annuity) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityValueObject result = null;
        try {
            AnnuityValueObject annuityValueObject = new AnnuityValueObject();
            annuityValueObject.setAnnuity(annuity);
            result = this.webService.updateAnnuity(annuityValueObject);
            annuityValueObject.getAnnuity();
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : result.getAnnuity();
    }

    @Override
    public IAnnuityHolder updateAnnuityHolder(IAnnuityHolder annHolder) throws ServerInternalErrorException, InvalidArgumentException {
        AnnuityHolder result = null;
        try {
            result = this.webService.updateAnnuityHolder((AnnuityHolder)annHolder);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result;
    }

    @Override
    public IContact updateContact(IContact contact) throws ServerInternalErrorException, InvalidArgumentException {
        Contact result = null;
        try {
            result = this.webService.updateContact((Contact)contact);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result;
    }

    @Override
    public IPayor updatePayor(IPayor payor) throws ServerInternalErrorException, InvalidArgumentException {
        Payor result = null;
        try {
            result = this.webService.updatePayor((Payor)payor);
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result;
    }

    @Override
    public IPayout updatePayout(IPayout payout) throws ServerInternalErrorException, InvalidArgumentException {
        PayoutValueObject result = null;
        try {
            PayoutValueObject in = new PayoutValueObject();
            in.setPayout(payout);
            result = this.webService.updatePayout(in);
            in.getPayout();
        }
        catch (Exception e) {
            this.processCommonExceptions(e);
        }
        return result == null ? null : result.getPayout();
    }
}

