/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.client.ui.gui;

import com.ibm.wssvt.acme.common.client.ui.gui.AcmeGUI;
import com.ibm.wssvt.acme.common.client.ui.gui.GuiUtils;
import com.ibm.wssvt.acme.common.client.ui.gui.model.AdapterConfigurationDecorator;
import com.ibm.wssvt.acme.common.client.ui.gui.model.ExceptionHandlerConfigurationDecorator;
import com.ibm.wssvt.acme.common.client.ui.gui.model.ExecutionUnitConfigurationDecorator;
import com.ibm.wssvt.acme.common.client.ui.gui.model.ParametarizableCopier;
import com.ibm.wssvt.acme.common.envconfig.AcmeEnvConfigLoader;
import com.ibm.wssvt.acme.common.envconfig.AdapterConfiguration;
import com.ibm.wssvt.acme.common.envconfig.EnvConfigStringParameterizable;
import com.ibm.wssvt.acme.common.envconfig.ExceptionHandlerConfiguration;
import com.ibm.wssvt.acme.common.envconfig.ExecutionUnitConfiguration;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.bind.JAXBException;

public class ActionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JButton btnSaveConfigFile = null;
    private JLabel jLabel8 = null;
    private JTextField txtFileName = null;
    private JLabel lblActionsMessage = null;

    public ActionsPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setName("Actions");
        this.setSize(1076, 669);
        this.lblActionsMessage = new JLabel();
        this.lblActionsMessage.setBounds(new Rectangle(36, 107, 596, 16));
        this.lblActionsMessage.setForeground(new Color(255, 51, 51));
        this.lblActionsMessage.setText("");
        this.jLabel8 = new JLabel();
        this.jLabel8.setBounds(new Rectangle(36, 30, 75, 16));
        this.jLabel8.setText("File Name:");
        this.setLayout(null);
        this.add((Component)this.getBtnSaveConfigFile(), null);
        this.add((Component)this.jLabel8, null);
        this.add((Component)this.getTxtFileName(), null);
        this.add((Component)this.lblActionsMessage, null);
    }

    private JTextField getTxtFileName() {
        if (this.txtFileName == null) {
            this.txtFileName = new JTextField();
            this.txtFileName.setBounds(new Rectangle(123, 28, 338, 20));
            this.txtFileName.setEditable(false);
        }
        return this.txtFileName;
    }

    private JButton getBtnSaveConfigFile() {
        if (this.btnSaveConfigFile == null) {
            this.btnSaveConfigFile = new JButton();
            this.btnSaveConfigFile.setBounds(new Rectangle(475, 26, 157, 39));
            this.btnSaveConfigFile.setText("Save");
            this.btnSaveConfigFile.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (AcmeGUI.getSelectedAdaptersDataModel().isEmpty()) {
                        ActionsPanel.this.lblActionsMessage.setText("No Services/Adapters are configured.  Did NOT save!");
                        ActionsPanel.this.lblActionsMessage.setForeground(Color.RED);
                        return;
                    }
                    if (AcmeGUI.getConfiguredExecutionUnitsDataModel().isEmpty()) {
                        ActionsPanel.this.lblActionsMessage.setText("No Executioin Units are configured.  Did NOT save!");
                        ActionsPanel.this.lblActionsMessage.setForeground(Color.RED);
                        return;
                    }
                    ActionsPanel.this.lblActionsMessage.setText("");
                    File file = GuiUtils.getSaveFile();
                    if (file == null) {
                        ActionsPanel.this.lblActionsMessage.setText("user cancel!");
                        ActionsPanel.this.lblActionsMessage.setForeground(Color.BLUE);
                        return;
                    }
                    ActionsPanel.this.txtFileName.setText(file.getAbsolutePath());
                    ActionsPanel.this.lblActionsMessage.setText("");
                    EnvConfigStringParameterizable gparams = new EnvConfigStringParameterizable();
                    ArrayList<AdapterConfiguration> adapters = new ArrayList<AdapterConfiguration>();
                    ArrayList<ExecutionUnitConfiguration> executionUnits = new ArrayList<ExecutionUnitConfiguration>();
                    ArrayList<ExceptionHandlerConfiguration> exceptionHandlers = new ArrayList<ExceptionHandlerConfiguration>();
                    AcmeGUI.getConfiguredDocument().setGlobalConfigurationParams(gparams);
                    AcmeGUI.getConfiguredDocument().setClientConfiguration(AcmeGUI.getConfiguredClientConfig());
                    AcmeGUI.getConfiguredDocument().setAdapterConfigurationList(adapters);
                    AcmeGUI.getConfiguredDocument().setExecutionUnitConfigurationList(executionUnits);
                    AcmeGUI.getConfiguredDocument().setExceptionHandlerConfigurationList(exceptionHandlers);
                    gparams.addAllParams(AcmeGUI.getConfiguredGlobalParams().getConfiguration().getParameters());
                    for (AdapterConfigurationDecorator selectedAdapter : AcmeGUI.getSelectedAdaptersDataModel()) {
                        AdapterConfiguration ac = new AdapterConfiguration();
                        ac.setClassName(selectedAdapter.getClassName());
                        ac.setId(selectedAdapter.getId());
                        ac.setConfiguration(ParametarizableCopier.getCopy(selectedAdapter.getConfiguration(), new EnvConfigStringParameterizable()));
                        adapters.add(ac);
                    }
                    for (ExecutionUnitConfigurationDecorator selectedEU : AcmeGUI.getConfiguredExecutionUnitsDataModel()) {
                        ExecutionUnitConfiguration eu = new ExecutionUnitConfiguration();
                        eu.setAdapterId(selectedEU.getAdapterId());
                        eu.setBeansFactoryClass(selectedEU.getBeansFactoryClass());
                        eu.setClassName(selectedEU.getClassName());
                        eu.setDescription(selectedEU.getDescription());
                        eu.setRepeat(selectedEU.getRepeat());
                        eu.setConfiguration(ParametarizableCopier.getCopy(selectedEU.getConfiguration(), new EnvConfigStringParameterizable()));
                        executionUnits.add(eu);
                    }
                    for (ExceptionHandlerConfigurationDecorator selectedEH : AcmeGUI.getConfiguredExceptionHandlersDataModel()) {
                        ExceptionHandlerConfiguration eh = new ExceptionHandlerConfiguration();
                        eh.setExceptionClassName(selectedEH.getExceptionClassName());
                        eh.setHandlerClassName(selectedEH.getHandlerClassName());
                        eh.setConfiguration(ParametarizableCopier.getCopy(selectedEH.getConfiguration(), new EnvConfigStringParameterizable()));
                        exceptionHandlers.add(eh);
                    }
                    try {
                        AcmeEnvConfigLoader.save(AcmeGUI.getConfiguredDocument(), ActionsPanel.this.txtFileName.getText());
                        ActionsPanel.this.lblActionsMessage.setText("Saved OK. You may now use this config file with the Annuity Clients.");
                        ActionsPanel.this.lblActionsMessage.setForeground(Color.BLACK);
                    }
                    catch (FileNotFoundException e1) {
                        e1.printStackTrace();
                        ActionsPanel.this.lblActionsMessage.setText("error: " + e1);
                        ActionsPanel.this.lblActionsMessage.setForeground(Color.RED);
                    }
                    catch (JAXBException e1) {
                        e1.printStackTrace();
                        ActionsPanel.this.lblActionsMessage.setText("error: " + (Object)((Object)e1));
                        ActionsPanel.this.lblActionsMessage.setForeground(Color.RED);
                    }
                }
            });
        }
        return this.btnSaveConfigFile;
    }
}

