/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.adapter;

import com.ibm.wssvt.acme.common.adapter.IServerAdapter;
import com.ibm.wssvt.acme.common.adapter.IServerAdapterEvent;
import com.ibm.wssvt.acme.common.adapter.IServerAdapterEventListener;
import com.ibm.wssvt.acme.common.adapter.ServerAdapterEvent;
import com.ibm.wssvt.acme.common.bean.Parameterizable;
import com.ibm.wssvt.acme.common.bean.StringParameterizable;
import com.ibm.wssvt.acme.common.util.ClientContext;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractServerAdapter
implements IServerAdapter {
    private static final long serialVersionUID = 5500690194439215059L;
    private Parameterizable<String, String> adapterConfig = new StringParameterizable();
    private ClientContext clientContext;
    private String id;
    private List<IServerAdapterEventListener> listeners = new ArrayList<IServerAdapterEventListener>();
    private IServerAdapterEvent serverAdapterEvent = new ServerAdapterEvent();

    public AbstractServerAdapter() {
        this.serverAdapterEvent.setServerAdapter(this);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public synchronized void fireToListeners() {
        for (IServerAdapterEventListener listener : this.listeners) {
            listener.processServerAdapterEvent(this.serverAdapterEvent);
        }
        this.serverAdapterEvent.clearAll();
    }

    @Override
    public synchronized void clearListeners() {
        this.listeners.clear();
    }

    public synchronized IServerAdapterEvent getServerAdapterEvent() {
        return this.serverAdapterEvent;
    }

    public synchronized void setServerAdapterEvent(IServerAdapterEvent event) {
        this.serverAdapterEvent = event;
    }

    @Override
    public synchronized void clearEvents() {
        this.serverAdapterEvent.clearAll();
    }

    @Override
    public synchronized void addEventListener(IServerAdapterEventListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public synchronized boolean removeEventListener(IServerAdapterEventListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public synchronized Parameterizable<String, String> getConfiguration() {
        return this.adapterConfig;
    }

    @Override
    public void setConfiguration(Parameterizable<String, String> config) {
        this.adapterConfig = config;
    }

    @Override
    public synchronized ClientContext getClientContext() {
        return this.clientContext;
    }

    @Override
    public synchronized void setClientContext(ClientContext clientContext) {
        this.clientContext = clientContext;
    }
}

