/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wssvt.acme.common.client.ui.gui;

import com.ibm.wssvt.acme.common.bean.Configrable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class PropertiesDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private Map<String, String> props = new HashMap<String, String>();
    private JScrollPane jScrollPane = null;
    private JPanel jPanel = null;
    private Configrable<String, String> configrable;

    public Configrable<String, String> getConfigrable() {
        return this.configrable;
    }

    public PropertiesDialog(Configrable<String, String> configrable) {
        this.initialize();
        this.configrable = configrable;
        this.props = configrable.getConfiguration().getParameters();
        this.populate();
    }

    private void populate() {
        int x = 0;
        int y = 0;
        this.jPanel.removeAll();
        JLabel propNameLabel = new JLabel();
        propNameLabel.setText("Property Name");
        GridBagConstraints propNameConst = new GridBagConstraints();
        propNameConst.fill = 3;
        propNameConst.gridx = x++;
        propNameConst.gridy = y;
        propNameConst.weightx = 1.0;
        this.jPanel.add((Component)propNameLabel, propNameConst);
        JLabel propValueLabel = new JLabel();
        propValueLabel.setText("Property Value");
        GridBagConstraints propValueConst = new GridBagConstraints();
        propValueConst.fill = 3;
        propValueConst.gridx = x;
        propValueConst.gridy = y++;
        propValueConst.weightx = 1.0;
        this.jPanel.add((Component)propValueLabel, propValueConst);
        x = 0;
        for (String key : this.props.keySet()) {
            JLabel lbl = new JLabel();
            lbl.setText(key);
            lbl.setName(key);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 3;
            gridBagConstraints.gridx = x++;
            gridBagConstraints.gridy = y;
            gridBagConstraints.weightx = 1.0;
            this.jPanel.add((Component)lbl, gridBagConstraints);
            JTextField txt = new JTextField();
            txt.setText(this.props.get(key));
            txt.setName(key);
            txt.setColumns(35);
            GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.fill = 3;
            gridBagConstraints1.gridx = x++;
            gridBagConstraints1.gridy = y;
            gridBagConstraints1.weightx = 1.0;
            this.jPanel.add((Component)txt, gridBagConstraints1);
            JButton btnDelete = new JButton();
            btnDelete.setText("Delete");
            btnDelete.setName(key);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 3;
            gridBagConstraints2.gridx = x;
            gridBagConstraints2.gridy = y++;
            gridBagConstraints2.weightx = 1.0;
            this.jPanel.add((Component)btnDelete, gridBagConstraints2);
            btnDelete.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String keyStr = ((JButton)e.getSource()).getName();
                    PropertiesDialog.this.props.remove(keyStr);
                    PropertiesDialog.this.populate();
                    System.out.println(PropertiesDialog.this.props);
                }
            });
            x = 0;
        }
        x = 0;
        JButton btnDone = new JButton();
        btnDone.setText("Done");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = x++;
        gridBagConstraints.gridy = y;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        this.jPanel.add((Component)btnDone, gridBagConstraints);
        btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component[] comps2 = PropertiesDialog.this.jPanel.getComponents();
                for (int i = 0; i < comps2.length; ++i) {
                    if (!(comps2[i] instanceof JTextField)) continue;
                    JTextField txt = (JTextField)comps2[i];
                    String key = txt.getName();
                    String value = txt.getText();
                    PropertiesDialog.this.props.put(key, value);
                }
                PropertiesDialog.this.setVisible(false);
            }
        });
        JButton btnAdd = new JButton();
        btnAdd.setText("Add New Property");
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 3;
        gridBagConstraints2.gridx = x;
        gridBagConstraints2.gridy = y;
        this.jPanel.add((Component)btnAdd, gridBagConstraints2);
        btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String key = JOptionPane.showInputDialog(null, "What is the property NAME", "Enter the property NAME", 3);
                String value = "";
                if (key == null || key.trim().length() <= 0) {
                    JOptionPane.showMessageDialog(null, "Property Name is EMPTY. Nothing will be added ");
                    return;
                }
                value = JOptionPane.showInputDialog(null, "What is the property VALUE", "Enter the property VALUE", 3);
                PropertiesDialog.this.props.put(key, value);
                PropertiesDialog.this.populate();
            }
        });
        Dimension d = new Dimension(700, 350);
        this.setSize(d);
        this.jPanel.updateUI();
    }

    private void initialize() {
        this.setSize(500, 200);
        this.setTitle("Maintain Object Properties");
        this.setContentPane(this.getJContentPane());
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridx = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getJScrollPane(), gridBagConstraints);
        }
        return this.jContentPane;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getJPanel());
        }
        return this.jScrollPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
        }
        return this.jPanel;
    }
}

